/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.TagInfo;

public class PrintableString
extends BaseASN1Object {
    private String value;

    public PrintableString(String name) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(19);
        this.setTagNumber(19);
    }

    public PrintableString(String name, Object value) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(19);
        this.setTagNumber(19);
        this.setValue(value);
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.value = (String)value;
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void decode(byte[] data) throws DecodeException {
        TagInfo tagInfo = this.getTagInfo(data, 0);
        if (this.tagClass != tagInfo.tagClass) {
            throw new DecodeException();
        }
        if (this.tagMethod != tagInfo.tagMethod) {
            throw new DecodeException();
        }
        if (this.tagNumber != tagInfo.tagNumber) {
            throw new DecodeException();
        }
        if (this.tagMethod != 1 && this.type != tagInfo.type) {
            throw new DecodeException();
        }
        if (tagInfo.contentIndex + tagInfo.contentLength != data.length) {
            throw new DecodeException();
        }
        this.setType(19);
        this.value = new String(data, tagInfo.contentIndex, tagInfo.contentLength);
    }

    protected byte[] getContentEncoding() {
        if (this.value != null) {
            return this.value.getBytes();
        }
        return null;
    }

    public String toString() {
        if (this.value != null) {
            return this.value;
        }
        return new String(super.toString());
    }

    public static void main(String[] args) throws DecodeException {
        PrintableString i = new PrintableString("TestPrintableString", "Test string");
        System.out.println(i.toString());
        byte[] a = i.getEncoded();
        for (int z = 0; z < a.length; ++z) {
            System.out.println(Integer.toString(a[z] & 0xFF, 16));
        }
    }
}

