/*
 * Decompiled with CFR 0.152.
 */
package sune.security.pkcs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import sune.security.pkcs.PKCS10Attribute;
import sune.security.util.DerEncoder;
import sune.security.util.DerInputStream;
import sune.security.util.DerOutputStream;
import sune.security.util.DerValue;

public class PKCS10Attributes
implements DerEncoder {
    private Hashtable<String, PKCS10Attribute> map = new Hashtable(3);

    public PKCS10Attributes() {
    }

    public PKCS10Attributes(PKCS10Attribute[] attrs) {
        for (int i = 0; i < attrs.length; ++i) {
            this.map.put(attrs[i].getAttributeId().toString(), attrs[i]);
        }
    }

    public PKCS10Attributes(DerInputStream in) throws IOException {
        DerValue[] attrs = in.getSet(3, true);
        if (attrs == null) {
            throw new IOException("Illegal encoding of attributes");
        }
        for (int i = 0; i < attrs.length; ++i) {
            PKCS10Attribute attr = new PKCS10Attribute(attrs[i]);
            this.map.put(attr.getAttributeId().toString(), attr);
        }
    }

    public void encode(OutputStream out) throws IOException {
        this.derEncode(out);
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        Collection<PKCS10Attribute> allAttrs = this.map.values();
        DerEncoder[] attribs = allAttrs.toArray(new PKCS10Attribute[this.map.size()]);
        DerOutputStream attrOut = new DerOutputStream();
        attrOut.putOrderedSetOf(DerValue.createTag((byte)-128, true, (byte)0), attribs);
        out.write(attrOut.toByteArray());
    }

    public void setAttribute(String name, Object obj) {
        if (obj instanceof PKCS10Attribute) {
            this.map.put(name, (PKCS10Attribute)obj);
        }
    }

    public Object getAttribute(String name) {
        return this.map.get(name);
    }

    public void deleteAttribute(String name) {
        this.map.remove(name);
    }

    public Enumeration<PKCS10Attribute> getElements() {
        return this.map.elements();
    }

    public Collection<PKCS10Attribute> getAttributes() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PKCS10Attributes)) {
            return false;
        }
        Collection<PKCS10Attribute> othersAttribs = ((PKCS10Attributes)other).getAttributes();
        PKCS10Attribute[] attrs = othersAttribs.toArray(new PKCS10Attribute[othersAttribs.size()]);
        int len = attrs.length;
        if (len != this.map.size()) {
            return false;
        }
        String key = null;
        for (int i = 0; i < len; ++i) {
            PKCS10Attribute otherAttr = attrs[i];
            key = otherAttr.getAttributeId().toString();
            if (key == null) {
                return false;
            }
            PKCS10Attribute thisAttr = this.map.get(key);
            if (thisAttr == null) {
                return false;
            }
            if (thisAttr.equals(otherAttr)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        String s = this.map.size() + "\n" + this.map.toString();
        return s;
    }
}

