/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Object;
import com.turktrust.asn1.BitString;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.Sequence;
import com.turktrust.asn1.SequenceOf;
import com.turktrust.x509.DistributionPointName;
import com.turktrust.x509.GeneralName;
import java.util.Vector;

public class DistributionPoint
extends Sequence {
    private DistributionPointName dpn = new DistributionPointName("dpn");
    private BitString rflags = new BitString("reason_flags");
    private SequenceOf crlIssuer = new SequenceOf("crl_issuer", new GeneralName());

    public DistributionPoint() {
        super("default_dp");
        this.setUpElements();
    }

    public DistributionPoint(String name) {
        super(name);
        this.setUpElements();
    }

    private void setUpElements() {
        super.addElement(this.dpn);
        this.dpn.setOptional(true);
        this.dpn.setTaggingMethod(2);
        this.dpn.setTagClass((byte)-128);
        this.dpn.setTagNumber(0);
        this.dpn.setInternalTagMethod(1);
        super.addElement(this.rflags);
        this.rflags.setOptional(true);
        this.rflags.setTaggingMethod(2);
        this.rflags.setTagClass((byte)-128);
        this.rflags.setTagNumber(1);
        super.addElement(this.crlIssuer);
        this.crlIssuer.setOptional(true);
        this.crlIssuer.setTaggingMethod(2);
        this.crlIssuer.setTagClass((byte)-128);
        this.crlIssuer.setTagNumber(2);
    }

    public void setDistributionPointName(DistributionPointName dpn_given) {
        this.dpn = dpn_given;
        super.clearElements();
        this.setUpElements();
    }

    public void setReasonFlags(BitString rflags_given) {
        this.rflags = rflags_given;
        super.clearElements();
        this.setUpElements();
    }

    public void setCRLIssuer(SequenceOf crlIssuer_given) {
        this.crlIssuer = crlIssuer_given;
        super.clearElements();
        this.setUpElements();
    }

    public DistributionPointName getDistributionPointName() {
        return this.dpn;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }

    public void decode(byte[] input) throws DecodeException {
        super.decode(input);
        Vector elems = (Vector)super.getValue();
        for (int i = 0; i < elems.size(); ++i) {
            ASN1Object el = (ASN1Object)elems.elementAt(i);
            if (el.getTagNumber() == 0) {
                this.setDistributionPointName((DistributionPointName)el);
                continue;
            }
            if (el.getTagNumber() == 1) {
                this.setReasonFlags((BitString)el);
                continue;
            }
            if (el.getTagNumber() != 2) continue;
            this.setCRLIssuer((SequenceOf)el);
        }
        this.commitElementUpdate();
    }
}

