/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp;

import java.security.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.Constants;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EBasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtendedKeyUsage;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectPublicKeyInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.CheckStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.PathValidationResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseStatusInfo;
import tr.gov.tubitak.uekae.esya.api.common.bundle.cert.CertI18n;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.SignUtil;

public class OCSPSignatureChecker
extends OCSPResponseChecker {
    private static final Logger d;
    private static final String[] e;
    private static final String[] f;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected PathValidationResult _check(EOCSPResponse aOCSPCevabi, OCSPResponseStatusInfo aOCSPCevapBilgisi) {
        PathValidationResult pathValidationResult;
        boolean bl;
        block20: {
            byte[] byArray = aOCSPCevabi.getTbsResponseData();
            int n = OCSPResponseStatusInfo.f;
            if (byArray == null) {
                d.error(OCSPSignatureChecker.b(9819, -1848));
                aOCSPCevapBilgisi.addDetail(this, OCSPSignatureCheckStatus.INVALID_RESPONSE_STRUCTURE, false);
                return PathValidationResult.OCSP_SIGNATURE_CONTROL_FAILURE;
            }
            byte[] byArray2 = aOCSPCevabi.getSignatureValue();
            if (byArray2 == null) {
                d.error(OCSPSignatureChecker.b(9823, 16393));
                aOCSPCevapBilgisi.addDetail(this, OCSPSignatureCheckStatus.RESPONSE_NOT_SIGNED, false);
                return PathValidationResult.OCSP_SIGNATURE_CONTROL_FAILURE;
            }
            EBasicOCSPResponse eBasicOCSPResponse = aOCSPCevabi.getBasicOCSPResponse();
            if (eBasicOCSPResponse.getCertificateCount() == 0) {
                d.error(OCSPSignatureChecker.b(9822, 4411));
                aOCSPCevapBilgisi.addDetail(this, OCSPSignatureCheckStatus.NO_CERTIFICATE_IN_RESPONSE, false);
                return PathValidationResult.OCSP_SIGNATURE_CONTROL_FAILURE;
            }
            ECertificate eCertificate = eBasicOCSPResponse.getCertificate(0);
            if (!this.a(eCertificate)) {
                d.error(OCSPSignatureChecker.b(9818, 11435));
                aOCSPCevapBilgisi.addDetail(this, OCSPSignatureCheckStatus.CERTIFICATE_IS_NOT_OCSP_CERTIFICATE, false);
                return PathValidationResult.OCSP_SIGNATURE_CONTROL_FAILURE;
            }
            try {
                block21: {
                    block23: {
                        block22: {
                            Pair pair = SignatureAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)aOCSPCevabi.getBasicOCSPResponse().getSignatureAlgorithm());
                            PublicKey publicKey = KeyUtil.decodePublicKey((ESubjectPublicKeyInfo)eCertificate.getSubjectPublicKeyInfo());
                            bl = SignUtil.verify((SignatureAlg)((SignatureAlg)pair.first()), (AlgorithmParams)((AlgorithmParams)pair.second()), (byte[])byArray, (byte[])byArray2, (PublicKey)publicKey);
                            if (bl) break block21;
                            byte[] byArray3 = new byte[byArray2.length];
                            int n2 = byArray2.length - 1;
                            for (int i = 0; i < byArray2.length; ++i) {
                                byArray3[i] = byArray2[n2 - i];
                                if (n == 0) continue;
                            }
                            if (bl = SignUtil.verify((SignatureAlg)((SignatureAlg)pair.first()), (AlgorithmParams)((AlgorithmParams)pair.second()), (byte[])byArray, (byte[])byArray3, (PublicKey)publicKey)) break block22;
                            aOCSPCevapBilgisi.addDetail(this, OCSPSignatureCheckStatus.SIGNATURE_NOT_VERIFIED, false);
                            if (n == 0) break block23;
                        }
                        aOCSPCevapBilgisi.addDetail(this, OCSPSignatureCheckStatus.SIGNATURE_VERIFIED, true);
                    }
                    if (n == 0) break block20;
                }
                aOCSPCevapBilgisi.addDetail(this, OCSPSignatureCheckStatus.SIGNATURE_VERIFIED, true);
            }
            catch (CryptoException cryptoException) {
                d.error(OCSPSignatureChecker.b(9821, -29485), (Throwable)cryptoException);
                aOCSPCevapBilgisi.addDetail(this, OCSPSignatureCheckStatus.KRIPTO_ERROR_ON_VERIFICATION, false);
                return PathValidationResult.OCSP_SIGNATURE_CONTROL_FAILURE;
            }
        }
        d.debug(OCSPSignatureChecker.b(9820, -6503) + bl);
        if (bl) {
            pathValidationResult = PathValidationResult.SUCCESS;
            return pathValidationResult;
        }
        pathValidationResult = PathValidationResult.OCSP_SIGNATURE_CONTROL_FAILURE;
        return pathValidationResult;
    }

    private boolean a(ECertificate eCertificate) {
        EExtendedKeyUsage eExtendedKeyUsage = eCertificate.getExtensions().getExtendedKeyUsage();
        return eExtendedKeyUsage == null || eExtendedKeyUsage.hasElement(Constants.IMP_ID_KP_OCSPSIGNING);
    }

    @Override
    public String getCheckText() {
        return CertI18n.message((String)CertI18n.OCSP_IMZA_KONTROLU);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[6];
                var3_1 = 0;
                var2_2 = "\u009b\u0081\u00ca\u00fe\u0089\u008b\u0010m\u0014<\u00c4Y'\u00f4\u00f1\u00ec\u00e4Z\u00dd\u010eLm\u00f3\u01be\u00b4AFC_\u012f\u0080\u00f5\u00c6\u00abJ\u01d6,\u00b5<\u000fI1}\u0007\u00b3\u00f6\u00e7\u0098\"\u00ac\u009b\u0080\u0001\u00ca\u00e7\u0018\u00e9\u00ad\u00c6\u00bb\u0011>\r\u00bf\u00f8\u0095q\u00cae\u0080\u00b0\u0000\u00e5s\u0124\u0087\u00ea\u0007G\u009b\u01af\u001e*\u0082\u00bb\u0097z\u00e22\u0174\u008d\u00e3\u0087\u00deF\u0191\u00c6ue\u00a0]\u00e6\u00d8\u0012\f|\u00c5\u00dfv\u0173\u00be\u0094\u001d\u0019/\u00dd\"\u00b6T\u00a1\u01a2\u00a3>\u00b2\u00c3O\u0005\u00b9k-[\u0007\u00de\u00fa\u00e4Z3^\u00892\u00a9\u00ac";
                var4_3 = "\u009b\u0081\u00ca\u00fe\u0089\u008b\u0010m\u0014<\u00c4Y'\u00f4\u00f1\u00ec\u00e4Z\u00dd\u010eLm\u00f3\u01be\u00b4AFC_\u012f\u0080\u00f5\u00c6\u00abJ\u01d6,\u00b5<\u000fI1}\u0007\u00b3\u00f6\u00e7\u0098\"\u00ac\u009b\u0080\u0001\u00ca\u00e7\u0018\u00e9\u00ad\u00c6\u00bb\u0011>\r\u00bf\u00f8\u0095q\u00cae\u0080\u00b0\u0000\u00e5s\u0124\u0087\u00ea\u0007G\u009b\u01af\u001e*\u0082\u00bb\u0097z\u00e22\u0174\u008d\u00e3\u0087\u00deF\u0191\u00c6ue\u00a0]\u00e6\u00d8\u0012\f|\u00c5\u00dfv\u0173\u00be\u0094\u001d\u0019/\u00dd\"\u00b6T\u00a1\u01a2\u00a3>\u00b2\u00c3O\u0005\u00b9k-[\u0007\u00de\u00fa\u00e4Z3^\u00892\u00a9\u00ac".length();
                var1_4 = 36;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "M\u00fe\u0010\u0011\u00d2v{\u00d2y\u00cbi\u00a7\u0092+G\u00172%\u0007\u00b1Y\u00c5\u00dd1\u001a\u007f\u018du\u00e0|\u00a5\u00a1\u01d0\u0082ZA\\h\u0191<\u00abu\u008bi08\u00a8\u00fc\u001bV*\u00e5=\u00e5\u00c5\u00d2\u00c0\u0011\u00c1>(\u001aYR6K\u00cc\u0016xX\u00b2A\u00d6=\u018bV\u016c\u0001\nf5\u00a3\u00dc\u00c7\u0181\u00b3\u00ban\u00e2\u00a8\"\u0084\u0006\u009d\u009d\u009f-\u013f\u00e1\u0011";
                    var4_3 = "M\u00fe\u0010\u0011\u00d2v{\u00d2y\u00cbi\u00a7\u0092+G\u00172%\u0007\u00b1Y\u00c5\u00dd1\u001a\u007f\u018du\u00e0|\u00a5\u00a1\u01d0\u0082ZA\\h\u0191<\u00abu\u008bi08\u00a8\u00fc\u001bV*\u00e5=\u00e5\u00c5\u00d2\u00c0\u0011\u00c1>(\u001aYR6K\u00cc\u0016xX\u00b2A\u00d6=\u018bV\u016c\u0001\nf5\u00a3\u00dc\u00c7\u0181\u00b3\u00ban\u00e2\u00a8\"\u0084\u0006\u009d\u009d\u009f-\u013f\u00e1\u0011".length();
                    var1_4 = 39;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 125;
                            break;
                        }
                        case 1: {
                            v13 = 56;
                            break;
                        }
                        case 2: {
                            v13 = 75;
                            break;
                        }
                        case 3: {
                            v13 = 97;
                            break;
                        }
                        case 4: {
                            v13 = 113;
                            break;
                        }
                        case 5: {
                            v13 = 21;
                            break;
                        }
                        default: {
                            v13 = 24;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        OCSPSignatureChecker.e = var5;
        OCSPSignatureChecker.f = new String[6];
        OCSPSignatureChecker.d = LoggerFactory.getLogger(OCSPSignatureChecker.class);
    }

    private static String b(int n, int n2) {
        int n3 = (n ^ 0x265F) & 0xFFFF;
        if (f[n3] == null) {
            int n4;
            int n5;
            char[] cArray = e[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 31;
                    break;
                }
                case 1: {
                    n5 = 24;
                    break;
                }
                case 2: {
                    n5 = 165;
                    break;
                }
                case 3: {
                    n5 = 119;
                    break;
                }
                case 4: {
                    n5 = 220;
                    break;
                }
                case 5: {
                    n5 = 106;
                    break;
                }
                case 6: {
                    n5 = 38;
                    break;
                }
                case 7: {
                    n5 = 164;
                    break;
                }
                case 8: {
                    n5 = 158;
                    break;
                }
                case 9: {
                    n5 = 193;
                    break;
                }
                case 10: {
                    n5 = 246;
                    break;
                }
                case 11: {
                    n5 = 45;
                    break;
                }
                case 12: {
                    n5 = 116;
                    break;
                }
                case 13: {
                    n5 = 13;
                    break;
                }
                case 14: {
                    n5 = 242;
                    break;
                }
                case 15: {
                    n5 = 213;
                    break;
                }
                case 16: {
                    n5 = 233;
                    break;
                }
                case 17: {
                    n5 = 216;
                    break;
                }
                case 18: {
                    n5 = 69;
                    break;
                }
                case 19: {
                    n5 = 230;
                    break;
                }
                case 20: {
                    n5 = 251;
                    break;
                }
                case 21: {
                    n5 = 245;
                    break;
                }
                case 22: {
                    n5 = 28;
                    break;
                }
                case 23: {
                    n5 = 52;
                    break;
                }
                case 24: {
                    n5 = 214;
                    break;
                }
                case 25: {
                    n5 = 238;
                    break;
                }
                case 26: {
                    n5 = 229;
                    break;
                }
                case 27: {
                    n5 = 162;
                    break;
                }
                case 28: {
                    n5 = 168;
                    break;
                }
                case 29: {
                    n5 = 26;
                    break;
                }
                case 30: {
                    n5 = 239;
                    break;
                }
                case 31: {
                    n5 = 235;
                    break;
                }
                case 32: {
                    n5 = 80;
                    break;
                }
                case 33: {
                    n5 = 141;
                    break;
                }
                case 34: {
                    n5 = 27;
                    break;
                }
                case 35: {
                    n5 = 240;
                    break;
                }
                case 36: {
                    n5 = 16;
                    break;
                }
                case 37: {
                    n5 = 196;
                    break;
                }
                case 38: {
                    n5 = 125;
                    break;
                }
                case 39: {
                    n5 = 185;
                    break;
                }
                case 40: {
                    n5 = 104;
                    break;
                }
                case 41: {
                    n5 = 177;
                    break;
                }
                case 42: {
                    n5 = 2;
                    break;
                }
                case 43: {
                    n5 = 25;
                    break;
                }
                case 44: {
                    n5 = 202;
                    break;
                }
                case 45: {
                    n5 = 49;
                    break;
                }
                case 46: {
                    n5 = 142;
                    break;
                }
                case 47: {
                    n5 = 50;
                    break;
                }
                case 48: {
                    n5 = 85;
                    break;
                }
                case 49: {
                    n5 = 207;
                    break;
                }
                case 50: {
                    n5 = 4;
                    break;
                }
                case 51: {
                    n5 = 51;
                    break;
                }
                case 52: {
                    n5 = 74;
                    break;
                }
                case 53: {
                    n5 = 82;
                    break;
                }
                case 54: {
                    n5 = 234;
                    break;
                }
                case 55: {
                    n5 = 86;
                    break;
                }
                case 56: {
                    n5 = 95;
                    break;
                }
                case 57: {
                    n5 = 37;
                    break;
                }
                case 58: {
                    n5 = 36;
                    break;
                }
                case 59: {
                    n5 = 101;
                    break;
                }
                case 60: {
                    n5 = 221;
                    break;
                }
                case 61: {
                    n5 = 154;
                    break;
                }
                case 62: {
                    n5 = 20;
                    break;
                }
                case 63: {
                    n5 = 112;
                    break;
                }
                case 64: {
                    n5 = 117;
                    break;
                }
                case 65: {
                    n5 = 68;
                    break;
                }
                case 66: {
                    n5 = 29;
                    break;
                }
                case 67: {
                    n5 = 150;
                    break;
                }
                case 68: {
                    n5 = 107;
                    break;
                }
                case 69: {
                    n5 = 171;
                    break;
                }
                case 70: {
                    n5 = 199;
                    break;
                }
                case 71: {
                    n5 = 61;
                    break;
                }
                case 72: {
                    n5 = 23;
                    break;
                }
                case 73: {
                    n5 = 110;
                    break;
                }
                case 74: {
                    n5 = 253;
                    break;
                }
                case 75: {
                    n5 = 145;
                    break;
                }
                case 76: {
                    n5 = 219;
                    break;
                }
                case 77: {
                    n5 = 167;
                    break;
                }
                case 78: {
                    n5 = 172;
                    break;
                }
                case 79: {
                    n5 = 65;
                    break;
                }
                case 80: {
                    n5 = 157;
                    break;
                }
                case 81: {
                    n5 = 247;
                    break;
                }
                case 82: {
                    n5 = 87;
                    break;
                }
                case 83: {
                    n5 = 6;
                    break;
                }
                case 84: {
                    n5 = 118;
                    break;
                }
                case 85: {
                    n5 = 132;
                    break;
                }
                case 86: {
                    n5 = 173;
                    break;
                }
                case 87: {
                    n5 = 181;
                    break;
                }
                case 88: {
                    n5 = 75;
                    break;
                }
                case 89: {
                    n5 = 63;
                    break;
                }
                case 90: {
                    n5 = 94;
                    break;
                }
                case 91: {
                    n5 = 159;
                    break;
                }
                case 92: {
                    n5 = 161;
                    break;
                }
                case 93: {
                    n5 = 11;
                    break;
                }
                case 94: {
                    n5 = 224;
                    break;
                }
                case 95: {
                    n5 = 192;
                    break;
                }
                case 96: {
                    n5 = 189;
                    break;
                }
                case 97: {
                    n5 = 72;
                    break;
                }
                case 98: {
                    n5 = 149;
                    break;
                }
                case 99: {
                    n5 = 160;
                    break;
                }
                case 100: {
                    n5 = 108;
                    break;
                }
                case 101: {
                    n5 = 146;
                    break;
                }
                case 102: {
                    n5 = 39;
                    break;
                }
                case 103: {
                    n5 = 231;
                    break;
                }
                case 104: {
                    n5 = 123;
                    break;
                }
                case 105: {
                    n5 = 136;
                    break;
                }
                case 106: {
                    n5 = 122;
                    break;
                }
                case 107: {
                    n5 = 58;
                    break;
                }
                case 108: {
                    n5 = 77;
                    break;
                }
                case 109: {
                    n5 = 55;
                    break;
                }
                case 110: {
                    n5 = 183;
                    break;
                }
                case 111: {
                    n5 = 91;
                    break;
                }
                case 112: {
                    n5 = 195;
                    break;
                }
                case 113: {
                    n5 = 151;
                    break;
                }
                case 114: {
                    n5 = 121;
                    break;
                }
                case 115: {
                    n5 = 109;
                    break;
                }
                case 116: {
                    n5 = 206;
                    break;
                }
                case 117: {
                    n5 = 99;
                    break;
                }
                case 118: {
                    n5 = 191;
                    break;
                }
                case 119: {
                    n5 = 152;
                    break;
                }
                case 120: {
                    n5 = 18;
                    break;
                }
                case 121: {
                    n5 = 17;
                    break;
                }
                case 122: {
                    n5 = 44;
                    break;
                }
                case 123: {
                    n5 = 60;
                    break;
                }
                case 124: {
                    n5 = 114;
                    break;
                }
                case 125: {
                    n5 = 79;
                    break;
                }
                case 126: {
                    n5 = 212;
                    break;
                }
                case 127: {
                    n5 = 70;
                    break;
                }
                case 128: {
                    n5 = 182;
                    break;
                }
                case 129: {
                    n5 = 137;
                    break;
                }
                case 130: {
                    n5 = 163;
                    break;
                }
                case 131: {
                    n5 = 148;
                    break;
                }
                case 132: {
                    n5 = 135;
                    break;
                }
                case 133: {
                    n5 = 41;
                    break;
                }
                case 134: {
                    n5 = 155;
                    break;
                }
                case 135: {
                    n5 = 138;
                    break;
                }
                case 136: {
                    n5 = 64;
                    break;
                }
                case 137: {
                    n5 = 244;
                    break;
                }
                case 138: {
                    n5 = 210;
                    break;
                }
                case 139: {
                    n5 = 204;
                    break;
                }
                case 140: {
                    n5 = 35;
                    break;
                }
                case 141: {
                    n5 = 5;
                    break;
                }
                case 142: {
                    n5 = 48;
                    break;
                }
                case 143: {
                    n5 = 115;
                    break;
                }
                case 144: {
                    n5 = 236;
                    break;
                }
                case 145: {
                    n5 = 124;
                    break;
                }
                case 146: {
                    n5 = 7;
                    break;
                }
                case 147: {
                    n5 = 134;
                    break;
                }
                case 148: {
                    n5 = 153;
                    break;
                }
                case 149: {
                    n5 = 140;
                    break;
                }
                case 150: {
                    n5 = 208;
                    break;
                }
                case 151: {
                    n5 = 211;
                    break;
                }
                case 152: {
                    n5 = 228;
                    break;
                }
                case 153: {
                    n5 = 178;
                    break;
                }
                case 154: {
                    n5 = 227;
                    break;
                }
                case 155: {
                    n5 = 215;
                    break;
                }
                case 156: {
                    n5 = 73;
                    break;
                }
                case 157: {
                    n5 = 90;
                    break;
                }
                case 158: {
                    n5 = 226;
                    break;
                }
                case 159: {
                    n5 = 225;
                    break;
                }
                case 160: {
                    n5 = 184;
                    break;
                }
                case 161: {
                    n5 = 96;
                    break;
                }
                case 162: {
                    n5 = 252;
                    break;
                }
                case 163: {
                    n5 = 131;
                    break;
                }
                case 164: {
                    n5 = 53;
                    break;
                }
                case 165: {
                    n5 = 30;
                    break;
                }
                case 166: {
                    n5 = 8;
                    break;
                }
                case 167: {
                    n5 = 54;
                    break;
                }
                case 168: {
                    n5 = 128;
                    break;
                }
                case 169: {
                    n5 = 248;
                    break;
                }
                case 170: {
                    n5 = 175;
                    break;
                }
                case 171: {
                    n5 = 187;
                    break;
                }
                case 172: {
                    n5 = 222;
                    break;
                }
                case 173: {
                    n5 = 243;
                    break;
                }
                case 174: {
                    n5 = 201;
                    break;
                }
                case 175: {
                    n5 = 170;
                    break;
                }
                case 176: {
                    n5 = 57;
                    break;
                }
                case 177: {
                    n5 = 22;
                    break;
                }
                case 178: {
                    n5 = 0;
                    break;
                }
                case 179: {
                    n5 = 250;
                    break;
                }
                case 180: {
                    n5 = 19;
                    break;
                }
                case 181: {
                    n5 = 1;
                    break;
                }
                case 182: {
                    n5 = 113;
                    break;
                }
                case 183: {
                    n5 = 130;
                    break;
                }
                case 184: {
                    n5 = 105;
                    break;
                }
                case 185: {
                    n5 = 14;
                    break;
                }
                case 186: {
                    n5 = 78;
                    break;
                }
                case 187: {
                    n5 = 232;
                    break;
                }
                case 188: {
                    n5 = 241;
                    break;
                }
                case 189: {
                    n5 = 40;
                    break;
                }
                case 190: {
                    n5 = 97;
                    break;
                }
                case 191: {
                    n5 = 120;
                    break;
                }
                case 192: {
                    n5 = 21;
                    break;
                }
                case 193: {
                    n5 = 92;
                    break;
                }
                case 194: {
                    n5 = 126;
                    break;
                }
                case 195: {
                    n5 = 166;
                    break;
                }
                case 196: {
                    n5 = 237;
                    break;
                }
                case 197: {
                    n5 = 83;
                    break;
                }
                case 198: {
                    n5 = 169;
                    break;
                }
                case 199: {
                    n5 = 190;
                    break;
                }
                case 200: {
                    n5 = 176;
                    break;
                }
                case 201: {
                    n5 = 88;
                    break;
                }
                case 202: {
                    n5 = 129;
                    break;
                }
                case 203: {
                    n5 = 156;
                    break;
                }
                case 204: {
                    n5 = 180;
                    break;
                }
                case 205: {
                    n5 = 249;
                    break;
                }
                case 206: {
                    n5 = 47;
                    break;
                }
                case 207: {
                    n5 = 46;
                    break;
                }
                case 208: {
                    n5 = 103;
                    break;
                }
                case 209: {
                    n5 = 111;
                    break;
                }
                case 210: {
                    n5 = 56;
                    break;
                }
                case 211: {
                    n5 = 188;
                    break;
                }
                case 212: {
                    n5 = 198;
                    break;
                }
                case 213: {
                    n5 = 42;
                    break;
                }
                case 214: {
                    n5 = 12;
                    break;
                }
                case 215: {
                    n5 = 218;
                    break;
                }
                case 216: {
                    n5 = 98;
                    break;
                }
                case 217: {
                    n5 = 84;
                    break;
                }
                case 218: {
                    n5 = 43;
                    break;
                }
                case 219: {
                    n5 = 59;
                    break;
                }
                case 220: {
                    n5 = 67;
                    break;
                }
                case 221: {
                    n5 = 76;
                    break;
                }
                case 222: {
                    n5 = 62;
                    break;
                }
                case 223: {
                    n5 = 203;
                    break;
                }
                case 224: {
                    n5 = 93;
                    break;
                }
                case 225: {
                    n5 = 15;
                    break;
                }
                case 226: {
                    n5 = 9;
                    break;
                }
                case 227: {
                    n5 = 71;
                    break;
                }
                case 228: {
                    n5 = 254;
                    break;
                }
                case 229: {
                    n5 = 10;
                    break;
                }
                case 230: {
                    n5 = 100;
                    break;
                }
                case 231: {
                    n5 = 255;
                    break;
                }
                case 232: {
                    n5 = 133;
                    break;
                }
                case 233: {
                    n5 = 32;
                    break;
                }
                case 234: {
                    n5 = 33;
                    break;
                }
                case 235: {
                    n5 = 174;
                    break;
                }
                case 236: {
                    n5 = 205;
                    break;
                }
                case 237: {
                    n5 = 102;
                    break;
                }
                case 238: {
                    n5 = 197;
                    break;
                }
                case 239: {
                    n5 = 179;
                    break;
                }
                case 240: {
                    n5 = 143;
                    break;
                }
                case 241: {
                    n5 = 34;
                    break;
                }
                case 242: {
                    n5 = 223;
                    break;
                }
                case 243: {
                    n5 = 139;
                    break;
                }
                case 244: {
                    n5 = 217;
                    break;
                }
                case 245: {
                    n5 = 194;
                    break;
                }
                case 246: {
                    n5 = 66;
                    break;
                }
                case 247: {
                    n5 = 3;
                    break;
                }
                case 248: {
                    n5 = 144;
                    break;
                }
                case 249: {
                    n5 = 89;
                    break;
                }
                case 250: {
                    n5 = 209;
                    break;
                }
                case 251: {
                    n5 = 200;
                    break;
                }
                case 252: {
                    n5 = 147;
                    break;
                }
                case 253: {
                    n5 = 186;
                    break;
                }
                case 254: {
                    n5 = 127;
                    break;
                }
                default: {
                    n5 = 81;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            OCSPSignatureChecker.f[n3] = new String(cArray).intern();
        }
        return f[n3];
    }

    public static final class OCSPSignatureCheckStatus
    extends Enum<OCSPSignatureCheckStatus>
    implements CheckStatus {
        public static final /* enum */ OCSPSignatureCheckStatus RESPONSE_NOT_SIGNED;
        public static final /* enum */ OCSPSignatureCheckStatus INVALID_RESPONSE_STRUCTURE;
        public static final /* enum */ OCSPSignatureCheckStatus NO_CERTIFICATE_IN_RESPONSE;
        public static final /* enum */ OCSPSignatureCheckStatus CERTIFICATE_IS_NOT_OCSP_CERTIFICATE;
        public static final /* enum */ OCSPSignatureCheckStatus KRIPTO_ERROR_ON_VERIFICATION;
        public static final /* enum */ OCSPSignatureCheckStatus SIGNATURE_NOT_VERIFIED;
        public static final /* enum */ OCSPSignatureCheckStatus SIGNATURE_VERIFIED;
        private static final /* synthetic */ OCSPSignatureCheckStatus[] a;

        public static OCSPSignatureCheckStatus[] values() {
            return (OCSPSignatureCheckStatus[])a.clone();
        }

        public static OCSPSignatureCheckStatus valueOf(String name) {
            return Enum.valueOf(OCSPSignatureCheckStatus.class, name);
        }

        @Override
        public String getText() {
            switch (this) {
                case RESPONSE_NOT_SIGNED: {
                    return CertI18n.message((String)CertI18n.CEVAP_IMZALI_DEGIL);
                }
                case INVALID_RESPONSE_STRUCTURE: {
                    return CertI18n.message((String)CertI18n.CEVAP_YAPISI_BOZUK);
                }
                case NO_CERTIFICATE_IN_RESPONSE: {
                    return CertI18n.message((String)CertI18n.CEVAPTA_SERTIFIKA_YOK);
                }
                case CERTIFICATE_IS_NOT_OCSP_CERTIFICATE: {
                    return CertI18n.message((String)CertI18n.SERTIFIKA_OCSP_SERTIFIKASI_DEGIL);
                }
                case KRIPTO_ERROR_ON_VERIFICATION: {
                    return CertI18n.message((String)CertI18n.DOGRULAMA_KRIPTO_HATASI);
                }
                case SIGNATURE_NOT_VERIFIED: {
                    return CertI18n.message((String)CertI18n.IMZA_DOGRULANAMADI);
                }
                case SIGNATURE_VERIFIED: {
                    return CertI18n.message((String)CertI18n.IMZA_DOGRULANDI);
                }
            }
            return CertI18n.message((String)CertI18n.KONTROL_SONUCU);
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var6 = new String[7];
                    var4_1 = 0;
                    var3_2 = "d0u+|7\u000es*h4g&\u000e\u007f2h>w\u0012e<a5r-\bd0y-v+\u0014p<c?#u0t/z?\u0014u4r>l0\u000ei;i/l6\u001ee%y8v+\t\u007f3o8r-\u0018\u001c}'o+g6\u0002s't4a&\u0012x*p>a0\u001b\u007f6g/z6\u0013\u001a\u007f;p:\u007f0\u0019i'c(c6\u0013e0y(g+\bu!s)v";
                    var5_3 = "d0u+|7\u000es*h4g&\u000e\u007f2h>w\u0012e<a5r-\bd0y-v+\u0014p<c?#u0t/z?\u0014u4r>l0\u000ei;i/l6\u001ee%y8v+\t\u007f3o8r-\u0018\u001c}'o+g6\u0002s't4a&\u0012x*p>a0\u001b\u007f6g/z6\u0013\u001a\u007f;p:\u007f0\u0019i'c(c6\u0013e0y(g+\bu!s)v".length();
                    var2_4 = 19;
                    var1_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = ++var1_5;
                        v1 = var3_2.substring(v0, v0 + var2_4);
                        v2 = -1;
                        break block19;
                        break;
                    }
lbl12:
                    // 1 sources

                    while (true) {
                        var6[var4_1++] = v3.intern();
                        if ((var1_5 += var2_4) < var5_3) {
                            var2_4 = var3_2.charAt(var1_5);
                            ** continue;
                        }
                        var3_2 = "x:y8v+\t\u007f3o8r-\u0018i<h$a<\u000ef:h(v\u0016e<a5r-\bd0y5|-\u0002`0t2u0\u0018r";
                        var5_3 = "x:y8v+\t\u007f3o8r-\u0018i<h$a<\u000ef:h(v\u0016e<a5r-\bd0y5|-\u0002`0t2u0\u0018r".length();
                        var2_4 = 26;
                        var1_5 = -1;
lbl21:
                        // 2 sources

                        while (true) {
                            v4 = ++var1_5;
                            v1 = var3_2.substring(v4, v4 + var2_4);
                            v2 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl26:
                    // 1 sources

                    while (true) {
                        var6[var4_1++] = v3.intern();
                        if ((var1_5 += var2_4) < var5_3) {
                            var2_4 = var3_2.charAt(var1_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v5 = v1.toCharArray();
                var7_6 = 0;
                v6 = v5.length;
                v7 = v5;
                v8 = v6;
                if (v6 > 1) ** GOTO lbl76
                do {
                    v9 = v7;
                    v10 = v7;
                    v11 = var7_6;
                    while (true) {
                        v12 = v9[v11];
                        switch (var7_6 % 7) {
                            case 0: {
                                v13 = 54;
                                break;
                            }
                            case 1: {
                                v13 = 117;
                                break;
                            }
                            case 2: {
                                v13 = 38;
                                break;
                            }
                            case 3: {
                                v13 = 123;
                                break;
                            }
                            case 4: {
                                v13 = 51;
                                break;
                            }
                            case 5: {
                                v13 = 121;
                                break;
                            }
                            default: {
                                v13 = 93;
                            }
                        }
                        v9[v11] = (char)(v12 ^ v13);
                        ++var7_6;
                        v7 = v10;
                        v8 = v8;
                        if (v8 != 0) break;
                        v10 = v7;
                        v14 = v8;
                        v11 = v8;
                        v9 = v7;
                    }
lbl76:
                    // 2 sources

                    v15 = v7;
                    v14 = v8;
                } while (v8 > var7_6);
                v3 = new String(v15);
                switch (v2) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl85:
                    // 1 sources

                    ** continue;
                }
            }
            var0_7 = var6;
            OCSPSignatureCheckStatus.RESPONSE_NOT_SIGNED = new OCSPSignatureCheckStatus();
            OCSPSignatureCheckStatus.INVALID_RESPONSE_STRUCTURE = new OCSPSignatureCheckStatus();
            OCSPSignatureCheckStatus.NO_CERTIFICATE_IN_RESPONSE = new OCSPSignatureCheckStatus();
            OCSPSignatureCheckStatus.CERTIFICATE_IS_NOT_OCSP_CERTIFICATE = new OCSPSignatureCheckStatus();
            OCSPSignatureCheckStatus.KRIPTO_ERROR_ON_VERIFICATION = new OCSPSignatureCheckStatus();
            OCSPSignatureCheckStatus.SIGNATURE_NOT_VERIFIED = new OCSPSignatureCheckStatus();
            OCSPSignatureCheckStatus.SIGNATURE_VERIFIED = new OCSPSignatureCheckStatus();
            OCSPSignatureCheckStatus.a = new OCSPSignatureCheckStatus[]{OCSPSignatureCheckStatus.RESPONSE_NOT_SIGNED, OCSPSignatureCheckStatus.INVALID_RESPONSE_STRUCTURE, OCSPSignatureCheckStatus.NO_CERTIFICATE_IN_RESPONSE, OCSPSignatureCheckStatus.CERTIFICATE_IS_NOT_OCSP_CERTIFICATE, OCSPSignatureCheckStatus.KRIPTO_ERROR_ON_VERIFICATION, OCSPSignatureCheckStatus.SIGNATURE_NOT_VERIFIED, OCSPSignatureCheckStatus.SIGNATURE_VERIFIED};
        }
    }
}

