/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.ecdsa.ecmath.field;

import gnu.crypto.cipher.BaseCipher;
import gnu.crypto.sig.ecdsa.ecmath.field.Field;
import java.math.BigInteger;

public class FieldF2mPolynomial
extends Field {
    private final int a;
    private final BigInteger c;
    private final byte[] d;
    private final int[] e;
    private final BigInteger f;
    private final int g;
    private static final BigInteger h = BigInteger.ONE;
    private static final BigInteger i = new BigInteger("2");

    private FieldF2mPolynomial(int n, BigInteger bigInteger) {
        super(h.shiftLeft(n));
        byte[] byArray;
        this.a = n;
        this.c = bigInteger;
        this.d = this.c.toByteArray();
        this.f = this.mSize.subtract(i);
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2[0] != 0) {
            byArray = byArray2;
        } else {
            byArray = new byte[byArray2.length - 1];
            System.arraycopy(byArray2, 1, byArray, 0, byArray.length);
        }
        this.e = new int[bigInteger.bitCount()];
        int n2 = byArray.length - 1;
        int n3 = 0;
        int n4 = 0;
        while (n2 >= 0) {
            if (byArray[n2] != 0) {
                for (int k = 0; k < 8; ++k) {
                    if (((byArray[n2] & 0xFF) >> k & 1) != 1) continue;
                    this.e[n4++] = n3 + k;
                }
            }
            --n2;
            n3 += 8;
        }
        this.g = this.d[0] == 0 || this.d[0] == 1 ? this.d.length - 1 : this.d.length;
    }

    public static synchronized FieldF2mPolynomial getInstance(int aM, BigInteger aReductionP) {
        FieldF2mPolynomial fieldF2mPolynomial = (FieldF2mPolynomial)INSTANCES.get(h.shiftLeft(aM));
        if (fieldF2mPolynomial == null) {
            fieldF2mPolynomial = new FieldF2mPolynomial(aM, aReductionP);
        }
        return fieldF2mPolynomial;
    }

    public int getMM() {
        return this.a;
    }

    @Override
    public boolean equals(Object aObject) {
        if (super.equals(aObject)) {
            return this.c.equals(((FieldF2mPolynomial)aObject).c);
        }
        return false;
    }

    public BigInteger getMReductionP() {
        return this.c;
    }

    public byte[] getMReductionPArray() {
        return this.d;
    }

    public int[] getMReductionPOnes() {
        return this.e;
    }

    @Override
    public int hashCode() {
        return this.mSize.hashCode() ^ this.c.hashCode();
    }

    @Override
    public BigInteger fromOctetToFieldElement(byte[] aOctet) {
        return new BigInteger(1, aOctet);
    }

    public BigInteger getMFieldSizeMinusOne() {
        return this.mFieldSizeMinusOne;
    }

    public BigInteger getMFieldSizeMinusTwo() {
        return this.f;
    }

    public BigInteger reduce(BigInteger aPol) {
        return this.reduce(aPol.toByteArray());
    }

    public BigInteger reduce(byte[] aPol) {
        int n;
        int n2;
        byte by;
        int n3;
        int n4;
        int n5;
        int n6 = (aPol.length << 3) - 8 - this.a;
        int n7 = 0;
        String[] stringArray = Field.b();
        while (n7 < aPol.length - this.g) {
            if (aPol[n7] != 0) {
                for (n5 = this.e.length - 2; n5 >= 0; --n5) {
                    n4 = n6 + this.e[n5];
                    n3 = n4 & 7;
                    by = (byte)((aPol[n7] & 0xFF) >> 8 - n3);
                    int n8 = n2 = aPol.length - (n4 >> 3) - 1;
                    aPol[n8] = (byte)(aPol[n8] ^ (byte)(aPol[n7] << n3));
                    if (by <= 0) continue;
                    int n9 = n2 - 1;
                    aPol[n9] = (byte)(aPol[n9] ^ by);
                    if (stringArray != null) continue;
                    BaseCipher.b("U3xyd");
                    break;
                }
            }
            ++n7;
            n6 -= 8;
            if (stringArray != null) continue;
        }
        if ((n = (this.c.bitLength() - 1) % 8) > 0) {
            byte by2 = (byte)((aPol[n7] & 0xFF) >> n);
            if (by2 != 0) {
                for (n5 = this.e.length - 2; n5 >= 0; --n5) {
                    n4 = this.e[n5];
                    n3 = n4 & 7;
                    by = (byte)((by2 & 0xFF) >> 8 - n3);
                    int n10 = n2 = aPol.length - (n4 >> 3) - 1;
                    aPol[n10] = (byte)(aPol[n10] ^ (byte)(by2 << n3));
                    if (by <= 0) continue;
                    int n11 = n2 - 1;
                    aPol[n11] = (byte)(aPol[n11] ^ by);
                    if (stringArray != null) continue;
                }
            }
            aPol[n7] = (byte)(((byte)(aPol[n7] << 8 - n) & 0xFF) >> 8 - n);
        }
        byte[] byArray = new byte[aPol.length < this.g ? aPol.length : this.g];
        System.arraycopy(aPol, aPol.length - byArray.length, byArray, 0, byArray.length);
        return new BigInteger(1, byArray);
    }

    public BigInteger _reduce1(BigInteger aPol) {
        BigInteger bigInteger = aPol;
        String[] stringArray = Field.b();
        while (bigInteger.bitLength() > this.a) {
            BigInteger bigInteger2 = this.c.shiftLeft(bigInteger.bitLength() - this.c.bitLength());
            bigInteger = bigInteger.xor(bigInteger2);
            if (stringArray != null) continue;
        }
        if (BaseCipher.b() != null) {
            Field.b(new String[3]);
        }
        return bigInteger;
    }
}

