/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.xmlsignature.formats;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignedData;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectPublicKeyInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.CertificateStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.CertificateValidation;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.ValidationSystem;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation.RevocationChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.revocation.RevocationFromOCSPChecker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.Finder;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.find.ocsp.OCSPResponseFinderFromAIA;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AllEParameters;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.SignedDataValidation;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.SignedDataValidationResult;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.SignedData_Status;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.crypto.BaseSigner;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.util.ECUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;
import tr.gov.tubitak.uekae.esya.api.infra.tsclient.TSSettings;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.CertValidationData;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.Context;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.DigestMethod;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.SignatureMethod;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.SignatureType;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.SignatureValidationResult;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResult;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResultType;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignature;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignatureException;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignatureRuntimeException;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.config.TimestampConfig;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.config.ValidationConfig;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.core.ValidationDataCollector;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.document.Document;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.formats.BaseSignatureFormat;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.formats.SignatureFormat;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.formats.T;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.formats.XMLDSig;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.BaseElement;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.CertID;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.QualifyingProperties;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.SignatureTimeStamp;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.SignedProperties;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.SignedSignatureProperties;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.SigningCertificate;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.UnsignedProperties;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.UnsignedSignatureProperties;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.timestamp.EncapsulatedTimeStamp;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.timestamp.XAdESTimeStamp;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.CRLReference;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.CertificateValues;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.CompleteCertificateRefs;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.CompleteRevocationRefs;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.OCSPReference;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.RevocationValues;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.vrefs.TimeStampValidationData;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.resolver.Resolver;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.util.CertRevInfoExtractor;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.util.I18n;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.util.UniqueCertRevInfo;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.util.XmlSignUtil;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.validator.Validator;

public class BES
extends XMLDSig
implements SignatureFormat {
    private static final Logger c;
    private CertRevInfoExtractor d = new CertRevInfoExtractor();
    private static final String[] l;
    private static final String[] m;

    public BES(Context aContext, XMLSignature aSignature) {
        super(aContext, aSignature);
    }

    @Override
    public void addKeyInfo(ECertificate aCertificate) {
        super.addKeyInfo(aCertificate);
        SigningCertificate signingCertificate = new SigningCertificate(this.mContext);
        DigestMethod digestMethod = null;
        try {
            digestMethod = this.mContext.getConfig().getAlgorithmsConfig().getDigestMethod();
            signingCertificate.addCertID(new CertID(this.mContext, aCertificate, digestMethod));
        }
        catch (Exception exception) {
            throw new XMLSignatureRuntimeException(exception, BES.c(18741, -31282));
        }
        this.mSignature.createOrGetQualifyingProperties().getSignedProperties().getSignedSignatureProperties().setSigningCertificate(signingCertificate);
    }

    @Override
    public void addKeyInfo(PublicKey pk) throws XMLSignatureException {
        throw new XMLSignatureException(BES.c(18693, 8594));
    }

    @Override
    public SignatureValidationResult validateCore() throws XMLSignatureException {
        ECertificate eCertificate = this.extractCertificate();
        if (eCertificate == null) {
            c.warn(BES.c(18704, -11895));
            return new SignatureValidationResult(ValidationResultType.INCOMPLETE, I18n.translate(BES.c(18746, -17828), new Object[0]), null);
        }
        return this.validateCore(eCertificate);
    }

    public ECertificate extractCertificate() throws XMLSignatureException {
        ECertificate eCertificate;
        block6: {
            SigningCertificate signingCertificate;
            SignedSignatureProperties signedSignatureProperties;
            SignedProperties signedProperties;
            eCertificate = null;
            QualifyingProperties qualifyingProperties = this.mSignature.getQualifyingProperties();
            if (qualifyingProperties != null && (signedProperties = qualifyingProperties.getSignedProperties()) != null && (signedSignatureProperties = signedProperties.getSignedSignatureProperties()) != null && (signingCertificate = signedSignatureProperties.getSigningCertificate()) != null) {
                CertID certID = this.a(signingCertificate.getCertIDListCopy());
                String string = certID.getURI();
                if (string == null || string.length() <= 0) break block6;
                c.info(BES.c(18719, -5030) + string + BES.c(18707, -8378));
                try {
                    Document document = Resolver.resolve(string, this.mContext);
                    eCertificate = new ECertificate(document.getBytes());
                }
                catch (Exception exception) {
                    c.warn(I18n.translate(BES.c(18694, 12504), new Object[0]), (Throwable)exception);
                }
            }
        }
        if (eCertificate == null) {
            eCertificate = this.mSignature.getKeyInfo().resolveCertificate();
        }
        return eCertificate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public XMLSignature sign(BaseSigner aSigner) throws XMLSignatureException {
        Object object;
        boolean bl = this.mContext.isValidateCertificateBeforeSign();
        ECertificate eCertificate = this.extractCertificate();
        int n = BaseSignatureFormat.b;
        if (bl) {
            if (eCertificate == null) {
                throw new XMLSignatureRuntimeException(BES.c(18691, 15480));
            }
            object = this._validateCertificate(eCertificate, Calendar.getInstance(), true);
            if (object.getCertificateStatus() != CertificateStatus.VALID) {
                c.info(BES.c(18743, 14527) + object.printDetailedValidationReport());
                throw new XMLSignatureException(I18n.translate(BES.c(18696, 24645), object.getDetailedMessage()));
            }
        }
        try {
            ECUtil.checkDigestAlgForECCAlgorithm((ECertificate)eCertificate, (SignatureAlg)SignatureAlg.fromName((String)aSigner.getSignatureAlgorithmStr()));
            if (this.mSignature.createOrGetQualifyingProperties().getSignedSignatureProperties().getSignaturePolicyIdentifier() == null) return super.sign(aSigner);
            object = new ArrayList(0);
            Class<?> clazz = Class.forName(BES.c(18714, -27458));
            object.add(clazz);
            Iterator iterator = object.iterator();
            do {
                if (!iterator.hasNext()) return super.sign(aSigner);
                Class clazz2 = (Class)iterator.next();
                Validator validator = (Validator)clazz2.newInstance();
                ValidationResult validationResult = validator.validate(this.mSignature, eCertificate);
                if (validationResult.getResultType() == tr.gov.tubitak.uekae.esya.api.signature.ValidationResultType.VALID) continue;
                throw new XMLSignatureException(I18n.translate(BES.c(18709, 30236), new Object[0]));
            } while (n == 0);
            return super.sign(aSigner);
        }
        catch (Exception exception) {
            throw new XMLSignatureException(exception, BES.c(18697, 3321));
        }
    }

    @Override
    public SignatureValidationResult validateCore(Key aKey) throws XMLSignatureException {
        throw new XMLSignatureException(BES.c(18718, -18675));
    }

    @Override
    public SignatureValidationResult validateCore(ECertificate aCertificate) throws XMLSignatureException {
        ValidationResult validationResult;
        Object object2;
        PublicKey publicKey;
        this.a(aCertificate);
        int n = BaseSignatureFormat.b;
        try {
            publicKey = KeyUtil.decodePublicKey((ESubjectPublicKeyInfo)aCertificate.getSubjectPublicKeyInfo());
        }
        catch (CryptoException cryptoException) {
            throw new XMLSignatureException(cryptoException, BES.c(18700, 24520), BES.c(18738, 21099));
        }
        SignatureValidationResult signatureValidationResult = super.validateCore(publicKey);
        if (!signatureValidationResult.getType().equals((Object)ValidationResultType.VALID)) {
            return signatureValidationResult;
        }
        if (this.mContext.isValidateCertificates()) {
            boolean bl;
            block48: {
                boolean bl2;
                block45: {
                    boolean bl3;
                    block47: {
                        block46: {
                            block44: {
                                block41: {
                                    boolean bl4;
                                    block43: {
                                        block42: {
                                            bl2 = true;
                                            object2 = this.mSignature.getSignatureType();
                                            if (object2 != SignatureType.XAdES_X_L && object2 != SignatureType.XAdES_A) break block41;
                                            if (this.mContext.getConfig().getValidationConfig().isForceStrictReferences()) break block42;
                                            bl4 = true;
                                            break block43;
                                        }
                                        bl4 = false;
                                    }
                                    bl2 = bl4;
                                }
                                bl = true;
                                if (object2 == SignatureType.XAdES_C || object2 == SignatureType.XAdES_X) break block44;
                                if (object2 == SignatureType.XAdES_X_L) break block44;
                                if (object2 != SignatureType.XAdES_A) break block45;
                            }
                            if (this.mContext.getConfig().getValidationConfig().isForceStrictReferences()) break block46;
                            bl3 = true;
                            break block47;
                        }
                        bl3 = false;
                    }
                    bl = bl3;
                }
                ValidationDataCollector object3 = new ValidationDataCollector();
                validationResult = object3.collect(this.mSignature, bl2);
                if (validationResult == null || validationResult.getType() == ValidationResultType.VALID) break block48;
                signatureValidationResult.setStatus(validationResult.getType(), validationResult.getMessage());
                return signatureValidationResult;
            }
            ValidationResult validationResult2 = this.a(aCertificate, bl, signatureValidationResult);
            if (validationResult2.getType() != ValidationResultType.VALID) {
                signatureValidationResult.setStatus(validationResult2.getType(), validationResult2.getMessage());
                return signatureValidationResult;
            }
        }
        List<Validator> list = this.mContext.getConfig().getValidationConfig().getProfile(this.mSignature.getSignatureType()).createValidators();
        object2 = new ArrayList<Validator>(this.mContext.getValidators());
        object2.addAll(list);
        Iterator<Object> iterator = object2.iterator();
        while (iterator.hasNext()) {
            block49: {
                block50: {
                    Validator validator = (Validator)iterator.next();
                    validationResult = validator.validate(this.mSignature, aCertificate);
                    if (validationResult == null) break block49;
                    validationResult.setVerifierClass(validator.getClass());
                    signatureValidationResult.addItem(validationResult);
                    if (validationResult.getType() == ValidationResultType.INVALID) break block50;
                    if (validationResult.getType() != ValidationResultType.INCOMPLETE) break block49;
                }
                signatureValidationResult.setStatus(validationResult.getType(), validationResult.getMessage());
                return signatureValidationResult;
            }
            if (n == 0) continue;
        }
        for (XMLSignature xMLSignature : this.mSignature.getAllCounterSignatures()) {
            block51: {
                validationResult = xMLSignature.verify();
                signatureValidationResult.addItem(validationResult);
                if (validationResult.getType() != ValidationResultType.INVALID && validationResult.getType() != ValidationResultType.INCOMPLETE) break block51;
                signatureValidationResult.setStatus(validationResult.getType(), validationResult.getMessage());
                return signatureValidationResult;
            }
            if (n == 0) continue;
        }
        c.info(BES.c(18745, 1712));
        return signatureValidationResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(ECertificate eCertificate) {
        try {
            boolean bl = LV.getInstance().isTL(LV.Urunler.XMLIMZA);
            if (!bl) return;
            if (eCertificate.getSubject().getCommonNameAttribute().toLowerCase().contains(BES.c(18749, -3699))) return;
            throw new ESYARuntimeException(BES.c(18740, -3308));
        }
        catch (LE lE) {
            c.error(BES.c(18690, -6210), (Throwable)lE);
            throw new ESYARuntimeException(BES.c(18705, 29821), (Throwable)lE);
        }
    }

    private ValidationResult a(ECertificate eCertificate, boolean bl, SignatureValidationResult signatureValidationResult) throws XMLSignatureException {
        int n = BaseSignatureFormat.b;
        try {
            ValidationResult validationResult;
            CertificateStatusInfo certificateStatusInfo;
            block5: {
                block4: {
                    certificateStatusInfo = this._validateCertificate(eCertificate, this.mContext.getValidationTime(this.mSignature), bl);
                    this.mContext.setValidationResult(this.mSignature, certificateStatusInfo);
                    if (certificateStatusInfo.getCertificateStatus() != CertificateStatus.VALID) break block4;
                    validationResult = new ValidationResult(ValidationResultType.VALID, I18n.translate(BES.c(18710, -24800), new Object[0]), I18n.translate(BES.c(18701, -21304), new Object[0]), XmlSignUtil.verificationInfo(certificateStatusInfo), XMLSignature.class);
                    if (n == 0) break block5;
                }
                validationResult = new ValidationResult(ValidationResultType.INVALID, I18n.translate(BES.c(18736, -10586), new Object[0]), I18n.translate(BES.c(18747, -24861), eCertificate.getSubject().stringValue()) + "\n" + certificateStatusInfo.getDetailedMessage(), XmlSignUtil.verificationInfo(certificateStatusInfo), XMLSignature.class);
            }
            signatureValidationResult.setCertificateStatusInfo(certificateStatusInfo);
            signatureValidationResult.addItem(validationResult);
            return validationResult;
        }
        catch (Exception exception) {
            c.warn(exception.getMessage(), (Throwable)exception);
            return new ValidationResult(ValidationResultType.INCOMPLETE, I18n.translate(BES.c(18736, -10586), new Object[0]), BES.c(18703, -4073) + eCertificate.getSubject().stringValue() + "," + eCertificate.getSerialNumber() + " " + exception.getMessage(), null, XMLSignature.class);
        }
    }

    protected CertificateStatusInfo _validateCertificate(ECertificate aCertificate, Calendar aValidationTime, boolean useExternalResources) throws XMLSignatureException {
        Object object;
        Object object2;
        Object object3;
        CertValidationData certValidationData = this.mContext.getValidationData(this.mSignature);
        ValidationConfig validationConfig = this.mContext.getConfig().getValidationConfig();
        ValidationSystem validationSystem = this.mContext.getCertValidationSystem(aCertificate, useExternalResources, this.mSignature);
        validationSystem.setUserInitialCertificateSet(certValidationData.getCertificates());
        validationSystem.setUserInitialCRLSet(certValidationData.getCrls());
        validationSystem.setUserInitialOCSPResponseSet(certValidationData.getOcspResponses());
        int n = BaseSignatureFormat.b;
        DigestAlg digestAlg = this.mContext.getConfig().getAlgorithmsConfig().getDigestAlgForOCSP();
        if (digestAlg != null) {
            object3 = validationSystem.getCheckSystem().getRevocationCheckers();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (RevocationChecker)object2.next();
                if (object instanceof RevocationFromOCSPChecker) {
                    for (Finder finder : object.getFinders()) {
                        if (finder instanceof OCSPResponseFinderFromAIA) {
                            ((OCSPResponseFinderFromAIA)finder).setDigestAlgForOcspFinder(digestAlg);
                        }
                        if (n == 0) continue;
                    }
                }
                if (n == 0) continue;
            }
        }
        object3 = Calendar.getInstance();
        object2 = (Calendar)aValidationTime.clone();
        ((Calendar)object2).add(13, validationConfig.getGracePeriodInSeconds());
        if (((Calendar)object2).before(object3)) {
            object = (Calendar)aValidationTime.clone();
            ((Calendar)object).add(13, validationConfig.getLastRevocationPeriodInSeconds());
            if (((Calendar)object).after(aCertificate.getNotAfter())) {
                object = this.a(aCertificate.getNotAfter(), (Calendar)object2);
            }
            validationSystem.setBaseValidationTime(aValidationTime);
            validationSystem.setLastRevocationTime((Calendar)object);
        }
        try {
            return CertificateValidation.validateCertificate((ValidationSystem)validationSystem, (ECertificate)aCertificate, (boolean)validationConfig.isUseValidationDataPublishedAfterCreation());
        }
        catch (Exception exception) {
            c.warn(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private Calendar a(Calendar calendar, Calendar calendar2) {
        Calendar calendar3 = calendar.after(calendar2) ? calendar : calendar2;
        return calendar3;
    }

    private CertID a(List<CertID> list) {
        return list.get(0);
    }

    @Override
    public XMLSignature createCounterSignature() throws XMLSignatureException {
        XMLSignature xMLSignature = new XMLSignature(this.mContext, false);
        SignatureMethod signatureMethod = this.mSignature.getSignatureMethod();
        xMLSignature.setSignatureMethod(signatureMethod);
        String string = "#" + this.mSignature.getSignatureValueId();
        xMLSignature.addDocument(string, null, null, null, BES.c(18717, -18602), false);
        QualifyingProperties qualifyingProperties = this.mSignature.createOrGetQualifyingProperties();
        qualifyingProperties.createOrGetUnsignedProperties().getUnsignedSignatureProperties().addCounterSignature(xMLSignature);
        return xMLSignature;
    }

    @Override
    public SignatureFormat evolveToT() throws XMLSignatureException {
        TimestampConfig timestampConfig = this.mContext.getConfig().getTimestampConfig();
        TSSettings tSSettings = timestampConfig.getSettings();
        SignatureTimeStamp signatureTimeStamp = new SignatureTimeStamp(this.mContext, this.mSignature, timestampConfig.getC14nMethod(), timestampConfig.getDigestMethod(), tSSettings);
        this.mSignature.createOrGetQualifyingProperties().createOrGetUnsignedProperties().getUnsignedSignatureProperties().addSignatureTimeStamp(signatureTimeStamp);
        return new T(this.mContext, this.mSignature);
    }

    @Override
    public SignatureFormat evolveToC() throws XMLSignatureException {
        throw new XMLSignatureException(BES.c(18739, -23516), new Object[]{SignatureType.XAdES_BES, SignatureType.XAdES_C, SignatureType.XAdES_T});
    }

    @Override
    public SignatureFormat evolveToX1() throws XMLSignatureException {
        throw new XMLSignatureException(BES.c(18715, 9566), new Object[]{SignatureType.XAdES_BES, SignatureType.XAdES_X, SignatureType.XAdES_T});
    }

    @Override
    public SignatureFormat evolveToX2() throws XMLSignatureException {
        throw new XMLSignatureException(BES.c(18715, 9566), new Object[]{SignatureType.XAdES_BES, SignatureType.XAdES_X, SignatureType.XAdES_T});
    }

    @Override
    public SignatureFormat evolveToXL() throws XMLSignatureException {
        throw new XMLSignatureException(BES.c(18715, 9566), new Object[]{SignatureType.XAdES_BES, SignatureType.XAdES_X_L, SignatureType.XAdES_T});
    }

    @Override
    public SignatureFormat evolveToA() throws XMLSignatureException {
        throw new XMLSignatureException(BES.c(18715, 9566), new Object[]{SignatureType.XAdES_BES, SignatureType.XAdES_A, SignatureType.XAdES_T});
    }

    @Override
    public SignatureFormat addArchiveTimeStamp() throws XMLSignatureException {
        throw new XMLSignatureException(BES.c(18695, -22734));
    }

    protected void addReferences(CertificateStatusInfo csi) throws XMLSignatureException {
        Object object;
        CompleteCertificateRefs completeCertificateRefs = new CompleteCertificateRefs(this.mContext);
        CompleteRevocationRefs completeRevocationRefs = new CompleteRevocationRefs(this.mContext);
        DigestMethod digestMethod = this.mContext.getConfig().getAlgorithmsConfig().getDigestMethod();
        boolean bl = this.mContext.getConfig().getParameters().isWriteReferencedValidationDataToFileOnUpgrade();
        c.info(BES.c(18713, -22327) + bl);
        int n = BaseSignatureFormat.b;
        UniqueCertRevInfo uniqueCertRevInfo = this.d.trace(csi);
        int n2 = 0;
        for (ECertificate object22 : uniqueCertRevInfo.getCertificates()) {
            if (n2 != 0) {
                completeCertificateRefs.addCertificateReference(new CertID(this.mContext, object22, digestMethod));
            }
            ++n2;
            if (n == 0) continue;
            int n3 = BaseElement.b;
            BaseElement.b = ++n3;
            break;
        }
        for (ECRL eCRL : uniqueCertRevInfo.getCrls()) {
            object = null;
            if (bl) {
                object = eCRL.getIssuer().stringValue() + "_" + eCRL.getThisUpdate().getTime() + BES.c(18699, 24084);
                object = this.a(eCRL.getEncoded(), (String)object);
            }
            completeRevocationRefs.addCRLReference(new CRLReference(this.mContext, eCRL, digestMethod, (String)object));
            if (n == 0) continue;
        }
        for (EOCSPResponse eOCSPResponse : uniqueCertRevInfo.getOcspResponses()) {
            object = null;
            if (bl) {
                object = eOCSPResponse.getBasicOCSPResponse().getTbsResponseData().getResponderIdByName().stringValue() + "_" + eOCSPResponse.getBasicOCSPResponse().getProducedAt().getTime() + BES.c(18737, -30404);
                object = this.a(eOCSPResponse.getEncoded(), (String)object);
            }
            completeRevocationRefs.addOCSPReference(new OCSPReference(this.mContext, eOCSPResponse, digestMethod, (String)object));
            if (n == 0) continue;
        }
        QualifyingProperties qualifyingProperties = this.mSignature.createOrGetQualifyingProperties();
        UnsignedProperties unsignedProperties = qualifyingProperties.createOrGetUnsignedProperties();
        object = unsignedProperties.getUnsignedSignatureProperties();
        ((UnsignedSignatureProperties)object).setCompleteCertificateRefs(completeCertificateRefs);
        ((UnsignedSignatureProperties)object).setCompleteRevocationRefs(completeRevocationRefs);
    }

    protected void addValidationData() throws XMLSignatureException {
        block9: {
            CertificateStatusInfo certificateStatusInfo;
            block8: {
                certificateStatusInfo = this.mContext.getValidationResult(this.mSignature);
                int n = BaseSignatureFormat.b;
                if (certificateStatusInfo == null) {
                    ECertificate eCertificate = this.extractCertificate();
                    if (eCertificate == null) {
                        throw new XMLSignatureException(BES.c(18750, 18570));
                    }
                    ValidationResult validationResult = new ValidationDataCollector().collect(this.mSignature, true);
                    certificateStatusInfo = this._validateCertificate(eCertificate, this.mContext.getValidationTime(this.mSignature), true);
                    this.mContext.setValidationResult(this.mSignature, certificateStatusInfo);
                }
                if (certificateStatusInfo.getCertificateStatus() != CertificateStatus.VALID) break block8;
                this.addValidationData(certificateStatusInfo);
                if (n == 0) break block9;
            }
            c.warn(XmlSignUtil.verificationInfo(certificateStatusInfo));
            throw new XMLSignatureException(BES.c(18747, -24861));
        }
    }

    protected void addValidationData(CertificateStatusInfo csi) throws XMLSignatureException {
        Pair<CertificateValues, RevocationValues> pair = this.d.extractValidationDataFromCSI(this.mContext, csi);
        QualifyingProperties qualifyingProperties = this.mSignature.createOrGetQualifyingProperties();
        UnsignedProperties unsignedProperties = qualifyingProperties.createOrGetUnsignedProperties();
        UnsignedSignatureProperties unsignedSignatureProperties = unsignedProperties.getUnsignedSignatureProperties();
        unsignedSignatureProperties.setCertificateValues((CertificateValues)pair.getObject1());
        unsignedSignatureProperties.setRevocationValues((RevocationValues)pair.getObject2());
    }

    public void addTimestampValidationData(XAdESTimeStamp aXAdESTimeStamp, Calendar aValidationTime) throws XMLSignatureException {
        block23: {
            Object object;
            TimeStampValidationData timeStampValidationData;
            block22: {
                ValidationConfig validationConfig = this.mContext.getConfig().getValidationConfig();
                EncapsulatedTimeStamp encapsulatedTimeStamp = aXAdESTimeStamp.getEncapsulatedTimeStamp(0);
                timeStampValidationData = this.mContext.getValidationData(this.mSignature).getTSValidationDataForTS(aXAdESTimeStamp);
                if (timeStampValidationData == null) {
                    ESignedData eSignedData;
                    SignedDataValidationResult signedDataValidationResult;
                    block21: {
                        block19: {
                            object = encapsulatedTimeStamp.getContentInfo().getEncoded();
                            SignedDataValidation signedDataValidation = new SignedDataValidation();
                            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                            signedDataValidationResult = null;
                            try {
                                block20: {
                                    hashtable.put(AllEParameters.P_CERT_VALIDATION_POLICIES, validationConfig.getCertValidationPolicies());
                                    hashtable.put(AllEParameters.P_SIGNING_TIME, aValidationTime);
                                    hashtable.put(AllEParameters.P_GRACE_PERIOD, Long.valueOf(validationConfig.getGracePeriodInSeconds()));
                                    hashtable.put(AllEParameters.P_IGNORE_GRACE, true);
                                    hashtable.put(AllEParameters.P_REVOCINFO_PERIOD, Long.valueOf(validationConfig.getLastRevocationPeriodInSeconds()));
                                    hashtable.putAll(this.d.collectAllInitialValidationDataFromContextAsParams(this.mContext));
                                    c.debug(BES.c(18689, 23872) + aXAdESTimeStamp.getLocalName());
                                    signedDataValidationResult = signedDataValidation.verify((byte[])object, hashtable);
                                    c.debug(signedDataValidationResult.toString());
                                    if (signedDataValidationResult.getSDStatus() == SignedData_Status.ALL_VALID) break block19;
                                    boolean bl = false;
                                    if (signedDataValidationResult != null && signedDataValidationResult.getSDStatus() == SignedData_Status.ALL_VALID) break block20;
                                    c.debug(BES.c(18711, -6890));
                                    hashtable.put(AllEParameters.P_SIGNING_TIME, encapsulatedTimeStamp.getTime());
                                    signedDataValidationResult = signedDataValidation.verify((byte[])object, hashtable);
                                    bl = true;
                                }
                                if (signedDataValidationResult.getSDStatus() != SignedData_Status.ALL_VALID) {
                                    throw new XMLSignatureException(BES.c(18716, -19375));
                                }
                            }
                            catch (Exception exception) {
                                c.error(BES.c(18692, -3705), (Throwable)exception);
                                throw new XMLSignatureException(BES.c(18712, 32612), exception);
                            }
                        }
                        eSignedData = encapsulatedTimeStamp.getSignedData();
                        List list = eSignedData.getCertificates();
                        if (list != null && list.size() != 0) break block21;
                        throw new XMLSignatureException(BES.c(18706, 11216), aXAdESTimeStamp.getLocalName());
                    }
                    CertificateStatusInfo certificateStatusInfo = ((tr.gov.tubitak.uekae.esya.api.cmssignature.validation.SignatureValidationResult)signedDataValidationResult.getSDValidationResults().get(0)).getCertStatusInfo();
                    if (certificateStatusInfo.getCertificateStatus() != CertificateStatus.VALID) {
                        c.warn(BES.c(18748, 490));
                        c.info(XmlSignUtil.verificationInfo(certificateStatusInfo));
                        throw new XMLSignatureException(BES.c(18698, 19029));
                    }
                    Pair<CertificateValues, RevocationValues> pair = this.d.extractValidationDataFromCSI(this.mContext, certificateStatusInfo);
                    pair = this.d.removeDuplicateReferences(this.mContext, this.mSignature, (CertificateValues)pair.getObject1(), (RevocationValues)pair.getObject2(), eSignedData);
                    timeStampValidationData = new TimeStampValidationData(this.mContext, (CertificateValues)pair.getObject1(), (RevocationValues)pair.getObject2());
                }
                if (timeStampValidationData.getCertificateValues().getAllCertificates().size() != 0 || timeStampValidationData.getRevocationValues().getAllOCSPResponses().size() != 0) break block22;
                if (timeStampValidationData.getRevocationValues().getAllCRLs().size() == 0) break block23;
            }
            this.mContext.getValidationData(this.mSignature).addTSValidationData(aXAdESTimeStamp, timeStampValidationData);
            object = this.mSignature.getQualifyingProperties().createOrGetUnsignedProperties().getUnsignedSignatureProperties();
            ((UnsignedSignatureProperties)object).addTimeStampValidationData(timeStampValidationData, aXAdESTimeStamp);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String a(byte[] byArray, String string) throws XMLSignatureException {
        String string2 = null;
        FileOutputStream fileOutputStream = null;
        try {
            String string3 = this.mContext.getOutputDir();
            string2 = string.replaceAll(BES.c(18744, 12803), "_");
            string2 = string2 + BES.c(18751, -6157);
            fileOutputStream = new FileOutputStream(string3 + File.separator + string2);
            fileOutputStream.write(byArray);
            if (fileOutputStream == null) return string2;
        }
        catch (Exception exception) {
            try {
                c.error(BES.c(18688, -1137), (Throwable)exception);
                throw new XMLSignatureException(BES.c(18742, 21006) + string2);
            }
            catch (Throwable throwable) {
                if (fileOutputStream == null) throw throwable;
                try {
                    fileOutputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    c.error(BES.c(18708, 1456), (Throwable)iOException);
                }
                throw throwable;
            }
        }
        try {
            fileOutputStream.close();
            return string2;
        }
        catch (IOException iOException) {
            c.error(BES.c(18702, 7902), (Throwable)iOException);
            return string2;
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[48];
                var3_1 = 0;
                var2_2 = "\u0090\u0003\u0096$\u00e8x\u00afwTu\u0099\u00cbWt<\u000ex\u00d4\u00ffq\u00c6\u0085\u00a8\u00e2\u00e8\u00da\u001d\u0090\u00e6\u0081\u00bf\u00158\u007f\u00a6\u00c4Gx\u001c\u008a\u000b\u00f6\u00e8\u0014\u0080\u008cQK\u00bf&FIo{\u0085\u00faT\u00ff\u00e2\u00d3\u00f2\u00af\u00a9R\u00c8\u0000\u00a00\u00c7m3I~I\fmp\u00c5rA\u00e0\u0003t\u001a\u007f\u00b4\u00d2\u00b4p\u0096H/J(n\u00bch2x\u00ee_V/K\u0086]y\u00e9\u009f\u00f2\"\u00fdI\u00e9y\u00b2,@\u00e5\u0006\u00f6\u009d\u00ca\u00be\u0086\u000b \u00a3\u000b\u00c7g\"\u0016#\u00d0+\u0016\u001a$\u0084#C\u00e9\u00c5\u0081\u008a\\\u00f0\u00cdr.,\u00eaWw\u00a0\u00b3\u0000{\u00d3\u00b8\u001e@Gi\u00d5\u00bb'\u00bc\u009b\u0006F\u00f3\u00a4A\u009e\u0096\u00a3\u00ee\u0096\u00877\u0095\u0099\u000eU'\u00dd]\u00a0xFY\u00a3(z0\u0013\u00ca_n<\u008f[s\u007fnw\u00f7\u00ba 'V\u0016\u009d\u0013\u00d9p\u009b\u0013y\u00bd6Q.\u00e9G$i\u00e7\u001dEC\u0011G\u00cb\u001e)y\u00d9\u009b\u008f\u0014\u009a\u00d0\u0091\u00aa\u009dh\u00f8\u0011\u00b0`\u0096\u000b\u00c7\u00c4\u00a5\u00bb\u00ef\u00f5'\u00e9>\u00d4\u00a0\u00e9D\u009fG9\u00fbC\u00bd\u0018v\u00b6\u00b0\u00baP\u001bZ\"ov\u00cbA\u00f865|\u00b5\u00f9\u0000KcRQ,N\u00bd\u00e1\u00ce\u008c\u00f8x\u0092\u0005\u00e4\u00d0d\bK\u0090\u00ddr\u008e,\u00a7\u00fc\u00fa\u00d5\u0002\u00aeM\nu\u00b1l9>!\u001d\u00de\u00c4\u00c9\u00d75\u0085@w\u00af=x\n\u00b3s\u001a\u00cf\u0005\u00957\u00d0\u00c9\u00c8\u0013S?~\u00ea\u001c\u008a<\u0016\u00b4F\u00d2\u00fe\u00ac\u00c3\u00e7\u0089\n\u0085\u00bd\u00d6BRJG\u0085\u00bc\u00c0\u00ccC\u008a\u009f\u00f0\u000b\u00ca8\u007f\u0018\u00b6q.Z\u0080\u0094\u00dcmiQ\u0089\u0091h\u00b1\u009d<\u00bc\u00fb\u0091\u00a5\u00c8\u00d3\u000b5m\u00d7\\\u00fe\u00c6\u0090\u001c\u00afh\u00fbG\"\u00fcI@\u00f5\u00f8|\u0007=\u001bZ\u0088\u00b0\u001a@\u000f$OQ\u001e\u008d>\u00fb~$\u008d\u00ab\u00bf?\u00aa\u00f3X\u00a1\u00d7\u00c48\u0093\u00b2\u00f1F\u00f5/\u00f1\b\u0085\u00f1r\u0082\u000f\u00ce\u001dm\u0017\u00ca\u0083)\u00b8\u00cb\u00cdj\u007f\u001b\u001c\u00d1\u00c6\u0007Ns\r\u00df\u008c\u00e1\u00b7\u0084U\u00ea\"7\u001dw7@2\\B\u0097\u0007\u00e5660\u00f9y\u001a/\u00d0+\u00a0Qs\u0011*>\u001d\u0019\u0091\u00d1\u0086G\u00aa\u00fbMMWR\u0018\u00d7\u0011\u00a1*\u00b5\u00abVB\u00979N\u00b0R\u00e6\u00ba\u00ce\u00ed\u009e\u00c0\u00fc\u0004\u000b\u00ff\u0018\u000b\u00b3\u0091I(S\u00e8dW\u00d1\u00fe7\u0000:\u00f0\u0085\u0011\u0003$\u00ba~0\u00ddI\u00b7V\u0010\r\u00a5r9\u00e3\u009bN\u001fh\u00a5a#N[\u0015J .\u001a\u00cd\u00a0\u00d5_\u0011\u00e40\u0011\u0004\u0090\u0018\u001b\u00a7\u00a2\u00f8\u00dc|\u00b0\n\u000b\u00bf\u00be\u00f1 7\u00b6=G\u00faw\b\u00b5\u00acj\u00aa$\fa\u0018`/\u00a20\u00a3\u00a1\u0089~\u0088\u00ee\u00f7LH\u00f3|\u00a6o}\u00a5\u008c\u0016\u008a\u00b9}F\u00fd\u0018u\u00db\u009c\u00c5\u00f7[\u0018'\u0011\u00f6$\u00d6\u0094\u0014\u0010\u009eZ\ry_\u00d4\u0019\u001a\u00b6\u001aI\u0014r?\u009a\u00c8>F\u008c\u008c\u0088\u00da@S\u00af\u00b9x\u009a\u00b3a\u001a\u008d\u0005\u00b3\u001b\u00e4D\u00d9\u00b5\u00ad%q\u0015\u0003\u00b8F\u00afk\u008f\u00e5\u009b\u00e5\u00e2(\u00f2\u00d1\n>]\u0088\u00bc\u00c7&\u0098<\u001d\u00cd\u00fe\u00ad\u00d2j\u0086\u00bd\u0012\u00af\u00fd\u0019\u00f9?y\u00a4>\u0080-\u00c38\u001d\u00e3\u00afi\u00e1\u00f3\u00e9\u008c\u00cd\u00d3\t\u00b5\u00f0\u0011\u0015\u0011\u0003\u00fa\u0001b\u00b6\u008cU\u0014i9z\u0018\u00e1=a\u0085\u0011\u0004\u00ae~\u0096\u00c2(\u007f2\u00e1\fa\u0095!m\u00f8]\u00dd\u00a4\b\u0092\u00db\u00a8\u001c\u0007\u00cc\u00ec\u00e6{\u001b\u00c8\u00b0\u0094\u00bb.E\u00a9\tsM\u00f9\u00cb\u0000\u00a5!6C$\u00f1F0\u0082[DfW\u0010\u001a\u00c0H\u00ad\u008a\u00a5\u009aS\u001c\u00878\u0000\u00c5\u00bc\u00f9\t\u00c3\u0095\u00cc\u00d5\u00f8\u00ca\u00d7\u00b7 \u00e5\u00c2)L)\u0087o\u00ad\u00f9\u00b8\u00e0\u00cb\u00ec\u00bb\u0085\u00c8\\_\u0097\u00ad\u00b1\u00a4\"~\u0097R\u0082\u00ae\u00e9\u00ddY\u00db\u0092\u0085\u00b9M\u009a\u0010\u0001\u00eb\u00a49\u00a2\u00c7\u001c\u00aa\u007f4\u00d2\u0010\u00c7\u00c9\u0087\u00a8\u00c5&\u00d4\u00fb\u0090\u00c1b\u0000\u00bc\u00d5\u000f\u00b1\u0010+\u00be\u0018.\u00de\u00ce,\u00baI\u00f0\u00a0\u00d4\u008f\u0081k@F\u00f9{\u00a8\u008f\u001a<\u000fS\u00bb!\u00cc=\u001d^-\u00fd\u00cd\u0093\u0017\u00a7\u0015S_ RD\u00beO1\u00a2I\u00f4\u0088i\u001c$\u008c#\u0018\u00ae\u009e\u00db\u0092\u00a1\u00c7{I\u00e2\u008e\u000e\u00b9T\u00d3*\u0012i\u00ec\u00f8j\u00b8\u00b0]\u00af\f\u00b5\u00bf\u00f3\u00ca\u00e8\u00ca\u00d9\u00e8\u0016&\u00cdE}\u0007\u00b6\u007f\u0081\u00b4\u009dJ\u008c \u00c8\u00e1\u0080p<\u00a0R\u00e3\u00ed\u0081\u00f7\u0089\u00df\u00c5j\fa\u00f5ia\u00e1\u00d3\u00ce\u008a2k\u00fcl\u00e3;CJC\u00ff[\u000f\u00a0\u00ba\u008b\u008b\u0013\u0014'\u00fb\u00d5\u0006z\u00b3\u00b3\u00b0\u00cf\u0082[\u00d7\u00f4\u00c8\u0005\u00bc\u00c5\u009e\u00a1\u0096a\u00ae\u0000\u00e9\u00b7&\u00cb\u00db\u0001J\u00bd\u001b\u0007Yk\u00b4 g\u0096\u00f0r\u00d7\u00ac\u0092\u0081\u00e1`\u008f\u001c\u0096\u00b8\u0096\u000b\u008a\u00bfc\u0005\u00d1\u0091e\u00e2\u001f\u00b3\u00e1\u00ff\u00f8t\u00c3\u000f\u001b\u00d9\u00c0\u00c0\u00a4\u001a1zJ\u0004\u00e2\u008fN|\u00cb=\u00e1\u00ae\u0098\u0014\u001f\n\u0080j\u0095PL\u00d5\u008fM\u00f8\u001b\u0013\u00b0\u00f3<4\u00da\u0092V\u0081YW\b\u00a5\u0011\u0096d\u00e7\u00c1\u00af\u0000\fG\u00b3\u00adK#\u00fa\u00a0\u00ee9\u00e6(]\u0004\u0019pw\u00fa  \u00a2\n\u001e\u001c\u00d7\u008e%\rTc\u0092\u00d3\u00be<\u00cb\u00c1:)S\u00cf\u00b9dGhQ\u0005^\u00cey\u00ef\u00fe\u0004\u00e6\f\u008fR,0^\u0099\u009ch.\u00d9\u00eaV\u0002\u0081\u0004)\u00cbC}\u0001\u00e0K\u0090\u0084~\u00e4\u00f5\u00ff+\u00b4\u00de\u0083CCY\u00f1g\u0012B\u0097\u00bfU\n\u00e0\u00f83\u00bf)\u008c\t\u009fk\u00aey\u00d8\u00f0\u00c7\u00ee:\u00c5\u00f8TY\u0096m\u0091\u00bc&}\u00172\u0092\u00a2\u00eb\\\u0019\u00eb\u009a\u0083\u00b8\u008d\u00ba\b\u0005\u00e8$Y\u00b2\u00cb\u001a\u00f2\u0010??q'\u00adav\u0097\u0099\u00cf\u0091\u0088\u00e9\u00b8j (`\b\u00da\u0081\u00a4%d\u001c\u001f\u0019`\u0080\u008ej=Q\u00f2Oq\u00fb\u00bf\u00b4!\u0016\u00db\u00d7\u0087^K\u0092\u00ea\u00dfWq\u00b47\u0002\u008f\u00a0\u001b\u009dg,\u00bb\u00de\u00ca\u000fv\u008c\u0091\u00davB\u0085\u0019\u00b8\u0084\u00c4\u001d5\u001f\u0094\u008f3\u00b7~.$\u0086\u00b7O\u00bb\u00fd\u0091\u008cD\u008e\u00a2\u00f7\u00ad\u0015\u009f\u0018\u00e0u\u00aa\u00da6`\u00fbj\bfE\u00d1\u00e3\u00f8~\u001fEv_~\u00d1\u000f\u0092\u0018\u00cdT\u00e2 \u008d\u00d60\u00ab)\u00f4\u00a9zpn\u000eL\u001cE\u00e8\u00dc\u009fH\"nk\u009c\u00e1?Q\u00e3r3\u00f7\u00ed\u00a9w\u0095\u00e4\u0097ga\u00c5\u0092\u0090\u00e5\u00b0.\u00c9\u008e\u0003\u00bb\u00ed\u00a7Xo\u00dbk\u008f\u00e2\u0003\u00a9\u0098\u0081\u0093Q!\u00ad\u0095\u00c8\u00b8\u00f33=C\u001e\u00af\u0090\u009dx^\u00e2,=\u0017\u00d5\u0016_v&\u00af:\u009d\\Jfs\u00b7\u009b\u00cdq\u0001\u00afWj\u00d9{7{\u00a0W\u00839)\u00a7\u00be\u00e7\u00b2\u0098[\u00c5\u00ebGh\u0018\u001e\u00cf\u000f\u0098\u00dc\u0085\u0006{\u00bf\u00fe\u00c2\u00ec4\u00a2\u008c\u00ea\u00e1a\u00dev>\u00ab\u00b8\u00c9q\u00dfYB0\u009bT\tsj\u008c\u0094\u000e!_\u00b5\u00f9";
                var4_3 = "\u0090\u0003\u0096$\u00e8x\u00afwTu\u0099\u00cbWt<\u000ex\u00d4\u00ffq\u00c6\u0085\u00a8\u00e2\u00e8\u00da\u001d\u0090\u00e6\u0081\u00bf\u00158\u007f\u00a6\u00c4Gx\u001c\u008a\u000b\u00f6\u00e8\u0014\u0080\u008cQK\u00bf&FIo{\u0085\u00faT\u00ff\u00e2\u00d3\u00f2\u00af\u00a9R\u00c8\u0000\u00a00\u00c7m3I~I\fmp\u00c5rA\u00e0\u0003t\u001a\u007f\u00b4\u00d2\u00b4p\u0096H/J(n\u00bch2x\u00ee_V/K\u0086]y\u00e9\u009f\u00f2\"\u00fdI\u00e9y\u00b2,@\u00e5\u0006\u00f6\u009d\u00ca\u00be\u0086\u000b \u00a3\u000b\u00c7g\"\u0016#\u00d0+\u0016\u001a$\u0084#C\u00e9\u00c5\u0081\u008a\\\u00f0\u00cdr.,\u00eaWw\u00a0\u00b3\u0000{\u00d3\u00b8\u001e@Gi\u00d5\u00bb'\u00bc\u009b\u0006F\u00f3\u00a4A\u009e\u0096\u00a3\u00ee\u0096\u00877\u0095\u0099\u000eU'\u00dd]\u00a0xFY\u00a3(z0\u0013\u00ca_n<\u008f[s\u007fnw\u00f7\u00ba 'V\u0016\u009d\u0013\u00d9p\u009b\u0013y\u00bd6Q.\u00e9G$i\u00e7\u001dEC\u0011G\u00cb\u001e)y\u00d9\u009b\u008f\u0014\u009a\u00d0\u0091\u00aa\u009dh\u00f8\u0011\u00b0`\u0096\u000b\u00c7\u00c4\u00a5\u00bb\u00ef\u00f5'\u00e9>\u00d4\u00a0\u00e9D\u009fG9\u00fbC\u00bd\u0018v\u00b6\u00b0\u00baP\u001bZ\"ov\u00cbA\u00f865|\u00b5\u00f9\u0000KcRQ,N\u00bd\u00e1\u00ce\u008c\u00f8x\u0092\u0005\u00e4\u00d0d\bK\u0090\u00ddr\u008e,\u00a7\u00fc\u00fa\u00d5\u0002\u00aeM\nu\u00b1l9>!\u001d\u00de\u00c4\u00c9\u00d75\u0085@w\u00af=x\n\u00b3s\u001a\u00cf\u0005\u00957\u00d0\u00c9\u00c8\u0013S?~\u00ea\u001c\u008a<\u0016\u00b4F\u00d2\u00fe\u00ac\u00c3\u00e7\u0089\n\u0085\u00bd\u00d6BRJG\u0085\u00bc\u00c0\u00ccC\u008a\u009f\u00f0\u000b\u00ca8\u007f\u0018\u00b6q.Z\u0080\u0094\u00dcmiQ\u0089\u0091h\u00b1\u009d<\u00bc\u00fb\u0091\u00a5\u00c8\u00d3\u000b5m\u00d7\\\u00fe\u00c6\u0090\u001c\u00afh\u00fbG\"\u00fcI@\u00f5\u00f8|\u0007=\u001bZ\u0088\u00b0\u001a@\u000f$OQ\u001e\u008d>\u00fb~$\u008d\u00ab\u00bf?\u00aa\u00f3X\u00a1\u00d7\u00c48\u0093\u00b2\u00f1F\u00f5/\u00f1\b\u0085\u00f1r\u0082\u000f\u00ce\u001dm\u0017\u00ca\u0083)\u00b8\u00cb\u00cdj\u007f\u001b\u001c\u00d1\u00c6\u0007Ns\r\u00df\u008c\u00e1\u00b7\u0084U\u00ea\"7\u001dw7@2\\B\u0097\u0007\u00e5660\u00f9y\u001a/\u00d0+\u00a0Qs\u0011*>\u001d\u0019\u0091\u00d1\u0086G\u00aa\u00fbMMWR\u0018\u00d7\u0011\u00a1*\u00b5\u00abVB\u00979N\u00b0R\u00e6\u00ba\u00ce\u00ed\u009e\u00c0\u00fc\u0004\u000b\u00ff\u0018\u000b\u00b3\u0091I(S\u00e8dW\u00d1\u00fe7\u0000:\u00f0\u0085\u0011\u0003$\u00ba~0\u00ddI\u00b7V\u0010\r\u00a5r9\u00e3\u009bN\u001fh\u00a5a#N[\u0015J .\u001a\u00cd\u00a0\u00d5_\u0011\u00e40\u0011\u0004\u0090\u0018\u001b\u00a7\u00a2\u00f8\u00dc|\u00b0\n\u000b\u00bf\u00be\u00f1 7\u00b6=G\u00faw\b\u00b5\u00acj\u00aa$\fa\u0018`/\u00a20\u00a3\u00a1\u0089~\u0088\u00ee\u00f7LH\u00f3|\u00a6o}\u00a5\u008c\u0016\u008a\u00b9}F\u00fd\u0018u\u00db\u009c\u00c5\u00f7[\u0018'\u0011\u00f6$\u00d6\u0094\u0014\u0010\u009eZ\ry_\u00d4\u0019\u001a\u00b6\u001aI\u0014r?\u009a\u00c8>F\u008c\u008c\u0088\u00da@S\u00af\u00b9x\u009a\u00b3a\u001a\u008d\u0005\u00b3\u001b\u00e4D\u00d9\u00b5\u00ad%q\u0015\u0003\u00b8F\u00afk\u008f\u00e5\u009b\u00e5\u00e2(\u00f2\u00d1\n>]\u0088\u00bc\u00c7&\u0098<\u001d\u00cd\u00fe\u00ad\u00d2j\u0086\u00bd\u0012\u00af\u00fd\u0019\u00f9?y\u00a4>\u0080-\u00c38\u001d\u00e3\u00afi\u00e1\u00f3\u00e9\u008c\u00cd\u00d3\t\u00b5\u00f0\u0011\u0015\u0011\u0003\u00fa\u0001b\u00b6\u008cU\u0014i9z\u0018\u00e1=a\u0085\u0011\u0004\u00ae~\u0096\u00c2(\u007f2\u00e1\fa\u0095!m\u00f8]\u00dd\u00a4\b\u0092\u00db\u00a8\u001c\u0007\u00cc\u00ec\u00e6{\u001b\u00c8\u00b0\u0094\u00bb.E\u00a9\tsM\u00f9\u00cb\u0000\u00a5!6C$\u00f1F0\u0082[DfW\u0010\u001a\u00c0H\u00ad\u008a\u00a5\u009aS\u001c\u00878\u0000\u00c5\u00bc\u00f9\t\u00c3\u0095\u00cc\u00d5\u00f8\u00ca\u00d7\u00b7 \u00e5\u00c2)L)\u0087o\u00ad\u00f9\u00b8\u00e0\u00cb\u00ec\u00bb\u0085\u00c8\\_\u0097\u00ad\u00b1\u00a4\"~\u0097R\u0082\u00ae\u00e9\u00ddY\u00db\u0092\u0085\u00b9M\u009a\u0010\u0001\u00eb\u00a49\u00a2\u00c7\u001c\u00aa\u007f4\u00d2\u0010\u00c7\u00c9\u0087\u00a8\u00c5&\u00d4\u00fb\u0090\u00c1b\u0000\u00bc\u00d5\u000f\u00b1\u0010+\u00be\u0018.\u00de\u00ce,\u00baI\u00f0\u00a0\u00d4\u008f\u0081k@F\u00f9{\u00a8\u008f\u001a<\u000fS\u00bb!\u00cc=\u001d^-\u00fd\u00cd\u0093\u0017\u00a7\u0015S_ RD\u00beO1\u00a2I\u00f4\u0088i\u001c$\u008c#\u0018\u00ae\u009e\u00db\u0092\u00a1\u00c7{I\u00e2\u008e\u000e\u00b9T\u00d3*\u0012i\u00ec\u00f8j\u00b8\u00b0]\u00af\f\u00b5\u00bf\u00f3\u00ca\u00e8\u00ca\u00d9\u00e8\u0016&\u00cdE}\u0007\u00b6\u007f\u0081\u00b4\u009dJ\u008c \u00c8\u00e1\u0080p<\u00a0R\u00e3\u00ed\u0081\u00f7\u0089\u00df\u00c5j\fa\u00f5ia\u00e1\u00d3\u00ce\u008a2k\u00fcl\u00e3;CJC\u00ff[\u000f\u00a0\u00ba\u008b\u008b\u0013\u0014'\u00fb\u00d5\u0006z\u00b3\u00b3\u00b0\u00cf\u0082[\u00d7\u00f4\u00c8\u0005\u00bc\u00c5\u009e\u00a1\u0096a\u00ae\u0000\u00e9\u00b7&\u00cb\u00db\u0001J\u00bd\u001b\u0007Yk\u00b4 g\u0096\u00f0r\u00d7\u00ac\u0092\u0081\u00e1`\u008f\u001c\u0096\u00b8\u0096\u000b\u008a\u00bfc\u0005\u00d1\u0091e\u00e2\u001f\u00b3\u00e1\u00ff\u00f8t\u00c3\u000f\u001b\u00d9\u00c0\u00c0\u00a4\u001a1zJ\u0004\u00e2\u008fN|\u00cb=\u00e1\u00ae\u0098\u0014\u001f\n\u0080j\u0095PL\u00d5\u008fM\u00f8\u001b\u0013\u00b0\u00f3<4\u00da\u0092V\u0081YW\b\u00a5\u0011\u0096d\u00e7\u00c1\u00af\u0000\fG\u00b3\u00adK#\u00fa\u00a0\u00ee9\u00e6(]\u0004\u0019pw\u00fa  \u00a2\n\u001e\u001c\u00d7\u008e%\rTc\u0092\u00d3\u00be<\u00cb\u00c1:)S\u00cf\u00b9dGhQ\u0005^\u00cey\u00ef\u00fe\u0004\u00e6\f\u008fR,0^\u0099\u009ch.\u00d9\u00eaV\u0002\u0081\u0004)\u00cbC}\u0001\u00e0K\u0090\u0084~\u00e4\u00f5\u00ff+\u00b4\u00de\u0083CCY\u00f1g\u0012B\u0097\u00bfU\n\u00e0\u00f83\u00bf)\u008c\t\u009fk\u00aey\u00d8\u00f0\u00c7\u00ee:\u00c5\u00f8TY\u0096m\u0091\u00bc&}\u00172\u0092\u00a2\u00eb\\\u0019\u00eb\u009a\u0083\u00b8\u008d\u00ba\b\u0005\u00e8$Y\u00b2\u00cb\u001a\u00f2\u0010??q'\u00adav\u0097\u0099\u00cf\u0091\u0088\u00e9\u00b8j (`\b\u00da\u0081\u00a4%d\u001c\u001f\u0019`\u0080\u008ej=Q\u00f2Oq\u00fb\u00bf\u00b4!\u0016\u00db\u00d7\u0087^K\u0092\u00ea\u00dfWq\u00b47\u0002\u008f\u00a0\u001b\u009dg,\u00bb\u00de\u00ca\u000fv\u008c\u0091\u00davB\u0085\u0019\u00b8\u0084\u00c4\u001d5\u001f\u0094\u008f3\u00b7~.$\u0086\u00b7O\u00bb\u00fd\u0091\u008cD\u008e\u00a2\u00f7\u00ad\u0015\u009f\u0018\u00e0u\u00aa\u00da6`\u00fbj\bfE\u00d1\u00e3\u00f8~\u001fEv_~\u00d1\u000f\u0092\u0018\u00cdT\u00e2 \u008d\u00d60\u00ab)\u00f4\u00a9zpn\u000eL\u001cE\u00e8\u00dc\u009fH\"nk\u009c\u00e1?Q\u00e3r3\u00f7\u00ed\u00a9w\u0095\u00e4\u0097ga\u00c5\u0092\u0090\u00e5\u00b0.\u00c9\u008e\u0003\u00bb\u00ed\u00a7Xo\u00dbk\u008f\u00e2\u0003\u00a9\u0098\u0081\u0093Q!\u00ad\u0095\u00c8\u00b8\u00f33=C\u001e\u00af\u0090\u009dx^\u00e2,=\u0017\u00d5\u0016_v&\u00af:\u009d\\Jfs\u00b7\u009b\u00cdq\u0001\u00afWj\u00d9{7{\u00a0W\u00839)\u00a7\u00be\u00e7\u00b2\u0098[\u00c5\u00ebGh\u0018\u001e\u00cf\u000f\u0098\u00dc\u0085\u0006{\u00bf\u00fe\u00c2\u00ec4\u00a2\u008c\u00ea\u00e1a\u00dev>\u00ab\u00b8\u00c9q\u00dfYB0\u009bT\tsj\u008c\u0094\u000e!_\u00b5\u00f9".length();
                var1_4 = 38;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "]\u001e\u00f9\\\u0098\u001c\u00c4\u00b4\u0096\u00dc\u008f\u008f\u00fc.C5\u00aa\u00be\u00e7,\u0001n\u00db\u00c6-\u0094\u0089<\u00e4p;\u00f3-\u00c7";
                    var4_3 = "]\u001e\u00f9\\\u0098\u001c\u00c4\u00b4\u0096\u00dc\u008f\u008f\u00fc.C5\u00aa\u00be\u00e7,\u0001n\u00db\u00c6-\u0094\u0089<\u00e4p;\u00f3-\u00c7".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 117;
                            break;
                        }
                        case 1: {
                            v13 = 34;
                            break;
                        }
                        case 2: {
                            v13 = 116;
                            break;
                        }
                        case 3: {
                            v13 = 42;
                            break;
                        }
                        case 4: {
                            v13 = 86;
                            break;
                        }
                        case 5: {
                            v13 = 116;
                            break;
                        }
                        default: {
                            v13 = 91;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        BES.l = var5;
        BES.m = new String[48];
        BES.c = LoggerFactory.getLogger(BES.class);
    }

    private static String c(int n, int n2) {
        int n3 = (n ^ 0x491F) & 0xFFFF;
        if (m[n3] == null) {
            int n4;
            int n5;
            char[] cArray = l[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 174;
                    break;
                }
                case 1: {
                    n5 = 250;
                    break;
                }
                case 2: {
                    n5 = 141;
                    break;
                }
                case 3: {
                    n5 = 98;
                    break;
                }
                case 4: {
                    n5 = 251;
                    break;
                }
                case 5: {
                    n5 = 161;
                    break;
                }
                case 6: {
                    n5 = 21;
                    break;
                }
                case 7: {
                    n5 = 65;
                    break;
                }
                case 8: {
                    n5 = 139;
                    break;
                }
                case 9: {
                    n5 = 127;
                    break;
                }
                case 10: {
                    n5 = 217;
                    break;
                }
                case 11: {
                    n5 = 219;
                    break;
                }
                case 12: {
                    n5 = 121;
                    break;
                }
                case 13: {
                    n5 = 239;
                    break;
                }
                case 14: {
                    n5 = 168;
                    break;
                }
                case 15: {
                    n5 = 204;
                    break;
                }
                case 16: {
                    n5 = 154;
                    break;
                }
                case 17: {
                    n5 = 156;
                    break;
                }
                case 18: {
                    n5 = 153;
                    break;
                }
                case 19: {
                    n5 = 3;
                    break;
                }
                case 20: {
                    n5 = 188;
                    break;
                }
                case 21: {
                    n5 = 140;
                    break;
                }
                case 22: {
                    n5 = 238;
                    break;
                }
                case 23: {
                    n5 = 159;
                    break;
                }
                case 24: {
                    n5 = 76;
                    break;
                }
                case 25: {
                    n5 = 118;
                    break;
                }
                case 26: {
                    n5 = 109;
                    break;
                }
                case 27: {
                    n5 = 226;
                    break;
                }
                case 28: {
                    n5 = 26;
                    break;
                }
                case 29: {
                    n5 = 87;
                    break;
                }
                case 30: {
                    n5 = 158;
                    break;
                }
                case 31: {
                    n5 = 25;
                    break;
                }
                case 32: {
                    n5 = 144;
                    break;
                }
                case 33: {
                    n5 = 50;
                    break;
                }
                case 34: {
                    n5 = 218;
                    break;
                }
                case 35: {
                    n5 = 183;
                    break;
                }
                case 36: {
                    n5 = 138;
                    break;
                }
                case 37: {
                    n5 = 212;
                    break;
                }
                case 38: {
                    n5 = 128;
                    break;
                }
                case 39: {
                    n5 = 221;
                    break;
                }
                case 40: {
                    n5 = 54;
                    break;
                }
                case 41: {
                    n5 = 85;
                    break;
                }
                case 42: {
                    n5 = 61;
                    break;
                }
                case 43: {
                    n5 = 205;
                    break;
                }
                case 44: {
                    n5 = 73;
                    break;
                }
                case 45: {
                    n5 = 111;
                    break;
                }
                case 46: {
                    n5 = 74;
                    break;
                }
                case 47: {
                    n5 = 198;
                    break;
                }
                case 48: {
                    n5 = 86;
                    break;
                }
                case 49: {
                    n5 = 146;
                    break;
                }
                case 50: {
                    n5 = 24;
                    break;
                }
                case 51: {
                    n5 = 97;
                    break;
                }
                case 52: {
                    n5 = 1;
                    break;
                }
                case 53: {
                    n5 = 14;
                    break;
                }
                case 54: {
                    n5 = 115;
                    break;
                }
                case 55: {
                    n5 = 157;
                    break;
                }
                case 56: {
                    n5 = 64;
                    break;
                }
                case 57: {
                    n5 = 246;
                    break;
                }
                case 58: {
                    n5 = 123;
                    break;
                }
                case 59: {
                    n5 = 23;
                    break;
                }
                case 60: {
                    n5 = 52;
                    break;
                }
                case 61: {
                    n5 = 106;
                    break;
                }
                case 62: {
                    n5 = 33;
                    break;
                }
                case 63: {
                    n5 = 117;
                    break;
                }
                case 64: {
                    n5 = 16;
                    break;
                }
                case 65: {
                    n5 = 108;
                    break;
                }
                case 66: {
                    n5 = 172;
                    break;
                }
                case 67: {
                    n5 = 196;
                    break;
                }
                case 68: {
                    n5 = 182;
                    break;
                }
                case 69: {
                    n5 = 228;
                    break;
                }
                case 70: {
                    n5 = 245;
                    break;
                }
                case 71: {
                    n5 = 36;
                    break;
                }
                case 72: {
                    n5 = 165;
                    break;
                }
                case 73: {
                    n5 = 133;
                    break;
                }
                case 74: {
                    n5 = 82;
                    break;
                }
                case 75: {
                    n5 = 29;
                    break;
                }
                case 76: {
                    n5 = 195;
                    break;
                }
                case 77: {
                    n5 = 9;
                    break;
                }
                case 78: {
                    n5 = 179;
                    break;
                }
                case 79: {
                    n5 = 255;
                    break;
                }
                case 80: {
                    n5 = 231;
                    break;
                }
                case 81: {
                    n5 = 96;
                    break;
                }
                case 82: {
                    n5 = 92;
                    break;
                }
                case 83: {
                    n5 = 237;
                    break;
                }
                case 84: {
                    n5 = 81;
                    break;
                }
                case 85: {
                    n5 = 103;
                    break;
                }
                case 86: {
                    n5 = 6;
                    break;
                }
                case 87: {
                    n5 = 60;
                    break;
                }
                case 88: {
                    n5 = 194;
                    break;
                }
                case 89: {
                    n5 = 66;
                    break;
                }
                case 90: {
                    n5 = 206;
                    break;
                }
                case 91: {
                    n5 = 58;
                    break;
                }
                case 92: {
                    n5 = 227;
                    break;
                }
                case 93: {
                    n5 = 125;
                    break;
                }
                case 94: {
                    n5 = 185;
                    break;
                }
                case 95: {
                    n5 = 105;
                    break;
                }
                case 96: {
                    n5 = 209;
                    break;
                }
                case 97: {
                    n5 = 104;
                    break;
                }
                case 98: {
                    n5 = 213;
                    break;
                }
                case 99: {
                    n5 = 230;
                    break;
                }
                case 100: {
                    n5 = 253;
                    break;
                }
                case 101: {
                    n5 = 215;
                    break;
                }
                case 102: {
                    n5 = 222;
                    break;
                }
                case 103: {
                    n5 = 147;
                    break;
                }
                case 104: {
                    n5 = 134;
                    break;
                }
                case 105: {
                    n5 = 132;
                    break;
                }
                case 106: {
                    n5 = 136;
                    break;
                }
                case 107: {
                    n5 = 155;
                    break;
                }
                case 108: {
                    n5 = 177;
                    break;
                }
                case 109: {
                    n5 = 243;
                    break;
                }
                case 110: {
                    n5 = 119;
                    break;
                }
                case 111: {
                    n5 = 89;
                    break;
                }
                case 112: {
                    n5 = 37;
                    break;
                }
                case 113: {
                    n5 = 220;
                    break;
                }
                case 114: {
                    n5 = 71;
                    break;
                }
                case 115: {
                    n5 = 70;
                    break;
                }
                case 116: {
                    n5 = 55;
                    break;
                }
                case 117: {
                    n5 = 95;
                    break;
                }
                case 118: {
                    n5 = 181;
                    break;
                }
                case 119: {
                    n5 = 27;
                    break;
                }
                case 120: {
                    n5 = 152;
                    break;
                }
                case 121: {
                    n5 = 200;
                    break;
                }
                case 122: {
                    n5 = 162;
                    break;
                }
                case 123: {
                    n5 = 242;
                    break;
                }
                case 124: {
                    n5 = 148;
                    break;
                }
                case 125: {
                    n5 = 22;
                    break;
                }
                case 126: {
                    n5 = 88;
                    break;
                }
                case 127: {
                    n5 = 170;
                    break;
                }
                case 128: {
                    n5 = 211;
                    break;
                }
                case 129: {
                    n5 = 41;
                    break;
                }
                case 130: {
                    n5 = 49;
                    break;
                }
                case 131: {
                    n5 = 145;
                    break;
                }
                case 132: {
                    n5 = 7;
                    break;
                }
                case 133: {
                    n5 = 197;
                    break;
                }
                case 134: {
                    n5 = 68;
                    break;
                }
                case 135: {
                    n5 = 122;
                    break;
                }
                case 136: {
                    n5 = 252;
                    break;
                }
                case 137: {
                    n5 = 12;
                    break;
                }
                case 138: {
                    n5 = 130;
                    break;
                }
                case 139: {
                    n5 = 100;
                    break;
                }
                case 140: {
                    n5 = 143;
                    break;
                }
                case 141: {
                    n5 = 207;
                    break;
                }
                case 142: {
                    n5 = 48;
                    break;
                }
                case 143: {
                    n5 = 131;
                    break;
                }
                case 144: {
                    n5 = 190;
                    break;
                }
                case 145: {
                    n5 = 10;
                    break;
                }
                case 146: {
                    n5 = 150;
                    break;
                }
                case 147: {
                    n5 = 166;
                    break;
                }
                case 148: {
                    n5 = 63;
                    break;
                }
                case 149: {
                    n5 = 247;
                    break;
                }
                case 150: {
                    n5 = 135;
                    break;
                }
                case 151: {
                    n5 = 15;
                    break;
                }
                case 152: {
                    n5 = 51;
                    break;
                }
                case 153: {
                    n5 = 129;
                    break;
                }
                case 154: {
                    n5 = 4;
                    break;
                }
                case 155: {
                    n5 = 107;
                    break;
                }
                case 156: {
                    n5 = 39;
                    break;
                }
                case 157: {
                    n5 = 43;
                    break;
                }
                case 158: {
                    n5 = 149;
                    break;
                }
                case 159: {
                    n5 = 175;
                    break;
                }
                case 160: {
                    n5 = 176;
                    break;
                }
                case 161: {
                    n5 = 235;
                    break;
                }
                case 162: {
                    n5 = 19;
                    break;
                }
                case 163: {
                    n5 = 234;
                    break;
                }
                case 164: {
                    n5 = 78;
                    break;
                }
                case 165: {
                    n5 = 30;
                    break;
                }
                case 166: {
                    n5 = 101;
                    break;
                }
                case 167: {
                    n5 = 240;
                    break;
                }
                case 168: {
                    n5 = 199;
                    break;
                }
                case 169: {
                    n5 = 248;
                    break;
                }
                case 170: {
                    n5 = 40;
                    break;
                }
                case 171: {
                    n5 = 214;
                    break;
                }
                case 172: {
                    n5 = 56;
                    break;
                }
                case 173: {
                    n5 = 90;
                    break;
                }
                case 174: {
                    n5 = 35;
                    break;
                }
                case 175: {
                    n5 = 236;
                    break;
                }
                case 176: {
                    n5 = 254;
                    break;
                }
                case 177: {
                    n5 = 223;
                    break;
                }
                case 178: {
                    n5 = 124;
                    break;
                }
                case 179: {
                    n5 = 83;
                    break;
                }
                case 180: {
                    n5 = 225;
                    break;
                }
                case 181: {
                    n5 = 224;
                    break;
                }
                case 182: {
                    n5 = 201;
                    break;
                }
                case 183: {
                    n5 = 38;
                    break;
                }
                case 184: {
                    n5 = 137;
                    break;
                }
                case 185: {
                    n5 = 184;
                    break;
                }
                case 186: {
                    n5 = 69;
                    break;
                }
                case 187: {
                    n5 = 249;
                    break;
                }
                case 188: {
                    n5 = 102;
                    break;
                }
                case 189: {
                    n5 = 208;
                    break;
                }
                case 190: {
                    n5 = 32;
                    break;
                }
                case 191: {
                    n5 = 91;
                    break;
                }
                case 192: {
                    n5 = 2;
                    break;
                }
                case 193: {
                    n5 = 210;
                    break;
                }
                case 194: {
                    n5 = 191;
                    break;
                }
                case 195: {
                    n5 = 151;
                    break;
                }
                case 196: {
                    n5 = 229;
                    break;
                }
                case 197: {
                    n5 = 173;
                    break;
                }
                case 198: {
                    n5 = 232;
                    break;
                }
                case 199: {
                    n5 = 110;
                    break;
                }
                case 200: {
                    n5 = 18;
                    break;
                }
                case 201: {
                    n5 = 57;
                    break;
                }
                case 202: {
                    n5 = 0;
                    break;
                }
                case 203: {
                    n5 = 241;
                    break;
                }
                case 204: {
                    n5 = 193;
                    break;
                }
                case 205: {
                    n5 = 126;
                    break;
                }
                case 206: {
                    n5 = 67;
                    break;
                }
                case 207: {
                    n5 = 44;
                    break;
                }
                case 208: {
                    n5 = 11;
                    break;
                }
                case 209: {
                    n5 = 216;
                    break;
                }
                case 210: {
                    n5 = 192;
                    break;
                }
                case 211: {
                    n5 = 79;
                    break;
                }
                case 212: {
                    n5 = 178;
                    break;
                }
                case 213: {
                    n5 = 8;
                    break;
                }
                case 214: {
                    n5 = 28;
                    break;
                }
                case 215: {
                    n5 = 99;
                    break;
                }
                case 216: {
                    n5 = 80;
                    break;
                }
                case 217: {
                    n5 = 62;
                    break;
                }
                case 218: {
                    n5 = 116;
                    break;
                }
                case 219: {
                    n5 = 31;
                    break;
                }
                case 220: {
                    n5 = 17;
                    break;
                }
                case 221: {
                    n5 = 114;
                    break;
                }
                case 222: {
                    n5 = 72;
                    break;
                }
                case 223: {
                    n5 = 120;
                    break;
                }
                case 224: {
                    n5 = 171;
                    break;
                }
                case 225: {
                    n5 = 202;
                    break;
                }
                case 226: {
                    n5 = 34;
                    break;
                }
                case 227: {
                    n5 = 13;
                    break;
                }
                case 228: {
                    n5 = 47;
                    break;
                }
                case 229: {
                    n5 = 164;
                    break;
                }
                case 230: {
                    n5 = 189;
                    break;
                }
                case 231: {
                    n5 = 42;
                    break;
                }
                case 232: {
                    n5 = 20;
                    break;
                }
                case 233: {
                    n5 = 244;
                    break;
                }
                case 234: {
                    n5 = 77;
                    break;
                }
                case 235: {
                    n5 = 53;
                    break;
                }
                case 236: {
                    n5 = 5;
                    break;
                }
                case 237: {
                    n5 = 45;
                    break;
                }
                case 238: {
                    n5 = 160;
                    break;
                }
                case 239: {
                    n5 = 169;
                    break;
                }
                case 240: {
                    n5 = 46;
                    break;
                }
                case 241: {
                    n5 = 233;
                    break;
                }
                case 242: {
                    n5 = 167;
                    break;
                }
                case 243: {
                    n5 = 94;
                    break;
                }
                case 244: {
                    n5 = 163;
                    break;
                }
                case 245: {
                    n5 = 187;
                    break;
                }
                case 246: {
                    n5 = 203;
                    break;
                }
                case 247: {
                    n5 = 180;
                    break;
                }
                case 248: {
                    n5 = 142;
                    break;
                }
                case 249: {
                    n5 = 84;
                    break;
                }
                case 250: {
                    n5 = 93;
                    break;
                }
                case 251: {
                    n5 = 186;
                    break;
                }
                case 252: {
                    n5 = 59;
                    break;
                }
                case 253: {
                    n5 = 75;
                    break;
                }
                case 254: {
                    n5 = 112;
                    break;
                }
                default: {
                    n5 = 113;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            BES.m[n3] = new String(cArray).intern();
        }
        return m[n3];
    }
}

