/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.xmlsignature.formats;

import java.security.Key;
import java.security.PublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectPublicKeyInfo;
import tr.gov.tubitak.uekae.esya.api.common.crypto.BaseSigner;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.C14nMethod;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.Context;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.SignatureMethod;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.SignatureValidationResult;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResult;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResultType;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignature;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignatureException;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.algorithms.XmlSignatureAlgorithm;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.formats.SignatureFormat;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.BaseElement;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.Manifest;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.Reference;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.SignedInfo;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.keyinfo.KeyValue;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.keyinfo.X509Data;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.keyinfo.x509.X509Certificate;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.util.I18n;

public abstract class BaseSignatureFormat
implements SignatureFormat {
    private static Logger a;
    protected XMLSignature mSignature;
    protected Context mContext;
    public static int b;
    private static final String[] h;
    private static final String[] i;

    protected BaseSignatureFormat(Context aContext, XMLSignature aSignature) {
        this.mContext = aContext;
        this.mSignature = aSignature;
    }

    protected DigestAlg getDigestAlgorithmUrl() {
        return this.mSignature.getSignedInfo().getSignatureMethod().getDigestAlg();
    }

    protected C14nMethod getC14nMethod() {
        return this.mSignature.getSignedInfo().getCanonicalizationMethod();
    }

    protected SignatureMethod getSignatureMethod() {
        return this.mSignature.getSignedInfo().getSignatureMethod();
    }

    protected void digestReferences(Manifest aReferences) throws XMLSignatureException {
        a.info(BaseSignatureFormat.a(25779, -15050) + aReferences);
        int n = b;
        for (int i = 0; i < aReferences.getReferenceCount(); ++i) {
            Reference reference = aReferences.getReference(i);
            reference.generateDigestValue();
            Manifest manifest = reference.getReferencedManifest();
            if (manifest == null) continue;
            a.info(BaseSignatureFormat.a(25784, -14463) + manifest);
            this.digestReferences(manifest);
            continue;
        }
    }

    @Override
    public SignatureValidationResult validateCore() throws XMLSignatureException {
        PublicKey publicKey = this.mSignature.getKeyInfo().resolvePublicKey();
        if (publicKey == null) {
            throw new XMLSignatureException(BaseSignatureFormat.a(25788, -26365));
        }
        return this.validateCore(publicKey);
    }

    @Override
    public SignatureValidationResult validateCore(Key aKey) throws XMLSignatureException {
        SignatureValidationResult signatureValidationResult;
        block11: {
            block10: {
                XmlSignatureAlgorithm xmlSignatureAlgorithm;
                a.debug(BaseSignatureFormat.a(25763, -15554));
                signatureValidationResult = new SignatureValidationResult();
                signatureValidationResult.setVerifierClass(XMLSignature.class);
                int n = b;
                SignedInfo signedInfo = this.mSignature.getSignedInfo();
                try {
                    xmlSignatureAlgorithm = this.getSignatureMethod().getSignatureImpl();
                    xmlSignatureAlgorithm.initVerify(aKey, signedInfo.getSignatureAlgorithmParameters());
                }
                catch (Exception exception) {
                    a.warn(BaseSignatureFormat.a(25790, -8044), (Throwable)exception);
                    signatureValidationResult.setStatus(ValidationResultType.INVALID, exception.getMessage());
                    return signatureValidationResult;
                }
                byte[] byArray = signedInfo.getCanonicalizedBytes();
                a.debug(BaseSignatureFormat.a(25769, -27677) + StringUtil.toHexString((byte[])byArray));
                xmlSignatureAlgorithm.update(byArray);
                if (a.isDebugEnabled()) {
                    this.debugSign(signedInfo, byArray, aKey);
                }
                boolean bl = xmlSignatureAlgorithm.verify(this.mSignature.getSignatureValue());
                if (!bl) {
                    String string = I18n.translate(BaseSignatureFormat.a(25764, 28701), new Object[0]);
                    a.info(string);
                    signatureValidationResult.setStatus(ValidationResultType.INVALID, string);
                    return signatureValidationResult;
                }
                signatureValidationResult.addItem(new ValidationResult(ValidationResultType.VALID, I18n.translate(BaseSignatureFormat.a(25776, 1943), new Object[0]), I18n.translate(BaseSignatureFormat.a(25765, -14143), new Object[0]), null, XMLSignature.class));
                a.info(BaseSignatureFormat.a(25781, -29790));
                ValidationResult validationResult = this.validateReferences(this.mSignature.getSignedInfo());
                signatureValidationResult.addItem(validationResult);
                if (validationResult.getType() == ValidationResultType.VALID) break block10;
                signatureValidationResult.setStatus(validationResult.getType(), I18n.translate(BaseSignatureFormat.a(25782, 10477), new Object[0]));
                if (n == 0) break block11;
            }
            signatureValidationResult.setStatus(ValidationResultType.VALID, I18n.translate(BaseSignatureFormat.a(25785, 5673), new Object[0]));
        }
        return signatureValidationResult;
    }

    @Override
    public SignatureValidationResult validateCore(ECertificate aCertificate) throws XMLSignatureException {
        try {
            return this.validateCore(KeyUtil.decodePublicKey((ESubjectPublicKeyInfo)aCertificate.getSubjectPublicKeyInfo()));
        }
        catch (CryptoException cryptoException) {
            throw new XMLSignatureException(cryptoException, BaseSignatureFormat.a(25762, -14089), aCertificate.getSubjectPublicKeyInfo(), BaseSignatureFormat.a(25767, 18652));
        }
    }

    protected ValidationResult validateReferences(Manifest aReferences) throws XMLSignatureException {
        a.info(BaseSignatureFormat.a(25786, 12816) + aReferences);
        int n = b;
        for (int i = 0; i < aReferences.getReferenceCount(); ++i) {
            Object object;
            Reference reference = aReferences.getReference(i);
            boolean bl = false;
            Exception exception = null;
            try {
                bl = reference.validateDigestValue();
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (!bl) {
                object = new ValidationResult(ValidationResultType.INVALID, I18n.translate(BaseSignatureFormat.a(25775, -2219), new Object[0]), I18n.translate(BaseSignatureFormat.a(25770, 19337), reference.getURI()), null, XMLSignature.class);
                if (exception != null) {
                    ((ValidationResult)object).setMessage(((ValidationResult)object).getMessage() + BaseSignatureFormat.a(25768, -8800) + exception.getMessage());
                }
                return object;
            }
            if (!this.mContext.isValidateManifests() || (object = reference.getReferencedManifest()) == null) continue;
            a.info(BaseSignatureFormat.a(25772, -7203) + object);
            ValidationResult validationResult = this.validateReferences((Manifest)object);
            if (validationResult.getType() == ValidationResultType.VALID) continue;
            return validationResult;
        }
        a.info(BaseSignatureFormat.a(25780, -19480));
        return new ValidationResult(ValidationResultType.VALID, I18n.translate(BaseSignatureFormat.a(25773, 24806), new Object[0]), I18n.translate(BaseSignatureFormat.a(25789, -14734), new Object[0]), null, this.getClass());
    }

    @Override
    public XMLSignature sign(BaseSigner aSigner) throws XMLSignatureException {
        this.digestReferences(this.mSignature.getSignedInfo());
        int n = b;
        SignatureMethod signatureMethod = null;
        try {
            SignedInfo signedInfo = this.mSignature.getSignedInfo();
            String string = signedInfo.getSignatureMethod().getSignatureImpl().getAlgorithmName();
            String string2 = aSigner.getSignatureAlgorithmStr();
            signatureMethod = SignatureMethod.fromAlgorithmAndParams(string2, aSigner.getAlgorithmParameterSpec());
            if (signatureMethod == null) {
                throw new XMLSignatureException(BaseSignatureFormat.a(25766, 12908), string2);
            }
            if (!string.equals(string2)) {
                a.warn(BaseSignatureFormat.a(25760, 23140) + string + BaseSignatureFormat.a(25783, -29844) + string2);
                signedInfo.setSignatureMethod(signatureMethod);
            }
            byte[] byArray = this.mSignature.getSignedInfo().getCanonicalizedBytes();
            this.debugSign(signedInfo, byArray, aSigner.getClass());
            byte[] byArray2 = aSigner.sign(byArray);
            this.mSignature.setSignatureValue(byArray2);
        }
        catch (Exception exception) {
            throw new XMLSignatureException(exception, BaseSignatureFormat.a(25777, 26966));
        }
        XMLSignature xMLSignature = this.mSignature;
        if (BaseElement.b != 0) {
            b = ++n;
        }
        return xMLSignature;
    }

    protected void fillSignatureValue(Key aKey) throws XMLSignatureException {
        try {
            SignedInfo signedInfo = this.mSignature.getSignedInfo();
            SignatureMethod signatureMethod = signedInfo.getSignatureMethod();
            XmlSignatureAlgorithm xmlSignatureAlgorithm = signatureMethod.getSignatureImpl();
            xmlSignatureAlgorithm.initSign(aKey, signedInfo.getSignatureAlgorithmParameters());
            byte[] byArray = this.mSignature.getSignedInfo().getCanonicalizedBytes();
            if (a.isDebugEnabled()) {
                this.debugSign(signedInfo, byArray, aKey.getClass());
            }
            xmlSignatureAlgorithm.update(byArray);
            byte[] byArray2 = xmlSignatureAlgorithm.sign();
            this.mSignature.setSignatureValue(byArray2);
        }
        catch (Exception exception) {
            throw new XMLSignatureException(exception, BaseSignatureFormat.a(25778, -3937));
        }
    }

    protected void debugSign(SignedInfo si, byte[] canoned, Object aKey) {
        if (a.isDebugEnabled()) {
            a.debug(BaseSignatureFormat.a(25774, -32012) + si.getCanonicalizationMethod().getURL());
            a.debug(BaseSignatureFormat.a(25761, 29657) + si.getSignatureMethod().getUrl());
            a.debug(BaseSignatureFormat.a(25787, 21681) + new String(canoned));
            a.debug(BaseSignatureFormat.a(25771, 29024) + aKey);
        }
    }

    @Override
    public void addKeyInfo(ECertificate aCertificate) {
        X509Data x509Data = new X509Data(this.mContext);
        X509Certificate x509Certificate = new X509Certificate(this.mContext, aCertificate);
        x509Data.add(x509Certificate);
        this.mSignature.createOrGetKeyInfo().add(x509Data);
    }

    @Override
    public void addKeyInfo(PublicKey pk) throws XMLSignatureException {
        KeyValue keyValue = new KeyValue(this.mContext, pk);
        this.mSignature.createOrGetKeyInfo().add(keyValue);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[31];
                var3_1 = 0;
                var2_2 = "Dt\u0002\u00dcf\u00bc\u00d6\"'\u008c8\u001cC\u0000\u00c0Bn\rJJ\u00e7\u001b\u00f6Ul6[\u0013\u00b1|\u00c2\u0011\u00b6\f\u00b9\u00aa\u00b5T\u0086\u00c9\u0019\u008cb\u00ba#\u00da\u00ffs\u00cc\u000ed\u00a0\u00a8H\\\u00dc5\u008e?\u00af\u00d4D\u008d\u00b8\u001e7\u0012O\u00dd7\u00e1N`\u00b3-\u0091\u0087b\u0088L\u00d6x \u00b9\u00de\u00ff1\u0084zV\u00e9\u0092\u00efW:\u001c\u00fa\u0091\u00f6\u00ad\u0000\u00fa\u00ac\u00a8v\u009b\u009bp\u00a3\u00cb\u00d2\u00b8\u00f4E\u00b8\u008f\rD\\6[\u00fa\u00a3\u00f9\u0011\u00ae\u0017\u00b1W\u0093\u00ce\u00bcS\u00169\u0090e\u001be\u0016\u00c3\u0081\t$\u00d1h\u00f5\u0086\u00cc\u00fd\u00ce\u00a7\tH+\u00f3d\b^PN\u00ca.}HL]\u00fe\u0096\u0097\u00a2\u00ef\u00aaoN%c'3\u00af_\u00d7\u00bb\u0082g\u00dc\u000e\nr\u00f4)\u0081\u00ab\u000f\u00cd\b*\u0007\u00e3\u0082\u00f9\u00c1Y\u0095w\u00bc$\u00b0\u00c1\u0019:\u0094\u00ee\r\u0003\u00fb\u00c8#cE\u008b\u008a!)$\u00e2t\u00aa\u0018\t\u00f9\u00b0.h{\u0006\u009f\u00faX\u00ce\u00ab-\u000fc52\u00faO\u008e\u0012Q<b\u00b4_\u008av\u00f5\u001a\u00a2\u00b7T\u00aa\u00c3\u0080\u00c6\t\u000e\u00df\u0015\u00f7\u00d1\u00b6\u00017\u00d5\u00ea\u00f8\u00f7\u0091\u001b\u00dd\u00e5i\u00b6\u0007\u00a80\u00fa\u0007\u0001\u0089\u0006\u001a\t\u0080!Lm\\\u0013\u0092\u00b4\u00acB\u0099;{\\\u008e~\u00dd\u008d\u0011?\u00c7\b~\u00d3\u00c5\u001f\u0016\u00ed\u00c2\u00e1\u0011\u00e9\u009c$Ez|C\u00fc \u00a4\u00e5a\u00b1b\u00bcD@\u001c\u00e4s\u00ee\u00f4WS\u0091: o*D\u00daV\u0001b|6\u00bb%\u00fcz)\u0011\u00dcc\u00cb\t)]2\u0002E\u0000\u00ecN\u00d5\\\tg\u00dd y\u00da\u0086\u00c4\u000e\u00c2i\u0004W\u00b4\t\u001d\u00ff\u0015\u00a1[u;\u00cb7\u0005\u00f1\t=a\u00e3b4\u00d95\u00d7Z\u0017^\u009e\u00b4\u008a\u00a2\u001c\u0002* \u0012\u0085\u00cf\u001aw\u00a6\u0001R\u00f2@\u00d2\u00c3@?\u0015\u00e7\u00e3V\u00a8\u00deI\u00ab\u00be\u00f0\u007f\u008fHD\u00ff\u00919\u00c3\u00c3\u009c\u0016V\u001a\f\u00b3\u000b$G\u00a3\u00f2\u00c1\u00a3\u00f0\u00b3\u0097R\u00e8\u00f3\u00a5\u0015\u0089\u00ba\u00e5\u00f0\u00a4\u00c1h\u00de&\u000f\u00b4\u00ff?`9V\u008f\u0096\u008b\u00f3\u0096\\\u0082\u00f3P:\u00b2\u00ab\u00c9\u0080\u0004\t\u00d1W\u00ae\u009c:\u001a\u0003O\u00cf\u0085?\u0085\u00c6l \u00a6\nz\u0013mC5G\u00d8\u0084(E\u0004\u00d9\u00c9\u0095\u00caX\u00f3\u00f0\u007f\u00a0S\u008b\u00c8L\u00a4\u00d1\u0083\u0097u0~\u008a\u00a5F6\u001a\u00ffp\u0080W$\u00a7\u00d2]:\u00fc\u00d2\u0018u\u00cd,y\u00d4\u0012\u00f8\u0096\u00f8\u00ce\u0085\u00b0\u00ef\u0000\r\u00f4\u00e97\u00a28\u001b\u00ab\u0094\u0096\u001c\u0087\u0080 \u0017u\u00d8\u0094\u00c3\u0004\u00b5a\u00b3L!\b\u00a9\u00ab\u00bb\u0090\u0098\u0094\u00c1\u0098\u00b4\u00d8\u008c\\\u0010\u00f1/v\u00b1\u00d0\u00e8tA\u00ef1b-\\O\u0080\u00ae \u00b8f\u00beS\t0\u0089ZKn\u008ej\u0087\u001e9\u0004eG\u00ee\u00d2_=\u0085\u00ba\u00ed\u00e0i\u00ab:\u00ffU\u00dc";
                var4_3 = "Dt\u0002\u00dcf\u00bc\u00d6\"'\u008c8\u001cC\u0000\u00c0Bn\rJJ\u00e7\u001b\u00f6Ul6[\u0013\u00b1|\u00c2\u0011\u00b6\f\u00b9\u00aa\u00b5T\u0086\u00c9\u0019\u008cb\u00ba#\u00da\u00ffs\u00cc\u000ed\u00a0\u00a8H\\\u00dc5\u008e?\u00af\u00d4D\u008d\u00b8\u001e7\u0012O\u00dd7\u00e1N`\u00b3-\u0091\u0087b\u0088L\u00d6x \u00b9\u00de\u00ff1\u0084zV\u00e9\u0092\u00efW:\u001c\u00fa\u0091\u00f6\u00ad\u0000\u00fa\u00ac\u00a8v\u009b\u009bp\u00a3\u00cb\u00d2\u00b8\u00f4E\u00b8\u008f\rD\\6[\u00fa\u00a3\u00f9\u0011\u00ae\u0017\u00b1W\u0093\u00ce\u00bcS\u00169\u0090e\u001be\u0016\u00c3\u0081\t$\u00d1h\u00f5\u0086\u00cc\u00fd\u00ce\u00a7\tH+\u00f3d\b^PN\u00ca.}HL]\u00fe\u0096\u0097\u00a2\u00ef\u00aaoN%c'3\u00af_\u00d7\u00bb\u0082g\u00dc\u000e\nr\u00f4)\u0081\u00ab\u000f\u00cd\b*\u0007\u00e3\u0082\u00f9\u00c1Y\u0095w\u00bc$\u00b0\u00c1\u0019:\u0094\u00ee\r\u0003\u00fb\u00c8#cE\u008b\u008a!)$\u00e2t\u00aa\u0018\t\u00f9\u00b0.h{\u0006\u009f\u00faX\u00ce\u00ab-\u000fc52\u00faO\u008e\u0012Q<b\u00b4_\u008av\u00f5\u001a\u00a2\u00b7T\u00aa\u00c3\u0080\u00c6\t\u000e\u00df\u0015\u00f7\u00d1\u00b6\u00017\u00d5\u00ea\u00f8\u00f7\u0091\u001b\u00dd\u00e5i\u00b6\u0007\u00a80\u00fa\u0007\u0001\u0089\u0006\u001a\t\u0080!Lm\\\u0013\u0092\u00b4\u00acB\u0099;{\\\u008e~\u00dd\u008d\u0011?\u00c7\b~\u00d3\u00c5\u001f\u0016\u00ed\u00c2\u00e1\u0011\u00e9\u009c$Ez|C\u00fc \u00a4\u00e5a\u00b1b\u00bcD@\u001c\u00e4s\u00ee\u00f4WS\u0091: o*D\u00daV\u0001b|6\u00bb%\u00fcz)\u0011\u00dcc\u00cb\t)]2\u0002E\u0000\u00ecN\u00d5\\\tg\u00dd y\u00da\u0086\u00c4\u000e\u00c2i\u0004W\u00b4\t\u001d\u00ff\u0015\u00a1[u;\u00cb7\u0005\u00f1\t=a\u00e3b4\u00d95\u00d7Z\u0017^\u009e\u00b4\u008a\u00a2\u001c\u0002* \u0012\u0085\u00cf\u001aw\u00a6\u0001R\u00f2@\u00d2\u00c3@?\u0015\u00e7\u00e3V\u00a8\u00deI\u00ab\u00be\u00f0\u007f\u008fHD\u00ff\u00919\u00c3\u00c3\u009c\u0016V\u001a\f\u00b3\u000b$G\u00a3\u00f2\u00c1\u00a3\u00f0\u00b3\u0097R\u00e8\u00f3\u00a5\u0015\u0089\u00ba\u00e5\u00f0\u00a4\u00c1h\u00de&\u000f\u00b4\u00ff?`9V\u008f\u0096\u008b\u00f3\u0096\\\u0082\u00f3P:\u00b2\u00ab\u00c9\u0080\u0004\t\u00d1W\u00ae\u009c:\u001a\u0003O\u00cf\u0085?\u0085\u00c6l \u00a6\nz\u0013mC5G\u00d8\u0084(E\u0004\u00d9\u00c9\u0095\u00caX\u00f3\u00f0\u007f\u00a0S\u008b\u00c8L\u00a4\u00d1\u0083\u0097u0~\u008a\u00a5F6\u001a\u00ffp\u0080W$\u00a7\u00d2]:\u00fc\u00d2\u0018u\u00cd,y\u00d4\u0012\u00f8\u0096\u00f8\u00ce\u0085\u00b0\u00ef\u0000\r\u00f4\u00e97\u00a28\u001b\u00ab\u0094\u0096\u001c\u0087\u0080 \u0017u\u00d8\u0094\u00c3\u0004\u00b5a\u00b3L!\b\u00a9\u00ab\u00bb\u0090\u0098\u0094\u00c1\u0098\u00b4\u00d8\u008c\\\u0010\u00f1/v\u00b1\u00d0\u00e8tA\u00ef1b-\\O\u0080\u00ae \u00b8f\u00beS\t0\u0089ZKn\u008ej\u0087\u001e9\u0004eG\u00ee\u00d2_=\u0085\u00ba\u00ed\u00e0i\u00ab:\u00ffU\u00dc".length();
                var1_4 = 17;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "R\u00fe\u00e3@\u00a2C\u00f8\u000f\u00f0\u00ed\u00ca#\u0003\u0080!\u00db\u009f\u000fU\u00b9x.\u00c9\u001e\u00ff\u0001\u00e4{\u0005R\u00a1\u00f4\u0095\u0000\u00ae-`\u00fe\u0019\u00d2W|\f\u0095t\u00b7E\u009c\u00aa\u00f9Y\u00f2K\u00a9";
                    var4_3 = "R\u00fe\u00e3@\u00a2C\u00f8\u000f\u00f0\u00ed\u00ca#\u0003\u0080!\u00db\u009f\u000fU\u00b9x.\u00c9\u001e\u00ff\u0001\u00e4{\u0005R\u00a1\u00f4\u0095\u0000\u00ae-`\u00fe\u0019\u00d2W|\f\u0095t\u00b7E\u009c\u00aa\u00f9Y\u00f2K\u00a9".length();
                    var1_4 = 23;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 87;
                            break;
                        }
                        case 1: {
                            v13 = 43;
                            break;
                        }
                        case 2: {
                            v13 = 62;
                            break;
                        }
                        case 3: {
                            v13 = 29;
                            break;
                        }
                        case 4: {
                            v13 = 11;
                            break;
                        }
                        case 5: {
                            v13 = 83;
                            break;
                        }
                        default: {
                            v13 = 67;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        BaseSignatureFormat.h = var5;
        BaseSignatureFormat.i = new String[31];
        BaseSignatureFormat.a = LoggerFactory.getLogger(BaseSignatureFormat.class);
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0x64A0) & 0xFFFF;
        if (i[n3] == null) {
            int n4;
            int n5;
            char[] cArray = h[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 59;
                    break;
                }
                case 1: {
                    n5 = 1;
                    break;
                }
                case 2: {
                    n5 = 80;
                    break;
                }
                case 3: {
                    n5 = 247;
                    break;
                }
                case 4: {
                    n5 = 169;
                    break;
                }
                case 5: {
                    n5 = 12;
                    break;
                }
                case 6: {
                    n5 = 102;
                    break;
                }
                case 7: {
                    n5 = 35;
                    break;
                }
                case 8: {
                    n5 = 46;
                    break;
                }
                case 9: {
                    n5 = 233;
                    break;
                }
                case 10: {
                    n5 = 144;
                    break;
                }
                case 11: {
                    n5 = 209;
                    break;
                }
                case 12: {
                    n5 = 37;
                    break;
                }
                case 13: {
                    n5 = 210;
                    break;
                }
                case 14: {
                    n5 = 157;
                    break;
                }
                case 15: {
                    n5 = 222;
                    break;
                }
                case 16: {
                    n5 = 38;
                    break;
                }
                case 17: {
                    n5 = 128;
                    break;
                }
                case 18: {
                    n5 = 216;
                    break;
                }
                case 19: {
                    n5 = 36;
                    break;
                }
                case 20: {
                    n5 = 101;
                    break;
                }
                case 21: {
                    n5 = 192;
                    break;
                }
                case 22: {
                    n5 = 186;
                    break;
                }
                case 23: {
                    n5 = 130;
                    break;
                }
                case 24: {
                    n5 = 204;
                    break;
                }
                case 25: {
                    n5 = 116;
                    break;
                }
                case 26: {
                    n5 = 20;
                    break;
                }
                case 27: {
                    n5 = 232;
                    break;
                }
                case 28: {
                    n5 = 254;
                    break;
                }
                case 29: {
                    n5 = 107;
                    break;
                }
                case 30: {
                    n5 = 55;
                    break;
                }
                case 31: {
                    n5 = 139;
                    break;
                }
                case 32: {
                    n5 = 108;
                    break;
                }
                case 33: {
                    n5 = 103;
                    break;
                }
                case 34: {
                    n5 = 156;
                    break;
                }
                case 35: {
                    n5 = 207;
                    break;
                }
                case 36: {
                    n5 = 84;
                    break;
                }
                case 37: {
                    n5 = 106;
                    break;
                }
                case 38: {
                    n5 = 42;
                    break;
                }
                case 39: {
                    n5 = 47;
                    break;
                }
                case 40: {
                    n5 = 219;
                    break;
                }
                case 41: {
                    n5 = 218;
                    break;
                }
                case 42: {
                    n5 = 113;
                    break;
                }
                case 43: {
                    n5 = 255;
                    break;
                }
                case 44: {
                    n5 = 237;
                    break;
                }
                case 45: {
                    n5 = 225;
                    break;
                }
                case 46: {
                    n5 = 82;
                    break;
                }
                case 47: {
                    n5 = 89;
                    break;
                }
                case 48: {
                    n5 = 220;
                    break;
                }
                case 49: {
                    n5 = 174;
                    break;
                }
                case 50: {
                    n5 = 76;
                    break;
                }
                case 51: {
                    n5 = 217;
                    break;
                }
                case 52: {
                    n5 = 100;
                    break;
                }
                case 53: {
                    n5 = 246;
                    break;
                }
                case 54: {
                    n5 = 164;
                    break;
                }
                case 55: {
                    n5 = 8;
                    break;
                }
                case 56: {
                    n5 = 251;
                    break;
                }
                case 57: {
                    n5 = 208;
                    break;
                }
                case 58: {
                    n5 = 214;
                    break;
                }
                case 59: {
                    n5 = 17;
                    break;
                }
                case 60: {
                    n5 = 141;
                    break;
                }
                case 61: {
                    n5 = 126;
                    break;
                }
                case 62: {
                    n5 = 135;
                    break;
                }
                case 63: {
                    n5 = 132;
                    break;
                }
                case 64: {
                    n5 = 74;
                    break;
                }
                case 65: {
                    n5 = 96;
                    break;
                }
                case 66: {
                    n5 = 242;
                    break;
                }
                case 67: {
                    n5 = 78;
                    break;
                }
                case 68: {
                    n5 = 5;
                    break;
                }
                case 69: {
                    n5 = 77;
                    break;
                }
                case 70: {
                    n5 = 51;
                    break;
                }
                case 71: {
                    n5 = 145;
                    break;
                }
                case 72: {
                    n5 = 226;
                    break;
                }
                case 73: {
                    n5 = 86;
                    break;
                }
                case 74: {
                    n5 = 29;
                    break;
                }
                case 75: {
                    n5 = 15;
                    break;
                }
                case 76: {
                    n5 = 143;
                    break;
                }
                case 77: {
                    n5 = 25;
                    break;
                }
                case 78: {
                    n5 = 221;
                    break;
                }
                case 79: {
                    n5 = 142;
                    break;
                }
                case 80: {
                    n5 = 19;
                    break;
                }
                case 81: {
                    n5 = 110;
                    break;
                }
                case 82: {
                    n5 = 245;
                    break;
                }
                case 83: {
                    n5 = 75;
                    break;
                }
                case 84: {
                    n5 = 39;
                    break;
                }
                case 85: {
                    n5 = 176;
                    break;
                }
                case 86: {
                    n5 = 98;
                    break;
                }
                case 87: {
                    n5 = 180;
                    break;
                }
                case 88: {
                    n5 = 65;
                    break;
                }
                case 89: {
                    n5 = 228;
                    break;
                }
                case 90: {
                    n5 = 178;
                    break;
                }
                case 91: {
                    n5 = 154;
                    break;
                }
                case 92: {
                    n5 = 231;
                    break;
                }
                case 93: {
                    n5 = 111;
                    break;
                }
                case 94: {
                    n5 = 45;
                    break;
                }
                case 95: {
                    n5 = 122;
                    break;
                }
                case 96: {
                    n5 = 26;
                    break;
                }
                case 97: {
                    n5 = 53;
                    break;
                }
                case 98: {
                    n5 = 34;
                    break;
                }
                case 99: {
                    n5 = 57;
                    break;
                }
                case 100: {
                    n5 = 104;
                    break;
                }
                case 101: {
                    n5 = 69;
                    break;
                }
                case 102: {
                    n5 = 244;
                    break;
                }
                case 103: {
                    n5 = 155;
                    break;
                }
                case 104: {
                    n5 = 18;
                    break;
                }
                case 105: {
                    n5 = 68;
                    break;
                }
                case 106: {
                    n5 = 146;
                    break;
                }
                case 107: {
                    n5 = 215;
                    break;
                }
                case 108: {
                    n5 = 152;
                    break;
                }
                case 109: {
                    n5 = 123;
                    break;
                }
                case 110: {
                    n5 = 64;
                    break;
                }
                case 111: {
                    n5 = 160;
                    break;
                }
                case 112: {
                    n5 = 241;
                    break;
                }
                case 113: {
                    n5 = 236;
                    break;
                }
                case 114: {
                    n5 = 252;
                    break;
                }
                case 115: {
                    n5 = 185;
                    break;
                }
                case 116: {
                    n5 = 85;
                    break;
                }
                case 117: {
                    n5 = 71;
                    break;
                }
                case 118: {
                    n5 = 93;
                    break;
                }
                case 119: {
                    n5 = 131;
                    break;
                }
                case 120: {
                    n5 = 81;
                    break;
                }
                case 121: {
                    n5 = 14;
                    break;
                }
                case 122: {
                    n5 = 187;
                    break;
                }
                case 123: {
                    n5 = 183;
                    break;
                }
                case 124: {
                    n5 = 13;
                    break;
                }
                case 125: {
                    n5 = 114;
                    break;
                }
                case 126: {
                    n5 = 235;
                    break;
                }
                case 127: {
                    n5 = 112;
                    break;
                }
                case 128: {
                    n5 = 151;
                    break;
                }
                case 129: {
                    n5 = 129;
                    break;
                }
                case 130: {
                    n5 = 124;
                    break;
                }
                case 131: {
                    n5 = 32;
                    break;
                }
                case 132: {
                    n5 = 205;
                    break;
                }
                case 133: {
                    n5 = 213;
                    break;
                }
                case 134: {
                    n5 = 61;
                    break;
                }
                case 135: {
                    n5 = 166;
                    break;
                }
                case 136: {
                    n5 = 197;
                    break;
                }
                case 137: {
                    n5 = 21;
                    break;
                }
                case 138: {
                    n5 = 7;
                    break;
                }
                case 139: {
                    n5 = 182;
                    break;
                }
                case 140: {
                    n5 = 181;
                    break;
                }
                case 141: {
                    n5 = 4;
                    break;
                }
                case 142: {
                    n5 = 94;
                    break;
                }
                case 143: {
                    n5 = 140;
                    break;
                }
                case 144: {
                    n5 = 240;
                    break;
                }
                case 145: {
                    n5 = 56;
                    break;
                }
                case 146: {
                    n5 = 58;
                    break;
                }
                case 147: {
                    n5 = 161;
                    break;
                }
                case 148: {
                    n5 = 230;
                    break;
                }
                case 149: {
                    n5 = 172;
                    break;
                }
                case 150: {
                    n5 = 28;
                    break;
                }
                case 151: {
                    n5 = 159;
                    break;
                }
                case 152: {
                    n5 = 2;
                    break;
                }
                case 153: {
                    n5 = 27;
                    break;
                }
                case 154: {
                    n5 = 31;
                    break;
                }
                case 155: {
                    n5 = 72;
                    break;
                }
                case 156: {
                    n5 = 249;
                    break;
                }
                case 157: {
                    n5 = 191;
                    break;
                }
                case 158: {
                    n5 = 201;
                    break;
                }
                case 159: {
                    n5 = 136;
                    break;
                }
                case 160: {
                    n5 = 133;
                    break;
                }
                case 161: {
                    n5 = 138;
                    break;
                }
                case 162: {
                    n5 = 223;
                    break;
                }
                case 163: {
                    n5 = 105;
                    break;
                }
                case 164: {
                    n5 = 97;
                    break;
                }
                case 165: {
                    n5 = 60;
                    break;
                }
                case 166: {
                    n5 = 239;
                    break;
                }
                case 167: {
                    n5 = 95;
                    break;
                }
                case 168: {
                    n5 = 149;
                    break;
                }
                case 169: {
                    n5 = 33;
                    break;
                }
                case 170: {
                    n5 = 211;
                    break;
                }
                case 171: {
                    n5 = 43;
                    break;
                }
                case 172: {
                    n5 = 193;
                    break;
                }
                case 173: {
                    n5 = 243;
                    break;
                }
                case 174: {
                    n5 = 184;
                    break;
                }
                case 175: {
                    n5 = 158;
                    break;
                }
                case 176: {
                    n5 = 6;
                    break;
                }
                case 177: {
                    n5 = 90;
                    break;
                }
                case 178: {
                    n5 = 73;
                    break;
                }
                case 179: {
                    n5 = 117;
                    break;
                }
                case 180: {
                    n5 = 148;
                    break;
                }
                case 181: {
                    n5 = 202;
                    break;
                }
                case 182: {
                    n5 = 23;
                    break;
                }
                case 183: {
                    n5 = 199;
                    break;
                }
                case 184: {
                    n5 = 62;
                    break;
                }
                case 185: {
                    n5 = 171;
                    break;
                }
                case 186: {
                    n5 = 22;
                    break;
                }
                case 187: {
                    n5 = 70;
                    break;
                }
                case 188: {
                    n5 = 177;
                    break;
                }
                case 189: {
                    n5 = 200;
                    break;
                }
                case 190: {
                    n5 = 3;
                    break;
                }
                case 191: {
                    n5 = 11;
                    break;
                }
                case 192: {
                    n5 = 234;
                    break;
                }
                case 193: {
                    n5 = 175;
                    break;
                }
                case 194: {
                    n5 = 173;
                    break;
                }
                case 195: {
                    n5 = 196;
                    break;
                }
                case 196: {
                    n5 = 147;
                    break;
                }
                case 197: {
                    n5 = 125;
                    break;
                }
                case 198: {
                    n5 = 212;
                    break;
                }
                case 199: {
                    n5 = 203;
                    break;
                }
                case 200: {
                    n5 = 189;
                    break;
                }
                case 201: {
                    n5 = 248;
                    break;
                }
                case 202: {
                    n5 = 238;
                    break;
                }
                case 203: {
                    n5 = 206;
                    break;
                }
                case 204: {
                    n5 = 227;
                    break;
                }
                case 205: {
                    n5 = 40;
                    break;
                }
                case 206: {
                    n5 = 163;
                    break;
                }
                case 207: {
                    n5 = 150;
                    break;
                }
                case 208: {
                    n5 = 153;
                    break;
                }
                case 209: {
                    n5 = 121;
                    break;
                }
                case 210: {
                    n5 = 66;
                    break;
                }
                case 211: {
                    n5 = 10;
                    break;
                }
                case 212: {
                    n5 = 9;
                    break;
                }
                case 213: {
                    n5 = 83;
                    break;
                }
                case 214: {
                    n5 = 190;
                    break;
                }
                case 215: {
                    n5 = 168;
                    break;
                }
                case 216: {
                    n5 = 253;
                    break;
                }
                case 217: {
                    n5 = 50;
                    break;
                }
                case 218: {
                    n5 = 118;
                    break;
                }
                case 219: {
                    n5 = 92;
                    break;
                }
                case 220: {
                    n5 = 162;
                    break;
                }
                case 221: {
                    n5 = 87;
                    break;
                }
                case 222: {
                    n5 = 195;
                    break;
                }
                case 223: {
                    n5 = 48;
                    break;
                }
                case 224: {
                    n5 = 41;
                    break;
                }
                case 225: {
                    n5 = 115;
                    break;
                }
                case 226: {
                    n5 = 165;
                    break;
                }
                case 227: {
                    n5 = 109;
                    break;
                }
                case 228: {
                    n5 = 52;
                    break;
                }
                case 229: {
                    n5 = 167;
                    break;
                }
                case 230: {
                    n5 = 54;
                    break;
                }
                case 231: {
                    n5 = 170;
                    break;
                }
                case 232: {
                    n5 = 188;
                    break;
                }
                case 233: {
                    n5 = 79;
                    break;
                }
                case 234: {
                    n5 = 134;
                    break;
                }
                case 235: {
                    n5 = 250;
                    break;
                }
                case 236: {
                    n5 = 179;
                    break;
                }
                case 237: {
                    n5 = 127;
                    break;
                }
                case 238: {
                    n5 = 30;
                    break;
                }
                case 239: {
                    n5 = 119;
                    break;
                }
                case 240: {
                    n5 = 67;
                    break;
                }
                case 241: {
                    n5 = 91;
                    break;
                }
                case 242: {
                    n5 = 44;
                    break;
                }
                case 243: {
                    n5 = 194;
                    break;
                }
                case 244: {
                    n5 = 198;
                    break;
                }
                case 245: {
                    n5 = 99;
                    break;
                }
                case 246: {
                    n5 = 24;
                    break;
                }
                case 247: {
                    n5 = 16;
                    break;
                }
                case 248: {
                    n5 = 120;
                    break;
                }
                case 249: {
                    n5 = 224;
                    break;
                }
                case 250: {
                    n5 = 63;
                    break;
                }
                case 251: {
                    n5 = 0;
                    break;
                }
                case 252: {
                    n5 = 229;
                    break;
                }
                case 253: {
                    n5 = 137;
                    break;
                }
                case 254: {
                    n5 = 49;
                    break;
                }
                default: {
                    n5 = 88;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            BaseSignatureFormat.i[n3] = new String(cArray).intern();
        }
        return i[n3];
    }
}

