/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;
import javax.smartcardio.TerminalFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.MA3APIEnvironment;
import tr.gov.tubitak.uekae.esya.api.common.crypto.Algorithms;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.smartcard.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.smartcard.bundle.SmartCardI18n;
import tr.gov.tubitak.uekae.esya.api.smartcard.keyfinder.ModulusFinderFromObjectID;
import tr.gov.tubitak.uekae.esya.api.smartcard.keyfinder.PublicKeyFinderWithLabel;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.Application;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.ISmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCard;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.KeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.EncryptionSchemeFactory;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.IEncryptionScheme;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.ISignatureScheme;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.scheme.SignatureSchemeFactory;

public class SmartOp {
    private long a;
    private CardType b;
    private String c;
    private static Logger d;
    private static final String[] e;
    private static final String[] f;

    public SmartOp(long aSlotID, CardType aCardType, String aPassword) {
        this();
        this.initialize(aSlotID, aCardType, aPassword);
    }

    public SmartOp() {
        try {
            LV.getInstance().checkLD(LV.Urunler.AKILLIKART);
        }
        catch (LE lE) {
            throw new RuntimeException(SmartOp.a(-2023, 2472) + lE.getMessage(), lE);
        }
    }

    public void initialize(long aSlotID, CardType aCardType, String aPassword) {
        this.a = aSlotID;
        this.b = aCardType;
        this.c = aPassword;
    }

    public static boolean _in(long aElement, long[] aList) {
        boolean bl = CardType.b;
        if (aList == null) {
            return false;
        }
        for (int i = 0; i < aList.length; ++i) {
            if (aList[i] != aElement) continue;
            return true;
        }
        return false;
    }

    public static Pair<Long, CardType> findCardTypeAndSlot(Application aApp) throws SmartCardException {
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            List<CardTerminal> list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
            int n = list.size();
            String string = "";
            CardTerminal cardTerminal = null;
            while (true) {
                if (n == 0) {
                    throw new SmartCardException(SmartOp.a(-2026, 3715));
                }
                if (n == 1) {
                    string = list.get(0).getName();
                    cardTerminal = list.get(0);
                    break;
                }
                int n2 = 0;
                n2 = SmartOp.a(list);
                if (n2 != -1) {
                    string = list.get(n2).getName();
                    cardTerminal = terminalFactory.terminals().getTerminal(string);
                    break;
                }
                list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
                n = list.size();
            }
            Card card = cardTerminal.connect("*");
            String string2 = SmartOp.a(card.getATR().getBytes());
            card.disconnect(false);
            CardType cardType = CardType.getCardTypeFromATR(string2, aApp);
            if (cardType == CardType.UNKNOWN) {
                return new Pair(null, (Object)cardType);
            }
            Long l = null;
            try {
                l = SmartOp.a(cardType, string);
            }
            catch (Exception exception) {
                d.warn(SmartOp.a(-2014, 20563), (Throwable)exception);
                l = null;
            }
            return new Pair((Object)l, (Object)cardType);
        }
        catch (SmartCardException smartCardException) {
            throw smartCardException;
        }
        catch (Exception exception) {
            throw new SmartCardException(SmartOp.a(-1986, -18810), exception);
        }
    }

    public static List<Pair<Long, CardType>> findCardTypesAndSlots(Application aApp) throws SmartCardException {
        boolean bl = CardType.b;
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            List<CardTerminal> list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
            int n = list.size();
            if (n == 0) {
                throw new SmartCardException(SmartOp.a(-2010, -16948));
            }
            ArrayList<Pair<Long, CardType>> arrayList = new ArrayList<Pair<Long, CardType>>();
            for (CardTerminal cardTerminal : list) {
                block11: {
                    CardType cardType;
                    String string;
                    block10: {
                        string = cardTerminal.getName();
                        Card card = cardTerminal.connect("*");
                        String string2 = SmartOp.a(card.getATR().getBytes());
                        card.disconnect(false);
                        cardType = SmartCard.findCardType(string2, aApp);
                        if (cardType != CardType.UNKNOWN) break block10;
                        arrayList.add((Pair<Long, CardType>)new Pair(null, (Object)cardType));
                        if (!bl) break block11;
                    }
                    Long l = null;
                    try {
                        l = SmartOp.a(cardType, string);
                    }
                    catch (Exception exception) {
                        d.warn(SmartOp.a(-2014, 20563), (Throwable)exception);
                        l = null;
                    }
                    arrayList.add((Pair<Long, CardType>)new Pair((Object)l, (Object)cardType));
                }
                if (!bl) continue;
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new SmartCardException(SmartOp.a(-1985, -30600), exception);
        }
    }

    public static Pair<Long, CardType> findCardTypeAndSlot() throws SmartCardException {
        return SmartOp.findCardTypeAndSlot(Application.ESIGNATURE);
    }

    public static List<Pair<Long, CardType>> findCardTypesAndSlots() throws SmartCardException {
        return SmartOp.findCardTypesAndSlots(Application.ESIGNATURE);
    }

    private static List<CardTerminal> a(TerminalFactory terminalFactory, CardTerminals.State state) throws CardException {
        return SmartOp.a(terminalFactory, state, true);
    }

    private static List<CardTerminal> a(TerminalFactory terminalFactory, CardTerminals.State state, boolean bl) throws CardException {
        ArrayList<CardTerminal> arrayList = new ArrayList();
        try {
            arrayList = terminalFactory.terminals().list(state);
        }
        catch (CardException cardException) {
            block11: {
                if (!bl || cardException.getCause() == null) break block11;
                if (!SmartOp.a(-1988, 11791).equals(cardException.getCause().getMessage())) break block11;
                SmartOp.a();
                return SmartOp.a(terminalFactory, state, false);
            }
            if (!cardException.getCause().getMessage().contains(SmartOp.a(-2012, 2002))) {
                throw cardException;
            }
        }
        return arrayList;
    }

    private static void a() {
        try {
            d.warn(SmartOp.a(-2007, -26569));
            Class<?> clazz = Class.forName(SmartOp.a(-2027, -30178));
            Field field = clazz.getDeclaredField(SmartOp.a(-2024, 8418));
            field.setAccessible(true);
            if (field.getLong(clazz) != 0L) {
                Class<?> clazz2 = Class.forName(SmartOp.a(-2048, 7279));
                Method method = clazz2.getDeclaredMethod(SmartOp.a(-2013, 10195), Integer.TYPE);
                method.setAccessible(true);
                Field field2 = clazz2.getDeclaredField(SmartOp.a(-2045, 11063));
                field2.setAccessible(true);
                long l = (Long)method.invoke(clazz2, field2.getInt(clazz2));
                field.setLong(clazz, l);
                TerminalFactory terminalFactory = TerminalFactory.getDefault();
                CardTerminals cardTerminals = terminalFactory.terminals();
                Field field3 = clazz.getDeclaredField(SmartOp.a(-2000, -6304));
                field3.setAccessible(true);
                Class<?> clazz3 = Class.forName(SmartOp.a(-2017, 12512));
                Method method2 = clazz3.getDeclaredMethod(SmartOp.a(-2041, 10277), new Class[0]);
                method2.invoke(field3.get(cardTerminals), new Object[0]);
                Field field4 = clazz.getDeclaredField(SmartOp.a(-2008, 13018));
                field4.setAccessible(true);
                method2.invoke(field4.get(cardTerminals), new Object[0]);
                d.info(SmartOp.a(-2042, 31698));
            }
        }
        catch (Exception exception) {
            d.warn(SmartOp.a(-2002, -23197), (Throwable)exception);
        }
    }

    private static int a(List<CardTerminal> list) {
        int n = list.size();
        boolean bl = CardType.b;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = list.get(i).getName();
            if (!bl) continue;
        }
        return SmartOp.secenekSor(null, null, stringArray, SmartOp.a(-2018, -13098), new String[]{SmartCardI18n.getMsg(E_KEYS.OK, null)});
    }

    private static long a(CardType cardType, String string) throws PKCS11Exception, IOException {
        SmartCard smartCard = new SmartCard(cardType);
        long[] lArray = smartCard.getTokenPresentSlotList();
        long l = 0L;
        boolean bl = CardType.b;
        for (long l2 : lArray) {
            String string2 = new String(smartCard.getSlotInfo((long)l2).slotDescription).trim();
            if (!string.contains(string2)) continue;
            l = l2;
            if (!bl) break;
            if (!bl) continue;
            break;
        }
        return l;
    }

    private static String a(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        boolean bl = CardType.b;
        if (byArray == null) {
            return SmartOp.a(-2046, 9189);
        }
        if (byArray.length == 0) {
            return SmartOp.a(-2028, -29248);
        }
        byte[] byArray2 = new byte[byArray.length * 2];
        int n = 0;
        for (byte by : byArray) {
            byArray2[n++] = (byte)cArray[(by & 0xF0) >> 4];
            byArray2[n++] = (byte)cArray[by & 0xF];
            if (!bl) continue;
            break;
        }
        return new String(byArray2);
    }

    public static String[] getCardTerminals() throws SmartCardException {
        boolean bl = CardType.b;
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            List<CardTerminal> list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = list.get(i).getName();
                if (!bl) continue;
            }
            return stringArray;
        }
        catch (CardException cardException) {
            throw new SmartCardException(SmartOp.a(-1994, 31627), cardException);
        }
    }

    public static String[] getCardATRs() throws SmartCardException {
        String[] stringArray = null;
        boolean bl = CardType.b;
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            List<CardTerminal> list = SmartOp.a(terminalFactory, CardTerminals.State.CARD_PRESENT);
            stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                String string;
                CardTerminal cardTerminal = list.get(i);
                Card card = cardTerminal.connect("*");
                stringArray[i] = string = StringUtil.toHexString((byte[])card.getATR().getBytes());
                if (!bl) continue;
                break;
            }
        }
        catch (CardException cardException) {
            throw new SmartCardException(SmartOp.a(-1990, 598), cardException);
        }
        return stringArray;
    }

    public static Pair<Long, CardType> getSlotAndCardType(String terminal, Application aApp) throws SmartCardException {
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            CardTerminal cardTerminal = terminalFactory.terminals().getTerminal(terminal);
            Card card = cardTerminal.connect("*");
            String string = SmartOp.a(card.getATR().getBytes());
            card.disconnect(false);
            CardType cardType = CardType.getCardTypeFromATR(string, aApp);
            Long l = null;
            try {
                if (cardType != CardType.UNKNOWN) {
                    l = SmartOp.a(cardType, terminal);
                }
            }
            catch (Exception exception) {
                d.warn(SmartOp.a(-2014, 20563), (Throwable)exception);
                l = null;
            }
            Pair pair = new Pair((Object)l, (Object)cardType);
            return pair;
        }
        catch (Exception exception) {
            throw new SmartCardException(SmartOp.a(-1999, -28282), exception);
        }
    }

    public static Pair<Long, CardType> getSlotAndCardType(String terminal) throws SmartCardException {
        return SmartOp.getSlotAndCardType(terminal, Application.ESIGNATURE);
    }

    public String getCardSerialNumber() throws PKCS11Exception, IOException {
        SmartCard smartCard = new SmartCard(this.b);
        return new String(smartCard.getTokenInfo((long)this.a).serialNumber).trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importCertificateAndKey(String aCertLabel, String aKeyLabel, PrivateKey aPrivKey, X509Certificate aCert) throws PKCS11Exception, IOException, SmartCardException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            smartCard.importCertificateAndKey(l, aCertLabel, aKeyLabel, aPrivKey, aCert);
            smartCard.logout(l);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, byte[] aPbCertData, int aSignOrEnc) throws PKCS11Exception, IOException {
        boolean bl;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            bl = smartCard.importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarLen, aScfname, aContextName, aPbCertData, aSignOrEnc);
            if (smartCard == null) return bl;
            if (l == -1L) return bl;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void importKeyPair(String aLabel, KeyPair aKeyPair, byte[] aSubject, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, IOException, SmartCardException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            smartCard.importKeyPair(l, aLabel, aKeyPair, aSubject, aIsSign, aIsEncrypt);
            smartCard.logout(l);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> readCertificate(String aLabel) throws IOException, PKCS11Exception, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            list = smartCard.readCertificate(l, aLabel);
            if (smartCard == null) return list;
            if (l == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> getSignCertificates() throws PKCS11Exception, IOException, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            list = smartCard.getSignatureCertificates(l);
            if (smartCard == null) return list;
            if (l == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> getEncryptCertificates() throws IOException, PKCS11Exception, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            list = smartCard.getEncryptionCertificates(l);
            if (smartCard == null) return list;
            if (l == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importCertificate(String aCertLabel, X509Certificate aCert) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l = -1L;
        boolean bl = CardType.b;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.importCertificate(l, aCertLabel, aCert);
            return;
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (!pKCS11Exception.getMessage().equals(SmartOp.a(-2025, -32119))) throw pKCS11Exception;
            smartCard.login(l, this.c);
            smartCard.importCertificate(l, aCertLabel, aCert);
            smartCard.logout(l);
            if (!bl) return;
            throw pKCS11Exception;
        }
        finally {
            if (smartCard != null && l != -1L) {
                smartCard.closeSession(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> readPrivateData(String aLabel) throws PKCS11Exception, IOException, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            List<byte[]> list2 = smartCard.readPrivateData(l, aLabel);
            smartCard.logout(l);
            list = list2;
            if (smartCard == null) return list;
            if (l == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<byte[]> readPublicData(String aLabel) throws PKCS11Exception, IOException, SmartCardException {
        List<byte[]> list;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            List<byte[]> list2;
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            list = list2 = smartCard.readPublicData(l, aLabel);
            if (smartCard == null) return list;
            if (l == -1L) return list;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writePrivateData(String aLabel, byte[] aData) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            smartCard.writePrivateData(l, aLabel, aData);
            smartCard.logout(l);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writePublicData(String aLabel, byte[] aData) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            smartCard.writePublicData(l, aLabel, aData);
            smartCard.logout(l);
            return;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.warn(SmartOp.a(-2014, 20563), (Throwable)pKCS11Exception);
            if (!pKCS11Exception.getMessage().equals(SmartOp.a(-2047, -8730))) return;
            smartCard.login(l, this.c);
            smartCard.writePublicData(l, aLabel, aData);
            smartCard.logout(l);
            return;
        }
        finally {
            if (smartCard != null && l != -1L) {
                smartCard.closeSession(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deletePrivateData(String aLabel) throws IOException, PKCS11Exception, SmartCardException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            smartCard.deletePrivateData(l, aLabel);
            smartCard.logout(l);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deletePublicData(String aLabel) throws IOException, PKCS11Exception, SmartCardException {
        SmartCard smartCard = null;
        boolean bl = CardType.b;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.deletePublicData(l, aLabel);
            return;
        }
        catch (PKCS11Exception pKCS11Exception) {
            if (!pKCS11Exception.getMessage().equals(SmartOp.a(-2047, -8730))) throw pKCS11Exception;
            smartCard.login(l, this.c);
            smartCard.deletePublicData(l, aLabel);
            smartCard.logout(l);
            if (!bl) return;
            throw pKCS11Exception;
        }
        finally {
            if (smartCard != null && l != -1L) {
                smartCard.closeSession(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isObjectExist(String aLabel, boolean aIsPrivate) throws IOException, PKCS11Exception {
        boolean bl;
        SmartCard smartCard = null;
        boolean bl2 = CardType.b;
        long l = -1L;
        try {
            boolean bl3;
            block9: {
                block8: {
                    smartCard = new SmartCard(this.b);
                    l = smartCard.openSession(this.a);
                    if (!aIsPrivate) break block8;
                    smartCard.login(l, this.c);
                    bl3 = smartCard.isObjectExist(l, aLabel);
                    smartCard.logout(l);
                    if (!bl2) break block9;
                }
                bl3 = smartCard.isObjectExist(l, aLabel);
            }
            bl = bl3;
            if (smartCard == null) return bl;
            if (l == -1L) return bl;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCardEmpty() throws PKCS11Exception, IOException {
        boolean bl;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            bl = smartCard.isAnyObjectExist(l);
            if (smartCard == null) return bl;
            if (l == -1L) return bl;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateKeyPair(String aKeyLabel, AlgorithmParameterSpec aParamSpec, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, IOException, SmartCardException {
        SmartCard smartCard = null;
        long l = -1L;
        boolean bl = CardType.b;
        try {
            if (this.b == null) {
                throw new SmartCardException(SmartOp.a(-2031, -21885));
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            boolean bl2 = smartCard.isObjectExist(l, aKeyLabel);
            if (bl2) {
                throw new SmartCardException(aKeyLabel + SmartOp.a(-2006, -20664));
            }
            smartCard.createKeyPair(l, aKeyLabel, aParamSpec, aIsSign, aIsEncrypt);
            smartCard.logout(l);
        }
        finally {
            if (smartCard != null && l != -1L) {
                smartCard.closeSession(l);
            }
        }
        if (bl) {
            SmartCardException.b = !SmartCardException.b;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeySpec getPublicKeySpec(String aKeyLabel) throws PKCS11Exception, IOException, SmartCardException {
        KeySpec keySpec;
        SmartCard smartCard = null;
        long l = -1L;
        try {
            KeySpec keySpec2;
            if (this.b == null) {
                throw new SmartCardException(SmartOp.a(-2031, -21885));
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            keySpec = keySpec2 = smartCard.readPublicKeySpec(l, aKeyLabel);
            if (smartCard == null) return keySpec;
            if (l == -1L) return keySpec;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return keySpec;
    }

    public byte[] sign(byte[] aCertSerialNo, byte[] aToBeSigned, String aSigningAlg) throws PKCS11Exception, IOException, SmartCardException {
        return this.sign(aCertSerialNo, aToBeSigned, aSigningAlg, null);
    }

    public static byte[] sign(ISmartCard aSC, long aSessionID, long aSlotID, byte[] aCertSerialNo, byte[] aToBeSigned, String aSigningAlg) throws PKCS11Exception, SmartCardException {
        return SmartOp.sign(aSC, aSessionID, aSlotID, aCertSerialNo, aToBeSigned, aSigningAlg, null);
    }

    public byte[] sign(String aKeyLabel, byte[] aToBeSigned, String aSigningAlg) throws IOException, PKCS11Exception, SmartCardException {
        return this.sign(aKeyLabel, aToBeSigned, aSigningAlg, null);
    }

    public static byte[] sign(ISmartCard aSC, long aSessionID, long aSlotID, String aKeyLabel, byte[] aToBeSigned, String aSigningAlg) throws PKCS11Exception, SmartCardException {
        return SmartOp.sign(aSC, aSessionID, aSlotID, aKeyLabel, aToBeSigned, aSigningAlg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] sign(byte[] aCertSerialNo, byte[] aToBeSigned, String aSigningAlg, AlgorithmParameterSpec aParams) throws PKCS11Exception, IOException, SmartCardException {
        byte[] byArray;
        if (this.b == null) {
            throw new SmartCardException(SmartOp.a(-2031, -21885));
        }
        if (this.a == -1L) {
            this.a = SmartOp.findSlotNumber(this.b);
        }
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            byte[] byArray2 = SmartOp.sign((ISmartCard)smartCard, l, this.a, aCertSerialNo, aToBeSigned, aSigningAlg, aParams);
            smartCard.logout(l);
            byArray = byArray2;
            if (smartCard == null) return byArray;
            if (l == -1L) return byArray;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return byArray;
    }

    public static byte[] sign(ISmartCard aSC, long aSessionID, long aSlotID, byte[] aCertSerialNo, byte[] aImzalanacak, String aSigningAlg, AlgorithmParameterSpec aParamSpec) throws PKCS11Exception, SmartCardException {
        try {
            long l = aSC.getPrivateKeyObjIDFromCertificateSerial(aSessionID, aCertSerialNo);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            long[] lArray = aSC.getMechanismList(aSlotID);
            ISignatureScheme iSignatureScheme = SignatureSchemeFactory.getSignatureScheme(true, aSigningAlg, aParamSpec, lArray, modulusFinderFromObjectID);
            byte[] byArray = iSignatureScheme.getSignatureInput(aImzalanacak);
            CK_MECHANISM cK_MECHANISM = iSignatureScheme.getMechanism();
            byte[] byArray2 = aSC.signDataWithKeyID(aSessionID, l, cK_MECHANISM, byArray);
            return byArray2;
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-2003, -18916), aSC.getCardType(), aSlotID, StringUtil.toHexString((byte[])aCertSerialNo), aSigningAlg), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-2003, -18916), aSC.getCardType(), aSlotID, StringUtil.toHexString((byte[])aCertSerialNo), aSigningAlg), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] sign(String aAnahtarAdi, byte[] aImzalanacak, String aSigningAlg, AlgorithmParameterSpec aParams) throws IOException, PKCS11Exception, SmartCardException {
        byte[] byArray;
        SmartCard smartCard = null;
        long l = -1L;
        if (this.b == null) {
            throw new SmartCardException(SmartOp.a(-2031, -21885));
        }
        if (this.a == -1L) {
            this.a = SmartOp.findSlotNumber(this.b);
        }
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            byte[] byArray2 = SmartOp.sign((ISmartCard)smartCard, l, this.a, aAnahtarAdi, aImzalanacak, aSigningAlg, aParams);
            smartCard.logout(l);
            byArray = byArray2;
            if (smartCard == null) return byArray;
            if (l == -1L) return byArray;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return byArray;
    }

    public static byte[] sign(ISmartCard aSC, long aSessionID, long aSlotID, String aAnahtarAdi, byte[] aImzalanacak, String aSigningAlg, AlgorithmParameterSpec aParamSpec) throws PKCS11Exception, SmartCardException {
        try {
            long l = aSC.getPrivateKeyObjIDFromPrivateKeyLabel(aSessionID, aAnahtarAdi);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            long[] lArray = aSC.getMechanismList(aSlotID);
            ISignatureScheme iSignatureScheme = SignatureSchemeFactory.getSignatureScheme(true, aSigningAlg, aParamSpec, lArray, modulusFinderFromObjectID);
            byte[] byArray = iSignatureScheme.getSignatureInput(aImzalanacak);
            CK_MECHANISM cK_MECHANISM = iSignatureScheme.getMechanism();
            byte[] byArray2 = aSC.signData(aSessionID, aAnahtarAdi, byArray, cK_MECHANISM);
            return byArray2;
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-1993, 14455), aSC.getCardType(), aSlotID, aAnahtarAdi, aSigningAlg), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-1993, 14455), aSC.getCardType(), aSlotID, aAnahtarAdi, aSigningAlg), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verify(String aAnahtarAdi, byte[] aImzalanan, byte[] aDogrulanacak, String aSigningAlg) throws IOException, PKCS11Exception, SmartCardException {
        boolean bl;
        ISmartCard iSmartCard = null;
        long l = -1L;
        try {
            if (this.b == null) {
                throw new SmartCardException(SmartOp.a(-2031, -21885));
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            iSmartCard = new SmartCard(this.b);
            l = iSmartCard.openSession(this.a);
            iSmartCard.login(l, this.c);
            boolean bl2 = SmartOp.verify(iSmartCard, l, this.a, aAnahtarAdi, aImzalanan, aDogrulanacak, aSigningAlg);
            iSmartCard.logout(l);
            bl = bl2;
            if (iSmartCard == null) return bl;
            if (l == -1L) return bl;
        }
        catch (Throwable throwable) {
            if (iSmartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            iSmartCard.closeSession(l);
            throw throwable;
        }
        iSmartCard.closeSession(l);
        return bl;
    }

    public static boolean verify(ISmartCard aSC, long aSessionID, long aSlotID, String aKeyLabel, byte[] aImzalanan, byte[] aDogrulanacak, String aSigningAlg) throws PKCS11Exception, SmartCardException {
        try {
            PublicKeyFinderWithLabel publicKeyFinderWithLabel = new PublicKeyFinderWithLabel(aSC, aSessionID, aKeyLabel);
            long[] lArray = aSC.getMechanismList(aSlotID);
            ISignatureScheme iSignatureScheme = SignatureSchemeFactory.getSignatureScheme(false, aSigningAlg, null, lArray, publicKeyFinderWithLabel);
            CK_MECHANISM cK_MECHANISM = iSignatureScheme.getMechanism();
            byte[] byArray = iSignatureScheme.getSignatureInput(aImzalanan);
            boolean bl = false;
            try {
                aSC.verifyData(aSessionID, aKeyLabel, byArray, aDogrulanacak, cK_MECHANISM.mechanism);
                bl = true;
            }
            catch (PKCS11Exception pKCS11Exception) {
                d.error(SmartOp.a(-2020, 23499), (Throwable)pKCS11Exception);
            }
            return bl;
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-1993, 14455), aSC.getCardType(), aSlotID, aKeyLabel, aSigningAlg), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-1993, 14455), aSC.getCardType(), aSlotID, aKeyLabel, aSigningAlg), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] encrypt(String aAnahtarAdi, byte[] aSifrelenecek, String aAlgoritma, AlgorithmParameterSpec aParametreler) throws IOException, PKCS11Exception, SmartCardException {
        byte[] byArray;
        ISmartCard iSmartCard = null;
        long l = -1L;
        try {
            if (this.b == null) {
                throw new SmartCardException(SmartOp.a(-2031, -21885));
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            iSmartCard = new SmartCard(this.b);
            l = iSmartCard.openSession(this.a);
            iSmartCard.login(l, this.c);
            byte[] byArray2 = SmartOp.encrypt(iSmartCard, l, aAnahtarAdi, aSifrelenecek, aAlgoritma, aParametreler);
            iSmartCard.logout(l);
            byArray = byArray2;
            if (iSmartCard == null) return byArray;
            if (l == -1L) return byArray;
        }
        catch (Throwable throwable) {
            if (iSmartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            iSmartCard.closeSession(l);
            throw throwable;
        }
        iSmartCard.closeSession(l);
        return byArray;
    }

    public static byte[] encrypt(ISmartCard aSC, long aSessionID, String aAnahtarAdi, byte[] aSifrelenecek, String aAlgoritma, AlgorithmParameterSpec aParametreler) throws PKCS11Exception, SmartCardException {
        try {
            long l = aSC.getPrivateKeyObjIDFromPrivateKeyLabel(aSessionID, aAnahtarAdi);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(true, aAlgoritma, aParametreler, aSC, aSessionID, modulusFinderFromObjectID);
            byte[] byArray = aSC.encryptData(aSessionID, aAnahtarAdi, iEncryptionScheme.getResult(aSifrelenecek), iEncryptionScheme.getMechanism());
            return byArray;
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-2032, -2945), aSC.getCardType(), aAnahtarAdi, aAlgoritma), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-1995, 22082), aSC.getCardType(), aAnahtarAdi, aAlgoritma), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] decrypt(String aAnahtarAdi, byte[] aCozulecek, String aAlgoritma, AlgorithmParameterSpec aParam) throws PKCS11Exception, IOException, SmartCardException {
        byte[] byArray;
        if (this.b == null) {
            throw new SmartCardException(SmartOp.a(-2031, -21885));
        }
        if (this.a == -1L) {
            this.a = SmartOp.findSlotNumber(this.b);
        }
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.login(l, this.c);
            byte[] byArray2 = SmartOp.decrypt((ISmartCard)smartCard, l, this.a, aAnahtarAdi, aCozulecek, aAlgoritma, aParam);
            smartCard.logout(l);
            byArray = byArray2;
            if (smartCard == null) return byArray;
            if (l == -1L) return byArray;
        }
        catch (Throwable throwable) {
            if (smartCard == null) throw throwable;
            if (l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        smartCard.closeSession(l);
        return byArray;
    }

    @Deprecated
    public byte[] decrypt(String aKeyLabel, byte[] aEncryptedData) throws PKCS11Exception, IOException, SmartCardException {
        return this.decrypt(aKeyLabel, aEncryptedData, Algorithms.CIPHER_RSA_PKCS1, null);
    }

    @Deprecated
    public byte[] decrypt(byte[] aCertSerialNo, byte[] aEncryptedData) throws PKCS11Exception, IOException, SmartCardException {
        return this.decrypt(aCertSerialNo, aEncryptedData, Algorithms.CIPHER_RSA_PKCS1, null);
    }

    @Deprecated
    public static byte[] decrypt(ISmartCard aSC, long aSessionID, byte[] aCertSerialNo, byte[] aEncryptedData) throws SmartCardException, PKCS11Exception {
        long l = aSC.getSessionInfo((long)aSessionID).slotID;
        return SmartOp.decrypt(aSC, aSessionID, l, aCertSerialNo, aEncryptedData, Algorithms.CIPHER_RSA_PKCS1, null);
    }

    @Deprecated
    public static byte[] decrypt(ISmartCard aSC, long aSessionID, String aKeyLabel, byte[] aEncryptedData) throws SmartCardException, PKCS11Exception {
        long l = aSC.getSessionInfo((long)aSessionID).slotID;
        return SmartOp.decrypt(aSC, aSessionID, l, aKeyLabel, aEncryptedData, Algorithms.CIPHER_RSA_PKCS1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] decrypt(byte[] aCertSerialNo, byte[] aCozulecek, String aAlgoritma, AlgorithmParameterSpec aParam) throws PKCS11Exception, IOException, SmartCardException {
        byte[] byArray2;
        boolean bl2;
        block12: {
            bl2 = CardType.b;
            if (this.b == null) {
                throw new SmartCardException(SmartOp.a(-2001, 16066));
            }
            if (this.a == -1L) {
                this.a = SmartOp.findSlotNumber(this.b);
            }
            SmartCard smartCard = null;
            long l = -1L;
            try {
                smartCard = new SmartCard(this.b);
                l = smartCard.openSession(this.a);
                smartCard.login(l, this.c);
                byte[] byArray3 = SmartOp.decrypt((ISmartCard)smartCard, l, this.a, aCertSerialNo, aCozulecek, aAlgoritma, aParam);
                smartCard.logout(l);
                byArray2 = byArray3;
                if (smartCard == null || l == -1L) break block12;
            }
            catch (Throwable throwable) {
                if (smartCard == null) throw throwable;
                if (l == -1L) throw throwable;
                smartCard.closeSession(l);
                throw throwable;
            }
            smartCard.closeSession(l);
        }
        if (!SmartCardException.b) return byArray2;
        CardType.b = !bl2;
        return byArray2;
    }

    public static byte[] decrypt(ISmartCard aSC, long aSessionID, long aSlot, byte[] aCertSerialNo, byte[] aCozulecek, String aAlgorithm, AlgorithmParameterSpec aParams) throws SmartCardException, PKCS11Exception {
        try {
            long l = aSC.getPrivateKeyObjIDFromCertificateSerial(aSessionID, aCertSerialNo);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(false, aAlgorithm, aParams, aSC, aSlot, modulusFinderFromObjectID);
            byte[] byArray = aSC.decryptDataWithCertSerialNo(aSessionID, aCertSerialNo, iEncryptionScheme.getMechanism(), aCozulecek);
            return iEncryptionScheme.getResult(byArray);
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-1987, 11984), aSC.getCardType(), aSlot, StringUtil.toHexString((byte[])aCertSerialNo), aAlgorithm), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-2003, -18916), aSC.getCardType(), aSlot, StringUtil.toHexString((byte[])aCertSerialNo), aAlgorithm), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    public static byte[] decrypt(ISmartCard aSC, long aSessionID, long aSlot, String aAnahtarAdi, byte[] aCozulecek, String aAlgorithm, AlgorithmParameterSpec aParams) throws SmartCardException, PKCS11Exception {
        try {
            long l = aSC.getPrivateKeyObjIDFromPrivateKeyLabel(aSessionID, aAnahtarAdi);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(false, aAlgorithm, aParams, aSC, aSlot, modulusFinderFromObjectID);
            byte[] byArray = aSC.decryptData(aSessionID, aAnahtarAdi, aCozulecek, iEncryptionScheme.getMechanism());
            return iEncryptionScheme.getResult(byArray);
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-2016, -24754), aSC.getCardType(), aSlot, aAnahtarAdi, aAlgorithm), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-1993, 14455), aSC.getCardType(), aSlot, aAnahtarAdi, aAlgorithm), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    public static byte[] wrap(ISmartCard aSC, long aSessionID, long aSlot, String aAlgorithm, String wrapperKeyLabel, String labelOfKeyToWrap, AlgorithmParameterSpec aParams) throws PKCS11Exception, SmartCardException {
        try {
            long l = aSC.getPublicKeyObjIDFromPublicKeyLabel(aSessionID, wrapperKeyLabel);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(false, aAlgorithm, aParams, aSC, aSlot, modulusFinderFromObjectID);
            byte[] byArray = aSC.wrapKey(aSessionID, iEncryptionScheme.getMechanism(), wrapperKeyLabel, labelOfKeyToWrap);
            return iEncryptionScheme.getResult(byArray);
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-2015, 25563), aSC.getCardType(), aSlot, wrapperKeyLabel, labelOfKeyToWrap, aAlgorithm), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-2029, -30814), aSC.getCardType(), aSlot, wrapperKeyLabel, labelOfKeyToWrap, aAlgorithm), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    public static void unwrap(ISmartCard aSC, long aSessionID, long aSlot, String aAlgorithm, String unwrapperKeyLabel, byte[] wrappedKey, KeyTemplate unwrappedKeyTemplate, AlgorithmParameterSpec aParams) throws PKCS11Exception, SmartCardException {
        try {
            long l = aSC.getPrivateKeyObjIDFromPrivateKeyLabel(aSessionID, unwrapperKeyLabel);
            ModulusFinderFromObjectID modulusFinderFromObjectID = new ModulusFinderFromObjectID(aSC, aSessionID, l);
            IEncryptionScheme iEncryptionScheme = EncryptionSchemeFactory.getEncryptionScheme(false, aAlgorithm, aParams, aSC, aSlot, modulusFinderFromObjectID);
            aSC.unwrapKey(aSessionID, iEncryptionScheme.getMechanism(), unwrapperKeyLabel, wrappedKey, unwrappedKeyTemplate);
        }
        catch (SmartCardException smartCardException) {
            d.debug(MessageFormat.format(SmartOp.a(-1989, -9485), aSC.getCardType(), aSlot, unwrapperKeyLabel), (Throwable)((Object)smartCardException));
            throw smartCardException;
        }
        catch (PKCS11Exception pKCS11Exception) {
            d.debug(MessageFormat.format(SmartOp.a(-2030, 14949), aSC.getCardType(), aSlot, unwrapperKeyLabel), (Throwable)pKCS11Exception);
            throw pKCS11Exception;
        }
    }

    public long getSlot() {
        return this.a;
    }

    public CardType getCardType() {
        return this.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void formatToken(String aSOpin, String aNewPIN, String aLabel) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.formatToken(aSOpin, aNewPIN, aLabel, (int)this.a);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changePassword(String aOldPass, String aNewPass) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.changePassword(aOldPass, aNewPass, l);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void changePuk(byte[] aSOPin, byte[] aNewSOPin) throws PKCS11Exception, IOException {
        SmartCard smartCard = null;
        long l = -1L;
        try {
            smartCard = new SmartCard(this.b);
            l = smartCard.openSession(this.a);
            smartCard.setSOPin(aSOPin, aNewSOPin, l);
            if (smartCard == null) return;
        }
        catch (Throwable throwable) {
            if (smartCard == null || l == -1L) throw throwable;
            smartCard.closeSession(l);
            throw throwable;
        }
        if (l == -1L) return;
        smartCard.closeSession(l);
        return;
    }

    public static long findSlotNumber(CardType aCardType) throws PKCS11Exception, IOException, SmartCardException {
        return SmartOp.findSlotNumber(aCardType, SmartOp.a(-2004, 12244));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long findSlotNumber(CardType aCardType, String message) throws PKCS11Exception, IOException, SmartCardException {
        int n = 1;
        boolean bl = CardType.b;
        do {
            Object[] objectArray;
            JComboBox<String> jComboBox;
            SmartCard smartCard;
            long[] lArray;
            int n2;
            if ((n2 = (lArray = (smartCard = new SmartCard(aCardType)).getTokenPresentSlotList()).length) == 0) {
                throw new SmartCardException(SmartOp.a(-1996, -6436));
            }
            if (n2 == 1) {
                return lArray[0];
            }
            String[] stringArray = new String[n2];
            int n3 = lArray.length;
            for (int i = 0; i < n3; ++i) {
                long l = lArray[i];
                String string = "";
                try {
                    string = string + " " + new String(smartCard.getSlotInfo((long)l).slotDescription).trim();
                }
                catch (Exception exception) {
                    d.warn(SmartOp.a(-2009, -20163), (Throwable)exception);
                }
                try {
                    string = string + " " + new String(smartCard.getTokenInfo((long)l).label).trim().split("\u0000")[0];
                }
                catch (Exception exception) {
                    d.warn(SmartOp.a(-2014, 20563), (Throwable)exception);
                }
                stringArray[i] = string;
                if (!bl) continue;
            }
            if ((n = JOptionPane.showOptionDialog(null, jComboBox = new JComboBox<String>(stringArray), message, 2, -1, null, objectArray = new String[]{SmartOp.a(-2005, -23903), SmartOp.a(-1991, -23788), SmartOp.a(-1998, -3517)}, objectArray[0])) == 0) {
                return lArray[jComboBox.getSelectedIndex()];
            }
            if (n != 2) continue;
            throw new SmartCardException(SmartOp.a(-2019, 2641));
        } while (n == 1 && !bl);
        throw new ESYARuntimeException(SmartOp.a(-1992, 14416) + n);
    }

    public static int secenekSor(Component aParent, Icon aIcon, String[] aSecenekList, String aBaslik, String[] aOptions) {
        JComboBox<String> jComboBox = new JComboBox<String>(aSecenekList);
        int n = JOptionPane.showOptionDialog(aParent, jComboBox, aBaslik, 2, -1, null, aOptions, aOptions[0]);
        if (n == 1) {
            return -1;
        }
        return jComboBox.getSelectedIndex();
    }

    /*
     * Unable to fully structure code
     */
    static {
        block25: {
            block24: {
                block23: {
                    var5 = new String[54];
                    var3_1 = 0;
                    var2_2 = "\u0007\u0089\u00bb\u0086\u0002  \t(Li\u00ea0\u00e7\u00e9\u00e1\u0091\u00ed\u00bc\u00fav\u008a\u00d2\u00fd\u00faSW\u00d3\u0090O\u008b\u001a,R\u00c2/w\u00b5C\t]\u00b6=\u00ebA@\u00c9\u0094g\u0017\u001a^\u0018?}?\u00bc\u0016l\u009b:\u00aa\u00a8+{l0\u009c\u0011UH\u00dc\u00a6\u0018\u00bf\u00d0\u00ac\u00ee\u00eb\u0005nQ6sq\u00b7\u00c1\u0088V\u0018\u0095\u0012\u00a5\u0084\u00de\u00e6t\u00fc@\u00df\u00ca\u00d0\u00ecrc\u00c4z\u00a8h\u00e4-\u00a1L#\u008d|<U\u000e\u009ch\u00bbE{\u00a3&\u00b6\u0082\u00dfu\u0090\u00f5\u00cbr\u00e1\u0017&\u00f3\u001a\u0090\u00c7\u0119J\n\u00d6\u00e4 \u0000\u00a5\u0088\u00e2\u0086a\u00ba\u0003L,\u0000CS\u00fd\u00b9\u0085\u000f\u00a0\u008a\u00ad)C\u00cb\u00856H\u008e\u008b-N\u0012'5\u00b8\u00f8<\u00aa\u00ef\u00abwc\u00deK*Ix\u00c0\u0018\u001c\u001b\u000e\u00b9H\u0001\u00b2\n@\u0013\u0082\u00f5\u001c\u0080\u009eN\u0112\u00a8\u00e6\u00d7\u009a\u00f3v\u0015\u0095yx\u00f2\u0096\u00ab\u0003\u00ead\u00c6?\u00be\u00ef'\u0018en\u00f79\u0080\u00ff\u0003\u000e\u009b\u0098\u00c4\u00caw'\u0080\u00edO\u00ac\u00feS\u00b5\u001c\u0019\u00a34\u00e6\u00ab\u00f7\u00c0\u0096\u00e6X\u00ca;~\u0096\u00ef\u00ef\u0014\u00ea\u0086E]r\"x\u00ed'\u00f5\u00e8\u00b5Tt\u00cc\u0087\u00bc\u009b\u00d8\u00aaw\u00d7R\u00a8\u00ee\u00bdB\u009akv\u00d4\u007fk\u008fh\u00a4{\u00e3\u000f'In}\u0017\u00e8\u00ca\u00f7\u00db\u00aa\u00f82\u00f4i>\u0007\u00c2\u00198\u0001{\u00fc\n.\u007f\u00e7\u00ca\u009b\u0096\u00a1\u0090\u008e\u00ba\u008a\u00ba\u00db\u00d81\u0005\u00cc\u0093^\u00e7\tz\u00c4\u00affH(\u00b2\u00b9\u0089\u00f7\u0081GE\u00b3\u00cd`\u00c8>ZV\u0090\u00f9\u00d3\u00f0\fS.\u0018`&k\u000b\u00bf#M\u00cc\u00f2t\u00d4\u0001\u00d0>\u00f0\u00f4\u00d9\u000b\u00f9\u00e7\u00da\u001c\u00a5>P|\u00b6P\u0016\u00ba{\"4!\u0090U \u00e9\u0095\u00e6\u0081\u001d\u00ff\u00d5\u00b2\u0017V\u001c\u00acc\u000b\u00b8,\u00af[\u001a\u0099K\u00f1rHZ\u00a92\u00f0[,'\u00fb?\u0010*)\u00f0M\u00e0#\nTf{\u00ecRt]\u008a\u00b3\u00dc\u00ac\u0012\u00a3\u00eb\\5\u0087\u00ad\u00b9wq\u00e7\u000b\u00978 \u009a\u00ea\\\u00dcY\u0088\u00e5\u00fd\u0098\u001e\u000bL\u00bbBA\u00f3\u0000n\u0017\u0087\u009a|,x\u00c4v-J\b\u0012\u00c1\u0089\u00e9\u008b\u00db/\u009c5\u0011\u00f2\u00df\u001d!?\u00c5\u00be\u00d5\u00c4\u0015H\u00f1O\u00fes51l:\u000b\u00ff\u0095\u00feZ\u00d2!\u0001KUx\u00d3@ \u00c7/M\u008dW;\u00fcW\u00b8\u001b7^\u000f\u00dc\u00e5\u00831\u00aa\u00afc\\D\u00c3\u0084s\u00d9\u00ac}\u009c\u008a\u00f8\n\u00c6\u008d@\u00e8\u0012\f\u009co\u0017\u01e6P\u00f5\u0095\u001bH\u00ff\u00a8wCyUE\u0085\u00b3\u00fc\u00ffY\u00ac\u00beF\u00edU\u009bGX]cU\u00e6\u00bc\u00ec\u00b0l6\u00b0/\u0001\u00e18\u00b1\u00dd\u00bf\u008d^\u0099\u0083?{\u00ae\u00ad\u0093\u00bcW\u00fc\u00a7Z\u00ecT\u00c0\u008f\u008d\u00abR\u00f4\u00be\u00d6\u008b\u00b0\u0003\u0083\u00b2Jn\u00a5\u00a9L/\u00bdj\u009b>\u00d81/\u00ca\u00f4\u00caA\u00c6\u008c\",\u00e5\r\u00ea6`\u00ac#\u008e(X\u00c3X\u00ed\u00df\u0087\u001fp\u0016@b\u00a7Qu\u00e8\u00eai\u00e9_\u0085`\u0014\u00132\u00ce[e\u0016\u00ae\u00e0e\n\u00a5\u001c\\t\u00cfV\u0012\u00ed\u0012l\u00f8kA\u008a\u00f8\u00d3K\u0087**\u00d9\u00a4b\u00f9_\u001cn\u00ce\u00ab9\u00eb\u00f30\u00c6\u00c5=\u00f9\u00e0]\u0081Q|\u00aa\u00a8\u00a1\u00fe\u0012\u00a4\u00f7\u00afF\u00c1~\u00b3\u0007\u00c1&\u008a.h\u0098\u00e1\u0010\u00eaK\u001fPT\u00a9 \u00bc\u0010\u00c3\u00ff\u000b)\u00d8_i\u0002\u009f\u00e5\t\u00bb\u00bf\u00e1\u00ca\u00dad\u00ba\u0010\te\u009a\u00b8\u0015<(\bX\u0017\u0016\u00d5G\u0095:\u00fe\u00b0\u00ea\u00a6\u00e1\u00a8\u00c2BJ`\u00ec\u0006wa\u0086\u00e7\u001f\u00a7\u00b9f\u0085\u008d\u0004\u0019!\u00fb;H\u00f6\u00f4\u009bO\u0087\u00d6&\u00a7\u00fa\u00a0\u0000\u0083\b\u00a2\u0094\u00a1D\u00cd\u00cd\u00ed\u00e2\u00c6Y\u001f`B\u009cX\u00a8\u0013\u00af\u008c-x\u008d\u0004\u00adA\u0096\u00b7$\u0018iL\u00d1\u00d6+\u00cd\u00a3\u00d3\u0002\u00d53\u00a1\u009e\u00c6\u00e1M\u00de\n \u00ceNY\u0091\u00b9\u00ea2\u00b3m\u00b2\u00c4\u00a4Q\u00eb\u00b6Ri\u00ee\u0098\u000b\u00aa\u001b)\u00e1\u00fd\u0007\u0088q\u00eckL\u00ca\u0011K\u0098.\u00a3\u001ev\u00a9\u00ae\u000bk\u00af\u00ba\u0015\u00c2>\u008f\u0016\tp\u008dF\u00bd\u00d9\u0092\u00b2\u00b7\u0006?\u00ab\u0001^\u0095\u00a3L\u00fe\u009f\u00ef\u00d4\f\u00ba\u00bc\u00be\u0080\u00d3\b\u00f7\u00dbwMG\u0081\u00a0<\u001f\u00ce!\u009f-\u00d6\u00ce\u0083\u000b\u00ed\u008f\u00b2p\u0084\u001d^O\u00efH\u00e5\u0086f\u001b\u00fa\u00d8w\u000b\u00f9+G\u00e9\u0097\u00ca\u00b3 \u00c3\u0080\u00d54~q\u00e4\u009b\u00f4\u008d\u0014\u00a7\u00b2\u00d3\u00a7Z\u00c9\u00a2.P\u00dd\u0087ay\u001a\u0086k\u0098a\u0018e\u00c1\u00ea1xM@pd\u008c0\u00c3\u00a2\u00d0\u00cb7Z\u00c3\u00f2\u00c9\u00afY\u00f0~h\u00b8U1@\r\u00bd\u00c9I\u00b3?F\u00c098\u001a\u00eeT\u00d9\u0092\u00b6\u0088_'B\u00cc\u0000\u0095\u000b\u00fb\u00a39}\u0002\u00c4\r]\u00b9\u00b4j\u0093\u00d8(\u00f8\u0084\u00eb\u00d8!qV\u00bb\u0018M;E\u0003Pz>\u00c0\u00ebk\u00d6\u009b\u00ee\u009f\u00cc`F\u0093l\u00880\u00b0\u008e@F5\u00a2\u0089O}`i_\u00b8?-5U\u008c\u0081$Xz\u0081Y\u0000\f\u00f1\u00a1\u0003\u00ddw\u00bf\u00f6z\u0004\u00c6\u00b6c\u00fcz\u00cd\u00c5.\u00f4\u00fb\u0083!\u01b1E\u0092j\u0014D\u00a7\u00e3\u00af\u00a7?)~\u00d0\u001e\u0085\u00c7+K\u0003a\u0090\u0011\u00c3\u00b5?\u0006<\u00c2\u00ed8\u0083\u00b9\u00be\u00e07\u0089z\u00e6\u009e\u001f\u00bf}\u00b9\u000f\u0098\u00fc\u0092]\u0016\u00dfv\u0089v\u00bajH\u00fd\u00a5\u00a2\b)\u0003\u0007\u00d0\u00f6\u0013\u0083\u008a\u0087\u0015(\u0016F*\u00af\u00a1\u000b@\u001f01ND\u00a9\u00e2c\u00f4\u008ea\u00a2tu\u00cf\u0007\u000bnfj\u00e1\u00f9u\u00cc\u00ab\u00c66\u0004&\u00c5\n\u00d5-\u00d9\u00b8\u0081\u00f8-\u00b3t\u00f8\u00c9\u00fe\u00ec\u00c31\u00d8\u00ca\u0013\u00e0\u0018)\u009a\u00d62\u00e1\u008b\u0007|\u00b0\u00ba\u0001\u0091JD\u00e6\u00a8\u0003\u00f7\u00e0C?\u0002\\\u00edX,\u00e0\u00d6\u00a96\u0088\u00f8\u0094\u00c3\u0018\u001fp\u00ed/\u00e1'\u00d0\u0000\u00dc\u00f5\u00ebB\u00c7\u00c1\"Q2\u00a4\u00b8\u009e\u0018\u00d1K\u0093V*\u00b0\u0092\u0015\u009dR\u0090\u00ac\u00f3{\u00dc\u0083\u00dbV\u0091\u00f0\u00af\u001f(q6\u0014\\.\tK\u00f4\u0016\u00f1\u00b7/\u008f\u0088\u000f\u001b\u00fb\u0002\u00d7\u00fc:2\u0000c+\u001a\n!G\u00b0L\u00b7.*+\u00fa\u00ce(\u00f66 \u001f\u0082\u000fn!\u0000\u00c2\u001d\u00fe\u00c9\u00a3\u00ce'\u00f6g5\u00a1U\r\u0085C\u00ff\u00dd\u00da\u0010\u0000\u00e3\u00f6\b\u00eb8z\u0010\u0010\u00ca\u0083\u0093\u008dC q\u0000\u00c0\u00d0\u00f3;\u0083G\u009a\u001d\u00c1!\u00bc\u00d2\u00cd\u00b10\u00cd\u0002\u0001\u0092`cqs\nz)\u001b\u008b/h\u0095\u0090.\u00e9\u0000l\u00f1\u0004N\u00f6\u0018\u00f0\u0010\u009a\u00e35\u009c8G\\L\u009d\u00ec\u00c9+\u0012F\u00ab\u00c3\u001d\u00c1\u00c9UU\u00c9\u00b7\u0083\u0019m\u008f|\u007f\u00c8\u000e\u00cc\u00dd5\u001bJk\u00f0\u0017+{\u0096\u000e\u00e9\f\u0006\u0016\u00f6\u00bc\u00b9s\u00c9\u001aG{:'%\u0084\u00ce\u00c6q:\u00d14b\u00a7\r]";
                    var4_3 = "\u0007\u0089\u00bb\u0086\u0002  \t(Li\u00ea0\u00e7\u00e9\u00e1\u0091\u00ed\u00bc\u00fav\u008a\u00d2\u00fd\u00faSW\u00d3\u0090O\u008b\u001a,R\u00c2/w\u00b5C\t]\u00b6=\u00ebA@\u00c9\u0094g\u0017\u001a^\u0018?}?\u00bc\u0016l\u009b:\u00aa\u00a8+{l0\u009c\u0011UH\u00dc\u00a6\u0018\u00bf\u00d0\u00ac\u00ee\u00eb\u0005nQ6sq\u00b7\u00c1\u0088V\u0018\u0095\u0012\u00a5\u0084\u00de\u00e6t\u00fc@\u00df\u00ca\u00d0\u00ecrc\u00c4z\u00a8h\u00e4-\u00a1L#\u008d|<U\u000e\u009ch\u00bbE{\u00a3&\u00b6\u0082\u00dfu\u0090\u00f5\u00cbr\u00e1\u0017&\u00f3\u001a\u0090\u00c7\u0119J\n\u00d6\u00e4 \u0000\u00a5\u0088\u00e2\u0086a\u00ba\u0003L,\u0000CS\u00fd\u00b9\u0085\u000f\u00a0\u008a\u00ad)C\u00cb\u00856H\u008e\u008b-N\u0012'5\u00b8\u00f8<\u00aa\u00ef\u00abwc\u00deK*Ix\u00c0\u0018\u001c\u001b\u000e\u00b9H\u0001\u00b2\n@\u0013\u0082\u00f5\u001c\u0080\u009eN\u0112\u00a8\u00e6\u00d7\u009a\u00f3v\u0015\u0095yx\u00f2\u0096\u00ab\u0003\u00ead\u00c6?\u00be\u00ef'\u0018en\u00f79\u0080\u00ff\u0003\u000e\u009b\u0098\u00c4\u00caw'\u0080\u00edO\u00ac\u00feS\u00b5\u001c\u0019\u00a34\u00e6\u00ab\u00f7\u00c0\u0096\u00e6X\u00ca;~\u0096\u00ef\u00ef\u0014\u00ea\u0086E]r\"x\u00ed'\u00f5\u00e8\u00b5Tt\u00cc\u0087\u00bc\u009b\u00d8\u00aaw\u00d7R\u00a8\u00ee\u00bdB\u009akv\u00d4\u007fk\u008fh\u00a4{\u00e3\u000f'In}\u0017\u00e8\u00ca\u00f7\u00db\u00aa\u00f82\u00f4i>\u0007\u00c2\u00198\u0001{\u00fc\n.\u007f\u00e7\u00ca\u009b\u0096\u00a1\u0090\u008e\u00ba\u008a\u00ba\u00db\u00d81\u0005\u00cc\u0093^\u00e7\tz\u00c4\u00affH(\u00b2\u00b9\u0089\u00f7\u0081GE\u00b3\u00cd`\u00c8>ZV\u0090\u00f9\u00d3\u00f0\fS.\u0018`&k\u000b\u00bf#M\u00cc\u00f2t\u00d4\u0001\u00d0>\u00f0\u00f4\u00d9\u000b\u00f9\u00e7\u00da\u001c\u00a5>P|\u00b6P\u0016\u00ba{\"4!\u0090U \u00e9\u0095\u00e6\u0081\u001d\u00ff\u00d5\u00b2\u0017V\u001c\u00acc\u000b\u00b8,\u00af[\u001a\u0099K\u00f1rHZ\u00a92\u00f0[,'\u00fb?\u0010*)\u00f0M\u00e0#\nTf{\u00ecRt]\u008a\u00b3\u00dc\u00ac\u0012\u00a3\u00eb\\5\u0087\u00ad\u00b9wq\u00e7\u000b\u00978 \u009a\u00ea\\\u00dcY\u0088\u00e5\u00fd\u0098\u001e\u000bL\u00bbBA\u00f3\u0000n\u0017\u0087\u009a|,x\u00c4v-J\b\u0012\u00c1\u0089\u00e9\u008b\u00db/\u009c5\u0011\u00f2\u00df\u001d!?\u00c5\u00be\u00d5\u00c4\u0015H\u00f1O\u00fes51l:\u000b\u00ff\u0095\u00feZ\u00d2!\u0001KUx\u00d3@ \u00c7/M\u008dW;\u00fcW\u00b8\u001b7^\u000f\u00dc\u00e5\u00831\u00aa\u00afc\\D\u00c3\u0084s\u00d9\u00ac}\u009c\u008a\u00f8\n\u00c6\u008d@\u00e8\u0012\f\u009co\u0017\u01e6P\u00f5\u0095\u001bH\u00ff\u00a8wCyUE\u0085\u00b3\u00fc\u00ffY\u00ac\u00beF\u00edU\u009bGX]cU\u00e6\u00bc\u00ec\u00b0l6\u00b0/\u0001\u00e18\u00b1\u00dd\u00bf\u008d^\u0099\u0083?{\u00ae\u00ad\u0093\u00bcW\u00fc\u00a7Z\u00ecT\u00c0\u008f\u008d\u00abR\u00f4\u00be\u00d6\u008b\u00b0\u0003\u0083\u00b2Jn\u00a5\u00a9L/\u00bdj\u009b>\u00d81/\u00ca\u00f4\u00caA\u00c6\u008c\",\u00e5\r\u00ea6`\u00ac#\u008e(X\u00c3X\u00ed\u00df\u0087\u001fp\u0016@b\u00a7Qu\u00e8\u00eai\u00e9_\u0085`\u0014\u00132\u00ce[e\u0016\u00ae\u00e0e\n\u00a5\u001c\\t\u00cfV\u0012\u00ed\u0012l\u00f8kA\u008a\u00f8\u00d3K\u0087**\u00d9\u00a4b\u00f9_\u001cn\u00ce\u00ab9\u00eb\u00f30\u00c6\u00c5=\u00f9\u00e0]\u0081Q|\u00aa\u00a8\u00a1\u00fe\u0012\u00a4\u00f7\u00afF\u00c1~\u00b3\u0007\u00c1&\u008a.h\u0098\u00e1\u0010\u00eaK\u001fPT\u00a9 \u00bc\u0010\u00c3\u00ff\u000b)\u00d8_i\u0002\u009f\u00e5\t\u00bb\u00bf\u00e1\u00ca\u00dad\u00ba\u0010\te\u009a\u00b8\u0015<(\bX\u0017\u0016\u00d5G\u0095:\u00fe\u00b0\u00ea\u00a6\u00e1\u00a8\u00c2BJ`\u00ec\u0006wa\u0086\u00e7\u001f\u00a7\u00b9f\u0085\u008d\u0004\u0019!\u00fb;H\u00f6\u00f4\u009bO\u0087\u00d6&\u00a7\u00fa\u00a0\u0000\u0083\b\u00a2\u0094\u00a1D\u00cd\u00cd\u00ed\u00e2\u00c6Y\u001f`B\u009cX\u00a8\u0013\u00af\u008c-x\u008d\u0004\u00adA\u0096\u00b7$\u0018iL\u00d1\u00d6+\u00cd\u00a3\u00d3\u0002\u00d53\u00a1\u009e\u00c6\u00e1M\u00de\n \u00ceNY\u0091\u00b9\u00ea2\u00b3m\u00b2\u00c4\u00a4Q\u00eb\u00b6Ri\u00ee\u0098\u000b\u00aa\u001b)\u00e1\u00fd\u0007\u0088q\u00eckL\u00ca\u0011K\u0098.\u00a3\u001ev\u00a9\u00ae\u000bk\u00af\u00ba\u0015\u00c2>\u008f\u0016\tp\u008dF\u00bd\u00d9\u0092\u00b2\u00b7\u0006?\u00ab\u0001^\u0095\u00a3L\u00fe\u009f\u00ef\u00d4\f\u00ba\u00bc\u00be\u0080\u00d3\b\u00f7\u00dbwMG\u0081\u00a0<\u001f\u00ce!\u009f-\u00d6\u00ce\u0083\u000b\u00ed\u008f\u00b2p\u0084\u001d^O\u00efH\u00e5\u0086f\u001b\u00fa\u00d8w\u000b\u00f9+G\u00e9\u0097\u00ca\u00b3 \u00c3\u0080\u00d54~q\u00e4\u009b\u00f4\u008d\u0014\u00a7\u00b2\u00d3\u00a7Z\u00c9\u00a2.P\u00dd\u0087ay\u001a\u0086k\u0098a\u0018e\u00c1\u00ea1xM@pd\u008c0\u00c3\u00a2\u00d0\u00cb7Z\u00c3\u00f2\u00c9\u00afY\u00f0~h\u00b8U1@\r\u00bd\u00c9I\u00b3?F\u00c098\u001a\u00eeT\u00d9\u0092\u00b6\u0088_'B\u00cc\u0000\u0095\u000b\u00fb\u00a39}\u0002\u00c4\r]\u00b9\u00b4j\u0093\u00d8(\u00f8\u0084\u00eb\u00d8!qV\u00bb\u0018M;E\u0003Pz>\u00c0\u00ebk\u00d6\u009b\u00ee\u009f\u00cc`F\u0093l\u00880\u00b0\u008e@F5\u00a2\u0089O}`i_\u00b8?-5U\u008c\u0081$Xz\u0081Y\u0000\f\u00f1\u00a1\u0003\u00ddw\u00bf\u00f6z\u0004\u00c6\u00b6c\u00fcz\u00cd\u00c5.\u00f4\u00fb\u0083!\u01b1E\u0092j\u0014D\u00a7\u00e3\u00af\u00a7?)~\u00d0\u001e\u0085\u00c7+K\u0003a\u0090\u0011\u00c3\u00b5?\u0006<\u00c2\u00ed8\u0083\u00b9\u00be\u00e07\u0089z\u00e6\u009e\u001f\u00bf}\u00b9\u000f\u0098\u00fc\u0092]\u0016\u00dfv\u0089v\u00bajH\u00fd\u00a5\u00a2\b)\u0003\u0007\u00d0\u00f6\u0013\u0083\u008a\u0087\u0015(\u0016F*\u00af\u00a1\u000b@\u001f01ND\u00a9\u00e2c\u00f4\u008ea\u00a2tu\u00cf\u0007\u000bnfj\u00e1\u00f9u\u00cc\u00ab\u00c66\u0004&\u00c5\n\u00d5-\u00d9\u00b8\u0081\u00f8-\u00b3t\u00f8\u00c9\u00fe\u00ec\u00c31\u00d8\u00ca\u0013\u00e0\u0018)\u009a\u00d62\u00e1\u008b\u0007|\u00b0\u00ba\u0001\u0091JD\u00e6\u00a8\u0003\u00f7\u00e0C?\u0002\\\u00edX,\u00e0\u00d6\u00a96\u0088\u00f8\u0094\u00c3\u0018\u001fp\u00ed/\u00e1'\u00d0\u0000\u00dc\u00f5\u00ebB\u00c7\u00c1\"Q2\u00a4\u00b8\u009e\u0018\u00d1K\u0093V*\u00b0\u0092\u0015\u009dR\u0090\u00ac\u00f3{\u00dc\u0083\u00dbV\u0091\u00f0\u00af\u001f(q6\u0014\\.\tK\u00f4\u0016\u00f1\u00b7/\u008f\u0088\u000f\u001b\u00fb\u0002\u00d7\u00fc:2\u0000c+\u001a\n!G\u00b0L\u00b7.*+\u00fa\u00ce(\u00f66 \u001f\u0082\u000fn!\u0000\u00c2\u001d\u00fe\u00c9\u00a3\u00ce'\u00f6g5\u00a1U\r\u0085C\u00ff\u00dd\u00da\u0010\u0000\u00e3\u00f6\b\u00eb8z\u0010\u0010\u00ca\u0083\u0093\u008dC q\u0000\u00c0\u00d0\u00f3;\u0083G\u009a\u001d\u00c1!\u00bc\u00d2\u00cd\u00b10\u00cd\u0002\u0001\u0092`cqs\nz)\u001b\u008b/h\u0095\u0090.\u00e9\u0000l\u00f1\u0004N\u00f6\u0018\u00f0\u0010\u009a\u00e35\u009c8G\\L\u009d\u00ec\u00c9+\u0012F\u00ab\u00c3\u001d\u00c1\u00c9UU\u00c9\u00b7\u0083\u0019m\u008f|\u007f\u00c8\u000e\u00cc\u00dd5\u001bJk\u00f0\u0017+{\u0096\u000e\u00e9\f\u0006\u0016\u00f6\u00bc\u00b9s\u00c9\u001aG{:'%\u0084\u00ce\u00c6q:\u00d14b\u00a7\r]".length();
                    var1_4 = 6;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = ++var0_5;
                        v1 = var2_2.substring(v0, v0 + var1_4);
                        v2 = -1;
                        break block23;
                        break;
                    }
lbl12:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v3.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00de\u00dc\u009f\u00ba*\u00b8;?o?\u00c3\u00cc*yW\u0015O\u00f4\u0015\u00ac\u001e\u00c7Jm\u0095c\b\u00b4\u00ce\u00b7O\u00cb\u000fD\u0000\u0014\r\u001es\u0011\u000b \u00b0\u00d9\u0005\u0016g\u00b6\u00f5\u00de";
                        var4_3 = "\u00de\u00dc\u009f\u00ba*\u00b8;?o?\u00c3\u00cc*yW\u0015O\u00f4\u0015\u00ac\u001e\u00c7Jm\u0095c\b\u00b4\u00ce\u00b7O\u00cb\u000fD\u0000\u0014\r\u001es\u0011\u000b \u00b0\u00d9\u0005\u0016g\u00b6\u00f5\u00de".length();
                        var1_4 = 44;
                        var0_5 = -1;
lbl21:
                        // 2 sources

                        while (true) {
                            v4 = ++var0_5;
                            v1 = var2_2.substring(v4, v4 + var1_4);
                            v2 = 0;
                            break block23;
                            break;
                        }
                        break;
                    }
lbl26:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v3.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block24;
                        break;
                    }
                }
                v5 = v1.toCharArray();
                var6_6 = 0;
                v6 = v5.length;
                v7 = v5;
                v8 = v6;
                if (v6 > 1) ** GOTO lbl76
                do {
                    v9 = v7;
                    v10 = v7;
                    v11 = var6_6;
                    while (true) {
                        v12 = v9[v11];
                        switch (var6_6 % 7) {
                            case 0: {
                                v13 = 81;
                                break;
                            }
                            case 1: {
                                v13 = 44;
                                break;
                            }
                            case 2: {
                                v13 = 52;
                                break;
                            }
                            case 3: {
                                v13 = 28;
                                break;
                            }
                            case 4: {
                                v13 = 53;
                                break;
                            }
                            case 5: {
                                v13 = 16;
                                break;
                            }
                            default: {
                                v13 = 98;
                            }
                        }
                        v9[v11] = (char)(v12 ^ v13);
                        ++var6_6;
                        v7 = v10;
                        v8 = v8;
                        if (v8 != 0) break;
                        v10 = v7;
                        v14 = v8;
                        v11 = v8;
                        v9 = v7;
                    }
lbl76:
                    // 2 sources

                    v15 = v7;
                    v14 = v8;
                } while (v8 > var6_6);
                v3 = new String(v15);
                switch (v2) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl85:
                    // 1 sources

                    ** continue;
                }
            }
            SmartOp.e = var5;
            SmartOp.f = new String[54];
            SmartOp.d = LoggerFactory.getLogger(SmartOp.class);
            var7_7 = System.getProperty(SmartOp.a(-2011, 1419)).toLowerCase();
            if (var7_7.indexOf(SmartOp.a(-2022, 28043)) < 0 || !MA3APIEnvironment.SET_MAC_OS_PCSC_PATH) break block25;
            System.setProperty(SmartOp.a(-1997, 30513), SmartOp.a(-2021, -22527));
        }
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0xFFFFF832) & 0xFFFF;
        if (f[n3] == null) {
            int n4;
            int n5;
            char[] cArray = e[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 136;
                    break;
                }
                case 1: {
                    n5 = 247;
                    break;
                }
                case 2: {
                    n5 = 203;
                    break;
                }
                case 3: {
                    n5 = 63;
                    break;
                }
                case 4: {
                    n5 = 51;
                    break;
                }
                case 5: {
                    n5 = 52;
                    break;
                }
                case 6: {
                    n5 = 35;
                    break;
                }
                case 7: {
                    n5 = 187;
                    break;
                }
                case 8: {
                    n5 = 114;
                    break;
                }
                case 9: {
                    n5 = 91;
                    break;
                }
                case 10: {
                    n5 = 182;
                    break;
                }
                case 11: {
                    n5 = 5;
                    break;
                }
                case 12: {
                    n5 = 232;
                    break;
                }
                case 13: {
                    n5 = 58;
                    break;
                }
                case 14: {
                    n5 = 165;
                    break;
                }
                case 15: {
                    n5 = 196;
                    break;
                }
                case 16: {
                    n5 = 168;
                    break;
                }
                case 17: {
                    n5 = 132;
                    break;
                }
                case 18: {
                    n5 = 229;
                    break;
                }
                case 19: {
                    n5 = 146;
                    break;
                }
                case 20: {
                    n5 = 212;
                    break;
                }
                case 21: {
                    n5 = 117;
                    break;
                }
                case 22: {
                    n5 = 11;
                    break;
                }
                case 23: {
                    n5 = 53;
                    break;
                }
                case 24: {
                    n5 = 202;
                    break;
                }
                case 25: {
                    n5 = 137;
                    break;
                }
                case 26: {
                    n5 = 105;
                    break;
                }
                case 27: {
                    n5 = 16;
                    break;
                }
                case 28: {
                    n5 = 226;
                    break;
                }
                case 29: {
                    n5 = 149;
                    break;
                }
                case 30: {
                    n5 = 69;
                    break;
                }
                case 31: {
                    n5 = 116;
                    break;
                }
                case 32: {
                    n5 = 163;
                    break;
                }
                case 33: {
                    n5 = 98;
                    break;
                }
                case 34: {
                    n5 = 227;
                    break;
                }
                case 35: {
                    n5 = 248;
                    break;
                }
                case 36: {
                    n5 = 72;
                    break;
                }
                case 37: {
                    n5 = 190;
                    break;
                }
                case 38: {
                    n5 = 88;
                    break;
                }
                case 39: {
                    n5 = 66;
                    break;
                }
                case 40: {
                    n5 = 228;
                    break;
                }
                case 41: {
                    n5 = 27;
                    break;
                }
                case 42: {
                    n5 = 77;
                    break;
                }
                case 43: {
                    n5 = 9;
                    break;
                }
                case 44: {
                    n5 = 200;
                    break;
                }
                case 45: {
                    n5 = 80;
                    break;
                }
                case 46: {
                    n5 = 23;
                    break;
                }
                case 47: {
                    n5 = 254;
                    break;
                }
                case 48: {
                    n5 = 224;
                    break;
                }
                case 49: {
                    n5 = 96;
                    break;
                }
                case 50: {
                    n5 = 128;
                    break;
                }
                case 51: {
                    n5 = 43;
                    break;
                }
                case 52: {
                    n5 = 223;
                    break;
                }
                case 53: {
                    n5 = 84;
                    break;
                }
                case 54: {
                    n5 = 175;
                    break;
                }
                case 55: {
                    n5 = 93;
                    break;
                }
                case 56: {
                    n5 = 86;
                    break;
                }
                case 57: {
                    n5 = 108;
                    break;
                }
                case 58: {
                    n5 = 19;
                    break;
                }
                case 59: {
                    n5 = 237;
                    break;
                }
                case 60: {
                    n5 = 220;
                    break;
                }
                case 61: {
                    n5 = 218;
                    break;
                }
                case 62: {
                    n5 = 157;
                    break;
                }
                case 63: {
                    n5 = 102;
                    break;
                }
                case 64: {
                    n5 = 221;
                    break;
                }
                case 65: {
                    n5 = 199;
                    break;
                }
                case 66: {
                    n5 = 30;
                    break;
                }
                case 67: {
                    n5 = 214;
                    break;
                }
                case 68: {
                    n5 = 139;
                    break;
                }
                case 69: {
                    n5 = 104;
                    break;
                }
                case 70: {
                    n5 = 207;
                    break;
                }
                case 71: {
                    n5 = 1;
                    break;
                }
                case 72: {
                    n5 = 127;
                    break;
                }
                case 73: {
                    n5 = 112;
                    break;
                }
                case 74: {
                    n5 = 211;
                    break;
                }
                case 75: {
                    n5 = 126;
                    break;
                }
                case 76: {
                    n5 = 18;
                    break;
                }
                case 77: {
                    n5 = 120;
                    break;
                }
                case 78: {
                    n5 = 158;
                    break;
                }
                case 79: {
                    n5 = 185;
                    break;
                }
                case 80: {
                    n5 = 167;
                    break;
                }
                case 81: {
                    n5 = 121;
                    break;
                }
                case 82: {
                    n5 = 38;
                    break;
                }
                case 83: {
                    n5 = 133;
                    break;
                }
                case 84: {
                    n5 = 184;
                    break;
                }
                case 85: {
                    n5 = 180;
                    break;
                }
                case 86: {
                    n5 = 46;
                    break;
                }
                case 87: {
                    n5 = 217;
                    break;
                }
                case 88: {
                    n5 = 6;
                    break;
                }
                case 89: {
                    n5 = 99;
                    break;
                }
                case 90: {
                    n5 = 151;
                    break;
                }
                case 91: {
                    n5 = 209;
                    break;
                }
                case 92: {
                    n5 = 206;
                    break;
                }
                case 93: {
                    n5 = 255;
                    break;
                }
                case 94: {
                    n5 = 240;
                    break;
                }
                case 95: {
                    n5 = 4;
                    break;
                }
                case 96: {
                    n5 = 122;
                    break;
                }
                case 97: {
                    n5 = 235;
                    break;
                }
                case 98: {
                    n5 = 107;
                    break;
                }
                case 99: {
                    n5 = 129;
                    break;
                }
                case 100: {
                    n5 = 119;
                    break;
                }
                case 101: {
                    n5 = 181;
                    break;
                }
                case 102: {
                    n5 = 142;
                    break;
                }
                case 103: {
                    n5 = 50;
                    break;
                }
                case 104: {
                    n5 = 210;
                    break;
                }
                case 105: {
                    n5 = 162;
                    break;
                }
                case 106: {
                    n5 = 251;
                    break;
                }
                case 107: {
                    n5 = 253;
                    break;
                }
                case 108: {
                    n5 = 204;
                    break;
                }
                case 109: {
                    n5 = 208;
                    break;
                }
                case 110: {
                    n5 = 76;
                    break;
                }
                case 111: {
                    n5 = 219;
                    break;
                }
                case 112: {
                    n5 = 85;
                    break;
                }
                case 113: {
                    n5 = 21;
                    break;
                }
                case 114: {
                    n5 = 70;
                    break;
                }
                case 115: {
                    n5 = 252;
                    break;
                }
                case 116: {
                    n5 = 12;
                    break;
                }
                case 117: {
                    n5 = 171;
                    break;
                }
                case 118: {
                    n5 = 45;
                    break;
                }
                case 119: {
                    n5 = 54;
                    break;
                }
                case 120: {
                    n5 = 148;
                    break;
                }
                case 121: {
                    n5 = 103;
                    break;
                }
                case 122: {
                    n5 = 201;
                    break;
                }
                case 123: {
                    n5 = 179;
                    break;
                }
                case 124: {
                    n5 = 145;
                    break;
                }
                case 125: {
                    n5 = 100;
                    break;
                }
                case 126: {
                    n5 = 215;
                    break;
                }
                case 127: {
                    n5 = 152;
                    break;
                }
                case 128: {
                    n5 = 249;
                    break;
                }
                case 129: {
                    n5 = 14;
                    break;
                }
                case 130: {
                    n5 = 8;
                    break;
                }
                case 131: {
                    n5 = 144;
                    break;
                }
                case 132: {
                    n5 = 36;
                    break;
                }
                case 133: {
                    n5 = 94;
                    break;
                }
                case 134: {
                    n5 = 160;
                    break;
                }
                case 135: {
                    n5 = 31;
                    break;
                }
                case 136: {
                    n5 = 39;
                    break;
                }
                case 137: {
                    n5 = 236;
                    break;
                }
                case 138: {
                    n5 = 64;
                    break;
                }
                case 139: {
                    n5 = 143;
                    break;
                }
                case 140: {
                    n5 = 166;
                    break;
                }
                case 141: {
                    n5 = 195;
                    break;
                }
                case 142: {
                    n5 = 177;
                    break;
                }
                case 143: {
                    n5 = 246;
                    break;
                }
                case 144: {
                    n5 = 140;
                    break;
                }
                case 145: {
                    n5 = 71;
                    break;
                }
                case 146: {
                    n5 = 178;
                    break;
                }
                case 147: {
                    n5 = 83;
                    break;
                }
                case 148: {
                    n5 = 55;
                    break;
                }
                case 149: {
                    n5 = 197;
                    break;
                }
                case 150: {
                    n5 = 92;
                    break;
                }
                case 151: {
                    n5 = 33;
                    break;
                }
                case 152: {
                    n5 = 73;
                    break;
                }
                case 153: {
                    n5 = 198;
                    break;
                }
                case 154: {
                    n5 = 183;
                    break;
                }
                case 155: {
                    n5 = 233;
                    break;
                }
                case 156: {
                    n5 = 48;
                    break;
                }
                case 157: {
                    n5 = 110;
                    break;
                }
                case 158: {
                    n5 = 191;
                    break;
                }
                case 159: {
                    n5 = 153;
                    break;
                }
                case 160: {
                    n5 = 193;
                    break;
                }
                case 161: {
                    n5 = 147;
                    break;
                }
                case 162: {
                    n5 = 42;
                    break;
                }
                case 163: {
                    n5 = 131;
                    break;
                }
                case 164: {
                    n5 = 13;
                    break;
                }
                case 165: {
                    n5 = 40;
                    break;
                }
                case 166: {
                    n5 = 192;
                    break;
                }
                case 167: {
                    n5 = 2;
                    break;
                }
                case 168: {
                    n5 = 250;
                    break;
                }
                case 169: {
                    n5 = 95;
                    break;
                }
                case 170: {
                    n5 = 194;
                    break;
                }
                case 171: {
                    n5 = 242;
                    break;
                }
                case 172: {
                    n5 = 62;
                    break;
                }
                case 173: {
                    n5 = 81;
                    break;
                }
                case 174: {
                    n5 = 44;
                    break;
                }
                case 175: {
                    n5 = 65;
                    break;
                }
                case 176: {
                    n5 = 241;
                    break;
                }
                case 177: {
                    n5 = 118;
                    break;
                }
                case 178: {
                    n5 = 28;
                    break;
                }
                case 179: {
                    n5 = 115;
                    break;
                }
                case 180: {
                    n5 = 239;
                    break;
                }
                case 181: {
                    n5 = 243;
                    break;
                }
                case 182: {
                    n5 = 205;
                    break;
                }
                case 183: {
                    n5 = 244;
                    break;
                }
                case 184: {
                    n5 = 188;
                    break;
                }
                case 185: {
                    n5 = 234;
                    break;
                }
                case 186: {
                    n5 = 176;
                    break;
                }
                case 187: {
                    n5 = 173;
                    break;
                }
                case 188: {
                    n5 = 82;
                    break;
                }
                case 189: {
                    n5 = 169;
                    break;
                }
                case 190: {
                    n5 = 26;
                    break;
                }
                case 191: {
                    n5 = 245;
                    break;
                }
                case 192: {
                    n5 = 17;
                    break;
                }
                case 193: {
                    n5 = 25;
                    break;
                }
                case 194: {
                    n5 = 74;
                    break;
                }
                case 195: {
                    n5 = 189;
                    break;
                }
                case 196: {
                    n5 = 101;
                    break;
                }
                case 197: {
                    n5 = 41;
                    break;
                }
                case 198: {
                    n5 = 138;
                    break;
                }
                case 199: {
                    n5 = 113;
                    break;
                }
                case 200: {
                    n5 = 24;
                    break;
                }
                case 201: {
                    n5 = 15;
                    break;
                }
                case 202: {
                    n5 = 89;
                    break;
                }
                case 203: {
                    n5 = 159;
                    break;
                }
                case 204: {
                    n5 = 3;
                    break;
                }
                case 205: {
                    n5 = 155;
                    break;
                }
                case 206: {
                    n5 = 32;
                    break;
                }
                case 207: {
                    n5 = 156;
                    break;
                }
                case 208: {
                    n5 = 134;
                    break;
                }
                case 209: {
                    n5 = 238;
                    break;
                }
                case 210: {
                    n5 = 172;
                    break;
                }
                case 211: {
                    n5 = 135;
                    break;
                }
                case 212: {
                    n5 = 34;
                    break;
                }
                case 213: {
                    n5 = 56;
                    break;
                }
                case 214: {
                    n5 = 125;
                    break;
                }
                case 215: {
                    n5 = 20;
                    break;
                }
                case 216: {
                    n5 = 141;
                    break;
                }
                case 217: {
                    n5 = 90;
                    break;
                }
                case 218: {
                    n5 = 67;
                    break;
                }
                case 219: {
                    n5 = 22;
                    break;
                }
                case 220: {
                    n5 = 47;
                    break;
                }
                case 221: {
                    n5 = 130;
                    break;
                }
                case 222: {
                    n5 = 68;
                    break;
                }
                case 223: {
                    n5 = 170;
                    break;
                }
                case 224: {
                    n5 = 37;
                    break;
                }
                case 225: {
                    n5 = 7;
                    break;
                }
                case 226: {
                    n5 = 61;
                    break;
                }
                case 227: {
                    n5 = 97;
                    break;
                }
                case 228: {
                    n5 = 124;
                    break;
                }
                case 229: {
                    n5 = 230;
                    break;
                }
                case 230: {
                    n5 = 49;
                    break;
                }
                case 231: {
                    n5 = 216;
                    break;
                }
                case 232: {
                    n5 = 225;
                    break;
                }
                case 233: {
                    n5 = 161;
                    break;
                }
                case 234: {
                    n5 = 60;
                    break;
                }
                case 235: {
                    n5 = 150;
                    break;
                }
                case 236: {
                    n5 = 231;
                    break;
                }
                case 237: {
                    n5 = 0;
                    break;
                }
                case 238: {
                    n5 = 222;
                    break;
                }
                case 239: {
                    n5 = 57;
                    break;
                }
                case 240: {
                    n5 = 59;
                    break;
                }
                case 241: {
                    n5 = 29;
                    break;
                }
                case 242: {
                    n5 = 164;
                    break;
                }
                case 243: {
                    n5 = 79;
                    break;
                }
                case 244: {
                    n5 = 174;
                    break;
                }
                case 245: {
                    n5 = 78;
                    break;
                }
                case 246: {
                    n5 = 10;
                    break;
                }
                case 247: {
                    n5 = 186;
                    break;
                }
                case 248: {
                    n5 = 154;
                    break;
                }
                case 249: {
                    n5 = 109;
                    break;
                }
                case 250: {
                    n5 = 106;
                    break;
                }
                case 251: {
                    n5 = 75;
                    break;
                }
                case 252: {
                    n5 = 87;
                    break;
                }
                case 253: {
                    n5 = 111;
                    break;
                }
                case 254: {
                    n5 = 213;
                    break;
                }
                default: {
                    n5 = 123;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            SmartOp.f[n3] = new String(cArray).intern();
        }
        return f[n3];
    }
}

