/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.Any;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.Sequence;

public class SMIMECapability
extends Sequence {
    private ObjectID capabilityID = new ObjectID("algorithm");
    private Any parameters = new Any("parameters");
    public static final String RC2_CBC_OID = "1.2.840.113549.3.2";
    public static final String RC4_CBC_OID = "1.2.840.113549.3.4";
    public static final String DES_CBC_OID = "1.3.14.3.2.7";
    public static final String DES_EDE3_CBC_OID = "1.2.840.113549.3.7";

    public SMIMECapability() {
        this("defaultSMIMECapability");
    }

    public SMIMECapability(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.capabilityID);
        super.addElement(this.parameters);
        this.parameters.setOptional(true);
    }

    public ObjectID getCapabilityID() {
        return this.capabilityID;
    }

    public void setCapabilityID(ObjectID value) {
        this.capabilityID = value;
    }

    public Any getParameters() {
        return this.parameters;
    }

    public void setParameters(Any value) {
        this.parameters = value;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }

    public void decode(byte[] input) throws DecodeException {
        super.decode(input);
        this.setCapabilityID((ObjectID)super.getElement(0));
        this.setParameters((Any)super.getElement(1));
        this.commitElementUpdate();
    }
}

