/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.cms;

import com.turktrust.asn1.ASN1Object;
import com.turktrust.asn1.Sequence;
import com.turktrust.cms.CMSVersion;
import com.turktrust.cms.KeyDerivationAlgorithmIdentifier;
import com.turktrust.pkcs7.EncryptedKey;
import com.turktrust.pkcs7.KeyEncryptionAlgorithmIdentifier;

public class PasswordRecipientInfo
extends Sequence {
    private CMSVersion version = new CMSVersion("version");
    private KeyDerivationAlgorithmIdentifier keyDerivationAlgorithm = new KeyDerivationAlgorithmIdentifier("keyDerivationAlgorithm");
    private KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithm = new KeyEncryptionAlgorithmIdentifier("keyEncryptionAlgorithm");
    private EncryptedKey encryptedKey = new EncryptedKey("encryptedKey");

    public PasswordRecipientInfo(String name) {
        super(name);
        this.setUpElements();
    }

    public PasswordRecipientInfo() {
        super("default_PasswordRecipientInfo");
        this.setUpElements();
    }

    protected void setUpElements() {
        this.keyDerivationAlgorithm.setOptional(true);
        this.keyDerivationAlgorithm.setTaggingMethod(1);
        this.keyDerivationAlgorithm.setTagClass((byte)-128);
        this.keyDerivationAlgorithm.setTagNumber(0);
        super.addElement(this.version);
        super.addElement(this.keyDerivationAlgorithm);
        super.addElement((ASN1Object)this.keyEncryptionAlgorithm);
        super.addElement((ASN1Object)this.encryptedKey);
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }

    public EncryptedKey getEncryptedKey() {
        return this.encryptedKey;
    }

    public void setEncryptedKey(EncryptedKey encryptedKey) {
        this.encryptedKey = encryptedKey;
    }

    public KeyDerivationAlgorithmIdentifier getKeyDerivationAlgorithm() {
        return this.keyDerivationAlgorithm;
    }

    public void setKeyDerivationAlgorithm(KeyDerivationAlgorithmIdentifier keyDerivationAlgorithm) {
        this.keyDerivationAlgorithm = keyDerivationAlgorithm;
    }

    public KeyEncryptionAlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public void setKeyEncryptionAlgorithm(KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithm) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    public void setVersion(CMSVersion version) {
        this.version = version;
    }
}

