/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.signature.certval.match;

import java.math.BigInteger;
import java.util.Arrays;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtensions;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectKeyIdentifier;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.api.signature.SignatureException;
import tr.gov.tubitak.uekae.esya.api.signature.certval.CertificateSearchCriteria;
import tr.gov.tubitak.uekae.esya.api.signature.certval.match.OCSPResponseCriteriaMatcher;

public class CertificateCriteriaMatcher {
    private static final String a;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean match(CertificateSearchCriteria aCriteria, ECertificate aCertificate) {
        String string = aCriteria.getIssuer();
        int n = OCSPResponseCriteriaMatcher.b;
        if (string != null && !string.equals(aCertificate.getIssuer().stringValue())) {
            return false;
        }
        BigInteger bigInteger = aCriteria.getSerial();
        if (bigInteger != null && !bigInteger.equals(aCertificate.getSerialNumber())) {
            return false;
        }
        string = aCriteria.getSubject();
        if (string != null && !string.equals(aCertificate.getSubject().stringValue())) {
            return false;
        }
        byte[] byArray = aCriteria.getSubjectKeyIdentifier();
        if (byArray != null) {
            EExtensions eExtensions = aCertificate.getExtensions();
            if (eExtensions == null) {
                return false;
            }
            ESubjectKeyIdentifier eSubjectKeyIdentifier = eExtensions.getSubjectKeyIdentifier();
            if (eSubjectKeyIdentifier == null || !Arrays.equals(byArray, eSubjectKeyIdentifier.getValue())) {
                return false;
            }
        }
        if (aCriteria.getDigestAlg() != null) {
            try {
                byArray = DigestUtil.digest((DigestAlg)aCriteria.getDigestAlg(), (byte[])aCertificate.getEncoded());
                if (!Arrays.equals(byArray, aCriteria.getDigestValue())) {
                    return false;
                }
            }
            catch (Exception exception) {
                throw new ESYARuntimeException(a, (Throwable)exception);
            }
        }
        if (n != 0) {
            int n2 = SignatureException.b;
            SignatureException.b = ++n2;
        }
        return true;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        block12: {
            int n;
            int n2;
            char[] cArray2;
            int n3;
            block11: {
                char[] cArray3 = "?\u001c\fhYL%\u0019\u001e\t<\u001dF*\u0019\u000e\u0016<\u000fN!\t\u0018Bs\u001f\u000f.\u0019\u000f\u0016u\u001fF.\u001d\t\u0007".toCharArray();
                n3 = 0;
                int n4 = cArray3.length;
                cArray2 = cArray3;
                n2 = n4;
                if (n4 <= 1) break block11;
                cArray = cArray2;
                n = n2;
                if (n2 <= n3) break block12;
            }
            do {
                char[] cArray4 = cArray2;
                char[] cArray5 = cArray2;
                int n5 = n3;
                while (true) {
                    int n6;
                    char c = cArray4[n5];
                    switch (n3 % 7) {
                        case 0: {
                            n6 = 124;
                            break;
                        }
                        case 1: {
                            n6 = 125;
                            break;
                        }
                        case 2: {
                            n6 = 98;
                            break;
                        }
                        case 3: {
                            n6 = 28;
                            break;
                        }
                        case 4: {
                            n6 = 121;
                            break;
                        }
                        case 5: {
                            n6 = 47;
                            break;
                        }
                        default: {
                            n6 = 77;
                        }
                    }
                    cArray4[n5] = (char)(c ^ n6);
                    ++n3;
                    cArray2 = cArray5;
                    n2 = n2;
                    if (n2 != 0) break;
                    cArray5 = cArray2;
                    n = n2;
                    n5 = n2;
                    cArray4 = cArray2;
                }
                cArray = cArray2;
                n = n2;
            } while (n2 > n3);
        }
        a = new String(cArray).intern();
    }
}

