/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.ASN1Object;
import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.Set;
import com.turktrust.asn1.TagInfo;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class SetOf
extends BaseASN1Object
implements Comparator {
    private Vector components = new Vector();
    private Class componentType;

    public SetOf(String name) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(17);
        this.setTagNumber(17);
        this.setConstructed(true);
    }

    public SetOf(String name, Object value) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(17);
        this.setTagNumber(17);
        this.setConstructed(true);
        this.componentType = value instanceof Class ? (Class)value : value.getClass();
    }

    public void setValue(Object value) {
        if (value instanceof Vector) {
            this.components = (Vector)value;
        }
    }

    public Object getValue() {
        return this.components;
    }

    public void addElement(ASN1Object element) {
        Class<?> x = element.getClass();
        if (x.equals(this.componentType)) {
            this.components.addElement(element);
        }
    }

    public ASN1Object getElement(String name) {
        for (int i = 0; i < this.components.size(); ++i) {
            ASN1Object element = (ASN1Object)this.components.elementAt(i);
            String elementName = element.getName();
            if (elementName == null || !elementName.equalsIgnoreCase(name)) continue;
            return element;
        }
        return null;
    }

    public void decode(byte[] data) throws DecodeException {
        TagInfo tagInfo = this.getTagInfo(data, 0);
        if (this.tagClass != tagInfo.tagClass) {
            throw new DecodeException();
        }
        if (this.tagMethod != tagInfo.tagMethod) {
            throw new DecodeException();
        }
        if (this.tagNumber != tagInfo.tagNumber) {
            throw new DecodeException();
        }
        if (this.tagMethod != 1 && this.type != tagInfo.type) {
            throw new DecodeException();
        }
        if (tagInfo.contentIndex + tagInfo.contentLength != data.length) {
            throw new DecodeException();
        }
        SetOf.trace("Set.decode: " + this.toString());
        SetOf.trace("Set.decode: tagInfo =\n" + tagInfo.toString() + "\n");
        int startAtIdx = 1;
        int idx = tagInfo.contentIndex;
        while (idx < tagInfo.contentIndex + tagInfo.contentLength) {
            TagInfo x = this.getTagInfo(data, idx);
            if (x == null) {
                throw new DecodeException();
            }
            SetOf.trace("SequenceOf.decode: " + this.getName() + " decoding component specified by:\n" + x.toString());
            try {
                ASN1Object newComponent = (ASN1Object)this.componentType.newInstance();
                newComponent.setName(this.getName() + "." + startAtIdx++);
                SetOf.trace("SequenceOf.decode: added component " + newComponent.getName());
                this.addElement(newComponent);
                int y = x.contentLength + (x.contentIndex - x.tagIndex);
                byte[] content = new byte[y];
                System.arraycopy(data, x.tagIndex, content, 0, y);
                newComponent.decode(content);
                SetOf.trace("SequenceOf.decode: done: " + newComponent.toString());
            }
            catch (Exception e) {
                throw new DecodeException();
            }
            idx = x.contentIndex + x.contentLength;
        }
    }

    protected byte[] getContentEncoding() {
        byte[] contents;
        Vector<byte[]> componentEncodings = new Vector<byte[]>(this.components.size());
        int len = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            ASN1Object object = (ASN1Object)this.components.elementAt(i);
            contents = object.getEncoded();
            componentEncodings.addElement(contents);
            len += contents.length;
        }
        byte[] totalContents = new byte[len];
        len = 0;
        Collections.sort(componentEncodings, this);
        for (int i = 0; i < componentEncodings.size(); ++i) {
            contents = (byte[])componentEncodings.elementAt(i);
            System.arraycopy(contents, 0, totalContents, len, contents.length);
            len += contents.length;
        }
        return totalContents;
    }

    public String toString() {
        return new String(super.toString());
    }

    public int compare(Object o1, Object o2) {
        byte[] a1 = (byte[])o1;
        byte[] a2 = (byte[])o2;
        int len = 0;
        len = a1.length < a2.length ? a1.length : a2.length;
        for (int i = 0; i < len; ++i) {
            int tempa2;
            int tempa1 = a1[i] < 0 ? a1[i] + 256 : a1[i];
            int n = tempa2 = a2[i] < 0 ? a2[i] + 256 : a2[i];
            if (tempa1 < tempa2) {
                return -1;
            }
            if (tempa1 <= tempa2) continue;
            return 1;
        }
        if (a1.length < a2.length) {
            return -1;
        }
        if (a1.length > a2.length) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof Set;
    }

    public static void main(String[] args) throws DecodeException {
        try {
            SetOf.trace("SetOf.main: creating a new SetOf");
            SetOf x = new SetOf("setOf", Class.forName("au.com.forge.framework.asn1.ASN1Integer"));
            SetOf.trace("SetOf.main: adding integers");
            x.addElement(new ASN1Integer("e1", "9"));
            x.addElement(new ASN1Integer("e2", "4"));
            SetOf.trace("SetOf.main: decoding");
            byte[] f = x.getEncoded();
            for (int z = 0; z < f.length; ++z) {
                System.out.print(Integer.toString(f[z] & 0xFF, 16) + " ");
            }
            System.out.println("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

