/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.cmssignature.validation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignerIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EBasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.CertificateStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.PathValidationRecord;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.PathValidationResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.crl.CRLStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.ocsp.OCSPResponseStatusInfo;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CMSSignatureException;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeOIDs;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.BaseSignedData;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.ESignatureType;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.Signer;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.ATSHashIndexCollector;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.DefaultValidationParameters;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.SignatureValidationResult;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.SignedDataValidation;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.Types;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.ValidationMessage;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.c;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.ArchiveTimeStampAttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.ArchiveTimeStampV2AttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.ArchiveTimeStampV3AttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.BaseChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CAdES_C_TimeStampAttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CertificateChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CertificateRefsValuesMatchChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckAllChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.Checker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckerResult;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.ContentTimeStampAttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.ContentTypeAttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CryptoChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.MessageDigestAttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.RevocationRefsValuesMatchChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.SignaturePolicyChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.SignatureTimeStampAttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.SigningCertificateAttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.TimeStampedCertsCrlsRefsAttrChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.TurkishProfileAttributesChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.ValidationState;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.signature.certval.CertificateSearchCriteria;
import tr.gov.tubitak.uekae.esya.api.signature.certval.ValidationInfoResolver;

public class SignatureValidator {
    private static Logger a;
    private List<Checker> b = new ArrayList<Checker>();
    private List<ECertificate> c = new ArrayList<ECertificate>();
    private List<ECRL> d = new ArrayList<ECRL>();
    private List<EBasicOCSPResponse> e = new ArrayList<EBasicOCSPResponse>();
    BaseSignedData f = null;
    private byte[] g = null;
    private static final String[] h;
    private static final String[] i;

    public SignatureValidator(byte[] aContentInfo) throws CMSSignatureException {
        this.g = aContentInfo;
        this.f = new BaseSignedData(aContentInfo);
    }

    private ArrayList<Checker> a(ESignatureType eSignatureType) throws CMSSignatureException {
        ArrayList<Checker> arrayList = new ArrayList<Checker>();
        arrayList.add(new CryptoChecker());
        arrayList.add(new MessageDigestAttrChecker());
        arrayList.add(new SigningCertificateAttrChecker());
        arrayList.add(new CertificateChecker());
        if (eSignatureType == ESignatureType.TYPE_BES) {
            return arrayList;
        }
        ArrayList<Checker> arrayList2 = new ArrayList<Checker>();
        arrayList2.addAll(arrayList);
        if (eSignatureType == ESignatureType.TYPE_EPES) {
            return arrayList2;
        }
        ArrayList<Checker> arrayList3 = new ArrayList<Checker>();
        arrayList3.addAll(arrayList);
        arrayList3.add(new SignatureTimeStampAttrChecker());
        if (eSignatureType == ESignatureType.TYPE_EST) {
            return arrayList3;
        }
        ArrayList<Checker> arrayList4 = new ArrayList<Checker>();
        arrayList4.addAll(arrayList3);
        if (eSignatureType == ESignatureType.TYPE_ESC) {
            return arrayList4;
        }
        ArrayList<Checker> arrayList5 = new ArrayList<Checker>();
        arrayList5.addAll(arrayList4);
        arrayList5.add(new CAdES_C_TimeStampAttrChecker());
        if (eSignatureType == ESignatureType.TYPE_ESX_Type1) {
            return arrayList5;
        }
        ArrayList<Checker> arrayList6 = new ArrayList<Checker>();
        arrayList6.addAll(arrayList4);
        arrayList6.add(new TimeStampedCertsCrlsRefsAttrChecker());
        if (eSignatureType == ESignatureType.TYPE_ESX_Type2) {
            return arrayList6;
        }
        ArrayList<Checker> arrayList7 = new ArrayList<Checker>();
        arrayList7.addAll(arrayList4);
        arrayList7.add(new RevocationRefsValuesMatchChecker());
        arrayList7.add(new CertificateRefsValuesMatchChecker());
        if (eSignatureType == ESignatureType.TYPE_ESXLong) {
            return arrayList7;
        }
        ArrayList<Checker> arrayList8 = new ArrayList<Checker>();
        arrayList8.addAll(arrayList7);
        arrayList8.add(new CAdES_C_TimeStampAttrChecker());
        if (eSignatureType == ESignatureType.TYPE_ESXLong_Type1) {
            return arrayList8;
        }
        ArrayList<Checker> arrayList9 = new ArrayList<Checker>();
        arrayList9.addAll(arrayList7);
        arrayList9.add(new TimeStampedCertsCrlsRefsAttrChecker());
        if (eSignatureType == ESignatureType.TYPE_ESXLong_Type2) {
            return arrayList9;
        }
        ArrayList<Checker> arrayList10 = new ArrayList<Checker>();
        arrayList10.addAll(arrayList);
        ArrayList<Checker> arrayList11 = new ArrayList<Checker>();
        arrayList11.add(new CAdES_C_TimeStampAttrChecker());
        arrayList11.add(new TimeStampedCertsCrlsRefsAttrChecker());
        arrayList10.add(new CheckAllChecker(arrayList11, false));
        ArrayList<Checker> arrayList12 = new ArrayList<Checker>();
        arrayList12.add(new ArchiveTimeStampAttrChecker());
        arrayList12.add(new ArchiveTimeStampV2AttrChecker());
        arrayList12.add(new ArchiveTimeStampV3AttrChecker());
        arrayList10.add(new CheckAllChecker(arrayList12, true));
        if (eSignatureType == ESignatureType.TYPE_ESA) {
            return arrayList10;
        }
        throw new CMSSignatureException(SignatureValidator.a(26349, -10743));
    }

    public void setCertificates(List<ECertificate> aCerts) {
        this.c = aCerts;
    }

    public void setCRLs(List<ECRL> aCRLs) {
        this.d = aCRLs;
    }

    public void setOCSPs(List<EBasicOCSPResponse> aOCSPs) {
        this.e = aOCSPs;
    }

    List<Checker> a(Signer signer, boolean bl, ESignatureType eSignatureType, Map<String, Object> map) throws CMSSignatureException {
        ArrayList<Checker> arrayList;
        block35: {
            block31: {
                block34: {
                    boolean bl2;
                    block33: {
                        block32: {
                            arrayList = this.a(eSignatureType);
                            bl2 = Types.b;
                            if (!bl) {
                                arrayList.add(new ContentTypeAttrChecker());
                            }
                            if (signer.getType() != ESignatureType.TYPE_ESA) break block31;
                            if (!signer._checkIfSignerIsESAV2()) break block32;
                            arrayList.add(new SignatureTimeStampAttrChecker());
                            arrayList.add(new RevocationRefsValuesMatchChecker());
                            arrayList.add(new CertificateRefsValuesMatchChecker());
                            if (!bl2) break block31;
                        }
                        if (signer.getUnsignedAttribute(AttributeOIDs.id_aa_signatureTimeStampToken).size() <= 0) break block33;
                        arrayList.add(new SignatureTimeStampAttrChecker());
                    }
                    if (signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_certValues).size() <= 0 || signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_revocationValues).size() <= 0) break block34;
                    arrayList.add(new RevocationRefsValuesMatchChecker());
                    arrayList.add(new CertificateRefsValuesMatchChecker());
                    if (!bl2) break block31;
                }
                if (signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_certificateRefs).size() != 0) break block31;
                if (signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_revocationRefs).size() != 0) break block31;
                map.put(SignatureValidator.a(26341, -11776), true);
            }
            if (signer.getSignedAttribute(AttributeOIDs.id_aa_ets_sigPolicyId).size() > 0) {
                arrayList.add(new SignaturePolicyChecker());
            }
            if (!signer.isTurkishProfile() || Boolean.TRUE.equals(map.get(SignatureValidator.a(26357, -14888)))) break block35;
            arrayList.add(new TurkishProfileAttributesChecker());
        }
        if (signer.getSignedAttribute(AttributeOIDs.id_aa_ets_contentTimestamp).size() > 0) {
            arrayList.add(new ContentTimeStampAttrChecker());
        }
        return arrayList;
    }

    public void verify(SignatureValidationResult aSVR, Signer aSigner, boolean aIsCounterSigner, Map<String, Object> aParams) throws CMSSignatureException {
        List<EBasicOCSPResponse> list;
        HashMap<String, Object> hashMap;
        boolean bl;
        block28: {
            List<ECRL> list2;
            block31: {
                boolean bl2;
                block29: {
                    block30: {
                        Object object;
                        block27: {
                            Object object2;
                            ESignatureType eSignatureType = aSigner.getType();
                            bl = Types.b;
                            List<Checker> list3 = this.a(aSigner, aIsCounterSigner, eSignatureType, aParams);
                            ECertificate eCertificate = this.a(this.c, aSigner.getSignerInfo().getSignerIdentifier(), aParams);
                            if (eCertificate == null) {
                                throw new CMSSignatureException(SignatureValidator.a(26306, -19367));
                            }
                            this.a(eCertificate);
                            hashMap = new HashMap<String, Object>();
                            hashMap.put(SignatureValidator.a(26342, 16295), eCertificate);
                            hashMap.put(SignatureValidator.a(26364, -30721), this.f.getSignedData());
                            hashMap.put(SignatureValidator.a(26311, -4568), this.c);
                            hashMap.put(SignatureValidator.a(26307, -15621), this.d);
                            hashMap.put(SignatureValidator.a(26304, 7512), this.e);
                            hashMap.put(SignatureValidator.a(26337, -22974), this.g);
                            if (aParams != null) {
                                hashMap.putAll(aParams);
                            }
                            this.a(hashMap);
                            aSVR.setSignerCertificate((ECertificate)hashMap.get(SignatureValidator.a(26352, 722)));
                            if (eSignatureType == ESignatureType.TYPE_ESA) {
                                SignedDataValidation signedDataValidation = new SignedDataValidation();
                                signedDataValidation._fillCertRevocationLists(this.f.getSignedData(), aSigner, aParams);
                                hashMap.put(SignatureValidator.a(26343, 20050), signedDataValidation.mCerts);
                                hashMap.put(SignatureValidator.a(26367, 5755), signedDataValidation.mCRLs);
                                hashMap.put(SignatureValidator.a(26360, 26277), signedDataValidation.mOCSPs);
                                if (aSigner._checkIfSignerIsESAV3()) {
                                    object2 = new ATSHashIndexCollector();
                                    ((ATSHashIndexCollector)object2).checkATSHashIndex(aSigner);
                                    object = signedDataValidation.mCerts;
                                    list2 = signedDataValidation.mCRLs;
                                    list = signedDataValidation.mOCSPs;
                                    object.removeAll(((ATSHashIndexCollector)object2).a);
                                    list2.removeAll(((ATSHashIndexCollector)object2).b);
                                    list.removeAll(((ATSHashIndexCollector)object2).c);
                                    hashMap.put(SignatureValidator.a(26343, 20050), object);
                                    hashMap.put(SignatureValidator.a(26367, 5755), list2);
                                    hashMap.put(SignatureValidator.a(26360, 26277), list);
                                }
                            }
                            bl2 = true;
                            object2 = new ArrayList<Checker>();
                            object2.addAll(this.b);
                            object2.addAll(list3);
                            object = object2.iterator();
                            while (object.hasNext()) {
                                list2 = (Checker)object.next();
                                list2.setParameters(hashMap);
                                list = new CheckerResult();
                                boolean bl3 = list2.check(aSigner, (CheckerResult)((Object)list));
                                aSVR.addCheckResult((CheckerResult)((Object)list));
                                if (bl2) {
                                    bl2 = bl3;
                                }
                                if (!bl) continue;
                                int n = BaseChecker.d;
                                BaseChecker.d = ++n;
                                break;
                            }
                            object = aSVR.getSignatureStatus();
                            list2 = aSVR;
                            if (object != Types.Signature_Status.INVALID) break block27;
                            ((SignatureValidationResult)((Object)list2)).setSignatureStatus(Types.Signature_Status.INVALID);
                            ((SignatureValidationResult)((Object)list2)).setDescription(SignatureValidator.a(26363, -29221));
                            ((SignatureValidationResult)((Object)list2)).getCheckerResults().add(this.a(Types.CheckerResult_Status.UNSUCCESS));
                            if (!bl) break block28;
                        }
                        if (object != Types.Signature_Status.INCOMPLETE) break block29;
                        ((SignatureValidationResult)((Object)list2)).getCheckerResults().add(this.a(Types.CheckerResult_Status.UNSUCCESS));
                        if (bl2) break block30;
                        ((SignatureValidationResult)((Object)list2)).setSignatureStatus(Types.Signature_Status.INVALID);
                        this.a((SignatureValidationResult)((Object)list2));
                        if (!bl) break block28;
                    }
                    ((SignatureValidationResult)((Object)list2)).setSignatureStatus(Types.Signature_Status.INCOMPLETE);
                    ((SignatureValidationResult)((Object)list2)).setDescription(SignatureValidator.a(26363, -29221));
                    if (!bl) break block28;
                }
                if (bl2) break block31;
                ((SignatureValidationResult)((Object)list2)).setSignatureStatus(Types.Signature_Status.INVALID);
                this.a((SignatureValidationResult)((Object)list2));
                if (!bl) break block28;
            }
            this.b((SignatureValidationResult)((Object)list2));
            ((SignatureValidationResult)((Object)list2)).setSignatureStatus(Types.Signature_Status.VALID);
        }
        list = aSigner.getCounterSigners();
        for (Signer signer : list) {
            this.a(aSigner, signer, aSVR, hashMap);
            if (!bl) continue;
        }
    }

    private CheckerResult a(Types.CheckerResult_Status checkerResult_Status) {
        CheckerResult checkerResult;
        block5: {
            block4: {
                checkerResult = new CheckerResult();
                boolean bl = Types.b;
                checkerResult.setCheckerName(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNATURE_CHECKER, new String[0]), c.class);
                checkerResult.setResultStatus(checkerResult_Status);
                if (checkerResult_Status != Types.CheckerResult_Status.SUCCESS) break block4;
                checkerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNATURE_VALID, new String[0])));
                if (!bl) break block5;
            }
            checkerResult.addMessage(new ValidationMessage(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNATURE_INVALID, new String[0])));
        }
        return checkerResult;
    }

    private void a(Signer signer, Signer signer2, SignatureValidationResult signatureValidationResult, Map<String, Object> map) throws CMSSignatureException {
        Serializable serializable;
        ECertificate eCertificate;
        block12: {
            map.put(SignatureValidator.a(26345, -6088), signer.getSignerInfo());
            eCertificate = this.a(this.c, signer2.getSignerInfo().getSignerIdentifier(), map);
            if (eCertificate == null) {
                throw new CMSSignatureException(SignatureValidator.a(26351, -21056));
            }
            map.put(SignatureValidator.a(26352, 722), eCertificate);
            try {
                if (map.containsKey(SignatureValidator.a(26358, -12196))) break block12;
                serializable = signer2.getESAv2Time();
                if (serializable == null) {
                    serializable = signer2.getESAv3Time();
                }
                if (serializable != null) {
                    map.put(SignatureValidator.a(26354, -31215), serializable);
                }
            }
            catch (ESYAException eSYAException) {
                a.warn(SignatureValidator.a(26319, 24111), (Throwable)eSYAException);
                throw new CMSSignatureException(SignatureValidator.a(26365, -13855));
            }
        }
        serializable = new SignatureValidationResult();
        if (signatureValidationResult.getSignatureStatus() != Types.Signature_Status.VALID) {
            ((SignatureValidationResult)serializable).setSignatureStatus(signatureValidationResult.getSignatureStatus());
        }
        this.verify((SignatureValidationResult)serializable, signer2, true, map);
        ((SignatureValidationResult)serializable).setSignerCertificate(eCertificate);
        signatureValidationResult.addCounterSigValidationResult((SignatureValidationResult)serializable);
        map.remove(SignatureValidator.a(26354, -31215));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(ECertificate eCertificate) {
        try {
            boolean bl = LV.getInstance().isTL(LV.Urunler.CMSIMZA);
            if (!bl) return;
            if (eCertificate.getSubject().getCommonNameAttribute().toLowerCase().contains(SignatureValidator.a(26359, 629))) return;
            throw new ESYARuntimeException(SignatureValidator.a(26338, -13216));
        }
        catch (LE lE) {
            throw new ESYARuntimeException(SignatureValidator.a(26347, 16478) + lE.getMessage());
        }
    }

    private void a(Map<String, Object> map) {
        block39: {
            block38: {
                boolean bl;
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                block33: {
                                    block32: {
                                        bl = Types.b;
                                        if (map.containsKey(SignatureValidator.a(26339, -11927))) break block32;
                                        map.put(SignatureValidator.a(26344, 31940), DefaultValidationParameters.DEFAULT_TRUST_SIGNINGTIMEATTR);
                                        if (!a.isDebugEnabled()) break block33;
                                        a.debug(SignatureValidator.a(26340, -31618));
                                        if (!bl) break block33;
                                    }
                                    if (map.get(SignatureValidator.a(26344, 31940)) instanceof Boolean) break block33;
                                    map.put(SignatureValidator.a(26344, 31940), DefaultValidationParameters.DEFAULT_TRUST_SIGNINGTIMEATTR);
                                    a.debug(SignatureValidator.a(26356, -16323));
                                }
                                if (map.containsKey(SignatureValidator.a(26346, -22221))) break block34;
                                map.put(SignatureValidator.a(26336, -7470), DefaultValidationParameters.DEFAULT_GRACE_PERIOD);
                                if (!a.isDebugEnabled()) break block35;
                                a.debug(SignatureValidator.a(26362, -16030) + DefaultValidationParameters.DEFAULT_GRACE_PERIOD + ".");
                                if (!bl) break block35;
                            }
                            if (map.get(SignatureValidator.a(26336, -7470)) instanceof Long) break block35;
                            map.put(SignatureValidator.a(26336, -7470), DefaultValidationParameters.DEFAULT_GRACE_PERIOD);
                            a.debug(SignatureValidator.a(26366, 6880) + DefaultValidationParameters.DEFAULT_GRACE_PERIOD + ".");
                        }
                        if (map.containsKey(SignatureValidator.a(26305, 21737))) break block36;
                        map.put(SignatureValidator.a(26310, -9866), DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE);
                        if (!a.isDebugEnabled()) break block37;
                        a.debug(SignatureValidator.a(26355, -7872) + DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE + ".");
                        if (!bl) break block37;
                    }
                    if (map.get(SignatureValidator.a(26310, -9866)) instanceof Long) break block37;
                    map.put(SignatureValidator.a(26310, -9866), DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE);
                    a.debug(SignatureValidator.a(26308, -5902) + DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE + ".");
                }
                if (map.containsKey(SignatureValidator.a(26361, -407))) break block38;
                map.put(SignatureValidator.a(26353, 29075), DefaultValidationParameters.DEFAULT_IGNORE_GRACE);
                if (!a.isDebugEnabled()) break block39;
                a.debug(SignatureValidator.a(26350, 30940) + DefaultValidationParameters.DEFAULT_GRACE_PERIOD + ".");
                if (!bl) break block39;
            }
            if (map.get(SignatureValidator.a(26353, 29075)) instanceof Boolean) break block39;
            map.put(SignatureValidator.a(26353, 29075), DefaultValidationParameters.DEFAULT_IGNORE_GRACE);
            a.debug(SignatureValidator.a(26309, -3387) + DefaultValidationParameters.DEFAULT_IGNORE_GRACE + ".");
        }
    }

    private ECertificate a(List<ECertificate> list, ESignerIdentifier eSignerIdentifier, Map<String, Object> map) {
        Iterator<ECertificate> iterator = list.iterator();
        boolean bl = Types.b;
        while (iterator.hasNext()) {
            ECertificate eCertificate = iterator.next();
            if (eSignerIdentifier.isEqual(eCertificate)) {
                return eCertificate;
            }
            if (!bl) continue;
        }
        return this.a(eSignerIdentifier, map);
    }

    private ECertificate a(ESignerIdentifier eSignerIdentifier, Map<String, Object> map) {
        ECertificate eCertificate;
        block10: {
            List list;
            block8: {
                boolean bl;
                CertificateSearchCriteria certificateSearchCriteria;
                block9: {
                    eCertificate = null;
                    certificateSearchCriteria = null;
                    bl = Types.b;
                    if (eSignerIdentifier.getIssuerAndSerialNumber() != null) {
                        certificateSearchCriteria = new CertificateSearchCriteria(eSignerIdentifier.getIssuerAndSerialNumber().getIssuer().stringValue(), eSignerIdentifier.getIssuerAndSerialNumber().getSerialNumber());
                    } else if (eSignerIdentifier.getSubjectKeyIdentifier() != null) {
                        certificateSearchCriteria = new CertificateSearchCriteria(eSignerIdentifier.getSubjectKeyIdentifier());
                    }
                    if (certificateSearchCriteria != null) break block9;
                    eCertificate = null;
                    if (!bl) break block10;
                }
                ValidationInfoResolver validationInfoResolver = new ValidationInfoResolver();
                validationInfoResolver.addCertificates(this.c);
                list = validationInfoResolver.resolve(certificateSearchCriteria);
                if (list != null && list.size() != 0) break block8;
                eCertificate = null;
                if (!bl) break block10;
            }
            eCertificate = (ECertificate)list.get(0);
        }
        return eCertificate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(SignatureValidationResult signatureValidationResult) {
        block18: {
            boolean bl;
            block22: {
                block21: {
                    CheckerResult checkerResult;
                    List<CheckerResult> list = signatureValidationResult.getCheckerResults();
                    bl = Types.b;
                    CertificateStatusInfo certificateStatusInfo = list.iterator();
                    while (certificateStatusInfo.hasNext()) {
                        checkerResult = certificateStatusInfo.next();
                        if (checkerResult.getResultStatus() != Types.CheckerResult_Status.SUCCESS && !checkerResult.getCheckerClass().equals(CertificateChecker.class)) {
                            signatureValidationResult.setSignatureStatus(Types.Signature_Status.INVALID);
                            signatureValidationResult.setDescription(SignatureValidator.a(26348, 24346));
                            return;
                        }
                        if (!bl) continue;
                    }
                    if ((certificateStatusInfo = signatureValidationResult.getCertStatusInfo()) == null || certificateStatusInfo.getValidationHistory() == null || certificateStatusInfo.getValidationHistory().size() == 0) {
                        signatureValidationResult.setSignatureStatus(Types.Signature_Status.INVALID);
                        signatureValidationResult.setDescription(SignatureValidator.a(26363, -29221));
                        if (!bl) return;
                    }
                    if ((checkerResult = certificateStatusInfo.getCertificateStatus()) != CertificateStatus.PATH_VALIDATION_FAILURE) break block18;
                    List list2 = certificateStatusInfo.getValidationHistory();
                    boolean bl2 = true;
                    for (PathValidationRecord pathValidationRecord : list2) {
                        block20: {
                            block19: {
                                if (pathValidationRecord.getResultCode() != PathValidationResult.REVOCATION_CONTROL_FAILURE) break block19;
                                bl2 = true;
                                if (!bl) break block20;
                            }
                            bl2 = false;
                        }
                        if (!bl) continue;
                    }
                    if (!bl2) break block21;
                    signatureValidationResult.setSignatureStatus(Types.Signature_Status.INCOMPLETE);
                    signatureValidationResult.setDescription(SignatureValidator.a(26363, -29221));
                    if (!bl) break block22;
                }
                signatureValidationResult.setSignatureStatus(Types.Signature_Status.INVALID);
                signatureValidationResult.setDescription(SignatureValidator.a(26363, -29221));
            }
            if (!bl) return;
        }
        signatureValidationResult.setSignatureStatus(Types.Signature_Status.INVALID);
        signatureValidationResult.setDescription(SignatureValidator.a(26363, -29221));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void b(SignatureValidationResult signatureValidationResult) {
        int n;
        OCSPResponseStatusInfo oCSPResponseStatusInfo;
        List list;
        boolean bl;
        Calendar calendar;
        block11: {
            block13: {
                block12: {
                    CertificateStatusInfo certificateStatusInfo = signatureValidationResult.getCertStatusInfo();
                    calendar = signatureValidationResult.getSigningTime();
                    List list2 = certificateStatusInfo.getOCSPResponseInfoList();
                    bl = Types.b;
                    list = certificateStatusInfo.getCRLInfoList();
                    if (list2.size() == 0) break block11;
                    oCSPResponseStatusInfo = (OCSPResponseStatusInfo)list2.get(0);
                    for (n = 1; n < list2.size(); ++n) {
                        if (!((OCSPResponseStatusInfo)list2.get(n)).getOCSPResponse().getBasicOCSPResponse().getProducedAt().after(oCSPResponseStatusInfo.getOCSPResponse().getBasicOCSPResponse().getProducedAt())) continue;
                        oCSPResponseStatusInfo = (OCSPResponseStatusInfo)list2.get(n);
                        if (!bl) continue;
                    }
                    if (!oCSPResponseStatusInfo.getOCSPResponse().getBasicOCSPResponse().getProducedAt().after(calendar)) break block12;
                    signatureValidationResult.setValidationState(ValidationState.MATURE);
                    if (!bl) break block13;
                }
                signatureValidationResult.setValidationState(ValidationState.PREMATURE);
            }
            if (!bl) return;
        }
        if (list.size() == 0) return;
        oCSPResponseStatusInfo = (CRLStatusInfo)list.get(0);
        for (n = 1; n < list.size(); ++n) {
            if (!((CRLStatusInfo)list.get(n)).getCRL().getThisUpdate().after(oCSPResponseStatusInfo.getCRL().getThisUpdate())) continue;
            oCSPResponseStatusInfo = (CRLStatusInfo)list.get(n);
            if (!bl) continue;
        }
        if (oCSPResponseStatusInfo.getCRL().getThisUpdate().after(calendar)) {
            signatureValidationResult.setValidationState(ValidationState.MATURE);
            if (!bl) return;
        }
        signatureValidationResult.setValidationState(ValidationState.PREMATURE);
    }

    protected void setUserDefinedCheckers(List<Checker> aUserDefinedCheckers) {
        this.b = aUserDefinedCheckers;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[41];
                var3_1 = 0;
                var2_2 = "\u00c5\u009a\u001d\u00a1\u009f\\\u00bcc)k~\u00ec\u0014\u0099\u00ba\u008b\u00c5\u00f6\u0015\u00f3\b\u00c9\u00f6^\u0002\u00e4\u0090|tif\u00a6\u00bc\u009c\u00c8\u0004\u00de\u00b8V\u00f2\u0011\u0007\u0086A=\u009d: \u009d\u00d7\u00fb\u00d6:\u00cbM\u00c8\u0089\u001e]\u00dd\u0084\u000b|\u00f36\u001c\u00b9\u00c9tM\u00b9\u00bd7\u0089\u00f2i\u00c7\u0011\u00afR\u00d1\u0001zB\u0013\u00b6\u0087\u009e\u001f\u00d9E\u00aa\u00b3\u00c98\u009a\u00ca\u0012\u0097\u0012\u00b2\u001a\u00f8\u0014\u008d\u00c6M2\u00e7?-\n\u00d0\u0007\u00dd\u001f\u00f7\u0016_\u00bd\u0094\u0083\u00f5\u0099\u00e6\u00f0\u00e2?sm\u008c\u00b6\"\u00f2:i/\u00bd?\u00d3\u00bf\u00e1\u00d7\u00abv\u0011 ~08\u009b\u00f3\u0017\u00e2I\u00ec\u00c5\u000f\u0001\u0083_:\u00a83\"rDp\u009cV\n\u00f6\u0016\u00ae\u00e6\u009enP\u00ae\u00b3}\u00dc\u0018A2wE\u00a58\u00fb\u00f3\u00f0\u00f4\"\u00b5<\u00fe\u0088\u00f7?\u0090\u00a6(\u0084t\u00cc(J\u00c3\u001adPT\u00eeciHu\u0081\u00caJ\u00b2\u00dfb\u00c0\u00a0z\u00fbx\u009c\u007f-\u00bd\u00ad\u001d\u0092\u00e2*XN\u0081-\u00b9,\u0011'\u00e8tg\u000f<\u00ed%\u001b.\u00f6XW\u00f0R\u00b3\u0093\u00fa\u00ae\u00bac\u000b\u0007\u00b5b\u00c6n!\u0099\u00af\u0088\u00fb\u00ee\by\u00a6z\u00e0A\u0087Y\u00c1\u0014!\u000e\u00830\f\u0006\u008aI/Ox\n\u00db@\u00b3+%1\u008aY\u000e\u0098\u00bb\u00b0\u009b\u00e1\u00da\u00d96A\u0089*\u008c\u00e0|!D\u001dh\u0083\u00faS\u007f\fif\u009a\u0080=\u00f4w|+\u00ad\u00a6\u00edX\u00c5\u00f5\u0085,\u00e8y{}w\u00fd[+Et\u008b-\u009dR\u001a\u00af.\u008f\u008a\u00f3\u00ec\u00dbp\u00e4ug\u00a8\u00d9\u00b6\u00da{0Y\u00e5g\u0019AI\u00a4@<\u00984\u00b3v)-!\u009f\u0081\u0084F\u00b0\u001a\u00a8G\u0001\u00cfb\u0012\u0086\u00f58Dj\u00c6\u00ae\u00e0zR\u00d9\u00edc\u0013;\u00e65\u00f4\u00168\u00ac\rR\u00f5l\u009b-DV\u00dc\u00f9\u0083!Qk*{\u00c1\u00c0_2\u0012?\u0002C\u00ebd\u0086\u000eb\u00f6\f\u0084\"\u00ed\u00a1j\u00dfW\u00d5\u001b\u00c5\u0092\u00b0}|c\u00c5\u00034\u00b6z\u001e(Z\u00ebMz\u00e6\u000b\u0002\u00c7}p<c\u00f4\u008b\u000e\u00be{t\u0083y\u00d9\u00caV#\u0085f\riL\u0014zy\u00fb\u00d0n\u00c4R8U4]\u00e1w\u001f\"\u0096\u00ab\"J~\u0017d\u007f<\u0003\u0015\u00d9\u00c0DR\u00cb>N\u00d3\u00c9D-\u00d0<&\u00d0\u00b4>\u00dd\u0004\u00bby@\u0098\u0011^\u0099\u007f\u00cc\u00feG@H\u0017,\u000f0u\u00f2J\n\u00d2\u0011\u0099\u00d9\u0087\u00c4\u00f7F\u00a8c\u00b8/c\u00d2p@+CaX\u00cd\u001b\t\u008f\u00b3H\u0014v\u00c8\u008dm\u0086\u00b9\u00d0\t\u000eyX\u0013\\\u0012\u00af\t\u00b5C\u00ea\u0096\u00b8\u009a\u00f8Y\u00b9\u00ba,\u00ca\u00d9\u0088\u00e8qR*\u00d1\u00b9~v\u0098]\u00d22\u00da5\u00ebJ\u00ef\u00f0\u009fa\u00b9oC\u00da|[\u00b1\u007fnv\u00f1\u0099N\u0017\u0082\u00a2+\u001a\u00f3\u00e4&2\u0093\u00c2 p;A/\u00cf\u001am{\u008b\u00df\u0080p\u0001P\u0095\u0081 \u00bb\u00a3x\u00c38Yp\u0006\u00cf\u00c9\u00cd\u00b3[s\u00ce\u009a~\u00bb'\u00ca\u00f86\u00e4\u00e0\u00b9L\u00b5;\u0090/\u00c8\u0098\u00ac\\\u00c2\u00d4\u0016\fx\u00d3\u001ff`\u0094\u0097\u00b2s\u00cc\u00de\u00b0\u0095Z\u0014\u00b5)\u00bc!uD\u0084\u0006\u00fb2Y\u00deg\u00ef\u008b\u0014)A\u001b\u0002Q\u00a4~\u000f~W\u00d0v\"\u00f8\u0080\u00b7l\u00e6\u0090)\u0085\u00cc\u00de\u00eeh}\u00fd\u00e6J\f\u0011\u00f1)\u008a\u00da@\u0085\u0097\u0010\u00ed'PQ\u009e\u00de7\u008f}\u000e\u00b9\b\u009a\u00f8d\r\u0090[\u0092\u007f\u00be\u0018~\u00e6\u0015\u0098\u009b\u00a4\u0084\u00f3LQY\u00caM\u00bfA|X\u00c7ToM\u00d5$_\n*\u00e2\u00e0\u00ae \u00bdKH\u00c9\u00fcH\u0003\u0014T$HSk\u00e93e\u0082\u00ee\u008e`u:\u0018\u00e9M\u00eb\u00e6\u00d8^\u00a9\u00ed}g\u00d2Y\u0015|\u00fc\u00d3{\u00de\u001cJ\u00cb\u0011\u0085S\u00b6\u0012\u009bP\u00a26\r\u0095!\u0093t#\u00bb\u00e2\u0003\u00b4\u00af\u008c\u00a8\u00aca\u00f9b\u009c\u009c\u00d8\u00e3\u0000;RzH\u0012Acq;~\u00fd\u0091\u0099\u00f6Dn#\\\u0094\u00d3`\u0080\u001c\u00c3\u008b\u00cb\u00fa\u00adS\u000e\u00fe`\u00e5H\u00fdO5\r\u000b\u00d6\u00eb\u001e]4\u0088\u00a6DE'\u00ea\u001a67\u00b5\u00bf\u00e1wx\u0012\u00f1\u0011\u00cd\u001f\u00a4\u008a\\f\u00dd\u001c\u009d\u00b3\u00fc&\u0004\u0096\u0090\r\u00e6-kR\n\u0096b\b97\u00d8g\u00c1\u0012\u0003\u00a9\u00c4\u009e\u0094(\u0010\u00b75\u00b6\u00fcu\u00e2K\u008b\u0082k~ET\u00a4)x\u00d2\u00a6\u00bf\u00b9\u008dx\u00b3\u00b2\u00d3\u00bb\u00e5\fG\u0087\u00ddSZ\u00c7 \u00ce\u00e7\u0095Y\u001fAoAE\u00b8\u001b\u00b7\u0093\u00a9\u00911\b\u0083v\u0006\u00ee\u0012cFx\u00efM\u0016cu\u0084T\u00fd\u00c4\\\u00a0$Z\u0012\u00ec\u001a3\u0014\u00e2\u00d0t\u000e\u00e2\u001c\u00f1z\t]=Q'>\b0\u00a8\u00e3\u001a\u00f2\u00e0\u00fb\u00eeC\u00b5&ZZ\u00d5;\u009c\u00f1\u00ad\u00d2\t\u0082#\u00b8\u00ddc\u00d4\u00bf\u00d1?I\u0012\u00a3.\u00d17\u0006\u008e\u008f9O \u00b2\u0085\u008d\u00b4\u0089.\u00a3B\"\u00a7\u0091D\u00c3\u0003i>\u0098L\u0081\u0002\u0097OE\u00de\u0089\u00ac\u001cT\u008a\u00be\u00db5~\u0003;\u00c7\u008f\u0010L\u001e\u00e68\u00faH\u0016>\u00f6a\u001c\u00fb\u00e1\u00fcl\u00d2\u00a9\u00a3\u0012^\u001c\u00a6\u00db09\u00d8\u00e5\u009f>A\u00e1`\u00e6qiazr\u0013\u00aa\u00c6&I\u008cqm_\u00ab\u00938`\u00d60\u0083U\u00fe\u009eO9%6*ud\u00fe\u00dd\u00eaB\u0010\u0006\u00a1\u0010\u007fr\u00f4\t\u00cc<g\u00c1\u00ab=:\u0003\u00e8#7\u00fd\u00fe\u00f7d\u00d2\t\u00dc\u00a3\u00bc\u0005\u0080\u00a9K\u00cf9\u00ebaH_~\u000fvq\"\u00fe\u0091\u00ce\u00d0\u00e37SD7\u00ac\u00aas\u001a\u001e\u00f8T4G\u00ad\u001f\u00fa\u00f6\u0081F\u0001\u00bb2\u00f5\u00b6\u0019H^\u00ba<i,\u00ce\u0000'\u00cb\u00bdo\u0011SP6t=\u0088\u0092\u00b2\u00b3\u00fb\u001dI@{\u00b7S\u00c7l\u00c5\u00c6\u00af\u0090}b\u0081|qL\nu_\u000b\u0019]K\u00e4\u0096<'!\u00fd`_,\u001c\u00a6\u00a3\u00b2\u00f2\u00b1\u00e9zS\u00ab\u00ba\u0097\u0092\u00d0\u0091B\u00be0);\u00b7?\n\u0081\u0013(0\u00b0\u0092\"]\u00a3\u001b\u0085\u00e8\u00a1C\u0081\u00e3\u00a2\u00f7\u00f3\u00f1\u00c9\t\u0018V.\u000b\u00ccU\u0013Hg\u00ac\u00182\u00eb\u00ae\u00c0\u00c9w\u00c2\u00c8";
                var4_3 = "\u00c5\u009a\u001d\u00a1\u009f\\\u00bcc)k~\u00ec\u0014\u0099\u00ba\u008b\u00c5\u00f6\u0015\u00f3\b\u00c9\u00f6^\u0002\u00e4\u0090|tif\u00a6\u00bc\u009c\u00c8\u0004\u00de\u00b8V\u00f2\u0011\u0007\u0086A=\u009d: \u009d\u00d7\u00fb\u00d6:\u00cbM\u00c8\u0089\u001e]\u00dd\u0084\u000b|\u00f36\u001c\u00b9\u00c9tM\u00b9\u00bd7\u0089\u00f2i\u00c7\u0011\u00afR\u00d1\u0001zB\u0013\u00b6\u0087\u009e\u001f\u00d9E\u00aa\u00b3\u00c98\u009a\u00ca\u0012\u0097\u0012\u00b2\u001a\u00f8\u0014\u008d\u00c6M2\u00e7?-\n\u00d0\u0007\u00dd\u001f\u00f7\u0016_\u00bd\u0094\u0083\u00f5\u0099\u00e6\u00f0\u00e2?sm\u008c\u00b6\"\u00f2:i/\u00bd?\u00d3\u00bf\u00e1\u00d7\u00abv\u0011 ~08\u009b\u00f3\u0017\u00e2I\u00ec\u00c5\u000f\u0001\u0083_:\u00a83\"rDp\u009cV\n\u00f6\u0016\u00ae\u00e6\u009enP\u00ae\u00b3}\u00dc\u0018A2wE\u00a58\u00fb\u00f3\u00f0\u00f4\"\u00b5<\u00fe\u0088\u00f7?\u0090\u00a6(\u0084t\u00cc(J\u00c3\u001adPT\u00eeciHu\u0081\u00caJ\u00b2\u00dfb\u00c0\u00a0z\u00fbx\u009c\u007f-\u00bd\u00ad\u001d\u0092\u00e2*XN\u0081-\u00b9,\u0011'\u00e8tg\u000f<\u00ed%\u001b.\u00f6XW\u00f0R\u00b3\u0093\u00fa\u00ae\u00bac\u000b\u0007\u00b5b\u00c6n!\u0099\u00af\u0088\u00fb\u00ee\by\u00a6z\u00e0A\u0087Y\u00c1\u0014!\u000e\u00830\f\u0006\u008aI/Ox\n\u00db@\u00b3+%1\u008aY\u000e\u0098\u00bb\u00b0\u009b\u00e1\u00da\u00d96A\u0089*\u008c\u00e0|!D\u001dh\u0083\u00faS\u007f\fif\u009a\u0080=\u00f4w|+\u00ad\u00a6\u00edX\u00c5\u00f5\u0085,\u00e8y{}w\u00fd[+Et\u008b-\u009dR\u001a\u00af.\u008f\u008a\u00f3\u00ec\u00dbp\u00e4ug\u00a8\u00d9\u00b6\u00da{0Y\u00e5g\u0019AI\u00a4@<\u00984\u00b3v)-!\u009f\u0081\u0084F\u00b0\u001a\u00a8G\u0001\u00cfb\u0012\u0086\u00f58Dj\u00c6\u00ae\u00e0zR\u00d9\u00edc\u0013;\u00e65\u00f4\u00168\u00ac\rR\u00f5l\u009b-DV\u00dc\u00f9\u0083!Qk*{\u00c1\u00c0_2\u0012?\u0002C\u00ebd\u0086\u000eb\u00f6\f\u0084\"\u00ed\u00a1j\u00dfW\u00d5\u001b\u00c5\u0092\u00b0}|c\u00c5\u00034\u00b6z\u001e(Z\u00ebMz\u00e6\u000b\u0002\u00c7}p<c\u00f4\u008b\u000e\u00be{t\u0083y\u00d9\u00caV#\u0085f\riL\u0014zy\u00fb\u00d0n\u00c4R8U4]\u00e1w\u001f\"\u0096\u00ab\"J~\u0017d\u007f<\u0003\u0015\u00d9\u00c0DR\u00cb>N\u00d3\u00c9D-\u00d0<&\u00d0\u00b4>\u00dd\u0004\u00bby@\u0098\u0011^\u0099\u007f\u00cc\u00feG@H\u0017,\u000f0u\u00f2J\n\u00d2\u0011\u0099\u00d9\u0087\u00c4\u00f7F\u00a8c\u00b8/c\u00d2p@+CaX\u00cd\u001b\t\u008f\u00b3H\u0014v\u00c8\u008dm\u0086\u00b9\u00d0\t\u000eyX\u0013\\\u0012\u00af\t\u00b5C\u00ea\u0096\u00b8\u009a\u00f8Y\u00b9\u00ba,\u00ca\u00d9\u0088\u00e8qR*\u00d1\u00b9~v\u0098]\u00d22\u00da5\u00ebJ\u00ef\u00f0\u009fa\u00b9oC\u00da|[\u00b1\u007fnv\u00f1\u0099N\u0017\u0082\u00a2+\u001a\u00f3\u00e4&2\u0093\u00c2 p;A/\u00cf\u001am{\u008b\u00df\u0080p\u0001P\u0095\u0081 \u00bb\u00a3x\u00c38Yp\u0006\u00cf\u00c9\u00cd\u00b3[s\u00ce\u009a~\u00bb'\u00ca\u00f86\u00e4\u00e0\u00b9L\u00b5;\u0090/\u00c8\u0098\u00ac\\\u00c2\u00d4\u0016\fx\u00d3\u001ff`\u0094\u0097\u00b2s\u00cc\u00de\u00b0\u0095Z\u0014\u00b5)\u00bc!uD\u0084\u0006\u00fb2Y\u00deg\u00ef\u008b\u0014)A\u001b\u0002Q\u00a4~\u000f~W\u00d0v\"\u00f8\u0080\u00b7l\u00e6\u0090)\u0085\u00cc\u00de\u00eeh}\u00fd\u00e6J\f\u0011\u00f1)\u008a\u00da@\u0085\u0097\u0010\u00ed'PQ\u009e\u00de7\u008f}\u000e\u00b9\b\u009a\u00f8d\r\u0090[\u0092\u007f\u00be\u0018~\u00e6\u0015\u0098\u009b\u00a4\u0084\u00f3LQY\u00caM\u00bfA|X\u00c7ToM\u00d5$_\n*\u00e2\u00e0\u00ae \u00bdKH\u00c9\u00fcH\u0003\u0014T$HSk\u00e93e\u0082\u00ee\u008e`u:\u0018\u00e9M\u00eb\u00e6\u00d8^\u00a9\u00ed}g\u00d2Y\u0015|\u00fc\u00d3{\u00de\u001cJ\u00cb\u0011\u0085S\u00b6\u0012\u009bP\u00a26\r\u0095!\u0093t#\u00bb\u00e2\u0003\u00b4\u00af\u008c\u00a8\u00aca\u00f9b\u009c\u009c\u00d8\u00e3\u0000;RzH\u0012Acq;~\u00fd\u0091\u0099\u00f6Dn#\\\u0094\u00d3`\u0080\u001c\u00c3\u008b\u00cb\u00fa\u00adS\u000e\u00fe`\u00e5H\u00fdO5\r\u000b\u00d6\u00eb\u001e]4\u0088\u00a6DE'\u00ea\u001a67\u00b5\u00bf\u00e1wx\u0012\u00f1\u0011\u00cd\u001f\u00a4\u008a\\f\u00dd\u001c\u009d\u00b3\u00fc&\u0004\u0096\u0090\r\u00e6-kR\n\u0096b\b97\u00d8g\u00c1\u0012\u0003\u00a9\u00c4\u009e\u0094(\u0010\u00b75\u00b6\u00fcu\u00e2K\u008b\u0082k~ET\u00a4)x\u00d2\u00a6\u00bf\u00b9\u008dx\u00b3\u00b2\u00d3\u00bb\u00e5\fG\u0087\u00ddSZ\u00c7 \u00ce\u00e7\u0095Y\u001fAoAE\u00b8\u001b\u00b7\u0093\u00a9\u00911\b\u0083v\u0006\u00ee\u0012cFx\u00efM\u0016cu\u0084T\u00fd\u00c4\\\u00a0$Z\u0012\u00ec\u001a3\u0014\u00e2\u00d0t\u000e\u00e2\u001c\u00f1z\t]=Q'>\b0\u00a8\u00e3\u001a\u00f2\u00e0\u00fb\u00eeC\u00b5&ZZ\u00d5;\u009c\u00f1\u00ad\u00d2\t\u0082#\u00b8\u00ddc\u00d4\u00bf\u00d1?I\u0012\u00a3.\u00d17\u0006\u008e\u008f9O \u00b2\u0085\u008d\u00b4\u0089.\u00a3B\"\u00a7\u0091D\u00c3\u0003i>\u0098L\u0081\u0002\u0097OE\u00de\u0089\u00ac\u001cT\u008a\u00be\u00db5~\u0003;\u00c7\u008f\u0010L\u001e\u00e68\u00faH\u0016>\u00f6a\u001c\u00fb\u00e1\u00fcl\u00d2\u00a9\u00a3\u0012^\u001c\u00a6\u00db09\u00d8\u00e5\u009f>A\u00e1`\u00e6qiazr\u0013\u00aa\u00c6&I\u008cqm_\u00ab\u00938`\u00d60\u0083U\u00fe\u009eO9%6*ud\u00fe\u00dd\u00eaB\u0010\u0006\u00a1\u0010\u007fr\u00f4\t\u00cc<g\u00c1\u00ab=:\u0003\u00e8#7\u00fd\u00fe\u00f7d\u00d2\t\u00dc\u00a3\u00bc\u0005\u0080\u00a9K\u00cf9\u00ebaH_~\u000fvq\"\u00fe\u0091\u00ce\u00d0\u00e37SD7\u00ac\u00aas\u001a\u001e\u00f8T4G\u00ad\u001f\u00fa\u00f6\u0081F\u0001\u00bb2\u00f5\u00b6\u0019H^\u00ba<i,\u00ce\u0000'\u00cb\u00bdo\u0011SP6t=\u0088\u0092\u00b2\u00b3\u00fb\u001dI@{\u00b7S\u00c7l\u00c5\u00c6\u00af\u0090}b\u0081|qL\nu_\u000b\u0019]K\u00e4\u0096<'!\u00fd`_,\u001c\u00a6\u00a3\u00b2\u00f2\u00b1\u00e9zS\u00ab\u00ba\u0097\u0092\u00d0\u0091B\u00be0);\u00b7?\n\u0081\u0013(0\u00b0\u0092\"]\u00a3\u001b\u0085\u00e8\u00a1C\u0081\u00e3\u00a2\u00f7\u00f3\u00f1\u00c9\t\u0018V.\u000b\u00ccU\u0013Hg\u00ac\u00182\u00eb\u00ae\u00c0\u00c9w\u00c2\u00c8".length();
                var1_4 = 18;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00ea\u00f4\u00f8l#\u00e5*P\u00db\u0094\u000b\u00b4\u00f7\u00a8\u0012\u00a9\u009a7\u00bb_\u0003\u0084\u00b3\u00db\u00be\b\u001dY\u00dcZ\u00b2\u0007i\n\u00b7d\u0002\u00e2\u00a9\u00e3\u00a2Oy\u0080\u001d\u0081\u00ef\u0093LE\u0013'^\u008a \u00c0";
                    var4_3 = "\u00ea\u00f4\u00f8l#\u00e5*P\u00db\u0094\u000b\u00b4\u00f7\u00a8\u0012\u00a9\u009a7\u00bb_\u0003\u0084\u00b3\u00db\u00be\b\u001dY\u00dcZ\u00b2\u0007i\n\u00b7d\u0002\u00e2\u00a9\u00e3\u00a2Oy\u0080\u001d\u0081\u00ef\u0093LE\u0013'^\u008a \u00c0".length();
                    var1_4 = 26;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 126;
                            break;
                        }
                        case 1: {
                            v13 = 34;
                            break;
                        }
                        case 2: {
                            v13 = 113;
                            break;
                        }
                        case 3: {
                            v13 = 78;
                            break;
                        }
                        case 4: {
                            v13 = 55;
                            break;
                        }
                        case 5: {
                            v13 = 59;
                            break;
                        }
                        default: {
                            v13 = 47;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        SignatureValidator.h = var5;
        SignatureValidator.i = new String[41];
        SignatureValidator.a = LoggerFactory.getLogger(SignatureValidator.class);
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0x66E7) & 0xFFFF;
        if (i[n3] == null) {
            int n4;
            int n5;
            char[] cArray = h[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 80;
                    break;
                }
                case 1: {
                    n5 = 182;
                    break;
                }
                case 2: {
                    n5 = 165;
                    break;
                }
                case 3: {
                    n5 = 138;
                    break;
                }
                case 4: {
                    n5 = 228;
                    break;
                }
                case 5: {
                    n5 = 235;
                    break;
                }
                case 6: {
                    n5 = 242;
                    break;
                }
                case 7: {
                    n5 = 226;
                    break;
                }
                case 8: {
                    n5 = 91;
                    break;
                }
                case 9: {
                    n5 = 10;
                    break;
                }
                case 10: {
                    n5 = 130;
                    break;
                }
                case 11: {
                    n5 = 160;
                    break;
                }
                case 12: {
                    n5 = 61;
                    break;
                }
                case 13: {
                    n5 = 99;
                    break;
                }
                case 14: {
                    n5 = 63;
                    break;
                }
                case 15: {
                    n5 = 152;
                    break;
                }
                case 16: {
                    n5 = 134;
                    break;
                }
                case 17: {
                    n5 = 74;
                    break;
                }
                case 18: {
                    n5 = 73;
                    break;
                }
                case 19: {
                    n5 = 239;
                    break;
                }
                case 20: {
                    n5 = 158;
                    break;
                }
                case 21: {
                    n5 = 89;
                    break;
                }
                case 22: {
                    n5 = 62;
                    break;
                }
                case 23: {
                    n5 = 172;
                    break;
                }
                case 24: {
                    n5 = 96;
                    break;
                }
                case 25: {
                    n5 = 144;
                    break;
                }
                case 26: {
                    n5 = 122;
                    break;
                }
                case 27: {
                    n5 = 197;
                    break;
                }
                case 28: {
                    n5 = 149;
                    break;
                }
                case 29: {
                    n5 = 26;
                    break;
                }
                case 30: {
                    n5 = 78;
                    break;
                }
                case 31: {
                    n5 = 245;
                    break;
                }
                case 32: {
                    n5 = 236;
                    break;
                }
                case 33: {
                    n5 = 49;
                    break;
                }
                case 34: {
                    n5 = 206;
                    break;
                }
                case 35: {
                    n5 = 118;
                    break;
                }
                case 36: {
                    n5 = 17;
                    break;
                }
                case 37: {
                    n5 = 22;
                    break;
                }
                case 38: {
                    n5 = 207;
                    break;
                }
                case 39: {
                    n5 = 191;
                    break;
                }
                case 40: {
                    n5 = 219;
                    break;
                }
                case 41: {
                    n5 = 183;
                    break;
                }
                case 42: {
                    n5 = 232;
                    break;
                }
                case 43: {
                    n5 = 13;
                    break;
                }
                case 44: {
                    n5 = 143;
                    break;
                }
                case 45: {
                    n5 = 251;
                    break;
                }
                case 46: {
                    n5 = 233;
                    break;
                }
                case 47: {
                    n5 = 27;
                    break;
                }
                case 48: {
                    n5 = 154;
                    break;
                }
                case 49: {
                    n5 = 240;
                    break;
                }
                case 50: {
                    n5 = 117;
                    break;
                }
                case 51: {
                    n5 = 14;
                    break;
                }
                case 52: {
                    n5 = 31;
                    break;
                }
                case 53: {
                    n5 = 93;
                    break;
                }
                case 54: {
                    n5 = 112;
                    break;
                }
                case 55: {
                    n5 = 249;
                    break;
                }
                case 56: {
                    n5 = 156;
                    break;
                }
                case 57: {
                    n5 = 41;
                    break;
                }
                case 58: {
                    n5 = 87;
                    break;
                }
                case 59: {
                    n5 = 133;
                    break;
                }
                case 60: {
                    n5 = 227;
                    break;
                }
                case 61: {
                    n5 = 171;
                    break;
                }
                case 62: {
                    n5 = 140;
                    break;
                }
                case 63: {
                    n5 = 188;
                    break;
                }
                case 64: {
                    n5 = 52;
                    break;
                }
                case 65: {
                    n5 = 18;
                    break;
                }
                case 66: {
                    n5 = 241;
                    break;
                }
                case 67: {
                    n5 = 168;
                    break;
                }
                case 68: {
                    n5 = 234;
                    break;
                }
                case 69: {
                    n5 = 47;
                    break;
                }
                case 70: {
                    n5 = 246;
                    break;
                }
                case 71: {
                    n5 = 104;
                    break;
                }
                case 72: {
                    n5 = 45;
                    break;
                }
                case 73: {
                    n5 = 214;
                    break;
                }
                case 74: {
                    n5 = 131;
                    break;
                }
                case 75: {
                    n5 = 221;
                    break;
                }
                case 76: {
                    n5 = 59;
                    break;
                }
                case 77: {
                    n5 = 247;
                    break;
                }
                case 78: {
                    n5 = 77;
                    break;
                }
                case 79: {
                    n5 = 24;
                    break;
                }
                case 80: {
                    n5 = 198;
                    break;
                }
                case 81: {
                    n5 = 178;
                    break;
                }
                case 82: {
                    n5 = 88;
                    break;
                }
                case 83: {
                    n5 = 98;
                    break;
                }
                case 84: {
                    n5 = 119;
                    break;
                }
                case 85: {
                    n5 = 123;
                    break;
                }
                case 86: {
                    n5 = 20;
                    break;
                }
                case 87: {
                    n5 = 107;
                    break;
                }
                case 88: {
                    n5 = 128;
                    break;
                }
                case 89: {
                    n5 = 205;
                    break;
                }
                case 90: {
                    n5 = 60;
                    break;
                }
                case 91: {
                    n5 = 218;
                    break;
                }
                case 92: {
                    n5 = 120;
                    break;
                }
                case 93: {
                    n5 = 57;
                    break;
                }
                case 94: {
                    n5 = 85;
                    break;
                }
                case 95: {
                    n5 = 51;
                    break;
                }
                case 96: {
                    n5 = 81;
                    break;
                }
                case 97: {
                    n5 = 231;
                    break;
                }
                case 98: {
                    n5 = 23;
                    break;
                }
                case 99: {
                    n5 = 64;
                    break;
                }
                case 100: {
                    n5 = 12;
                    break;
                }
                case 101: {
                    n5 = 114;
                    break;
                }
                case 102: {
                    n5 = 175;
                    break;
                }
                case 103: {
                    n5 = 102;
                    break;
                }
                case 104: {
                    n5 = 153;
                    break;
                }
                case 105: {
                    n5 = 127;
                    break;
                }
                case 106: {
                    n5 = 94;
                    break;
                }
                case 107: {
                    n5 = 3;
                    break;
                }
                case 108: {
                    n5 = 184;
                    break;
                }
                case 109: {
                    n5 = 146;
                    break;
                }
                case 110: {
                    n5 = 180;
                    break;
                }
                case 111: {
                    n5 = 56;
                    break;
                }
                case 112: {
                    n5 = 230;
                    break;
                }
                case 113: {
                    n5 = 186;
                    break;
                }
                case 114: {
                    n5 = 86;
                    break;
                }
                case 115: {
                    n5 = 142;
                    break;
                }
                case 116: {
                    n5 = 161;
                    break;
                }
                case 117: {
                    n5 = 54;
                    break;
                }
                case 118: {
                    n5 = 141;
                    break;
                }
                case 119: {
                    n5 = 151;
                    break;
                }
                case 120: {
                    n5 = 110;
                    break;
                }
                case 121: {
                    n5 = 215;
                    break;
                }
                case 122: {
                    n5 = 1;
                    break;
                }
                case 123: {
                    n5 = 169;
                    break;
                }
                case 124: {
                    n5 = 199;
                    break;
                }
                case 125: {
                    n5 = 167;
                    break;
                }
                case 126: {
                    n5 = 162;
                    break;
                }
                case 127: {
                    n5 = 115;
                    break;
                }
                case 128: {
                    n5 = 15;
                    break;
                }
                case 129: {
                    n5 = 216;
                    break;
                }
                case 130: {
                    n5 = 53;
                    break;
                }
                case 131: {
                    n5 = 137;
                    break;
                }
                case 132: {
                    n5 = 124;
                    break;
                }
                case 133: {
                    n5 = 100;
                    break;
                }
                case 134: {
                    n5 = 179;
                    break;
                }
                case 135: {
                    n5 = 71;
                    break;
                }
                case 136: {
                    n5 = 150;
                    break;
                }
                case 137: {
                    n5 = 126;
                    break;
                }
                case 138: {
                    n5 = 132;
                    break;
                }
                case 139: {
                    n5 = 44;
                    break;
                }
                case 140: {
                    n5 = 201;
                    break;
                }
                case 141: {
                    n5 = 202;
                    break;
                }
                case 142: {
                    n5 = 25;
                    break;
                }
                case 143: {
                    n5 = 50;
                    break;
                }
                case 144: {
                    n5 = 11;
                    break;
                }
                case 145: {
                    n5 = 30;
                    break;
                }
                case 146: {
                    n5 = 220;
                    break;
                }
                case 147: {
                    n5 = 67;
                    break;
                }
                case 148: {
                    n5 = 148;
                    break;
                }
                case 149: {
                    n5 = 248;
                    break;
                }
                case 150: {
                    n5 = 135;
                    break;
                }
                case 151: {
                    n5 = 222;
                    break;
                }
                case 152: {
                    n5 = 55;
                    break;
                }
                case 153: {
                    n5 = 39;
                    break;
                }
                case 154: {
                    n5 = 200;
                    break;
                }
                case 155: {
                    n5 = 125;
                    break;
                }
                case 156: {
                    n5 = 157;
                    break;
                }
                case 157: {
                    n5 = 250;
                    break;
                }
                case 158: {
                    n5 = 37;
                    break;
                }
                case 159: {
                    n5 = 244;
                    break;
                }
                case 160: {
                    n5 = 72;
                    break;
                }
                case 161: {
                    n5 = 192;
                    break;
                }
                case 162: {
                    n5 = 193;
                    break;
                }
                case 163: {
                    n5 = 139;
                    break;
                }
                case 164: {
                    n5 = 164;
                    break;
                }
                case 165: {
                    n5 = 195;
                    break;
                }
                case 166: {
                    n5 = 187;
                    break;
                }
                case 167: {
                    n5 = 101;
                    break;
                }
                case 168: {
                    n5 = 16;
                    break;
                }
                case 169: {
                    n5 = 36;
                    break;
                }
                case 170: {
                    n5 = 76;
                    break;
                }
                case 171: {
                    n5 = 83;
                    break;
                }
                case 172: {
                    n5 = 166;
                    break;
                }
                case 173: {
                    n5 = 209;
                    break;
                }
                case 174: {
                    n5 = 69;
                    break;
                }
                case 175: {
                    n5 = 229;
                    break;
                }
                case 176: {
                    n5 = 48;
                    break;
                }
                case 177: {
                    n5 = 190;
                    break;
                }
                case 178: {
                    n5 = 2;
                    break;
                }
                case 179: {
                    n5 = 90;
                    break;
                }
                case 180: {
                    n5 = 194;
                    break;
                }
                case 181: {
                    n5 = 211;
                    break;
                }
                case 182: {
                    n5 = 35;
                    break;
                }
                case 183: {
                    n5 = 32;
                    break;
                }
                case 184: {
                    n5 = 181;
                    break;
                }
                case 185: {
                    n5 = 203;
                    break;
                }
                case 186: {
                    n5 = 129;
                    break;
                }
                case 187: {
                    n5 = 103;
                    break;
                }
                case 188: {
                    n5 = 105;
                    break;
                }
                case 189: {
                    n5 = 224;
                    break;
                }
                case 190: {
                    n5 = 34;
                    break;
                }
                case 191: {
                    n5 = 7;
                    break;
                }
                case 192: {
                    n5 = 163;
                    break;
                }
                case 193: {
                    n5 = 43;
                    break;
                }
                case 194: {
                    n5 = 208;
                    break;
                }
                case 195: {
                    n5 = 212;
                    break;
                }
                case 196: {
                    n5 = 108;
                    break;
                }
                case 197: {
                    n5 = 196;
                    break;
                }
                case 198: {
                    n5 = 254;
                    break;
                }
                case 199: {
                    n5 = 252;
                    break;
                }
                case 200: {
                    n5 = 5;
                    break;
                }
                case 201: {
                    n5 = 113;
                    break;
                }
                case 202: {
                    n5 = 70;
                    break;
                }
                case 203: {
                    n5 = 84;
                    break;
                }
                case 204: {
                    n5 = 238;
                    break;
                }
                case 205: {
                    n5 = 66;
                    break;
                }
                case 206: {
                    n5 = 136;
                    break;
                }
                case 207: {
                    n5 = 29;
                    break;
                }
                case 208: {
                    n5 = 21;
                    break;
                }
                case 209: {
                    n5 = 177;
                    break;
                }
                case 210: {
                    n5 = 8;
                    break;
                }
                case 211: {
                    n5 = 255;
                    break;
                }
                case 212: {
                    n5 = 68;
                    break;
                }
                case 213: {
                    n5 = 111;
                    break;
                }
                case 214: {
                    n5 = 19;
                    break;
                }
                case 215: {
                    n5 = 121;
                    break;
                }
                case 216: {
                    n5 = 95;
                    break;
                }
                case 217: {
                    n5 = 237;
                    break;
                }
                case 218: {
                    n5 = 46;
                    break;
                }
                case 219: {
                    n5 = 38;
                    break;
                }
                case 220: {
                    n5 = 145;
                    break;
                }
                case 221: {
                    n5 = 155;
                    break;
                }
                case 222: {
                    n5 = 92;
                    break;
                }
                case 223: {
                    n5 = 174;
                    break;
                }
                case 224: {
                    n5 = 253;
                    break;
                }
                case 225: {
                    n5 = 147;
                    break;
                }
                case 226: {
                    n5 = 243;
                    break;
                }
                case 227: {
                    n5 = 82;
                    break;
                }
                case 228: {
                    n5 = 75;
                    break;
                }
                case 229: {
                    n5 = 9;
                    break;
                }
                case 230: {
                    n5 = 28;
                    break;
                }
                case 231: {
                    n5 = 33;
                    break;
                }
                case 232: {
                    n5 = 42;
                    break;
                }
                case 233: {
                    n5 = 185;
                    break;
                }
                case 234: {
                    n5 = 58;
                    break;
                }
                case 235: {
                    n5 = 6;
                    break;
                }
                case 236: {
                    n5 = 217;
                    break;
                }
                case 237: {
                    n5 = 225;
                    break;
                }
                case 238: {
                    n5 = 109;
                    break;
                }
                case 239: {
                    n5 = 210;
                    break;
                }
                case 240: {
                    n5 = 223;
                    break;
                }
                case 241: {
                    n5 = 204;
                    break;
                }
                case 242: {
                    n5 = 213;
                    break;
                }
                case 243: {
                    n5 = 106;
                    break;
                }
                case 244: {
                    n5 = 40;
                    break;
                }
                case 245: {
                    n5 = 170;
                    break;
                }
                case 246: {
                    n5 = 4;
                    break;
                }
                case 247: {
                    n5 = 97;
                    break;
                }
                case 248: {
                    n5 = 159;
                    break;
                }
                case 249: {
                    n5 = 176;
                    break;
                }
                case 250: {
                    n5 = 173;
                    break;
                }
                case 251: {
                    n5 = 65;
                    break;
                }
                case 252: {
                    n5 = 189;
                    break;
                }
                case 253: {
                    n5 = 79;
                    break;
                }
                case 254: {
                    n5 = 0;
                    break;
                }
                default: {
                    n5 = 116;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            SignatureValidator.i[n3] = new String(cArray).intern();
        }
        return i[n3];
    }
}

