/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.Choice;
import com.turktrust.asn1.SequenceOf;
import com.turktrust.x509.GeneralName;
import com.turktrust.x509.RelativeDistinguishedName;
import java.util.Vector;

public class DistributionPointName
extends Choice {
    private SequenceOf generalNamesSeq = new SequenceOf("seqOfGN", new GeneralName());
    private RelativeDistinguishedName rdn = new RelativeDistinguishedName("rdn");

    public DistributionPointName() {
        super("default_gpn");
        this.setUpElements();
    }

    public DistributionPointName(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.generalNamesSeq);
        this.generalNamesSeq.setTaggingMethod(1);
        this.generalNamesSeq.setTagClass((byte)-128);
        this.generalNamesSeq.setTagNumber(0);
        this.generalNamesSeq.setForcedTagMethod(1);
        super.addElement(this.rdn);
        this.rdn.setTaggingMethod(1);
        this.rdn.setTagClass((byte)-128);
        this.rdn.setTagNumber(1);
        this.setForcedTagMethod(1);
    }

    public void setFullName(Vector genNameVec) {
        this.generalNamesSeq.setValue(genNameVec);
        this.generalNamesSeq.setForcedTagMethod(1);
        super.setValue(this.generalNamesSeq);
    }

    public void setRelativeName(RelativeDistinguishedName rdn_given) {
        this.rdn = rdn_given;
        super.clearElements();
        this.setUpElements();
        super.setValue(this.rdn);
    }

    public Vector getFullName() {
        return (Vector)this.generalNamesSeq.getValue();
    }
}

