/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.Sequence;
import com.turktrust.asn1.SequenceOf;
import com.turktrust.x509.Extension;
import com.turktrust.x509.QCStatement;
import java.util.Vector;

public class QCStatements
extends Extension {
    public static final String EXT_OBJ_ID = "1.3.6.1.5.5.7.1.3";
    private Vector qcstatsVec;

    public QCStatements(String name, boolean critical, Vector statementsVec) {
        super(name);
        this.qcstatsVec = statementsVec;
        ObjectID qcStatObjId = new ObjectID("qcStatements");
        qcStatObjId.setValue(EXT_OBJ_ID);
        this.setextnID(qcStatObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
        this.setcritical(crit);
        Sequence statSeq = new Sequence();
        for (int i = 0; i < statementsVec.size(); ++i) {
            statSeq.addElement((QCStatement)statementsVec.elementAt(i));
        }
        byte[] statSeqBytes = statSeq.getEncoded();
        OctetString octs = new OctetString("qcStatOcs");
        octs.setValue(statSeqBytes);
        this.setextnValue(octs);
        this.commitElementUpdate();
    }

    public QCStatements() {
        super("defaultQC");
        ObjectID qcStatObjId = new ObjectID("qcStatements");
        qcStatObjId.setValue(EXT_OBJ_ID);
        this.setextnID(qcStatObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(false));
        this.setcritical(crit);
        this.commitElementUpdate();
    }

    public void decodeExtVal(byte[] extValBytes) {
        SequenceOf statementsSeq = new SequenceOf("statementsSeq", new QCStatement());
        try {
            statementsSeq.decode(extValBytes);
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.qcstatsVec = (Vector)statementsSeq.getValue();
        OctetString extOcts = new OctetString("extCertPolicies", extValBytes);
        this.setextnValue(extOcts);
        this.commitElementUpdate();
    }

    public Vector getStatements() {
        return this.qcstatsVec;
    }

    public String getExtensionTitle() {
        return "Qualified Certificate Statements";
    }

    public String getTurkishExtensionTitle() {
        return "Nitelikli Sertifika Belirtimleri";
    }

    public String getExplanation() throws DecodeException {
        String exp = "";
        for (int i = 0; i < this.qcstatsVec.size(); ++i) {
            QCStatement qcsTemp = (QCStatement)this.qcstatsVec.elementAt(i);
            exp = exp + qcsTemp.getExplanation() + "\n";
        }
        return exp;
    }

    public String getTurkishExplanation() throws DecodeException {
        String exp = "";
        for (int i = 0; i < this.qcstatsVec.size(); ++i) {
            QCStatement qcsTemp = (QCStatement)this.qcstatsVec.elementAt(i);
            exp = exp + qcsTemp.getTurkishExplanation() + "\n";
        }
        return exp;
    }
}

