/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.ASN1Object;
import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.TagInfo;
import java.util.Vector;

public class SequenceOf
extends BaseASN1Object {
    private Vector components = new Vector();
    private Class componentType;

    public SequenceOf(String name) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(16);
        this.setTagNumber(16);
        this.setConstructed(true);
    }

    public SequenceOf(String name, Object value) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(16);
        this.setTagNumber(16);
        this.setConstructed(true);
        this.componentType = value instanceof Class ? (Class)value : value.getClass();
    }

    public void setValue(Object value) {
        if (value instanceof Vector) {
            this.components = (Vector)value;
        }
    }

    public Object getValue() {
        return this.components;
    }

    public void addElement(ASN1Object element) {
        Class<?> x = element.getClass();
        if (x.equals(this.componentType) || x.getSuperclass().equals(this.componentType)) {
            this.components.addElement(element);
        }
    }

    public ASN1Object getElement(String name) {
        if (this.components == null) {
            return null;
        }
        for (int i = 0; i < this.components.size(); ++i) {
            ASN1Object element = (ASN1Object)this.components.elementAt(i);
            String elementName = element.getName();
            if (elementName == null || !elementName.equalsIgnoreCase(name)) continue;
            return element;
        }
        return null;
    }

    public void decode(byte[] data) throws DecodeException {
        this.clearElements();
        TagInfo tagInfo = this.getTagInfo(data, 0);
        if (this.tagClass != tagInfo.tagClass) {
            throw new DecodeException();
        }
        if (this.tagMethod != tagInfo.tagMethod) {
            throw new DecodeException();
        }
        if (this.tagNumber != tagInfo.tagNumber) {
            throw new DecodeException();
        }
        if (this.tagMethod != 1 && this.type != tagInfo.type) {
            throw new DecodeException();
        }
        if (tagInfo.contentIndex + tagInfo.contentLength != data.length) {
            throw new DecodeException();
        }
        SequenceOf.trace("SequenceOf." + this.getName() + ".decode: " + this.toString());
        SequenceOf.trace("SequenceOf." + this.getName() + ".decode: tagInfo =\n" + tagInfo.toString() + "\n");
        int startAtIdx = 1;
        int idx = tagInfo.contentIndex;
        while (idx < tagInfo.contentIndex + tagInfo.contentLength) {
            TagInfo x = this.getTagInfo(data, idx);
            if (x == null) {
                throw new DecodeException();
            }
            SequenceOf.trace("SequenceOf." + this.getName() + ".decode: decoding component specified by:\n" + x.toString());
            try {
                ASN1Object newComponent = (ASN1Object)this.componentType.newInstance();
                newComponent.setName(this.getName() + "." + startAtIdx++);
                SequenceOf.trace("SequenceOf." + this.getName() + ".decode: added component " + newComponent.getName());
                this.addElement(newComponent);
                int y = x.contentLength + (x.contentIndex - x.tagIndex);
                byte[] content = new byte[y];
                System.arraycopy(data, x.tagIndex, content, 0, y);
                newComponent.decode(content);
                SequenceOf.trace("SequenceOf." + this.getName() + ".decode: done: " + newComponent.toString());
            }
            catch (Exception e) {
                throw new DecodeException();
            }
            idx = x.contentIndex + x.contentLength;
        }
    }

    protected byte[] getContentEncoding() {
        byte[] contents;
        Vector<byte[]> componentEncodings = new Vector<byte[]>(this.components.size());
        int len = 0;
        if (this.components.size() == 0) {
            if (this.optional) {
                return null;
            }
            return new byte[0];
        }
        for (int i = 0; i < this.components.size(); ++i) {
            ASN1Object object = (ASN1Object)this.components.elementAt(i);
            contents = object.getEncoded();
            componentEncodings.addElement(contents);
            len += contents.length;
        }
        byte[] totalContents = new byte[len];
        len = 0;
        for (int i = 0; i < componentEncodings.size(); ++i) {
            contents = (byte[])componentEncodings.elementAt(i);
            System.arraycopy(contents, 0, totalContents, len, contents.length);
            len += contents.length;
        }
        return totalContents;
    }

    public String toString() {
        return new String(super.toString());
    }

    public void clearElements() {
        this.components.clear();
    }

    public static void main(String[] args) throws DecodeException {
        try {
            SequenceOf.trace("SequenceOf.main: creating a new SequenceOf");
            SequenceOf x = new SequenceOf("sequenceOf", Class.forName("au.com.forge.framework.asn1.ASN1Integer"));
            SequenceOf.trace("SequenceOf.main: adding integers");
            x.addElement(new ASN1Integer("e1", "9"));
            x.addElement(new ASN1Integer("e2", "4"));
            SequenceOf.trace("SequenceOf.main: decoding");
            byte[] f = x.getEncoded();
            for (int z = 0; z < f.length; ++z) {
                System.out.print(Integer.toString(f[z] & 0xFF, 16) + " ");
            }
            System.out.println("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

