/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.smyy.utils;

import com.turktrust.smyy.utils.SHA224;
import com.turktrust.smyy.utils.Whirlpool;
import java.security.MessageDigest;

public class HashFabrikasi {
    public static final String SHA_1 = "1.3.14.3.2.26";
    public static final String SHA_224 = "2.16.840.1.101.3.4.2.4";
    public static final String SHA_256 = "2.16.840.1.101.3.4.2.1";
    public static final String SHA_384 = "2.16.840.1.101.3.4.2.2";
    public static final String SHA_512 = "2.16.840.1.101.3.4.2.3";
    public static final String WHIRLPOOL = "1.0.10118.3.0.55";
    public static final String XMLSIG_URI_SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String XMLSIG_URI_SHA224 = "http://www.w3.org/2001/04/xmldsig-more#sha224";
    public static final String XMLSIG_URI_SHA256 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String XMLSIG_URI_SHA384 = "http://www.w3.org/2001/04/xmldsig-more#sha384";
    public static final String XMLSIG_URI_SHA512 = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final String XMLSIG_URI_WHIRLPOOL = "";

    public static byte[] hashAl(byte[] input, String algoritma) {
        try {
            String algName = XMLSIG_URI_WHIRLPOOL;
            boolean useJreProvider = false;
            if (algoritma.equals(SHA_1)) {
                algName = "SHA-1";
                useJreProvider = true;
            } else if (algoritma.equals(SHA_256)) {
                algName = "SHA-256";
                useJreProvider = true;
            } else if (algoritma.equals(SHA_384)) {
                algName = "SHA-384";
                useJreProvider = true;
            } else if (algoritma.equals(SHA_512)) {
                algName = "SHA-512";
                useJreProvider = true;
            }
            if (useJreProvider) {
                MessageDigest mdig = MessageDigest.getInstance(algName);
                byte[] result = mdig.digest(input);
                return result;
            }
            if (algoritma.equals(SHA_224)) {
                SHA224 md = new SHA224();
                return md.digest(input);
            }
            if (algoritma.equals(WHIRLPOOL)) {
                Whirlpool wp = new Whirlpool();
                return wp.digest(input);
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static boolean algoritmaDesteklenmeKontrolu(String algoritma) {
        return algoritma.equals(SHA_1) || algoritma.equals(SHA_224) || algoritma.equals(SHA_256) || algoritma.equals(SHA_384) || algoritma.equals(SHA_512) || algoritma.equals(WHIRLPOOL);
    }

    public static MessageDigest messageDigestNesnesiAl(String algoritma) {
        try {
            String algName = XMLSIG_URI_WHIRLPOOL;
            if (algoritma.equals(SHA_1)) {
                algName = "SHA-1";
            } else if (algoritma.equals(SHA_256)) {
                algName = "SHA-256";
            } else if (algoritma.equals(SHA_384)) {
                algName = "SHA-384";
            } else if (algoritma.equals(SHA_512)) {
                algName = "SHA-512";
            } else {
                return null;
            }
            MessageDigest mdig = MessageDigest.getInstance(algName);
            return mdig;
        }
        catch (Exception exc) {
            return null;
        }
    }

    private static void prettyPrint(byte[] input) {
        for (int i = 0; i < input.length; ++i) {
            int p = Integer.parseInt(Byte.toString(input[i]));
            if (p < 0) {
                p += 256;
            }
            System.out.print(Integer.toHexString(p) + " ");
        }
        System.out.println(XMLSIG_URI_WHIRLPOOL);
    }

    public static String algoritmaUriIcinAlgoritmaOidAl(String algUri) {
        try {
            String algOid = null;
            if (algUri.equals(XMLSIG_URI_SHA1)) {
                algOid = SHA_1;
            } else if (algUri.equals(XMLSIG_URI_SHA224)) {
                algOid = SHA_224;
            } else if (algUri.equals(XMLSIG_URI_SHA256)) {
                algOid = SHA_256;
            } else if (algUri.equals(XMLSIG_URI_SHA384)) {
                algOid = SHA_384;
            } else if (algUri.equals(XMLSIG_URI_SHA512)) {
                algOid = SHA_512;
            } else if (algUri.equals(XMLSIG_URI_WHIRLPOOL)) {
                algOid = WHIRLPOOL;
            }
            return algOid;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String algoritmaOidIcinAlgoritmaUriAl(String algOid) {
        try {
            String algUri = null;
            if (algOid.equals(SHA_1)) {
                algUri = XMLSIG_URI_SHA1;
            } else if (algOid.equals(SHA_224)) {
                algUri = XMLSIG_URI_SHA224;
            } else if (algOid.equals(SHA_256)) {
                algUri = XMLSIG_URI_SHA256;
            } else if (algOid.equals(SHA_384)) {
                algUri = XMLSIG_URI_SHA384;
            } else if (algOid.equals(SHA_512)) {
                algUri = XMLSIG_URI_SHA512;
            } else if (algOid.equals(WHIRLPOOL)) {
                algUri = XMLSIG_URI_WHIRLPOOL;
            }
            return algUri;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

