/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.ASN1Object;
import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.TagInfo;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class Set
extends BaseASN1Object
implements Comparator {
    private Vector components = new Vector();

    public Set() {
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(17);
        this.setTagNumber(17);
        this.setConstructed(true);
    }

    public Set(String name) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(17);
        this.setTagNumber(17);
        this.setConstructed(true);
    }

    public Set(String name, Object value) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(17);
        this.setTagNumber(17);
        this.setConstructed(true);
        this.setValue(value);
    }

    public void setValue(Object value) {
        if (value instanceof Vector) {
            this.components = (Vector)value;
        }
    }

    public Object getValue() {
        return this.components;
    }

    public void addElement(ASN1Object element) {
        this.components.addElement(element);
    }

    public ASN1Object getElement(String name) {
        for (int i = 0; i < this.components.size(); ++i) {
            ASN1Object element = (ASN1Object)this.components.elementAt(i);
            String elementName = element.getName();
            if (elementName == null || !elementName.equalsIgnoreCase(name)) continue;
            return element;
        }
        return null;
    }

    public void decode(byte[] data) throws DecodeException {
        TagInfo tagInfo = this.getTagInfo(data, 0);
        if (this.tagClass != tagInfo.tagClass) {
            throw new DecodeException();
        }
        if (this.tagMethod != tagInfo.tagMethod) {
            throw new DecodeException();
        }
        if (this.tagNumber != tagInfo.tagNumber) {
            throw new DecodeException();
        }
        if (this.tagMethod != 1 && this.type != tagInfo.type) {
            throw new DecodeException();
        }
        if (tagInfo.contentIndex + tagInfo.contentLength != data.length) {
            throw new DecodeException();
        }
        Set.trace("Set.decode: " + this.toString());
        Set.trace("Set.decode: tagInfo =\n" + tagInfo.toString() + "\n");
        int idx = tagInfo.contentIndex;
        while (idx < tagInfo.contentIndex + tagInfo.contentLength) {
            TagInfo x = this.getTagInfo(data, idx);
            Set.trace("Set.decode: x =\n" + x.toString());
            for (int i = 0; i < this.components.size(); ++i) {
                ASN1Object comp = (ASN1Object)this.components.elementAt(i);
                Set.trace("Set.decode: checking for\tmatch: " + comp.toString());
                if (comp.getTagNumber() != 0 && (comp.getTagClass() != x.tagClass || comp.getTagNumber() != x.tagNumber)) continue;
                Set.trace("Set.decode: setting the value of " + comp.getName() + "\n");
                int y = x.contentLength + (x.contentIndex - x.tagIndex);
                byte[] content = new byte[y];
                System.arraycopy(data, x.tagIndex, content, 0, y);
                comp.decode(content);
                break;
            }
            idx = x.contentIndex + x.contentLength;
        }
    }

    protected byte[] getContentEncoding() {
        byte[] contents;
        Vector<byte[]> componentEncodings = new Vector<byte[]>(this.components.size());
        int len = 0;
        for (int i = 0; i < this.components.size(); ++i) {
            ASN1Object object = (ASN1Object)this.components.elementAt(i);
            if (object.isOptional() && object.isDefaultValue()) {
                Set.trace("Set.getContentEncoding: " + object.getName() + " is optional and has default value, not included in the encoding");
                continue;
            }
            contents = object.getEncoded();
            if (contents == null && object.isOptional()) {
                Set.trace("Set." + this.getName() + ".getContentEncoding: " + object.getName() + " is optional and has no value, not included in the encoding");
                continue;
            }
            componentEncodings.addElement(contents);
            len += contents.length;
        }
        byte[] totalContents = new byte[len];
        len = 0;
        Collections.sort(componentEncodings, this);
        for (int i = 0; i < componentEncodings.size(); ++i) {
            contents = (byte[])componentEncodings.elementAt(i);
            System.arraycopy(contents, 0, totalContents, len, contents.length);
            len += contents.length;
        }
        return totalContents;
    }

    public String toString() {
        return new String(super.toString());
    }

    public int compare(Object o1, Object o2) {
        byte[] a1 = (byte[])o1;
        byte[] a2 = (byte[])o2;
        if (a1[0] < a2[0]) {
            return -1;
        }
        if (a1[0] == a2[0]) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        return obj instanceof Set;
    }

    public static void main(String[] args) throws DecodeException {
        Set seq = new Set("Set");
        ASN1Integer i1 = new ASN1Integer("PublicExponent");
        ASN1Integer i2 = new ASN1Integer("Modulus");
        seq.addElement(i1);
        seq.addElement(i2);
        byte[] contents = new byte[]{48, 8, 2, 1, 16, 2, 3, 1, 0, 1};
        seq.decode(contents);
        ASN1Object publicExponent = seq.getElement("PublicExponent");
        System.out.println("\nPublicExponent = " + publicExponent.getValue().toString());
        ASN1Object modulus = seq.getElement("modulus");
        System.out.println("\nModulus =\t" + modulus.getValue().toString());
        byte[] f = seq.getEncoded();
        for (int z = 0; z < f.length; ++z) {
            System.out.print(Integer.toString(f[z] & 0xFF, 16) + "\t");
        }
        System.out.println("");
    }
}

