/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.Sequence;
import com.turktrust.asn1.SequenceOf;
import com.turktrust.x509.Extension;
import java.util.Vector;

public class ExtendedKeyUsage
extends Extension {
    public static final String EXT_OBJ_ID = "2.5.29.37";
    public static final String SERVER_AUTH = "1.3.6.1.5.5.7.3.1";
    public static final String CLIENT_AUTH = "1.3.6.1.5.5.7.3.2";
    public static final String CODE_SIGNING = "1.3.6.1.5.5.7.3.3";
    public static final String EMAIL_PROTECTION = "1.3.6.1.5.5.7.3.4";
    public static final String TIMESTAMPING = "1.3.6.1.5.5.7.3.8";
    public static final String OCSP_SIGNING = "1.3.6.1.5.5.7.3.9";
    public static final String SMART_CARD_LOGON = "1.3.6.1.4.1.311.20.2.2";
    public static final String MICROSOFT_CODE_SIGNING = "1.3.6.1.4.1.311.2.1.22";
    private Sequence seq;

    public ExtendedKeyUsage(String name, boolean critical, String boolBits) {
        super(name);
        ObjectID extKeyUsageObjId = new ObjectID("extendedKeyUsage");
        extKeyUsageObjId.setValue(EXT_OBJ_ID);
        this.setextnID(extKeyUsageObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(critical));
        this.setcritical(crit);
        this.seq = new Sequence("extendedKeyUsageSeq");
        if (boolBits.charAt(0) == '1') {
            this.setKeyUsage(SERVER_AUTH);
        }
        if (boolBits.charAt(1) == '1') {
            this.setKeyUsage(CLIENT_AUTH);
        }
        if (boolBits.charAt(2) == '1') {
            this.setKeyUsage(CODE_SIGNING);
        }
        if (boolBits.charAt(3) == '1') {
            this.setKeyUsage(EMAIL_PROTECTION);
        }
        if (boolBits.charAt(4) == '1') {
            this.setKeyUsage(TIMESTAMPING);
        }
        if (boolBits.charAt(5) == '1') {
            this.setKeyUsage(OCSP_SIGNING);
        }
        if (boolBits.length() > 6 && boolBits.charAt(6) == '1') {
            this.setKeyUsage(SMART_CARD_LOGON);
        }
        if (boolBits.length() > 7 && boolBits.charAt(7) == '1') {
            this.setKeyUsage(MICROSOFT_CODE_SIGNING);
        }
        byte[] seqBytes = this.seq.getEncoded();
        OctetString octs = new OctetString("extKeyUsageVal", seqBytes);
        this.setextnValue(octs);
        this.commitElementUpdate();
    }

    public ExtendedKeyUsage() {
        super("defaultEKU");
        ObjectID extKeyUsageObjId = new ObjectID("extendedKeyUsage");
        extKeyUsageObjId.setValue(EXT_OBJ_ID);
        this.setextnID(extKeyUsageObjId);
        ASN1Boolean crit = new ASN1Boolean("critical", new Boolean(false));
        this.setcritical(crit);
        this.commitElementUpdate();
    }

    public void decodeExtVal(byte[] extValBytes) {
        SequenceOf seqOf = new SequenceOf("extendedKeyUsageSeqOf", new ObjectID());
        try {
            seqOf.decode(extValBytes);
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.seq = new Sequence("extendedKeyUsageSeq");
        this.seq.setValue(seqOf.getValue());
        OctetString octs = new OctetString("extKeyUsageVal", extValBytes);
        this.setextnValue(octs);
        this.commitElementUpdate();
    }

    private void setKeyUsage(String objIdStr) {
        ObjectID objId = new ObjectID("extKeyUsageObjId");
        objId.setValue(objIdStr);
        this.seq.addElement(objId);
    }

    public String getExtensionTitle() {
        return "Extended Key Usage";
    }

    public String getTurkishExtensionTitle() {
        return "Geni\u015fletilmi\u015f Anahtar Kullan\u0131m\u0131";
    }

    public String getExplanation() {
        String exp = "";
        Vector ekuVec = (Vector)this.seq.getValue();
        for (int i = 0; i < ekuVec.size(); ++i) {
            String objIdStr = (String)((ObjectID)ekuVec.elementAt(i)).getValue();
            if (objIdStr.equals(SERVER_AUTH)) {
                exp = exp + "Server Authentication";
            } else if (objIdStr.equals(CLIENT_AUTH)) {
                exp = exp + "Client Authentication";
            } else if (objIdStr.equals(CODE_SIGNING)) {
                exp = exp + "Code Signing";
            } else if (objIdStr.equals(EMAIL_PROTECTION)) {
                exp = exp + "E-mail Protection";
            } else if (objIdStr.equals(TIMESTAMPING)) {
                exp = exp + "Timestamping";
            } else if (objIdStr.equals(OCSP_SIGNING)) {
                exp = exp + "OCSP Signing";
            } else if (objIdStr.equals(SMART_CARD_LOGON)) {
                exp = exp + "Smart Card Logon";
            } else if (objIdStr.equals(MICROSOFT_CODE_SIGNING)) {
                exp = exp + "Microsoft Code Signing";
            }
            if (i >= ekuVec.size() - 1) continue;
            exp = exp + ",";
        }
        return exp;
    }

    public String getTurkishExplanation() {
        String exp = "";
        Vector ekuVec = (Vector)this.seq.getValue();
        for (int i = 0; i < ekuVec.size(); ++i) {
            String objIdStr = (String)((ObjectID)ekuVec.elementAt(i)).getValue();
            if (objIdStr.equals(SERVER_AUTH)) {
                exp = exp + "Sunucu Do\u011frulama";
            } else if (objIdStr.equals(CLIENT_AUTH)) {
                exp = exp + "Kullan\u0131c\u0131 Do\u011frulama";
            } else if (objIdStr.equals(CODE_SIGNING)) {
                exp = exp + "Yaz\u0131l\u0131m \u0130mzalama";
            } else if (objIdStr.equals(EMAIL_PROTECTION)) {
                exp = exp + "E-posta Korumas\u0131";
            } else if (objIdStr.equals(TIMESTAMPING)) {
                exp = exp + "Zaman Damgas\u0131";
            } else if (objIdStr.equals(OCSP_SIGNING)) {
                exp = exp + "OCSP \u0130mzalama";
            } else if (objIdStr.equals(SMART_CARD_LOGON)) {
                exp = exp + "Ak\u0131ll\u0131 Kart Logon";
            } else if (objIdStr.equals(MICROSOFT_CODE_SIGNING)) {
                exp = exp + "Microsoft Yaz\u0131l\u0131m \u0130mzalama";
            }
            if (i >= ekuVec.size() - 1) continue;
            exp = exp + ",";
        }
        return exp;
    }
}

