/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.ATR;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import tr.gov.tubitak.uekae.esya.api.asn.sun.security.util.DerOutputStream;
import tr.gov.tubitak.uekae.esya.api.asn.sun.security.util.DerValue;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ec.ECParameters;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.KeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.KeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECKeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECPublicKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.AkisOps;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.IPKCS11Ops;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.CardTemplate;

public class AkisTemplate
extends CardTemplate {
    protected static Logger logger;
    protected static long CKA_SENSITIVE_EC_PARAMS;
    public static List<String> ATR_HASHES;
    public static List<String> HISTORICAL_BYTE_REGEXES;
    private static final String[] c;
    private static final String[] d;

    public AkisTemplate(CardType aCardType) {
        super(aCardType);
    }

    @Override
    public synchronized IPKCS11Ops getPKCS11Ops() {
        if (this.mIslem == null) {
            this.mIslem = new AkisOps(this.cardType);
        }
        return this.mIslem;
    }

    public static boolean isAkisATR(String atrHex) {
        String string = AkisTemplate.b(28848, -801);
        String string2 = AkisTemplate.b(28849, 14635);
        boolean bl = CardTemplate.b;
        if (atrHex.contains(string) || atrHex.contains(string2)) {
            return true;
        }
        ATR aTR = new ATR(StringUtil.toByteArray((String)atrHex));
        byte[] byArray = aTR.getHistoricalBytes();
        String string3 = StringUtil.toHexString((byte[])byArray);
        for (String string4 : HISTORICAL_BYTE_REGEXES) {
            boolean bl2 = string3.matches(string4);
            if (bl2) {
                return true;
            }
            if (!bl) continue;
        }
        return false;
    }

    @Override
    public List<List<CK_ATTRIBUTE>> getCertSerialNumberTemplates(byte[] aSerialNumber) {
        List<List<CK_ATTRIBUTE>> list = super.getCertSerialNumberTemplates(aSerialNumber);
        CK_ATTRIBUTE cK_ATTRIBUTE = new CK_ATTRIBUTE(0L, 1L);
        CK_ATTRIBUTE cK_ATTRIBUTE2 = new CK_ATTRIBUTE(2L, false);
        CK_ATTRIBUTE cK_ATTRIBUTE3 = new CK_ATTRIBUTE(1L, true);
        BigInteger bigInteger = new BigInteger(1, aSerialNumber);
        boolean bl = CardTemplate.b;
        ArrayList<CK_ATTRIBUTE> arrayList = new ArrayList<CK_ATTRIBUTE>();
        arrayList.add(cK_ATTRIBUTE);
        arrayList.add(cK_ATTRIBUTE2);
        arrayList.add(new CK_ATTRIBUTE(130L, bigInteger.toString(16)));
        arrayList.add(cK_ATTRIBUTE3);
        ArrayList<CK_ATTRIBUTE> arrayList2 = new ArrayList<CK_ATTRIBUTE>();
        arrayList2.add(cK_ATTRIBUTE);
        arrayList2.add(cK_ATTRIBUTE2);
        arrayList2.add(new CK_ATTRIBUTE(130L, aSerialNumber.toString()));
        arrayList2.add(cK_ATTRIBUTE3);
        String string = new BigInteger(aSerialNumber).toString(16);
        CharsetEncoder charsetEncoder = Charset.forName(AkisTemplate.b(28846, -6789)).newEncoder();
        ByteBuffer byteBuffer = null;
        for (int i = 0; i <= aSerialNumber.length * 2 - string.length(); ++i) {
            string = '0' + string;
            if (!bl) continue;
        }
        try {
            byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string.toCharArray()));
        }
        catch (CharacterCodingException characterCodingException) {
            logger.warn(AkisTemplate.b(28814, -15494), (Throwable)characterCodingException);
        }
        ArrayList<CK_ATTRIBUTE> arrayList3 = new ArrayList<CK_ATTRIBUTE>();
        arrayList3.add(cK_ATTRIBUTE);
        arrayList3.add(cK_ATTRIBUTE2);
        arrayList3.add(new CK_ATTRIBUTE(130L, byteBuffer.array()));
        arrayList3.add(cK_ATTRIBUTE3);
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derOutputStream.putInteger(new BigInteger(aSerialNumber));
        }
        catch (Exception exception) {
            logger.warn(AkisTemplate.b(28853, -31541), (Throwable)exception);
        }
        byte[] byArray = derOutputStream.toByteArray();
        ArrayList<CK_ATTRIBUTE> arrayList4 = new ArrayList<CK_ATTRIBUTE>();
        arrayList4.add(cK_ATTRIBUTE);
        arrayList4.add(cK_ATTRIBUTE2);
        arrayList4.add(new CK_ATTRIBUTE(130L, byArray));
        arrayList4.add(cK_ATTRIBUTE3);
        list.add(arrayList);
        list.add(arrayList2);
        list.add(arrayList3);
        list.add(arrayList4);
        return list;
    }

    @Override
    public List<CK_ATTRIBUTE> getRSAPublicKeyImportTemplate(String aLabel, RSAPrivateCrtKey aPrivKey, X509Certificate aCert, boolean aIsSign, boolean aIsEncrypt) {
        byte[] byArray = AkisTemplate.toByteArray(aPrivKey.getModulus());
        List<CK_ATTRIBUTE> list = super.getRSAPublicKeyImportTemplate(aLabel, aPrivKey, aCert, aIsSign, aIsEncrypt);
        list.add(new CK_ATTRIBUTE(289L, byArray.length * 8));
        return list;
    }

    @Override
    public void applyTemplate(KeyPairTemplate template) throws SmartCardException {
        block10: {
            if (template instanceof ECKeyPairTemplate) {
                Object object;
                block9: {
                    ECPublicKeyTemplate eCPublicKeyTemplate = (ECPublicKeyTemplate)template.getPublicKeyTemplate();
                    if (eCPublicKeyTemplate == null) break block9;
                    eCPublicKeyTemplate.getAsExplicitECParameters();
                    if (!eCPublicKeyTemplate.isSecretECCurve()) break block9;
                    object = ((ECParameterSpec)eCPublicKeyTemplate.getSpec()).getCurve();
                    ECPoint eCPoint = eCPublicKeyTemplate.getEcPublicKey().getW();
                    byte[] byArray = ECParameters.encodePoint(eCPoint, (EllipticCurve)object, true);
                    DerValue derValue = new DerValue(4, byArray);
                    try {
                        eCPublicKeyTemplate.add(new CK_ATTRIBUTE(385L, derValue.toByteArray()));
                    }
                    catch (IOException iOException) {
                        throw new SmartCardException(AkisTemplate.b(28856, 30250), iOException);
                    }
                    eCPublicKeyTemplate.add(new CK_ATTRIBUTE(CKA_SENSITIVE_EC_PARAMS, true));
                }
                object = (ECKeyTemplate)template.getPrivateKeyTemplate();
                if (object == null || !((ECKeyTemplate)object).isSecretECCurve()) break block10;
                ((KeyTemplate)object).add(new CK_ATTRIBUTE(CKA_SENSITIVE_EC_PARAMS, true));
            }
        }
    }

    @Override
    public String[] getATRHashes() {
        return ATR_HASHES.toArray(new String[0]);
    }

    public static void addATR(String aATR) {
        ATR_HASHES.add(aATR);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[37];
                var3_1 = 0;
                var2_2 = "\u00f8\u00a5\u0003\u0095U-\u00bf\u00ab\u00f6\u001b9V\u00da\u00bd\f\u00f0\u0082\u001b\u00bc^\u00b2'w0\u0080\u00d1/\u008f{U.\u00ed\u00b6\u00c4\u00b8O\u0096}\u00bd>\u0084\u00f62\\,\u008e\u00bb\u00cdV\u008cU\u0084\u00a4\u00fb\u00e6\u00a3i\b\u00b0\u008b\u0085r\u00b5\u00a2\u008bq\u009d\u000fg\u008f;\u00ce\u00d2Y\u00e1=O.o\u0000\u0094nEM<\u00e7\u0016\u00cf\u00f3[\u00fc\u0001\u009a\u001eO\u00e2\u00dc\u00c3\u008ev\u00cc\u00be\u00fd!\u00c2\u0092\u00f3\u008a}TC\u00b7M\u001a\u0088\u0097\u007f%\u00d0\u0011\u009a\u009d21\nA*\u0012s,\u00e6=U\u0084\u0090.\u0007%\u0099\u00ca\u00ec\u00dc\u0000p\u0091=\u0003\u0005\u00e2\u00caYg7\u00cf\u00d3%o\u008d\u00f6uze\u00f1<2\u00bbr\u0010}\u001cp+\u009bu\u00c28+\u00d1\u00bb\u0080lG.\u00a7\u001d\u008d\u00cdf9Xi\u009a\u001eba\u00ceF\u00dc\u00f6\u0087\u00fd\u00c5c\u00adE\u00aelqF\u0090X\u001e7\u00f7\u0081\u00cd.fmY\u00bd\u009a! \u00f2\u00da\u00e4H\u00b1.\u00ad\u001e\u00cc\u00adN4]\u00e9:\u000evcL\u0006\u008c\u00fe\u008d\u00fe\u0084@\u0085\u0006\u00ae\u00b2\u00d2\u00e3&\u00e1N\u00af\u00ca\u00f0\u00b5#\u0093\u0088S\u00c5\u0004o\u00bfXw\u00b4\u00f4e.\u00d36\u0003\u00a8\u00b7\u0095b\u00fc\u00dd\u00ac\u008a7\u00d3\u008c\u007f\u00af\u00f3\u00d6K\u0006|\u00e9\u0094\u00f96\u00f4x\u000e\u0003\u00fcS\u00da\u00be&\bl\u0094\u009d#%\u0017r<\u00f4\u00e8\u00c8.\u00d6o\u00a3\u0083\u00a3\u00f0\u00e0P\u008d9\u0080\u0085\u0092\u00daWe\u00f6\u008f\u00eb-h\u008c\u0016Ufar\u00bcB\u00ab\u000b\u0017\u00cbY\u00a6\u0083A`\u0099\u009a@\u0085\u00d6\n\u00c5\u0016.+\u0093\u001c\u001cT\u0002\u001e/R\u00d6{x\u00ede\u00b8\u0092\u000bsT\u00f1\u009f0\u00edt\u00ba;+\u00f5\u00ef\u00c3\u00fe}3\u0092C\u00beI\u0003G\u00b7\u00d7Cz\u00d7U~.h\u00a6t\u00baY\u00d7\u00bf\u00b4f\u00a5\u00fd\u0016=\u00a8\u00a2+HF<\u0014\u0092\u00abI\u00b1\u008d\u00fd\u000f/\u00ed\u00d9\u00feXu\u0091q\u009a\u00bbC\u00c6\u00fe\u00ab\t\u00ab\u009bj#.\u0093\u00d7\u000b\u0094\u00b6\u0012B\f\u00d9\u00b2\n\u00f4\u00c3\u00f4}\u00a0\u00b35C9})\u00c4WD_\u00f4v\u0014]\u0081\u00ae\u00dc\u00e8\u00be\u00f1\u00f6\u00ea\u00b0\u008a)\u00e4\u00a5#\u00a2\u0094&\u000f\u00c3\u00e3\u0011\u00b7Bc\u00e0\u00ff\u000e\u00d1\u0017\u0011\u0002\u0017tpUY4\u001f\u00d8\u00f85\u00bbt\u00cf\u009f7nS.\u00fd\u00afJ\u00a7\u00c0\u0092.*\u00c5<\u00d6PZ\u009e\u0005B\u0093y\u00d0\u00adp\u00b00\n't{\u009ba\u0018_\u00df\u007f\u0087rz\u00ddL\u00bee\u00ea\u0089\u00b1\u0010\u00e2l\u008b\u00b2\u00c4\u00d6'\u00cc\u0017.%\u00ed\u00dd\u00d3l\u00fb\u0019\u0010\u00b21g\u0084n\u00fa\u00c8a\u0005\r\u0095>\u00a7\u00c9\u009eM.\u00da\u00b9\u00c6\u00bdK\u00b4lz\u00b0j\u00fal\u008b\u00e3\u00a6Ca\u00e8\u0093\b\u0087.\u0086\u0080\u00a9~\u00e2O\u00c8\u00a7\u0088\u00c7 Z\u0086!\u00d5\u001a\u00a6`\u00e1\u00d0)3>\u00a2c\u009f\u00d2cVP\u00fdo\u00ef\u00b1\"\u009e\u00d1\u00c3\u008b\u00ee\u0002\u000b\u009e\u00db\u00b8-.\u0016\u008c\u00bb\u00ff\u00a0\u007f\u0080\u00a1\u0081\u0007\u0001B\u00a2\"Qz6l\u00f3Qk\u0003v\u00a4j_\u00f3{rSu\u000fs\u00bd\u00b1\u001f\u00a3\u00f3\u00c5\u00e8\u00cb\u00cb\u00a7\u00c3\u00e8..\u001aH:g\u0090l\u0086\u00c3AK\u0019\u00cb\u00a1\u00131\\:\u00a8r\u00c9[\u0010p\u00c6\u00aa\u0013\u00eb\u00f2qa\u001d+w\u00181\u00ab\u00b3e\u00c7:\u008b\u0091\u00af\u0088\u009a<.\u00e7\u00e7\u0085\u0092g\u00d2x\u0014\u009e\u00b1\u00e2\u0094\u00de\u00f8\u00de!\u00c7\u0007\u00cd<\u00ac\u00ae\u008e\u0011u\u00e9\u0010\u00ad\u000e\u0089\u00f2T\u008a\u00d6\u008erD^9]T}T\u0015\u00e5\u00f4.\u00e7'\u0085\u008ao\u00d4pq\u009f\u001d\u00c2\u0001\u00daJ^w\u00d7\u00cd\u00cfe\u00ec\u0085\u0086ttE08\n;q\u0000\u0099\u001e\u00eck\b}\u00b09e\u00f1r\u0084Q\u00c7.\u0015\u0010\u00dbl\u00ac\f\u0001\u00ee\u00b1\u00ee\u0007\u007fb\u0085I\u008e5\u00f0\u0093\u0081g>\u0087\u00b5,\u0003\u00f9\u00fd\u00b5,\u00b5\u0080Z-nI\u00ec\u00fd\u00f3hA\u00b8\u00a8\u00a8\u0003\u00e69\u0092{\u008a\u0016\u00ea\u00ed\u0003\u0002~\u00df\u00a8\u0007\u0001\u0003\u0087II\u00830\u0017\u00ff\u0017\u008cHr\u007f=\u008a\u008aT\u0005\u00a6\u00fa\u00a7\u008c\u008f\u00ca.\u00c6l~\u00d6\u00dc\fTe\u001b\n\u001c\u00b3T\u00c9d\u00a2_`G.'\u007f\u009d\u0081d\u00b1\u0018Y\u0092\u0018c\u00a1\u00ee^\u00d8\u00f5\u0007\u009f\u00d5l\u00af\u0083\u00eb\u0002z\u00f53,\u00ec\u00f8\u009e\u001a?~\u00c2#y\u00b0A\u00c1\u0017\u008db\u000eVD.cp\u0015`u\u008d:\u00de\u00d6\u00e8\u00eb\u00bf\u00ff\u009d\u00fa\u008dC\u0090]\u008d\u00be\u00bf\u00c9\u0085>\u0005\u00bb=\u00fd4\u00bc\u0083{MJEh|cXS\u00be\u00ealG\u00fe\u0017N\u00ba\u0013V\u00c7?i\u00ebR\"\fV\u00f6x$\u0082\u00e9\u00c1t\u00ac#\u008f\u00d1.\u00ee\u00a7\u00a4\u009aK\u00d0\u00f47\u000f\u00d5\u00d0\u0018\u0098i\u0016\u0013\u00deA\u00ee\u00f4\u00c8\u00b7\u00022\u00e4\u008d\"!H\u00189d\u0090\u0092\u00cd\u00fa,O4\u007f\u00f59`\u009d\u0013\u00e6.\u00846\u00e9\u00a8\u00ea\u0095\u00c9\u00fc\u00a8\u00ac$7\u0006\u008c\u00c5\u00af\u00a4\u00d6\u00a1\u0006!\u00e9?\u00f9C\u00f4\u00d6\u000e\u00d6\u00fd\u00ea\u00d8\u00ea\u0005\u0082\b\u00c5\u0011\t\u00b4R@\u0094\u00b2\u00fc{.j\u00a34\u001aQ\u00c3\u00be6F\u00f5\u00f9\u001c\u00bd\u00e9\u00b2\u0003JC|\u00b4\u009a\u00bfH3\u00ad\u00ad\u000b%m\u0098\u009ew\u0007\u0093?\u00darK\u00ff\u00ff\u008c)O\u009f\u0086\u00a6\nNY;\u00afQ\u001c^7\u0090\u00d1\nG\u00bfZs=\u0087\u0093Di\u00bf.\u00dc\u00d1\u00e2T\u0083\t\u00ed\f,\u00b2\u00b4\u00f4\u0014\u00f4\u0087\u00a0\u00ec7\u00a8:\u0000n\u001b\t\u00c7\u00eaF\u00cd\u00c4\u0085\u00ac\u00d7\u00a6\u00e4\u000b4\u00f4\u0096/D\u0096^\fq\u009a{.G\u001e\u0091\u00ad\u00e54(\u00e9\u0094\u000e\u00a3c\u00f6\u0006\u00db\u00feg\u00fe\u00d9@.\u0006\u00df\u00b3x\u00e1{\u00c8\u00ec\u00c1\u009e=?\u009a\u00c2\u00bfy#A\u00b3\u0017\u00c3b\u00c7Zz\u001eZ=W\u0084\u00dfL\u00ee\u00a0\u00c6\u00d0|\u00d11\u00aa5uvI\u00e6\u00cb\u0003\u00d1\u00f5*\u000f\u00d3\u0092\u00ac\u008c/.7\u00e7\u009f\u0092$\u00d2\u0010\u0014\u0093\u00b1C\u0094\u00ea\u00f8X!\u0017\u0007\u00d7<\u00ef\u00ae\u00e6\u0011x\u00e9\u00b1\u00ad:\u0089pU^\u00d7\u0014R\u0017ZS\u00dd\u0019m\u00fd\u0017\u00d4\u00b7.\u00aa\u00b6,\u00b8R\u0096\u00de\u00bdJ\u0084x2\u008d,\u00b4\u00bb\u008aVdU\u0099\u00a4-\u00e6\u00a2i(\u00b8\u008f\u008d\u00f2\u00b4\u00b2\u00abs\u0099O\u00e7\u0087+\u00cf\u00d0y\u00a556";
                var4_3 = "\u00f8\u00a5\u0003\u0095U-\u00bf\u00ab\u00f6\u001b9V\u00da\u00bd\f\u00f0\u0082\u001b\u00bc^\u00b2'w0\u0080\u00d1/\u008f{U.\u00ed\u00b6\u00c4\u00b8O\u0096}\u00bd>\u0084\u00f62\\,\u008e\u00bb\u00cdV\u008cU\u0084\u00a4\u00fb\u00e6\u00a3i\b\u00b0\u008b\u0085r\u00b5\u00a2\u008bq\u009d\u000fg\u008f;\u00ce\u00d2Y\u00e1=O.o\u0000\u0094nEM<\u00e7\u0016\u00cf\u00f3[\u00fc\u0001\u009a\u001eO\u00e2\u00dc\u00c3\u008ev\u00cc\u00be\u00fd!\u00c2\u0092\u00f3\u008a}TC\u00b7M\u001a\u0088\u0097\u007f%\u00d0\u0011\u009a\u009d21\nA*\u0012s,\u00e6=U\u0084\u0090.\u0007%\u0099\u00ca\u00ec\u00dc\u0000p\u0091=\u0003\u0005\u00e2\u00caYg7\u00cf\u00d3%o\u008d\u00f6uze\u00f1<2\u00bbr\u0010}\u001cp+\u009bu\u00c28+\u00d1\u00bb\u0080lG.\u00a7\u001d\u008d\u00cdf9Xi\u009a\u001eba\u00ceF\u00dc\u00f6\u0087\u00fd\u00c5c\u00adE\u00aelqF\u0090X\u001e7\u00f7\u0081\u00cd.fmY\u00bd\u009a! \u00f2\u00da\u00e4H\u00b1.\u00ad\u001e\u00cc\u00adN4]\u00e9:\u000evcL\u0006\u008c\u00fe\u008d\u00fe\u0084@\u0085\u0006\u00ae\u00b2\u00d2\u00e3&\u00e1N\u00af\u00ca\u00f0\u00b5#\u0093\u0088S\u00c5\u0004o\u00bfXw\u00b4\u00f4e.\u00d36\u0003\u00a8\u00b7\u0095b\u00fc\u00dd\u00ac\u008a7\u00d3\u008c\u007f\u00af\u00f3\u00d6K\u0006|\u00e9\u0094\u00f96\u00f4x\u000e\u0003\u00fcS\u00da\u00be&\bl\u0094\u009d#%\u0017r<\u00f4\u00e8\u00c8.\u00d6o\u00a3\u0083\u00a3\u00f0\u00e0P\u008d9\u0080\u0085\u0092\u00daWe\u00f6\u008f\u00eb-h\u008c\u0016Ufar\u00bcB\u00ab\u000b\u0017\u00cbY\u00a6\u0083A`\u0099\u009a@\u0085\u00d6\n\u00c5\u0016.+\u0093\u001c\u001cT\u0002\u001e/R\u00d6{x\u00ede\u00b8\u0092\u000bsT\u00f1\u009f0\u00edt\u00ba;+\u00f5\u00ef\u00c3\u00fe}3\u0092C\u00beI\u0003G\u00b7\u00d7Cz\u00d7U~.h\u00a6t\u00baY\u00d7\u00bf\u00b4f\u00a5\u00fd\u0016=\u00a8\u00a2+HF<\u0014\u0092\u00abI\u00b1\u008d\u00fd\u000f/\u00ed\u00d9\u00feXu\u0091q\u009a\u00bbC\u00c6\u00fe\u00ab\t\u00ab\u009bj#.\u0093\u00d7\u000b\u0094\u00b6\u0012B\f\u00d9\u00b2\n\u00f4\u00c3\u00f4}\u00a0\u00b35C9})\u00c4WD_\u00f4v\u0014]\u0081\u00ae\u00dc\u00e8\u00be\u00f1\u00f6\u00ea\u00b0\u008a)\u00e4\u00a5#\u00a2\u0094&\u000f\u00c3\u00e3\u0011\u00b7Bc\u00e0\u00ff\u000e\u00d1\u0017\u0011\u0002\u0017tpUY4\u001f\u00d8\u00f85\u00bbt\u00cf\u009f7nS.\u00fd\u00afJ\u00a7\u00c0\u0092.*\u00c5<\u00d6PZ\u009e\u0005B\u0093y\u00d0\u00adp\u00b00\n't{\u009ba\u0018_\u00df\u007f\u0087rz\u00ddL\u00bee\u00ea\u0089\u00b1\u0010\u00e2l\u008b\u00b2\u00c4\u00d6'\u00cc\u0017.%\u00ed\u00dd\u00d3l\u00fb\u0019\u0010\u00b21g\u0084n\u00fa\u00c8a\u0005\r\u0095>\u00a7\u00c9\u009eM.\u00da\u00b9\u00c6\u00bdK\u00b4lz\u00b0j\u00fal\u008b\u00e3\u00a6Ca\u00e8\u0093\b\u0087.\u0086\u0080\u00a9~\u00e2O\u00c8\u00a7\u0088\u00c7 Z\u0086!\u00d5\u001a\u00a6`\u00e1\u00d0)3>\u00a2c\u009f\u00d2cVP\u00fdo\u00ef\u00b1\"\u009e\u00d1\u00c3\u008b\u00ee\u0002\u000b\u009e\u00db\u00b8-.\u0016\u008c\u00bb\u00ff\u00a0\u007f\u0080\u00a1\u0081\u0007\u0001B\u00a2\"Qz6l\u00f3Qk\u0003v\u00a4j_\u00f3{rSu\u000fs\u00bd\u00b1\u001f\u00a3\u00f3\u00c5\u00e8\u00cb\u00cb\u00a7\u00c3\u00e8..\u001aH:g\u0090l\u0086\u00c3AK\u0019\u00cb\u00a1\u00131\\:\u00a8r\u00c9[\u0010p\u00c6\u00aa\u0013\u00eb\u00f2qa\u001d+w\u00181\u00ab\u00b3e\u00c7:\u008b\u0091\u00af\u0088\u009a<.\u00e7\u00e7\u0085\u0092g\u00d2x\u0014\u009e\u00b1\u00e2\u0094\u00de\u00f8\u00de!\u00c7\u0007\u00cd<\u00ac\u00ae\u008e\u0011u\u00e9\u0010\u00ad\u000e\u0089\u00f2T\u008a\u00d6\u008erD^9]T}T\u0015\u00e5\u00f4.\u00e7'\u0085\u008ao\u00d4pq\u009f\u001d\u00c2\u0001\u00daJ^w\u00d7\u00cd\u00cfe\u00ec\u0085\u0086ttE08\n;q\u0000\u0099\u001e\u00eck\b}\u00b09e\u00f1r\u0084Q\u00c7.\u0015\u0010\u00dbl\u00ac\f\u0001\u00ee\u00b1\u00ee\u0007\u007fb\u0085I\u008e5\u00f0\u0093\u0081g>\u0087\u00b5,\u0003\u00f9\u00fd\u00b5,\u00b5\u0080Z-nI\u00ec\u00fd\u00f3hA\u00b8\u00a8\u00a8\u0003\u00e69\u0092{\u008a\u0016\u00ea\u00ed\u0003\u0002~\u00df\u00a8\u0007\u0001\u0003\u0087II\u00830\u0017\u00ff\u0017\u008cHr\u007f=\u008a\u008aT\u0005\u00a6\u00fa\u00a7\u008c\u008f\u00ca.\u00c6l~\u00d6\u00dc\fTe\u001b\n\u001c\u00b3T\u00c9d\u00a2_`G.'\u007f\u009d\u0081d\u00b1\u0018Y\u0092\u0018c\u00a1\u00ee^\u00d8\u00f5\u0007\u009f\u00d5l\u00af\u0083\u00eb\u0002z\u00f53,\u00ec\u00f8\u009e\u001a?~\u00c2#y\u00b0A\u00c1\u0017\u008db\u000eVD.cp\u0015`u\u008d:\u00de\u00d6\u00e8\u00eb\u00bf\u00ff\u009d\u00fa\u008dC\u0090]\u008d\u00be\u00bf\u00c9\u0085>\u0005\u00bb=\u00fd4\u00bc\u0083{MJEh|cXS\u00be\u00ealG\u00fe\u0017N\u00ba\u0013V\u00c7?i\u00ebR\"\fV\u00f6x$\u0082\u00e9\u00c1t\u00ac#\u008f\u00d1.\u00ee\u00a7\u00a4\u009aK\u00d0\u00f47\u000f\u00d5\u00d0\u0018\u0098i\u0016\u0013\u00deA\u00ee\u00f4\u00c8\u00b7\u00022\u00e4\u008d\"!H\u00189d\u0090\u0092\u00cd\u00fa,O4\u007f\u00f59`\u009d\u0013\u00e6.\u00846\u00e9\u00a8\u00ea\u0095\u00c9\u00fc\u00a8\u00ac$7\u0006\u008c\u00c5\u00af\u00a4\u00d6\u00a1\u0006!\u00e9?\u00f9C\u00f4\u00d6\u000e\u00d6\u00fd\u00ea\u00d8\u00ea\u0005\u0082\b\u00c5\u0011\t\u00b4R@\u0094\u00b2\u00fc{.j\u00a34\u001aQ\u00c3\u00be6F\u00f5\u00f9\u001c\u00bd\u00e9\u00b2\u0003JC|\u00b4\u009a\u00bfH3\u00ad\u00ad\u000b%m\u0098\u009ew\u0007\u0093?\u00darK\u00ff\u00ff\u008c)O\u009f\u0086\u00a6\nNY;\u00afQ\u001c^7\u0090\u00d1\nG\u00bfZs=\u0087\u0093Di\u00bf.\u00dc\u00d1\u00e2T\u0083\t\u00ed\f,\u00b2\u00b4\u00f4\u0014\u00f4\u0087\u00a0\u00ec7\u00a8:\u0000n\u001b\t\u00c7\u00eaF\u00cd\u00c4\u0085\u00ac\u00d7\u00a6\u00e4\u000b4\u00f4\u0096/D\u0096^\fq\u009a{.G\u001e\u0091\u00ad\u00e54(\u00e9\u0094\u000e\u00a3c\u00f6\u0006\u00db\u00feg\u00fe\u00d9@.\u0006\u00df\u00b3x\u00e1{\u00c8\u00ec\u00c1\u009e=?\u009a\u00c2\u00bfy#A\u00b3\u0017\u00c3b\u00c7Zz\u001eZ=W\u0084\u00dfL\u00ee\u00a0\u00c6\u00d0|\u00d11\u00aa5uvI\u00e6\u00cb\u0003\u00d1\u00f5*\u000f\u00d3\u0092\u00ac\u008c/.7\u00e7\u009f\u0092$\u00d2\u0010\u0014\u0093\u00b1C\u0094\u00ea\u00f8X!\u0017\u0007\u00d7<\u00ef\u00ae\u00e6\u0011x\u00e9\u00b1\u00ad:\u0089pU^\u00d7\u0014R\u0017ZS\u00dd\u0019m\u00fd\u0017\u00d4\u00b7.\u00aa\u00b6,\u00b8R\u0096\u00de\u00bdJ\u0084x2\u008d,\u00b4\u00bb\u008aVdU\u0099\u00a4-\u00e6\u00a2i(\u00b8\u008f\u008d\u00f2\u00b4\u00b2\u00abs\u0099O\u00e7\u0087+\u00cf\u00d0y\u00a556".length();
                var1_4 = 30;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0013\u00e5\u00b8\u00bd\u00b2B\u00c7D\u0087\u00d7\u00b6\u00e8\u00a1\u00af\u00cex\u00b4\u009e\u00dfGV\u00f2\u007f.\u0017\u00e4\u009b\u00f2\u00a4\u00de\u0000\u0095\u0091\u0081\u0003\u0092\u00e28Y97\u0004\u00d3\\o\u00a2\u00f6\u0090z\u00d9\u00f1\u00ab2I}Mr\u00d4\u00912\u00a7VE\\\u00db]\u00a5\u0011\u00a8w";
                    var4_3 = "\u0013\u00e5\u00b8\u00bd\u00b2B\u00c7D\u0087\u00d7\u00b6\u00e8\u00a1\u00af\u00cex\u00b4\u009e\u00dfGV\u00f2\u007f.\u0017\u00e4\u009b\u00f2\u00a4\u00de\u0000\u0095\u0091\u0081\u0003\u0092\u00e28Y97\u0004\u00d3\\o\u00a2\u00f6\u0090z\u00d9\u00f1\u00ab2I}Mr\u00d4\u00912\u00a7VE\\\u00db]\u00a5\u0011\u00a8w".length();
                    var1_4 = 23;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 9;
                            break;
                        }
                        case 1: {
                            v13 = 18;
                            break;
                        }
                        case 2: {
                            v13 = 52;
                            break;
                        }
                        case 3: {
                            v13 = 96;
                            break;
                        }
                        case 4: {
                            v13 = 118;
                            break;
                        }
                        case 5: {
                            v13 = 52;
                            break;
                        }
                        default: {
                            v13 = 124;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        AkisTemplate.c = var5;
        AkisTemplate.d = new String[37];
        AkisTemplate.logger = LoggerFactory.getLogger(AkisTemplate.class);
        AkisTemplate.CKA_SENSITIVE_EC_PARAMS = 0x80000001L;
        AkisTemplate.ATR_HASHES = new ArrayList<String>();
        AkisTemplate.HISTORICAL_BYTE_REGEXES = new ArrayList<String>();
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28833, 26634));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28860, -16441));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28854, -8388));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28863, -26691));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28812, -21759));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28834, -7988));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28852, -12629));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28855, -3510));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28862, 22461));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28841, -5968));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28851, -3240));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28840, -21509));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28847, -10019));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28809, 12200));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28861, 11645));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28842, -5523));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28837, 17649));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28839, -26894));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28815, -16535));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28859, -27004));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28836, 29890));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28844, -30342));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28858, -32069));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28857, 16174));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28835, 26312));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28832, 12716));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28838, -23611));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28843, -5067));
        AkisTemplate.ATR_HASHES.add(AkisTemplate.b(28850, -19743));
        AkisTemplate.HISTORICAL_BYTE_REGEXES.add(AkisTemplate.b(28813, -19714));
        AkisTemplate.HISTORICAL_BYTE_REGEXES.add(AkisTemplate.b(28845, 21140));
    }

    private static String b(int n, int n2) {
        int n3 = (n ^ 0x70AD) & 0xFFFF;
        if (d[n3] == null) {
            int n4;
            int n5;
            char[] cArray = c[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 47;
                    break;
                }
                case 1: {
                    n5 = 111;
                    break;
                }
                case 2: {
                    n5 = 146;
                    break;
                }
                case 3: {
                    n5 = 99;
                    break;
                }
                case 4: {
                    n5 = 26;
                    break;
                }
                case 5: {
                    n5 = 90;
                    break;
                }
                case 6: {
                    n5 = 213;
                    break;
                }
                case 7: {
                    n5 = 36;
                    break;
                }
                case 8: {
                    n5 = 237;
                    break;
                }
                case 9: {
                    n5 = 73;
                    break;
                }
                case 10: {
                    n5 = 42;
                    break;
                }
                case 11: {
                    n5 = 10;
                    break;
                }
                case 12: {
                    n5 = 245;
                    break;
                }
                case 13: {
                    n5 = 152;
                    break;
                }
                case 14: {
                    n5 = 115;
                    break;
                }
                case 15: {
                    n5 = 253;
                    break;
                }
                case 16: {
                    n5 = 97;
                    break;
                }
                case 17: {
                    n5 = 227;
                    break;
                }
                case 18: {
                    n5 = 195;
                    break;
                }
                case 19: {
                    n5 = 167;
                    break;
                }
                case 20: {
                    n5 = 240;
                    break;
                }
                case 21: {
                    n5 = 113;
                    break;
                }
                case 22: {
                    n5 = 196;
                    break;
                }
                case 23: {
                    n5 = 151;
                    break;
                }
                case 24: {
                    n5 = 30;
                    break;
                }
                case 25: {
                    n5 = 40;
                    break;
                }
                case 26: {
                    n5 = 45;
                    break;
                }
                case 27: {
                    n5 = 109;
                    break;
                }
                case 28: {
                    n5 = 255;
                    break;
                }
                case 29: {
                    n5 = 197;
                    break;
                }
                case 30: {
                    n5 = 123;
                    break;
                }
                case 31: {
                    n5 = 81;
                    break;
                }
                case 32: {
                    n5 = 135;
                    break;
                }
                case 33: {
                    n5 = 192;
                    break;
                }
                case 34: {
                    n5 = 177;
                    break;
                }
                case 35: {
                    n5 = 156;
                    break;
                }
                case 36: {
                    n5 = 165;
                    break;
                }
                case 37: {
                    n5 = 6;
                    break;
                }
                case 38: {
                    n5 = 230;
                    break;
                }
                case 39: {
                    n5 = 84;
                    break;
                }
                case 40: {
                    n5 = 56;
                    break;
                }
                case 41: {
                    n5 = 7;
                    break;
                }
                case 42: {
                    n5 = 214;
                    break;
                }
                case 43: {
                    n5 = 133;
                    break;
                }
                case 44: {
                    n5 = 169;
                    break;
                }
                case 45: {
                    n5 = 226;
                    break;
                }
                case 46: {
                    n5 = 103;
                    break;
                }
                case 47: {
                    n5 = 225;
                    break;
                }
                case 48: {
                    n5 = 172;
                    break;
                }
                case 49: {
                    n5 = 67;
                    break;
                }
                case 50: {
                    n5 = 162;
                    break;
                }
                case 51: {
                    n5 = 25;
                    break;
                }
                case 52: {
                    n5 = 50;
                    break;
                }
                case 53: {
                    n5 = 19;
                    break;
                }
                case 54: {
                    n5 = 127;
                    break;
                }
                case 55: {
                    n5 = 66;
                    break;
                }
                case 56: {
                    n5 = 54;
                    break;
                }
                case 57: {
                    n5 = 102;
                    break;
                }
                case 58: {
                    n5 = 82;
                    break;
                }
                case 59: {
                    n5 = 13;
                    break;
                }
                case 60: {
                    n5 = 189;
                    break;
                }
                case 61: {
                    n5 = 138;
                    break;
                }
                case 62: {
                    n5 = 244;
                    break;
                }
                case 63: {
                    n5 = 43;
                    break;
                }
                case 64: {
                    n5 = 175;
                    break;
                }
                case 65: {
                    n5 = 62;
                    break;
                }
                case 66: {
                    n5 = 201;
                    break;
                }
                case 67: {
                    n5 = 51;
                    break;
                }
                case 68: {
                    n5 = 130;
                    break;
                }
                case 69: {
                    n5 = 57;
                    break;
                }
                case 70: {
                    n5 = 206;
                    break;
                }
                case 71: {
                    n5 = 187;
                    break;
                }
                case 72: {
                    n5 = 122;
                    break;
                }
                case 73: {
                    n5 = 63;
                    break;
                }
                case 74: {
                    n5 = 128;
                    break;
                }
                case 75: {
                    n5 = 112;
                    break;
                }
                case 76: {
                    n5 = 59;
                    break;
                }
                case 77: {
                    n5 = 131;
                    break;
                }
                case 78: {
                    n5 = 100;
                    break;
                }
                case 79: {
                    n5 = 212;
                    break;
                }
                case 80: {
                    n5 = 55;
                    break;
                }
                case 81: {
                    n5 = 198;
                    break;
                }
                case 82: {
                    n5 = 23;
                    break;
                }
                case 83: {
                    n5 = 147;
                    break;
                }
                case 84: {
                    n5 = 22;
                    break;
                }
                case 85: {
                    n5 = 58;
                    break;
                }
                case 86: {
                    n5 = 223;
                    break;
                }
                case 87: {
                    n5 = 190;
                    break;
                }
                case 88: {
                    n5 = 107;
                    break;
                }
                case 89: {
                    n5 = 61;
                    break;
                }
                case 90: {
                    n5 = 89;
                    break;
                }
                case 91: {
                    n5 = 251;
                    break;
                }
                case 92: {
                    n5 = 2;
                    break;
                }
                case 93: {
                    n5 = 60;
                    break;
                }
                case 94: {
                    n5 = 11;
                    break;
                }
                case 95: {
                    n5 = 34;
                    break;
                }
                case 96: {
                    n5 = 205;
                    break;
                }
                case 97: {
                    n5 = 160;
                    break;
                }
                case 98: {
                    n5 = 91;
                    break;
                }
                case 99: {
                    n5 = 236;
                    break;
                }
                case 100: {
                    n5 = 72;
                    break;
                }
                case 101: {
                    n5 = 4;
                    break;
                }
                case 102: {
                    n5 = 136;
                    break;
                }
                case 103: {
                    n5 = 220;
                    break;
                }
                case 104: {
                    n5 = 0;
                    break;
                }
                case 105: {
                    n5 = 78;
                    break;
                }
                case 106: {
                    n5 = 98;
                    break;
                }
                case 107: {
                    n5 = 29;
                    break;
                }
                case 108: {
                    n5 = 239;
                    break;
                }
                case 109: {
                    n5 = 1;
                    break;
                }
                case 110: {
                    n5 = 80;
                    break;
                }
                case 111: {
                    n5 = 210;
                    break;
                }
                case 112: {
                    n5 = 27;
                    break;
                }
                case 113: {
                    n5 = 150;
                    break;
                }
                case 114: {
                    n5 = 209;
                    break;
                }
                case 115: {
                    n5 = 222;
                    break;
                }
                case 116: {
                    n5 = 188;
                    break;
                }
                case 117: {
                    n5 = 38;
                    break;
                }
                case 118: {
                    n5 = 155;
                    break;
                }
                case 119: {
                    n5 = 178;
                    break;
                }
                case 120: {
                    n5 = 39;
                    break;
                }
                case 121: {
                    n5 = 93;
                    break;
                }
                case 122: {
                    n5 = 33;
                    break;
                }
                case 123: {
                    n5 = 96;
                    break;
                }
                case 124: {
                    n5 = 164;
                    break;
                }
                case 125: {
                    n5 = 186;
                    break;
                }
                case 126: {
                    n5 = 88;
                    break;
                }
                case 127: {
                    n5 = 219;
                    break;
                }
                case 128: {
                    n5 = 243;
                    break;
                }
                case 129: {
                    n5 = 235;
                    break;
                }
                case 130: {
                    n5 = 126;
                    break;
                }
                case 131: {
                    n5 = 181;
                    break;
                }
                case 132: {
                    n5 = 142;
                    break;
                }
                case 133: {
                    n5 = 49;
                    break;
                }
                case 134: {
                    n5 = 17;
                    break;
                }
                case 135: {
                    n5 = 14;
                    break;
                }
                case 136: {
                    n5 = 208;
                    break;
                }
                case 137: {
                    n5 = 9;
                    break;
                }
                case 138: {
                    n5 = 254;
                    break;
                }
                case 139: {
                    n5 = 157;
                    break;
                }
                case 140: {
                    n5 = 149;
                    break;
                }
                case 141: {
                    n5 = 140;
                    break;
                }
                case 142: {
                    n5 = 211;
                    break;
                }
                case 143: {
                    n5 = 16;
                    break;
                }
                case 144: {
                    n5 = 246;
                    break;
                }
                case 145: {
                    n5 = 176;
                    break;
                }
                case 146: {
                    n5 = 216;
                    break;
                }
                case 147: {
                    n5 = 20;
                    break;
                }
                case 148: {
                    n5 = 101;
                    break;
                }
                case 149: {
                    n5 = 118;
                    break;
                }
                case 150: {
                    n5 = 12;
                    break;
                }
                case 151: {
                    n5 = 44;
                    break;
                }
                case 152: {
                    n5 = 75;
                    break;
                }
                case 153: {
                    n5 = 106;
                    break;
                }
                case 154: {
                    n5 = 28;
                    break;
                }
                case 155: {
                    n5 = 76;
                    break;
                }
                case 156: {
                    n5 = 231;
                    break;
                }
                case 157: {
                    n5 = 207;
                    break;
                }
                case 158: {
                    n5 = 159;
                    break;
                }
                case 159: {
                    n5 = 69;
                    break;
                }
                case 160: {
                    n5 = 110;
                    break;
                }
                case 161: {
                    n5 = 139;
                    break;
                }
                case 162: {
                    n5 = 232;
                    break;
                }
                case 163: {
                    n5 = 217;
                    break;
                }
                case 164: {
                    n5 = 158;
                    break;
                }
                case 165: {
                    n5 = 168;
                    break;
                }
                case 166: {
                    n5 = 183;
                    break;
                }
                case 167: {
                    n5 = 32;
                    break;
                }
                case 168: {
                    n5 = 242;
                    break;
                }
                case 169: {
                    n5 = 218;
                    break;
                }
                case 170: {
                    n5 = 204;
                    break;
                }
                case 171: {
                    n5 = 248;
                    break;
                }
                case 172: {
                    n5 = 233;
                    break;
                }
                case 173: {
                    n5 = 35;
                    break;
                }
                case 174: {
                    n5 = 94;
                    break;
                }
                case 175: {
                    n5 = 144;
                    break;
                }
                case 176: {
                    n5 = 108;
                    break;
                }
                case 177: {
                    n5 = 21;
                    break;
                }
                case 178: {
                    n5 = 120;
                    break;
                }
                case 179: {
                    n5 = 87;
                    break;
                }
                case 180: {
                    n5 = 200;
                    break;
                }
                case 181: {
                    n5 = 124;
                    break;
                }
                case 182: {
                    n5 = 31;
                    break;
                }
                case 183: {
                    n5 = 143;
                    break;
                }
                case 184: {
                    n5 = 179;
                    break;
                }
                case 185: {
                    n5 = 125;
                    break;
                }
                case 186: {
                    n5 = 92;
                    break;
                }
                case 187: {
                    n5 = 173;
                    break;
                }
                case 188: {
                    n5 = 70;
                    break;
                }
                case 189: {
                    n5 = 171;
                    break;
                }
                case 190: {
                    n5 = 154;
                    break;
                }
                case 191: {
                    n5 = 141;
                    break;
                }
                case 192: {
                    n5 = 71;
                    break;
                }
                case 193: {
                    n5 = 95;
                    break;
                }
                case 194: {
                    n5 = 53;
                    break;
                }
                case 195: {
                    n5 = 221;
                    break;
                }
                case 196: {
                    n5 = 241;
                    break;
                }
                case 197: {
                    n5 = 104;
                    break;
                }
                case 198: {
                    n5 = 79;
                    break;
                }
                case 199: {
                    n5 = 105;
                    break;
                }
                case 200: {
                    n5 = 65;
                    break;
                }
                case 201: {
                    n5 = 74;
                    break;
                }
                case 202: {
                    n5 = 182;
                    break;
                }
                case 203: {
                    n5 = 174;
                    break;
                }
                case 204: {
                    n5 = 180;
                    break;
                }
                case 205: {
                    n5 = 129;
                    break;
                }
                case 206: {
                    n5 = 148;
                    break;
                }
                case 207: {
                    n5 = 15;
                    break;
                }
                case 208: {
                    n5 = 3;
                    break;
                }
                case 209: {
                    n5 = 170;
                    break;
                }
                case 210: {
                    n5 = 202;
                    break;
                }
                case 211: {
                    n5 = 121;
                    break;
                }
                case 212: {
                    n5 = 199;
                    break;
                }
                case 213: {
                    n5 = 114;
                    break;
                }
                case 214: {
                    n5 = 48;
                    break;
                }
                case 215: {
                    n5 = 68;
                    break;
                }
                case 216: {
                    n5 = 247;
                    break;
                }
                case 217: {
                    n5 = 134;
                    break;
                }
                case 218: {
                    n5 = 132;
                    break;
                }
                case 219: {
                    n5 = 191;
                    break;
                }
                case 220: {
                    n5 = 116;
                    break;
                }
                case 221: {
                    n5 = 185;
                    break;
                }
                case 222: {
                    n5 = 250;
                    break;
                }
                case 223: {
                    n5 = 5;
                    break;
                }
                case 224: {
                    n5 = 249;
                    break;
                }
                case 225: {
                    n5 = 194;
                    break;
                }
                case 226: {
                    n5 = 85;
                    break;
                }
                case 227: {
                    n5 = 137;
                    break;
                }
                case 228: {
                    n5 = 163;
                    break;
                }
                case 229: {
                    n5 = 234;
                    break;
                }
                case 230: {
                    n5 = 252;
                    break;
                }
                case 231: {
                    n5 = 215;
                    break;
                }
                case 232: {
                    n5 = 184;
                    break;
                }
                case 233: {
                    n5 = 238;
                    break;
                }
                case 234: {
                    n5 = 119;
                    break;
                }
                case 235: {
                    n5 = 24;
                    break;
                }
                case 236: {
                    n5 = 8;
                    break;
                }
                case 237: {
                    n5 = 83;
                    break;
                }
                case 238: {
                    n5 = 224;
                    break;
                }
                case 239: {
                    n5 = 229;
                    break;
                }
                case 240: {
                    n5 = 41;
                    break;
                }
                case 241: {
                    n5 = 203;
                    break;
                }
                case 242: {
                    n5 = 145;
                    break;
                }
                case 243: {
                    n5 = 86;
                    break;
                }
                case 244: {
                    n5 = 161;
                    break;
                }
                case 245: {
                    n5 = 166;
                    break;
                }
                case 246: {
                    n5 = 228;
                    break;
                }
                case 247: {
                    n5 = 52;
                    break;
                }
                case 248: {
                    n5 = 18;
                    break;
                }
                case 249: {
                    n5 = 46;
                    break;
                }
                case 250: {
                    n5 = 193;
                    break;
                }
                case 251: {
                    n5 = 77;
                    break;
                }
                case 252: {
                    n5 = 153;
                    break;
                }
                case 253: {
                    n5 = 64;
                    break;
                }
                case 254: {
                    n5 = 37;
                    break;
                }
                default: {
                    n5 = 117;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            AkisTemplate.d[n3] = new String(cArray).intern();
        }
        return d[n3];
    }
}

