/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.TagInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class GeneralizedTime
extends BaseASN1Object {
    private Date value;
    private double fractionOfSeconds = -1.0;
    private String fractionString = "";

    public GeneralizedTime(String name) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(24);
        this.setTagNumber(24);
    }

    public GeneralizedTime(String name, Object value) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(24);
        this.setTagNumber(24);
        if (value instanceof Date) {
            this.setValue(value);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object date) {
        this.value = (Date)date;
    }

    public double getFractionOfSeconds() {
        return this.fractionOfSeconds;
    }

    public void setFractionOfSeconds(double frac) {
        this.fractionOfSeconds = frac >= 0.0 && frac < 1.0 ? frac : -1.0;
    }

    public void decode(byte[] data) throws DecodeException {
        TagInfo tagInfo = this.getTagInfo(data, 0);
        if (this.tagClass != tagInfo.tagClass) {
            throw new DecodeException();
        }
        if (this.tagMethod != tagInfo.tagMethod) {
            throw new DecodeException();
        }
        if (this.tagNumber != tagInfo.tagNumber) {
            throw new DecodeException();
        }
        if (this.tagMethod != 1 && this.type != tagInfo.type) {
            throw new DecodeException();
        }
        if (tagInfo.contentIndex + tagInfo.contentLength != data.length) {
            throw new DecodeException();
        }
        this.setType(24);
        try {
            TimeZone tz;
            SimpleDateFormat sdf;
            String shortString;
            String dateString = new String(data, tagInfo.contentIndex, tagInfo.contentLength);
            GeneralizedTime.trace("GeneralizedTime.decode: " + dateString);
            if (dateString.charAt(14) == '.') {
                GeneralizedTime.trace("GeneralizedTime.decode: milliseconds are included");
                shortString = dateString.substring(0, 14);
                int zindex = dateString.indexOf(90);
                if (zindex == -1) {
                    zindex = dateString.indexOf(122);
                }
                if (zindex == -1) {
                    zindex = dateString.indexOf(43);
                }
                this.fractionString = dateString.substring(15, zindex);
                int miliSeconds = Integer.parseInt(this.fractionString) * (int)Math.pow(10.0, 3 - zindex + 15);
                this.fractionOfSeconds = (double)miliSeconds / 1000.0;
                sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            } else {
                GeneralizedTime.trace("GeneralizedTime.decode: milliseconds are not included");
                shortString = dateString.substring(0, 14);
                sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            }
            int tzIdx = dateString.indexOf(90);
            if (tzIdx != -1) {
                GeneralizedTime.trace("GeneralizedTime.decode: using Generalized time");
                tz = TimeZone.getTimeZone("GMT");
            } else {
                tzIdx = dateString.indexOf(43);
                if (tzIdx == -1 && (tzIdx = dateString.indexOf(45)) == -1) {
                    GeneralizedTime.trace("GeneralizedTime.decode: no time zone specified in " + dateString);
                    return;
                }
                String tzString = new String("GMT" + dateString.substring(tzIdx, tzIdx + 3));
                tzString = tzString.concat(":" + dateString.substring(tzIdx += 3, tzIdx + 2));
                GeneralizedTime.trace("GeneralizedTime.decode: creating a time zone of " + tzString);
                tz = TimeZone.getTimeZone(tzString);
            }
            sdf.setTimeZone(tz);
            GeneralizedTime.trace("GeneralizedTime.decode: short string is " + shortString);
            this.value = sdf.parse(shortString);
        }
        catch (ParseException e) {
            throw new DecodeException();
        }
    }

    protected byte[] getContentEncoding() {
        if (this.value != null) {
            TimeZone tz = TimeZone.getTimeZone("GMT");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            sdf.setTimeZone(tz);
            String x = sdf.format(this.value);
            if (this.fractionOfSeconds != -1.0) {
                int miliSaniye = (int)(this.fractionOfSeconds * 1000.0);
                x = x + ".";
                x = x + this.fractionString;
            }
            x = x + "Z";
            return x.getBytes();
        }
        return null;
    }

    public String toString() {
        if (this.value != null) {
            return new String(super.toString() + " " + this.value.toString());
        }
        return new String(super.toString());
    }

    public static void main(String[] args) {
        try {
            GeneralizedTime gtime = new GeneralizedTime("gtime");
            gtime.setValue(new Date());
            gtime.setFractionOfSeconds(0.008);
            System.out.println(new String(gtime.getEncoded()));
            GeneralizedTime gtime2 = new GeneralizedTime("gtime2");
            gtime2.decode(gtime.getEncoded());
            System.out.println(new String(gtime2.getEncoded()));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

