/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1CerOutputStream;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1InvalidLengthException;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import com.objsys.asn1j.runtime.Asn1UTF8String;
import com.objsys.asn1j.runtime.Asn1XerEncoder;
import com.objsys.asn1j.runtime.Asn1XmlEncoder;
import com.objsys.asn1j.runtime.h;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Asn1Real10
extends Asn1UTF8String {
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 9);
    private static final long serialVersionUID = -4325632075269696709L;
    private static h f = h.a();

    public Asn1Real10() {
    }

    public Asn1Real10(String string) {
        super(string);
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n2) throws Asn1Exception, IOException {
        block3: {
            block2: {
                int n3;
                int n4 = n3 = bl ? Asn1Real10.matchTag(asn1BerDecodeBuffer, TAG) : n2;
                if (n3 <= 0) break block2;
                byte by = (byte)asn1BerDecodeBuffer.read();
                super.decode(asn1BerDecodeBuffer, false, n3 - 1);
                if (!Asn1Exception.z) break block3;
            }
            this.value = "0";
        }
        f.lcheck(1);
        asn1BerDecodeBuffer.setTypeCode((short)9);
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        if (!asn1BerEncodeBuffer.isBER()) {
            return this.encode((Asn1DerEncodeBuffer)asn1BerEncodeBuffer, bl);
        }
        byte by = this.getNumberForm();
        int n2 = 0;
        if (by > 0) {
            n2 = this.value.length() + 1;
            asn1BerEncodeBuffer.checkSize(n2);
            super.encode(asn1BerEncodeBuffer, false);
            asn1BerEncodeBuffer.copy(by);
        }
        if (bl) {
            n2 += asn1BerEncodeBuffer.encodeTagAndLength(TAG, n2);
        }
        return n2;
    }

    public int encode(Asn1DerEncodeBuffer asn1DerEncodeBuffer, boolean bl) throws Asn1Exception {
        this.convertToNR3Form(false);
        int n2 = this.mStringBuffer.length();
        if (n2 > 0) {
            asn1DerEncodeBuffer.checkSize(++n2);
            asn1DerEncodeBuffer.copy(this.mStringBuffer.toString().getBytes());
            asn1DerEncodeBuffer.copy((byte)3);
        }
        if (bl) {
            n2 += asn1DerEncodeBuffer.encodeTagAndLength(TAG, n2);
        }
        return n2;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        block6: {
            block5: {
                long l2 = asn1PerDecodeBuffer.decodeLength();
                if (l2 <= 0L) break block5;
                if ((l2 - 1L) * 8L > Integer.MAX_VALUE) {
                    throw new Asn1InvalidLengthException();
                }
                int n2 = (int)l2 - 1;
                asn1PerDecodeBuffer.byteAlign();
                byte by = (byte)asn1PerDecodeBuffer.decodeBitsToInt(8);
                if (by != 3) {
                    throw new Asn1Exception("Invalid value of number form marker (must be 3)");
                }
                byte[] byArray = new byte[n2];
                asn1PerDecodeBuffer.decodeBitsToOctetArray(byArray, 0, n2 * 8);
                this.value = new String(byArray);
                if (!Asn1Exception.z) break block6;
            }
            this.value = "0";
        }
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        this.convertToNR3Form(false);
        int n2 = this.mStringBuffer.length();
        if (n2 > 0) {
            ++n2;
        }
        asn1PerEncodeBuffer.encodeLength(n2);
        if (n2 > 0) {
            asn1PerEncodeBuffer.byteAlign();
            this.mStringBuffer.insert(0, '\u0003');
            asn1PerEncodeBuffer.copy(this.mStringBuffer.toString().getBytes());
        }
    }

    public void encode(Asn1XerEncoder asn1XerEncoder, String string) throws IOException, Asn1Exception {
        if (string == null) {
            string = "REAL";
        }
        asn1XerEncoder.encodeStartElement(string);
        this.convertToNR3Form(true);
        asn1XerEncoder.copy(this.mStringBuffer.toString());
        asn1XerEncoder.encodeEndElement(string);
    }

    public void encode(Asn1XmlEncoder asn1XmlEncoder, String string, String string2) throws IOException, Asn1Exception {
        if (string == null) {
            string = "REAL";
        }
        asn1XmlEncoder.encodeStartElement(string, string2, true);
        this.convertToDecimal();
        asn1XmlEncoder.copy(this.mStringBuffer.toString());
        asn1XmlEncoder.encodeEndElement(string, string2);
    }

    public void encodeAttribute(Asn1XmlEncoder asn1XmlEncoder, String string) throws Asn1Exception, IOException {
        if (string != null) {
            this.convertToDecimal();
            asn1XmlEncoder.encodeAttr(string, this.mStringBuffer.toString());
        }
    }

    public static byte getNumberForm(String string) {
        boolean bl = Asn1Exception.z;
        int n2 = 1;
        boolean bl2 = true;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '.') {
                n2 = 2;
                if (!bl) continue;
            }
            if (c2 == 'e' || c2 == 'E') {
                n2 = 3;
                if (!bl) continue;
            }
            if (n2 == 3 || c2 <= '0' || c2 > '9') continue;
            bl2 = false;
            if (!bl) continue;
        }
        if (bl2) {
            n2 = 0;
        }
        return (byte)n2;
    }

    public byte getNumberForm() {
        return Asn1Real10.getNumberForm(this.value);
    }

    public void convertToNR3Form(boolean bl) {
        block49: {
            int n2;
            block50: {
                char c2;
                boolean bl2;
                int n3;
                int n4;
                int n5;
                boolean bl3;
                block45: {
                    block46: {
                        block48: {
                            block47: {
                                block44: {
                                    block43: {
                                        int n6;
                                        bl3 = Asn1Exception.z;
                                        n5 = 0;
                                        n4 = 0;
                                        n3 = 0;
                                        int n7 = 0;
                                        int n8 = 0;
                                        n2 = 0;
                                        bl2 = false;
                                        boolean bl4 = false;
                                        boolean bl5 = false;
                                        for (n6 = 0; n6 < this.value.length(); ++n6) {
                                            c2 = this.value.charAt(n6);
                                            if (c2 == '-') {
                                                bl2 = true;
                                                if (!bl3) continue;
                                            }
                                            if (c2 != ' ' && c2 != '0' && c2 != '+' && !bl3) break;
                                            if (!bl3) continue;
                                        }
                                        n5 = n4 = n6;
                                        while (n6 < this.value.length()) {
                                            block34: {
                                                block38: {
                                                    block35: {
                                                        block37: {
                                                            block36: {
                                                                block33: {
                                                                    c2 = this.value.charAt(n6);
                                                                    if (c2 != '0') break block33;
                                                                    ++n7;
                                                                    if (!bl3) break block34;
                                                                }
                                                                if (c2 <= '0' || c2 > '9') break block35;
                                                                if (n3 != 0 || !bl5) break block36;
                                                                n8 = -n7;
                                                                n3 = 1;
                                                                n5 = n6;
                                                                if (!bl3) break block37;
                                                            }
                                                            n3 += n7 + 1;
                                                        }
                                                        n7 = 0;
                                                        n4 = n6 + 1;
                                                        if (!bl3) break block34;
                                                    }
                                                    if (c2 != '.') break block38;
                                                    n8 = n3 + n7;
                                                    bl5 = true;
                                                    if (!bl3) break block34;
                                                }
                                                if (c2 == 'e' || c2 == 'E') {
                                                    ++n6;
                                                    if (!bl3) break;
                                                }
                                                if (c2 != ' ' && !bl3) break;
                                            }
                                            ++n6;
                                            if (!bl3) continue;
                                        }
                                        if (!bl5) {
                                            n8 = n3 + n7;
                                        }
                                        while (n6 < this.value.length()) {
                                            block40: {
                                                block39: {
                                                    c2 = this.value.charAt(n6);
                                                    if (c2 != '-') break block39;
                                                    bl4 = true;
                                                    if (!bl3) break block40;
                                                }
                                                if (c2 != ' ' && c2 != '0' && c2 != '+' && !bl3) break;
                                            }
                                            ++n6;
                                            if (!bl3) continue;
                                        }
                                        while (n6 < this.value.length()) {
                                            block42: {
                                                block41: {
                                                    c2 = this.value.charAt(n6);
                                                    if (c2 < '0' || c2 > '9') break block41;
                                                    n2 = n2 * 10 + (c2 - 48);
                                                    if (!bl3) break block42;
                                                }
                                                if (c2 != ' ' && !bl3) break;
                                            }
                                            ++n6;
                                            if (!bl3) continue;
                                        }
                                        if (bl4) {
                                            n2 = -n2;
                                        }
                                        n2 += n8;
                                        if (this.mStringBuffer != null) break block43;
                                        this.mStringBuffer = new StringBuffer();
                                        if (!bl3) break block44;
                                    }
                                    this.mStringBuffer.setLength(0);
                                }
                                if (!bl) break block45;
                                if (n3 <= 0) break block46;
                                --n2;
                                if (bl2) {
                                    this.mStringBuffer.append('-');
                                }
                                c2 = this.value.charAt(n5++);
                                this.mStringBuffer.append(c2);
                                if (n3 != 1) break block47;
                                this.mStringBuffer.append(".0E");
                                if (!bl3) break block48;
                            }
                            this.mStringBuffer.append('.');
                            while (n5 != n4) {
                                if ((c2 = this.value.charAt(n5++)) < '0' || c2 > '9') continue;
                                this.mStringBuffer.append(c2);
                                if (!bl3) continue;
                            }
                            this.mStringBuffer.append('E');
                        }
                        this.mStringBuffer.append(n2);
                        if (!bl3) break block49;
                    }
                    this.mStringBuffer.append('0');
                    if (!bl3) break block49;
                }
                if (n3 <= 0) break block49;
                n2 -= n3;
                if (bl2) {
                    this.mStringBuffer.append('-');
                }
                while (n5 != n4) {
                    if ((c2 = this.value.charAt(n5++)) < '0' || c2 > '9') continue;
                    this.mStringBuffer.append(c2);
                    if (!bl3) continue;
                }
                this.mStringBuffer.append(".E");
                if (n2 != 0) break block50;
                this.mStringBuffer.append("+0");
                if (!bl3) break block49;
            }
            this.mStringBuffer.append(n2);
        }
    }

    public void convertToDecimal() {
        char c2;
        int n2;
        boolean bl;
        boolean bl2;
        boolean bl3;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl4;
        block37: {
            block36: {
                bl4 = Asn1Exception.z;
                n8 = 0;
                n7 = 0;
                n6 = 0;
                n5 = 0;
                n4 = 0;
                n3 = 0;
                bl3 = false;
                bl2 = false;
                bl = false;
                for (n2 = 0; n2 < this.value.length(); ++n2) {
                    c2 = this.value.charAt(n2);
                    if (c2 == '-') {
                        bl3 = true;
                        if (!bl4) continue;
                    }
                    if (c2 != ' ' && c2 != '0' && c2 != '+' && !bl4) break;
                    if (!bl4) continue;
                }
                n8 = n7 = n2;
                while (n2 < this.value.length()) {
                    block31: {
                        block35: {
                            block32: {
                                block34: {
                                    block33: {
                                        block30: {
                                            c2 = this.value.charAt(n2);
                                            if (c2 != '0') break block30;
                                            ++n5;
                                            if (!bl4) break block31;
                                        }
                                        if (c2 <= '0' || c2 > '9') break block32;
                                        if (n6 != 0 || !bl) break block33;
                                        n4 = -n5;
                                        n6 = 1;
                                        n8 = n2;
                                        if (!bl4) break block34;
                                    }
                                    n6 += n5 + 1;
                                }
                                n5 = 0;
                                n7 = n2 + 1;
                                if (!bl4) break block31;
                            }
                            if (c2 != '.') break block35;
                            n4 = n6 + n5;
                            bl = true;
                            if (!bl4) break block31;
                        }
                        if (c2 == 'e' || c2 == 'E') {
                            ++n2;
                            if (!bl4) break;
                        }
                        if (c2 != ' ' && !bl4) break;
                    }
                    ++n2;
                    if (!bl4) continue;
                }
                if (this.mStringBuffer != null) break block36;
                this.mStringBuffer = new StringBuffer();
                if (!bl4) break block37;
            }
            this.mStringBuffer.setLength(0);
        }
        if (n6 == 0) {
            this.mStringBuffer.append('0');
            return;
        }
        if (!bl) {
            n4 = n6 + n5;
        }
        while (n2 < this.value.length()) {
            block39: {
                block38: {
                    c2 = this.value.charAt(n2);
                    if (c2 != '-') break block38;
                    bl2 = true;
                    if (!bl4) break block39;
                }
                if (c2 != ' ' && c2 != '0' && c2 != '+' && !bl4) break;
            }
            ++n2;
            if (!bl4) continue;
        }
        while (n2 < this.value.length()) {
            block41: {
                block40: {
                    c2 = this.value.charAt(n2);
                    if (c2 < '0' || c2 > '9') break block40;
                    n3 = n3 * 10 + (c2 - 48);
                    if (!bl4) break block41;
                }
                if (c2 != ' ' && !bl4) break;
            }
            ++n2;
            if (!bl4) continue;
        }
        if (bl2) {
            n3 = -n3;
        }
        n3 += n4;
        if (bl3) {
            this.mStringBuffer.append('-');
        }
        if (n3 <= 0) {
            this.mStringBuffer.append('0');
            if (n6 > 0) {
                this.mStringBuffer.append('.');
            }
        }
        while (n3 < 0) {
            ++n3;
            this.mStringBuffer.append('0');
            if (!bl4) continue;
        }
        while (n8 != n7) {
            if ((c2 = this.value.charAt(n8++)) < '0' || c2 > '9') continue;
            this.mStringBuffer.append(c2);
            if (--n3 != 0 || n8 == n7) continue;
            this.mStringBuffer.append('.');
            if (!bl4) continue;
        }
        while (n3 > 0) {
            --n3;
            this.mStringBuffer.append('0');
            if (!bl4) continue;
        }
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        if (!asn1BerOutputStream.isBER()) {
            this.encode((Asn1CerOutputStream)asn1BerOutputStream, bl);
            return;
        }
        int n2 = 0;
        byte by = this.getNumberForm();
        if (by > 0) {
            n2 = this.value.length() + 1;
        }
        if (bl) {
            asn1BerOutputStream.encodeTagAndLength(TAG, n2);
        }
        if (by > 0) {
            asn1BerOutputStream.write(by);
            asn1BerOutputStream.write(this.value.getBytes());
        }
    }

    public void encode(Asn1CerOutputStream asn1CerOutputStream, boolean bl) throws Asn1Exception, IOException {
        this.convertToNR3Form(false);
        int n2 = this.mStringBuffer.length();
        if (n2 > 0) {
            ++n2;
        }
        if (bl) {
            asn1CerOutputStream.encodeTagAndLength(TAG, n2);
        }
        if (n2 > 0) {
            asn1CerOutputStream.write(3);
            asn1CerOutputStream.write(this.mStringBuffer.toString().getBytes());
        }
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b);
        asn1PerOutputStream.a(false);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeUTF(this.value);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.value = objectInputStream.readUTF();
    }
}

