/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.cms;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.Sequence;
import com.turktrust.cms.SignedAttributes;
import com.turktrust.cms.SignerIdentifier;
import com.turktrust.cms.UnsignedAttributes;
import com.turktrust.x509.AlgorithmIdentifier;

public class SignerInfo
extends Sequence {
    private ASN1Integer cmsVersion = new ASN1Integer("cmsVersion");
    private SignerIdentifier sid = new SignerIdentifier("sid");
    private AlgorithmIdentifier digestAlgorithm = new AlgorithmIdentifier("digestAlgorithm");
    private SignedAttributes signedAttrs = new SignedAttributes("signedAttrs");
    private AlgorithmIdentifier signatureAlgorithm = new AlgorithmIdentifier("signatureAlgorithmIdentifier");
    private OctetString signature = new OctetString("signature");
    private UnsignedAttributes unsignedAttrs = new UnsignedAttributes("unsignedAttrs");

    public SignerInfo() {
        super("default_signerInfo");
        this.setUpElements();
    }

    public SignerInfo(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.cmsVersion);
        super.addElement(this.sid);
        super.addElement(this.digestAlgorithm);
        super.addElement(this.signedAttrs);
        this.signedAttrs.setOptional(true);
        this.signedAttrs.setTaggingMethod(1);
        this.signedAttrs.setForcedTagMethod(1);
        this.signedAttrs.setTagClass((byte)-128);
        this.signedAttrs.setTagNumber(0);
        super.addElement(this.signatureAlgorithm);
        super.addElement(this.signature);
        super.addElement(this.unsignedAttrs);
        this.unsignedAttrs.setOptional(true);
        this.unsignedAttrs.setTaggingMethod(1);
        this.unsignedAttrs.setForcedTagMethod(1);
        this.unsignedAttrs.setTagClass((byte)-128);
        this.unsignedAttrs.setTagNumber(1);
    }

    public void setCMSVersion(ASN1Integer value) {
        this.cmsVersion = value;
    }

    public ASN1Integer getCMSVersion() {
        return this.cmsVersion;
    }

    public void setSignerIdentifier(SignerIdentifier value) {
        this.sid = value;
    }

    public SignerIdentifier getSignerIdentifier() {
        return this.sid;
    }

    public void setDigestAlgorithm(AlgorithmIdentifier value) {
        this.digestAlgorithm = value;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setSignedAttributes(SignedAttributes value) {
        this.signedAttrs = value;
    }

    public SignedAttributes getSignedAttributes() {
        return this.signedAttrs;
    }

    public void setSignatureAlgorithm(AlgorithmIdentifier value) {
        this.signatureAlgorithm = value;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignature(OctetString value) {
        this.signature = value;
    }

    public OctetString getSignature() {
        return this.signature;
    }

    public void setUnsignedAttributes(UnsignedAttributes value) {
        this.unsignedAttrs = value;
    }

    public UnsignedAttributes getUnsignedAttributes() {
        return this.unsignedAttrs;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }
}

