/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.KeySpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_SESSION_INFO;
import sun.security.pkcs11.wrapper.CK_SLOT_INFO;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import tr.gov.tubitak.uekae.esya.api.asn.sun.security.util.DerValue;
import tr.gov.tubitak.uekae.esya.api.asn.sun.security.util.ObjectIdentifier;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.MA3APIEnvironment;
import tr.gov.tubitak.uekae.esya.api.common.util.StringUtil;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.CardType;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ec.ECParameters;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ec.NamedCurve;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.KeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.KeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECKeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECPrivateKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.ec.ECPublicKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAKeyPairTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAPrivateKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAPublicKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.symmetric.SecretKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.ESYAPKCS11;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.IPKCS11Ops;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.ops.key.SecretKey;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.ICardTemplate;

public class PKCS11Ops
implements IPKCS11Ops {
    private Logger a = LoggerFactory.getLogger(PKCS11Ops.class);
    private static List<String> b;
    protected PKCS11 mPKCS11;
    private CardType c;
    protected MessageDigest OZET_ALICI;
    protected ESYAPKCS11 mESYAPKCS11 = null;
    public static boolean d;
    private static final String[] f;
    private static final String[] g;

    public PKCS11Ops(CardType aKartTip) {
        try {
            this.OZET_ALICI = MessageDigest.getInstance(PKCS11Ops.a(11823, -15699));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.a.error(PKCS11Ops.a(11796, -24193), (Throwable)noSuchAlgorithmException);
            throw new RuntimeException(noSuchAlgorithmException);
        }
        this.c = aKartTip;
    }

    @Override
    public void initialize() throws PKCS11Exception, IOException {
        try {
            CK_C_INITIALIZE_ARGS cK_C_INITIALIZE_ARGS = this.a();
            String string = this.a(this.c.getLibName());
            this.mPKCS11 = PKCS11.getInstance(string, PKCS11Ops.a(11834, 4776), cK_C_INITIALIZE_ARGS, false);
        }
        catch (Exception exception) {
            throw new IOException(PKCS11Ops.a(11814, 20776), exception);
        }
    }

    CK_C_INITIALIZE_ARGS a() {
        return null;
    }

    @Override
    public long[] getTokenPresentSlotList() throws PKCS11Exception {
        return this.mPKCS11.C_GetSlotList(true);
    }

    @Override
    public List<Pair<Long, String>> getTokenPresentSlotListWithDescription() throws PKCS11Exception {
        long[] lArray = this.getTokenPresentSlotList();
        ArrayList<Pair<Long, String>> arrayList = new ArrayList<Pair<Long, String>>();
        long[] lArray2 = lArray;
        int n = lArray2.length;
        boolean bl = d;
        for (int i = 0; i < n; ++i) {
            long l = lArray2[i];
            String string = "";
            try {
                string = string + " " + new String(this.getSlotInfo((long)l).slotDescription).trim();
            }
            catch (Exception exception) {
                this.a.info(PKCS11Ops.a(11860, -31476) + exception.getMessage(), (Throwable)exception);
            }
            try {
                string = string + " " + new String(this.getTokenInfo((long)l).label).trim().split("\u0000")[0];
            }
            catch (Exception exception) {
                this.a.info(PKCS11Ops.a(11857, -3182) + exception.getMessage(), (Throwable)exception);
            }
            arrayList.add((Pair<Long, String>)new Pair((Object)l, (Object)string));
            if (!bl) continue;
        }
        return arrayList;
    }

    @Override
    public long[] getSlotList() throws PKCS11Exception {
        return this.mPKCS11.C_GetSlotList(false);
    }

    @Override
    public CK_SLOT_INFO getSlotInfo(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_GetSlotInfo(aSlotID);
    }

    @Override
    public CK_SESSION_INFO getSessionInfo(long aSessionID) throws PKCS11Exception {
        return this.mPKCS11.C_GetSessionInfo(aSessionID);
    }

    @Override
    public boolean isTokenPresent(long aSlotID) throws PKCS11Exception {
        CK_SLOT_INFO cK_SLOT_INFO = this.mPKCS11.C_GetSlotInfo(aSlotID);
        long l = cK_SLOT_INFO.flags;
        if ((l & 1L) != 0L) {
            return true;
        }
        return false;
    }

    @Override
    public CK_TOKEN_INFO getTokenInfo(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_GetTokenInfo(aSlotID);
    }

    @Override
    public long[] getMechanismList(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_GetMechanismList(aSlotID);
    }

    @Override
    public long openSession(long aSlotID) throws PKCS11Exception {
        return this.mPKCS11.C_OpenSession(aSlotID, 6L, null, null);
    }

    @Override
    public void closeSession(long aSessionID) throws PKCS11Exception {
        this.mPKCS11.C_CloseSession(aSessionID);
    }

    @Override
    public void login(long aSessionID, String aCardPIN) throws PKCS11Exception {
        this.mPKCS11.C_Login(aSessionID, 1L, aCardPIN.toCharArray());
    }

    @Override
    public void logout(long aSessionID) throws PKCS11Exception {
        this.mPKCS11.C_Logout(aSessionID);
    }

    @Override
    public boolean isAnyObjectExist(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            return false;
        }
        return true;
    }

    @Override
    public void importCertificate(long aSessionID, String aCertLabel, X509Certificate aSertifika) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.c.getCardTemplate().getCertificateTemplate(aCertLabel, aSertifika);
        this.mPKCS11.C_CreateObject(aSessionID, list.toArray(new CK_ATTRIBUTE[0]));
    }

    private void a(long l, String string, RSAKeyGenParameterSpec rSAKeyGenParameterSpec, boolean bl, boolean bl2) throws PKCS11Exception {
        CK_MECHANISM cK_MECHANISM;
        block12: {
            block11: {
                cK_MECHANISM = new CK_MECHANISM(0L);
                cK_MECHANISM.mechanism = 10L;
                cK_MECHANISM.pParameter = null;
                if (this.c == CardType.AKIS || this.c == CardType.ATIKHSM) break block11;
                if (this.c == CardType.DIRAKHSM) break block11;
                if (this.c == CardType.OPENDNSSOFTHSM) break block11;
                if (this.c != CardType.PROCENNEHSM) break block12;
            }
            cK_MECHANISM.mechanism = 0L;
        }
        int n = rSAKeyGenParameterSpec.getKeysize();
        BigInteger bigInteger = rSAKeyGenParameterSpec.getPublicExponent();
        if (bigInteger == null) {
            bigInteger = RSAKeyGenParameterSpec.F4;
        }
        ICardTemplate iCardTemplate = this.c.getCardTemplate();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = iCardTemplate.getRSAPublicKeyCreateTemplate(string, n, bigInteger, bl, bl2).toArray(new CK_ATTRIBUTE[0]);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = iCardTemplate.getRSAPrivateKeyCreateTemplate(string, bl, bl2).toArray(new CK_ATTRIBUTE[0]);
        this.mPKCS11.C_GenerateKeyPair(l, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        this.a(l, string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public void createKeyPair(long aSessionID, String aKeyLabel, AlgorithmParameterSpec aParamSpec, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, SmartCardException, IOException {
        boolean bl;
        block14: {
            bl = d;
            if (aParamSpec instanceof RSAKeyGenParameterSpec) {
                this.a(aSessionID, aKeyLabel, (RSAKeyGenParameterSpec)aParamSpec, aIsSign, aIsEncrypt);
                if (!bl) return;
            }
            if (!(aParamSpec instanceof ECParameterSpec)) break block14;
            this.a(aSessionID, aKeyLabel, (ECParameterSpec)aParamSpec, aIsSign, aIsEncrypt);
            if (!bl) return;
        }
        if (!(aParamSpec instanceof ECGenParameterSpec)) throw new SmartCardException(PKCS11Ops.a(11810, 11770));
        ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)aParamSpec;
        ECParameterSpec eCParameterSpec = NamedCurve.getECParameterSpec(eCGenParameterSpec.getName());
        if (eCParameterSpec == null) {
            throw new SmartCardException(PKCS11Ops.a(11868, 28426));
        }
        this.a(aSessionID, aKeyLabel, eCParameterSpec, aIsSign, aIsEncrypt);
        if (!bl) return;
        throw new SmartCardException(PKCS11Ops.a(11810, 11770));
    }

    private void a(long l, String string, ECParameterSpec eCParameterSpec, boolean bl, boolean bl2) throws PKCS11Exception, IOException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = 4160L;
        cK_MECHANISM.pParameter = null;
        byte[] byArray = ECParameters.encodeParameters(eCParameterSpec);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, false), new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(260L, bl2), new CK_ATTRIBUTE(266L, bl), new CK_ATTRIBUTE(384L, byArray), new CK_ATTRIBUTE(3L, string)};
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(261L, bl2), new CK_ATTRIBUTE(264L, bl), new CK_ATTRIBUTE(3L, string)};
        this.mPKCS11.C_GenerateKeyPair(l, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray3 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray3);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray4 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L)};
        this.mPKCS11.C_GetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray4);
        byte[] byArray2 = (byte[])cK_ATTRIBUTEArray4[0].pValue;
        byte[] byArray3 = this.c.getCardTemplate().getPointValue(byArray2);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray5 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string)};
        long[] lArray2 = this.objeAra(l, cK_ATTRIBUTEArray5);
        byte[] byArray4 = this.OZET_ALICI.digest(byArray3);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray6 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray4)};
        this.mPKCS11.C_SetAttributeValue(l, lArray2[0], cK_ATTRIBUTEArray6);
        this.mPKCS11.C_SetAttributeValue(l, lArray2[1], cK_ATTRIBUTEArray6);
    }

    @Override
    public void createSecretKey(long aSessionID, SecretKey aKey) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.c.getCardTemplate().getSecretKeyCreateTemplate(aKey);
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aKey.getGenerationMechanism();
        cK_MECHANISM.pParameter = null;
        this.mPKCS11.C_GenerateKey(aSessionID, cK_MECHANISM, list.toArray(new CK_ATTRIBUTE[0]));
    }

    @Override
    public void importSecretKey(long aSessionId, SecretKey aKey) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.c.getCardTemplate().getSecretKeyImportTemplate(aKey);
        this.mPKCS11.C_CreateObject(aSessionId, list.toArray(new CK_ATTRIBUTE[0]));
    }

    @Override
    public void importSecretKey(long aSessionId, SecretKeyTemplate aKeyTemplate) throws PKCS11Exception, SmartCardException {
        this.c.getCardTemplate().applyTemplate(aKeyTemplate);
        this.mPKCS11.C_CreateObject(aSessionId, aKeyTemplate.getAttributesAsArr());
    }

    @Override
    public byte[] signDataWithKeyID(long aSessionID, long aKeyID, CK_MECHANISM aMechanism, byte[] aImzalanacak) throws PKCS11Exception {
        this.mPKCS11.C_SignInit(aSessionID, aMechanism, aKeyID);
        byte[] byArray = this.mPKCS11.C_Sign(aSessionID, aImzalanacak);
        return byArray;
    }

    @Override
    public byte[] signDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, CK_MECHANISM aMechanism, byte[] aImzalanacak) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aSessionID, aSerialNumber);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(258L, byArray), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(1L, true)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(PKCS11Ops.a(11800, 19271));
        }
        this.mPKCS11.C_SignInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray2 = this.mPKCS11.C_Sign(aSessionID, aImzalanacak);
        return byArray2;
    }

    private byte[] a(long l, byte[] byArray) throws PKCS11Exception, SmartCardException {
        Object object;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
        long[] lArray;
        block8: {
            List<List<CK_ATTRIBUTE>> list = this.c.getCardTemplate().getCertSerialNumberTemplates(byArray);
            lArray = null;
            cK_ATTRIBUTEArray = list.iterator();
            boolean bl = d;
            while (cK_ATTRIBUTEArray.hasNext()) {
                object = cK_ATTRIBUTEArray.next();
                lArray = this.objeAra(l, object.toArray(new CK_ATTRIBUTE[0]));
                if (lArray.length > 0) {
                    break;
                }
                if (!bl) continue;
            }
            if (lArray != null && lArray.length != 0) break block8;
            throw new SmartCardException(PKCS11Ops.a(11840, -17556));
        }
        cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
        this.mPKCS11.C_GetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray);
        object = (byte[])cK_ATTRIBUTEArray[0].pValue;
        return object;
    }

    @Override
    public byte[] decryptDataWithCertSerialNo(long aSessionID, byte[] aSerialNumber, CK_MECHANISM aMechanism, byte[] aData) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aData);
        byte[] byArray2 = this.b(aSessionID, aSerialNumber);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(258L, byArray2), new CK_ATTRIBUTE(2L, true), new CK_ATTRIBUTE(1L, true)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(PKCS11Ops.a(11856, 19154));
        }
        byte[] byArray3 = new byte[1024];
        this.mPKCS11.C_DecryptInit(aSessionID, aMechanism, lArray[0]);
        int n = this.a(aSessionID, byArray, 0, byArray.length, byArray3, 0, byArray3.length);
        byte[] byArray4 = new byte[n];
        System.arraycopy(byArray3, 0, byArray4, 0, n);
        return byArray4;
    }

    private int a(long l, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws SmartCardException {
        Class<?> clazz = this.mPKCS11.getClass();
        Method[] methodArray = clazz.getMethods();
        AccessibleObject accessibleObject = null;
        int n5 = 0;
        while (true) {
            block17: {
                if (n5 >= methodArray.length) break;
                if (!methodArray[n5].getName().equals(PKCS11Ops.a(11785, -15010))) break block17;
                accessibleObject = methodArray[n5];
                break;
            }
            ++n5;
        }
        if (accessibleObject == null) {
            throw new SmartCardException(PKCS11Ops.a(11826, -16194));
        }
        if (!accessibleObject.isAccessible()) {
            ((Method)accessibleObject).setAccessible(true);
        }
        Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
        if (classArray.length == 7) {
            return (Integer)((Method)accessibleObject).invoke(this.mPKCS11, l, byArray, n, n2, byArray2, n3, n4);
        }
        if (classArray.length == 9) {
            return (Integer)((Method)accessibleObject).invoke(this.mPKCS11, l, 0, byArray, n, n2, 0, byArray2, n3, n4);
        }
        try {
            throw new SmartCardException(PKCS11Ops.a(11783, -8195));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SmartCardException(PKCS11Ops.a(11808, 5390), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SmartCardException(PKCS11Ops.a(11782, -16925), illegalAccessException);
        }
    }

    private byte[] b(long l, byte[] byArray) throws PKCS11Exception, SmartCardException {
        long[] lArray;
        block8: {
            List<List<CK_ATTRIBUTE>> list = this.c.getCardTemplate().getCertSerialNumberTemplates(byArray);
            boolean bl = d;
            lArray = null;
            for (List<CK_ATTRIBUTE> list2 : list) {
                lArray = this.objeAra(l, list2.toArray(new CK_ATTRIBUTE[0]));
                if (lArray.length > 0) {
                    break;
                }
                if (!bl) continue;
            }
            if (lArray != null && lArray.length != 0) break block8;
            throw new SmartCardException(PKCS11Ops.a(11839, -16153));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
        this.mPKCS11.C_GetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray);
        return (byte[])cK_ATTRIBUTEArray[0].pValue;
    }

    @Override
    public List<byte[]> getSignatureCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.a(aSessionID, true);
    }

    @Override
    public List<byte[]> getEncryptionCertificates(long aSessionID) throws PKCS11Exception, SmartCardException {
        return this.a(aSessionID, false);
    }

    private List<byte[]> a(long l, boolean bl) throws PKCS11Exception, SmartCardException {
        List<byte[]> list = this.getCertificates(l);
        boolean bl2 = d;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (byte[] byArray : list) {
            block17: {
                block19: {
                    Object object;
                    block18: {
                        X509Certificate x509Certificate = null;
                        try {
                            object = new ByteArrayInputStream(byArray);
                            CertificateFactory certificateFactory = CertificateFactory.getInstance(PKCS11Ops.a(11803, -91));
                            x509Certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)object);
                            ((InputStream)object).close();
                        }
                        catch (Exception exception) {
                            throw new SmartCardException(PKCS11Ops.a(11829, 3789) + StringUtil.toHexString((byte[])byArray), exception);
                        }
                        object = x509Certificate.getKeyUsage();
                        if (object == null) break block17;
                        if (!bl) break block18;
                        if (object[0] == false) break block17;
                        arrayList.add(byArray);
                        if (!bl2) break block17;
                    }
                    if (object[3] != false) break block19;
                    if (object[2] != false) break block19;
                    if (object[4] == false) break block17;
                }
                arrayList.add(byArray);
            }
            if (!bl2) continue;
        }
        return arrayList;
    }

    @Override
    public List<byte[]> getCertificates(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 1L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        long[] lArray2 = lArray;
        boolean bl = d;
        for (long l : lArray2) {
            this.mPKCS11.C_GetAttributeValue(aSessionID, l, cK_ATTRIBUTEArray2);
            byte[] byArray = (byte[])cK_ATTRIBUTEArray2[0].pValue;
            arrayList.add(byArray);
            if (!bl) continue;
        }
        return arrayList;
    }

    @Override
    public String[] getSignatureKeyLabels(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(264L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    @Override
    public String[] getEncryptionKeyLabels(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(260L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    @Override
    public String[] getWrapperKeyLabels(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(262L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    @Override
    public String[] getUnwrapperKeyLabels(long aSessionID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(263L, true)};
        return this.getLabels(aSessionID, cK_ATTRIBUTEArray);
    }

    public String[] getLabels(long aSessionID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        long[] lArray = this.objeAra(aSessionID, aTemplate);
        ArrayList<String> arrayList = new ArrayList<String>();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L)};
        long[] lArray2 = lArray;
        int n = lArray2.length;
        boolean bl = d;
        for (int i = 0; i < n; ++i) {
            long l = lArray2[i];
            this.mPKCS11.C_GetAttributeValue(aSessionID, l, cK_ATTRIBUTEArray);
            String string = new String((char[])cK_ATTRIBUTEArray[0].pValue);
            arrayList.add(string);
            if (!bl) continue;
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public boolean isObjectExist(long aSessionID, String aLabel) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length > 0) {
            return true;
        }
        return false;
    }

    private boolean a(long l, String string, long l2) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(0L, l2)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray);
        if (lArray.length > 0) {
            return true;
        }
        return false;
    }

    private void a(long l, String string, byte[] byArray, boolean bl) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 0L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(17L, byArray), new CK_ATTRIBUTE(2L, bl)};
        this.mPKCS11.C_CreateObject(l, cK_ATTRIBUTEArray);
    }

    @Override
    public void writePrivateData(long aSessionID, String aLabel, byte[] aData) throws PKCS11Exception {
        this.a(aSessionID, aLabel, aData, true);
    }

    @Override
    public void writePublicData(long aSessionID, String aLabel, byte[] aData) throws PKCS11Exception {
        this.a(aSessionID, aLabel, aData, false);
    }

    protected List<byte[]> _readData(long aSessionID, String aLabel, boolean aIsPrivate, long aDataType) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, aIsPrivate, true, aDataType);
    }

    protected List<byte[]> _readData(long aSessionID, String aLabel, boolean aIsPrivate, boolean aIstoken, long aDataType) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, aDataType), new CK_ATTRIBUTE(1L, aIstoken), new CK_ATTRIBUTE(2L, aIsPrivate), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        int n = lArray.length;
        boolean bl = d;
        if (n == 0) {
            throw new SmartCardException(aLabel + PKCS11Ops.a(11819, -13916));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (int i = 0; i < n; ++i) {
            this.mPKCS11.C_GetAttributeValue(aSessionID, lArray[i], cK_ATTRIBUTEArray2);
            byte[] byArray = (byte[])cK_ATTRIBUTEArray2[0].pValue;
            arrayList.add(byArray);
            if (!bl) continue;
        }
        return arrayList;
    }

    @Override
    public List<byte[]> readPrivateData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, true, 0L);
    }

    @Override
    public List<byte[]> readPublicData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, false, 0L);
    }

    @Override
    public boolean isPrivateKeyExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.a(aSessionID, aLabel, 3L);
    }

    @Override
    public boolean isPublicKeyExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.a(aSessionID, aLabel, 2L);
    }

    @Override
    public boolean isCertificateExist(long aSessionID, String aLabel) throws PKCS11Exception {
        return this.a(aSessionID, aLabel, 1L);
    }

    @Override
    public List<byte[]> readCertificate(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        return this._readData(aSessionID, aLabel, false, 1L);
    }

    @Override
    public byte[] readCertificate(long aSessionID, byte[] aCertSerialNo) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 1L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, false), new CK_ATTRIBUTE(130L, aCertSerialNo)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(PKCS11Ops.a(11867, -24187));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
        this.mPKCS11.C_GetAttributeValue(aSessionID, lArray[0], cK_ATTRIBUTEArray2);
        return (byte[])cK_ATTRIBUTEArray2[0].pValue;
    }

    @Override
    public KeySpec readPublicKeySpec(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(aLabel + PKCS11Ops.a(11788, 24250));
        }
        return this.a(aSessionID, lArray[0]);
    }

    @Override
    public KeySpec readPublicKeySpec(long aSessionID, byte[] aCertSerialNo) throws SmartCardException, PKCS11Exception {
        byte[] byArray = this.a(aSessionID, aCertSerialNo);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(258L, byArray)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(StringUtil.toHexString((byte[])byArray) + PKCS11Ops.a(11789, 8601));
        }
        return this.a(aSessionID, lArray[0]);
    }

    @Override
    public long getPrivateKeyObjIDFromCertificateSerial(long aSessionID, byte[] aCertSerialNo) throws SmartCardException, PKCS11Exception {
        byte[] byArray = this.a(aSessionID, aCertSerialNo);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(258L, byArray)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(StringUtil.toHexString((byte[])byArray) + PKCS11Ops.a(11786, 29775));
        }
        return lArray[0];
    }

    private KeySpec a(long l, long l2) throws SmartCardException, PKCS11Exception {
        Long l3;
        block7: {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(256L)};
            this.mPKCS11.C_GetAttributeValue(l, l2, cK_ATTRIBUTEArray);
            l3 = (Long)cK_ATTRIBUTEArray[0].pValue;
            if (l3 == 0L) {
                return this.b(l, l2);
            }
            if (l3 != 3L && l3 != 3L) break block7;
            return this._readECPublicKeySpec(l, l2);
        }
        throw new SmartCardException(PKCS11Ops.a(11835, 255), l3);
    }

    private RSAPublicKeySpec b(long l, long l2) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(290L), new CK_ATTRIBUTE(288L)};
        this.mPKCS11.C_GetAttributeValue(l, l2, cK_ATTRIBUTEArray);
        byte[] byArray = (byte[])cK_ATTRIBUTEArray[0].pValue;
        byte[] byArray2 = (byte[])cK_ATTRIBUTEArray[1].pValue;
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = new BigInteger(1, byArray2);
        return new RSAPublicKeySpec(bigInteger2, bigInteger);
    }

    protected ECPublicKeySpec _readECPublicKeySpec(long aSessionID, long aKeyId) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(384L), new CK_ATTRIBUTE(385L)};
        this.mPKCS11.C_GetAttributeValue(aSessionID, aKeyId, cK_ATTRIBUTEArray);
        byte[] byArray = (byte[])cK_ATTRIBUTEArray[0].pValue;
        byte[] byArray2 = (byte[])cK_ATTRIBUTEArray[1].pValue;
        try {
            ECParameterSpec eCParameterSpec = ECParameters.decodeParameters(byArray);
            byte[] byArray3 = this.c.getCardTemplate().getPointValue(byArray2);
            ECPoint eCPoint = ECParameters.decodePoint(byArray3, eCParameterSpec.getCurve());
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
            return eCPublicKeySpec;
        }
        catch (IOException iOException) {
            throw new SmartCardException(PKCS11Ops.a(11830, -31645), iOException);
        }
    }

    @Override
    public void updatePrivateData(long aSessionID, String aLabel, byte[] aValue) throws PKCS11Exception, SmartCardException {
        this.b(aSessionID, aLabel, aValue, true);
    }

    @Override
    public void updatePublicData(long aSessionID, String aLabel, byte[] aValue) throws PKCS11Exception, SmartCardException {
        this.b(aSessionID, aLabel, aValue, false);
    }

    private void b(long l, String string, byte[] byArray, boolean bl) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 0L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, bl), new CK_ATTRIBUTE(3L, string)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(string + PKCS11Ops.a(11799, -7422));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L, byArray)};
        this.mPKCS11.C_SetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray2);
    }

    protected void _deleteObject(long aSessionID, String aLabel, boolean aIsPrivate, boolean aIsToken) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, aIsToken), new CK_ATTRIBUTE(2L, aIsPrivate), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        boolean bl = d;
        if (lArray.length == 0) {
            throw new SmartCardException(aLabel + PKCS11Ops.a(11799, -7422));
        }
        for (int i = 0; i < lArray.length; ++i) {
            this.mPKCS11.C_DestroyObject(aSessionID, lArray[i]);
            if (!bl) continue;
        }
    }

    @Override
    public void deletePrivateObject(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this._deleteObject(aSessionID, aLabel, true, true);
    }

    @Override
    public void deletePublicObject(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this._deleteObject(aSessionID, aLabel, false, true);
    }

    private void a(long l, String string, boolean bl) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 0L), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(2L, bl), new CK_ATTRIBUTE(3L, string)};
        boolean bl2 = d;
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(string + PKCS11Ops.a(11799, -7422));
        }
        for (int i = 0; i < lArray.length; ++i) {
            this.mPKCS11.C_DestroyObject(l, lArray[i]);
            if (!bl2) continue;
        }
    }

    @Override
    public void deletePrivateData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.a(aSessionID, aLabel, true);
    }

    @Override
    public void deletePublicData(long aSessionID, String aLabel) throws PKCS11Exception, SmartCardException {
        this.a(aSessionID, aLabel, false);
    }

    @Override
    public byte[] getRandomData(long aSessionID, int aDataLength) throws PKCS11Exception {
        byte[] byArray = new byte[aDataLength];
        this.mPKCS11.C_GenerateRandom(aSessionID, byArray);
        return byArray;
    }

    @Override
    public byte[] getTokenSerialNo(long aSlotID) throws PKCS11Exception {
        char[] cArray = this.mPKCS11.C_GetTokenInfo((long)aSlotID).serialNumber;
        String string = new String(cArray);
        return string.trim().getBytes();
    }

    @Override
    public byte[] signData(long aSessionID, String aKeyLabel, byte[] aImzalanacak, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + PKCS11Ops.a(11827, 4893));
            }
        }
        this.mPKCS11.C_SignInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray = this.mPKCS11.C_Sign(aSessionID, aImzalanacak);
        return byArray;
    }

    @Override
    public byte[] signAndRecoverData(long aSessionID, String aKeyLabel, byte[] aImzalanacak, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + PKCS11Ops.a(11865, 21018));
            }
        }
        this.mPKCS11.C_SignRecoverInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray = new byte[1024];
        int n = this.mPKCS11.C_SignRecover(aSessionID, aImzalanacak, 0, aImzalanacak.length, byArray, 0, byArray.length);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    @Override
    public byte[] verifyAndRecoverData(long aSessionID, String aKeyLabel, byte[] aSignature, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + PKCS11Ops.a(11865, 21018));
            }
        }
        byte[] byArray = null;
        this.mPKCS11.C_VerifyRecoverInit(aSessionID, aMechanism, lArray[0]);
        byte[] byArray2 = new byte[1024];
        int n = this.mPKCS11.C_VerifyRecover(aSessionID, aSignature, 0, aSignature.length, byArray2, 0, byArray2.length);
        byArray = new byte[n];
        System.arraycopy(byArray2, 0, byArray, 0, n);
        return byArray;
    }

    @Override
    public void verifyData(long aSessionID, String aKeyLabel, byte[] aData, byte[] aImza, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aKeyLabel + PKCS11Ops.a(11795, -4927));
            }
        }
        this.mPKCS11.C_VerifyInit(aSessionID, aMechanism, lArray[0]);
        this.mPKCS11.C_Verify(aSessionID, aData, aImza);
    }

    @Override
    public void verifyData(long aSessionID, String aKeyLabel, byte[] aData, byte[] aImza, long aMechanism) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = aMechanism;
        this.verifyData(aSessionID, aKeyLabel, aData, aImza, cK_MECHANISM);
    }

    @Override
    public byte[] encryptData(long aSessionID, String aKeyLabel, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        ByteArrayOutputStream byteArrayOutputStream;
        block10: {
            int n;
            byte[] byArray;
            int n2;
            boolean bl;
            block9: {
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 2L)};
                bl = d;
                long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
                if (lArray.length == 0) {
                    cK_ATTRIBUTEArray[2] = new CK_ATTRIBUTE(0L, 4L);
                    lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
                    if (lArray.length == 0) {
                        throw new SmartCardException(aKeyLabel + PKCS11Ops.a(11865, 21018));
                    }
                }
                n2 = 1024;
                byteArrayOutputStream = new ByteArrayOutputStream();
                byArray = new byte[n2 + 128];
                this.mPKCS11.C_EncryptInit(aSessionID, aMechanism, lArray[0]);
                n = 0;
                if (aData.length >= n2) break block9;
                n = this.b(aSessionID, aData, 0, aData.length, byArray, 0, byArray.length);
                byteArrayOutputStream.write(byArray, 0, n);
                if (!bl) break block10;
            }
            int n3 = aData.length;
            int n4 = 0;
            while (n3 > 0) {
                int n5;
                block12: {
                    block11: {
                        n5 = 0;
                        if (n3 <= n2) break block11;
                        n5 = n2;
                        if (!bl) break block12;
                    }
                    n5 = n3;
                }
                n = this.mPKCS11.C_EncryptUpdate(aSessionID, 0L, aData, n4, n5, 0L, byArray, 0, byArray.length);
                byteArrayOutputStream.write(byArray, 0, n);
                n3 -= n5;
                n4 += n5;
                if (!bl) continue;
            }
            n = this.mPKCS11.C_EncryptFinal(aSessionID, 0L, byArray, 0, byArray.length);
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private int b(long l, byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) throws SmartCardException, PKCS11Exception {
        Class<?> clazz = this.mPKCS11.getClass();
        Method[] methodArray = clazz.getMethods();
        AccessibleObject accessibleObject = null;
        int n5 = 0;
        while (true) {
            block20: {
                if (n5 >= methodArray.length) break;
                if (!methodArray[n5].getName().equals(PKCS11Ops.a(11784, -10692))) break block20;
                accessibleObject = methodArray[n5];
                break;
            }
            ++n5;
        }
        if (accessibleObject == null) {
            throw new SmartCardException(PKCS11Ops.a(11822, 7035));
        }
        if (!accessibleObject.isAccessible()) {
            ((Method)accessibleObject).setAccessible(true);
        }
        Class<?>[] classArray = ((Method)accessibleObject).getParameterTypes();
        if (classArray.length == 7) {
            return (Integer)((Method)accessibleObject).invoke(this.mPKCS11, l, byArray, n, n2, byArray2, n3, n4);
        }
        if (classArray.length == 9) {
            return (Integer)((Method)accessibleObject).invoke(this.mPKCS11, l, 0, byArray, n, n2, 0, byArray2, n3, n4);
        }
        try {
            throw new SmartCardException(PKCS11Ops.a(11837, -22599));
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof PKCS11Exception) {
                throw (PKCS11Exception)invocationTargetException.getTargetException();
            }
            throw new SmartCardException(PKCS11Ops.a(11862, -5487), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SmartCardException(PKCS11Ops.a(11866, 4385), illegalAccessException);
        }
    }

    @Override
    public byte[] decryptData(long aSessionID, String aKeyLabel, byte[] aData, CK_MECHANISM aMechanism) throws PKCS11Exception, SmartCardException {
        ByteArrayOutputStream byteArrayOutputStream;
        block10: {
            int n;
            int n2;
            byte[] byArray;
            byte[] byArray2;
            boolean bl;
            block9: {
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(0L, 3L)};
                long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
                bl = d;
                if (lArray.length == 0) {
                    cK_ATTRIBUTEArray[1] = new CK_ATTRIBUTE(0L, 4L);
                    lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
                    if (lArray.length == 0) {
                        throw new SmartCardException(aKeyLabel + PKCS11Ops.a(11865, 21018));
                    }
                }
                long l = lArray[0];
                byteArrayOutputStream = new ByteArrayOutputStream();
                byArray2 = new byte[1152];
                this.mPKCS11.C_DecryptInit(aSessionID, aMechanism, l);
                byArray = this.a(aData);
                n2 = 1024;
                n = 0;
                if (byArray.length >= n2) break block9;
                n = this.a(aSessionID, byArray, 0, byArray.length, byArray2, 0, byArray2.length);
                byteArrayOutputStream.write(byArray2, 0, n);
                if (!bl) break block10;
            }
            int n3 = aData.length;
            int n4 = 0;
            while (n3 > 0) {
                int n5;
                block12: {
                    block11: {
                        n5 = 0;
                        if (n3 <= n2) break block11;
                        n5 = n2;
                        if (!bl) break block12;
                    }
                    n5 = n3;
                }
                n = this.mPKCS11.C_DecryptUpdate(aSessionID, 0L, byArray, n4, n5, 0L, byArray2, 0, byArray2.length);
                byteArrayOutputStream.write(byArray2, 0, n);
                n3 -= n5;
                n4 += n5;
                if (!bl) continue;
            }
            n = this.mPKCS11.C_DecryptFinal(aSessionID, 0L, byArray2, 0, byArray2.length);
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] a(byte[] byArray) {
        int n;
        block3: {
            n = byArray.length % 8;
            if (n != 1 || byArray[0] != 0) break block3;
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
            return byArray2;
        }
        if (n == 7) {
            byte[] byArray3 = new byte[byArray.length + 1];
            byArray3[0] = 0;
            System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
            return byArray3;
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void importCertificateAndKey(long aSessionID, String aCertLabel, String aKeyLabel, PrivateKey aPrivKey, X509Certificate aCert) throws PKCS11Exception, SmartCardException, IOException {
        Object object;
        block14: {
            block15: {
                byte[] byArray;
                boolean bl;
                boolean bl2;
                boolean bl3;
                block13: {
                    boolean[] blArray;
                    bl3 = false;
                    bl2 = d;
                    bl = false;
                    if (aCert != null && (blArray = aCert.getKeyUsage()) != null) {
                        bl3 = blArray[0];
                        bl = blArray[2] || blArray[3] || blArray[4];
                    }
                    byArray = aCert.getSubjectX500Principal().getEncoded();
                    if (!(aPrivKey instanceof RSAPrivateCrtKey)) break block13;
                    object = (RSAPrivateCrtKey)aPrivKey;
                    this.a(aSessionID, aKeyLabel, (RSAPrivateCrtKey)object, byArray, bl3, bl);
                    if (!bl2) break block14;
                }
                if (!(aPrivKey instanceof ECPrivateKey)) break block15;
                object = (ECPrivateKey)aPrivKey;
                ECPublicKey eCPublicKey = null;
                try {
                    eCPublicKey = (ECPublicKey)aCert.getPublicKey();
                }
                catch (ClassCastException classCastException) {
                    try {
                        PublicKey publicKey = aCert.getPublicKey();
                        Class<?> clazz = Class.forName(PKCS11Ops.a(11804, 24712));
                        Constructor<?> constructor = clazz.getConstructor(byte[].class);
                        eCPublicKey = (ECPublicKey)constructor.newInstance(new Object[]{publicKey.getEncoded()});
                    }
                    catch (Exception exception) {
                        this.a.warn(PKCS11Ops.a(11838, -25347), (Throwable)exception);
                        throw classCastException;
                    }
                }
                this.a(aSessionID, aKeyLabel, (ECPrivateKey)object, eCPublicKey, byArray, bl3, bl);
                if (!bl2) break block14;
            }
            throw new SmartCardException(PKCS11Ops.a(11778, -11668));
        }
        object = this.c.getCardTemplate().getCertificateTemplate(aCertLabel, aCert);
        this.mPKCS11.C_CreateObject(aSessionID, object.toArray(new CK_ATTRIBUTE[0]));
    }

    private void a(long l, String string, RSAPrivateCrtKey rSAPrivateCrtKey, byte[] byArray, boolean bl, boolean bl2) throws PKCS11Exception {
        List<CK_ATTRIBUTE> list = this.c.getCardTemplate().getRSAPrivateKeyImportTemplate(string, rSAPrivateCrtKey, null, bl, bl2);
        List<CK_ATTRIBUTE> list2 = this.c.getCardTemplate().getRSAPublicKeyImportTemplate(string, rSAPrivateCrtKey, null, bl, bl2);
        if (byArray != null) {
            list.add(new CK_ATTRIBUTE(257L, byArray));
        }
        this.mPKCS11.C_CreateObject(l, list.toArray(new CK_ATTRIBUTE[0]));
        this.mPKCS11.C_CreateObject(l, list2.toArray(new CK_ATTRIBUTE[0]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(long l, String string, ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey, byte[] byArray, boolean bl, boolean bl2) throws PKCS11Exception, IOException {
        Object object;
        byte[] byArray2;
        boolean bl3;
        ECParameterSpec eCParameterSpec;
        block18: {
            block17: {
                eCParameterSpec = eCPrivateKey.getParams();
                bl3 = d;
                if (this.c != CardType.AKIS) break block17;
                byArray2 = ECParameters.encodeECParameterSpec(eCParameterSpec);
                if (!bl3) break block18;
            }
            byArray2 = ECParameters.encodeParameters(eCParameterSpec);
        }
        ECPoint eCPoint = eCPublicKey.getW();
        byte[] byArray3 = ECParameters.encodePoint(eCPoint, eCParameterSpec.getCurve());
        DerValue derValue = new DerValue(4, byArray3);
        byte[] byArray4 = this.OZET_ALICI.digest(byArray3);
        ArrayList<CK_ATTRIBUTE> arrayList = new ArrayList<CK_ATTRIBUTE>();
        arrayList.add(new CK_ATTRIBUTE(1L, true));
        arrayList.add(new CK_ATTRIBUTE(0L, 2L));
        arrayList.add(new CK_ATTRIBUTE(256L, 3L));
        arrayList.add(new CK_ATTRIBUTE(384L, byArray2));
        arrayList.add(new CK_ATTRIBUTE(385L, derValue.toByteArray()));
        arrayList.add(new CK_ATTRIBUTE(3L, string));
        arrayList.add(new CK_ATTRIBUTE(2L, false));
        arrayList.add(new CK_ATTRIBUTE(258L, byArray4));
        if (bl2) {
            arrayList.add(new CK_ATTRIBUTE(268L, bl2));
        }
        if (bl) {
            arrayList.add(new CK_ATTRIBUTE(266L, bl));
        }
        boolean bl4 = false;
        ECParameterSpec eCParameterSpec2 = eCPublicKey.getParams();
        if (eCParameterSpec2 instanceof NamedCurve) {
            bl4 = true;
            object = NamedCurve.getNameCurves();
            ObjectIdentifier objectIdentifier = ((NamedCurve)eCParameterSpec2).getObjectIdentifier();
            for (NamedCurve namedCurve : object.values()) {
                if (namedCurve.getObjectIdentifier().toString().equals(objectIdentifier.toString())) {
                    bl4 = false;
                    if (!bl3) break;
                }
                if (!bl3) continue;
            }
        }
        arrayList.add(new CK_ATTRIBUTE(2L, bl4));
        object = new ArrayList();
        object.add(new CK_ATTRIBUTE(1L, true));
        object.add(new CK_ATTRIBUTE(2L, true));
        object.add(new CK_ATTRIBUTE(0L, 3L));
        object.add(new CK_ATTRIBUTE(256L, 3L));
        object.add(new CK_ATTRIBUTE(3L, string));
        object.add(new CK_ATTRIBUTE(17L, eCPrivateKey.getS()));
        object.add(new CK_ATTRIBUTE(384L, byArray2));
        object.add(new CK_ATTRIBUTE(258L, byArray4));
        if (bl2) {
            object.add(new CK_ATTRIBUTE(268L, bl2));
        }
        if (bl) {
            object.add(new CK_ATTRIBUTE(264L, bl));
        }
        if (byArray != null) {
            object.add(new CK_ATTRIBUTE(257L, byArray));
        }
        this.mPKCS11.C_CreateObject(l, arrayList.toArray(new CK_ATTRIBUTE[0]));
        this.mPKCS11.C_CreateObject(l, object.toArray(new CK_ATTRIBUTE[0]));
    }

    @Override
    @Deprecated
    public void importKeyPair(long aSessionID, String aLabel, KeyPair aKeyPair, byte[] aSubject, boolean aIsSign, boolean aIsEncrypt) throws PKCS11Exception, SmartCardException, IOException {
        block13: {
            block14: {
                PublicKey publicKey;
                boolean bl;
                PrivateKey privateKey;
                block12: {
                    privateKey = aKeyPair.getPrivate();
                    bl = d;
                    publicKey = aKeyPair.getPublic();
                    if (!(privateKey instanceof RSAPrivateCrtKey) || !(publicKey instanceof RSAPublicKey)) break block12;
                    this.a(aSessionID, aLabel, (RSAPrivateCrtKey)privateKey, aSubject, aIsSign, aIsEncrypt);
                    if (!bl) break block13;
                }
                if (!(privateKey instanceof ECPrivateKey)) break block14;
                if (!(publicKey instanceof ECPublicKey)) break block14;
                this.a(aSessionID, aLabel, (ECPrivateKey)privateKey, (ECPublicKey)publicKey, aSubject, aIsSign, aIsEncrypt);
                if (!bl) break block13;
            }
            throw new SmartCardException(PKCS11Ops.a(11812, 19710));
        }
    }

    @Override
    public void changePassword(String aOldPass, String aNewPass, long aSessionID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.changePassword(aOldPass, aNewPass, (int)aSessionID);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public void formatToken(String aSOpin, String aNewPIN, String aLabel, int slotID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.formatToken(aSOpin, aNewPIN, aLabel, slotID);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public void setSOPin(byte[] aSOPin, byte[] aNewSOPin, long aSessionID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.setSOPin(aSOPin, aSOPin.length, aNewSOPin, aNewSOPin.length, (int)aSessionID);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public void changeUserPin(byte[] aSOPin, byte[] aUserPin, long aSessionID) throws PKCS11Exception {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.changeUserPin(aSOPin, aSOPin.length, aUserPin, aUserPin.length, (int)aSessionID);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public boolean setContainer(byte[] aContainerLabel, long aSessionID) {
        String string = this.c.getLibName();
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(string);
        }
        int n = this.mESYAPKCS11.setContainer(aContainerLabel, aContainerLabel.length, (int)aSessionID, string);
        if ((long)n == 0L) {
            return true;
        }
        return false;
    }

    @Override
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, byte[] aPbCertData, int aSignOrEnc) {
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(this.c.getLibName());
        }
        int n = this.mESYAPKCS11.importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarCifti.length, aAnahtarLen, aScfname, aScfname.length(), aContextName, aContextName.length(), aPbCertData, aSignOrEnc);
        if ((long)n == 0L) {
            return true;
        }
        return false;
    }

    @Override
    public boolean importCertificateAndKeyWithCSP(byte[] aAnahtarCifti, int aAnahtarLen, String aScfname, String aContextName, X509Certificate aPbCertificate, int aSignOrEnc) {
        byte[] byArray = null;
        try {
            byArray = aPbCertificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            this.a.warn(PKCS11Ops.a(11816, 16551), (Throwable)certificateEncodingException);
            return false;
        }
        return this.importCertificateAndKeyWithCSP(aAnahtarCifti, aAnahtarLen, aScfname, aContextName, byArray, aSignOrEnc);
    }

    protected void changePUK(byte[] aOldPUK, byte[] aNewPUK, long aSessionID) throws PKCS11Exception {
        String string = this.c.getLibName();
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(string);
        }
        int n = this.mESYAPKCS11.ChangePUK(aOldPUK, aOldPUK.length, aNewPUK, aNewPUK.length, (int)aSessionID, string);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    protected void unBlockPIN(byte[] aPUK, byte[] aUserPIN, long aSessionID) throws PKCS11Exception {
        String string = this.c.getLibName();
        if (this.mESYAPKCS11 == null) {
            this.mESYAPKCS11 = new ESYAPKCS11(string);
        }
        int n = this.mESYAPKCS11.UnBlockPIN(aPUK, aPUK.length, aUserPIN, aUserPIN.length, (int)aSessionID, string);
        if ((long)n != 0L) {
            throw new PKCS11Exception((long)n);
        }
    }

    @Override
    public long[] objeAra(long aSessionID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        long l = 200L;
        this.mPKCS11.C_FindObjectsInit(aSessionID, aTemplate);
        long[] lArray = this.mPKCS11.C_FindObjects(aSessionID, l);
        this.mPKCS11.C_FindObjectsFinal(aSessionID);
        return lArray;
    }

    @Override
    public void getAttributeValue(long aSessionID, long aObjectID, CK_ATTRIBUTE[] aTemplate) throws PKCS11Exception {
        this.mPKCS11.C_GetAttributeValue(aSessionID, aObjectID, aTemplate);
    }

    @Override
    public void changeLabel(long aSessionID, String aOldLabel, String aNewLabel) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(3L, aOldLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        boolean bl = d;
        if (lArray.length == 0) {
            throw new SmartCardException(aOldLabel + PKCS11Ops.a(11799, -7422));
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aNewLabel)};
        for (int i = 0; i < lArray.length; ++i) {
            this.mPKCS11.C_SetAttributeValue(aSessionID, lArray[i], cK_ATTRIBUTEArray2);
            if (!bl) continue;
        }
    }

    private String a(String string) {
        String string2 = System.getProperty(PKCS11Ops.a(11869, 24890));
        boolean bl = d;
        this.a.debug(PKCS11Ops.a(11809, -20305) + string2);
        this.a.debug(PKCS11Ops.a(11779, 25537) + string2);
        if (new File(string).exists()) {
            this.a.info(string + PKCS11Ops.a(11858, 19034));
            return string;
        }
        String string3 = System.getProperty(PKCS11Ops.a(11792, 26012));
        String string4 = System.getProperty(PKCS11Ops.a(11871, 16954));
        String[] stringArray = string3.split(string4);
        for (String string5 : stringArray) {
            String string6 = string5 + System.getProperty(PKCS11Ops.a(11801, 2029)) + System.mapLibraryName(string);
            this.a.debug(PKCS11Ops.a(11836, -28519) + string6);
            if (!new File(string6).exists()) continue;
            this.a.info(PKCS11Ops.a(11798, 18854) + string6);
            return string6;
        }
        for (String string7 : b) {
            String string8 = string7 + System.mapLibraryName(string);
            this.a.debug(PKCS11Ops.a(11836, -28519) + string8);
            if (new File(string8).exists()) {
                this.a.info(PKCS11Ops.a(11791, -9031) + string8);
                return string8;
            }
            this.a.debug(PKCS11Ops.a(11870, -16902) + string8);
            if (!bl) continue;
        }
        this.a.info(PKCS11Ops.a(11791, -9031) + System.mapLibraryName(string));
        return System.mapLibraryName(string);
    }

    protected byte[] toByteArray(BigInteger aX) {
        byte[] byArray = aX.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        return byArray;
    }

    @Override
    public byte[] generateRSAPrivateKey(long aSessionID, int keySize) throws ESYAException {
        throw new RuntimeException(PKCS11Ops.a(11821, 23456));
    }

    @Override
    public KeyPair generateECKeyPair(long aSessionID, ECParameterSpec ecParameterSpec) throws ESYAException {
        throw new RuntimeException(PKCS11Ops.a(11861, 6845));
    }

    @Override
    public byte[] getModulusOfKey(long aSessionID, long aObjID) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L)};
        this.getAttributeValue(aSessionID, aObjID, cK_ATTRIBUTEArray);
        return (byte[])cK_ATTRIBUTEArray[0].pValue;
    }

    private long b(long l, String string, long l2) throws SmartCardException, PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, l2), new CK_ATTRIBUTE(3L, string)};
        long[] lArray = this.objeAra(l, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(l, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(string + PKCS11Ops.a(11865, 21018));
            }
        }
        return lArray[0];
    }

    @Override
    public long getObjIDFromPublicKeyLabel(long aSessionID, String aLabel) throws SmartCardException, PKCS11Exception {
        return this.b(aSessionID, aLabel, 2L);
    }

    @Override
    public long getObjIDFromPrivateKeyLabel(long aSessionID, String aLabel) throws SmartCardException, PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(3L, aLabel)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE(0L, 4L);
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(aLabel + PKCS11Ops.a(11865, 21018));
            }
        }
        return lArray[0];
    }

    @Override
    public byte[] wrapKey(long aSessionID, CK_MECHANISM aMechanism, String wrapperKeyLabel, String aKeyLabel) throws PKCS11Exception, SmartCardException {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, wrapperKeyLabel), new CK_ATTRIBUTE(0L, 2L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[1].pValue = 4L;
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(wrapperKeyLabel + PKCS11Ops.a(11793, -17100));
            }
        }
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(2L, true)};
        long[] lArray2 = this.objeAra(aSessionID, cK_ATTRIBUTEArray2);
        if (lArray2.length == 0) {
            throw new SmartCardException(aKeyLabel + PKCS11Ops.a(11790, 14499));
        }
        return this.mPKCS11.C_WrapKey(aSessionID, aMechanism, lArray[0], lArray2[0]);
    }

    @Override
    public byte[] wrapKey(long aSessionID, CK_MECHANISM aMechanism, KeyTemplate wrapperKeyTemplate, KeyTemplate aToBeExportedKeyTemplate) throws PKCS11Exception {
        this.a(aSessionID, wrapperKeyTemplate, aToBeExportedKeyTemplate);
        return this.mPKCS11.C_WrapKey(aSessionID, aMechanism, wrapperKeyTemplate.getKeyId(), aToBeExportedKeyTemplate.getKeyId());
    }

    private void a(long l, KeyTemplate ... keyTemplateArray) throws PKCS11Exception {
        KeyTemplate[] keyTemplateArray2 = keyTemplateArray;
        int n = keyTemplateArray2.length;
        boolean bl = d;
        for (int i = 0; i < n; ++i) {
            KeyTemplate keyTemplate = keyTemplateArray2[i];
            if (keyTemplate.getKeyId() > 0L) continue;
            this.a(l, keyTemplate);
            continue;
        }
    }

    private void a(long l, KeyTemplate keyTemplate) throws PKCS11Exception {
        long[] lArray;
        block7: {
            lArray = this.objeAra(l, keyTemplate.getAttributesAsArr());
            if (lArray != null && lArray.length != 0) break block7;
            return;
        }
        if (lArray.length > 1) {
            this.a.warn(PKCS11Ops.a(11776, -7744) + keyTemplate);
        }
        keyTemplate.setKeyId(lArray[0]);
    }

    @Override
    public void unwrapKey(long aSessionID, CK_MECHANISM aMechanism, String unwrapperKeyLabel, byte[] aWrappedKey, KeyTemplate aUnwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aWrappedKey);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, unwrapperKeyLabel), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            cK_ATTRIBUTEArray[1].pValue = 4L;
            lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
            if (lArray.length == 0) {
                throw new SmartCardException(unwrapperKeyLabel + PKCS11Ops.a(11790, 14499));
            }
        }
        long l = this.mPKCS11.C_UnwrapKey(aSessionID, aMechanism, lArray[0], byArray, aUnwrappedKeyTemplate.getAttributesAsArr());
        aUnwrappedKeyTemplate.setKeyId(l);
        String string = aUnwrappedKeyTemplate.getLabel();
        this.a(aSessionID, string);
    }

    @Override
    public void unwrapKey(long aSessionID, CK_MECHANISM aMechanism, KeyTemplate unwrapperKeyTemplate, byte[] aWrappedKey, KeyTemplate aUnwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aWrappedKey);
        this.a(aUnwrappedKeyTemplate);
        this.a(aSessionID, new KeyTemplate[]{unwrapperKeyTemplate});
        long l = this.mPKCS11.C_UnwrapKey(aSessionID, aMechanism, unwrapperKeyTemplate.getKeyId(), byArray, aUnwrappedKeyTemplate.getAttributesAsArr());
        aUnwrappedKeyTemplate.setKeyId(l);
        String string = unwrapperKeyTemplate.getLabel();
        this.a(aSessionID, string);
    }

    private void a(KeyTemplate keyTemplate) throws SmartCardException {
        ICardTemplate iCardTemplate = this.c.getCardTemplate();
        if (keyTemplate instanceof SecretKeyTemplate) {
            iCardTemplate.applyTemplate((SecretKeyTemplate)keyTemplate);
        }
    }

    @Override
    public void unwrapKey(long aSessionID, CK_MECHANISM aMechanism, byte[] certSerialNumber, byte[] aWrappedKey, KeyTemplate aUnwrappedKeyTemplate) throws PKCS11Exception, SmartCardException {
        byte[] byArray = this.a(aWrappedKey);
        byte[] byArray2 = this.b(aSessionID, certSerialNumber);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray2), new CK_ATTRIBUTE(0L, 3L)};
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        if (lArray.length == 0) {
            throw new SmartCardException(StringUtil.toString((byte[])certSerialNumber) + PKCS11Ops.a(11824, 18061));
        }
        long l = this.mPKCS11.C_UnwrapKey(aSessionID, aMechanism, lArray[0], byArray, aUnwrappedKeyTemplate.getAttributesAsArr());
        aUnwrappedKeyTemplate.setKeyId(l);
    }

    public PKCS11 getmPKCS11() {
        return this.mPKCS11;
    }

    @Override
    public KeySpec createKeyPair(long aSessionID, KeyPairTemplate template) throws PKCS11Exception, IOException, SmartCardException {
        if (this.a.isDebugEnabled()) {
            this.a(((KeyTemplate)template.getPrivateKeyTemplate()).getAttributesAsArr());
            this.a(((KeyTemplate)template.getPublicKeyTemplate()).getAttributesAsArr());
        }
        if (template instanceof RSAKeyPairTemplate) {
            return this.createKeyPair(aSessionID, (RSAKeyPairTemplate)template);
        }
        if (template instanceof ECKeyPairTemplate) {
            return this.a(aSessionID, (ECKeyPairTemplate)template);
        }
        throw new ESYARuntimeException(PKCS11Ops.a(11864, -5194) + template);
    }

    public KeySpec createKeyPair(long aSessionID, RSAKeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        long[] lArray = this.createKeyPairWithOutRead(aSessionID, template);
        RSAPublicKeySpec rSAPublicKeySpec = this.b(aSessionID, lArray[0]);
        String string = ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).getLabel();
        this.a(aSessionID, string);
        ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).setKeyId(lArray[0]);
        ((RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()).setKeyId(lArray[1]);
        return rSAPublicKeySpec;
    }

    protected long[] createKeyPairWithOutRead(long aSessionID, RSAKeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = 0L;
        cK_MECHANISM.pParameter = null;
        ICardTemplate iCardTemplate = this.c.getCardTemplate();
        iCardTemplate.applyTemplate(template);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).getAttributesAsArr();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = ((RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()).getAttributesAsArr();
        if (this.a.isDebugEnabled()) {
            this.a(cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        }
        long[] lArray = this.mPKCS11.C_GenerateKeyPair(aSessionID, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        return lArray;
    }

    protected long[] createKeyPairWithOutRead(long aSessionID, ECKeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(0L);
        cK_MECHANISM.mechanism = 4160L;
        cK_MECHANISM.pParameter = null;
        ICardTemplate iCardTemplate = this.c.getCardTemplate();
        iCardTemplate.applyTemplate(template);
        ECPublicKeyTemplate eCPublicKeyTemplate = (ECPublicKeyTemplate)template.getPublicKeyTemplate();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = eCPublicKeyTemplate.getAttributesAsArr();
        ECPrivateKeyTemplate eCPrivateKeyTemplate = (ECPrivateKeyTemplate)template.getPrivateKeyTemplate();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = eCPrivateKeyTemplate.getAttributesAsArr();
        long[] lArray = this.mPKCS11.C_GenerateKeyPair(aSessionID, cK_MECHANISM, cK_ATTRIBUTEArray, cK_ATTRIBUTEArray2);
        return lArray;
    }

    private void a(long l, String string) {
        boolean bl = d;
        try {
            long[] lArray;
            block5: {
                CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, string), new CK_ATTRIBUTE(1L, true)};
                lArray = this.objeAra(l, cK_ATTRIBUTEArray);
                if (lArray != null && lArray.length >= 1) break block5;
                return;
            }
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L)};
            this.mPKCS11.C_GetAttributeValue(l, lArray[0], cK_ATTRIBUTEArray);
            byte[] byArray = (byte[])cK_ATTRIBUTEArray[0].pValue;
            this.OZET_ALICI.update(byArray);
            byte[] byArray2 = this.OZET_ALICI.digest();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray2)};
            for (long l2 : lArray) {
                this.mPKCS11.C_SetAttributeValue(l, l2, cK_ATTRIBUTEArray2);
                if (!bl) continue;
                break;
            }
        }
        catch (Exception exception) {
            this.a.warn(PKCS11Ops.a(11817, 13986), (Throwable)exception);
        }
    }

    private KeySpec a(long l, ECKeyPairTemplate eCKeyPairTemplate) throws SmartCardException, IOException, PKCS11Exception {
        long[] lArray = this.createKeyPairWithOutRead(l, eCKeyPairTemplate);
        long l2 = lArray[0];
        byte[] byArray = this.d(l, l2);
        this.a(l, lArray, byArray);
        return this.a(l, l2);
    }

    private byte[] c(long l, long l2) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L)};
        this.mPKCS11.C_GetAttributeValue(l, l2, cK_ATTRIBUTEArray);
        return (byte[])cK_ATTRIBUTEArray[0].pValue;
    }

    private void a(long l, long[] lArray, ECPublicKeyTemplate eCPublicKeyTemplate) throws PKCS11Exception {
        byte[] byArray = this.a(eCPublicKeyTemplate);
        this.a(l, lArray, byArray);
    }

    private void a(long l, long[] lArray, byte[] byArray) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L, byArray)};
        boolean bl = d;
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == -1L) continue;
            this.mPKCS11.C_SetAttributeValue(l, lArray[i], cK_ATTRIBUTEArray);
            continue;
        }
    }

    private byte[] a(ECPublicKeyTemplate eCPublicKeyTemplate) {
        ECPoint eCPoint = eCPublicKeyTemplate.getEcPublicKey().getW();
        EllipticCurve ellipticCurve = ((ECParameterSpec)eCPublicKeyTemplate.getSpec()).getCurve();
        byte[] byArray = ECParameters.encodePoint(eCPoint, ellipticCurve, false);
        return this.OZET_ALICI.digest(byArray);
    }

    private byte[] d(long l, long l2) throws IOException, PKCS11Exception {
        byte[] byArray = this.c(l, l2);
        byte[] byArray2 = this.c.getCardTemplate().getPointValue(byArray);
        byte[] byArray3 = this.OZET_ALICI.digest(byArray2);
        return byArray3;
    }

    @Override
    public void importKeyPair(long sessionID, KeyPairTemplate template) throws PKCS11Exception, SmartCardException {
        block9: {
            block10: {
                boolean bl;
                block8: {
                    this.c.getCardTemplate().applyTemplate(template);
                    bl = d;
                    if (!(template instanceof RSAKeyPairTemplate)) break block8;
                    this.importKeyPair(sessionID, (RSAKeyPairTemplate)template);
                    if (!bl) break block9;
                }
                if (!(template instanceof ECKeyPairTemplate)) break block10;
                this.importKeyPair(sessionID, (ECKeyPairTemplate)template);
                if (!bl) break block9;
            }
            throw new ESYARuntimeException(PKCS11Ops.a(11811, -21969) + template);
        }
    }

    public void importKeyPair(long sessionID, RSAKeyPairTemplate template) throws PKCS11Exception {
        long l;
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray;
        String string = ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).getLabel();
        if (template.getPublicKeyTemplate() != null) {
            cK_ATTRIBUTEArray = ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).getAttributesAsArr();
            l = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            ((RSAPublicKeyTemplate)template.getPublicKeyTemplate()).setKeyId(l);
        }
        if (template.getPrivateKeyTemplate() != null) {
            cK_ATTRIBUTEArray = ((RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()).getAttributesAsArr();
            l = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            ((RSAPrivateKeyTemplate)template.getPrivateKeyTemplate()).setKeyId(l);
        }
        this.a(sessionID, string);
    }

    public void importKeyPair(long sessionID, ECKeyPairTemplate template) throws PKCS11Exception {
        long l = -1L;
        if (template.getPublicKeyTemplate() != null) {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = ((KeyTemplate)template.getPublicKeyTemplate()).getAttributesAsArr();
            l = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            ((KeyTemplate)template.getPublicKeyTemplate()).setKeyId(l);
        }
        long l2 = -1L;
        if (template.getPrivateKeyTemplate() != null) {
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = ((KeyTemplate)template.getPrivateKeyTemplate()).getAttributesAsArr();
            l2 = this.mPKCS11.C_CreateObject(sessionID, cK_ATTRIBUTEArray);
            ((KeyTemplate)template.getPrivateKeyTemplate()).setKeyId(l2);
        }
        this.a(sessionID, new long[]{l, l2}, (ECPublicKeyTemplate)template.getPublicKeyTemplate());
    }

    @Override
    public void createSecretKey(long sessionID, SecretKeyTemplate template) throws PKCS11Exception, SmartCardException {
        this.c.getCardTemplate().applyTemplate(template);
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = template.getAttributesAsArr();
        CK_MECHANISM cK_MECHANISM = new CK_MECHANISM(template.getGenerationMechanism());
        long l = this.mPKCS11.C_GenerateKey(sessionID, cK_MECHANISM, cK_ATTRIBUTEArray);
        template.setKeyId(l);
    }

    @Override
    public int deleteCertificate(long aSessionID, String aKeyLabel) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(3L, aKeyLabel), new CK_ATTRIBUTE(0L, 1L)};
        boolean bl = d;
        long[] lArray = this.objeAra(aSessionID, cK_ATTRIBUTEArray);
        int n = 0;
        if (lArray.length > 0) {
            for (int i = 0; i < lArray.length; ++i) {
                this.mPKCS11.C_DestroyObject(aSessionID, lArray[i]);
                ++n;
                if (!bl) continue;
            }
        }
        return n;
    }

    private void a(CK_MECHANISM cK_MECHANISM, CK_ATTRIBUTE[] cK_ATTRIBUTEArray, CK_ATTRIBUTE[] cK_ATTRIBUTEArray2) {
        block4: {
            block5: {
                if (!this.a.isDebugEnabled()) break block4;
                this.a.debug(PKCS11Ops.a(11831, 4494));
                this.a.debug(PKCS11Ops.a(11805, -10656) + cK_MECHANISM.mechanism);
                this.a.debug(PKCS11Ops.a(11780, 2897));
                if (cK_MECHANISM.pParameter != null) break block5;
                this.a.debug(PKCS11Ops.a(11863, 20436));
            }
            this.a.debug("\n");
            this.a.debug(PKCS11Ops.a(11818, 30875));
            this.a(cK_ATTRIBUTEArray2);
            this.a.debug(PKCS11Ops.a(11832, 26408));
            this.a.debug(PKCS11Ops.a(11859, 11855));
            this.a(cK_ATTRIBUTEArray);
            this.a.debug(PKCS11Ops.a(11797, 4457));
        }
    }

    private void a(CK_ATTRIBUTE[] cK_ATTRIBUTEArray) {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray2 = cK_ATTRIBUTEArray;
        int n = cK_ATTRIBUTEArray2.length;
        boolean bl = d;
        for (int i = 0; i < n; ++i) {
            CK_ATTRIBUTE cK_ATTRIBUTE = cK_ATTRIBUTEArray2[i];
            this.a.debug(cK_ATTRIBUTE.toString());
            System.out.println(cK_ATTRIBUTE.toString());
            if (!bl) continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    static {
        block26: {
            block25: {
                var5 = new String[81];
                var3_1 = 0;
                var2_2 = "\u00da\f\u00f5\u0082\u00c6\u0086\u0085\u0081\u00f3\u0080\u001f\u00ca\u0006\u00a0\u0098k\u00c9!\u00b6f~\u00ceQ\u0006\\\u00d3\u00db\u00cfx\u00dc\u00c1@b\u0010\u00e4h\u0006\u00c3W1E\u00f6\u00d6r\u0083\u001e\u0018x\u00d0\u0084\u00d0\u0007)<-\u0088\u0087y\u00de\u001b\u00d1e\u0092\u00ae\u00cc\n\u00efR\u00ad\u00ff\u00b6\u00da\u0018\u0080Y\b\u0083k\u00ea\u00a3\u00ca=\u00f6l\u00ba^\f\u00120\u00e3f\u0000lU\u00072\u00f1J~\u00beI\u0012\u00f3o\u00e6\u0017,-\u00f3\u00ff\u00f4\u00b4\u00cc\u00ec\u00eeM\u0087#\u00bb6\r\u00b1ql\u00a4\u00c6\u00c6\u00a2\u00af\u0084\u00af\u001a\u00be\u0011\u00adUe\u00f0&U\u0096\u00d0\u00a5\u00ca\u00ee\u00d3\u0096(\u00a8r\u00c5\u001dx\u00a7!\u00f3\u000b\u001f\u00f5\u00da\"\u00b8\u001a\u00b4Ye#\u00d0\u00d6\u00b6\u0002n\u00d1+S\u00bc\u0000s\u00d2k\u00d7 \u0087\u00e9X?\u00958\u00c4\u0014\u00c7<\u0007\u00ceo\u0085\u009d\u00808\u0006\u00a1\u00ac1h\u0002\u00b0\u00c1wu\u00ffP.\u00d1,[\u00b1\u0080'\u009fZ%\u001b\u009f\u00c6M\u0098\u00e7\u00f8\t\u009c\u009a\u00d6\u00ce\u0018a\u00f8\u008dO\u00cd\u00f8\u0012\u009d\u00b9t&|\u00aa\u000e\u001fK\u00ad1\u008b,\u00e0S\u00f4y\u00c7\u008d\u00f4`\u00ea\u00de\u00ef\u00ee\u00b7\u00b3n;W\u00c0\u00bb\u00f2<\u00a1.\fN\u001d\u00b6\u00c6\u0014\u00e4dJq\u00dbV\u00d0I\u00fc\u00b3qS.\u00d5p\u00cbS\u00b6[\u00d5!i=\u000e\u0001\u00e6\u0019\u00d2\u0002\u0017\u0011]\u00ffX\u00fc\u00adJ\u00e2\u0005\u008a\u001b,\u00af\b\u0005\u00f4>\u00073\u00a4\u001f#K\u00e8\u00b3#\u000f\u00c5\u008f\u00b0\u00bcqD\rd\u00fb\u001e\u00caD\n!\u00a6A\u00e6U\u00fc.3\u009a\u008f6\u00a2\f\u001e\u00cf}Q\u00e0\u00b3\u00c8\u0080\u00bc\u00c6\u009f\u00d6\bX\u009c\u009a\u009e\u00c5\u00b3\u009dV\u0003\u0002\u00a0<1\u00c7\u00dc\u00bc\u00a3\u00d5\u009f\u00cdw\u00e4\r\u0017\u0004\u00a7\u00b8:\u00df\u00f4O{s\"\u00b8m\u00a9\u00d92\u00e8\u00d8\u009f\u00c2\u008c\u00caW'\u00dc\\\u00a3\u0099w\u0007(~d\u0003\u00dfP\u0080\u00d5\u000f\u0003\u00d1wF(H\u0017\u0018m\u00bd{\u00e7TE+`\u00d2\u0012\u0005\u00da\u00f9o)\u0007ZR\u00d1rOLY^\u00b5\u0082~\u00d7q\u00b1\u00baf!sbj\u0086#\u00a5\u00e2\u00e1\u009a9\u00cc\u00db\u00c8\u00e3\u00ad\u008b\u00f9\u00ca\u00af\u0096\u00f5\u0013\u00bd\u00bb;\u00e56\u00ffv\u009e\u00148b\u009f]\u00df\u00c1\u001f\u00ea\u00fc\u0018$\u0085:\u0018\b\u009a\u00d5\u00a5\u001fb\u00f12\u008c\u00b1o\u0012:\u00d9\u0005D\u00c5F\u00ea3\u0003\u00df\u008f\u00a7\u001a\u00ff?o\u0019\u00aco<s\u00d0\u00cf\u00bdV\u001a\u00b0^\u00e1\u0089uJs4z\u00a5\u000b\u00c8\u00c1-\"*\u00fe\u009e\u00f7\u00f2\u0081Jo\u000bA6\u00a4v\u0097\u0014\u00b6\u00dbt\u00aeb\u0098\u00a9M\u008fF\u00a4\u009c\r\u009c\u00b0\u00039\u0011\u00b3'\u00a1\u0083Z\u0090\u0013\u0086oI\u00ad\t\r\u00a90\u00c0f>eY\u00fb\t\u0092w\u00c2\u0010\u0019N\u008aW\u0006Tb\u00d6\u00d3\u00b24\u000b\u0098\u0096,\u0001a\u00f7\u00df\u00a9D\u00172\u00b9\u0091\u0088v\u0019\u008f\u0097\u00e3\u00b0\u00adi\"\b\u0082f%\u00e1E\u00af\u00b2\u00b7,\u0084_\u008e\u001c\u0082S.\u00c6\u009c\u0088\u00fe\u00b2\u00f3\u0082\u00b5\u00e2S\u00ad\u01cf\u0093\u00e1_\u0095y9\u00b3X\u0013\u00c9^\u00df\u001d\u00061\u00b1\u0099\u0083B-\u0087\u0094\u00f3\u00d8\u01f5\r \u00cf\u0010u\u00d8\u0090b\u00b3\"~\t\u00a8\u00f26\u00a4\u0092\u009d\u001f\u00a5R\u00d8\u00e8\u00e0=d\u00e2\u008c)\u00cd\u00c1\u0083\u0089k\u001b\u00d9\u00fa\u0093]\u00ect\u00eb\u009d-\u0006\u00a6\u00e5\u001ag\u0019\u00f4\u008b\u00f4\u00ebP\u00eaC\u00f2\u00a3:\u00a7\u001c\u001a\u00a0w\u008b\u0086?\u008d\u00f9F\u0000\u001b\u00e4\u00b4o\u00c1R\u001a\u00f0\u0018\u00c9\u00bc}\u009f\u00eeG\u00cf\u00aa!\u0086\"xF\u0091\u0017D\u00f1\u00d8\u008b\u0018T\u00cdQ\u00e32\u00d4,\u0000K\u0097 ]\u00d4\u00d56\u00e3\u0096\u0014iQ\u00a6\u00e0\u001d\u00bdh\u0099\n\u001c \u0017=~D\u0091+(\u0096\r\u00ae\u0013y\u00ba\u0097\u00c6\u0014\u00b1[\\\u008fY\u00f4\u00a64\u00eb\u00c7\u00c3\u009c+1&\u00d9p\u00e1\u0007\u00ccV\r\u00b8\u00c8\u00e2}Y\u00af5\u00bb\u009e]\u00d4\u0019\u00ac\u00f9\rB\u0095^X\u00b4\u00b93\u0007\u00c9\u00f6\u009f\u00b2\u00f6\u008b\u00fa\u00e8\u00de|\u0096\u009e,\u0002\u0106\u000e[\u00ecR\u0093k?<XZ\u00f8H\u00b9\u00dc`\"\u0082\u009a\u00c0\u00adY\u00f9\u0082\u00a1\u0007\u00f8Pa\\fX\u001b\u007f\u0007{\u00f9\u000f,\u00121\u00baj8\u00d3\u00db\u00a0\u00cf\u00e4\u00fb\u00d4\u001a\u0002G\u00e8\u00ea\u0083\u0082\u0006C\u0090\u00dd\u0011\u009e\u00ec\b\u00c7\u0019PI\u0090\u00e7\u0085\u00b5\u001f}\u0087|\n\u00f8\u008d\u00aa\u00bc\u00c3\u00f7<\u0083\u0085y4 \u00d1\u00b0\u00a8\u00ad~G\u00dc\u00b8B\u0010\u00ec_\u008eRC}\u00eb\u0001*{\u00ba\u0089\u0087Gv\u00f6\u00daI?\u00fa\u0012\u0093\u00fdZ\u00ff\u0091h\u00c9\u0018f\u009dG{\u000b\u00f8\u00d2\u0096\u00b6\u0089P\u00f3,5\u00d6\u0094\u00ae->\u00cdRN\u009a\u008c\u00c2\u008f\u00bekU\u0000*\u0086:\u00a1\u00c5\u00ef\u00d4b-\u00d3\u0093bL\u00d7LQo\u00d9\u00b6j\u0014I$)\u00c9X$H<\u00b5v\u00dce)6\u00b2\u00f6\u00ec\u00b46$\\\u0013\u00bb\u00d8\u001d\u00b0\u001b\u00d6\u00fe\u00b2UGh(\u00b5\u0092\u00cf\u0081\u0087\u00f6\u00b3\u00ad,zf\rgZ\u001f\u00c8\u00beRC;\u00cf\u0014\u00b8W\u00f4\u00ab~\u00c7Uo\u009aW9A\u0095\u00b2%f\u001e\u00a6hf\u0097[\u00c2.\u0000YZ\u00a1\u0000fz\u00bb\u009f-y\u00ee}\u00a7\u00d8$A\u000ec\u0093\u0016\u0005\u0012\u00fa\u00c8\u0014K\u00f8\u001e\u00cf\u0099sx<u\u00f0~DE\u00c3\u00fa\u0002(\u0090_\u0098\u0007\u0086T\u0083\u00d6\u0014\u00e3u\u0011\u00ca\u00ba\u00ca\u00a9lM\u00dd\u009bv[\u0087\u0010-\u0013\u00bd\u00a1xH\"\n\u00b3\u00a5\u00a1GcWQX\u008f\u00c8X\u00aa\u00d8iL\u00ca\u000f\u00ef\u00a5\u0092\u00b9<\u00bd\n\u00cf:\u00e1\u008b\u00e8z_\u00a4\u009b\u0007\u00b9\u00a2`+^\u00d9\u0096\u00e2\u00e0\u009a0\u00ec\u00f3\u00c1\u00f2,9BK;\u0097\u0081`q\u0095\u0080t\u00dd\u00ba\u00dc\u00f4\u0012\u00c0\u00e5G\u00de#\u00f4\u00e8\u00cb\u00db|\u00e4s\u00cd\u00f6\r)\u00ed\u009e-\u001c\u00a5B\u00b7\u0091z\u00a0\u001eWs\u008b\u00b4\u009av\u00cb\u00dfU\u0091N\u00e0\u00d6-\u00d4\f Z,j\u00faY\u0000i\u00acz\u0019\u00fe+$K\u00dd\u00cbn\u0095\u0080WNP&_\u0090r\u001d_3\u00c4\u0017\f\u00e7V\u009b\u00a4\u0093\u00cc\u00e6\u0094E\u00d2\u0014\u00c8[)g\u009e\u00d6/\u008br\u00c4\u0005\u00858v\u00a4\u00a1cC\u00e5J2\u00a0\u00ba\u0005\u00d8\u001e\u00cd\u0093\u0082\u00d7\u00ee\u00ba\u0093\u00bc\u0087\u0014K\u00c7\u00f4:9\u00bc4\u00d58\u00faT\u00fd\u00c9@\u008d\u00d2\u00b8\u0092\u00a5\u00f9_\u0002\u008f\u00b50\u0010\u009b~\u0089\u008a\u00d0\u0093I\u0089=\u001a\u00e0\u0081\u008c\u00ce\u00d0\u0095\u00b3,!$\u0083+\u00dd\u001f\u00a6\u0014\u0096\u00cb\u00a9\u00a4H\u0080*T9*\r%\u0004\u0094F)W\u00d9\u00bb\u00a1\u00c5\u00812\u00c1-\u00acd\u0084\u0003.\u00b6\u0095\u00ed%\n\u0085!\u00be\u0010M[\u00c1qw\u00f1\u001d\u00bd\u00fe\u00fc\\\u00f9\u00e6\u00acR\u00fd\\\u00fb$\u0013\u00e6\u00c88CK\t:4,\u00d8^\u0018\u0002\u00b8L\u009a\u00f4\u00edu\u00c3\u00c0\u000b\u009b!9=k;#\t\u008c?\u00d2~\u00f7\u00883\u00ed\u008a\u00ac\u00de+\r5\u009a;\u00ed\u0013\u00ca\u00a2\u00b5\u00b9\u00a7\u0090\u009e\u007f\u0000\u0016\u00f7\u00fd-[r\u0098\u0019\u00ac\u001e'f\" \bvh\u0011cW&M\u0087yl\u008f\u00c7\u00cc\u009e`\u0082?\u0088%]\u00c1g\u00b7\u00a4\u00c2m\u0004%X\u001c\u009ae5C1i\u0080\u00dau\u0088\u00ba\u00d7\u00f6$L\u00df\u00f5l\u0086.\u00be\u00d1Tg\u00c2e]\u00b2g\u00d46\u008bS\u00ca\u00ef\u00ac\u00delz\u001d\u00f8\u00fd\u0099?\u00fb\u0094\u00fa\u00f5\u00a1\t$?\u00cb\u0001'\u00d4\u001br\u00d1m=\u00cet5]\u009d\u008d\nv\u00e4m\u00e3B\"\u00ff\u009c\u0083\u00cb\u00c7##\u00cb\u00f1\u001b\u00e5\u0018J\u0003\u00cbM/\u0014D\u00dd\u00b8\u00b7\u00ac\u00cci\u00c8\u00ba\u00ac\u001c\u0088\u001b\u00d7\u00c0\u0095\u00ef\u00c5t\u009a\u0015\u000e\u009e{\u0091L\u008e\u0081\u00a1\u00ca\u009f\u00c9\u0002R\u00b7B!\u00f6t\u00d9F\u00a4.&\u00c5\u009e2\u0098\u0014i\u00f5\u00fd\u00e9H\u0085\u00cd%N\u001d\u001eV\u00af|q\u00b4L9\u00bbA\u0013\u00a9\u0081\u001aq\u00e5){\u00f3\u0018\u00aeY_`\u00b9v@\u001eRI \u00ac\u00c4=\u009a9\u008cQ\u0082u\u00eeQ\u0094\u00a5\u00ce\u00c4\u00e9\u0013+\u00c4\t\u009d\u00dc\u0097&s\u00a5#\u00a5\u009ae\u0088E\u0003\u00e6\u00cc\u008aL\u0084\u00de\u00d0\u00a3\u00be\u0005_&]7,@VB2\u0085U\u0092\u0087\u00a9\u0087\u00af\u00a1\u009f1\u00bf\u001b\u007f\u00d5\u00e9\u000e\u00c5\u008d\u00c6?g9\u0002\u0004X.J\u00fe\u00bdj\u00fcP\u0007\u00ccC\u00f6\u009f\u00a9z\u0017\u00c0\r\u00d3\t\u00cf\u00f2\u00a4\u00d7,\u00c7\u00d6\u007f\u00aeAx\u00f6!\u00b8<\u00caO\"(R\u0094\u00bf\u00f2\u00d1\u00f7\u00a4\u00a9X\u0085u\u00e6\u00e4\u000fK\u0095\r&\u00b8\u00a4\u0004g4\u0014\u00ca\u00ed\u00c7a\"\u0098\u00b4\u0011\u00de\u0005\u0080\u00b0\u0097UD[Y\u00f4:\u0011\u00f9\u00f4o\u00a5H\nI\u000f\u00c2\u0014\u00db9>\u00ba\u0005\u00ef[\\;\u00f7vULQN;;\t\u00e6kV#\u0092ZX\u00da\u00dd\u00b3\u00a8/\u00b7\u00e9'I6\u009b\u00f39\u0010\u00bfOmN\u00fc#\u00d4\u009b3K\u00ed\u00f5\u00c2\u00db\u009aG\u00b5>KU\u0011\u0001\u00a1\u00c6\u00ae6\u00f0\u00c6\u00a1mE\u00f0g/\u00ef\u00af.\u00ec\u001a\u00f6nww\u00a2\u00a1\u00c6\u0080\u008eg\u0006/\n?\u00db\u01ca\u0017\nU\u00de\u009c\u00e2\u00a3\u0096w\u00fc\u001b\nZ\u00f5\u00bb\u00bc?\u00cb\u00b4F\r3\u0004z\u00b6\u00c8\u00cb\u00c5\u00d5\u00b9\u0000r\u00f3d<\u00c3\u00e1t-\u00de\u00fb\u0081\u00f5{\u00ec\u0015\u00ear\n\u00b9\u00fe\u00f8\u00b7\u008a\u0001\u00caK\u00f6\u00c5\u00e8}8M\u00a0\u00d4\u00bdt?E\u0091n\u00ec3\u00e7\u0011,x\u000fD\u00b3\u00f2\u0001\u008ez\u001a\u00831\u00d9\u009cw\u00dc|/\u00d9\u0092\u00ec\u0091W\u00e8p\u0130bU\u00fb5I\u009f\u00199 \t8%\u0093\u00e4\n80\u008f\u0080G\u00e3o\u00da>\u0011?\u00ef\u00f4\u00df\u00b3\u0000\u0001\u009aq9+kX\u00e5\u00bd\u00ba\u0003\u00af,\u008b\u000b\u00ce\u00bf7\u00d4\u00fe4\u009e\u00bd'\u0002\u00af]mm\u000e\u00c26/O\u00c7f \u0012\u00e1\u00d3\u00c9\u001a\u001f\u00ea}\nc\u00f1\u0012h\b\u00de\u00d6\u00be\u00b4c\u00c4|\u00c8G\u0080R\u00d4\u001f\u0083g\u00be@\u00b6\u0004\u00913\u0002\u00fe\u0018I;%\u00ea\u00d9\u00e3\u00d0\u0002t3\r&\u00eb\u00dd1'h\u008a\u00e5O\u00ffpRI\u001a(?\u00ad\u00e5+c\u0013\u007f2ZEnf\u0016\u0096\u00daz1\u00d5\u00e8-T\nA%\u00fb \u0087\u008daDL\u00ae KS\u00a5\u00da\u00ca\r\u0013r\u00b5+\u00d8\u00d1I*y\u008d\u00b6\u000b\u00124[\u0002\u00a5\u00ec\u00d5,\u001e\u001el\u00d5+\u00d6`'(\u0015\u0082\r\u00c8\u00de\u00d7\u0084Tq\u00dek(\u00efT\u00c3\u0092\u00d7\u00ca\u0098\u00de\u00fa\t\u00b1\u00ea\u00e7\u00ad\u007f\u0082\u00be\u00f0\u0083'\u0083\u0092!-n\u00f4\u00dc\u0011%\u00f4\u00f4\u00a5\t\u0003\u0000\u0000\u000e4[\u00df\u0003\u00e1/\u00e3\u0016\u00ff\u009f\u00b4p\u00f0c\u008d\u00e2\u00d9J\u007f\u00e6\u0083\u00be\u00da3\u0001*A\u0016=\u00a9\u00f9\u00ee\b\u00a4\u009b\u00d53\u00b3\u00c9+q\u001e`{\u00b6-\u00f5\u0019\u00b6S?\u00d8\f\u00d5\u00f5\u00e1!\u00ca\u00ed9\u001d\u00e4`y)\u00bd\u0080\u001c\u00edy\u00b5\u0005";
                var4_3 = "\u00da\f\u00f5\u0082\u00c6\u0086\u0085\u0081\u00f3\u0080\u001f\u00ca\u0006\u00a0\u0098k\u00c9!\u00b6f~\u00ceQ\u0006\\\u00d3\u00db\u00cfx\u00dc\u00c1@b\u0010\u00e4h\u0006\u00c3W1E\u00f6\u00d6r\u0083\u001e\u0018x\u00d0\u0084\u00d0\u0007)<-\u0088\u0087y\u00de\u001b\u00d1e\u0092\u00ae\u00cc\n\u00efR\u00ad\u00ff\u00b6\u00da\u0018\u0080Y\b\u0083k\u00ea\u00a3\u00ca=\u00f6l\u00ba^\f\u00120\u00e3f\u0000lU\u00072\u00f1J~\u00beI\u0012\u00f3o\u00e6\u0017,-\u00f3\u00ff\u00f4\u00b4\u00cc\u00ec\u00eeM\u0087#\u00bb6\r\u00b1ql\u00a4\u00c6\u00c6\u00a2\u00af\u0084\u00af\u001a\u00be\u0011\u00adUe\u00f0&U\u0096\u00d0\u00a5\u00ca\u00ee\u00d3\u0096(\u00a8r\u00c5\u001dx\u00a7!\u00f3\u000b\u001f\u00f5\u00da\"\u00b8\u001a\u00b4Ye#\u00d0\u00d6\u00b6\u0002n\u00d1+S\u00bc\u0000s\u00d2k\u00d7 \u0087\u00e9X?\u00958\u00c4\u0014\u00c7<\u0007\u00ceo\u0085\u009d\u00808\u0006\u00a1\u00ac1h\u0002\u00b0\u00c1wu\u00ffP.\u00d1,[\u00b1\u0080'\u009fZ%\u001b\u009f\u00c6M\u0098\u00e7\u00f8\t\u009c\u009a\u00d6\u00ce\u0018a\u00f8\u008dO\u00cd\u00f8\u0012\u009d\u00b9t&|\u00aa\u000e\u001fK\u00ad1\u008b,\u00e0S\u00f4y\u00c7\u008d\u00f4`\u00ea\u00de\u00ef\u00ee\u00b7\u00b3n;W\u00c0\u00bb\u00f2<\u00a1.\fN\u001d\u00b6\u00c6\u0014\u00e4dJq\u00dbV\u00d0I\u00fc\u00b3qS.\u00d5p\u00cbS\u00b6[\u00d5!i=\u000e\u0001\u00e6\u0019\u00d2\u0002\u0017\u0011]\u00ffX\u00fc\u00adJ\u00e2\u0005\u008a\u001b,\u00af\b\u0005\u00f4>\u00073\u00a4\u001f#K\u00e8\u00b3#\u000f\u00c5\u008f\u00b0\u00bcqD\rd\u00fb\u001e\u00caD\n!\u00a6A\u00e6U\u00fc.3\u009a\u008f6\u00a2\f\u001e\u00cf}Q\u00e0\u00b3\u00c8\u0080\u00bc\u00c6\u009f\u00d6\bX\u009c\u009a\u009e\u00c5\u00b3\u009dV\u0003\u0002\u00a0<1\u00c7\u00dc\u00bc\u00a3\u00d5\u009f\u00cdw\u00e4\r\u0017\u0004\u00a7\u00b8:\u00df\u00f4O{s\"\u00b8m\u00a9\u00d92\u00e8\u00d8\u009f\u00c2\u008c\u00caW'\u00dc\\\u00a3\u0099w\u0007(~d\u0003\u00dfP\u0080\u00d5\u000f\u0003\u00d1wF(H\u0017\u0018m\u00bd{\u00e7TE+`\u00d2\u0012\u0005\u00da\u00f9o)\u0007ZR\u00d1rOLY^\u00b5\u0082~\u00d7q\u00b1\u00baf!sbj\u0086#\u00a5\u00e2\u00e1\u009a9\u00cc\u00db\u00c8\u00e3\u00ad\u008b\u00f9\u00ca\u00af\u0096\u00f5\u0013\u00bd\u00bb;\u00e56\u00ffv\u009e\u00148b\u009f]\u00df\u00c1\u001f\u00ea\u00fc\u0018$\u0085:\u0018\b\u009a\u00d5\u00a5\u001fb\u00f12\u008c\u00b1o\u0012:\u00d9\u0005D\u00c5F\u00ea3\u0003\u00df\u008f\u00a7\u001a\u00ff?o\u0019\u00aco<s\u00d0\u00cf\u00bdV\u001a\u00b0^\u00e1\u0089uJs4z\u00a5\u000b\u00c8\u00c1-\"*\u00fe\u009e\u00f7\u00f2\u0081Jo\u000bA6\u00a4v\u0097\u0014\u00b6\u00dbt\u00aeb\u0098\u00a9M\u008fF\u00a4\u009c\r\u009c\u00b0\u00039\u0011\u00b3'\u00a1\u0083Z\u0090\u0013\u0086oI\u00ad\t\r\u00a90\u00c0f>eY\u00fb\t\u0092w\u00c2\u0010\u0019N\u008aW\u0006Tb\u00d6\u00d3\u00b24\u000b\u0098\u0096,\u0001a\u00f7\u00df\u00a9D\u00172\u00b9\u0091\u0088v\u0019\u008f\u0097\u00e3\u00b0\u00adi\"\b\u0082f%\u00e1E\u00af\u00b2\u00b7,\u0084_\u008e\u001c\u0082S.\u00c6\u009c\u0088\u00fe\u00b2\u00f3\u0082\u00b5\u00e2S\u00ad\u01cf\u0093\u00e1_\u0095y9\u00b3X\u0013\u00c9^\u00df\u001d\u00061\u00b1\u0099\u0083B-\u0087\u0094\u00f3\u00d8\u01f5\r \u00cf\u0010u\u00d8\u0090b\u00b3\"~\t\u00a8\u00f26\u00a4\u0092\u009d\u001f\u00a5R\u00d8\u00e8\u00e0=d\u00e2\u008c)\u00cd\u00c1\u0083\u0089k\u001b\u00d9\u00fa\u0093]\u00ect\u00eb\u009d-\u0006\u00a6\u00e5\u001ag\u0019\u00f4\u008b\u00f4\u00ebP\u00eaC\u00f2\u00a3:\u00a7\u001c\u001a\u00a0w\u008b\u0086?\u008d\u00f9F\u0000\u001b\u00e4\u00b4o\u00c1R\u001a\u00f0\u0018\u00c9\u00bc}\u009f\u00eeG\u00cf\u00aa!\u0086\"xF\u0091\u0017D\u00f1\u00d8\u008b\u0018T\u00cdQ\u00e32\u00d4,\u0000K\u0097 ]\u00d4\u00d56\u00e3\u0096\u0014iQ\u00a6\u00e0\u001d\u00bdh\u0099\n\u001c \u0017=~D\u0091+(\u0096\r\u00ae\u0013y\u00ba\u0097\u00c6\u0014\u00b1[\\\u008fY\u00f4\u00a64\u00eb\u00c7\u00c3\u009c+1&\u00d9p\u00e1\u0007\u00ccV\r\u00b8\u00c8\u00e2}Y\u00af5\u00bb\u009e]\u00d4\u0019\u00ac\u00f9\rB\u0095^X\u00b4\u00b93\u0007\u00c9\u00f6\u009f\u00b2\u00f6\u008b\u00fa\u00e8\u00de|\u0096\u009e,\u0002\u0106\u000e[\u00ecR\u0093k?<XZ\u00f8H\u00b9\u00dc`\"\u0082\u009a\u00c0\u00adY\u00f9\u0082\u00a1\u0007\u00f8Pa\\fX\u001b\u007f\u0007{\u00f9\u000f,\u00121\u00baj8\u00d3\u00db\u00a0\u00cf\u00e4\u00fb\u00d4\u001a\u0002G\u00e8\u00ea\u0083\u0082\u0006C\u0090\u00dd\u0011\u009e\u00ec\b\u00c7\u0019PI\u0090\u00e7\u0085\u00b5\u001f}\u0087|\n\u00f8\u008d\u00aa\u00bc\u00c3\u00f7<\u0083\u0085y4 \u00d1\u00b0\u00a8\u00ad~G\u00dc\u00b8B\u0010\u00ec_\u008eRC}\u00eb\u0001*{\u00ba\u0089\u0087Gv\u00f6\u00daI?\u00fa\u0012\u0093\u00fdZ\u00ff\u0091h\u00c9\u0018f\u009dG{\u000b\u00f8\u00d2\u0096\u00b6\u0089P\u00f3,5\u00d6\u0094\u00ae->\u00cdRN\u009a\u008c\u00c2\u008f\u00bekU\u0000*\u0086:\u00a1\u00c5\u00ef\u00d4b-\u00d3\u0093bL\u00d7LQo\u00d9\u00b6j\u0014I$)\u00c9X$H<\u00b5v\u00dce)6\u00b2\u00f6\u00ec\u00b46$\\\u0013\u00bb\u00d8\u001d\u00b0\u001b\u00d6\u00fe\u00b2UGh(\u00b5\u0092\u00cf\u0081\u0087\u00f6\u00b3\u00ad,zf\rgZ\u001f\u00c8\u00beRC;\u00cf\u0014\u00b8W\u00f4\u00ab~\u00c7Uo\u009aW9A\u0095\u00b2%f\u001e\u00a6hf\u0097[\u00c2.\u0000YZ\u00a1\u0000fz\u00bb\u009f-y\u00ee}\u00a7\u00d8$A\u000ec\u0093\u0016\u0005\u0012\u00fa\u00c8\u0014K\u00f8\u001e\u00cf\u0099sx<u\u00f0~DE\u00c3\u00fa\u0002(\u0090_\u0098\u0007\u0086T\u0083\u00d6\u0014\u00e3u\u0011\u00ca\u00ba\u00ca\u00a9lM\u00dd\u009bv[\u0087\u0010-\u0013\u00bd\u00a1xH\"\n\u00b3\u00a5\u00a1GcWQX\u008f\u00c8X\u00aa\u00d8iL\u00ca\u000f\u00ef\u00a5\u0092\u00b9<\u00bd\n\u00cf:\u00e1\u008b\u00e8z_\u00a4\u009b\u0007\u00b9\u00a2`+^\u00d9\u0096\u00e2\u00e0\u009a0\u00ec\u00f3\u00c1\u00f2,9BK;\u0097\u0081`q\u0095\u0080t\u00dd\u00ba\u00dc\u00f4\u0012\u00c0\u00e5G\u00de#\u00f4\u00e8\u00cb\u00db|\u00e4s\u00cd\u00f6\r)\u00ed\u009e-\u001c\u00a5B\u00b7\u0091z\u00a0\u001eWs\u008b\u00b4\u009av\u00cb\u00dfU\u0091N\u00e0\u00d6-\u00d4\f Z,j\u00faY\u0000i\u00acz\u0019\u00fe+$K\u00dd\u00cbn\u0095\u0080WNP&_\u0090r\u001d_3\u00c4\u0017\f\u00e7V\u009b\u00a4\u0093\u00cc\u00e6\u0094E\u00d2\u0014\u00c8[)g\u009e\u00d6/\u008br\u00c4\u0005\u00858v\u00a4\u00a1cC\u00e5J2\u00a0\u00ba\u0005\u00d8\u001e\u00cd\u0093\u0082\u00d7\u00ee\u00ba\u0093\u00bc\u0087\u0014K\u00c7\u00f4:9\u00bc4\u00d58\u00faT\u00fd\u00c9@\u008d\u00d2\u00b8\u0092\u00a5\u00f9_\u0002\u008f\u00b50\u0010\u009b~\u0089\u008a\u00d0\u0093I\u0089=\u001a\u00e0\u0081\u008c\u00ce\u00d0\u0095\u00b3,!$\u0083+\u00dd\u001f\u00a6\u0014\u0096\u00cb\u00a9\u00a4H\u0080*T9*\r%\u0004\u0094F)W\u00d9\u00bb\u00a1\u00c5\u00812\u00c1-\u00acd\u0084\u0003.\u00b6\u0095\u00ed%\n\u0085!\u00be\u0010M[\u00c1qw\u00f1\u001d\u00bd\u00fe\u00fc\\\u00f9\u00e6\u00acR\u00fd\\\u00fb$\u0013\u00e6\u00c88CK\t:4,\u00d8^\u0018\u0002\u00b8L\u009a\u00f4\u00edu\u00c3\u00c0\u000b\u009b!9=k;#\t\u008c?\u00d2~\u00f7\u00883\u00ed\u008a\u00ac\u00de+\r5\u009a;\u00ed\u0013\u00ca\u00a2\u00b5\u00b9\u00a7\u0090\u009e\u007f\u0000\u0016\u00f7\u00fd-[r\u0098\u0019\u00ac\u001e'f\" \bvh\u0011cW&M\u0087yl\u008f\u00c7\u00cc\u009e`\u0082?\u0088%]\u00c1g\u00b7\u00a4\u00c2m\u0004%X\u001c\u009ae5C1i\u0080\u00dau\u0088\u00ba\u00d7\u00f6$L\u00df\u00f5l\u0086.\u00be\u00d1Tg\u00c2e]\u00b2g\u00d46\u008bS\u00ca\u00ef\u00ac\u00delz\u001d\u00f8\u00fd\u0099?\u00fb\u0094\u00fa\u00f5\u00a1\t$?\u00cb\u0001'\u00d4\u001br\u00d1m=\u00cet5]\u009d\u008d\nv\u00e4m\u00e3B\"\u00ff\u009c\u0083\u00cb\u00c7##\u00cb\u00f1\u001b\u00e5\u0018J\u0003\u00cbM/\u0014D\u00dd\u00b8\u00b7\u00ac\u00cci\u00c8\u00ba\u00ac\u001c\u0088\u001b\u00d7\u00c0\u0095\u00ef\u00c5t\u009a\u0015\u000e\u009e{\u0091L\u008e\u0081\u00a1\u00ca\u009f\u00c9\u0002R\u00b7B!\u00f6t\u00d9F\u00a4.&\u00c5\u009e2\u0098\u0014i\u00f5\u00fd\u00e9H\u0085\u00cd%N\u001d\u001eV\u00af|q\u00b4L9\u00bbA\u0013\u00a9\u0081\u001aq\u00e5){\u00f3\u0018\u00aeY_`\u00b9v@\u001eRI \u00ac\u00c4=\u009a9\u008cQ\u0082u\u00eeQ\u0094\u00a5\u00ce\u00c4\u00e9\u0013+\u00c4\t\u009d\u00dc\u0097&s\u00a5#\u00a5\u009ae\u0088E\u0003\u00e6\u00cc\u008aL\u0084\u00de\u00d0\u00a3\u00be\u0005_&]7,@VB2\u0085U\u0092\u0087\u00a9\u0087\u00af\u00a1\u009f1\u00bf\u001b\u007f\u00d5\u00e9\u000e\u00c5\u008d\u00c6?g9\u0002\u0004X.J\u00fe\u00bdj\u00fcP\u0007\u00ccC\u00f6\u009f\u00a9z\u0017\u00c0\r\u00d3\t\u00cf\u00f2\u00a4\u00d7,\u00c7\u00d6\u007f\u00aeAx\u00f6!\u00b8<\u00caO\"(R\u0094\u00bf\u00f2\u00d1\u00f7\u00a4\u00a9X\u0085u\u00e6\u00e4\u000fK\u0095\r&\u00b8\u00a4\u0004g4\u0014\u00ca\u00ed\u00c7a\"\u0098\u00b4\u0011\u00de\u0005\u0080\u00b0\u0097UD[Y\u00f4:\u0011\u00f9\u00f4o\u00a5H\nI\u000f\u00c2\u0014\u00db9>\u00ba\u0005\u00ef[\\;\u00f7vULQN;;\t\u00e6kV#\u0092ZX\u00da\u00dd\u00b3\u00a8/\u00b7\u00e9'I6\u009b\u00f39\u0010\u00bfOmN\u00fc#\u00d4\u009b3K\u00ed\u00f5\u00c2\u00db\u009aG\u00b5>KU\u0011\u0001\u00a1\u00c6\u00ae6\u00f0\u00c6\u00a1mE\u00f0g/\u00ef\u00af.\u00ec\u001a\u00f6nww\u00a2\u00a1\u00c6\u0080\u008eg\u0006/\n?\u00db\u01ca\u0017\nU\u00de\u009c\u00e2\u00a3\u0096w\u00fc\u001b\nZ\u00f5\u00bb\u00bc?\u00cb\u00b4F\r3\u0004z\u00b6\u00c8\u00cb\u00c5\u00d5\u00b9\u0000r\u00f3d<\u00c3\u00e1t-\u00de\u00fb\u0081\u00f5{\u00ec\u0015\u00ear\n\u00b9\u00fe\u00f8\u00b7\u008a\u0001\u00caK\u00f6\u00c5\u00e8}8M\u00a0\u00d4\u00bdt?E\u0091n\u00ec3\u00e7\u0011,x\u000fD\u00b3\u00f2\u0001\u008ez\u001a\u00831\u00d9\u009cw\u00dc|/\u00d9\u0092\u00ec\u0091W\u00e8p\u0130bU\u00fb5I\u009f\u00199 \t8%\u0093\u00e4\n80\u008f\u0080G\u00e3o\u00da>\u0011?\u00ef\u00f4\u00df\u00b3\u0000\u0001\u009aq9+kX\u00e5\u00bd\u00ba\u0003\u00af,\u008b\u000b\u00ce\u00bf7\u00d4\u00fe4\u009e\u00bd'\u0002\u00af]mm\u000e\u00c26/O\u00c7f \u0012\u00e1\u00d3\u00c9\u001a\u001f\u00ea}\nc\u00f1\u0012h\b\u00de\u00d6\u00be\u00b4c\u00c4|\u00c8G\u0080R\u00d4\u001f\u0083g\u00be@\u00b6\u0004\u00913\u0002\u00fe\u0018I;%\u00ea\u00d9\u00e3\u00d0\u0002t3\r&\u00eb\u00dd1'h\u008a\u00e5O\u00ffpRI\u001a(?\u00ad\u00e5+c\u0013\u007f2ZEnf\u0016\u0096\u00daz1\u00d5\u00e8-T\nA%\u00fb \u0087\u008daDL\u00ae KS\u00a5\u00da\u00ca\r\u0013r\u00b5+\u00d8\u00d1I*y\u008d\u00b6\u000b\u00124[\u0002\u00a5\u00ec\u00d5,\u001e\u001el\u00d5+\u00d6`'(\u0015\u0082\r\u00c8\u00de\u00d7\u0084Tq\u00dek(\u00efT\u00c3\u0092\u00d7\u00ca\u0098\u00de\u00fa\t\u00b1\u00ea\u00e7\u00ad\u007f\u0082\u00be\u00f0\u0083'\u0083\u0092!-n\u00f4\u00dc\u0011%\u00f4\u00f4\u00a5\t\u0003\u0000\u0000\u000e4[\u00df\u0003\u00e1/\u00e3\u0016\u00ff\u009f\u00b4p\u00f0c\u008d\u00e2\u00d9J\u007f\u00e6\u0083\u00be\u00da3\u0001*A\u0016=\u00a9\u00f9\u00ee\b\u00a4\u009b\u00d53\u00b3\u00c9+q\u001e`{\u00b6-\u00f5\u0019\u00b6S?\u00d8\f\u00d5\u00f5\u00e1!\u00ca\u00ed9\u001d\u00e4`y)\u00bd\u0080\u001c\u00edy\u00b5\u0005".length();
                var1_4 = 17;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block25;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00d5\u00baO]\u00d3J+\u00f6\u00b8-\u0014\u0003W72H,\u0018\n\u00bd\u0097\u00e7\u00c9Y\u0087k\u00be\u0086\"S\u00ff/b'\u00eb\u001fn\u00a1st=,\u00e4z(\u0095\fz3\u00e4\u008d\u00a1\u00d5\u00c1{\u009e\u00f2\u00af\u00a4\u00b0u\u00d4\u00fda\u00ab";
                    var4_3 = "\u00d5\u00baO]\u00d3J+\u00f6\u00b8-\u0014\u0003W72H,\u0018\n\u00bd\u0097\u00e7\u00c9Y\u0087k\u00be\u0086\"S\u00ff/b'\u00eb\u001fn\u00a1st=,\u00e4z(\u0095\fz3\u00e4\u008d\u00a1\u00d5\u00c1{\u009e\u00f2\u00af\u00a4\u00b0u\u00d4\u00fda\u00ab".length();
                    var1_4 = 14;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block25;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block26;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 29;
                            break;
                        }
                        case 1: {
                            v13 = 27;
                            break;
                        }
                        case 2: {
                            v13 = 92;
                            break;
                        }
                        case 3: {
                            v13 = 76;
                            break;
                        }
                        case 4: {
                            v13 = 101;
                            break;
                        }
                        case 5: {
                            v13 = 126;
                            break;
                        }
                        default: {
                            v13 = 115;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        PKCS11Ops.f = var5;
        PKCS11Ops.g = new String[81];
        PKCS11Ops.b = new ArrayList<String>();
        var7_7 = System.getProperty(PKCS11Ops.a(11833, 9436)).toLowerCase();
        if (var7_7.indexOf(PKCS11Ops.a(11794, -8236)) >= 0) {
            var8_8 = System.getenv(PKCS11Ops.a(11828, -28071)) + System.getProperty(PKCS11Ops.a(11825, 23003)) + PKCS11Ops.a(11806, -23332) + System.getProperty(PKCS11Ops.a(11801, 2029));
            PKCS11Ops.b.add(var8_8);
        } else if (var7_7.indexOf(PKCS11Ops.a(11781, -17033)) >= 0) {
            var8_9 = System.getProperty(PKCS11Ops.a(11801, 2029)) + PKCS11Ops.a(11820, 31846) + System.getProperty(PKCS11Ops.a(11801, 2029)) + PKCS11Ops.a(11802, -21191) + System.getProperty(PKCS11Ops.a(11801, 2029)) + PKCS11Ops.a(11777, -9611) + System.getProperty(PKCS11Ops.a(11801, 2029));
            PKCS11Ops.b.add(var8_9);
            var9_11 = System.getProperty(PKCS11Ops.a(11801, 2029)) + PKCS11Ops.a(11815, -3986) + System.getProperty(PKCS11Ops.a(11801, 2029)) + PKCS11Ops.a(11807, -20399) + System.getProperty(PKCS11Ops.a(11801, 2029));
            PKCS11Ops.b.add(var9_11);
            if (!MA3APIEnvironment.SET_MAC_OS_PCSC_PATH) ** GOTO lbl113
            System.setProperty(PKCS11Ops.a(11787, -19755), PKCS11Ops.a(11813, 16011));
        } else {
            var8_10 = System.getProperty(PKCS11Ops.a(11801, 2029)) + PKCS11Ops.a(11807, -20399) + System.getProperty(PKCS11Ops.a(11801, 2029));
            PKCS11Ops.b.add(var8_10);
        }
lbl113:
        // 4 sources

    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0x2E10) & 0xFFFF;
        if (g[n3] == null) {
            int n4;
            int n5;
            char[] cArray = f[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 219;
                    break;
                }
                case 1: {
                    n5 = 8;
                    break;
                }
                case 2: {
                    n5 = 43;
                    break;
                }
                case 3: {
                    n5 = 61;
                    break;
                }
                case 4: {
                    n5 = 24;
                    break;
                }
                case 5: {
                    n5 = 91;
                    break;
                }
                case 6: {
                    n5 = 15;
                    break;
                }
                case 7: {
                    n5 = 170;
                    break;
                }
                case 8: {
                    n5 = 161;
                    break;
                }
                case 9: {
                    n5 = 250;
                    break;
                }
                case 10: {
                    n5 = 235;
                    break;
                }
                case 11: {
                    n5 = 32;
                    break;
                }
                case 12: {
                    n5 = 168;
                    break;
                }
                case 13: {
                    n5 = 179;
                    break;
                }
                case 14: {
                    n5 = 150;
                    break;
                }
                case 15: {
                    n5 = 69;
                    break;
                }
                case 16: {
                    n5 = 233;
                    break;
                }
                case 17: {
                    n5 = 236;
                    break;
                }
                case 18: {
                    n5 = 224;
                    break;
                }
                case 19: {
                    n5 = 82;
                    break;
                }
                case 20: {
                    n5 = 79;
                    break;
                }
                case 21: {
                    n5 = 149;
                    break;
                }
                case 22: {
                    n5 = 165;
                    break;
                }
                case 23: {
                    n5 = 35;
                    break;
                }
                case 24: {
                    n5 = 93;
                    break;
                }
                case 25: {
                    n5 = 51;
                    break;
                }
                case 26: {
                    n5 = 84;
                    break;
                }
                case 27: {
                    n5 = 87;
                    break;
                }
                case 28: {
                    n5 = 115;
                    break;
                }
                case 29: {
                    n5 = 248;
                    break;
                }
                case 30: {
                    n5 = 148;
                    break;
                }
                case 31: {
                    n5 = 222;
                    break;
                }
                case 32: {
                    n5 = 94;
                    break;
                }
                case 33: {
                    n5 = 141;
                    break;
                }
                case 34: {
                    n5 = 182;
                    break;
                }
                case 35: {
                    n5 = 55;
                    break;
                }
                case 36: {
                    n5 = 28;
                    break;
                }
                case 37: {
                    n5 = 190;
                    break;
                }
                case 38: {
                    n5 = 9;
                    break;
                }
                case 39: {
                    n5 = 103;
                    break;
                }
                case 40: {
                    n5 = 246;
                    break;
                }
                case 41: {
                    n5 = 198;
                    break;
                }
                case 42: {
                    n5 = 217;
                    break;
                }
                case 43: {
                    n5 = 102;
                    break;
                }
                case 44: {
                    n5 = 173;
                    break;
                }
                case 45: {
                    n5 = 23;
                    break;
                }
                case 46: {
                    n5 = 21;
                    break;
                }
                case 47: {
                    n5 = 3;
                    break;
                }
                case 48: {
                    n5 = 76;
                    break;
                }
                case 49: {
                    n5 = 111;
                    break;
                }
                case 50: {
                    n5 = 144;
                    break;
                }
                case 51: {
                    n5 = 90;
                    break;
                }
                case 52: {
                    n5 = 145;
                    break;
                }
                case 53: {
                    n5 = 5;
                    break;
                }
                case 54: {
                    n5 = 112;
                    break;
                }
                case 55: {
                    n5 = 108;
                    break;
                }
                case 56: {
                    n5 = 64;
                    break;
                }
                case 57: {
                    n5 = 56;
                    break;
                }
                case 58: {
                    n5 = 74;
                    break;
                }
                case 59: {
                    n5 = 133;
                    break;
                }
                case 60: {
                    n5 = 4;
                    break;
                }
                case 61: {
                    n5 = 95;
                    break;
                }
                case 62: {
                    n5 = 59;
                    break;
                }
                case 63: {
                    n5 = 129;
                    break;
                }
                case 64: {
                    n5 = 40;
                    break;
                }
                case 65: {
                    n5 = 230;
                    break;
                }
                case 66: {
                    n5 = 34;
                    break;
                }
                case 67: {
                    n5 = 185;
                    break;
                }
                case 68: {
                    n5 = 192;
                    break;
                }
                case 69: {
                    n5 = 166;
                    break;
                }
                case 70: {
                    n5 = 187;
                    break;
                }
                case 71: {
                    n5 = 33;
                    break;
                }
                case 72: {
                    n5 = 247;
                    break;
                }
                case 73: {
                    n5 = 36;
                    break;
                }
                case 74: {
                    n5 = 180;
                    break;
                }
                case 75: {
                    n5 = 58;
                    break;
                }
                case 76: {
                    n5 = 139;
                    break;
                }
                case 77: {
                    n5 = 0;
                    break;
                }
                case 78: {
                    n5 = 143;
                    break;
                }
                case 79: {
                    n5 = 171;
                    break;
                }
                case 80: {
                    n5 = 25;
                    break;
                }
                case 81: {
                    n5 = 113;
                    break;
                }
                case 82: {
                    n5 = 174;
                    break;
                }
                case 83: {
                    n5 = 57;
                    break;
                }
                case 84: {
                    n5 = 156;
                    break;
                }
                case 85: {
                    n5 = 105;
                    break;
                }
                case 86: {
                    n5 = 211;
                    break;
                }
                case 87: {
                    n5 = 176;
                    break;
                }
                case 88: {
                    n5 = 83;
                    break;
                }
                case 89: {
                    n5 = 153;
                    break;
                }
                case 90: {
                    n5 = 73;
                    break;
                }
                case 91: {
                    n5 = 160;
                    break;
                }
                case 92: {
                    n5 = 175;
                    break;
                }
                case 93: {
                    n5 = 157;
                    break;
                }
                case 94: {
                    n5 = 167;
                    break;
                }
                case 95: {
                    n5 = 89;
                    break;
                }
                case 96: {
                    n5 = 125;
                    break;
                }
                case 97: {
                    n5 = 207;
                    break;
                }
                case 98: {
                    n5 = 120;
                    break;
                }
                case 99: {
                    n5 = 114;
                    break;
                }
                case 100: {
                    n5 = 37;
                    break;
                }
                case 101: {
                    n5 = 116;
                    break;
                }
                case 102: {
                    n5 = 184;
                    break;
                }
                case 103: {
                    n5 = 118;
                    break;
                }
                case 104: {
                    n5 = 154;
                    break;
                }
                case 105: {
                    n5 = 127;
                    break;
                }
                case 106: {
                    n5 = 172;
                    break;
                }
                case 107: {
                    n5 = 11;
                    break;
                }
                case 108: {
                    n5 = 45;
                    break;
                }
                case 109: {
                    n5 = 231;
                    break;
                }
                case 110: {
                    n5 = 1;
                    break;
                }
                case 111: {
                    n5 = 142;
                    break;
                }
                case 112: {
                    n5 = 30;
                    break;
                }
                case 113: {
                    n5 = 135;
                    break;
                }
                case 114: {
                    n5 = 68;
                    break;
                }
                case 115: {
                    n5 = 229;
                    break;
                }
                case 116: {
                    n5 = 16;
                    break;
                }
                case 117: {
                    n5 = 86;
                    break;
                }
                case 118: {
                    n5 = 117;
                    break;
                }
                case 119: {
                    n5 = 152;
                    break;
                }
                case 120: {
                    n5 = 238;
                    break;
                }
                case 121: {
                    n5 = 159;
                    break;
                }
                case 122: {
                    n5 = 98;
                    break;
                }
                case 123: {
                    n5 = 18;
                    break;
                }
                case 124: {
                    n5 = 186;
                    break;
                }
                case 125: {
                    n5 = 188;
                    break;
                }
                case 126: {
                    n5 = 14;
                    break;
                }
                case 127: {
                    n5 = 240;
                    break;
                }
                case 128: {
                    n5 = 254;
                    break;
                }
                case 129: {
                    n5 = 191;
                    break;
                }
                case 130: {
                    n5 = 99;
                    break;
                }
                case 131: {
                    n5 = 134;
                    break;
                }
                case 132: {
                    n5 = 237;
                    break;
                }
                case 133: {
                    n5 = 158;
                    break;
                }
                case 134: {
                    n5 = 67;
                    break;
                }
                case 135: {
                    n5 = 245;
                    break;
                }
                case 136: {
                    n5 = 119;
                    break;
                }
                case 137: {
                    n5 = 13;
                    break;
                }
                case 138: {
                    n5 = 81;
                    break;
                }
                case 139: {
                    n5 = 46;
                    break;
                }
                case 140: {
                    n5 = 242;
                    break;
                }
                case 141: {
                    n5 = 138;
                    break;
                }
                case 142: {
                    n5 = 44;
                    break;
                }
                case 143: {
                    n5 = 146;
                    break;
                }
                case 144: {
                    n5 = 6;
                    break;
                }
                case 145: {
                    n5 = 227;
                    break;
                }
                case 146: {
                    n5 = 204;
                    break;
                }
                case 147: {
                    n5 = 31;
                    break;
                }
                case 148: {
                    n5 = 162;
                    break;
                }
                case 149: {
                    n5 = 209;
                    break;
                }
                case 150: {
                    n5 = 201;
                    break;
                }
                case 151: {
                    n5 = 62;
                    break;
                }
                case 152: {
                    n5 = 255;
                    break;
                }
                case 153: {
                    n5 = 196;
                    break;
                }
                case 154: {
                    n5 = 72;
                    break;
                }
                case 155: {
                    n5 = 232;
                    break;
                }
                case 156: {
                    n5 = 210;
                    break;
                }
                case 157: {
                    n5 = 223;
                    break;
                }
                case 158: {
                    n5 = 63;
                    break;
                }
                case 159: {
                    n5 = 226;
                    break;
                }
                case 160: {
                    n5 = 194;
                    break;
                }
                case 161: {
                    n5 = 178;
                    break;
                }
                case 162: {
                    n5 = 124;
                    break;
                }
                case 163: {
                    n5 = 197;
                    break;
                }
                case 164: {
                    n5 = 212;
                    break;
                }
                case 165: {
                    n5 = 104;
                    break;
                }
                case 166: {
                    n5 = 65;
                    break;
                }
                case 167: {
                    n5 = 208;
                    break;
                }
                case 168: {
                    n5 = 251;
                    break;
                }
                case 169: {
                    n5 = 54;
                    break;
                }
                case 170: {
                    n5 = 2;
                    break;
                }
                case 171: {
                    n5 = 169;
                    break;
                }
                case 172: {
                    n5 = 77;
                    break;
                }
                case 173: {
                    n5 = 195;
                    break;
                }
                case 174: {
                    n5 = 85;
                    break;
                }
                case 175: {
                    n5 = 121;
                    break;
                }
                case 176: {
                    n5 = 215;
                    break;
                }
                case 177: {
                    n5 = 19;
                    break;
                }
                case 178: {
                    n5 = 164;
                    break;
                }
                case 179: {
                    n5 = 26;
                    break;
                }
                case 180: {
                    n5 = 78;
                    break;
                }
                case 181: {
                    n5 = 49;
                    break;
                }
                case 182: {
                    n5 = 48;
                    break;
                }
                case 183: {
                    n5 = 71;
                    break;
                }
                case 184: {
                    n5 = 205;
                    break;
                }
                case 185: {
                    n5 = 110;
                    break;
                }
                case 186: {
                    n5 = 241;
                    break;
                }
                case 187: {
                    n5 = 253;
                    break;
                }
                case 188: {
                    n5 = 155;
                    break;
                }
                case 189: {
                    n5 = 252;
                    break;
                }
                case 190: {
                    n5 = 202;
                    break;
                }
                case 191: {
                    n5 = 42;
                    break;
                }
                case 192: {
                    n5 = 122;
                    break;
                }
                case 193: {
                    n5 = 10;
                    break;
                }
                case 194: {
                    n5 = 200;
                    break;
                }
                case 195: {
                    n5 = 97;
                    break;
                }
                case 196: {
                    n5 = 214;
                    break;
                }
                case 197: {
                    n5 = 128;
                    break;
                }
                case 198: {
                    n5 = 243;
                    break;
                }
                case 199: {
                    n5 = 239;
                    break;
                }
                case 200: {
                    n5 = 130;
                    break;
                }
                case 201: {
                    n5 = 47;
                    break;
                }
                case 202: {
                    n5 = 109;
                    break;
                }
                case 203: {
                    n5 = 189;
                    break;
                }
                case 204: {
                    n5 = 213;
                    break;
                }
                case 205: {
                    n5 = 106;
                    break;
                }
                case 206: {
                    n5 = 181;
                    break;
                }
                case 207: {
                    n5 = 137;
                    break;
                }
                case 208: {
                    n5 = 96;
                    break;
                }
                case 209: {
                    n5 = 70;
                    break;
                }
                case 210: {
                    n5 = 52;
                    break;
                }
                case 211: {
                    n5 = 39;
                    break;
                }
                case 212: {
                    n5 = 147;
                    break;
                }
                case 213: {
                    n5 = 123;
                    break;
                }
                case 214: {
                    n5 = 203;
                    break;
                }
                case 215: {
                    n5 = 20;
                    break;
                }
                case 216: {
                    n5 = 41;
                    break;
                }
                case 217: {
                    n5 = 60;
                    break;
                }
                case 218: {
                    n5 = 50;
                    break;
                }
                case 219: {
                    n5 = 206;
                    break;
                }
                case 220: {
                    n5 = 131;
                    break;
                }
                case 221: {
                    n5 = 101;
                    break;
                }
                case 222: {
                    n5 = 249;
                    break;
                }
                case 223: {
                    n5 = 7;
                    break;
                }
                case 224: {
                    n5 = 221;
                    break;
                }
                case 225: {
                    n5 = 29;
                    break;
                }
                case 226: {
                    n5 = 66;
                    break;
                }
                case 227: {
                    n5 = 92;
                    break;
                }
                case 228: {
                    n5 = 177;
                    break;
                }
                case 229: {
                    n5 = 163;
                    break;
                }
                case 230: {
                    n5 = 199;
                    break;
                }
                case 231: {
                    n5 = 151;
                    break;
                }
                case 232: {
                    n5 = 22;
                    break;
                }
                case 233: {
                    n5 = 244;
                    break;
                }
                case 234: {
                    n5 = 132;
                    break;
                }
                case 235: {
                    n5 = 218;
                    break;
                }
                case 236: {
                    n5 = 234;
                    break;
                }
                case 237: {
                    n5 = 27;
                    break;
                }
                case 238: {
                    n5 = 100;
                    break;
                }
                case 239: {
                    n5 = 75;
                    break;
                }
                case 240: {
                    n5 = 88;
                    break;
                }
                case 241: {
                    n5 = 107;
                    break;
                }
                case 242: {
                    n5 = 225;
                    break;
                }
                case 243: {
                    n5 = 140;
                    break;
                }
                case 244: {
                    n5 = 53;
                    break;
                }
                case 245: {
                    n5 = 228;
                    break;
                }
                case 246: {
                    n5 = 183;
                    break;
                }
                case 247: {
                    n5 = 17;
                    break;
                }
                case 248: {
                    n5 = 38;
                    break;
                }
                case 249: {
                    n5 = 136;
                    break;
                }
                case 250: {
                    n5 = 220;
                    break;
                }
                case 251: {
                    n5 = 216;
                    break;
                }
                case 252: {
                    n5 = 126;
                    break;
                }
                case 253: {
                    n5 = 80;
                    break;
                }
                case 254: {
                    n5 = 193;
                    break;
                }
                default: {
                    n5 = 12;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            PKCS11Ops.g[n3] = new String(cArray).intern();
        }
        return g[n3];
    }
}

