/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.certstore.ops;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.ItemSource;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStore;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVEN;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVTKatmani;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.JDBCUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.NotFoundException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzetTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzneTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.SILTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoDizin;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOzet;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoSIL;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.ops.CertStoreRootCertificateOps;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.CRLSearchTemplate;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.util.RsItemSource;

public class CertStoreCRLOps {
    private static Logger a;
    private final CertStore b;
    private static final String[] c;
    private static final String[] d;

    public CertStoreCRLOps(CertStore aDepo) {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            a.error(CertStoreCRLOps.a(-10649, 22616), (Throwable)lE);
            throw new ESYARuntimeException(CertStoreCRLOps.a(-10648, 25660) + lE.getMessage(), (Throwable)lE);
        }
        this.b = aDepo;
    }

    public DepoSIL readStoreCRL(Long aSILNo) throws CertStoreException {
        if (aSILNo <= 0L) {
            throw new CertStoreException(CertStoreCRLOps.a(-10637, 26549));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            DepoSIL depoSIL = depoVEN.sILOku(aSILNo);
            return depoSIL;
        }
        catch (NotFoundException notFoundException) {
            throw new CertStoreException(aSILNo + CertStoreCRLOps.a(-10650, -14790), notFoundException);
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aSILNo + CertStoreCRLOps.a(-10628, 14595), certStoreException);
        }
    }

    public void writeCRL(ECRL aCRL, Long aDizinNo) throws CertStoreException {
        this.writeCRL(aCRL.getEncoded(), aDizinNo);
    }

    public void writeCRL(byte[] aCRL, Long aDizinNo) throws CertStoreException {
        DepoSIL depoSIL = null;
        try {
            depoSIL = CertStoreUtil.asnCRLTODepoSIL(aCRL);
        }
        catch (Exception exception) {
            throw new CertStoreException(CertStoreCRLOps.a(-10647, -25687), exception);
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            List<DepoOzet> list = CertStoreUtil.convertToDepoOzet(depoSIL.getValue(), OzneTipi.SIL);
            depoVEN.sILYaz(depoSIL, list, aDizinNo);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(CertStoreCRLOps.a(-10655, -29643), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemSource<DepoSIL> listStoreCRL() throws CertStoreException {
        ItemSource<DepoSIL> itemSource2;
        try {
            ItemSource<DepoSIL> itemSource;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            itemSource2 = itemSource = depoVEN.sILListele();
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(CertStoreCRLOps.a(-10634, 27089), certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(CertStoreCRLOps.a(-10634, 27089), certStoreException2);
                }
            }
        }
        try {
            JDBCUtil.commit(this.b.getConn());
            return itemSource2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(CertStoreCRLOps.a(-10651, 28461), certStoreException);
        }
    }

    public List<ECRL> listCRL(CRLSearchTemplate aSAS, SILTipi[] aTipler) throws CertStoreException {
        ItemSource<DepoSIL> itemSource = this.listStoreCRL(aSAS, aTipler);
        boolean bl = CertStoreRootCertificateOps.c;
        ArrayList<ECRL> arrayList = new ArrayList<ECRL>();
        try {
            DepoSIL depoSIL = (DepoSIL)itemSource.nextItem();
            while (depoSIL != null) {
                arrayList.add(new ECRL(depoSIL.getValue()));
                depoSIL = (DepoSIL)itemSource.nextItem();
                if (!bl) continue;
                break;
            }
        }
        catch (Exception exception) {
            throw new CertStoreException(exception);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemSource<DepoSIL> listStoreCRL(CRLSearchTemplate aSAS, SILTipi[] aTipler) throws CertStoreException {
        ItemSource<DepoSIL> itemSource2;
        try {
            ItemSource<DepoSIL> itemSource;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aSAS, aTipler);
            String string = (String)pair.first();
            List list = (List)pair.second();
            itemSource2 = itemSource = depoVEN.sILListele(string, list.toArray());
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(CertStoreCRLOps.a(-10630, -12374), certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(CertStoreCRLOps.a(-10630, -12374), certStoreException2);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return itemSource2;
            JDBCUtil.commit(this.b.getConn());
            return itemSource2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(CertStoreCRLOps.a(-10644, 31696), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoDizin> listCRLDirectories(long aSILNo) throws CertStoreException {
        List<DepoDizin> list2;
        if (aSILNo <= 0L) {
            throw new CertStoreException(CertStoreCRLOps.a(-10637, 26549));
        }
        try {
            List<DepoDizin> list;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            list2 = list = ((RsItemSource)depoVEN.sILDizinleriniListele(aSILNo)).toList();
        }
        catch (CertStoreException certStoreException) {
            try {
                throw new CertStoreException(aSILNo + CertStoreCRLOps.a(-10636, -26935), certStoreException);
            }
            catch (Throwable throwable) {
                try {
                    if (this.b.getConn() == null) throw throwable;
                    JDBCUtil.commit(this.b.getConn());
                    throw throwable;
                }
                catch (CertStoreException certStoreException2) {
                    throw new CertStoreException(aSILNo + CertStoreCRLOps.a(-10636, -26935), certStoreException2);
                }
            }
        }
        try {
            if (this.b.getConn() == null) return list2;
            JDBCUtil.commit(this.b.getConn());
            return list2;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(aSILNo + CertStoreCRLOps.a(-10656, 15390), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteCRLFromDirectory(long aSILNo, long aDizinNo) throws CertStoreException {
        if (aSILNo <= 0L) throw new CertStoreException(CertStoreCRLOps.a(-10637, 26549));
        if (aDizinNo <= 0L) {
            throw new CertStoreException(CertStoreCRLOps.a(-10637, 26549));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.dizindenSILSil(aSILNo, aDizinNo);
            JDBCUtil.commit(this.b.getConn());
            return;
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() == null) throw new CertStoreException(aSILNo + CertStoreCRLOps.a(-10646, -14682) + aDizinNo + CertStoreCRLOps.a(-10643, 10140), certStoreException);
            JDBCUtil.rollback(this.b.getConn());
            throw new CertStoreException(aSILNo + CertStoreCRLOps.a(-10646, -14682) + aDizinNo + CertStoreCRLOps.a(-10643, 10140), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void moveCRL(long aSILNo, long aEskiDizinNo, long aYeniDizinNo) throws CertStoreException {
        if (aSILNo <= 0L) throw new CertStoreException(CertStoreCRLOps.a(-10637, 26549));
        if (aEskiDizinNo <= 0L) throw new CertStoreException(CertStoreCRLOps.a(-10637, 26549));
        if (aYeniDizinNo <= 0L) {
            throw new CertStoreException(CertStoreCRLOps.a(-10637, 26549));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.sILTasi(aSILNo, aEskiDizinNo, aYeniDizinNo);
            JDBCUtil.commit(this.b.getConn());
            return;
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() == null) throw new CertStoreException(aSILNo + CertStoreCRLOps.a(-10631, 3814) + aEskiDizinNo + CertStoreCRLOps.a(-10677, -24713) + aYeniDizinNo + CertStoreCRLOps.a(-10625, -28246), certStoreException);
            JDBCUtil.rollback(this.b.getConn());
            throw new CertStoreException(aSILNo + CertStoreCRLOps.a(-10631, 3814) + aEskiDizinNo + CertStoreCRLOps.a(-10677, -24713) + aYeniDizinNo + CertStoreCRLOps.a(-10625, -28246), certStoreException);
        }
    }

    public void deleteCRL(long aSILNo) throws CertStoreException {
        if (aSILNo <= 0L) {
            throw new CertStoreException(CertStoreCRLOps.a(-10633, 27042));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.sILSil(aSILNo);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aSILNo + CertStoreCRLOps.a(-10627, 5088), certStoreException);
        }
    }

    public int deleteCRL(CRLSearchTemplate aSAS) throws CertStoreException {
        Long l = aSAS.getDizinNo();
        SILTipi[] sILTipiArray = new SILTipi[]{SILTipi.BASE, SILTipi.DELTA};
        boolean bl = CertStoreRootCertificateOps.c;
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aSAS, sILTipiArray);
            String string = (String)pair.first();
            List list = (List)pair.second();
            ItemSource<DepoSIL> itemSource = depoVEN.sILListele(string, list.toArray());
            int n = 0;
            DepoSIL depoSIL = (DepoSIL)itemSource.nextItem();
            while (depoSIL != null) {
                block11: {
                    block10: {
                        if (l != null) break block10;
                        n += depoVEN.sILSil(depoSIL.getSILNo());
                        if (!bl) break block11;
                    }
                    n += depoVEN.dizindenSILSil(depoSIL.getSILNo(), l);
                }
                depoSIL = (DepoSIL)itemSource.nextItem();
                if (!bl) continue;
            }
            JDBCUtil.commit(this.b.getConn());
            return n;
        }
        catch (Exception exception) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(CertStoreCRLOps.a(-10642, -20882), exception);
        }
    }

    private Pair<String, List<Object>> a(CRLSearchTemplate cRLSearchTemplate, SILTipi[] sILTipiArray) {
        ArrayList<Object> arrayList;
        boolean bl;
        StringBuffer stringBuffer;
        block38: {
            stringBuffer = new StringBuffer("");
            bl = CertStoreRootCertificateOps.c;
            arrayList = new ArrayList<Object>();
            stringBuffer.append(CertStoreCRLOps.a(-10640, 10871));
            if (sILTipiArray == null || sILTipiArray.length == 0) break block38;
            stringBuffer.append(CertStoreCRLOps.a(-10679, -7065));
            stringBuffer.append(CertStoreCRLOps.a(-10638, -27501));
            stringBuffer.append("(");
            for (int i = 0; i < sILTipiArray.length - 1; ++i) {
                stringBuffer.append(sILTipiArray[i].getIntValue() + CertStoreCRLOps.a(-10678, -25801));
                if (!bl) continue;
            }
            stringBuffer.append(sILTipiArray[sILTipiArray.length - 1].getIntValue());
            stringBuffer.append(")");
        }
        if (cRLSearchTemplate != null) {
            block41: {
                OzetTipi ozetTipi;
                block39: {
                    block40: {
                        Long l = cRLSearchTemplate.getDizinNo();
                        if (l != null) {
                            stringBuffer.append(CertStoreCRLOps.a(-10626, 23513));
                            arrayList.add(l);
                        }
                        byte[] byArray = cRLSearchTemplate.getValue();
                        if (byArray != null) {
                            stringBuffer.append(CertStoreCRLOps.a(-10635, 27995));
                            arrayList.add(byArray);
                        }
                        byte[] byArray2 = cRLSearchTemplate.getHash();
                        ozetTipi = cRLSearchTemplate.getHashType();
                        if (byArray2 == null) break block39;
                        stringBuffer.append(CertStoreCRLOps.a(-10654, -16720));
                        arrayList.add(OzneTipi.SIL.getIntValue());
                        arrayList.add(byArray2);
                        if (ozetTipi == null) break block40;
                        stringBuffer.append(CertStoreCRLOps.a(-10629, 15207));
                        arrayList.add(ozetTipi.getIntValue());
                        if (!bl) break block41;
                    }
                    stringBuffer.append(CertStoreCRLOps.a(-10641, -18742));
                    if (!bl) break block41;
                }
                if (ozetTipi == null) break block41;
                stringBuffer.append(CertStoreCRLOps.a(-10676, -5781));
                arrayList.add(OzneTipi.SIL.getIntValue());
                arrayList.add(ozetTipi.getIntValue());
            }
            byte[] byArray = cRLSearchTemplate.getIssuer();
            if (byArray != null) {
                stringBuffer.append(CertStoreCRLOps.a(-10645, -8824));
                arrayList.add(byArray);
            }
            byte[] byArray3 = cRLSearchTemplate.getSILNumber();
            if (byArray3 != null) {
                stringBuffer.append(CertStoreCRLOps.a(-10652, 2614));
                arrayList.add(byArray3);
            }
            Date date = cRLSearchTemplate.getPublishedBefore();
            if (date != null) {
                stringBuffer.append(CertStoreCRLOps.a(-10680, 24180));
                arrayList.add(date);
            }
            Date date2 = cRLSearchTemplate.getPublishedAfter();
            if (date2 != null) {
                stringBuffer.append(CertStoreCRLOps.a(-10632, 24374));
                arrayList.add(date2);
            }
            Date date3 = cRLSearchTemplate.getValidAt();
            if (date3 != null) {
                stringBuffer.append(CertStoreCRLOps.a(-10639, -32292));
                arrayList.add(date3);
                arrayList.add(date3);
            }
            byte[] byArray4 = cRLSearchTemplate.getBaseSILNumber();
            if (byArray4 != null) {
                stringBuffer.append(CertStoreCRLOps.a(-10653, 20659));
                arrayList.add(byArray4);
            }
        }
        return new Pair((Object)stringBuffer.toString(), arrayList);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[37];
                var3_1 = 0;
                var2_2 = "\u0096\u00e5\u0080\u00a2\b^\u0099\br\u008d\u0083\u000b\u00d1*x\u008eR\u00af|\u00ed\u00fb,:L\u001b\u0088BDpr\u00edH\u0006p\u00aa\u00df\u00c7Z\u00e5\u0004\u0085\u00b6v\u00fc\u00e8\"\u001b\u00a59\u00cb\u008d\u00d5\u00afI\u00edr,\u00c7\\\u0086\u00c6\u00c0\u00ce\u0080\u00a0\u00d1\u00ac\u007f\u00e0\u008d\tq\u00e8D\u0012\u000f\u0014;\u00ad\u00cc\u00aa\u0081A\u00e9U\u0012\u000bh&\u00e3\u00fd\u0081BF\u00dc\u00cb\n4\u00a4)`\u00b9\u00f9\u00a4\u00e7\u00ebX\u0014\u007fua\u00b8\u00e0\u00a6Prh\u00d2\u009f\u00b6\u009a'\u00ce\u000e\u00c9\u00fe\u00f7\u00ef2)\u0090\u009a\by\u00ba\u00d7a\u00da\u0083\u0099\u00fc\u001b\u001e\u00bb\u00bc\u00d3\bG\u0019\u00a2\u00ba\u00be\u008d\u00a1\u00b5%\u00e25%b]\u00ef\u0084\u0096\u0099n\u0092\u00e7\u0015A\u009d\u00a0\u0092\u00b8\u009e\u00eeH\u00aehN\u000f\u00f4NjU\u00b8\u000e\u00efY4K\u00cd\u009b$/^L\u0081\u00cf\u008b\u00cf\u0015\u00dc\u001f\u00c8a\u00d8G\u0012T\u00e3\u00a0;\u00a9X\u00bd*\u001b\u0089\u009a\u00aa 4\u008c\u00e8\u00a8R3t\\\u00e9\u009av\u0084M\u00dc4\u00e9\u00ee\u00a3\u0013\u00d3\u00d9\u00d3\u0012\u00df\u0080088\u00fa)4;-\u007f\u00da9-\u00ae\u00e2jFgs\u0014X\u00a2\u00a4\u0096\u0018\u00fa\u0082\u0087/Th\u00acH\u00a78\u001eC\u00af+\u00b9\u00f2\"\u00fa\u0080\u00a2\u00b3\u00c1(\u009c#\u00ad}\u0096l[\u0097\t\u00c2\u0003w|\u00076l~\";\u00d8\u0092\u0088\u008an\u00f5Z\u009f\u001b/\u009b}\u00ba\u00cf\u0014\u000b\ntWB\u009c\u00b1\u0097U\u00d1\fQ\u001a\u0090XP\u00d6\u00e9\u00cbv\u00aeL\u008b-W\u00c8\u00f5O\u00a1\u00bav\u00cf\u0085\u00aa\u000fA\u00a0\u00eb\u0085\u0006g\u00b1\u00db\u00a7(=\u00ad\u00e3\u00d8\u000fG\u001e|DR\u00f9@\u00a6\u008b\u0014w\u00c2\u0092\u00b4u3\"\u0089\u00ad\u008f\u00ac`\u008d\u00cd\u0005\u00bfa\u009c%.\u0017\u00d6\u00f1b\u0080\\\u0089\u00cf\u0016\u00b1\u00b7\u00d4\u00e3\u008c\u00bd\u00e2\u00f8\u00e7$\u0083HR=p)\u0018\u00e9\u00a8K\u00d5M\u00f45>\u00f8\u009c\u0005\u00ee,\u0093F\u00c0j\u00a6\u00d6v-\u00ee\u00d5{N\u00f0\u008a\u00e1L\u00c9\u00c7\n^\u00c0\u00e2RqG\u00f7\u001a\t\u00d0r\u00ebQ\u00aaf}\u00bc\u0080\u001eP\u00f5\u00aei\u00b0\u00b2&\u00e8u\u008e \u00c7\u00c8HG\u008e\u00c7~\u00c7T\u00f4\u0015\u00d0\\\u00fa\u00150\u0017E\u00b7&\u00e0\b\u00a6_\u0018\u00c9\u00a9\u0082+J\u00ce\u0016j\u0083*\u00f2pA\u001e&\u0012\u00b0\u00c3\u0098n\u00dff\u008d\f\u0095\u00d5ch\u00fdJ\u00e3B\u009c\u00d6*\u00cf\u0012\u00ae\u0082-\t\u00cb\u00d4\u00da?\u00f3e\u001a\u00fade\u0010\u0001\u00c5\u009b\u0003\u0017E_\u00fbi\u00beF\u00detz\u00a4\b)>\u00ad\u00e6\u0019\u0010\u00da\u0099(#\u00da>\u00f43\u0002\u0093\u00d3\u00aa\u0005\u00f1(\u0014\u00fb9\u0082\b,\u0016\u00ae\u00d2\u0003\u00cf\u00a8\u00d5\u0001\u0080V\u00a5\u00f0\u00044\u0097I\u00e2\u00f4\u001a\u009a\u0081\u0001.8\u00cf\u009f:\u00b2\u00cb\u009b\u00c3\u00d23\u0018\u00ad^\u00cb\u00fda\u00cb\u00bd<~\u00db\u00ce\u00159\u008f\u00a9\u00e7\u00f9Ph\b\u0011\u00f4tn\u00a5J)\u00996\u0011t\u00b3\u0091\u000b\u00b4<9s\u00bb\u009b\u00e4\u00ab\u00e3\u00dd\u00a22\u00bf\u0098H\t#\u009a\u009ce\u00b3\u0003\u00b4\u00ec\u00be\u001c\u000f\u00fcE\u0000\u0095\u0018\u00f8\u009a\u00f5\u0089\u00c85\b\u00f2\u0090'\u00d6\u001dy\u008cD\u00984\u00b2\u00ac\u0011(\u001d\u008d\u0082\u001d\u009cZ\b8`\u0014\u00e5\u008e2\u00c7\u008aH\u000f\u008e\u00ce|\u00feJ\u00d8\fZ\u008f\n\u00ce\u00db\u00e0-\u00a5\u001f\u001b\u0017\u00ff\u0017l:\u00f2\u00e3\u00cfX:x\\\u00d4\u00df\u00f8\u00f8\u00c2\u00d1\u00ac\u00fa\u00d1,t)\u00b9\u00d0\u0019}4\u0081\u00a3\u0007H\u00ce\u00d0\u00c99\u00fa\u00aeE\u00b7\u0098G[\u0018\u00c4\u00f7\u0004\u000b\u0013\u00b9\u001d\u0093.T\u0080\u00bc*\u00b0p\u0002<\u001cu\u00c3\u00d4 \u0017*\u00c7r\u00c4`A\u001c\u000b@\u00e8\u0012\u007frV\u00af\u00fc\u00ca8vl\u0098\u0013W\u00c5\u00e8\u00e5\u00d1\u00ff\u00ddn\u0005\u00eb\n\u0085Y\u009a\u00e6\u00e8u2\u0002Y\u00a4?E\u0094=\u00cf\u0012wT\"!2\u00e4b\u00d2\u00d0\u00faD\u0004\u0092\u00fd\u00de\u00f1\u0018\u008c\u00a1/\u00b3l8\u00c8\u0099\u00a5B\u00c8mw@z~l\u00ec6\u0095c\u00f37Y\u008078%\u000b\u0016\u0099~\u00fa\u00af>\r{\u00aba4\u0013\u001cJ\u00ef\u00b8R\u00e3\u00d6\u0089~\u00c9W\u00f0\u008aT\u00e6,,\u0006E\u0088\u00ee\u00f4\u00e9r_C%s,\u00c3ucf\u00de\u0083\u00d2@\u00a7\u00f5\u0082*S\u00a5\u00f3\u008bv\u00b1\u00e7xGy\u00a8UM&\u0095\u00d8\u00d1\"\u0095\u0005\u001akkU\u0099Yw\f\u00a0\u00fd+\u0085O\u009e\u0014\u0003\u00d0-\u00d8)\u00f0T\u0090\u009c\u00de?\u008c\u00e5\u008dI\u00e7\u00d9\u00d7\u00bcgG\u00fd\u00caO\u00c8\u00f65\u00beoKuYQ\u0087\u00bb\u00c0\r\u008c(\u00a8:\u0084\u00bc7\u00d4\b\u000b\u00b4\u0091\u0007='=\u00d2L]\u0007\u00d0*$\u00e3\u0094\u00e0\u0081\u00ab\u00ab\u00a0?P\u009d\u00f2'Y%%\u0012\u00da\u00af\u0002/\u00a4\u00b8\u00de\u0011K\u007f:\u00b5\u00cd\u00f9\u00ef(\u0082Y\u0012s\u0019\u0097\u00c4\u00e2\u00196\u0018;\u00ac\u0093\t\u0087\u00b2()\u00a1\u00b2\u0015\u0006~8W\u00ce\u008a\u009a\u00a3\u00dbam\u00e0\u00db\u00e5\u007f\u00df\u00cc]\u00f20\u00e4\u001d\u00de~8\u00deL\f\u000b\u00df\u00c5\u00dd\u00d5\u00a4\u00ec\u008b\u00ce3A-{\u001a\u0012A0\u00a6\u0010\u0018\u00a9u\u00f5\u0092\u00fe\u0099\u008c\u0083q1 g;*Y>|\u0007w\u00b9\u0080\u00c2\u00b3\u00fd\u00de=\u00bf\u00f1\u00d0\u0004\u0086-\u0017\u001eY\u00a7\u000eI\u0092\u00ab\u0093\u001e{\u007f\u00ce\u00c5\u009e\u0005\u00ec(\u00bc\u00a9[\u00cc\u00f0\u00ea*X\u0014\u001b\u001ept\u0095[\u00f8/e\u001d8\u00a4\u00c6\u009an- \u00fc\u00de{\u0086%\u00d64\u0087\u00d5\u00aa0\u001aPTu\u00d6\u00ec\u0082\u00c6\u00a9?%f\u0014\u00e1\u00a8\u00b2\u0003\u009a\u00cc\u0004\u009b\u009c\u0086\u00c5 \u0093\u0083\u00ef\u00a0\u00ec+rU\u0005\u00e572\u00f0\u008a\u0003j\u00f4\u00ad";
                var4_3 = "\u0096\u00e5\u0080\u00a2\b^\u0099\br\u008d\u0083\u000b\u00d1*x\u008eR\u00af|\u00ed\u00fb,:L\u001b\u0088BDpr\u00edH\u0006p\u00aa\u00df\u00c7Z\u00e5\u0004\u0085\u00b6v\u00fc\u00e8\"\u001b\u00a59\u00cb\u008d\u00d5\u00afI\u00edr,\u00c7\\\u0086\u00c6\u00c0\u00ce\u0080\u00a0\u00d1\u00ac\u007f\u00e0\u008d\tq\u00e8D\u0012\u000f\u0014;\u00ad\u00cc\u00aa\u0081A\u00e9U\u0012\u000bh&\u00e3\u00fd\u0081BF\u00dc\u00cb\n4\u00a4)`\u00b9\u00f9\u00a4\u00e7\u00ebX\u0014\u007fua\u00b8\u00e0\u00a6Prh\u00d2\u009f\u00b6\u009a'\u00ce\u000e\u00c9\u00fe\u00f7\u00ef2)\u0090\u009a\by\u00ba\u00d7a\u00da\u0083\u0099\u00fc\u001b\u001e\u00bb\u00bc\u00d3\bG\u0019\u00a2\u00ba\u00be\u008d\u00a1\u00b5%\u00e25%b]\u00ef\u0084\u0096\u0099n\u0092\u00e7\u0015A\u009d\u00a0\u0092\u00b8\u009e\u00eeH\u00aehN\u000f\u00f4NjU\u00b8\u000e\u00efY4K\u00cd\u009b$/^L\u0081\u00cf\u008b\u00cf\u0015\u00dc\u001f\u00c8a\u00d8G\u0012T\u00e3\u00a0;\u00a9X\u00bd*\u001b\u0089\u009a\u00aa 4\u008c\u00e8\u00a8R3t\\\u00e9\u009av\u0084M\u00dc4\u00e9\u00ee\u00a3\u0013\u00d3\u00d9\u00d3\u0012\u00df\u0080088\u00fa)4;-\u007f\u00da9-\u00ae\u00e2jFgs\u0014X\u00a2\u00a4\u0096\u0018\u00fa\u0082\u0087/Th\u00acH\u00a78\u001eC\u00af+\u00b9\u00f2\"\u00fa\u0080\u00a2\u00b3\u00c1(\u009c#\u00ad}\u0096l[\u0097\t\u00c2\u0003w|\u00076l~\";\u00d8\u0092\u0088\u008an\u00f5Z\u009f\u001b/\u009b}\u00ba\u00cf\u0014\u000b\ntWB\u009c\u00b1\u0097U\u00d1\fQ\u001a\u0090XP\u00d6\u00e9\u00cbv\u00aeL\u008b-W\u00c8\u00f5O\u00a1\u00bav\u00cf\u0085\u00aa\u000fA\u00a0\u00eb\u0085\u0006g\u00b1\u00db\u00a7(=\u00ad\u00e3\u00d8\u000fG\u001e|DR\u00f9@\u00a6\u008b\u0014w\u00c2\u0092\u00b4u3\"\u0089\u00ad\u008f\u00ac`\u008d\u00cd\u0005\u00bfa\u009c%.\u0017\u00d6\u00f1b\u0080\\\u0089\u00cf\u0016\u00b1\u00b7\u00d4\u00e3\u008c\u00bd\u00e2\u00f8\u00e7$\u0083HR=p)\u0018\u00e9\u00a8K\u00d5M\u00f45>\u00f8\u009c\u0005\u00ee,\u0093F\u00c0j\u00a6\u00d6v-\u00ee\u00d5{N\u00f0\u008a\u00e1L\u00c9\u00c7\n^\u00c0\u00e2RqG\u00f7\u001a\t\u00d0r\u00ebQ\u00aaf}\u00bc\u0080\u001eP\u00f5\u00aei\u00b0\u00b2&\u00e8u\u008e \u00c7\u00c8HG\u008e\u00c7~\u00c7T\u00f4\u0015\u00d0\\\u00fa\u00150\u0017E\u00b7&\u00e0\b\u00a6_\u0018\u00c9\u00a9\u0082+J\u00ce\u0016j\u0083*\u00f2pA\u001e&\u0012\u00b0\u00c3\u0098n\u00dff\u008d\f\u0095\u00d5ch\u00fdJ\u00e3B\u009c\u00d6*\u00cf\u0012\u00ae\u0082-\t\u00cb\u00d4\u00da?\u00f3e\u001a\u00fade\u0010\u0001\u00c5\u009b\u0003\u0017E_\u00fbi\u00beF\u00detz\u00a4\b)>\u00ad\u00e6\u0019\u0010\u00da\u0099(#\u00da>\u00f43\u0002\u0093\u00d3\u00aa\u0005\u00f1(\u0014\u00fb9\u0082\b,\u0016\u00ae\u00d2\u0003\u00cf\u00a8\u00d5\u0001\u0080V\u00a5\u00f0\u00044\u0097I\u00e2\u00f4\u001a\u009a\u0081\u0001.8\u00cf\u009f:\u00b2\u00cb\u009b\u00c3\u00d23\u0018\u00ad^\u00cb\u00fda\u00cb\u00bd<~\u00db\u00ce\u00159\u008f\u00a9\u00e7\u00f9Ph\b\u0011\u00f4tn\u00a5J)\u00996\u0011t\u00b3\u0091\u000b\u00b4<9s\u00bb\u009b\u00e4\u00ab\u00e3\u00dd\u00a22\u00bf\u0098H\t#\u009a\u009ce\u00b3\u0003\u00b4\u00ec\u00be\u001c\u000f\u00fcE\u0000\u0095\u0018\u00f8\u009a\u00f5\u0089\u00c85\b\u00f2\u0090'\u00d6\u001dy\u008cD\u00984\u00b2\u00ac\u0011(\u001d\u008d\u0082\u001d\u009cZ\b8`\u0014\u00e5\u008e2\u00c7\u008aH\u000f\u008e\u00ce|\u00feJ\u00d8\fZ\u008f\n\u00ce\u00db\u00e0-\u00a5\u001f\u001b\u0017\u00ff\u0017l:\u00f2\u00e3\u00cfX:x\\\u00d4\u00df\u00f8\u00f8\u00c2\u00d1\u00ac\u00fa\u00d1,t)\u00b9\u00d0\u0019}4\u0081\u00a3\u0007H\u00ce\u00d0\u00c99\u00fa\u00aeE\u00b7\u0098G[\u0018\u00c4\u00f7\u0004\u000b\u0013\u00b9\u001d\u0093.T\u0080\u00bc*\u00b0p\u0002<\u001cu\u00c3\u00d4 \u0017*\u00c7r\u00c4`A\u001c\u000b@\u00e8\u0012\u007frV\u00af\u00fc\u00ca8vl\u0098\u0013W\u00c5\u00e8\u00e5\u00d1\u00ff\u00ddn\u0005\u00eb\n\u0085Y\u009a\u00e6\u00e8u2\u0002Y\u00a4?E\u0094=\u00cf\u0012wT\"!2\u00e4b\u00d2\u00d0\u00faD\u0004\u0092\u00fd\u00de\u00f1\u0018\u008c\u00a1/\u00b3l8\u00c8\u0099\u00a5B\u00c8mw@z~l\u00ec6\u0095c\u00f37Y\u008078%\u000b\u0016\u0099~\u00fa\u00af>\r{\u00aba4\u0013\u001cJ\u00ef\u00b8R\u00e3\u00d6\u0089~\u00c9W\u00f0\u008aT\u00e6,,\u0006E\u0088\u00ee\u00f4\u00e9r_C%s,\u00c3ucf\u00de\u0083\u00d2@\u00a7\u00f5\u0082*S\u00a5\u00f3\u008bv\u00b1\u00e7xGy\u00a8UM&\u0095\u00d8\u00d1\"\u0095\u0005\u001akkU\u0099Yw\f\u00a0\u00fd+\u0085O\u009e\u0014\u0003\u00d0-\u00d8)\u00f0T\u0090\u009c\u00de?\u008c\u00e5\u008dI\u00e7\u00d9\u00d7\u00bcgG\u00fd\u00caO\u00c8\u00f65\u00beoKuYQ\u0087\u00bb\u00c0\r\u008c(\u00a8:\u0084\u00bc7\u00d4\b\u000b\u00b4\u0091\u0007='=\u00d2L]\u0007\u00d0*$\u00e3\u0094\u00e0\u0081\u00ab\u00ab\u00a0?P\u009d\u00f2'Y%%\u0012\u00da\u00af\u0002/\u00a4\u00b8\u00de\u0011K\u007f:\u00b5\u00cd\u00f9\u00ef(\u0082Y\u0012s\u0019\u0097\u00c4\u00e2\u00196\u0018;\u00ac\u0093\t\u0087\u00b2()\u00a1\u00b2\u0015\u0006~8W\u00ce\u008a\u009a\u00a3\u00dbam\u00e0\u00db\u00e5\u007f\u00df\u00cc]\u00f20\u00e4\u001d\u00de~8\u00deL\f\u000b\u00df\u00c5\u00dd\u00d5\u00a4\u00ec\u008b\u00ce3A-{\u001a\u0012A0\u00a6\u0010\u0018\u00a9u\u00f5\u0092\u00fe\u0099\u008c\u0083q1 g;*Y>|\u0007w\u00b9\u0080\u00c2\u00b3\u00fd\u00de=\u00bf\u00f1\u00d0\u0004\u0086-\u0017\u001eY\u00a7\u000eI\u0092\u00ab\u0093\u001e{\u007f\u00ce\u00c5\u009e\u0005\u00ec(\u00bc\u00a9[\u00cc\u00f0\u00ea*X\u0014\u001b\u001ept\u0095[\u00f8/e\u001d8\u00a4\u00c6\u009an- \u00fc\u00de{\u0086%\u00d64\u0087\u00d5\u00aa0\u001aPTu\u00d6\u00ec\u0082\u00c6\u00a9?%f\u0014\u00e1\u00a8\u00b2\u0003\u009a\u00cc\u0004\u009b\u009c\u0086\u00c5 \u0093\u0083\u00ef\u00a0\u00ec+rU\u0005\u00e572\u00f0\u008a\u0003j\u00f4\u00ad".length();
                var1_4 = 27;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00f4\u00fc1k\u00ba\u0098\u00f3\u00eb\u00e6\u00b4\u00bc\u00dde&\u00f0S\u00d9\u0004\u00b5\u0096zy9\u00ef\u0003\u00b3\u00fc\u00d6\u00c1\u0081\"M\u00c8\u00e7\u00daN\u00f9w\u00a4Lc\u00a9\u001c\u0093w\u00ed\u00adB\u00a8\u00bd[\u0084\u00cd\u0011\u0090h?\u0000>\u00f20\u00cdUH\u00b5\u00de\u00fa\u00f3/Qlj\u00bb\u00e9\u00a0X\u008b;\u00cf\u00d6jT[F\u00db\u0096\u00fc\u00fd2\u0098\u0083\u00145\u00c3\u00a89*\u00bd|";
                    var4_3 = "\u00f4\u00fc1k\u00ba\u0098\u00f3\u00eb\u00e6\u00b4\u00bc\u00dde&\u00f0S\u00d9\u0004\u00b5\u0096zy9\u00ef\u0003\u00b3\u00fc\u00d6\u00c1\u0081\"M\u00c8\u00e7\u00daN\u00f9w\u00a4Lc\u00a9\u001c\u0093w\u00ed\u00adB\u00a8\u00bd[\u0084\u00cd\u0011\u0090h?\u0000>\u00f20\u00cdUH\u00b5\u00de\u00fa\u00f3/Qlj\u00bb\u00e9\u00a0X\u008b;\u00cf\u00d6jT[F\u00db\u0096\u00fc\u00fd2\u0098\u0083\u00145\u00c3\u00a89*\u00bd|".length();
                    var1_4 = 15;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 127;
                            break;
                        }
                        case 1: {
                            v13 = 65;
                            break;
                        }
                        case 2: {
                            v13 = 11;
                            break;
                        }
                        case 3: {
                            v13 = 19;
                            break;
                        }
                        case 4: {
                            v13 = 10;
                            break;
                        }
                        case 5: {
                            v13 = 86;
                            break;
                        }
                        default: {
                            v13 = 90;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        CertStoreCRLOps.c = var5;
        CertStoreCRLOps.d = new String[37];
        CertStoreCRLOps.a = LoggerFactory.getLogger(CertStoreCRLOps.class);
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0xFFFFD668) & 0xFFFF;
        if (d[n3] == null) {
            int n4;
            int n5;
            char[] cArray = c[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 104;
                    break;
                }
                case 1: {
                    n5 = 187;
                    break;
                }
                case 2: {
                    n5 = 22;
                    break;
                }
                case 3: {
                    n5 = 223;
                    break;
                }
                case 4: {
                    n5 = 152;
                    break;
                }
                case 5: {
                    n5 = 92;
                    break;
                }
                case 6: {
                    n5 = 183;
                    break;
                }
                case 7: {
                    n5 = 144;
                    break;
                }
                case 8: {
                    n5 = 162;
                    break;
                }
                case 9: {
                    n5 = 136;
                    break;
                }
                case 10: {
                    n5 = 140;
                    break;
                }
                case 11: {
                    n5 = 200;
                    break;
                }
                case 12: {
                    n5 = 46;
                    break;
                }
                case 13: {
                    n5 = 54;
                    break;
                }
                case 14: {
                    n5 = 106;
                    break;
                }
                case 15: {
                    n5 = 91;
                    break;
                }
                case 16: {
                    n5 = 194;
                    break;
                }
                case 17: {
                    n5 = 56;
                    break;
                }
                case 18: {
                    n5 = 82;
                    break;
                }
                case 19: {
                    n5 = 235;
                    break;
                }
                case 20: {
                    n5 = 25;
                    break;
                }
                case 21: {
                    n5 = 2;
                    break;
                }
                case 22: {
                    n5 = 118;
                    break;
                }
                case 23: {
                    n5 = 103;
                    break;
                }
                case 24: {
                    n5 = 207;
                    break;
                }
                case 25: {
                    n5 = 239;
                    break;
                }
                case 26: {
                    n5 = 191;
                    break;
                }
                case 27: {
                    n5 = 58;
                    break;
                }
                case 28: {
                    n5 = 18;
                    break;
                }
                case 29: {
                    n5 = 179;
                    break;
                }
                case 30: {
                    n5 = 12;
                    break;
                }
                case 31: {
                    n5 = 21;
                    break;
                }
                case 32: {
                    n5 = 123;
                    break;
                }
                case 33: {
                    n5 = 27;
                    break;
                }
                case 34: {
                    n5 = 49;
                    break;
                }
                case 35: {
                    n5 = 210;
                    break;
                }
                case 36: {
                    n5 = 220;
                    break;
                }
                case 37: {
                    n5 = 102;
                    break;
                }
                case 38: {
                    n5 = 95;
                    break;
                }
                case 39: {
                    n5 = 57;
                    break;
                }
                case 40: {
                    n5 = 147;
                    break;
                }
                case 41: {
                    n5 = 139;
                    break;
                }
                case 42: {
                    n5 = 188;
                    break;
                }
                case 43: {
                    n5 = 89;
                    break;
                }
                case 44: {
                    n5 = 172;
                    break;
                }
                case 45: {
                    n5 = 227;
                    break;
                }
                case 46: {
                    n5 = 17;
                    break;
                }
                case 47: {
                    n5 = 117;
                    break;
                }
                case 48: {
                    n5 = 74;
                    break;
                }
                case 49: {
                    n5 = 34;
                    break;
                }
                case 50: {
                    n5 = 221;
                    break;
                }
                case 51: {
                    n5 = 231;
                    break;
                }
                case 52: {
                    n5 = 70;
                    break;
                }
                case 53: {
                    n5 = 109;
                    break;
                }
                case 54: {
                    n5 = 79;
                    break;
                }
                case 55: {
                    n5 = 53;
                    break;
                }
                case 56: {
                    n5 = 202;
                    break;
                }
                case 57: {
                    n5 = 205;
                    break;
                }
                case 58: {
                    n5 = 153;
                    break;
                }
                case 59: {
                    n5 = 155;
                    break;
                }
                case 60: {
                    n5 = 198;
                    break;
                }
                case 61: {
                    n5 = 199;
                    break;
                }
                case 62: {
                    n5 = 61;
                    break;
                }
                case 63: {
                    n5 = 75;
                    break;
                }
                case 64: {
                    n5 = 72;
                    break;
                }
                case 65: {
                    n5 = 94;
                    break;
                }
                case 66: {
                    n5 = 78;
                    break;
                }
                case 67: {
                    n5 = 131;
                    break;
                }
                case 68: {
                    n5 = 161;
                    break;
                }
                case 69: {
                    n5 = 164;
                    break;
                }
                case 70: {
                    n5 = 208;
                    break;
                }
                case 71: {
                    n5 = 247;
                    break;
                }
                case 72: {
                    n5 = 50;
                    break;
                }
                case 73: {
                    n5 = 4;
                    break;
                }
                case 74: {
                    n5 = 81;
                    break;
                }
                case 75: {
                    n5 = 59;
                    break;
                }
                case 76: {
                    n5 = 192;
                    break;
                }
                case 77: {
                    n5 = 238;
                    break;
                }
                case 78: {
                    n5 = 180;
                    break;
                }
                case 79: {
                    n5 = 80;
                    break;
                }
                case 80: {
                    n5 = 218;
                    break;
                }
                case 81: {
                    n5 = 60;
                    break;
                }
                case 82: {
                    n5 = 129;
                    break;
                }
                case 83: {
                    n5 = 5;
                    break;
                }
                case 84: {
                    n5 = 132;
                    break;
                }
                case 85: {
                    n5 = 185;
                    break;
                }
                case 86: {
                    n5 = 203;
                    break;
                }
                case 87: {
                    n5 = 133;
                    break;
                }
                case 88: {
                    n5 = 88;
                    break;
                }
                case 89: {
                    n5 = 241;
                    break;
                }
                case 90: {
                    n5 = 11;
                    break;
                }
                case 91: {
                    n5 = 160;
                    break;
                }
                case 92: {
                    n5 = 15;
                    break;
                }
                case 93: {
                    n5 = 158;
                    break;
                }
                case 94: {
                    n5 = 112;
                    break;
                }
                case 95: {
                    n5 = 245;
                    break;
                }
                case 96: {
                    n5 = 234;
                    break;
                }
                case 97: {
                    n5 = 6;
                    break;
                }
                case 98: {
                    n5 = 167;
                    break;
                }
                case 99: {
                    n5 = 97;
                    break;
                }
                case 100: {
                    n5 = 189;
                    break;
                }
                case 101: {
                    n5 = 197;
                    break;
                }
                case 102: {
                    n5 = 145;
                    break;
                }
                case 103: {
                    n5 = 130;
                    break;
                }
                case 104: {
                    n5 = 243;
                    break;
                }
                case 105: {
                    n5 = 48;
                    break;
                }
                case 106: {
                    n5 = 42;
                    break;
                }
                case 107: {
                    n5 = 7;
                    break;
                }
                case 108: {
                    n5 = 108;
                    break;
                }
                case 109: {
                    n5 = 222;
                    break;
                }
                case 110: {
                    n5 = 215;
                    break;
                }
                case 111: {
                    n5 = 186;
                    break;
                }
                case 112: {
                    n5 = 76;
                    break;
                }
                case 113: {
                    n5 = 84;
                    break;
                }
                case 114: {
                    n5 = 116;
                    break;
                }
                case 115: {
                    n5 = 28;
                    break;
                }
                case 116: {
                    n5 = 120;
                    break;
                }
                case 117: {
                    n5 = 1;
                    break;
                }
                case 118: {
                    n5 = 52;
                    break;
                }
                case 119: {
                    n5 = 190;
                    break;
                }
                case 120: {
                    n5 = 233;
                    break;
                }
                case 121: {
                    n5 = 138;
                    break;
                }
                case 122: {
                    n5 = 141;
                    break;
                }
                case 123: {
                    n5 = 40;
                    break;
                }
                case 124: {
                    n5 = 67;
                    break;
                }
                case 125: {
                    n5 = 237;
                    break;
                }
                case 126: {
                    n5 = 137;
                    break;
                }
                case 127: {
                    n5 = 30;
                    break;
                }
                case 128: {
                    n5 = 14;
                    break;
                }
                case 129: {
                    n5 = 127;
                    break;
                }
                case 130: {
                    n5 = 64;
                    break;
                }
                case 131: {
                    n5 = 47;
                    break;
                }
                case 132: {
                    n5 = 157;
                    break;
                }
                case 133: {
                    n5 = 101;
                    break;
                }
                case 134: {
                    n5 = 85;
                    break;
                }
                case 135: {
                    n5 = 114;
                    break;
                }
                case 136: {
                    n5 = 105;
                    break;
                }
                case 137: {
                    n5 = 26;
                    break;
                }
                case 138: {
                    n5 = 113;
                    break;
                }
                case 139: {
                    n5 = 204;
                    break;
                }
                case 140: {
                    n5 = 149;
                    break;
                }
                case 141: {
                    n5 = 31;
                    break;
                }
                case 142: {
                    n5 = 10;
                    break;
                }
                case 143: {
                    n5 = 45;
                    break;
                }
                case 144: {
                    n5 = 250;
                    break;
                }
                case 145: {
                    n5 = 206;
                    break;
                }
                case 146: {
                    n5 = 43;
                    break;
                }
                case 147: {
                    n5 = 177;
                    break;
                }
                case 148: {
                    n5 = 77;
                    break;
                }
                case 149: {
                    n5 = 212;
                    break;
                }
                case 150: {
                    n5 = 219;
                    break;
                }
                case 151: {
                    n5 = 90;
                    break;
                }
                case 152: {
                    n5 = 248;
                    break;
                }
                case 153: {
                    n5 = 32;
                    break;
                }
                case 154: {
                    n5 = 173;
                    break;
                }
                case 155: {
                    n5 = 16;
                    break;
                }
                case 156: {
                    n5 = 216;
                    break;
                }
                case 157: {
                    n5 = 253;
                    break;
                }
                case 158: {
                    n5 = 182;
                    break;
                }
                case 159: {
                    n5 = 55;
                    break;
                }
                case 160: {
                    n5 = 184;
                    break;
                }
                case 161: {
                    n5 = 244;
                    break;
                }
                case 162: {
                    n5 = 150;
                    break;
                }
                case 163: {
                    n5 = 249;
                    break;
                }
                case 164: {
                    n5 = 37;
                    break;
                }
                case 165: {
                    n5 = 181;
                    break;
                }
                case 166: {
                    n5 = 229;
                    break;
                }
                case 167: {
                    n5 = 83;
                    break;
                }
                case 168: {
                    n5 = 171;
                    break;
                }
                case 169: {
                    n5 = 159;
                    break;
                }
                case 170: {
                    n5 = 66;
                    break;
                }
                case 171: {
                    n5 = 69;
                    break;
                }
                case 172: {
                    n5 = 128;
                    break;
                }
                case 173: {
                    n5 = 213;
                    break;
                }
                case 174: {
                    n5 = 252;
                    break;
                }
                case 175: {
                    n5 = 217;
                    break;
                }
                case 176: {
                    n5 = 73;
                    break;
                }
                case 177: {
                    n5 = 98;
                    break;
                }
                case 178: {
                    n5 = 242;
                    break;
                }
                case 179: {
                    n5 = 148;
                    break;
                }
                case 180: {
                    n5 = 87;
                    break;
                }
                case 181: {
                    n5 = 0;
                    break;
                }
                case 182: {
                    n5 = 226;
                    break;
                }
                case 183: {
                    n5 = 178;
                    break;
                }
                case 184: {
                    n5 = 96;
                    break;
                }
                case 185: {
                    n5 = 63;
                    break;
                }
                case 186: {
                    n5 = 176;
                    break;
                }
                case 187: {
                    n5 = 230;
                    break;
                }
                case 188: {
                    n5 = 232;
                    break;
                }
                case 189: {
                    n5 = 201;
                    break;
                }
                case 190: {
                    n5 = 224;
                    break;
                }
                case 191: {
                    n5 = 174;
                    break;
                }
                case 192: {
                    n5 = 23;
                    break;
                }
                case 193: {
                    n5 = 142;
                    break;
                }
                case 194: {
                    n5 = 19;
                    break;
                }
                case 195: {
                    n5 = 115;
                    break;
                }
                case 196: {
                    n5 = 125;
                    break;
                }
                case 197: {
                    n5 = 225;
                    break;
                }
                case 198: {
                    n5 = 38;
                    break;
                }
                case 199: {
                    n5 = 68;
                    break;
                }
                case 200: {
                    n5 = 228;
                    break;
                }
                case 201: {
                    n5 = 107;
                    break;
                }
                case 202: {
                    n5 = 154;
                    break;
                }
                case 203: {
                    n5 = 251;
                    break;
                }
                case 204: {
                    n5 = 33;
                    break;
                }
                case 205: {
                    n5 = 195;
                    break;
                }
                case 206: {
                    n5 = 156;
                    break;
                }
                case 207: {
                    n5 = 71;
                    break;
                }
                case 208: {
                    n5 = 165;
                    break;
                }
                case 209: {
                    n5 = 236;
                    break;
                }
                case 210: {
                    n5 = 44;
                    break;
                }
                case 211: {
                    n5 = 119;
                    break;
                }
                case 212: {
                    n5 = 240;
                    break;
                }
                case 213: {
                    n5 = 126;
                    break;
                }
                case 214: {
                    n5 = 255;
                    break;
                }
                case 215: {
                    n5 = 170;
                    break;
                }
                case 216: {
                    n5 = 124;
                    break;
                }
                case 217: {
                    n5 = 146;
                    break;
                }
                case 218: {
                    n5 = 9;
                    break;
                }
                case 219: {
                    n5 = 135;
                    break;
                }
                case 220: {
                    n5 = 122;
                    break;
                }
                case 221: {
                    n5 = 99;
                    break;
                }
                case 222: {
                    n5 = 110;
                    break;
                }
                case 223: {
                    n5 = 169;
                    break;
                }
                case 224: {
                    n5 = 24;
                    break;
                }
                case 225: {
                    n5 = 13;
                    break;
                }
                case 226: {
                    n5 = 100;
                    break;
                }
                case 227: {
                    n5 = 246;
                    break;
                }
                case 228: {
                    n5 = 51;
                    break;
                }
                case 229: {
                    n5 = 175;
                    break;
                }
                case 230: {
                    n5 = 35;
                    break;
                }
                case 231: {
                    n5 = 29;
                    break;
                }
                case 232: {
                    n5 = 93;
                    break;
                }
                case 233: {
                    n5 = 151;
                    break;
                }
                case 234: {
                    n5 = 36;
                    break;
                }
                case 235: {
                    n5 = 163;
                    break;
                }
                case 236: {
                    n5 = 168;
                    break;
                }
                case 237: {
                    n5 = 121;
                    break;
                }
                case 238: {
                    n5 = 65;
                    break;
                }
                case 239: {
                    n5 = 196;
                    break;
                }
                case 240: {
                    n5 = 41;
                    break;
                }
                case 241: {
                    n5 = 193;
                    break;
                }
                case 242: {
                    n5 = 39;
                    break;
                }
                case 243: {
                    n5 = 211;
                    break;
                }
                case 244: {
                    n5 = 254;
                    break;
                }
                case 245: {
                    n5 = 209;
                    break;
                }
                case 246: {
                    n5 = 62;
                    break;
                }
                case 247: {
                    n5 = 20;
                    break;
                }
                case 248: {
                    n5 = 8;
                    break;
                }
                case 249: {
                    n5 = 111;
                    break;
                }
                case 250: {
                    n5 = 143;
                    break;
                }
                case 251: {
                    n5 = 134;
                    break;
                }
                case 252: {
                    n5 = 86;
                    break;
                }
                case 253: {
                    n5 = 214;
                    break;
                }
                case 254: {
                    n5 = 166;
                    break;
                }
                default: {
                    n5 = 3;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            CertStoreCRLOps.d[n3] = new String(cArray).intern();
        }
        return d[n3];
    }
}

