/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer;

import com.objsys.asn1j.runtime.Asn1OpenType;
import java.security.PublicKey;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectPublicKeyInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.CheckResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.CheckStatus;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.Checker;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.PathValidationResult;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer.IssuerCheckParameters;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.issuer.IssuerChecker;
import tr.gov.tubitak.uekae.esya.api.common.bundle.cert.CertI18n;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.AsymmetricAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.SignUtil;

public class CertificateSignatureChecker
extends IssuerChecker {
    private static Logger e;
    private static final String[] f;
    private static final String[] g;

    @Override
    protected PathValidationResult _check(IssuerCheckParameters aConstraint, ECertificate aIssuerCertificate, ECertificate aCertificate, CertificateStatusInfo aCertStatusInfo) {
        String string = aCertificate.getSubject().stringValue();
        e.debug(CertificateSignatureChecker.b(30128, -8559) + string);
        boolean bl = IssuerChecker.d;
        PathValidationResult pathValidationResult = CertificateSignatureChecker.checkSignature(aIssuerCertificate, aCertificate, aConstraint, aCertStatusInfo);
        if (bl) {
            Checker.c = !Checker.c;
        }
        return pathValidationResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PathValidationResult checkSignature(ECertificate aIssuerCertificate, ECertificate aCertificate, IssuerCheckParameters aConstraint, CertificateStatusInfo aCertStatusInfo) {
        boolean bl;
        PublicKey publicKey;
        Asn1OpenType asn1OpenType;
        byte[] byArray = aCertificate.getSignatureValue();
        boolean bl2 = IssuerChecker.d;
        if (byArray.length == 0) {
            e.error(CertificateSignatureChecker.b(30130, -30451));
            aCertStatusInfo.addDetail(new CheckResult(CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_KONTROLU), CertificateSignatureCheckStatus.CERTIFICATE_NOT_SIGNED.getText(), CertificateSignatureCheckStatus.CERTIFICATE_NOT_SIGNED, false));
            return PathValidationResult.SIGNATURE_CONTROL_FAILURE;
        }
        byte[] byArray2 = aCertificate.getTBSEncodedBytes();
        ESubjectPublicKeyInfo eSubjectPublicKeyInfo = aIssuerCertificate.getSubjectPublicKeyInfo();
        EAlgorithmIdentifier eAlgorithmIdentifier = eSubjectPublicKeyInfo.getAlgorithm();
        try {
            byte[] byArray3;
            block19: {
                block20: {
                    byte[] byArray4;
                    if (!Arrays.equals(eAlgorithmIdentifier.getAlgorithm().value, AsymmetricAlg.DSA.getOID())) break block19;
                    asn1OpenType = eAlgorithmIdentifier.getParameters();
                    byte[] byArray5 = byArray4 = asn1OpenType != null ? asn1OpenType.value : null;
                    if (byArray4 != null && asn1OpenType.getLength() > 0 && !Arrays.equals(byArray4, EAlgorithmIdentifier.ASN_NULL)) break block20;
                    Asn1OpenType asn1OpenType2 = aConstraint.getPreviousDSAParams();
                    if (asn1OpenType2 == null || asn1OpenType2.value.length <= 0 || Arrays.equals(asn1OpenType2.value, EAlgorithmIdentifier.ASN_NULL)) {
                        e.error(CertificateSignatureChecker.b(30131, 10134));
                        aCertStatusInfo.addDetail(new CheckResult(CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_KONTROLU), CertificateSignatureCheckStatus.KRIPTO_ERROR_ON_VERIFICATION.getText(), CertificateSignatureCheckStatus.KRIPTO_ERROR_ON_VERIFICATION, false));
                        return PathValidationResult.SIGNATURE_CONTROL_FAILURE;
                    }
                    eSubjectPublicKeyInfo.getAlgorithm().setParameters(aConstraint.getPreviousDSAParams());
                    if (!bl2) break block19;
                }
                aConstraint.setPreviousDSAParams(eAlgorithmIdentifier.getParameters());
            }
            if ((byArray3 = eSubjectPublicKeyInfo.getEncoded()).length == 0) {
                e.error(CertificateSignatureChecker.b(30129, -18948));
                aCertStatusInfo.addDetail(new CheckResult(CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_KONTROLU), CertificateSignatureCheckStatus.NO_PUBLIC_KEY_IN_CERTIFICATE.getText(), CertificateSignatureCheckStatus.NO_PUBLIC_KEY_IN_CERTIFICATE, false));
                return PathValidationResult.SIGNATURE_CONTROL_FAILURE;
            }
            asn1OpenType = SignatureAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eSubjectPublicKeyInfo.getAlgorithm());
            AsymmetricAlg asymmetricAlg = ((SignatureAlg)asn1OpenType.first()).getAsymmetricAlg();
            publicKey = KeyUtil.decodePublicKey((AsymmetricAlg)asymmetricAlg, (byte[])byArray3);
        }
        catch (Exception exception) {
            e.error(CertificateSignatureChecker.b(30134, 25215), (Throwable)exception);
            aCertStatusInfo.addDetail(new CheckResult(CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_KONTROLU), CertificateSignatureCheckStatus.INVALID_PUBLIC_KEY_IN_CERTIFICATE.getText(), CertificateSignatureCheckStatus.INVALID_PUBLIC_KEY_IN_CERTIFICATE, false));
            return PathValidationResult.SIGNATURE_CONTROL_FAILURE;
        }
        try {
            asn1OpenType = aCertificate.getSignatureAlgorithm();
            Pair pair = SignatureAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)asn1OpenType);
            bl = SignUtil.verify((SignatureAlg)((SignatureAlg)pair.first()), (AlgorithmParams)((AlgorithmParams)pair.second()), (byte[])byArray2, (byte[])byArray, (PublicKey)publicKey);
        }
        catch (Exception exception) {
            e.error(CertificateSignatureChecker.b(30135, 17155), (Throwable)exception);
            aCertStatusInfo.addDetail(new CheckResult(CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_KONTROLU), CertificateSignatureCheckStatus.KRIPTO_ERROR_ON_VERIFICATION.getText(), CertificateSignatureCheckStatus.KRIPTO_ERROR_ON_VERIFICATION, false));
            return PathValidationResult.SIGNATURE_CONTROL_FAILURE;
        }
        if (bl) {
            e.debug(CertificateSignatureChecker.b(30132, 26012));
            aCertStatusInfo.addDetail(new CheckResult(CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_KONTROLU), CertificateSignatureCheckStatus.SIGNATURE_VERIFIED.getText(), CertificateSignatureCheckStatus.SIGNATURE_VERIFIED, true));
            return PathValidationResult.SUCCESS;
        }
        e.error(CertificateSignatureChecker.b(30133, 13239));
        aCertStatusInfo.addDetail(new CheckResult(CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_KONTROLU), CertificateSignatureCheckStatus.SIGNATURE_NOT_VERIFIED.getText(), CertificateSignatureCheckStatus.SIGNATURE_NOT_VERIFIED, false));
        return PathValidationResult.SIGNATURE_CONTROL_FAILURE;
    }

    @Override
    public String getCheckText() {
        return CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_KONTROLU);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[8];
                var3_1 = 0;
                var2_2 = "$c\rJ\u0003z\u0083)\u00f4\u00c1!\u0086\u00b5\u00bf\u0004\u007f\t\u0183&VZ\u00d7e\u0011\u01a5\u0013\u001dD\u00f4\u0001\u00b8\u0082$\u00b3\u00e2\u00f2\u00b8\u00e1\u00a9\u00adZ\u0007\u00c3i\u0114*\u00a4\u00db\u0089U\u00df\u00ff \u00f4\u01b6\u00ff2w\u00acg\u00b3NE*\u00ce\u00c1=\u009e\u0001`Y\u00ec\b;\u00fe\u00d1\u000f\u001dtC\u01bb_\u000e\u00e4\u0013\u001e\u008b\u017de\u017e\u00d2}\u00a4f\u00bf\u009cE-J\u00d8\u00ca\u00915\u017b\u00a6`\u00a7+\u00eb\u0097\u00f4\u00d4<\u00a9dS\b\u008e\u00beoF\u0082)\u018d\u00daY\u00e7\u0173\u00c2@\u00a9p!\u0185Z\u0002\u00b5\u0089\u009da\u0001\u0092\u00c2/\u00dbo\u0017\u01a4\u00e2\u009b/.\u000b\u0082\u00e8v\u00bf\u00fd\u0014\u00d9\u0006\u0091\u0127\b|\u0005a?O:\u0162\u00d5\u00feV\u0016\u00fe\u0088\u00bd\u00ee\u00db\u00fe\u009a\u00bdLa\u00a4NW\u0081]\u00fa#A\u00e1\u00cb \u008eE p\u0087\u0087\u00d6R\u00e9\u00a9[\u00b1\u008f\u0090W\u00a1\u0093\u00d4Q<\u00d51j\u0001\u00dd\u00c9U-\u0121\u0089\u0093\u00c7\u001c\u008d\u00d7";
                var4_3 = "$c\rJ\u0003z\u0083)\u00f4\u00c1!\u0086\u00b5\u00bf\u0004\u007f\t\u0183&VZ\u00d7e\u0011\u01a5\u0013\u001dD\u00f4\u0001\u00b8\u0082$\u00b3\u00e2\u00f2\u00b8\u00e1\u00a9\u00adZ\u0007\u00c3i\u0114*\u00a4\u00db\u0089U\u00df\u00ff \u00f4\u01b6\u00ff2w\u00acg\u00b3NE*\u00ce\u00c1=\u009e\u0001`Y\u00ec\b;\u00fe\u00d1\u000f\u001dtC\u01bb_\u000e\u00e4\u0013\u001e\u008b\u017de\u017e\u00d2}\u00a4f\u00bf\u009cE-J\u00d8\u00ca\u00915\u017b\u00a6`\u00a7+\u00eb\u0097\u00f4\u00d4<\u00a9dS\b\u008e\u00beoF\u0082)\u018d\u00daY\u00e7\u0173\u00c2@\u00a9p!\u0185Z\u0002\u00b5\u0089\u009da\u0001\u0092\u00c2/\u00dbo\u0017\u01a4\u00e2\u009b/.\u000b\u0082\u00e8v\u00bf\u00fd\u0014\u00d9\u0006\u0091\u0127\b|\u0005a?O:\u0162\u00d5\u00feV\u0016\u00fe\u0088\u00bd\u00ee\u00db\u00fe\u009a\u00bdLa\u00a4NW\u0081]\u00fa#A\u00e1\u00cb \u008eE p\u0087\u0087\u00d6R\u00e9\u00a9[\u00b1\u008f\u0090W\u00a1\u0093\u00d4Q<\u00d51j\u0001\u00dd\u00c9U-\u0121\u0089\u0093\u00c7\u001c\u008d\u00d7".length();
                var1_4 = 26;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "8\u0080\u008e6s\u00f5\u008d\u00d85\u00ff\u0019A\u00b2G\u00e4`\u001f\u0160\u00b8-y\u001e\u00a4P\u00c0J\u001cv\u00da\u0081\u00d9\u00fe\u00d19\u00b1\u00d7\u00dc\u00d5\u00d7\u008adZ\u00be)P\u00f4\u00f4\u0012\u0097l\u008a\u00d8\u008a\u0010\u01e3";
                    var4_3 = "8\u0080\u008e6s\u00f5\u008d\u00d85\u00ff\u0019A\u00b2G\u00e4`\u001f\u0160\u00b8-y\u001e\u00a4P\u00c0J\u001cv\u00da\u0081\u00d9\u00fe\u00d19\u00b1\u00d7\u00dc\u00d5\u00d7\u008adZ\u00be)P\u00f4\u00f4\u0012\u0097l\u008a\u00d8\u008a\u0010\u01e3".length();
                    var1_4 = 26;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 46;
                            break;
                        }
                        case 1: {
                            v13 = 36;
                            break;
                        }
                        case 2: {
                            v13 = 7;
                            break;
                        }
                        case 3: {
                            v13 = 31;
                            break;
                        }
                        case 4: {
                            v13 = 23;
                            break;
                        }
                        case 5: {
                            v13 = 76;
                            break;
                        }
                        default: {
                            v13 = 44;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        CertificateSignatureChecker.f = var5;
        CertificateSignatureChecker.g = new String[8];
        CertificateSignatureChecker.e = LoggerFactory.getLogger(CertificateSignatureChecker.class);
    }

    private static String b(int n, int n2) {
        int n3 = (n ^ 0x75B4) & 0xFFFF;
        if (g[n3] == null) {
            int n4;
            int n5;
            char[] cArray = f[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 226;
                    break;
                }
                case 1: {
                    n5 = 137;
                    break;
                }
                case 2: {
                    n5 = 181;
                    break;
                }
                case 3: {
                    n5 = 190;
                    break;
                }
                case 4: {
                    n5 = 68;
                    break;
                }
                case 5: {
                    n5 = 240;
                    break;
                }
                case 6: {
                    n5 = 209;
                    break;
                }
                case 7: {
                    n5 = 53;
                    break;
                }
                case 8: {
                    n5 = 119;
                    break;
                }
                case 9: {
                    n5 = 193;
                    break;
                }
                case 10: {
                    n5 = 67;
                    break;
                }
                case 11: {
                    n5 = 225;
                    break;
                }
                case 12: {
                    n5 = 61;
                    break;
                }
                case 13: {
                    n5 = 176;
                    break;
                }
                case 14: {
                    n5 = 182;
                    break;
                }
                case 15: {
                    n5 = 175;
                    break;
                }
                case 16: {
                    n5 = 102;
                    break;
                }
                case 17: {
                    n5 = 29;
                    break;
                }
                case 18: {
                    n5 = 134;
                    break;
                }
                case 19: {
                    n5 = 39;
                    break;
                }
                case 20: {
                    n5 = 113;
                    break;
                }
                case 21: {
                    n5 = 148;
                    break;
                }
                case 22: {
                    n5 = 200;
                    break;
                }
                case 23: {
                    n5 = 141;
                    break;
                }
                case 24: {
                    n5 = 169;
                    break;
                }
                case 25: {
                    n5 = 62;
                    break;
                }
                case 26: {
                    n5 = 223;
                    break;
                }
                case 27: {
                    n5 = 130;
                    break;
                }
                case 28: {
                    n5 = 40;
                    break;
                }
                case 29: {
                    n5 = 161;
                    break;
                }
                case 30: {
                    n5 = 202;
                    break;
                }
                case 31: {
                    n5 = 250;
                    break;
                }
                case 32: {
                    n5 = 192;
                    break;
                }
                case 33: {
                    n5 = 249;
                    break;
                }
                case 34: {
                    n5 = 60;
                    break;
                }
                case 35: {
                    n5 = 228;
                    break;
                }
                case 36: {
                    n5 = 172;
                    break;
                }
                case 37: {
                    n5 = 27;
                    break;
                }
                case 38: {
                    n5 = 154;
                    break;
                }
                case 39: {
                    n5 = 63;
                    break;
                }
                case 40: {
                    n5 = 204;
                    break;
                }
                case 41: {
                    n5 = 165;
                    break;
                }
                case 42: {
                    n5 = 246;
                    break;
                }
                case 43: {
                    n5 = 212;
                    break;
                }
                case 44: {
                    n5 = 158;
                    break;
                }
                case 45: {
                    n5 = 87;
                    break;
                }
                case 46: {
                    n5 = 1;
                    break;
                }
                case 47: {
                    n5 = 129;
                    break;
                }
                case 48: {
                    n5 = 42;
                    break;
                }
                case 49: {
                    n5 = 7;
                    break;
                }
                case 50: {
                    n5 = 152;
                    break;
                }
                case 51: {
                    n5 = 222;
                    break;
                }
                case 52: {
                    n5 = 64;
                    break;
                }
                case 53: {
                    n5 = 69;
                    break;
                }
                case 54: {
                    n5 = 232;
                    break;
                }
                case 55: {
                    n5 = 5;
                    break;
                }
                case 56: {
                    n5 = 168;
                    break;
                }
                case 57: {
                    n5 = 118;
                    break;
                }
                case 58: {
                    n5 = 179;
                    break;
                }
                case 59: {
                    n5 = 31;
                    break;
                }
                case 60: {
                    n5 = 26;
                    break;
                }
                case 61: {
                    n5 = 151;
                    break;
                }
                case 62: {
                    n5 = 51;
                    break;
                }
                case 63: {
                    n5 = 184;
                    break;
                }
                case 64: {
                    n5 = 247;
                    break;
                }
                case 65: {
                    n5 = 115;
                    break;
                }
                case 66: {
                    n5 = 132;
                    break;
                }
                case 67: {
                    n5 = 41;
                    break;
                }
                case 68: {
                    n5 = 206;
                    break;
                }
                case 69: {
                    n5 = 139;
                    break;
                }
                case 70: {
                    n5 = 163;
                    break;
                }
                case 71: {
                    n5 = 185;
                    break;
                }
                case 72: {
                    n5 = 128;
                    break;
                }
                case 73: {
                    n5 = 138;
                    break;
                }
                case 74: {
                    n5 = 166;
                    break;
                }
                case 75: {
                    n5 = 96;
                    break;
                }
                case 76: {
                    n5 = 112;
                    break;
                }
                case 77: {
                    n5 = 17;
                    break;
                }
                case 78: {
                    n5 = 153;
                    break;
                }
                case 79: {
                    n5 = 133;
                    break;
                }
                case 80: {
                    n5 = 235;
                    break;
                }
                case 81: {
                    n5 = 11;
                    break;
                }
                case 82: {
                    n5 = 171;
                    break;
                }
                case 83: {
                    n5 = 79;
                    break;
                }
                case 84: {
                    n5 = 34;
                    break;
                }
                case 85: {
                    n5 = 201;
                    break;
                }
                case 86: {
                    n5 = 219;
                    break;
                }
                case 87: {
                    n5 = 227;
                    break;
                }
                case 88: {
                    n5 = 122;
                    break;
                }
                case 89: {
                    n5 = 117;
                    break;
                }
                case 90: {
                    n5 = 82;
                    break;
                }
                case 91: {
                    n5 = 217;
                    break;
                }
                case 92: {
                    n5 = 236;
                    break;
                }
                case 93: {
                    n5 = 95;
                    break;
                }
                case 94: {
                    n5 = 239;
                    break;
                }
                case 95: {
                    n5 = 15;
                    break;
                }
                case 96: {
                    n5 = 149;
                    break;
                }
                case 97: {
                    n5 = 220;
                    break;
                }
                case 98: {
                    n5 = 159;
                    break;
                }
                case 99: {
                    n5 = 78;
                    break;
                }
                case 100: {
                    n5 = 229;
                    break;
                }
                case 101: {
                    n5 = 233;
                    break;
                }
                case 102: {
                    n5 = 100;
                    break;
                }
                case 103: {
                    n5 = 174;
                    break;
                }
                case 104: {
                    n5 = 167;
                    break;
                }
                case 105: {
                    n5 = 136;
                    break;
                }
                case 106: {
                    n5 = 126;
                    break;
                }
                case 107: {
                    n5 = 50;
                    break;
                }
                case 108: {
                    n5 = 101;
                    break;
                }
                case 109: {
                    n5 = 105;
                    break;
                }
                case 110: {
                    n5 = 10;
                    break;
                }
                case 111: {
                    n5 = 199;
                    break;
                }
                case 112: {
                    n5 = 106;
                    break;
                }
                case 113: {
                    n5 = 32;
                    break;
                }
                case 114: {
                    n5 = 20;
                    break;
                }
                case 115: {
                    n5 = 81;
                    break;
                }
                case 116: {
                    n5 = 183;
                    break;
                }
                case 117: {
                    n5 = 13;
                    break;
                }
                case 118: {
                    n5 = 242;
                    break;
                }
                case 119: {
                    n5 = 9;
                    break;
                }
                case 120: {
                    n5 = 94;
                    break;
                }
                case 121: {
                    n5 = 142;
                    break;
                }
                case 122: {
                    n5 = 255;
                    break;
                }
                case 123: {
                    n5 = 21;
                    break;
                }
                case 124: {
                    n5 = 33;
                    break;
                }
                case 125: {
                    n5 = 8;
                    break;
                }
                case 126: {
                    n5 = 49;
                    break;
                }
                case 127: {
                    n5 = 52;
                    break;
                }
                case 128: {
                    n5 = 147;
                    break;
                }
                case 129: {
                    n5 = 38;
                    break;
                }
                case 130: {
                    n5 = 89;
                    break;
                }
                case 131: {
                    n5 = 47;
                    break;
                }
                case 132: {
                    n5 = 71;
                    break;
                }
                case 133: {
                    n5 = 243;
                    break;
                }
                case 134: {
                    n5 = 210;
                    break;
                }
                case 135: {
                    n5 = 74;
                    break;
                }
                case 136: {
                    n5 = 205;
                    break;
                }
                case 137: {
                    n5 = 221;
                    break;
                }
                case 138: {
                    n5 = 189;
                    break;
                }
                case 139: {
                    n5 = 24;
                    break;
                }
                case 140: {
                    n5 = 116;
                    break;
                }
                case 141: {
                    n5 = 135;
                    break;
                }
                case 142: {
                    n5 = 188;
                    break;
                }
                case 143: {
                    n5 = 253;
                    break;
                }
                case 144: {
                    n5 = 83;
                    break;
                }
                case 145: {
                    n5 = 195;
                    break;
                }
                case 146: {
                    n5 = 84;
                    break;
                }
                case 147: {
                    n5 = 75;
                    break;
                }
                case 148: {
                    n5 = 144;
                    break;
                }
                case 149: {
                    n5 = 178;
                    break;
                }
                case 150: {
                    n5 = 99;
                    break;
                }
                case 151: {
                    n5 = 245;
                    break;
                }
                case 152: {
                    n5 = 187;
                    break;
                }
                case 153: {
                    n5 = 46;
                    break;
                }
                case 154: {
                    n5 = 196;
                    break;
                }
                case 155: {
                    n5 = 254;
                    break;
                }
                case 156: {
                    n5 = 215;
                    break;
                }
                case 157: {
                    n5 = 131;
                    break;
                }
                case 158: {
                    n5 = 177;
                    break;
                }
                case 159: {
                    n5 = 244;
                    break;
                }
                case 160: {
                    n5 = 22;
                    break;
                }
                case 161: {
                    n5 = 211;
                    break;
                }
                case 162: {
                    n5 = 35;
                    break;
                }
                case 163: {
                    n5 = 108;
                    break;
                }
                case 164: {
                    n5 = 45;
                    break;
                }
                case 165: {
                    n5 = 91;
                    break;
                }
                case 166: {
                    n5 = 54;
                    break;
                }
                case 167: {
                    n5 = 48;
                    break;
                }
                case 168: {
                    n5 = 14;
                    break;
                }
                case 169: {
                    n5 = 44;
                    break;
                }
                case 170: {
                    n5 = 90;
                    break;
                }
                case 171: {
                    n5 = 104;
                    break;
                }
                case 172: {
                    n5 = 157;
                    break;
                }
                case 173: {
                    n5 = 12;
                    break;
                }
                case 174: {
                    n5 = 214;
                    break;
                }
                case 175: {
                    n5 = 65;
                    break;
                }
                case 176: {
                    n5 = 103;
                    break;
                }
                case 177: {
                    n5 = 3;
                    break;
                }
                case 178: {
                    n5 = 143;
                    break;
                }
                case 179: {
                    n5 = 120;
                    break;
                }
                case 180: {
                    n5 = 124;
                    break;
                }
                case 181: {
                    n5 = 146;
                    break;
                }
                case 182: {
                    n5 = 86;
                    break;
                }
                case 183: {
                    n5 = 76;
                    break;
                }
                case 184: {
                    n5 = 59;
                    break;
                }
                case 185: {
                    n5 = 155;
                    break;
                }
                case 186: {
                    n5 = 251;
                    break;
                }
                case 187: {
                    n5 = 73;
                    break;
                }
                case 188: {
                    n5 = 55;
                    break;
                }
                case 189: {
                    n5 = 218;
                    break;
                }
                case 190: {
                    n5 = 77;
                    break;
                }
                case 191: {
                    n5 = 56;
                    break;
                }
                case 192: {
                    n5 = 88;
                    break;
                }
                case 193: {
                    n5 = 43;
                    break;
                }
                case 194: {
                    n5 = 19;
                    break;
                }
                case 195: {
                    n5 = 208;
                    break;
                }
                case 196: {
                    n5 = 180;
                    break;
                }
                case 197: {
                    n5 = 109;
                    break;
                }
                case 198: {
                    n5 = 97;
                    break;
                }
                case 199: {
                    n5 = 123;
                    break;
                }
                case 200: {
                    n5 = 125;
                    break;
                }
                case 201: {
                    n5 = 4;
                    break;
                }
                case 202: {
                    n5 = 127;
                    break;
                }
                case 203: {
                    n5 = 170;
                    break;
                }
                case 204: {
                    n5 = 58;
                    break;
                }
                case 205: {
                    n5 = 194;
                    break;
                }
                case 206: {
                    n5 = 237;
                    break;
                }
                case 207: {
                    n5 = 66;
                    break;
                }
                case 208: {
                    n5 = 231;
                    break;
                }
                case 209: {
                    n5 = 191;
                    break;
                }
                case 210: {
                    n5 = 198;
                    break;
                }
                case 211: {
                    n5 = 160;
                    break;
                }
                case 212: {
                    n5 = 150;
                    break;
                }
                case 213: {
                    n5 = 30;
                    break;
                }
                case 214: {
                    n5 = 37;
                    break;
                }
                case 215: {
                    n5 = 70;
                    break;
                }
                case 216: {
                    n5 = 145;
                    break;
                }
                case 217: {
                    n5 = 213;
                    break;
                }
                case 218: {
                    n5 = 80;
                    break;
                }
                case 219: {
                    n5 = 72;
                    break;
                }
                case 220: {
                    n5 = 2;
                    break;
                }
                case 221: {
                    n5 = 111;
                    break;
                }
                case 222: {
                    n5 = 6;
                    break;
                }
                case 223: {
                    n5 = 85;
                    break;
                }
                case 224: {
                    n5 = 114;
                    break;
                }
                case 225: {
                    n5 = 173;
                    break;
                }
                case 226: {
                    n5 = 107;
                    break;
                }
                case 227: {
                    n5 = 110;
                    break;
                }
                case 228: {
                    n5 = 92;
                    break;
                }
                case 229: {
                    n5 = 0;
                    break;
                }
                case 230: {
                    n5 = 156;
                    break;
                }
                case 231: {
                    n5 = 234;
                    break;
                }
                case 232: {
                    n5 = 238;
                    break;
                }
                case 233: {
                    n5 = 186;
                    break;
                }
                case 234: {
                    n5 = 121;
                    break;
                }
                case 235: {
                    n5 = 207;
                    break;
                }
                case 236: {
                    n5 = 18;
                    break;
                }
                case 237: {
                    n5 = 248;
                    break;
                }
                case 238: {
                    n5 = 93;
                    break;
                }
                case 239: {
                    n5 = 162;
                    break;
                }
                case 240: {
                    n5 = 197;
                    break;
                }
                case 241: {
                    n5 = 164;
                    break;
                }
                case 242: {
                    n5 = 241;
                    break;
                }
                case 243: {
                    n5 = 57;
                    break;
                }
                case 244: {
                    n5 = 216;
                    break;
                }
                case 245: {
                    n5 = 28;
                    break;
                }
                case 246: {
                    n5 = 36;
                    break;
                }
                case 247: {
                    n5 = 224;
                    break;
                }
                case 248: {
                    n5 = 25;
                    break;
                }
                case 249: {
                    n5 = 230;
                    break;
                }
                case 250: {
                    n5 = 203;
                    break;
                }
                case 251: {
                    n5 = 23;
                    break;
                }
                case 252: {
                    n5 = 98;
                    break;
                }
                case 253: {
                    n5 = 16;
                    break;
                }
                case 254: {
                    n5 = 140;
                    break;
                }
                default: {
                    n5 = 252;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            CertificateSignatureChecker.g[n3] = new String(cArray).intern();
        }
        return g[n3];
    }

    public static final class CertificateSignatureCheckStatus
    extends Enum<CertificateSignatureCheckStatus>
    implements CheckStatus {
        public static final /* enum */ CertificateSignatureCheckStatus CERTIFICATE_NOT_SIGNED;
        public static final /* enum */ CertificateSignatureCheckStatus CERTIFICATE_INVALID_STRUCTURE;
        public static final /* enum */ CertificateSignatureCheckStatus NO_PUBLIC_KEY_IN_CERTIFICATE;
        public static final /* enum */ CertificateSignatureCheckStatus INVALID_PUBLIC_KEY_IN_CERTIFICATE;
        public static final /* enum */ CertificateSignatureCheckStatus KRIPTO_ERROR_ON_VERIFICATION;
        public static final /* enum */ CertificateSignatureCheckStatus SIGNATURE_NOT_VERIFIED;
        public static final /* enum */ CertificateSignatureCheckStatus SIGNATURE_VERIFIED;
        private static final /* synthetic */ CertificateSignatureCheckStatus[] a;

        public static CertificateSignatureCheckStatus[] values() {
            return (CertificateSignatureCheckStatus[])a.clone();
        }

        public static CertificateSignatureCheckStatus valueOf(String name) {
            return Enum.valueOf(CertificateSignatureCheckStatus.class, name);
        }

        @Override
        public String getText() {
            switch (this) {
                case CERTIFICATE_NOT_SIGNED: {
                    return CertI18n.message((String)CertI18n.SERTIFIKA_IMZALI_DEGIL);
                }
                case CERTIFICATE_INVALID_STRUCTURE: {
                    return CertI18n.message((String)CertI18n.SERTIFIKA_YAPISI_BOZUK);
                }
                case NO_PUBLIC_KEY_IN_CERTIFICATE: {
                    return CertI18n.message((String)CertI18n.SERTIFIKADA_ACIK_ANAHTAR_YOK);
                }
                case INVALID_PUBLIC_KEY_IN_CERTIFICATE: {
                    return CertI18n.message((String)CertI18n.SERTIFIKADA_ACIK_ANAHTAR_BOZUK);
                }
                case KRIPTO_ERROR_ON_VERIFICATION: {
                    return CertI18n.message((String)CertI18n.DOGRULAMA_KRIPTO_HATASI);
                }
                case SIGNATURE_NOT_VERIFIED: {
                    return CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_DOGRULANAMADI);
                }
                case SIGNATURE_VERIFIED: {
                    return CertI18n.message((String)CertI18n.SERTIFIKA_IMZA_DOGRULANDI);
                }
            }
            return CertI18n.message((String)CertI18n.KONTROL_SONUCU);
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var6 = new String[7];
                    var4_1 = 0;
                    var3_2 = "D(c\u001eO&\u0015E${\u0006K \tQ(a\u0014\u0016D(c\u001eO&\u0015E${\u001eA&\u001fA$v\u0019H;\u0005S\u0016T$v\u0004G4\tT p\u0015Q<\u000fC>w\u0019I<\u0005S\u001dT$v\u0004G4\tT p\u0015Q;\u000eA h\u0019J-\u0013C3q\u0013Z'\u0012R\u001cY.{\u0000[0\f^\"{\u001bK+\u001f^/{\u0013K \u0014^'m\u0013O&\u0005";
                    var5_3 = "D(c\u001eO&\u0015E${\u0006K \tQ(a\u0014\u0016D(c\u001eO&\u0015E${\u001eA&\u001fA$v\u0019H;\u0005S\u0016T$v\u0004G4\tT p\u0015Q<\u000fC>w\u0019I<\u0005S\u001dT$v\u0004G4\tT p\u0015Q;\u000eA h\u0019J-\u0013C3q\u0013Z'\u0012R\u001cY.{\u0000[0\f^\"{\u001bK+\u001f^/{\u0013K \u0014^'m\u0013O&\u0005".length();
                    var2_4 = 18;
                    var1_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = ++var1_5;
                        v1 = var3_2.substring(v0, v0 + var2_4);
                        v2 = -1;
                        break block19;
                        break;
                    }
lbl12:
                    // 1 sources

                    while (true) {
                        var6[var4_1++] = v3.intern();
                        if ((var1_5 += var2_4) < var5_3) {
                            var2_4 = var3_2.charAt(var1_5);
                            ** continue;
                        }
                        var3_2 = "^/r\u0011B;\u0004H1q\u0012B;\u0003H*a\tQ;\u000eH\"a\u0002Z;\u0006^\"e\u0004K\u001c\\3m\u0000Z=\u001fR3v\u001f\\-\u000fY>r\u0015\\;\u0006^\"e\u0004G=\u000e";
                        var5_3 = "^/r\u0011B;\u0004H1q\u0012B;\u0003H*a\tQ;\u000eH\"a\u0002Z;\u0006^\"e\u0004K\u001c\\3m\u0000Z=\u001fR3v\u001f\\-\u000fY>r\u0015\\;\u0006^\"e\u0004G=\u000e".length();
                        var2_4 = 33;
                        var1_5 = -1;
lbl21:
                        // 2 sources

                        while (true) {
                            v4 = ++var1_5;
                            v1 = var3_2.substring(v4, v4 + var2_4);
                            v2 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl26:
                    // 1 sources

                    while (true) {
                        var6[var4_1++] = v3.intern();
                        if ((var1_5 += var2_4) < var5_3) {
                            var2_4 = var3_2.charAt(var1_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v5 = v1.toCharArray();
                var7_6 = 0;
                v6 = v5.length;
                v7 = v5;
                v8 = v6;
                if (v6 > 1) ** GOTO lbl76
                do {
                    v9 = v7;
                    v10 = v7;
                    v11 = var7_6;
                    while (true) {
                        v12 = v9[v11];
                        switch (var7_6 % 7) {
                            case 0: {
                                v13 = 23;
                                break;
                            }
                            case 1: {
                                v13 = 97;
                                break;
                            }
                            case 2: {
                                v13 = 36;
                                break;
                            }
                            case 3: {
                                v13 = 80;
                                break;
                            }
                            case 4: {
                                v13 = 14;
                                break;
                            }
                            case 5: {
                                v13 = 114;
                                break;
                            }
                            default: {
                                v13 = 64;
                            }
                        }
                        v9[v11] = (char)(v12 ^ v13);
                        ++var7_6;
                        v7 = v10;
                        v8 = v8;
                        if (v8 != 0) break;
                        v10 = v7;
                        v14 = v8;
                        v11 = v8;
                        v9 = v7;
                    }
lbl76:
                    // 2 sources

                    v15 = v7;
                    v14 = v8;
                } while (v8 > var7_6);
                v3 = new String(v15);
                switch (v2) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl85:
                    // 1 sources

                    ** continue;
                }
            }
            var0_7 = var6;
            CertificateSignatureCheckStatus.CERTIFICATE_NOT_SIGNED = new CertificateSignatureCheckStatus();
            CertificateSignatureCheckStatus.CERTIFICATE_INVALID_STRUCTURE = new CertificateSignatureCheckStatus();
            CertificateSignatureCheckStatus.NO_PUBLIC_KEY_IN_CERTIFICATE = new CertificateSignatureCheckStatus();
            CertificateSignatureCheckStatus.INVALID_PUBLIC_KEY_IN_CERTIFICATE = new CertificateSignatureCheckStatus();
            CertificateSignatureCheckStatus.KRIPTO_ERROR_ON_VERIFICATION = new CertificateSignatureCheckStatus();
            CertificateSignatureCheckStatus.SIGNATURE_NOT_VERIFIED = new CertificateSignatureCheckStatus();
            CertificateSignatureCheckStatus.SIGNATURE_VERIFIED = new CertificateSignatureCheckStatus();
            CertificateSignatureCheckStatus.a = new CertificateSignatureCheckStatus[]{CertificateSignatureCheckStatus.CERTIFICATE_NOT_SIGNED, CertificateSignatureCheckStatus.CERTIFICATE_INVALID_STRUCTURE, CertificateSignatureCheckStatus.NO_PUBLIC_KEY_IN_CERTIFICATE, CertificateSignatureCheckStatus.INVALID_PUBLIC_KEY_IN_CERTIFICATE, CertificateSignatureCheckStatus.KRIPTO_ERROR_ON_VERIFICATION, CertificateSignatureCheckStatus.SIGNATURE_NOT_VERIFIED, CertificateSignatureCheckStatus.SIGNATURE_VERIFIED};
        }
    }
}

