/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.smyy.utils;

import com.turktrust.asn1.Any;
import com.turktrust.asn1.BitString;
import com.turktrust.asn1.GeneralizedTime;
import com.turktrust.asn1.Null;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.UTCTime;
import com.turktrust.smyy.utils.ImzaFabrikasi;
import com.turktrust.x509.AlgorithmIdentifier;
import com.turktrust.x509.BasicConstraints;
import com.turktrust.x509.Certificate;
import com.turktrust.x509.CertificateSerialNumber;
import com.turktrust.x509.Extensions;
import com.turktrust.x509.Name;
import com.turktrust.x509.SubjectPublicKeyInfo;
import com.turktrust.x509.TBSCertificate;
import com.turktrust.x509.Time;
import com.turktrust.x509.Validity;
import com.turktrust.x509.Version;
import java.io.FileInputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.Vector;

public class SertifikaFabrikasi {
    private static final int iterationCount = 2000;

    public static KeyPair generateKeyPair(int keySize) {
        try {
            KeyPairGenerator rsakpg = KeyPairGenerator.getInstance("RSA");
            SecureRandom srand = SecureRandom.getInstance("SHA1PRNG");
            rsakpg.initialize(keySize, srand);
            return rsakpg.generateKeyPair();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static Certificate generateSelfSignedCertificate(String serialNoStr, Name subjectDN, KeyPair subjectKeyPair, int validityInDays) {
        return SertifikaFabrikasi.generateCertificate(serialNoStr, subjectDN, subjectKeyPair.getPublic(), validityInDays, false, subjectDN, subjectKeyPair.getPrivate(), subjectKeyPair.getPublic());
    }

    public static Certificate generateCertificate(String serialNoStr, Name subjectDN, PublicKey subjectPublicKey, int validityInDays, boolean endEntity, Certificate issuerCert, PrivateKey issuerPrivKey) {
        try {
            Name issuerDN = issuerCert.gettbsCertificate().getissuer();
            byte[] issuerSpkiBytes = issuerCert.gettbsCertificate().getsubjectPublicKeyInfo().getEncoded();
            X509EncodedKeySpec xspec = new X509EncodedKeySpec(issuerSpkiBytes);
            KeyFactory keyFac = KeyFactory.getInstance("RSA");
            PublicKey issuerPubKey = keyFac.generatePublic(xspec);
            return SertifikaFabrikasi.generateCertificate(serialNoStr, subjectDN, subjectPublicKey, validityInDays, endEntity, issuerDN, issuerPrivKey, issuerPubKey);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static Certificate generateCertificate(String serialNoStr, Name subjectDN, PublicKey subjectPublicKey, int validityInDays, boolean endEntity, Name issuerDN, PrivateKey issuerPrivKey, PublicKey issuerPublicKey) {
        try {
            Extensions extensions = new Extensions("extensions");
            BasicConstraints bc = null;
            bc = new BasicConstraints("bc", false, !endEntity);
            extensions.addElement(bc);
            TBSCertificate tbsCert = SertifikaFabrikasi.generateTBSCertificate(serialNoStr, subjectDN, subjectPublicKey, validityInDays, issuerDN, extensions);
            return SertifikaFabrikasi.signTBSCertificate(tbsCert, issuerPrivKey);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static TBSCertificate generateTBSCertificate(String serialNoStr, Name subjectDN, PublicKey subjectPublicKey, int validityInDays, Name issuerDN, Extensions extensions) {
        CertificateSerialNumber serial = new CertificateSerialNumber("serial");
        serial.setValue(serialNoStr);
        ObjectID sha1_rsa_objId = new ObjectID("SHA1WithRSA");
        sha1_rsa_objId.setValue("1.2.840.113549.1.1.5");
        Null parNull = new Null("Null_par");
        Any anyNull = new Any("Any_null");
        anyNull.setValue(parNull);
        AlgorithmIdentifier algId = new AlgorithmIdentifier("SHA1_RSA");
        algId.setalgorithm(sha1_rsa_objId);
        algId.setparameters(anyNull);
        algId.commitElementUpdate();
        Validity valid = new Validity("Cert_validity");
        Time valStart = new Time("Start");
        Time valFinish = new Time("Finish");
        Date now = new Date();
        Date finish = (Date)now.clone();
        finish.setTime(finish.getTime() + (long)validityInDays * 86400000L);
        UTCTime utcStart = new UTCTime("now", now);
        UTCTime utcFinish = new UTCTime("finish", finish);
        valStart.setValue(utcStart);
        valFinish.setValue(utcFinish);
        valid.setnotBefore(valStart);
        valid.setnotAfter(valFinish);
        valid.commitElementUpdate();
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo("spki");
        try {
            spki.decode(subjectPublicKey.getEncoded());
        }
        catch (Exception exc) {
            return null;
        }
        Version ver = new Version("X509 version");
        if (((Vector)extensions.getValue()).size() > 0) {
            ver.setValue(Integer.toString(2));
        } else {
            ver.setValue(Integer.toString(0));
        }
        TBSCertificate tbsCert = new TBSCertificate("tbsCert");
        tbsCert.setversion(ver);
        tbsCert.setserialNumber(serial);
        tbsCert.setsignature(algId);
        tbsCert.setissuer(issuerDN);
        tbsCert.setvalidity(valid);
        tbsCert.setsubject(subjectDN);
        tbsCert.setsubjectPublicKeyInfo(spki);
        if (((Vector)extensions.getValue()).size() > 0) {
            tbsCert.setextensions(extensions);
        }
        tbsCert.commitElementUpdate();
        return tbsCert;
    }

    public static Certificate signTBSCertificate(TBSCertificate tbsCert, PrivateKey issuerPrivKey) {
        try {
            ObjectID sha1_rsa_objId = new ObjectID("SHA1WithRSA");
            sha1_rsa_objId.setValue("1.2.840.113549.1.1.5");
            Null parNull = new Null("Null_par");
            Any anyNull = new Any("Any_null");
            anyNull.setValue(parNull);
            AlgorithmIdentifier algId = new AlgorithmIdentifier("SHA1_RSA");
            algId.setalgorithm(sha1_rsa_objId);
            algId.setparameters(anyNull);
            algId.commitElementUpdate();
            byte[] tbsBytes = tbsCert.getEncoded();
            Signature signer = Signature.getInstance("SHA1withRSA");
            signer.initSign(issuerPrivKey);
            signer.update(tbsBytes);
            byte[] sigBytes = signer.sign();
            BitString signBitString = new BitString("signature");
            signBitString.setValue(sigBytes);
            Certificate cert = new Certificate("cert");
            cert.settbsCertificate(tbsCert);
            cert.setsignatureAlgorithm(algId);
            cert.setsignature(signBitString);
            cert.commitElementUpdate();
            return cert;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static boolean verifyCertificate(Certificate toBeVerifiedCert, Certificate issuerCert) {
        try {
            byte[] tbsBytes = toBeVerifiedCert.gettbsCertificate().getEncoded();
            byte[] signatureBytes = (byte[])toBeVerifiedCert.getsignature().getValue();
            byte[] issuerSpkiBytes = issuerCert.gettbsCertificate().getsubjectPublicKeyInfo().getEncoded();
            X509EncodedKeySpec xspec = new X509EncodedKeySpec(issuerSpkiBytes);
            KeyFactory keyFac = KeyFactory.getInstance("RSA");
            PublicKey issuerPubKey = keyFac.generatePublic(xspec);
            ObjectID signAlgObjId = toBeVerifiedCert.getsignatureAlgorithm().getalgorithm();
            if (!ImzaFabrikasi.verifyPKCS1SignatureWithAlgorithmCheck(signatureBytes, issuerPubKey, tbsBytes, (String)signAlgObjId.getValue())) {
                return false;
            }
            Name issuerFromChild = toBeVerifiedCert.gettbsCertificate().getissuer();
            Name subjectFromParent = issuerCert.gettbsCertificate().getsubject();
            byte[] ifcBytes = issuerFromChild.getEncoded();
            byte[] sfpBytes = subjectFromParent.getEncoded();
            return SertifikaFabrikasi.areByteArraysEqual(ifcBytes, sfpBytes);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    public static boolean isCertificateValidAtGivenDate(Certificate cert, Date checkDate) {
        try {
            Date notBefore = (Date)((UTCTime)cert.gettbsCertificate().getvalidity().getnotBefore().getValue()).getValue();
            Date notAfter = (Date)((UTCTime)cert.gettbsCertificate().getvalidity().getnotAfter().getValue()).getValue();
            return checkDate.after(notBefore) && checkDate.before(notAfter);
        }
        catch (Exception exc) {
            try {
                Date notBefore = (Date)((GeneralizedTime)cert.gettbsCertificate().getvalidity().getnotBefore().getValue()).getValue();
                Date notAfter = (Date)((GeneralizedTime)cert.gettbsCertificate().getvalidity().getnotAfter().getValue()).getValue();
                return checkDate.after(notBefore) && checkDate.before(notAfter);
            }
            catch (Exception exc2) {
                exc2.printStackTrace();
                return false;
            }
        }
    }

    private static boolean areByteArraysEqual(byte[] bar1, byte[] bar2) {
        if (bar1.length != bar2.length) {
            return false;
        }
        for (int i = 0; i < bar1.length; ++i) {
            if (bar1[i] == bar2[i]) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            FileInputStream fis = new FileInputStream("/export/home/turktrust_docs/asil_kokler/10_TURKTRUST_Elektronik_Islem_Hizmetleri.crt");
            byte[] kokBytes = new byte[fis.available()];
            fis.read(kokBytes);
            fis.close();
            Certificate kokCert = new Certificate("kokCert");
            kokCert.decode(kokBytes);
            FileInputStream fis2 = new FileInputStream("/export/home/turktrust_docs/asil_kokler/11_TURKTRUST_Zaman_Damgasi_Hizmetleri.crt");
            byte[] altkokBytes = new byte[fis2.available()];
            fis2.read(altkokBytes);
            fis2.close();
            Certificate altkokCert = new Certificate("altkokCert");
            altkokBytes[15] = 7;
            altkokCert.decode(altkokBytes);
            System.out.println("Verif result = " + SertifikaFabrikasi.verifyCertificate(altkokCert, kokCert));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

