/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.xmlsignature.validator;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResult;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.ValidationResultType;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignature;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.XMLSignatureException;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.SignatureTimeStamp;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.SignedDataObjectProperties;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.SignedSignatureProperties;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.UnsignedSignatureProperties;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.timestamp.EncapsulatedTimeStamp;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.model.xades.timestamp.XAdESTimeStamp;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.util.I18n;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.validator.EncapsulatedTimeStampValidator;
import tr.gov.tubitak.uekae.esya.api.xmlsignature.validator.Validator;

public abstract class BaseTimeStampValidator
implements Validator {
    public static final int MILLIS_IN_SECONDS = 1000;
    private static Logger a;
    public static boolean b;
    private static final String[] d;
    private static final String[] e;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ValidationResult validate(XMLSignature aSignature, ECertificate aCertificate) throws XMLSignatureException {
        List<? extends XAdESTimeStamp> list = this.a(aSignature);
        boolean bl = b;
        if (list == null || list.size() < 1) {
            return null;
        }
        ValidationResult validationResult = new ValidationResult(this.getClass());
        for (XAdESTimeStamp xAdESTimeStamp : list) {
            a.debug(BaseTimeStampValidator.a(19256, 14863) + xAdESTimeStamp.getLocalName() + BaseTimeStampValidator.a(19261, -28873) + aSignature.getId());
            byte[] byArray = xAdESTimeStamp.getContentForTimeStamp(aSignature);
            if (xAdESTimeStamp.getEncapsulatedTimeStampCount() < 1) {
                return new ValidationResult(ValidationResultType.INVALID, I18n.translate(BaseTimeStampValidator.a(19236, 27022), this.a()), I18n.translate(BaseTimeStampValidator.a(19248, 13705), this.a()), null, this.getClass());
            }
            for (int i = 0; i < xAdESTimeStamp.getEncapsulatedTimeStampCount(); ++i) {
                EncapsulatedTimeStamp encapsulatedTimeStamp = xAdESTimeStamp.getEncapsulatedTimeStamp(i);
                try {
                    if (!encapsulatedTimeStamp.isTimeStamp()) {
                        return new ValidationResult(ValidationResultType.INVALID, I18n.translate(BaseTimeStampValidator.a(19236, 27022), this.a()), I18n.translate(BaseTimeStampValidator.a(19257, -10239), this.a(), i), null, this.getClass());
                    }
                    byte[] byArray2 = DigestUtil.digest((DigestAlg)encapsulatedTimeStamp.getDigestAlgorithm(), (byte[])byArray);
                    if (!Arrays.equals(byArray2, encapsulatedTimeStamp.getDigestValue())) {
                        return new ValidationResult(ValidationResultType.INVALID, I18n.translate(BaseTimeStampValidator.a(19236, 27022), this.a()), I18n.translate(BaseTimeStampValidator.a(19259, -32646), this.a(), i), null, this.getClass());
                    }
                    boolean bl2 = this.a(validationResult, encapsulatedTimeStamp.getTime(), encapsulatedTimeStamp, i, xAdESTimeStamp, aSignature, aCertificate);
                    if (!bl2) {
                        validationResult.setStatus(ValidationResultType.INVALID, I18n.translate(BaseTimeStampValidator.a(19236, 27022), this.a()), I18n.translate(BaseTimeStampValidator.a(19249, -18513), new Object[0]), null);
                        return validationResult;
                    }
                    ValidationResult validationResult2 = this.verifySignature(aSignature, xAdESTimeStamp, encapsulatedTimeStamp);
                    validationResult.addItem(validationResult2);
                    if (validationResult2.getType() != ValidationResultType.VALID) {
                        validationResult.setStatus(ValidationResultType.INVALID, I18n.translate(BaseTimeStampValidator.a(19236, 27022), this.a()), I18n.translate(BaseTimeStampValidator.a(19263, 10025), this.a(), i), null);
                        return validationResult2;
                    }
                    ++i;
                    continue;
                }
                catch (Exception exception) {
                    throw new XMLSignatureException(exception, BaseTimeStampValidator.a(19250, 16042), this.a(), i);
                }
            }
            if (!bl) continue;
        }
        validationResult.setStatus(ValidationResultType.VALID, I18n.translate(BaseTimeStampValidator.a(19236, 27022), this.a()), I18n.translate(BaseTimeStampValidator.a(19252, -27517), this.a()), null);
        return validationResult;
    }

    protected ValidationResult verifySignature(XMLSignature signature, XAdESTimeStamp aXAdESTimeStamp, EncapsulatedTimeStamp aTimeStamp) {
        ValidationResult validationResult = new ValidationResult(this.getClass());
        try {
            XAdESTimeStamp xAdESTimeStamp = this.a(aXAdESTimeStamp, signature);
            EncapsulatedTimeStampValidator encapsulatedTimeStampValidator = new EncapsulatedTimeStampValidator(signature, aXAdESTimeStamp);
            EncapsulatedTimeStampValidator encapsulatedTimeStampValidator2 = encapsulatedTimeStampValidator;
            EncapsulatedTimeStamp encapsulatedTimeStamp = aTimeStamp;
            Calendar calendar = xAdESTimeStamp != null ? xAdESTimeStamp.getEncapsulatedTimeStamp(0).getTime() : null;
            return encapsulatedTimeStampValidator2.verify(encapsulatedTimeStamp, calendar);
        }
        catch (Exception exception) {
            a.error(BaseTimeStampValidator.a(19258, -31947), (Throwable)exception);
            validationResult.setStatus(ValidationResultType.INCOMPLETE, I18n.translate(BaseTimeStampValidator.a(19236, 27022), this.a()), I18n.translate(BaseTimeStampValidator.a(19254, -20180), new Object[0]), exception.getMessage());
            return validationResult;
        }
    }

    abstract List<? extends XAdESTimeStamp> a(XMLSignature var1);

    abstract XAdESTimeStamp a(XAdESTimeStamp var1, XMLSignature var2) throws XMLSignatureException;

    abstract boolean a(ValidationResult var1, Calendar var2, EncapsulatedTimeStamp var3, int var4, XAdESTimeStamp var5, XMLSignature var6, ECertificate var7) throws XMLSignatureException;

    abstract String a();

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    protected boolean checkTimestampVsSigningTime(Calendar aTime, int aTSIndex, XMLSignature aSignature, ValidationResult aResult) {
        int n;
        long l;
        long l2;
        long l3;
        SignedSignatureProperties signedSignatureProperties = aSignature.getQualifyingProperties().getSignedSignatureProperties();
        int n2 = aSignature.getContext().getConfig().getValidationConfig().getSignatureTimeToleranceInSeconds();
        if (signedSignatureProperties != null && signedSignatureProperties.getSigningTime() != null && (l3 = aTime.getTimeInMillis()) < (l2 = (l = signedSignatureProperties.getSigningTime().toGregorianCalendar().getTimeInMillis()) - (long)(n = n2 * 1000))) {
            aResult.addItem(new ValidationResult(ValidationResultType.INVALID, I18n.translate(BaseTimeStampValidator.a(19260, -5144), this.a()), I18n.translate(BaseTimeStampValidator.a(19255, 9892), this.a(), aTSIndex, aTime.getTime(), signedSignatureProperties.getSigningTime().toGregorianCalendar().getTime()), null, this.getClass()));
            return false;
        }
        return true;
    }

    protected boolean checkTimestampVsSigningCertificate(Calendar aTime, int aTSIndex, ECertificate aCertificate, ValidationResult aResult) {
        Calendar calendar = aCertificate.getNotBefore();
        Calendar calendar2 = aCertificate.getNotAfter();
        if (aTime.after(calendar2) || aTime.before(calendar)) {
            aResult.addItem(new ValidationResult(ValidationResultType.INVALID, I18n.translate(BaseTimeStampValidator.a(19236, 27022), this.a()), I18n.translate(BaseTimeStampValidator.a(19262, -7843), this.a(), aTSIndex, aTime.getTime()), null, this.getClass()));
            return false;
        }
        return true;
    }

    protected boolean checkTimestampVsDataObjectTimestamps(Calendar aTime, int aTSIndex, XMLSignature aSignature, ValidationResult aResult) {
        EncapsulatedTimeStamp encapsulatedTimeStamp;
        int n;
        XAdESTimeStamp xAdESTimeStamp;
        int n2;
        boolean bl = true;
        SignedDataObjectProperties signedDataObjectProperties = aSignature.getQualifyingProperties().getSignedDataObjectProperties();
        boolean bl2 = b;
        if (signedDataObjectProperties == null) {
            return bl;
        }
        for (n2 = 0; n2 < signedDataObjectProperties.getAllDataObjectsTimeStampCount(); ++n2) {
            xAdESTimeStamp = signedDataObjectProperties.getAllDataObjectsTimeStamp(n2);
            for (n = 0; n < xAdESTimeStamp.getEncapsulatedTimeStampCount(); ++n) {
                encapsulatedTimeStamp = xAdESTimeStamp.getEncapsulatedTimeStamp(n);
                bl &= this.checkTimestampVsPreviousTimestamp(aTime, aTSIndex, encapsulatedTimeStamp, xAdESTimeStamp, aResult);
                if (!bl2) continue;
            }
            if (!bl2) continue;
        }
        for (n2 = 0; n2 < signedDataObjectProperties.getIndividualDataObjectsTimeStampCount(); ++n2) {
            xAdESTimeStamp = signedDataObjectProperties.getIndividualDataObjectsTimeStamp(n2);
            for (n = 0; n < xAdESTimeStamp.getEncapsulatedTimeStampCount(); ++n) {
                encapsulatedTimeStamp = xAdESTimeStamp.getEncapsulatedTimeStamp(n);
                bl &= this.checkTimestampVsPreviousTimestamp(aTime, aTSIndex, encapsulatedTimeStamp, xAdESTimeStamp, aResult);
                if (!bl2) continue;
            }
            if (!bl2) continue;
        }
        return bl;
    }

    protected boolean checkTimestampVsRefTimestamps(Calendar aTime, int aTSIndex, XMLSignature aSignature, ValidationResult aResult) {
        EncapsulatedTimeStamp encapsulatedTimeStamp;
        int n;
        XAdESTimeStamp xAdESTimeStamp;
        int n2;
        boolean bl = true;
        UnsignedSignatureProperties unsignedSignatureProperties = aSignature.getQualifyingProperties().getUnsignedSignatureProperties();
        boolean bl2 = b;
        if (unsignedSignatureProperties == null) {
            return bl;
        }
        for (n2 = 0; n2 < unsignedSignatureProperties.getRefsOnlyTimeStampCount(); ++n2) {
            xAdESTimeStamp = unsignedSignatureProperties.getRefsOnlyTimeStamp(n2);
            for (n = 0; n < xAdESTimeStamp.getEncapsulatedTimeStampCount(); ++n) {
                encapsulatedTimeStamp = xAdESTimeStamp.getEncapsulatedTimeStamp(n);
                bl &= this.checkTimestampVsPreviousTimestamp(aTime, aTSIndex, encapsulatedTimeStamp, xAdESTimeStamp, aResult);
                if (!bl2) continue;
            }
            if (!bl2) continue;
        }
        for (n2 = 0; n2 < unsignedSignatureProperties.getSigAndRefsTimeStampCount(); ++n2) {
            xAdESTimeStamp = unsignedSignatureProperties.getSigAndRefsTimeStamp(n2);
            for (n = 0; n < xAdESTimeStamp.getEncapsulatedTimeStampCount(); ++n) {
                encapsulatedTimeStamp = xAdESTimeStamp.getEncapsulatedTimeStamp(n);
                bl &= this.checkTimestampVsPreviousTimestamp(aTime, aTSIndex, encapsulatedTimeStamp, xAdESTimeStamp, aResult);
                if (!bl2) continue;
            }
            if (!bl2) continue;
        }
        return bl;
    }

    protected boolean checkTimestampVsSignatureTimestamp(Calendar aTime, int aTSIndex, XMLSignature aSignature, ValidationResult aResult) {
        boolean bl = true;
        UnsignedSignatureProperties unsignedSignatureProperties = aSignature.getQualifyingProperties().getUnsignedSignatureProperties();
        boolean bl2 = b;
        if (unsignedSignatureProperties == null) {
            return bl;
        }
        for (int i = 0; i < unsignedSignatureProperties.getSignatureTimeStampCount(); ++i) {
            SignatureTimeStamp signatureTimeStamp = unsignedSignatureProperties.getSignatureTimeStamp(i);
            for (int j = 0; j < signatureTimeStamp.getEncapsulatedTimeStampCount(); ++j) {
                EncapsulatedTimeStamp encapsulatedTimeStamp = signatureTimeStamp.getEncapsulatedTimeStamp(j);
                bl &= this.checkTimestampVsPreviousTimestamp(aTime, aTSIndex, encapsulatedTimeStamp, signatureTimeStamp, aResult);
                if (!bl2) continue;
            }
            if (!bl2) continue;
        }
        return bl;
    }

    protected boolean checkTimestampVsPreviousTimestamp(Calendar aTime, int aTSIndex, EncapsulatedTimeStamp aPreviousTS, XAdESTimeStamp aPreviousNode, ValidationResult aResult) {
        Calendar calendar;
        try {
            calendar = aPreviousTS.getTime();
        }
        catch (Exception exception) {
            a.warn(BaseTimeStampValidator.a(19237, -4870), (Throwable)exception);
            aResult.addItem(new ValidationResult(ValidationResultType.INVALID, I18n.translate(BaseTimeStampValidator.a(19236, 27022), this.a()), exception.getMessage() + BaseTimeStampValidator.a(19253, 11289) + aPreviousNode.getLocalName(), null, this.getClass()));
            return false;
        }
        if (aTime.before(calendar)) {
            aResult.addItem(new ValidationResult(ValidationResultType.INVALID, I18n.translate(BaseTimeStampValidator.a(19236, 27022), this.a()), I18n.translate(BaseTimeStampValidator.a(19251, -23729), this.a(), aTSIndex, aTime.getTime(), aPreviousNode.getLocalName(), calendar.getTime()), null, this.getClass()));
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[18];
                var3_1 = 0;
                var2_2 = ".\u00ab\u0010\u001aq\u00f9+_#]\u00e8\u0097\u0010\t\u00ea5L!\u00b0\u000fz\u00d9\u001b\u0095\u009d\u00a2\u00a1QTl,\u0010\u00e9\u0007]\u00a6\u001dX\u009f\u0006\b(\u0015\u0014%\u00bb\u008f\u001b\u00c97\u0097\u0018\u00f7\u0011N_\u00eb\u00e7%HP~\u0096\u00eb.\u00cd\u0083\u000bC\u00e8\u0088y\u00e3\u0084\u00c50\u00e5\u0011\u00b9Bq\u00fe\u00a2\u00e3Y\u0087\u00c3\u00e4i\u001b\u0014H\u00ee1\u0089\u0088\u00cf\u0004\u00e3+\u0012L\u0006\u00a1P\u0012\u00c9\u00b9tn>\u008fr\u00e9/\u0085R5x\u00f9\u000f\u00e4qA\u001f\u0080\u00f3\u0015\u001e\u00e4u\u0010\u0092\u000f\u00a9\t!0\u00a3?_\u008b\u00d3%\u00d4Z\u0095VDB,<\u00823\u009a\n\u001d\u00ea\u00edX\u00ddM\r%\u009d\u00a9H\u00dd\u001d\u00aa$l\u00af\u00e1\u00cdh\u0017\u00f3\u00e7lL\u00f0\u00af\u001e\u0005\u00fb*\u00bauR\u00ce\fo\r\u00d1\u00ac\u00c1},\u00be\u0002\u00eek\u00b1Ub\u0004\u00b2\u0085D\u0000\u00f5\"\u00b2\u001c\u00e2w+rA\u00b5\u0098\u001d\u00aa\u00c1\u00ac\u0087\u0091\u00dd\u001a\u0013\u00dcg\u00fb\u00aa\u00c9\u00d9\u00056[.\u007f\u00d4h\u00a3&\u0018\u00fcW1\u0014%\u0083\u00cegT\u000f&\u00b4^\n\u00aa\u009d\b\u00d1\u00b3\u0001\u00e5\u00db\u00a7\u00d5\u00f0\u001aC=m\u00c7\u00ebN\u00f1\u00f53E\u008e\u00ab\u00c1\u000f&\u00db4M\u00c7\u00ad\u00c9\u001e\u001cnP3\u001a\u00d7\u00ae\u00ff\u00b5\u00b9\u0000\u00bb<z|\u00a7\u009b\u00e5\u00f4\u0085\u00b5\u00dc\u008e\u00cf\u007f\u0007\u00ec\u00e1\u00f7+s/\u0005\u00f2\u00a5>\u00f2q\u00d2\u0012W\u00b9\u0002#Q\u00e3\u0013W\u000e\u00d2\u0095\u00f4L\u0096\u0095\u00d4#\u00ca>eL?_eq\u0082k\u00d4\u00d8\u0082z\u00e8\u00f4\u00a7*D4\u009fe\"\u009e\u000e\u00d6\u00a1\u009c\u0082\u001fl\u00eev5\u00da\u00b7\u00dc\u00cf\u00b0\u0095.\u00e6k\"bY\u00af\u00ad\u00e2\u0002\u00c9Z&foR\u00ca\t\u0093\u00a5S\u00d4,,\t\u00b5c\"\u00c9\u00b4<\u00f6\u00c1h\u00b41\u009b\u00dd\u009b\u00afbrue\u00c2\u0094\f<\u007f\u0088\u00f2\u00f2\u00d8I\u00ac\u00bc\u008d\u008e\u00cb\u00b4B\u00b8\u001f\u0090\u0088\u0086l\u0090\u0092C\u0080P\u009bs:\u00ff\u001aT\u00fa\u00e8\u00a6\u00a2\u00d0y\u00e2\u00ba\u00c0i\u00f1T\u00f9\u00aa/:";
                var4_3 = ".\u00ab\u0010\u001aq\u00f9+_#]\u00e8\u0097\u0010\t\u00ea5L!\u00b0\u000fz\u00d9\u001b\u0095\u009d\u00a2\u00a1QTl,\u0010\u00e9\u0007]\u00a6\u001dX\u009f\u0006\b(\u0015\u0014%\u00bb\u008f\u001b\u00c97\u0097\u0018\u00f7\u0011N_\u00eb\u00e7%HP~\u0096\u00eb.\u00cd\u0083\u000bC\u00e8\u0088y\u00e3\u0084\u00c50\u00e5\u0011\u00b9Bq\u00fe\u00a2\u00e3Y\u0087\u00c3\u00e4i\u001b\u0014H\u00ee1\u0089\u0088\u00cf\u0004\u00e3+\u0012L\u0006\u00a1P\u0012\u00c9\u00b9tn>\u008fr\u00e9/\u0085R5x\u00f9\u000f\u00e4qA\u001f\u0080\u00f3\u0015\u001e\u00e4u\u0010\u0092\u000f\u00a9\t!0\u00a3?_\u008b\u00d3%\u00d4Z\u0095VDB,<\u00823\u009a\n\u001d\u00ea\u00edX\u00ddM\r%\u009d\u00a9H\u00dd\u001d\u00aa$l\u00af\u00e1\u00cdh\u0017\u00f3\u00e7lL\u00f0\u00af\u001e\u0005\u00fb*\u00bauR\u00ce\fo\r\u00d1\u00ac\u00c1},\u00be\u0002\u00eek\u00b1Ub\u0004\u00b2\u0085D\u0000\u00f5\"\u00b2\u001c\u00e2w+rA\u00b5\u0098\u001d\u00aa\u00c1\u00ac\u0087\u0091\u00dd\u001a\u0013\u00dcg\u00fb\u00aa\u00c9\u00d9\u00056[.\u007f\u00d4h\u00a3&\u0018\u00fcW1\u0014%\u0083\u00cegT\u000f&\u00b4^\n\u00aa\u009d\b\u00d1\u00b3\u0001\u00e5\u00db\u00a7\u00d5\u00f0\u001aC=m\u00c7\u00ebN\u00f1\u00f53E\u008e\u00ab\u00c1\u000f&\u00db4M\u00c7\u00ad\u00c9\u001e\u001cnP3\u001a\u00d7\u00ae\u00ff\u00b5\u00b9\u0000\u00bb<z|\u00a7\u009b\u00e5\u00f4\u0085\u00b5\u00dc\u008e\u00cf\u007f\u0007\u00ec\u00e1\u00f7+s/\u0005\u00f2\u00a5>\u00f2q\u00d2\u0012W\u00b9\u0002#Q\u00e3\u0013W\u000e\u00d2\u0095\u00f4L\u0096\u0095\u00d4#\u00ca>eL?_eq\u0082k\u00d4\u00d8\u0082z\u00e8\u00f4\u00a7*D4\u009fe\"\u009e\u000e\u00d6\u00a1\u009c\u0082\u001fl\u00eev5\u00da\u00b7\u00dc\u00cf\u00b0\u0095.\u00e6k\"bY\u00af\u00ad\u00e2\u0002\u00c9Z&foR\u00ca\t\u0093\u00a5S\u00d4,,\t\u00b5c\"\u00c9\u00b4<\u00f6\u00c1h\u00b41\u009b\u00dd\u009b\u00afbrue\u00c2\u0094\f<\u007f\u0088\u00f2\u00f2\u00d8I\u00ac\u00bc\u008d\u008e\u00cb\u00b4B\u00b8\u001f\u0090\u0088\u0086l\u0090\u0092C\u0080P\u009bs:\u00ff\u001aT\u00fa\u00e8\u00a6\u00a2\u00d0y\u00e2\u00ba\u00c0i\u00f1T\u00f9\u00aa/:".length();
                var1_4 = 3;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00a7\u0003\u00ea\u0007\u00cb\u00beJL3\u0012F`\u001ee\u00f3}\u000fX\u0003\u000b\u00cd!\u00b6\u00c8\u0004\u00c5\u00e3\u008c\u00e1,q\u00e3e\u001an2\u00c8&_rgr\u00e1\u00b5\u00d4\u00b5\u008a\u00ccO\u00a3\u0019BbL}\"\u008a\u00e9\u0082\u00c3";
                    var4_3 = "\u00a7\u0003\u00ea\u0007\u00cb\u00beJL3\u0012F`\u001ee\u00f3}\u000fX\u0003\u000b\u00cd!\u00b6\u00c8\u0004\u00c5\u00e3\u008c\u00e1,q\u00e3e\u001an2\u00c8&_rgr\u00e1\u00b5\u00d4\u00b5\u008a\u00ccO\u00a3\u0019BbL}\"\u008a\u00e9\u0082\u00c3".length();
                    var1_4 = 33;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 118;
                            break;
                        }
                        case 1: {
                            v13 = 26;
                            break;
                        }
                        case 2: {
                            v13 = 31;
                            break;
                        }
                        case 3: {
                            v13 = 7;
                            break;
                        }
                        case 4: {
                            v13 = 32;
                            break;
                        }
                        case 5: {
                            v13 = 115;
                            break;
                        }
                        default: {
                            v13 = 20;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        BaseTimeStampValidator.d = var5;
        BaseTimeStampValidator.e = new String[18];
        BaseTimeStampValidator.a = LoggerFactory.getLogger(BaseTimeStampValidator.class);
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0x4B35) & 0xFFFF;
        if (e[n3] == null) {
            int n4;
            int n5;
            char[] cArray = d[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 163;
                    break;
                }
                case 1: {
                    n5 = 33;
                    break;
                }
                case 2: {
                    n5 = 172;
                    break;
                }
                case 3: {
                    n5 = 79;
                    break;
                }
                case 4: {
                    n5 = 235;
                    break;
                }
                case 5: {
                    n5 = 111;
                    break;
                }
                case 6: {
                    n5 = 202;
                    break;
                }
                case 7: {
                    n5 = 18;
                    break;
                }
                case 8: {
                    n5 = 12;
                    break;
                }
                case 9: {
                    n5 = 208;
                    break;
                }
                case 10: {
                    n5 = 120;
                    break;
                }
                case 11: {
                    n5 = 186;
                    break;
                }
                case 12: {
                    n5 = 0;
                    break;
                }
                case 13: {
                    n5 = 190;
                    break;
                }
                case 14: {
                    n5 = 8;
                    break;
                }
                case 15: {
                    n5 = 124;
                    break;
                }
                case 16: {
                    n5 = 183;
                    break;
                }
                case 17: {
                    n5 = 243;
                    break;
                }
                case 18: {
                    n5 = 108;
                    break;
                }
                case 19: {
                    n5 = 194;
                    break;
                }
                case 20: {
                    n5 = 206;
                    break;
                }
                case 21: {
                    n5 = 209;
                    break;
                }
                case 22: {
                    n5 = 187;
                    break;
                }
                case 23: {
                    n5 = 85;
                    break;
                }
                case 24: {
                    n5 = 32;
                    break;
                }
                case 25: {
                    n5 = 70;
                    break;
                }
                case 26: {
                    n5 = 100;
                    break;
                }
                case 27: {
                    n5 = 128;
                    break;
                }
                case 28: {
                    n5 = 131;
                    break;
                }
                case 29: {
                    n5 = 218;
                    break;
                }
                case 30: {
                    n5 = 65;
                    break;
                }
                case 31: {
                    n5 = 196;
                    break;
                }
                case 32: {
                    n5 = 83;
                    break;
                }
                case 33: {
                    n5 = 19;
                    break;
                }
                case 34: {
                    n5 = 105;
                    break;
                }
                case 35: {
                    n5 = 201;
                    break;
                }
                case 36: {
                    n5 = 254;
                    break;
                }
                case 37: {
                    n5 = 121;
                    break;
                }
                case 38: {
                    n5 = 72;
                    break;
                }
                case 39: {
                    n5 = 10;
                    break;
                }
                case 40: {
                    n5 = 112;
                    break;
                }
                case 41: {
                    n5 = 113;
                    break;
                }
                case 42: {
                    n5 = 43;
                    break;
                }
                case 43: {
                    n5 = 64;
                    break;
                }
                case 44: {
                    n5 = 54;
                    break;
                }
                case 45: {
                    n5 = 249;
                    break;
                }
                case 46: {
                    n5 = 229;
                    break;
                }
                case 47: {
                    n5 = 126;
                    break;
                }
                case 48: {
                    n5 = 40;
                    break;
                }
                case 49: {
                    n5 = 143;
                    break;
                }
                case 50: {
                    n5 = 15;
                    break;
                }
                case 51: {
                    n5 = 27;
                    break;
                }
                case 52: {
                    n5 = 78;
                    break;
                }
                case 53: {
                    n5 = 165;
                    break;
                }
                case 54: {
                    n5 = 51;
                    break;
                }
                case 55: {
                    n5 = 106;
                    break;
                }
                case 56: {
                    n5 = 140;
                    break;
                }
                case 57: {
                    n5 = 23;
                    break;
                }
                case 58: {
                    n5 = 1;
                    break;
                }
                case 59: {
                    n5 = 207;
                    break;
                }
                case 60: {
                    n5 = 133;
                    break;
                }
                case 61: {
                    n5 = 192;
                    break;
                }
                case 62: {
                    n5 = 102;
                    break;
                }
                case 63: {
                    n5 = 184;
                    break;
                }
                case 64: {
                    n5 = 178;
                    break;
                }
                case 65: {
                    n5 = 96;
                    break;
                }
                case 66: {
                    n5 = 246;
                    break;
                }
                case 67: {
                    n5 = 45;
                    break;
                }
                case 68: {
                    n5 = 227;
                    break;
                }
                case 69: {
                    n5 = 242;
                    break;
                }
                case 70: {
                    n5 = 203;
                    break;
                }
                case 71: {
                    n5 = 142;
                    break;
                }
                case 72: {
                    n5 = 130;
                    break;
                }
                case 73: {
                    n5 = 193;
                    break;
                }
                case 74: {
                    n5 = 117;
                    break;
                }
                case 75: {
                    n5 = 62;
                    break;
                }
                case 76: {
                    n5 = 38;
                    break;
                }
                case 77: {
                    n5 = 132;
                    break;
                }
                case 78: {
                    n5 = 30;
                    break;
                }
                case 79: {
                    n5 = 185;
                    break;
                }
                case 80: {
                    n5 = 199;
                    break;
                }
                case 81: {
                    n5 = 239;
                    break;
                }
                case 82: {
                    n5 = 231;
                    break;
                }
                case 83: {
                    n5 = 57;
                    break;
                }
                case 84: {
                    n5 = 2;
                    break;
                }
                case 85: {
                    n5 = 182;
                    break;
                }
                case 86: {
                    n5 = 251;
                    break;
                }
                case 87: {
                    n5 = 52;
                    break;
                }
                case 88: {
                    n5 = 161;
                    break;
                }
                case 89: {
                    n5 = 24;
                    break;
                }
                case 90: {
                    n5 = 56;
                    break;
                }
                case 91: {
                    n5 = 217;
                    break;
                }
                case 92: {
                    n5 = 104;
                    break;
                }
                case 93: {
                    n5 = 245;
                    break;
                }
                case 94: {
                    n5 = 31;
                    break;
                }
                case 95: {
                    n5 = 224;
                    break;
                }
                case 96: {
                    n5 = 171;
                    break;
                }
                case 97: {
                    n5 = 237;
                    break;
                }
                case 98: {
                    n5 = 41;
                    break;
                }
                case 99: {
                    n5 = 119;
                    break;
                }
                case 100: {
                    n5 = 122;
                    break;
                }
                case 101: {
                    n5 = 151;
                    break;
                }
                case 102: {
                    n5 = 148;
                    break;
                }
                case 103: {
                    n5 = 4;
                    break;
                }
                case 104: {
                    n5 = 129;
                    break;
                }
                case 105: {
                    n5 = 253;
                    break;
                }
                case 106: {
                    n5 = 73;
                    break;
                }
                case 107: {
                    n5 = 204;
                    break;
                }
                case 108: {
                    n5 = 5;
                    break;
                }
                case 109: {
                    n5 = 29;
                    break;
                }
                case 110: {
                    n5 = 211;
                    break;
                }
                case 111: {
                    n5 = 221;
                    break;
                }
                case 112: {
                    n5 = 252;
                    break;
                }
                case 113: {
                    n5 = 173;
                    break;
                }
                case 114: {
                    n5 = 22;
                    break;
                }
                case 115: {
                    n5 = 88;
                    break;
                }
                case 116: {
                    n5 = 13;
                    break;
                }
                case 117: {
                    n5 = 180;
                    break;
                }
                case 118: {
                    n5 = 28;
                    break;
                }
                case 119: {
                    n5 = 114;
                    break;
                }
                case 120: {
                    n5 = 63;
                    break;
                }
                case 121: {
                    n5 = 255;
                    break;
                }
                case 122: {
                    n5 = 226;
                    break;
                }
                case 123: {
                    n5 = 98;
                    break;
                }
                case 124: {
                    n5 = 123;
                    break;
                }
                case 125: {
                    n5 = 91;
                    break;
                }
                case 126: {
                    n5 = 101;
                    break;
                }
                case 127: {
                    n5 = 74;
                    break;
                }
                case 128: {
                    n5 = 103;
                    break;
                }
                case 129: {
                    n5 = 162;
                    break;
                }
                case 130: {
                    n5 = 90;
                    break;
                }
                case 131: {
                    n5 = 210;
                    break;
                }
                case 132: {
                    n5 = 37;
                    break;
                }
                case 133: {
                    n5 = 154;
                    break;
                }
                case 134: {
                    n5 = 84;
                    break;
                }
                case 135: {
                    n5 = 89;
                    break;
                }
                case 136: {
                    n5 = 213;
                    break;
                }
                case 137: {
                    n5 = 75;
                    break;
                }
                case 138: {
                    n5 = 93;
                    break;
                }
                case 139: {
                    n5 = 136;
                    break;
                }
                case 140: {
                    n5 = 214;
                    break;
                }
                case 141: {
                    n5 = 20;
                    break;
                }
                case 142: {
                    n5 = 58;
                    break;
                }
                case 143: {
                    n5 = 236;
                    break;
                }
                case 144: {
                    n5 = 158;
                    break;
                }
                case 145: {
                    n5 = 238;
                    break;
                }
                case 146: {
                    n5 = 198;
                    break;
                }
                case 147: {
                    n5 = 71;
                    break;
                }
                case 148: {
                    n5 = 34;
                    break;
                }
                case 149: {
                    n5 = 80;
                    break;
                }
                case 150: {
                    n5 = 138;
                    break;
                }
                case 151: {
                    n5 = 87;
                    break;
                }
                case 152: {
                    n5 = 179;
                    break;
                }
                case 153: {
                    n5 = 6;
                    break;
                }
                case 154: {
                    n5 = 189;
                    break;
                }
                case 155: {
                    n5 = 222;
                    break;
                }
                case 156: {
                    n5 = 159;
                    break;
                }
                case 157: {
                    n5 = 216;
                    break;
                }
                case 158: {
                    n5 = 225;
                    break;
                }
                case 159: {
                    n5 = 181;
                    break;
                }
                case 160: {
                    n5 = 7;
                    break;
                }
                case 161: {
                    n5 = 82;
                    break;
                }
                case 162: {
                    n5 = 11;
                    break;
                }
                case 163: {
                    n5 = 176;
                    break;
                }
                case 164: {
                    n5 = 67;
                    break;
                }
                case 165: {
                    n5 = 48;
                    break;
                }
                case 166: {
                    n5 = 39;
                    break;
                }
                case 167: {
                    n5 = 118;
                    break;
                }
                case 168: {
                    n5 = 155;
                    break;
                }
                case 169: {
                    n5 = 160;
                    break;
                }
                case 170: {
                    n5 = 188;
                    break;
                }
                case 171: {
                    n5 = 69;
                    break;
                }
                case 172: {
                    n5 = 16;
                    break;
                }
                case 173: {
                    n5 = 55;
                    break;
                }
                case 174: {
                    n5 = 168;
                    break;
                }
                case 175: {
                    n5 = 66;
                    break;
                }
                case 176: {
                    n5 = 44;
                    break;
                }
                case 177: {
                    n5 = 240;
                    break;
                }
                case 178: {
                    n5 = 9;
                    break;
                }
                case 179: {
                    n5 = 139;
                    break;
                }
                case 180: {
                    n5 = 153;
                    break;
                }
                case 181: {
                    n5 = 127;
                    break;
                }
                case 182: {
                    n5 = 200;
                    break;
                }
                case 183: {
                    n5 = 250;
                    break;
                }
                case 184: {
                    n5 = 205;
                    break;
                }
                case 185: {
                    n5 = 59;
                    break;
                }
                case 186: {
                    n5 = 150;
                    break;
                }
                case 187: {
                    n5 = 146;
                    break;
                }
                case 188: {
                    n5 = 197;
                    break;
                }
                case 189: {
                    n5 = 195;
                    break;
                }
                case 190: {
                    n5 = 35;
                    break;
                }
                case 191: {
                    n5 = 177;
                    break;
                }
                case 192: {
                    n5 = 53;
                    break;
                }
                case 193: {
                    n5 = 109;
                    break;
                }
                case 194: {
                    n5 = 147;
                    break;
                }
                case 195: {
                    n5 = 125;
                    break;
                }
                case 196: {
                    n5 = 191;
                    break;
                }
                case 197: {
                    n5 = 228;
                    break;
                }
                case 198: {
                    n5 = 166;
                    break;
                }
                case 199: {
                    n5 = 77;
                    break;
                }
                case 200: {
                    n5 = 157;
                    break;
                }
                case 201: {
                    n5 = 174;
                    break;
                }
                case 202: {
                    n5 = 175;
                    break;
                }
                case 203: {
                    n5 = 212;
                    break;
                }
                case 204: {
                    n5 = 149;
                    break;
                }
                case 205: {
                    n5 = 76;
                    break;
                }
                case 206: {
                    n5 = 170;
                    break;
                }
                case 207: {
                    n5 = 141;
                    break;
                }
                case 208: {
                    n5 = 215;
                    break;
                }
                case 209: {
                    n5 = 116;
                    break;
                }
                case 210: {
                    n5 = 220;
                    break;
                }
                case 211: {
                    n5 = 230;
                    break;
                }
                case 212: {
                    n5 = 137;
                    break;
                }
                case 213: {
                    n5 = 145;
                    break;
                }
                case 214: {
                    n5 = 46;
                    break;
                }
                case 215: {
                    n5 = 94;
                    break;
                }
                case 216: {
                    n5 = 49;
                    break;
                }
                case 217: {
                    n5 = 244;
                    break;
                }
                case 218: {
                    n5 = 3;
                    break;
                }
                case 219: {
                    n5 = 110;
                    break;
                }
                case 220: {
                    n5 = 241;
                    break;
                }
                case 221: {
                    n5 = 26;
                    break;
                }
                case 222: {
                    n5 = 21;
                    break;
                }
                case 223: {
                    n5 = 167;
                    break;
                }
                case 224: {
                    n5 = 25;
                    break;
                }
                case 225: {
                    n5 = 233;
                    break;
                }
                case 226: {
                    n5 = 17;
                    break;
                }
                case 227: {
                    n5 = 97;
                    break;
                }
                case 228: {
                    n5 = 86;
                    break;
                }
                case 229: {
                    n5 = 92;
                    break;
                }
                case 230: {
                    n5 = 144;
                    break;
                }
                case 231: {
                    n5 = 219;
                    break;
                }
                case 232: {
                    n5 = 99;
                    break;
                }
                case 233: {
                    n5 = 60;
                    break;
                }
                case 234: {
                    n5 = 135;
                    break;
                }
                case 235: {
                    n5 = 156;
                    break;
                }
                case 236: {
                    n5 = 42;
                    break;
                }
                case 237: {
                    n5 = 81;
                    break;
                }
                case 238: {
                    n5 = 50;
                    break;
                }
                case 239: {
                    n5 = 223;
                    break;
                }
                case 240: {
                    n5 = 61;
                    break;
                }
                case 241: {
                    n5 = 134;
                    break;
                }
                case 242: {
                    n5 = 169;
                    break;
                }
                case 243: {
                    n5 = 107;
                    break;
                }
                case 244: {
                    n5 = 14;
                    break;
                }
                case 245: {
                    n5 = 164;
                    break;
                }
                case 246: {
                    n5 = 47;
                    break;
                }
                case 247: {
                    n5 = 247;
                    break;
                }
                case 248: {
                    n5 = 36;
                    break;
                }
                case 249: {
                    n5 = 232;
                    break;
                }
                case 250: {
                    n5 = 115;
                    break;
                }
                case 251: {
                    n5 = 95;
                    break;
                }
                case 252: {
                    n5 = 152;
                    break;
                }
                case 253: {
                    n5 = 248;
                    break;
                }
                case 254: {
                    n5 = 68;
                    break;
                }
                default: {
                    n5 = 234;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            BaseTimeStampValidator.e[n3] = new String(cArray).intern();
        }
        return e[n3];
    }
}

