/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.smyy.utils;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.Any;
import com.turktrust.asn1.BitString;
import com.turktrust.asn1.Null;
import com.turktrust.asn1.ObjectID;
import com.turktrust.pkcs1.RSAPublicKey;
import com.turktrust.x509.AlgorithmIdentifier;
import com.turktrust.x509.SubjectPublicKeyInfo;
import java.math.BigInteger;

public class AkilliKarttakiAcikAnahtar {
    private byte[] modulusBytes;
    private byte[] publicExponentBytes;
    private byte[] idBytes;
    private byte[] labelBytes;

    public AkilliKarttakiAcikAnahtar(byte[] keyModulusBytes, byte[] keyPublicExponentBytes, byte[] keyIdBytes, byte[] keyLabelBytes) {
        this.modulusBytes = keyModulusBytes;
        this.publicExponentBytes = keyPublicExponentBytes;
        this.idBytes = keyIdBytes;
        this.labelBytes = keyLabelBytes;
    }

    public SubjectPublicKeyInfo getKeyAsSubjectPublicKeyInfo() {
        RSAPublicKey rpk = new RSAPublicKey("rpk");
        ASN1Integer modInt = new ASN1Integer("modInt");
        BigInteger modBigInt = new BigInteger(1, this.modulusBytes);
        modInt.setValue(modBigInt);
        ASN1Integer expInt = new ASN1Integer("expInt");
        BigInteger expBigInt = new BigInteger(1, this.publicExponentBytes);
        expInt.setValue(expBigInt);
        rpk.setmodulus(modInt);
        rpk.setpublicExponent(expInt);
        rpk.commitElementUpdate();
        byte[] rpkBytes = rpk.getEncoded();
        BitString rpkBits = new BitString("rpkBits");
        rpkBits.setValue(rpkBytes);
        ObjectID rsaObjId = new ObjectID("RSA");
        rsaObjId.setValue("1.2.840.113549.1.1.1");
        Null parNull = new Null("Null_par");
        Any anyNull = new Any("Any_null");
        anyNull.setValue(parNull);
        AlgorithmIdentifier algId = new AlgorithmIdentifier("SHA1_RSA");
        algId.setalgorithm(rsaObjId);
        algId.setparameters(anyNull);
        algId.commitElementUpdate();
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo("spki");
        spki.setalgorithm(algId);
        spki.setsubjectPublicKey(rpkBits);
        spki.commitElementUpdate();
        return spki;
    }

    public byte[] getKeyModulusBytes() {
        return this.modulusBytes;
    }

    public byte[] getKeyPublicExponentBytes() {
        return this.publicExponentBytes;
    }

    public byte[] getIdBytes() {
        return this.idBytes;
    }

    public byte[] getLabelBytes() {
        return this.labelBytes;
    }
}

