/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.IA5String;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.Sequence;
import com.turktrust.x509.UserNotice;

public class PolicyQualifierInfo
extends Sequence {
    private static final String ID_QT_CPS_URI = "1.3.6.1.5.5.7.2.1";
    private static final String ID_QT_UNOTICE = "1.3.6.1.5.5.7.2.2";
    private ObjectID qualType = new ObjectID("qualType");
    private UserNotice unotice = new UserNotice();
    private IA5String cpsuri = new IA5String("defCPSuri");

    public PolicyQualifierInfo() {
        super("defaultPQI");
        this.setUpElements();
    }

    private void setUpElements() {
        super.addElement(this.qualType);
        super.addElement(this.unotice);
        this.unotice.setOptional(true);
        super.addElement(this.cpsuri);
        this.cpsuri.setOptional(true);
    }

    public PolicyQualifierInfo(String name, UserNotice userNotice) {
        super(name);
        this.setUpElements();
        ObjectID uNoticeObjId = new ObjectID("uNoticeObjId");
        uNoticeObjId.setValue(ID_QT_UNOTICE);
        this.qualType = uNoticeObjId;
        this.unotice = userNotice;
        this.commitElementUpdate();
    }

    public PolicyQualifierInfo(String name, IA5String cpsIA5Str) {
        super(name);
        this.setUpElements();
        ObjectID cpsURIObjId = new ObjectID("cpsURIObjId");
        cpsURIObjId.setValue(ID_QT_CPS_URI);
        this.qualType = cpsURIObjId;
        this.cpsuri = cpsIA5Str;
        this.commitElementUpdate();
    }

    public String getExplanation() {
        String exp = "";
        ObjectID pqiObjId = (ObjectID)this.getElement(0);
        if (((String)pqiObjId.getValue()).equals(ID_QT_CPS_URI)) {
            exp = exp + "CPS URI: " + (String)this.cpsuri.getValue();
        } else if (((String)pqiObjId.getValue()).equals(ID_QT_UNOTICE)) {
            exp = exp + "User Notice: " + this.unotice.getNoticeText();
        }
        return exp;
    }

    public String getTurkishExplanation() {
        String exp = "";
        ObjectID pqiObjId = (ObjectID)this.getElement(0);
        if (((String)pqiObjId.getValue()).equals(ID_QT_CPS_URI)) {
            exp = exp + "Sertifika \u0130lkeleri Dok\u00fcman Adresi: " + (String)this.cpsuri.getValue();
        } else if (((String)pqiObjId.getValue()).equals(ID_QT_UNOTICE)) {
            exp = exp + "Kullan\u0131c\u0131lara Not: " + this.unotice.getNoticeText();
        }
        return exp;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }
}

