/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.x509;

import com.turktrust.asn1.ASN1Boolean;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.Sequence;
import com.turktrust.x509.AuthorityInfoAccessSyntax;
import com.turktrust.x509.AuthorityKeyId;
import com.turktrust.x509.BasicConstraints;
import com.turktrust.x509.CRLDistributionPoints;
import com.turktrust.x509.CRLNumber;
import com.turktrust.x509.CRLReason;
import com.turktrust.x509.CertificatePolicies;
import com.turktrust.x509.ExtendedKeyUsage;
import com.turktrust.x509.KeyUsage;
import com.turktrust.x509.QCStatements;
import com.turktrust.x509.SubjectAltName;
import com.turktrust.x509.SubjectKeyId;

public class Extension
extends Sequence {
    private ObjectID extnID = new ObjectID("extnID");
    private ASN1Boolean critical = new ASN1Boolean("critical");
    private OctetString extnValue = new OctetString("extnValue");
    private Extension subInstance;

    public Extension() {
        super("ext");
        this.setUpElements();
    }

    public Extension(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.extnID);
        super.addElement(this.critical);
        this.critical.setOptional(true);
        super.addElement(this.extnValue);
    }

    public ObjectID getextnID() {
        return this.extnID;
    }

    public void setextnID(ObjectID value) {
        this.extnID = value;
    }

    public ASN1Boolean getcritical() {
        return this.critical;
    }

    public void setcritical(ASN1Boolean value) {
        this.critical = value;
    }

    public OctetString getextnValue() {
        return this.extnValue;
    }

    public void setextnValue(OctetString value) {
        this.extnValue = value;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }

    public void decode(byte[] input) throws DecodeException {
        super.decode(input);
        this.setextnID((ObjectID)super.getElement(0));
        this.setcritical((ASN1Boolean)super.getElement(1));
        this.setextnValue((OctetString)super.getElement(2));
        this.commitElementUpdate();
        this.subInstance = this.findSubInstance();
    }

    public String getExtensionTitle() {
        if (this.subInstance != null) {
            return this.subInstance.getExtensionTitle();
        }
        return "";
    }

    public String getTurkishExtensionTitle() {
        if (this.subInstance != null) {
            return this.subInstance.getTurkishExtensionTitle();
        }
        return "";
    }

    public String getExplanation() throws DecodeException {
        if (this.subInstance != null) {
            return this.subInstance.getExplanation();
        }
        return "";
    }

    public String getTurkishExplanation() throws DecodeException {
        if (this.subInstance != null) {
            return this.subInstance.getTurkishExplanation();
        }
        return "";
    }

    public Extension getSubInstance() {
        return this.subInstance;
    }

    private Extension findSubInstance() {
        String extIdStr = (String)this.extnID.getValue();
        byte[] extValBytes = (byte[])this.extnValue.getValue();
        if (extIdStr.equals("2.5.29.35")) {
            AuthorityKeyId aki = new AuthorityKeyId();
            aki.decodeExtVal(extValBytes);
            return aki;
        }
        if (extIdStr.equals("2.5.29.14")) {
            SubjectKeyId ski = new SubjectKeyId();
            ski.decodeExtVal(extValBytes);
            return ski;
        }
        if (extIdStr.equals("2.5.29.15")) {
            KeyUsage ku = new KeyUsage();
            ku.decodeExtVal(extValBytes);
            return ku;
        }
        if (extIdStr.equals("2.5.29.19")) {
            BasicConstraints bc = new BasicConstraints();
            bc.decodeExtVal(extValBytes);
            return bc;
        }
        if (extIdStr.equals("2.5.29.31")) {
            CRLDistributionPoints cdp = new CRLDistributionPoints();
            cdp.decodeExtVal(extValBytes);
            return cdp;
        }
        if (extIdStr.equals("2.5.29.37")) {
            ExtendedKeyUsage eku = new ExtendedKeyUsage();
            eku.decodeExtVal(extValBytes);
            return eku;
        }
        if (extIdStr.equals("2.5.29.32")) {
            CertificatePolicies cp = new CertificatePolicies();
            cp.decodeExtVal(extValBytes);
            return cp;
        }
        if (extIdStr.equals("1.3.6.1.5.5.7.1.3")) {
            QCStatements qcs = new QCStatements();
            qcs.decodeExtVal(extValBytes);
            return qcs;
        }
        if (extIdStr.equals("2.5.29.17")) {
            SubjectAltName san = new SubjectAltName();
            san.decodeExtVal(extValBytes);
            return san;
        }
        if (extIdStr.equals("1.3.6.1.5.5.7.1.1")) {
            AuthorityInfoAccessSyntax aias = new AuthorityInfoAccessSyntax();
            try {
                aias.decodeExtVal(extValBytes);
            }
            catch (Exception exc) {
                return null;
            }
            return aias;
        }
        if (extIdStr.equals("2.5.29.21")) {
            CRLReason crlReason = new CRLReason();
            crlReason.decodeExtVal(extValBytes);
            return crlReason;
        }
        if (extIdStr.equals("2.5.29.20")) {
            CRLNumber crlNumber = new CRLNumber();
            crlNumber.decodeExtVal(extValBytes);
            return crlNumber;
        }
        return null;
    }
}

