/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.asn.cms;

import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1Type;
import java.util.Arrays;
import tr.gov.tubitak.uekae.esya.api.asn.BaseASNWrapper;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EIssuerAndSerialNumber;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtensions;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectKeyIdentifier;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.asn.cms.IssuerAndSerialNumber;
import tr.gov.tubitak.uekae.esya.asn.cms.SignerIdentifier;

public class ESignerIdentifier
extends BaseASNWrapper<SignerIdentifier> {
    public ESignerIdentifier(SignerIdentifier aObject) {
        super(aObject);
    }

    public ESignerIdentifier(byte[] aBytes) throws ESYAException {
        super(aBytes, new SignerIdentifier());
    }

    public int getType() {
        return ((SignerIdentifier)this.mObject).getChoiceID();
    }

    public void setIssuerAndSerialNumber(EIssuerAndSerialNumber aIssuerAndSerial) {
        ((SignerIdentifier)this.mObject).setElement(1, (Asn1Type)aIssuerAndSerial.getObject());
    }

    public void setSubjectKeyIdentifier(byte[] aSubjectKeyIdentifier) {
        ((SignerIdentifier)this.mObject).setElement(2, (Asn1Type)new Asn1OctetString(aSubjectKeyIdentifier));
    }

    public EIssuerAndSerialNumber getIssuerAndSerialNumber() {
        if (((SignerIdentifier)this.mObject).getChoiceID() == 1) {
            return new EIssuerAndSerialNumber((IssuerAndSerialNumber)((SignerIdentifier)this.mObject).getElement());
        }
        return null;
    }

    public byte[] getSubjectKeyIdentifier() {
        if (((SignerIdentifier)this.mObject).getChoiceID() == 2) {
            return ((Asn1OctetString)((SignerIdentifier)this.mObject).getElement()).value;
        }
        return null;
    }

    public boolean isEqual(ECertificate aCertificate) {
        EIssuerAndSerialNumber eIssuerAndSerialNumber = this.getIssuerAndSerialNumber();
        if (eIssuerAndSerialNumber != null) {
            EIssuerAndSerialNumber eIssuerAndSerialNumber2 = new EIssuerAndSerialNumber(aCertificate);
            return eIssuerAndSerialNumber2.equals(eIssuerAndSerialNumber);
        }
        byte[] byArray = this.getSubjectKeyIdentifier();
        if (byArray != null) {
            EExtensions eExtensions = aCertificate.getExtensions();
            if (eExtensions == null) {
                return false;
            }
            ESubjectKeyIdentifier eSubjectKeyIdentifier = eExtensions.getSubjectKeyIdentifier();
            if (eSubjectKeyIdentifier == null) {
                return false;
            }
            return Arrays.equals(byArray, eSubjectKeyIdentifier.getValue());
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ESignerIdentifier) {
            ESignerIdentifier eSignerIdentifier = (ESignerIdentifier)obj;
            if (this.getIssuerAndSerialNumber() != null && eSignerIdentifier.getIssuerAndSerialNumber() != null) {
                return this.getIssuerAndSerialNumber().equals(eSignerIdentifier.getIssuerAndSerialNumber());
            }
            if (this.getSubjectKeyIdentifier() != null && eSignerIdentifier.getSubjectKeyIdentifier() != null) {
                return Arrays.equals(this.getSubjectKeyIdentifier(), eSignerIdentifier.getSubjectKeyIdentifier());
            }
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

