/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.smyy.utils;

import com.turktrust.api.OCSPException;
import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.Any;
import com.turktrust.asn1.BitString;
import com.turktrust.asn1.GeneralizedTime;
import com.turktrust.asn1.Null;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.UTCTime;
import com.turktrust.ocsp.AlternativeNonce;
import com.turktrust.ocsp.BasicOCSPResponse;
import com.turktrust.ocsp.CRLReasonEnum;
import com.turktrust.ocsp.CertID;
import com.turktrust.ocsp.CertStatus;
import com.turktrust.ocsp.Nonce;
import com.turktrust.ocsp.OCSPRequest;
import com.turktrust.ocsp.OCSPResponse;
import com.turktrust.ocsp.OCSPResponseStatus;
import com.turktrust.ocsp.Request;
import com.turktrust.ocsp.ResponderID;
import com.turktrust.ocsp.ResponseBytes;
import com.turktrust.ocsp.ResponseData;
import com.turktrust.ocsp.RevokedInfo;
import com.turktrust.ocsp.SingleResponse;
import com.turktrust.ocsp.TBSRequest;
import com.turktrust.smyy.utils.Base64;
import com.turktrust.smyy.utils.HashFabrikasi;
import com.turktrust.smyy.utils.ImzaFabrikasi;
import com.turktrust.x509.AccessDescription;
import com.turktrust.x509.AlgorithmIdentifier;
import com.turktrust.x509.AuthorityInfoAccessSyntax;
import com.turktrust.x509.Certificate;
import com.turktrust.x509.Extension;
import com.turktrust.x509.Extensions;
import com.turktrust.x509.Name;
import com.turktrust.x509.SubjectPublicKeyInfo;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class OCSPFabrikasi {
    public static final int RESPONSE_GECERLI = 0;
    public static final int RESPONSE_DOGRULAMA_SERTIFIKASI_BULUNAMADI = 1;
    public static final int RESPONSE_GECERSIZ = 2;
    public static final int RESPONSE_DOGRULAMA_ISLEMINDE_HATA = 3;
    public static final int RESPONSE_BILINMEYEN_IMZA_ALGORITMASI = 4;
    public static final int RESPONSE_SUNUCUYA_BAGLANTI_KURULAMADI = 5;
    public static final int RESPONSE_SUNUCUDA_HATA_OLUSTU = 6;
    public static final int SERTIFIKA_GECERLI = 7;
    public static final int SERTIFIKA_IPTAL_EDILMIS = 8;
    public static final int SERTIFIKA_BILINMIYOR = 9;
    public static final int CEVAP_SERTIFIKA_ICIN_DEGIL = 10;
    public static final int CEVAP_KONTROL_ISLEMINDE_HATA_OLUSTU = -1;
    public static final int OCSP_ADRESI_BULUNAMADI = 11;
    public static final int RESPONSE_ZAMANI_RESPONDER_SERTIFIKA_ILE_UYUMSUZ = 12;
    public static final String HTTP_GET = "GET";
    public static final String HTTP_POST = "POST";

    public static CertID formCertID(Certificate subjectCert, String hashAlgOid, Certificate issuerCert) {
        try {
            BigInteger serialBigInt = (BigInteger)subjectCert.gettbsCertificate().getserialNumber().getValue();
            return OCSPFabrikasi.formCertID(serialBigInt, hashAlgOid, issuerCert);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static CertID formCertID(BigInteger subjectCertSerialNo, String hashAlgOid, Certificate issuerCert) {
        try {
            if (!HashFabrikasi.algoritmaDesteklenmeKontrolu(hashAlgOid)) {
                return null;
            }
            AlgorithmIdentifier hashAlgId = new AlgorithmIdentifier("hashAlgId");
            ObjectID hashAlgObjId = new ObjectID("hashAlgObjId", hashAlgOid);
            hashAlgId.setalgorithm(hashAlgObjId);
            Null parNull = new Null("Null_par");
            Any anyNull = new Any("Any_null");
            anyNull.setValue(parNull);
            hashAlgId.setparameters(anyNull);
            hashAlgId.commitElementUpdate();
            Name issuerName = issuerCert.gettbsCertificate().getsubject();
            byte[] issuerNameBytes = issuerName.getEncoded();
            byte[] issuerNameHashBytes = HashFabrikasi.hashAl(issuerNameBytes, hashAlgOid);
            OctetString issuerNameHash = new OctetString("issuerNameHash", issuerNameHashBytes);
            SubjectPublicKeyInfo issuerSpki = issuerCert.gettbsCertificate().getsubjectPublicKeyInfo();
            BitString issuerKeyBitString = issuerSpki.getsubjectPublicKey();
            byte[] keyBytes = (byte[])issuerKeyBitString.getValue();
            byte[] issuerKeyHashBytes = HashFabrikasi.hashAl(keyBytes, hashAlgOid);
            OctetString issuerKeyHash = new OctetString("issuerKeyHash", issuerKeyHashBytes);
            ASN1Integer serial = new ASN1Integer("serial", subjectCertSerialNo);
            CertID certId = new CertID("certId");
            certId.setHashAlgorithm(hashAlgId);
            certId.setIssuerNameHash(issuerNameHash);
            certId.setIssuerKeyHash(issuerKeyHash);
            certId.setSerialNumber(serial);
            certId.commitElementUpdate();
            return certId;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static Request formRequest(CertID certId) {
        Request req = new Request("req");
        req.setReqCert(certId);
        req.commitElementUpdate();
        return req;
    }

    public static TBSRequest formTBSRequest(Vector requestsVec, Extensions exts) {
        TBSRequest tbsReq = new TBSRequest("tbsReq");
        tbsReq.setRequestList(requestsVec);
        if (exts != null) {
            tbsReq.setRequestExtensions(exts);
        }
        tbsReq.commitElementUpdate();
        return tbsReq;
    }

    public static OCSPRequest formOCSPRequest(TBSRequest tbsReq) {
        OCSPRequest ocspReq = new OCSPRequest("ocspReq");
        ocspReq.setTBSRequest(tbsReq);
        ocspReq.commitElementUpdate();
        return ocspReq;
    }

    public static Vector getRequests(OCSPRequest ocspReq) {
        return (Vector)ocspReq.getTBSRequest().getRequestList().getValue();
    }

    public static RevokedInfo formRevokedInfo(Date revocationTime, int revocationReason) {
        RevokedInfo revInfo = new RevokedInfo("revInfo");
        GeneralizedTime revGenTime = new GeneralizedTime("revGenTime");
        revGenTime.setValue(revocationTime);
        revInfo.setRevocationTime(revGenTime);
        CRLReasonEnum revCRLReason = new CRLReasonEnum("revCRLReason", revocationReason);
        revInfo.setRevocationReason(revCRLReason);
        revInfo.commitElementUpdate();
        return revInfo;
    }

    public static SingleResponse formSingleResponse(CertID certId, int certStatus, RevokedInfo revInfo, Date thisUpdate) {
        SingleResponse sresp = new SingleResponse("sresp");
        sresp.setCertId(certId);
        CertStatus certst = new CertStatus("certst");
        if (certStatus == 0) {
            certst.setGood();
        } else if (certStatus == 2) {
            certst.setUnkown();
        } else if (certStatus == 1) {
            certst.setRevokedInfo(revInfo);
        } else {
            return null;
        }
        sresp.setCertStatus(certst);
        GeneralizedTime gttu = new GeneralizedTime("gttu");
        gttu.setValue(thisUpdate);
        sresp.setThisUpdate(gttu);
        sresp.commitElementUpdate();
        return sresp;
    }

    public static ResponseData formResponseData(Name responderName, Date producedAt, Vector singleRespVec, byte[] nonceBytes, boolean isNonceAlternativeEncoding) {
        ResponseData respData = new ResponseData("respData");
        ResponderID respId = new ResponderID("respId");
        respId.setByName(responderName);
        respData.setResponderId(respId);
        GeneralizedTime genProducedAt = new GeneralizedTime("producedAt");
        genProducedAt.setValue(producedAt);
        respData.setProducedAt(genProducedAt);
        respData.setResponses(singleRespVec);
        if (nonceBytes != null) {
            if (!isNonceAlternativeEncoding) {
                Nonce non = new Nonce("respNonce", false, nonceBytes);
                Extensions exts = new Extensions("respExts");
                exts.addElement(non);
                respData.setResponseExtensions(exts);
            } else {
                AlternativeNonce non = new AlternativeNonce("respAltNonce", false, nonceBytes);
                Extensions exts = new Extensions("respExts");
                exts.addElement(non);
                respData.setResponseExtensions(exts);
            }
        }
        respData.commitElementUpdate();
        return respData;
    }

    public static Certificate extractResponderCertFromBasicOCSPResponse(BasicOCSPResponse basicResp) {
        try {
            Vector certvec = basicResp.getCerts();
            ResponderID respId = basicResp.getTbsResponseData().getResponderId();
            Certificate respCert = null;
            if (respId.getTagNumber() == 1) {
                Name respName = (Name)respId.getValue();
                for (Certificate tempCert : certvec) {
                    if (!tempCert.gettbsCertificate().getsubject().isEqualTo(respName)) continue;
                    respCert = tempCert;
                    break;
                }
            } else if (respId.getTagNumber() == 2) {
                OctetString respHash = (OctetString)respId.getValue();
                byte[] respHashBytes = (byte[])respHash.getValue();
                Iterator iter = certvec.iterator();
                MessageDigest mdig = MessageDigest.getInstance("SHA-1");
                while (iter.hasNext()) {
                    Certificate tempCert = (Certificate)iter.next();
                    mdig.reset();
                    byte[] certKeyBytes = (byte[])tempCert.gettbsCertificate().getsubjectPublicKeyInfo().getsubjectPublicKey().getValue();
                    byte[] tempHash = mdig.digest(certKeyBytes);
                    if (!OCSPFabrikasi.areByteArraysEqual(respHashBytes, tempHash)) continue;
                    respCert = tempCert;
                    break;
                }
            }
            return respCert;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static int verifyBasicOCSPResponse(BasicOCSPResponse basicResp) {
        try {
            Certificate respCert = OCSPFabrikasi.extractResponderCertFromBasicOCSPResponse(basicResp);
            if (respCert == null) {
                return 1;
            }
            return OCSPFabrikasi.verifyBasicOCSPResponse(basicResp, respCert);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return 3;
        }
    }

    public static int verifyBasicOCSPResponse(BasicOCSPResponse basicResp, Certificate responderCert) {
        try {
            if (responderCert.gettbsCertificate().getsubject().getCN().indexOf("UEKAE") != -1) {
                basicResp.getTbsResponseData().getVersion().setDefaultValue("45");
            }
            if (responderCert.gettbsCertificate().getsubject().getCN().indexOf("EBG Sertifika Durum Protokol") != -1) {
                basicResp.getTbsResponseData().getVersion().setDefaultValue("45");
            }
            byte[] tbsBytes = basicResp.getTbsResponseData().getEncoded();
            byte[] signatureBytes = (byte[])basicResp.getSignature().getValue();
            byte[] signerSpkiBytes = responderCert.gettbsCertificate().getsubjectPublicKeyInfo().getEncoded();
            X509EncodedKeySpec xspec = new X509EncodedKeySpec(signerSpkiBytes);
            KeyFactory keyFac = KeyFactory.getInstance("RSA");
            PublicKey signerPubKey = keyFac.generatePublic(xspec);
            String signAlgId = (String)basicResp.getSignatureAlgorithm().getalgorithm().getValue();
            if (!ImzaFabrikasi.algoritmaDesteklenmeKontrolu(signAlgId)) {
                return 4;
            }
            if (ImzaFabrikasi.verifyPKCS1SignatureWithAlgorithmCheck(signatureBytes, signerPubKey, tbsBytes, signAlgId)) {
                Date producedDate = (Date)basicResp.getTbsResponseData().getProducedAt().getValue();
                Date certStart = null;
                try {
                    UTCTime utc = (UTCTime)responderCert.gettbsCertificate().getvalidity().getnotBefore().getValue();
                    certStart = (Date)utc.getValue();
                }
                catch (ClassCastException ccexc) {
                    GeneralizedTime gtm = (GeneralizedTime)responderCert.gettbsCertificate().getvalidity().getnotBefore().getValue();
                    certStart = (Date)gtm.getValue();
                }
                Date certFinish = null;
                try {
                    UTCTime utc = (UTCTime)responderCert.gettbsCertificate().getvalidity().getnotAfter().getValue();
                    certFinish = (Date)utc.getValue();
                }
                catch (ClassCastException ccexc) {
                    GeneralizedTime gtm = (GeneralizedTime)responderCert.gettbsCertificate().getvalidity().getnotAfter().getValue();
                    certFinish = (Date)gtm.getValue();
                }
                if (producedDate.before(certStart)) {
                    return 12;
                }
                if (producedDate.after(certFinish)) {
                    return 12;
                }
                SingleResponse singleResp = (SingleResponse)basicResp.getTbsResponseData().getReponses().elementAt(0);
                Date thisUpdateDate = (Date)singleResp.getThisUpdate().getValue();
                if (thisUpdateDate.before(certStart)) {
                    return 12;
                }
                if (thisUpdateDate.after(certFinish)) {
                    return 12;
                }
                return 0;
            }
            return 2;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return 3;
        }
    }

    public static OCSPResponse formOCSPResponse(int status, BasicOCSPResponse basicResp) {
        OCSPResponseStatus respStatus = new OCSPResponseStatus("respStatus");
        respStatus.setValue(status);
        OCSPResponse resp = new OCSPResponse("resp");
        resp.setResponseStatus(respStatus);
        if (basicResp != null) {
            byte[] basicRespBytes = basicResp.getEncoded();
            OctetString basicRespOcts = new OctetString("basicRespOcts", basicRespBytes);
            ResponseBytes respBytes = new ResponseBytes("respBytes");
            respBytes.setResponseType(new ObjectID("id-pkix-ocsp-basic", "1.3.6.1.5.5.7.48.1.1"));
            respBytes.setResponse(basicRespOcts);
            respBytes.commitElementUpdate();
            resp.setResponseBytes(respBytes);
        } else {
            resp.setResponseBytes(null);
        }
        resp.commitElementUpdate();
        return resp;
    }

    public static Vector queryUsingOCSP(Certificate tbqCert, Certificate issuerCert, String address, String requestHashAlgOid) {
        return OCSPFabrikasi.queryUsingOCSP(tbqCert, issuerCert, address, -1, requestHashAlgOid);
    }

    public static Vector queryUsingOCSP(Certificate tbqCert, Certificate issuerCert, String address, int timeoutInSeconds, String requestHashAlgOid) {
        Vector<Object> resultVec = new Vector<Object>();
        CertID certID = OCSPFabrikasi.formCertID(tbqCert, requestHashAlgOid, issuerCert);
        Vector<Request> reqVector = new Vector<Request>();
        reqVector.addElement(OCSPFabrikasi.formRequest(certID));
        SecureRandom randomBytes = new SecureRandom();
        byte[] nonceBytes = new byte[20];
        randomBytes.nextBytes(nonceBytes);
        Nonce non = new Nonce("respNonce", false, nonceBytes);
        Extensions exts = new Extensions("respExts");
        exts.addElement(non);
        TBSRequest tbsReq = OCSPFabrikasi.formTBSRequest(reqVector, exts);
        OCSPRequest ocspReq = OCSPFabrikasi.formOCSPRequest(tbsReq);
        byte[] ocspReqBytes = ocspReq.getEncoded();
        String httpReqMet = HTTP_POST;
        byte[] ocspResponseBytes = OCSPFabrikasi.sendOCSPRequestAndGetResponse(ocspReqBytes, address, httpReqMet, timeoutInSeconds);
        if (ocspResponseBytes == null) {
            resultVec.addElement(new Integer(5));
            return resultVec;
        }
        OCSPResponse tResp = new OCSPResponse("tResp");
        try {
            tResp.decode(ocspResponseBytes);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            resultVec.addElement(new Integer(2));
            return resultVec;
        }
        try {
            int respStat = tResp.getResponseStatus().getIntValue();
            if (respStat != 0) {
                if (respStat == 1) {
                    resultVec.add(new Integer(6));
                    return resultVec;
                }
                if (respStat == 2) {
                    resultVec.add(new Integer(6));
                    return resultVec;
                }
                if (respStat == 3) {
                    resultVec.add(new Integer(6));
                    return resultVec;
                }
                if (respStat == 5) {
                    resultVec.add(new Integer(6));
                    return resultVec;
                }
                if (respStat == 6) {
                    resultVec.add(new Integer(6));
                    return resultVec;
                }
            }
            BasicOCSPResponse basicOCSPResp = new BasicOCSPResponse("basicOCSPResp");
            try {
                basicOCSPResp.decode((byte[])tResp.getResponseBytes().getResponse().getValue());
            }
            catch (Exception exc) {
                exc.printStackTrace();
                resultVec.addElement(new Integer(2));
                return resultVec;
            }
            int verifyOCSPSigner = OCSPFabrikasi.verifyBasicOCSPResponse(basicOCSPResp);
            if (verifyOCSPSigner != 0) {
                resultVec.addElement(new Integer(verifyOCSPSigner));
                return resultVec;
            }
            ResponseData respData = basicOCSPResp.getTbsResponseData();
            Vector respVector = respData.getReponses();
            if (respVector.size() == 0) {
                resultVec.addElement(new Integer(2));
                return resultVec;
            }
            SingleResponse singleResp = (SingleResponse)respVector.get(0);
            CertStatus certStat = singleResp.getCertStatus();
            if (certStat.getStatus() == 0) {
                resultVec.addElement(new Integer(7));
                resultVec.addElement(ocspResponseBytes);
                resultVec.addElement((Date)respData.getProducedAt().getValue());
                return resultVec;
            }
            if (certStat.getStatus() == 1) {
                resultVec.addElement(new Integer(8));
                RevokedInfo revokedInfo = certStat.getRevokedInfo();
                if (revokedInfo.getRevocationReason().getValue() != null) {
                    resultVec.addElement(new Integer(revokedInfo.getRevocationReason().getValueAsInt()));
                    resultVec.addElement((Date)revokedInfo.getRevocationTime().getValue());
                }
                resultVec.addElement(ocspResponseBytes);
                resultVec.addElement((Date)respData.getProducedAt().getValue());
                return resultVec;
            }
            if (certStat.getStatus() == 2) {
                resultVec.addElement(new Integer(9));
                resultVec.addElement(ocspResponseBytes);
                resultVec.addElement((Date)respData.getProducedAt().getValue());
                return resultVec;
            }
            resultVec.addElement(new Integer(2));
            return resultVec;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            resultVec.addElement(new Integer(2));
            return resultVec;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] sendOCSPRequestAndGetResponse(byte[] ocspReqBytes, String ocspAddress, String httpRequestMethod, int timeoutInSeconds) {
        try {
            HttpURLConnection connection = null;
            byte[] ocspResponseBytes = null;
            if (httpRequestMethod.equals(HTTP_POST)) {
                int len;
                URL u = new URL(ocspAddress);
                URLConnection uc = u.openConnection();
                if (timeoutInSeconds != -1) {
                    uc.setConnectTimeout(timeoutInSeconds * 1000);
                    uc.setReadTimeout(timeoutInSeconds * 1000);
                }
                connection = (HttpURLConnection)uc;
                connection.setUseCaches(false);
                connection.setRequestMethod(httpRequestMethod);
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setRequestProperty("Content-Length", Integer.toString(ocspReqBytes.length));
                connection.setRequestProperty("Content-Type", "application/ocsp-request");
                OutputStream out = connection.getOutputStream();
                out.write(ocspReqBytes);
                out.close();
                InputStream is = connection.getInputStream();
                byte[] buf = new byte[2000];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((len = is.read(buf)) != -1) {
                    baos.write(buf, 0, len);
                }
                ocspResponseBytes = baos.toByteArray();
                connection.disconnect();
                return ocspResponseBytes;
            } else {
                Base64 b64 = new Base64();
                String ocspReqStr = b64.encodeToString(ocspReqBytes, false);
                String ocspReqStr2 = ocspReqStr.replace("+", "%2B");
                ocspReqStr2 = ocspReqStr2.replace("=", "%3D");
                URL u = new URL(ocspAddress);
                String ocspDomainName = ocspAddress.replace("http://", "");
                Socket sock = new Socket(ocspDomainName, 80);
                if (timeoutInSeconds != -1) {
                    sock.setSoTimeout(timeoutInSeconds * 1000);
                }
                OutputStreamWriter writer = new OutputStreamWriter(sock.getOutputStream(), "US-ASCII");
                writer.write("GET " + ocspReqStr2 + " HTTP/1.1\r\n");
                ((Writer)writer).flush();
                BufferedReader reader = new BufferedReader(new InputStreamReader(sock.getInputStream(), "US-ASCII"));
                String line = reader.readLine();
                if (line == null || !line.startsWith("HTTP/")) throw new IOException("Bad protocol");
                int sp = line.indexOf(32);
                String status = line.substring(sp + 1, sp + 4);
                if (!status.equals("200")) throw new FileNotFoundException("Host reports error " + status);
                while (line.length() != 0) {
                    line = reader.readLine();
                }
                char[] buf = new char[200000];
                int actualLen = reader.read(buf, 0, 200000);
                ocspResponseBytes = new byte[actualLen];
                for (int i = 0; i < actualLen; ++i) {
                    ocspResponseBytes[i] = (byte)buf[i];
                }
                reader.close();
                ((Writer)writer).close();
                sock.close();
            }
            return ocspResponseBytes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getCertStatusFromSingleResponse(SingleResponse sresp, Certificate cert) {
        try {
            String hashAlgOid = (String)sresp.getCertId().getHashAlgorithm().getalgorithm().getValue();
            byte[] issuerNameHash = (byte[])sresp.getCertId().getIssuerNameHash().getValue();
            byte[] tempIssuerNameBytes = cert.gettbsCertificate().getissuer().getEncoded();
            byte[] tempIssuerNameHash = HashFabrikasi.hashAl(tempIssuerNameBytes, hashAlgOid);
            if (OCSPFabrikasi.areByteArraysEqual(issuerNameHash, tempIssuerNameHash)) {
                BigInteger serialFromCert;
                BigInteger serialFromResp = (BigInteger)sresp.getCertId().getSerialNumber().getValue();
                if (serialFromResp.equals(serialFromCert = (BigInteger)cert.gettbsCertificate().getserialNumber().getValue())) {
                    if (sresp.getCertStatus().getStatus() == 0) {
                        return 7;
                    }
                    if (sresp.getCertStatus().getStatus() == 1) {
                        return 8;
                    }
                    return 9;
                }
                return 10;
            }
            return 10;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return 10;
        }
    }

    public static Date getResponseTimeFromResponse(BasicOCSPResponse basicResp) {
        try {
            return (Date)basicResp.getTbsResponseData().getProducedAt().getValue();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static BasicOCSPResponse getBasicResponseFromResponse(byte[] ocspResponseBytes) {
        OCSPResponse tResp = new OCSPResponse("tResp");
        try {
            tResp.decode(ocspResponseBytes);
        }
        catch (Exception exc) {
            return null;
        }
        BasicOCSPResponse basicOCSPResp = new BasicOCSPResponse("basicOCSPResp");
        try {
            basicOCSPResp.decode((byte[])tResp.getResponseBytes().getResponse().getValue());
            basicOCSPResp = OCSPFabrikasi.patchResponseWithVersion(basicOCSPResp);
        }
        catch (Exception exc) {
            return null;
        }
        return basicOCSPResp;
    }

    public static BasicOCSPResponse patchResponseWithVersion(BasicOCSPResponse basicResp) {
        try {
            Certificate responderCert = OCSPFabrikasi.extractResponderCertFromBasicOCSPResponse(basicResp);
            if (responderCert.gettbsCertificate().getsubject().getCN().indexOf("UEKAE") != -1) {
                basicResp.getTbsResponseData().getVersion().setDefaultValue("45");
            }
            return basicResp;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static int isCertificateValid(BasicOCSPResponse basicOCSPResponse, Certificate cert) {
        try {
            Vector singleRespVec = basicOCSPResponse.getTbsResponseData().getReponses();
            for (Object singleResp : singleRespVec) {
                int result = OCSPFabrikasi.getCertStatusFromSingleResponse((SingleResponse)singleResp, cert);
                if (result == 10) continue;
                return result;
            }
            return 10;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static OCSPResponse sertifikaOCSPSorgusuYapTumCevabiVer(Certificate sorgulanacakSertifika, Certificate kokSertifika, int zamanAsimiSaniye, String requestHashAlgOid) throws OCSPException {
        try {
            String adres = null;
            Extensions exts = sorgulanacakSertifika.gettbsCertificate().getextensions();
            Extension authInfoExt = exts.getExtensionByOID("1.3.6.1.5.5.7.1.1");
            if (authInfoExt == null) {
                throw new OCSPException(11);
            }
            AuthorityInfoAccessSyntax aias = new AuthorityInfoAccessSyntax();
            aias.decodeExtVal((byte[])authInfoExt.getextnValue().getValue());
            Vector vecAccess = aias.getAccessDescriptions();
            for (int i = 0; i < vecAccess.size(); ++i) {
                AccessDescription acDesc = (AccessDescription)vecAccess.elementAt(i);
                if (!((String)acDesc.getAccessMethod().getValue()).equals("1.3.6.1.5.5.7.48.1")) continue;
                adres = acDesc.getAccessLocation().getURI();
            }
            if (adres == null) {
                throw new OCSPException(11);
            }
            Vector sonucVec = OCSPFabrikasi.queryUsingOCSP(sorgulanacakSertifika, kokSertifika, adres, zamanAsimiSaniye, requestHashAlgOid);
            int sorguSonuc = (Integer)sonucVec.elementAt(0);
            OCSPResponse result = new OCSPResponse();
            switch (sorguSonuc) {
                case 5: {
                    throw new OCSPException(5);
                }
                case 6: {
                    throw new OCSPException(6);
                }
                case 2: {
                    throw new OCSPException(2);
                }
                case 1: {
                    throw new OCSPException(1);
                }
                case 3: {
                    throw new OCSPException(3);
                }
                case 4: {
                    throw new OCSPException(4);
                }
                case 7: {
                    result.decode((byte[])sonucVec.elementAt(1));
                    return result;
                }
                case 9: {
                    result.decode((byte[])sonucVec.elementAt(1));
                    return result;
                }
                case 8: {
                    result.decode((byte[])sonucVec.elementAt(1));
                    return result;
                }
            }
            throw new OCSPException(2);
        }
        catch (Exception e) {
            throw new OCSPException(-1);
        }
    }

    public static boolean areByteArraysEqual(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }
}

