/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.ess;

import com.turktrust.asn1.Any;
import com.turktrust.asn1.Null;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.Sequence;
import com.turktrust.ess.IssuerSerial;
import com.turktrust.x509.AlgorithmIdentifier;

public class ESSCertIdv2
extends Sequence {
    private AlgorithmIdentifier hashAlgorithm = new AlgorithmIdentifier();
    private OctetString certHash = new OctetString();
    private IssuerSerial issuerSerial = new IssuerSerial();
    private AlgorithmIdentifier defaultHashAlgorithm;

    public ESSCertIdv2() {
        super("default_ESSCertIdv2");
        this.setUpElements();
    }

    public ESSCertIdv2(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.hashAlgorithm);
        Null parNull = new Null("Null_par");
        Any anyNull = new Any("Any_null");
        anyNull.setValue(parNull);
        ObjectID sha256ObjId = new ObjectID("Hash");
        sha256ObjId.setValue("2.16.840.1.101.3.4.2.1");
        this.defaultHashAlgorithm = new AlgorithmIdentifier("Hash");
        this.defaultHashAlgorithm.setalgorithm(sha256ObjId);
        this.defaultHashAlgorithm.setparameters(anyNull);
        this.defaultHashAlgorithm.commitElementUpdate();
        this.hashAlgorithm.setOptional(true);
        super.addElement(this.certHash);
        super.addElement(this.issuerSerial);
        this.issuerSerial.setOptional(true);
    }

    public void setHashAlgorithm(AlgorithmIdentifier value) {
        this.hashAlgorithm = value;
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        if (this.hashAlgorithm.getalgorithm().getValue() != null) {
            return this.hashAlgorithm;
        }
        return this.defaultHashAlgorithm;
    }

    public void setCertHash(OctetString value) {
        this.certHash = value;
    }

    public OctetString getCertHash() {
        return this.certHash;
    }

    public void setIssuerSerial(IssuerSerial value) {
        this.issuerSerial = value;
    }

    public IssuerSerial getIssuerSerial() {
        return this.issuerSerial;
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }
}

