/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerOutputStream;
import com.objsys.asn1j.runtime.Asn1CharString;
import com.objsys.asn1j.runtime.Asn1ConsVioException;
import com.objsys.asn1j.runtime.Asn1Exception;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1PerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1PerOutputStream;
import com.objsys.asn1j.runtime.Asn1Tag;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class Asn1UTF8String
extends Asn1CharString {
    public static final Asn1Tag TAG = new Asn1Tag(0, 0, 12);

    public Asn1UTF8String() {
        super((short)12);
    }

    public Asn1UTF8String(String string) {
        super(string, (short)12);
    }

    public static String decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, Asn1Tag asn1Tag, int n2) throws Asn1Exception, IOException {
        int n3 = asn1Tag != null ? Asn1UTF8String.matchTag(asn1BerDecodeBuffer, asn1Tag) : n2;
        Asn1OctetString asn1OctetString = new Asn1OctetString();
        asn1OctetString.decode(asn1BerDecodeBuffer, false, n3);
        String string = new String(asn1OctetString.value, "UTF8");
        if (asn1Tag != null && n3 == -9999) {
            Asn1UTF8String.matchTag(asn1BerDecodeBuffer, Asn1Tag.EOC);
        }
        return string;
    }

    public void decode(Asn1BerDecodeBuffer asn1BerDecodeBuffer, boolean bl, int n2) throws Asn1Exception, IOException {
        Asn1Tag asn1Tag = bl ? TAG : null;
        this.value = Asn1UTF8String.decode(asn1BerDecodeBuffer, asn1Tag, n2);
    }

    public static int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, Asn1Tag asn1Tag, String string) throws Asn1Exception {
        int n2 = 0;
        try {
            byte[] byArray = string.getBytes("UTF8");
            n2 = byArray.length;
            asn1BerEncodeBuffer.copy(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("This JVM does not support UTF-8 encoding");
            unsupportedEncodingException.printStackTrace();
        }
        if (asn1Tag != null) {
            n2 += asn1BerEncodeBuffer.encodeTagAndLength(asn1Tag, n2);
        }
        return n2;
    }

    public int encode(Asn1BerEncodeBuffer asn1BerEncodeBuffer, boolean bl) throws Asn1Exception {
        Asn1Tag asn1Tag = bl ? TAG : null;
        return Asn1UTF8String.encode(asn1BerEncodeBuffer, asn1Tag, this.value);
    }

    public static String decodeUTF8(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        int n2;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = null;
        do {
            if ((n2 = (int)asn1PerDecodeBuffer.decodeLength()) <= 0) continue;
            asn1PerDecodeBuffer.byteAlign();
            byArray = n4 == 0 ? Asn1UTF8String.a(n3) : Asn1UTF8String.a(byArray, n3 += n2);
            asn1PerDecodeBuffer.decodeBitsToOctetArray(byArray, n4, n2 * 8);
            if (n2 < 16384) continue;
            n4 = n3;
        } while (n2 >= 16384);
        String string = null;
        if (byArray != null) {
            string = new String(byArray, "UTF8");
        }
        return string;
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer) throws Asn1Exception, IOException {
        this.value = Asn1UTF8String.decodeUTF8(asn1PerDecodeBuffer);
        asn1PerDecodeBuffer.setTypeCode((short)12);
    }

    public void decode(Asn1PerDecodeBuffer asn1PerDecodeBuffer, long l2, long l3) throws Asn1Exception, IOException {
        int n2;
        this.value = Asn1UTF8String.decodeUTF8(asn1PerDecodeBuffer);
        asn1PerDecodeBuffer.setTypeCode((short)12);
        int n3 = n2 = this.value == null ? 0 : this.value.length();
        if ((long)n2 < l2 || (long)n2 > l3) {
            throw new Asn1ConsVioException("Asn1UTF8String.length", n2);
        }
    }

    public static void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, String string) throws Asn1Exception, IOException {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("This JVM does not support UTF-8 encoding");
            unsupportedEncodingException.printStackTrace();
            return;
        }
        int n2 = byArray.length;
        int n3 = 0;
        while (true) {
            int n4;
            if ((n4 = (int)asn1PerEncodeBuffer.encodeLength(n2)) > 0) {
                asn1PerEncodeBuffer.byteAlign();
                asn1PerEncodeBuffer.encodeBits(byArray, n3, n4 * 8);
            }
            if ((n2 -= n4) <= 0) break;
            n3 += n4;
        }
        asn1PerEncodeBuffer.encodeLengthEOM(n2);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer) throws Asn1Exception, IOException {
        Asn1UTF8String.encode(asn1PerEncodeBuffer, this.value);
    }

    public void encode(Asn1PerEncodeBuffer asn1PerEncodeBuffer, long l2, long l3) throws Asn1Exception, IOException {
        if ((long)this.value.length() < l2 || (long)this.value.length() > l3) {
            throw new Asn1ConsVioException("Asn1UTF8String.length", this.value.length());
        }
        Asn1UTF8String.encode(asn1PerEncodeBuffer, this.value);
    }

    public void setAnyAttribute(String string, String string2) {
        this.value = string + "=\"" + string2 + "\"";
    }

    private static byte[] a(int n2) {
        return new byte[n2];
    }

    private static byte[] a(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        return byArray2;
    }

    public static void encode(Asn1BerOutputStream asn1BerOutputStream, Asn1Tag asn1Tag, String string) throws Asn1Exception, IOException {
        try {
            byte[] byArray = string.getBytes("UTF8");
            if (asn1Tag != null) {
                asn1BerOutputStream.encodeTag(asn1Tag);
            }
            asn1BerOutputStream.encodeLength(byArray.length);
            asn1BerOutputStream.write(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("This JVM does not support UTF-8 encoding");
            unsupportedEncodingException.printStackTrace();
        }
    }

    public void encode(Asn1BerOutputStream asn1BerOutputStream, boolean bl) throws Asn1Exception, IOException {
        Asn1Tag asn1Tag = bl ? TAG : null;
        Asn1UTF8String.encode(asn1BerOutputStream, asn1Tag, this.value);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b);
        asn1PerOutputStream.a(false);
    }

    public void encode(Asn1PerOutputStream asn1PerOutputStream, long l2, long l3) throws Asn1Exception, IOException {
        this.encode(asn1PerOutputStream.b, l2, l3);
        asn1PerOutputStream.a(false);
    }
}

