/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.common.crypto;

import java.util.Map;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.crypto.IRandom;
import tr.gov.tubitak.uekae.esya.api.common.crypto.LimitReachedException;

public abstract class BasePRNG
implements IRandom {
    protected String name;
    protected boolean initialised;
    protected byte[] buffer;
    protected int ndx;
    protected static final int MIN_BUFFER_SIZE = 2048;
    protected int bufferSize = 2048;

    public int getBufferSize() {
        return this.bufferSize;
    }

    protected BasePRNG(String name) {
        this.name = name;
        boolean bl = LimitReachedException.b;
        this.initialised = false;
        this.buffer = new byte[0];
        if (bl) {
            int n = ESYAException.b;
            ESYAException.b = ++n;
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void init(Map attributes) {
        this.setup(attributes);
        this.ndx = this.buffer.length;
        this.initialised = true;
    }

    public void setBufferSize(int bufSize) {
        block4: {
            boolean bl;
            block6: {
                block5: {
                    this.bufferSize = bufSize;
                    this.buffer = new byte[this.bufferSize];
                    this.ndx = this.bufferSize;
                    boolean bl2 = LimitReachedException.b;
                    if (ESYAException.b == 0) break block4;
                    if (!bl2) break block5;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
            LimitReachedException.b = bl;
        }
    }

    @Override
    public byte nextByte() throws IllegalStateException, LimitReachedException {
        if (!this.initialised) {
            throw new IllegalStateException();
        }
        return this.a();
    }

    @Override
    public void nextBytes(byte[] out, int offset, int length) throws IllegalStateException, LimitReachedException {
        boolean bl;
        block16: {
            block15: {
                bl = LimitReachedException.b;
                if (out == null) {
                    return;
                }
                if (!this.initialised) {
                    throw new IllegalStateException();
                }
                if (offset < 0 || offset >= out.length) break block15;
                if (length >= 1) break block16;
            }
            return;
        }
        int n = offset + length > out.length ? out.length - offset : length;
        int n2 = n;
        for (int i = 0; i < n2; ++i) {
            out[offset++] = this.a();
            if (!bl) continue;
        }
    }

    public boolean isInitialised() {
        return this.initialised;
    }

    private byte a() throws LimitReachedException {
        if (this.ndx >= this.buffer.length) {
            this.fillBlock();
            this.ndx = 0;
        }
        return this.buffer[this.ndx++];
    }

    @Override
    public boolean isUseTRSU() {
        return true;
    }

    @Override
    public abstract Object clone();

    public abstract void setup(Map var1);

    public abstract void fillBlock() throws LimitReachedException;
}

