/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.cms;

import com.turktrust.asn1.ASN1Object;
import com.turktrust.asn1.Sequence;
import com.turktrust.cms.CMSVersion;
import com.turktrust.cms.RecipientIdentifier;
import com.turktrust.pkcs7.EncryptedKey;
import com.turktrust.pkcs7.KeyEncryptionAlgorithmIdentifier;

public class KeyTransRecipientInfo
extends Sequence {
    private CMSVersion version = new CMSVersion("version");
    private RecipientIdentifier rid = new RecipientIdentifier("rid");
    private KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithm = new KeyEncryptionAlgorithmIdentifier("keyEncryptionAlgorithm");
    private EncryptedKey encryptedKey = new EncryptedKey("encryptedKey");

    public KeyTransRecipientInfo(String name) {
        super(name);
        this.setUpElements();
    }

    public KeyTransRecipientInfo() {
        super("default_KeyTransRecipientInfo");
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.version);
        super.addElement(this.rid);
        super.addElement((ASN1Object)this.keyEncryptionAlgorithm);
        super.addElement((ASN1Object)this.encryptedKey);
    }

    public void commitElementUpdate() {
        super.clearElements();
        this.setUpElements();
    }

    public EncryptedKey getEncryptedKey() {
        return this.encryptedKey;
    }

    public void setEncryptedKey(EncryptedKey encryptedKey) {
        this.encryptedKey = encryptedKey;
    }

    public KeyEncryptionAlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public void setKeyEncryptionAlgorithm(KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithm) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithm;
    }

    public RecipientIdentifier getRid() {
        return this.rid;
    }

    public void setRid(RecipientIdentifier rid) {
        this.rid = rid;
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    public void setVersion(CMSVersion version) {
        this.version = version;
    }
}

