/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.ess;

import com.turktrust.asn1.Sequence;
import com.turktrust.asn1.SequenceOf;
import com.turktrust.ess.ESSCertIdv2;
import com.turktrust.x509.PolicyInformation;
import java.util.Vector;

public class SigningCertificateV2
extends Sequence {
    public static final String ATTRIBUTE_OBJ_ID = "1.2.840.113549.1.9.16.2.47";
    private SequenceOf certs = new SequenceOf("certs", new ESSCertIdv2());
    private SequenceOf policies = new SequenceOf("policies", new PolicyInformation());

    public SigningCertificateV2() {
        super("default_signingCertificateV2");
        this.setUpElements();
    }

    public SigningCertificateV2(String name) {
        super(name);
        this.setUpElements();
    }

    protected void setUpElements() {
        super.addElement(this.certs);
        super.addElement(this.policies);
        this.policies.setOptional(true);
    }

    public void setESSCertIds(Vector values) {
        this.certs.setValue(values);
    }

    public Vector getESSCertIds() {
        return (Vector)this.certs.getValue();
    }

    public void setPolicyInfos(Vector values) {
        this.policies.setValue(values);
    }

    public Vector getPolicyInfos() {
        return (Vector)this.policies.getValue();
    }

    public void commitElementUpdate() {
        super.clearElements();
        if (((Vector)this.policies.getValue()).size() > 0) {
            this.setUpElements();
        } else {
            super.addElement(this.certs);
        }
    }
}

