/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.TagInfo;

public class OctetString
extends BaseASN1Object {
    private byte[] value;

    public OctetString() {
        super("");
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(4);
        this.setTagNumber(4);
    }

    public OctetString(String name) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(4);
        this.setTagNumber(4);
    }

    public OctetString(String name, Object value) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(4);
        this.setTagNumber(4);
        if (value instanceof byte[]) {
            this.setValue(value);
        }
    }

    public void setValue(Object value) {
        OctetString.trace("OctetString.setValue: setting value to " + value);
        this.value = (byte[])value;
    }

    public Object getValue() {
        return this.value;
    }

    public void decode(byte[] data) throws DecodeException {
        TagInfo tagInfo = this.getTagInfo(data, 0);
        if (this.tagClass != tagInfo.tagClass) {
            throw new DecodeException();
        }
        if (this.tagMethod != tagInfo.tagMethod) {
            throw new DecodeException();
        }
        if (this.tagNumber != tagInfo.tagNumber) {
            throw new DecodeException();
        }
        if (this.tagMethod != 1 && this.type != tagInfo.type) {
            throw new DecodeException();
        }
        if (tagInfo.contentIndex + tagInfo.contentLength != data.length) {
            throw new DecodeException();
        }
        this.setType(4);
        this.value = new byte[tagInfo.contentLength];
        System.arraycopy(data, tagInfo.contentIndex, this.value, 0, tagInfo.contentLength);
    }

    protected byte[] getContentEncoding() {
        if (this.value == null) {
            OctetString.trace("OctetString.getContentEncoding: value is null!");
        }
        return this.value;
    }

    public String toString() {
        if (this.value != null) {
            return new String(super.toString() + " length =\t" + this.value.length);
        }
        return new String(super.toString());
    }

    public static void main(String[] args) throws DecodeException {
        byte[] a = new byte[]{4, 6, 100, 97, 116, 105, 100, 0};
        OctetString i = new OctetString("TestOctetString");
        i.decode(a);
        System.out.println(i.toString());
        a = i.getEncoded();
        for (int z = 0; z < a.length; ++z) {
            System.out.println(Integer.toString(a[z] & 0xFF, 16));
        }
    }
}

