/*
 * Decompiled with CFR 0.152.
 */
package com.objsys.asn1j.runtime;

import com.objsys.asn1j.runtime.Asn1Exception;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Asn1Tag
implements Serializable {
    public static final boolean EXPL = true;
    public static final boolean IMPL = false;
    public static final short UNIV = 0;
    public static final short APPL = 64;
    public static final short CTXT = 128;
    public static final short PRIV = 192;
    public static final short ClassMask = 192;
    public static final short PRIM = 0;
    public static final short CONS = 32;
    public static final short FormMask = 32;
    public static final short EXTIDCODE = 31;
    public static final short IDMask = 31;
    public static final Asn1Tag ENUM = new Asn1Tag(0, 0, 10);
    public static final Asn1Tag EOC = new Asn1Tag(0, 0, 0);
    public static final Asn1Tag SEQUENCE = new Asn1Tag(0, 32, 16);
    public static final Asn1Tag SET = new Asn1Tag(0, 32, 17);
    public static final short Bit8Mask = 128;
    public static final short L7BitsMask = 127;
    public transient short mClass;
    public transient short mForm;
    public transient int mIDCode;

    public Asn1Tag() {
        this.mClass = 0;
        this.mForm = 0;
        this.mIDCode = 0;
    }

    public Asn1Tag(Asn1Tag asn1Tag) {
        this.mClass = asn1Tag.mClass;
        this.mForm = asn1Tag.mForm;
        this.mIDCode = asn1Tag.mIDCode;
    }

    public Asn1Tag(short s2, short s3, int n2) {
        this.mClass = s2;
        this.mForm = s3;
        this.mIDCode = n2;
    }

    public boolean equals(short s2, short s3, int n2) {
        return this.mClass == s2 && this.mIDCode == n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Asn1Tag)) {
            return false;
        }
        Asn1Tag asn1Tag = (Asn1Tag)object;
        return this.equals(asn1Tag.mClass, asn1Tag.mForm, asn1Tag.mIDCode);
    }

    public boolean isConstructed() {
        return this.mForm == 32;
    }

    public boolean isEOC() {
        return this.equals((short)0, (short)0, 0);
    }

    public String toString() {
        boolean bl = Asn1Exception.z;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        switch (this.mClass) {
            case 0: {
                stringBuffer.append("UNIVERSAL ");
                if (!bl) break;
            }
            case 64: {
                stringBuffer.append("APPLICATION ");
                if (!bl) break;
            }
            case 128: {
                if (!bl) break;
            }
            case 192: {
                stringBuffer.append("PRIVATE ");
                if (!bl) break;
            }
            default: {
                stringBuffer.append("??? ");
            }
        }
        stringBuffer.append(Integer.toString(this.mIDCode));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeShort(1);
        objectOutputStream.writeShort(this.mClass);
        objectOutputStream.writeShort(this.mForm);
        objectOutputStream.writeShort(this.mIDCode);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.readShort();
        this.mClass = objectInputStream.readShort();
        this.mForm = objectInputStream.readShort();
        this.mIDCode = objectInputStream.readShort();
    }
}

