/*
 * Decompiled with CFR 0.152.
 */
package tubitak.akis.cif.commands;

import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Random;
import javax.crypto.Cipher;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import tubitak.akis.cif.akisExceptions.AkisCIFException;
import tubitak.akis.cif.akisExceptions.AkisCardException;
import tubitak.akis.cif.akisExceptions.AkisSWException;
import tubitak.akis.cif.akisExceptions.UnsupportedVersionException;
import tubitak.akis.cif.commands.AbstractAkisCommands;
import tubitak.akis.cif.commands.PublicKeys;
import tubitak.akis.cif.dataStructures.AkisKey;
import tubitak.akis.cif.dataStructures.Algorithm;
import tubitak.akis.cif.dataStructures.AuthenticationType;
import tubitak.akis.cif.dataStructures.FCI;
import tubitak.akis.cif.dataStructures.FileAccessRules;
import tubitak.akis.cif.dataStructures.FileIDs;
import tubitak.akis.cif.dataStructures.FileLevel;
import tubitak.akis.cif.dataStructures.FileTypes;
import tubitak.akis.cif.dataStructures.GetDataModes;
import tubitak.akis.cif.dataStructures.KeyType;
import tubitak.akis.cif.dataStructures.Manufacturer;
import tubitak.akis.cif.dataStructures.P1P2;
import tubitak.akis.cif.dataStructures.RSAKeyFields;
import tubitak.akis.cif.dataStructures.Version;
import tubitak.akis.cif.functions.Crypto;
import tubitak.akis.cif.functions.ICommandTransmitter;

public class CommandsV11
extends AbstractAkisCommands {
    protected PublicKey currentSecureMessagingGeneratingKey = null;

    public CommandsV11(ICommandTransmitter transmitter, Version vers) {
        super(transmitter, vers);
        this.phaseBytePosition = 8;
        this.pso_param.cds = new P1P2(-98, -102);
        this.pso_param.vds = new P1P2(0, -88);
        this.pso_param.enc = new P1P2(-122, -128);
        this.pso_param.dec = new P1P2(-128, -122);
        this.pso_param.ccc = new P1P2(-114, -128);
        this.pso_param.vcc = new P1P2(0, -94);
        this.fileAccessRules = new FileAccessRules(-65, -77, -1, 0);
        this.fileTypes = new FileTypes(-128, 65, 67, 69);
    }

    @Override
    public void createBinaryEFbySFI(byte[] FID, byte SFI, FileTypes.FileType type, FileAccessRules.FileAccessRule access) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void createDFbyFID(byte[] FID, FileTypes.FileType type, FileAccessRules.FileAccessRule access) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandBytes = new byte[]{-128, 16, 0, -73, 2, 0, 0};
        commandBytes[5] = FID[0];
        commandBytes[6] = FID[1];
        ResponseAPDU response = this.sendCommand(commandBytes);
    }

    @Override
    public void createDFbyName(byte[] FID, byte[] name, FileTypes.FileType type, FileAccessRules.FileAccessRule access) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandBytes = new byte[]{-128, 16, 0, 55, 0};
        byte[] createCommand = null;
        commandBytes[4] = (byte)name.length;
        createCommand = new byte[name.length + commandBytes.length];
        System.arraycopy(commandBytes, 0, createCommand, 0, commandBytes.length);
        System.arraycopy(name, 0, createCommand, commandBytes.length, name.length);
        ResponseAPDU response = this.sendCommand(createCommand);
    }

    @Override
    public void deleteCurrent() {
        throw new UnsupportedVersionException();
    }

    @Override
    public void deleteByFIDUnderMF(byte[] FID, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        byte ins = (byte)(level == FileLevel.DF ? 17 : 22);
        byte[] eraseCommand = new byte[]{-128, ins, 0, 0, 2, FID[0], FID[1]};
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteByFIDUnderDF(byte[] FID, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        byte ins = (byte)(level == FileLevel.DF ? 17 : 22);
        byte p1 = (byte)(level == FileLevel.DF ? 1 : 2);
        byte[] eraseCommand = new byte[]{-128, ins, p1, 0, 2, FID[0], FID[1]};
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteDFByName(byte[] name) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] eraseCommandHeader = new byte[]{-128, 17, 4, 0, 0};
        byte[] eraseCommand = new byte[eraseCommandHeader.length + name.length];
        eraseCommandHeader[4] = (byte)name.length;
        System.arraycopy(eraseCommandHeader, 0, eraseCommand, 0, eraseCommandHeader.length);
        System.arraycopy(name, 0, eraseCommand, eraseCommandHeader.length, name.length);
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteByFIDPathFromMF(byte[] path, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        byte ins = (byte)(level == FileLevel.DF ? 17 : 22);
        byte[] eraseCommandHeader = new byte[]{-128, ins, 8, 0, 0};
        byte[] eraseCommand = new byte[eraseCommandHeader.length + path.length];
        eraseCommandHeader[4] = (byte)path.length;
        System.arraycopy(eraseCommandHeader, 0, eraseCommand, 0, eraseCommandHeader.length);
        System.arraycopy(path, 0, eraseCommand, eraseCommandHeader.length, path.length);
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteByFIDPathFromDF(byte[] path, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        byte ins = (byte)(level == FileLevel.DF ? 17 : 22);
        byte[] eraseCommandHeader = new byte[]{-128, ins, 9, 0, 0};
        byte[] eraseCommand = new byte[eraseCommandHeader.length + path.length];
        eraseCommandHeader[4] = (byte)path.length;
        System.arraycopy(eraseCommandHeader, 0, eraseCommand, 0, eraseCommandHeader.length);
        System.arraycopy(path, 0, eraseCommand, eraseCommandHeader.length, path.length);
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteByNamePathFromMF(byte[] path, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        byte ins = (byte)(level == FileLevel.DF ? 17 : 22);
        byte[] eraseCommandHeader = new byte[]{-128, ins, 12, 0, 0};
        byte[] eraseCommand = new byte[eraseCommandHeader.length + path.length];
        eraseCommandHeader[4] = (byte)path.length;
        System.arraycopy(eraseCommandHeader, 0, eraseCommand, 0, eraseCommandHeader.length);
        System.arraycopy(path, 0, eraseCommand, eraseCommandHeader.length, path.length);
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteByNamePathFromDF(byte[] path, FileLevel level) throws AkisSWException, AkisCardException, AkisCIFException {
        byte ins = (byte)(level == FileLevel.DF ? 17 : 22);
        byte[] eraseCommandHeader = new byte[]{-128, ins, 13, 0, 0};
        byte[] eraseCommand = new byte[eraseCommandHeader.length + path.length];
        eraseCommandHeader[4] = (byte)path.length;
        System.arraycopy(eraseCommandHeader, 0, eraseCommand, 0, eraseCommandHeader.length);
        System.arraycopy(path, 0, eraseCommand, eraseCommandHeader.length, path.length);
        this.sendCommand(eraseCommand);
    }

    @Override
    public void deleteParentDF() {
        throw new UnsupportedVersionException();
    }

    public void selectFileByNameUnderActiveDF(byte[] name) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileByNameTemplate = new byte[]{0, -92, 13, 0};
        byte[] selectFileByNameCommand = new byte[selectFileByNameTemplate.length + name.length + 1];
        int index = 0;
        System.arraycopy(selectFileByNameTemplate, 0, selectFileByNameCommand, index, selectFileByNameTemplate.length);
        selectFileByNameCommand[index += selectFileByNameTemplate.length] = (byte)name.length;
        System.arraycopy(name, 0, selectFileByNameCommand, ++index, name.length);
        this.sendCommand(selectFileByNameCommand);
    }

    @Override
    public FCI selectMF() throws AkisSWException, AkisCardException, AkisCIFException {
        return this.selectFileUnderMF(FileIDs.MF);
    }

    @Override
    public FCI selectFileUnderMF(byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileCommand = new byte[]{0, -92, 0, 0, 2, 0, 0, 0};
        selectFileCommand[5] = FID[0];
        selectFileCommand[6] = FID[1];
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectChildDF(byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileCommand = new byte[]{0, -92, 1, 0, 2, 0, 0, 0};
        selectFileCommand[5] = FID[0];
        selectFileCommand[6] = FID[1];
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectEFUnderDF(byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileCommand = new byte[]{0, -92, 2, 0, 2, 0, 0, 0};
        selectFileCommand[5] = FID[0];
        selectFileCommand[6] = FID[1];
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectParentDF() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] selectFileCommand = new byte[]{0, -92, 3, 0, 0};
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectDFByName(byte[] name) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandBytes = new byte[]{0, -92, 4, 0, 0};
        byte[] selectFileCommand = null;
        commandBytes[4] = (byte)name.length;
        selectFileCommand = new byte[name.length + 6];
        int index = 0;
        System.arraycopy(commandBytes, 0, selectFileCommand, index, commandBytes.length);
        System.arraycopy(name, 0, selectFileCommand, index += commandBytes.length, name.length);
        selectFileCommand[index += name.length] = 0;
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectFromMFByPath(byte[] path) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandBytes = new byte[]{0, -92, 8, 0, 0};
        byte[] selectFileCommand = null;
        commandBytes[4] = (byte)path.length;
        selectFileCommand = new byte[path.length + 6];
        int index = 0;
        System.arraycopy(commandBytes, 0, selectFileCommand, index, commandBytes.length);
        System.arraycopy(path, 0, selectFileCommand, index += commandBytes.length, path.length);
        selectFileCommand[index += path.length] = 0;
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public FCI selectFromDFByPath(byte[] path) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] commandBytes = new byte[]{0, -92, 9, 0, 0};
        byte[] selectFileCommand = null;
        commandBytes[4] = (byte)path.length;
        selectFileCommand = new byte[path.length + 6];
        int index = 0;
        System.arraycopy(commandBytes, 0, selectFileCommand, index, commandBytes.length);
        System.arraycopy(path, 0, selectFileCommand, index += commandBytes.length, path.length);
        selectFileCommand[index += path.length] = 0;
        ResponseAPDU response = this.sendCommand(selectFileCommand);
        byte[] responseData = response.getData();
        return new FCI(responseData);
    }

    @Override
    public byte[] readFileBySelectingUnderActiveDF(byte[] FID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] data = null;
        int fileLength = this.selectEFUnderDF(FID).getFileLength();
        if (fileLength > 0) {
            data = new byte[fileLength];
            int unReadDataLength = fileLength;
            int index = 0;
            while (unReadDataLength > 0) {
                byte MSB = (byte)((index & 0xFF00) >> 8);
                byte LSB = (byte)(index & 0xFF);
                byte[] readFileCommand = new byte[]{0, -80, MSB, LSB, 0};
                ResponseAPDU response = this.sendCommand(readFileCommand);
                int readDataLength = response.getData().length;
                byte[] responseData = response.getData();
                System.arraycopy(responseData, 0, data, index, readDataLength);
                unReadDataLength -= readDataLength;
                index += readDataLength;
            }
        }
        return data;
    }

    @Override
    public void updateBinaryFile(byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        int dataLenInCommand;
        int index = 0;
        for (int unWritenDataLength = data.length; unWritenDataLength > 0; unWritenDataLength -= dataLenInCommand) {
            byte MSB = (byte)((index & 0xFF00) >> 8);
            byte LSB = (byte)(index & 0xFF);
            byte[] updateBinaryTemplate = new byte[]{0, -42, MSB, LSB, 0};
            dataLenInCommand = 0;
            dataLenInCommand = unWritenDataLength > 196 ? 196 : unWritenDataLength;
            updateBinaryTemplate[4] = (byte)dataLenInCommand;
            byte[] updateBinaryCommand = new byte[updateBinaryTemplate.length + dataLenInCommand];
            System.arraycopy(updateBinaryTemplate, 0, updateBinaryCommand, 0, updateBinaryTemplate.length);
            System.arraycopy(data, index, updateBinaryCommand, updateBinaryTemplate.length, dataLenInCommand);
            this.sendCommand(updateBinaryCommand);
            index += dataLenInCommand;
        }
    }

    @Override
    public int getPinRemainingUsageCount() throws AkisSWException, AkisCardException, AkisCIFException {
        ResponseAPDU response;
        block2: {
            byte[] remainedPinCountCommand = new byte[]{0, 32, 0, -127, 0};
            response = null;
            try {
                response = this.mCardChannel.transmit(new CommandAPDU(remainedPinCountCommand));
            }
            catch (Exception e) {
                if (e.getMessage().contains("63c")) break block2;
                throw new RuntimeException();
            }
        }
        return response.getBytes()[1] & 0xF;
    }

    @Override
    public AkisKey[] getKeyInfos() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] readKeysCommand = new byte[]{-128, 31, 0, 0, 0};
        byte[] data = this.sendCommand(readKeysCommand).getData();
        int keyCount = data[2];
        int startIndex = 5;
        AkisKey[] keys = new AkisKey[keyCount];
        for (int i = 0; i < keyCount; ++i) {
            byte keyID = data[startIndex + 4 * i];
            byte durumBilgisi = data[startIndex + 2 + 4 * i];
            KeyType type = null;
            type = (durumBilgisi & 0x1F) == 31 ? KeyType.PRIVATE_RSA : ((durumBilgisi & 0x60) == 96 ? KeyType.PUBLIC_RSA : KeyType.UNKNOWN);
            keys[i] = new AkisKey(keyID, type);
        }
        return keys;
    }

    @Override
    public int getMaxKeyID() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] readKeysCommand = new byte[]{-128, 31, 0, 0, 0};
        byte max = 0;
        ResponseAPDU response = null;
        try {
            response = this.sendCommand(readKeysCommand);
        }
        catch (AkisSWException e) {
            if (e.getErrorCode() == 25625L) {
                return 0;
            }
            throw e;
        }
        byte[] keyAttr = response.getData();
        for (int i = 0; i < keyAttr[2]; ++i) {
            max = keyAttr[i * 4 + 5] > max ? keyAttr[i * 4 + 5] : max;
        }
        return max;
    }

    @Override
    public byte[] getPublicExponent(byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] gpe = new byte[]{-128, 31, 64, keyID, 0};
        ResponseAPDU response = this.sendCommand(gpe);
        return response.getData();
    }

    @Override
    public byte[] getModulus(byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] gme = new byte[]{-128, 31, 32, keyID, 0};
        ResponseAPDU response = this.sendCommand(gme);
        return response.getData();
    }

    @Override
    public void writePrivateKey(RSAKeyFields fields, int keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] oneField = new byte[fields.prime_1.length + 2];
        oneField[0] = -47;
        oneField[1] = (byte)fields.prime_1.length;
        System.arraycopy(fields.prime_1, 0, oneField, 2, fields.prime_1.length);
        this.writeKey(oneField, (byte)-16, keyID);
        oneField = new byte[fields.prime_2.length + 2];
        oneField[0] = -46;
        oneField[1] = (byte)fields.prime_2.length;
        System.arraycopy(fields.prime_2, 0, oneField, 2, fields.prime_2.length);
        this.writeKey(oneField, (byte)-16, keyID);
        oneField = new byte[fields.exponent_1.length + 2];
        oneField[0] = -45;
        oneField[1] = (byte)fields.exponent_1.length;
        System.arraycopy(fields.exponent_1, 0, oneField, 2, fields.exponent_1.length);
        this.writeKey(oneField, (byte)-16, keyID);
        oneField = new byte[fields.exponent_2.length + 2];
        oneField[0] = -44;
        oneField[1] = (byte)fields.exponent_2.length;
        System.arraycopy(fields.exponent_2, 0, oneField, 2, fields.exponent_1.length);
        this.writeKey(oneField, (byte)-16, keyID);
        oneField = new byte[fields.coefficient.length + 2];
        oneField[0] = -43;
        oneField[1] = (byte)fields.coefficient.length;
        System.arraycopy(fields.coefficient, 0, oneField, 2, fields.coefficient.length);
        this.writeKey(oneField, (byte)-16, keyID);
        oneField = new byte[fields.modBytes.length + 2];
        oneField[0] = -41;
        oneField[1] = (byte)(fields.modBytes.length > 256 ? 0 : fields.modBytes.length);
        System.arraycopy(fields.modBytes, 0, oneField, 2, fields.modBytes.length);
        this.writeKey(oneField, (byte)-16, keyID);
    }

    @Override
    public void writePublicKey(RSAKeyFields fields, int keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] oneField = new byte[fields.public_Exponent.length + 2];
        oneField[0] = -42;
        oneField[1] = (byte)(fields.public_Exponent.length == 256 ? 0 : fields.public_Exponent.length);
        System.arraycopy(fields.public_Exponent, 0, oneField, 2, fields.public_Exponent.length);
        this.writeKey(oneField, (byte)-16, keyID);
        oneField = new byte[fields.modBytes.length + 2];
        oneField[0] = -41;
        oneField[1] = (byte)(fields.modBytes.length == 256 ? 0 : fields.modBytes.length);
        System.arraycopy(fields.modBytes, 0, oneField, 2, fields.modBytes.length);
        this.writeKey(oneField, (byte)-16, keyID);
    }

    protected void writeKey(byte[] data, byte type, int keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] wk1 = new byte[]{-128, 30, (byte)(keyID | 0x80), type};
        if (data.length > 230) {
            int remaining = data.length;
            int offset = 0;
            do {
                int dataPartLen = remaining > 230 ? 230 : remaining;
                byte[] wk = new byte[wk1.length + 1 + dataPartLen];
                System.arraycopy(wk1, 0, wk, 0, wk1.length);
                wk[wk1.length] = (byte)dataPartLen;
                System.arraycopy(data, offset, wk, wk1.length + 1, dataPartLen);
                if (remaining > 230) {
                    wk[0] = (byte)(wk[0] | 0x10);
                }
                this.sendCommand(wk);
                offset += dataPartLen;
            } while ((remaining -= 230) > 0);
        } else {
            byte[] wk = new byte[wk1.length + 1 + data.length];
            wk[wk1.length] = (byte)data.length;
            System.arraycopy(wk1, 0, wk, 0, wk1.length);
            System.arraycopy(data, 0, wk, wk1.length + 1, data.length);
            this.sendCommand(wk);
        }
    }

    @Override
    public void writeBACKey(byte[] key, byte passportKeyProp, byte passportKeyId) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void deleteKey(int keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] deleteKey = new byte[]{-128, 30, (byte)keyID, 0};
        this.sendCommand(deleteKey);
    }

    @Override
    public void putData(P1P2 params, byte[] data) {
        throw new UnsupportedOperationException("putData Not implemented");
    }

    @Override
    public byte[] getData(byte mode) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] getDataCommand = new byte[]{0, -54, 1, 0, 0};
        int Le = 0;
        if (mode == GetDataModes.copyright) {
            Le = 23;
        } else if (mode == GetDataModes.chip) {
            Le = 2;
        } else if (mode == GetDataModes.atr) {
            Le = 18;
        } else if (mode == GetDataModes.memory) {
            Le = 11;
        } else if (mode == GetDataModes.cardType) {
            Le = 1;
        } else if (mode == GetDataModes.system) {
            Le = 81;
        } else if (mode == GetDataModes.romCheckSum) {
            Le = 2;
        }
        getDataCommand[3] = mode;
        getDataCommand[getDataCommand.length - 1] = Le;
        ResponseAPDU response = this.sendCommand(getDataCommand);
        return response.getData();
    }

    @Override
    public byte[] getSerial() throws AkisCardException, AkisSWException, AkisCIFException {
        byte[] serial;
        try {
            serial = this.getSerialByKartTest();
        }
        catch (AkisCIFException ex) {
            serial = this.getSerialGetDataForActivation();
        }
        catch (AkisSWException ex) {
            serial = this.getSerialGetDataForActivation();
        }
        return serial;
    }

    @Override
    protected byte[] getSerialGetData() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] getDatabytes = this.getData(GetDataModes.system);
        byte[] serial = new byte[8];
        if (getDatabytes.length < 69) {
            throw new AkisCIFException("Serial number can not be read. Get Data command returned insufficient length data.");
        }
        System.arraycopy(getDatabytes, 57, serial, 0, 8);
        return serial;
    }

    @Override
    protected byte[] getSerialGetDataForActivation() throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] getDatabytes = this.getData(GetDataModes.system);
        byte[] serial = new byte[8];
        if (getDatabytes.length < 69) {
            throw new AkisCIFException("Serial number can not be read. Get Data command returned insufficient length data.");
        }
        if (this.manufacturer.equals((Object)Manufacturer.INF)) {
            System.arraycopy(getDatabytes, 59, serial, 0, 2);
            System.arraycopy(getDatabytes, 63, serial, 2, 6);
        } else {
            System.arraycopy(getDatabytes, 61, serial, 0, 8);
        }
        return serial;
    }

    @Override
    public int getEmptyMemory() throws AkisSWException, AkisCardException, AkisCIFException {
        int emptyMemory = 0;
        byte[] cardSystemInfo = this.getData(GetDataModes.system);
        emptyMemory = 0xFF & cardSystemInfo[76];
        emptyMemory <<= 8;
        emptyMemory += 0xFF & cardSystemInfo[77];
        emptyMemory <<= 8;
        return emptyMemory += 0xFF & cardSystemInfo[78];
    }

    @Override
    protected byte[] exchangeChallenge(byte[] encryptedRandomNumber) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] command = new byte[encryptedRandomNumber.length + 6];
        command[0] = -128;
        command[1] = -122;
        command[2] = 0;
        command[3] = 0;
        command[4] = -128;
        command[133] = 16;
        System.arraycopy(encryptedRandomNumber, 0, command, 5, encryptedRandomNumber.length);
        ResponseAPDU response = this.sendCommand(command);
        return response.getData();
    }

    @Override
    public void activate(byte[] data) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void verifyInit(byte[] initKey) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void verifyPerso(byte[] persoKey) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void externalAuthenticatePure(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyIFD, byte privateKeyICC, byte[] data) {
        throw new UnsupportedVersionException();
    }

    @Override
    public byte[] generateMseData(Algorithm signAlg, Algorithm hashAlg, byte[] publicKeyIFD, byte privateKeyICC, AuthenticationType authType) {
        throw new UnsupportedVersionException();
    }

    @Override
    public byte[] getChallenge(int len) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void verify(byte[] pin, boolean isMF) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] verifyCommandTemplate = new byte[]{0, 32, 0, -127, 0};
        if (isMF) {
            verifyCommandTemplate[3] = 1;
        }
        verifyCommandTemplate[4] = (byte)pin.length;
        byte[] verifyCommand = new byte[verifyCommandTemplate.length + pin.length];
        System.arraycopy(verifyCommandTemplate, 0, verifyCommand, 0, verifyCommandTemplate.length);
        System.arraycopy(pin, 0, verifyCommand, verifyCommandTemplate.length, pin.length);
        this.sendCommand(verifyCommand);
    }

    @Override
    public void verify(byte pinNo, byte[] pin, boolean isMF) {
        throw new UnsupportedVersionException();
    }

    @Override
    public void verifyWithPinPad(byte pinNo, boolean isMF) {
        throw new UnsupportedVersionException();
    }

    private void changeDFPINPUK(byte[] fid, boolean isPUK, byte[] oldPIN, byte[] newPIN) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] changepin = new byte[7 + oldPIN.length + newPIN.length];
        byte[] changepin1 = new byte[]{0, 36, 0, -127};
        if (isPUK) {
            changepin1[3] = -126;
        }
        byte[] lc = new byte[]{(byte)(newPIN.length + oldPIN.length + 2)};
        System.arraycopy(changepin1, 0, changepin, 0, 4);
        System.arraycopy(lc, 0, changepin, 4, 1);
        byte[] len = new byte[2];
        len[0] = (byte)oldPIN.length;
        System.arraycopy(len, 0, changepin, 5, 1);
        System.arraycopy(oldPIN, 0, changepin, 6, len[0]);
        len[1] = (byte)newPIN.length;
        System.arraycopy(len, 1, changepin, 6 + len[0], 1);
        System.arraycopy(newPIN, 0, changepin, 7 + len[0], len[1]);
        this.selectMF();
        this.selectFileUnderMF(fid);
        this.sendCommand(changepin);
    }

    @Override
    public void unlockDFPIN(byte[] fid, byte[] PUK, byte[] newPIN) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] resetRetry = new byte[7 + newPIN.length + PUK.length];
        byte[] resetRetry_part1 = new byte[]{0, 44, 0, -127};
        resetRetry[4] = (byte)(newPIN.length + PUK.length + 2);
        System.arraycopy(resetRetry_part1, 0, resetRetry, 0, 4);
        byte[] len = new byte[2];
        len[0] = (byte)PUK.length;
        System.arraycopy(len, 0, resetRetry, 5, 1);
        System.arraycopy(PUK, 0, resetRetry, 6, len[0]);
        len[1] = (byte)newPIN.length;
        System.arraycopy(len, 1, resetRetry, 6 + len[0], 1);
        System.arraycopy(newPIN, 0, resetRetry, 7 + len[0], len[1]);
        this.selectMF();
        this.selectFileUnderMF(fid);
        this.sendCommand(resetRetry);
    }

    private void changeMFPINPUK(boolean isPUK, byte[] mfPin, byte[] oldPIN, byte[] newPIN) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] changepin = new byte[7 + oldPIN.length + newPIN.length];
        byte[] changepin1 = new byte[]{0, 36, 0, 1};
        if (isPUK) {
            changepin1[3] = 2;
        }
        byte[] lc = new byte[]{(byte)(newPIN.length + oldPIN.length + 2)};
        System.arraycopy(changepin1, 0, changepin, 0, 4);
        System.arraycopy(lc, 0, changepin, 4, 1);
        byte[] len = new byte[2];
        len[0] = (byte)oldPIN.length;
        System.arraycopy(len, 0, changepin, 5, 1);
        System.arraycopy(oldPIN, 0, changepin, 6, len[0]);
        len[1] = (byte)newPIN.length;
        System.arraycopy(len, 1, changepin, 6 + len[0], 1);
        System.arraycopy(newPIN, 0, changepin, 7 + len[0], len[1]);
        this.selectMF();
        this.changePhaseToAdmin(mfPin);
        this.sendCommand(changepin);
    }

    @Override
    public void unlockMFPIN(byte[] PUK, byte[] newPIN) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] resetRetry = new byte[7 + newPIN.length + PUK.length];
        byte[] resetRetry_part1 = new byte[]{0, 44, 0, 1};
        resetRetry[4] = (byte)(newPIN.length + PUK.length + 2);
        System.arraycopy(resetRetry_part1, 0, resetRetry, 0, 4);
        byte[] len = new byte[2];
        len[0] = (byte)PUK.length;
        System.arraycopy(len, 0, resetRetry, 5, 1);
        System.arraycopy(PUK, 0, resetRetry, 6, len[0]);
        len[1] = (byte)newPIN.length;
        System.arraycopy(len, 1, resetRetry, 6 + len[0], 1);
        System.arraycopy(newPIN, 0, resetRetry, 7 + len[0], len[1]);
        this.selectMF();
        this.sendCommand(resetRetry);
    }

    @Override
    public void changeDFPIN(byte[] fid, byte[] oldPIN, byte[] newPIN) throws AkisSWException, AkisCardException, AkisCIFException {
        this.changeDFPINPUK(fid, false, oldPIN, newPIN);
    }

    @Override
    public void changeDFPUK(byte[] fid, byte[] oldPIN, byte[] newPIN) throws AkisSWException, AkisCardException, AkisCIFException {
        this.changeDFPINPUK(fid, true, oldPIN, newPIN);
    }

    @Override
    public void changeMFPIN(byte[] oldPIN, byte[] newPIN) throws AkisSWException, AkisCardException, AkisCIFException {
        this.changeMFPINPUK(false, oldPIN, oldPIN, newPIN);
    }

    @Override
    public void changeMFPUK(byte[] mfPIN, byte[] oldPUK, byte[] newPUK) throws AkisSWException, AkisCardException, AkisCIFException {
        this.changeMFPINPUK(true, mfPIN, oldPUK, newPUK);
    }

    @Override
    public void mse(byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] mse = new byte[]{0, 34, -61, keyID};
        this.sendCommand(mse);
    }

    @Override
    public byte[] pso(P1P2 psoMode, byte[] data) throws AkisSWException, AkisCardException, AkisCIFException {
        byte[] pso1 = new byte[]{0, 42, psoMode.getp1(), psoMode.getp2()};
        byte[] pso = new byte[pso1.length + data.length + 2];
        System.arraycopy(pso1, 0, pso, 0, pso1.length);
        pso[pso1.length] = (byte)data.length;
        System.arraycopy(data, 0, pso, pso1.length + 1, data.length);
        pso[pso.length - 1] = 0;
        return this.sendCommand(pso).getData();
    }

    @Override
    public byte[] sign(byte[] data, byte keyID) throws AkisSWException, AkisCardException, AkisCIFException {
        this.mse(keyID);
        return this.pso(this.pso_param.cds, data);
    }

    @Override
    public void decideSecureMessageKeyGeneratingKey() throws AkisCIFException {
        byte[] bytesOfPublicKey = null;
        if (this.version == Version.V11_UEKAE_INF || this.version == Version.V12_UEKAE_INF || this.version == Version.V12_UEKAE_NXP) {
            bytesOfPublicKey = PublicKeys.RSAPubKey1024_Akis12;
        } else if (this.version == Version.V121_UEKAE_INF || this.version == Version.V121_UEKAE_NXP) {
            bytesOfPublicKey = PublicKeys.RSAPubKey1024_Akis121;
        } else if (this.version == Version.V122_UEKAE_INF || this.version == Version.V122_UEKAE_NXP) {
            bytesOfPublicKey = PublicKeys.RSAPubKey1024_Akis122;
        } else if (this.version == Version.V13_UEKAE_INF) {
            bytesOfPublicKey = PublicKeys.RSAPubKey1024_Akis13;
        } else {
            throw new UnsupportedVersionException();
        }
        try {
            X509EncodedKeySpec keyspec = new X509EncodedKeySpec(bytesOfPublicKey);
            KeyFactory keyFact = KeyFactory.getInstance("RSA");
            this.currentSecureMessagingGeneratingKey = keyFact.generatePublic(keyspec);
        }
        catch (Exception ex) {
            throw new AkisCIFException("X509 Encoding Failed: " + ex);
        }
    }

    @Override
    public void generateSecureMessagingKey() throws AkisCIFException, AkisSWException, AkisCardException {
        int i;
        Random rnd = new Random();
        byte[] rand16bytes = new byte[16];
        rnd.nextBytes(rand16bytes);
        Cipher rsacipher = null;
        byte[] cipherText = new byte[128];
        try {
            rsacipher = Cipher.getInstance("RSA");
            rsacipher.init(1, this.currentSecureMessagingGeneratingKey);
            cipherText = rsacipher.doFinal(rand16bytes);
        }
        catch (Exception ex) {
            throw new AkisCIFException("Encryption Failed: " + ex);
        }
        byte[] alinanRandom = new byte[16];
        alinanRandom = this.exchangeChallenge(cipherText);
        if (alinanRandom == null) {
            throw new AkisCIFException("Exchange Challenge returns NULL");
        }
        for (i = 0; i < 16; ++i) {
            this.secureMessagingKey_ABA[i] = (byte)(rand16bytes[i] ^ alinanRandom[i]);
        }
        for (i = 0; i < 8; ++i) {
            this.secureMessagingKey_ABA[i + 16] = (byte)(rand16bytes[i] ^ alinanRandom[i]);
        }
    }

    @Override
    public void generateSecureMessagingKey(String documentNumber, String dateOfBirth, String expireDate) {
        throw new UnsupportedVersionException();
    }

    @Override
    protected byte[] createEncryptedCommand(byte[] command) throws AkisCIFException {
        int i;
        int mode = 0;
        int index = 0;
        int secDataLen = 0;
        int dataLen = 0;
        int Le = -1;
        if (command.length >= 5) {
            if (command.length == 5) {
                Le = command[command.length - 1];
            } else if (command.length > 5 && command[4] < command.length - 5) {
                Le = command[command.length - 1];
            }
        }
        if (command.length <= 5 && Le < 0) {
            mode = 0;
        } else if (command.length <= 5 && Le >= 0) {
            mode = 1;
        } else if (command.length > 5 && Le < 0) {
            mode = 2;
        } else if (command.length > 5 && Le >= 0) {
            mode = 3;
        }
        byte[] createdCommand = new byte[256];
        System.arraycopy(command, 0, createdCommand, 0, command.length);
        createdCommand[0] = (byte)(createdCommand[0] | 4);
        int createdCommandLen = 0;
        if (mode == 0) {
            index = 5;
            createdCommandLen = command.length;
        } else if (mode == 1) {
            index = 4;
            createdCommand[index++] = 8;
            createdCommand[index++] = -106;
            createdCommand[index++] = 1;
            createdCommand[index++] = (byte)Le;
            secDataLen = 8;
            createdCommand[secDataLen + 5] = 0;
            createdCommandLen = secDataLen + 6;
        } else if (mode == 2) {
            dataLen = command.length - 5;
            secDataLen = (dataLen + 2) % 8 > 0 ? dataLen + 2 + (8 - (dataLen + 2) % 8) : dataLen + 2;
            index = 4;
            createdCommand[index++] = (byte)secDataLen;
            createdCommand[index++] = -122;
            createdCommand[index++] = (byte)dataLen;
            for (i = 0; i < dataLen; ++i) {
                createdCommand[index + i] = command[i + 5];
            }
            index += dataLen;
            createdCommandLen = secDataLen + 5;
        } else if (mode == 3) {
            dataLen = command.length - 6;
            secDataLen = (dataLen + 5) % 8 > 0 ? dataLen + 5 + (8 - (dataLen + 5) % 8) : dataLen + 5;
            index = 4;
            createdCommand[index++] = (byte)secDataLen;
            createdCommand[index++] = -122;
            createdCommand[index++] = (byte)dataLen;
            for (i = 0; i < dataLen; ++i) {
                createdCommand[index + i] = command[i + 5];
            }
            index += dataLen;
            createdCommand[index++] = -106;
            createdCommand[index++] = 1;
            createdCommand[index++] = (byte)Le;
            createdCommand[index++] = 0;
            createdCommandLen = secDataLen + 6;
        }
        if (secDataLen > 0) {
            for (int j = index; j < secDataLen + 5; ++j) {
                createdCommand[j] = 0;
            }
            byte[] plainData = new byte[secDataLen];
            System.arraycopy(createdCommand, 5, plainData, 0, secDataLen);
            byte[] cipherData = Crypto.triDes(this.secureMessagingKey_ABA, plainData, true);
            if (cipherData == null) {
                return null;
            }
            System.arraycopy(cipherData, 0, createdCommand, 5, cipherData.length);
        }
        byte[] newCommand = new byte[createdCommandLen];
        System.arraycopy(createdCommand, 0, newCommand, 0, createdCommandLen);
        return newCommand;
    }

    @Override
    protected byte[] createDecryptedCommand(byte[] response) throws AkisCIFException {
        if (response.length < 3) {
            return response;
        }
        if (response.length % 8 <= 2) {
            byte[] cipher;
            byte[] plain = new byte[256];
            byte[] elected_plain = null;
            if (response.length % 8 < 2) {
                cipher = new byte[response.length - response.length % 8];
                System.arraycopy(response, 0, cipher, 0, cipher.length);
                plain = Crypto.triDes(this.secureMessagingKey_ABA, cipher, false);
            } else {
                cipher = new byte[response.length - 2];
                System.arraycopy(response, 0, cipher, 0, cipher.length);
                plain = Crypto.triDes(this.secureMessagingKey_ABA, cipher, false);
            }
            if (plain == null || plain.length == 0) {
                return null;
            }
            int i = 0;
            if (plain[0] == -122) {
                int len = plain[1] & 0xFF;
                elected_plain = new byte[len + 2];
                for (i = 0; i < elected_plain.length - 2; ++i) {
                    elected_plain[i] = plain[i + 2];
                }
                if (plain[i + 2] == -103) {
                    elected_plain[i] = plain[i + 4];
                    elected_plain[i + 1] = plain[i + 5];
                }
            } else if (plain[0] == -103) {
                elected_plain = new byte[2];
                for (i = 0; i < elected_plain.length; ++i) {
                    elected_plain[i] = plain[i + 2];
                }
            } else {
                elected_plain = new byte[plain.length];
                elected_plain = plain;
            }
            return elected_plain;
        }
        byte[] error = new byte[]{response[response.length - 2], response[response.length - 1]};
        return error;
    }
}

