/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.certstore.ops;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1Exception;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStore;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreException;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.CertStoreUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVEN;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.DepoVTKatmani;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.JDBCUtil;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.GuvenlikSeviyesi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzetTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.OzneTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.db.cekirdek.yardimci.SertifikaTipi;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoKokSertifika;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoOzet;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.model.DepoSilinecekKokSertifika;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.CertificateSearchTemplate;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.template.KeyUsageSearchTemplate;
import tr.gov.tubitak.uekae.esya.api.infra.certstore.util.RsItemSource;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNEklenecekKokSertifika;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNImza;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNImzalar;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNKokSertifika;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNKokSertifikalar;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNRawImza;
import tr.gov.tubitak.uekae.esya.asn.depo.DepoASNSilinecekKokSertifika;
import tr.gov.tubitak.uekae.esya.asn.x509.Certificate;

public class CertStoreRootCertificateOps {
    private static Logger a;
    private final CertStore b;
    public static boolean c;
    private static final String[] d;
    private static final String[] e;

    public CertStoreRootCertificateOps(CertStore aDepo) {
        try {
            LV.getInstance().checkLD(LV.Urunler.ORTAK);
        }
        catch (LE lE) {
            a.error(CertStoreRootCertificateOps.a(3961, -5146));
            throw new ESYARuntimeException(CertStoreRootCertificateOps.a(3916, -23569) + lE.getMessage());
        }
        this.b = aDepo;
    }

    public void deleteRootCertificate(long aKokNo) throws CertStoreException {
        if (aKokNo <= 0L) {
            throw new CertStoreException(CertStoreRootCertificateOps.a(3960, 24936));
        }
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            depoVEN.kokSertifikaSil(aKokNo);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(aKokNo + CertStoreRootCertificateOps.a(3944, -11923), certStoreException);
        }
    }

    public byte[] createRootCertificatesTobeSigned(List<Certificate> aEklenecekList, List<SertifikaTipi> aTipler, List<GuvenlikSeviyesi> aSeviyeler, List<Certificate> aSilinecekList) throws CertStoreException, Asn1Exception {
        byte[] byArray;
        block13: {
            boolean bl;
            block15: {
                block14: {
                    DepoASNKokSertifika depoASNKokSertifika;
                    int n;
                    int n2;
                    boolean bl2;
                    int n3;
                    block12: {
                        n3 = 0;
                        int n4 = 0;
                        bl2 = c;
                        int n5 = 0;
                        n2 = 0;
                        if (aEklenecekList != null) {
                            n3 = aEklenecekList.size();
                            n4 = aTipler.size();
                            n5 = aSeviyeler.size();
                        }
                        if (aSilinecekList != null) {
                            n2 = aSilinecekList.size();
                        }
                        if (n3 == n4 && n4 == n5) break block12;
                        throw new CertStoreException(CertStoreRootCertificateOps.a(3915, -29433));
                    }
                    DepoASNKokSertifikalar depoASNKokSertifikalar = new DepoASNKokSertifikalar();
                    depoASNKokSertifikalar.elements = new DepoASNKokSertifika[n3 + n2];
                    for (n = 0; n < n3; ++n) {
                        DepoASNKokSertifika depoASNKokSertifika2 = new DepoASNKokSertifika();
                        depoASNKokSertifika = CertStoreUtil.asnCertTOAsnEklenecek(aEklenecekList.get(n), aTipler.get(n), aSeviyeler.get(n));
                        depoASNKokSertifika2.set_eklenecekSertifika((DepoASNEklenecekKokSertifika)depoASNKokSertifika);
                        depoASNKokSertifikalar.elements[n] = depoASNKokSertifika2;
                        if (!bl2) continue;
                    }
                    for (int i = 0; i < n2; ++i) {
                        depoASNKokSertifika = new DepoASNKokSertifika();
                        DepoASNSilinecekKokSertifika depoASNSilinecekKokSertifika = CertStoreUtil.asnCertTOAsnSilinecek(aSilinecekList.get(i));
                        depoASNKokSertifika.set_silinecekSertifika(depoASNSilinecekKokSertifika);
                        depoASNKokSertifikalar.elements[n] = depoASNKokSertifika;
                        ++n;
                        if (!bl2) continue;
                    }
                    Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
                    depoASNKokSertifikalar.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
                    byArray = asn1DerEncodeBuffer.getMsgCopy();
                    if (CertStoreException.b == 0) break block13;
                    if (!bl2) break block14;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
            c = bl;
        }
        return byArray;
    }

    public void addPersonalRootCertificate(Certificate aCert, SertifikaTipi aTip) throws CertStoreException {
        DepoKokSertifika depoKokSertifika = CertStoreUtil.asnCertTODepoEklenecek(aCert);
        depoKokSertifika.setKokTipi(aTip);
        depoKokSertifika.setKokGuvenSeviyesi(GuvenlikSeviyesi.PERSONAL);
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            List<DepoOzet> list = CertStoreUtil.convertToDepoOzet(depoKokSertifika.getValue(), OzneTipi.KOK_SERTIFIKA);
            depoVEN.kokSertifikaYaz(depoKokSertifika, list);
            JDBCUtil.commit(this.b.getConn());
        }
        catch (CertStoreException certStoreException) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            throw new CertStoreException(CertStoreRootCertificateOps.a(3938, 31720), certStoreException);
        }
    }

    public boolean verifySignature(DepoKokSertifika aKok) throws CertStoreException {
        boolean bl = CertStoreUtil.verifyDepoKokSertifika(aKok);
        if (!bl) {
            this.deleteRootCertificate(aKok.getKokSertifikaNo());
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoKokSertifika> listStoreRootCertificates() throws CertStoreException {
        boolean bl = c;
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            List list = ((RsItemSource)depoVEN.kokSertifikaListele()).toList();
            ArrayList<DepoKokSertifika> arrayList = new ArrayList<DepoKokSertifika>();
            for (DepoKokSertifika depoKokSertifika : list) {
                block9: {
                    try {
                        boolean bl2 = CertStoreUtil.verifyDepoKokSertifika(depoKokSertifika);
                        if (bl2) {
                            arrayList.add(depoKokSertifika);
                            if (!bl) break block9;
                        }
                        depoVEN.kokSertifikaSil(depoKokSertifika.getKokSertifikaNo());
                    }
                    catch (Exception exception) {
                        a.error(CertStoreRootCertificateOps.a(3956, -32023), (Throwable)exception);
                    }
                }
                if (!bl) continue;
            }
            JDBCUtil.commit(this.b.getConn());
            return arrayList;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(CertStoreRootCertificateOps.a(3948, 7643), certStoreException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<DepoKokSertifika> listStoreRootCertificates(CertificateSearchTemplate aSAS, SertifikaTipi[] aTipler, GuvenlikSeviyesi[] aSeviyeler) throws CertStoreException {
        boolean bl = c;
        try {
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            Pair<String, List<Object>> pair = this.a(aSAS, aTipler, aSeviyeler);
            String string = (String)pair.first();
            List list = (List)pair.second();
            List list2 = ((RsItemSource)depoVEN.kokSertifikaListele(string, list.toArray())).toList();
            ArrayList<DepoKokSertifika> arrayList = new ArrayList<DepoKokSertifika>();
            for (DepoKokSertifika depoKokSertifika : list2) {
                block9: {
                    try {
                        boolean bl2 = CertStoreUtil.verifyDepoKokSertifika(depoKokSertifika);
                        if (bl2) {
                            arrayList.add(depoKokSertifika);
                            if (!bl) break block9;
                        }
                        depoVEN.kokSertifikaSil(depoKokSertifika.getKokSertifikaNo());
                    }
                    catch (Exception exception) {
                        a.error(CertStoreRootCertificateOps.a(3967, 11590), (Throwable)exception);
                    }
                }
                if (!bl) continue;
            }
            JDBCUtil.commit(this.b.getConn());
            return arrayList;
        }
        catch (CertStoreException certStoreException) {
            throw new CertStoreException(CertStoreRootCertificateOps.a(3939, -6093), certStoreException);
        }
    }

    public void addSignedRootCertificates(byte[] aImzaliKokSertifikalar) throws CertStoreException {
        boolean bl = c;
        try {
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(aImzaliKokSertifikalar);
            DepoASNImzalar depoASNImzalar = new DepoASNImzalar();
            depoASNImzalar.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
            DepoASNImza[] depoASNImzaArray = depoASNImzalar.elements;
            DepoVEN depoVEN = DepoVTKatmani.yeniDepoVEN(this.b.getConn());
            for (DepoASNImza depoASNImza : depoASNImzaArray) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                int n;
                DepoASNKokSertifika depoASNKokSertifika;
                block23: {
                    byte[] byArray = null;
                    depoASNKokSertifika = depoASNImza.imzalanan;
                    n = depoASNKokSertifika.getChoiceID();
                    DepoASNRawImza depoASNRawImza = depoASNImza.imza;
                    object6 = new Asn1DerEncodeBuffer();
                    depoASNRawImza.encode((Asn1BerEncodeBuffer)object6);
                    object5 = object6.getMsgCopy();
                    object4 = new Asn1DerEncodeBuffer();
                    depoASNKokSertifika.encode((Asn1BerEncodeBuffer)object4);
                    byArray = object4.getMsgCopy();
                    boolean bl2 = false;
                    try {
                        bl2 = CertStoreUtil.verifyEncodedRootCertificate(byArray, depoASNRawImza);
                    }
                    catch (Exception exception) {
                        a.error(CertStoreRootCertificateOps.a(3917, -17000), (Throwable)exception);
                        if (!bl) continue;
                    }
                    if (bl2) break block23;
                    try {
                        object3 = null;
                        if (n == 1) {
                            object2 = (DepoASNEklenecekKokSertifika)depoASNKokSertifika.getElement();
                            object3 = ((DepoASNEklenecekKokSertifika)object2).kokSertifikaValue.value;
                        } else if (n == 2) {
                            object2 = (DepoASNSilinecekKokSertifika)depoASNKokSertifika.getElement();
                            object3 = ((DepoASNSilinecekKokSertifika)object2).kokSertifikaValue.value;
                        }
                        object2 = new ECertificate((byte[])object3);
                        object = object2.getSerialNumberHex();
                        String string = object2.getSubject().stringValue();
                        a.error(CertStoreRootCertificateOps.a(3913, -21523) + (String)object + CertStoreRootCertificateOps.a(3963, -17875) + string + CertStoreRootCertificateOps.a(3947, -18218));
                        continue;
                    }
                    catch (Exception exception) {
                        a.error(CertStoreRootCertificateOps.a(3954, -19828), (Throwable)exception);
                        if (!bl) continue;
                    }
                }
                try {
                    if (n == 1) {
                        object3 = (DepoASNEklenecekKokSertifika)depoASNKokSertifika.getElement();
                        object2 = CertStoreUtil.asnEklenecekTODepoKok(object3);
                        ((DepoKokSertifika)object2).setSatirImzasi((byte[])object5);
                        object = CertStoreUtil.convertToDepoOzet(((DepoKokSertifika)object2).getValue(), OzneTipi.KOK_SERTIFIKA);
                        depoVEN.kokSertifikaYaz((DepoKokSertifika)object2, (List<DepoOzet>)object);
                    }
                    if (n != 2) continue;
                    object3 = (DepoASNSilinecekKokSertifika)depoASNKokSertifika.getElement();
                    object2 = CertStoreUtil.asnSilinecekToDepoSilinecek((DepoASNSilinecekKokSertifika)object3);
                    ((DepoSilinecekKokSertifika)object2).setSatirImzasi((byte[])object5);
                    depoVEN.silinecekKokSertifikaYaz((DepoSilinecekKokSertifika)object2);
                    continue;
                }
                catch (Exception exception) {
                    try {
                        object6 = null;
                        if (n == 1) {
                            object5 = (DepoASNEklenecekKokSertifika)depoASNKokSertifika.getElement();
                            object6 = object5.kokSertifikaValue.value;
                        } else if (n == 2) {
                            object5 = (DepoASNSilinecekKokSertifika)depoASNKokSertifika.getElement();
                            object6 = object5.kokSertifikaValue.value;
                        }
                        object5 = new ECertificate((byte[])object6);
                        object4 = object5.getSerialNumberHex();
                        String string = object5.getSubject().stringValue();
                        a.error(CertStoreRootCertificateOps.a(3957, 24838) + (String)object4 + CertStoreRootCertificateOps.a(3965, -23082) + string + CertStoreRootCertificateOps.a(3951, -10820), (Throwable)exception);
                        continue;
                    }
                    catch (Exception exception2) {
                        a.error(CertStoreRootCertificateOps.a(3941, -794), (Throwable)exception2);
                    }
                }
                if (!bl) continue;
            }
            JDBCUtil.commit(this.b.getConn());
        }
        catch (Exception exception) {
            if (this.b.getConn() != null) {
                JDBCUtil.rollback(this.b.getConn());
            }
            a.error(CertStoreRootCertificateOps.a(3914, -3475), (Throwable)exception);
            throw new CertStoreException(CertStoreRootCertificateOps.a(3943, 14406), exception);
        }
    }

    private Pair<String, List<Object>> a(CertificateSearchTemplate certificateSearchTemplate, SertifikaTipi[] sertifikaTipiArray, GuvenlikSeviyesi[] guvenlikSeviyesiArray) {
        ArrayList<Object> arrayList;
        StringBuffer stringBuffer;
        block39: {
            boolean bl;
            block38: {
                stringBuffer = new StringBuffer("");
                bl = c;
                arrayList = new ArrayList<Object>();
                stringBuffer.append(CertStoreRootCertificateOps.a(3942, 23812));
                if (certificateSearchTemplate != null) {
                    block37: {
                        OzetTipi ozetTipi;
                        block35: {
                            block36: {
                                byte[] byArray = certificateSearchTemplate.getValue();
                                if (byArray != null) {
                                    stringBuffer.append(CertStoreRootCertificateOps.a(3936, 29741));
                                    arrayList.add(byArray);
                                }
                                byte[] byArray2 = certificateSearchTemplate.getHash();
                                ozetTipi = certificateSearchTemplate.getHashType();
                                if (byArray2 == null) break block35;
                                stringBuffer.append(CertStoreRootCertificateOps.a(3966, 4363));
                                arrayList.add(OzneTipi.KOK_SERTIFIKA.getIntValue());
                                arrayList.add(byArray2);
                                if (ozetTipi == null) break block36;
                                stringBuffer.append(CertStoreRootCertificateOps.a(3958, -4319));
                                arrayList.add(ozetTipi.getIntValue());
                                if (!bl) break block37;
                            }
                            stringBuffer.append(CertStoreRootCertificateOps.a(3955, -20208));
                            if (!bl) break block37;
                        }
                        if (ozetTipi == null) break block37;
                        stringBuffer.append(CertStoreRootCertificateOps.a(3952, 12802));
                        arrayList.add(OzneTipi.KOK_SERTIFIKA.getIntValue());
                        arrayList.add(ozetTipi.getIntValue());
                    }
                    byte[] byArray = certificateSearchTemplate.getIssuer();
                    if (byArray != null) {
                        stringBuffer.append(CertStoreRootCertificateOps.a(3949, -178));
                        arrayList.add(byArray);
                    }
                    byte[] byArray3 = certificateSearchTemplate.getSubject();
                    if (byArray3 != null) {
                        stringBuffer.append(CertStoreRootCertificateOps.a(3940, -938));
                        arrayList.add(byArray3);
                    }
                    byte[] byArray4 = certificateSearchTemplate.getSerialNumber();
                    if (byArray4 != null) {
                        stringBuffer.append(CertStoreRootCertificateOps.a(3918, -9041));
                        arrayList.add(byArray4);
                    }
                    byte[] byArray5 = certificateSearchTemplate.getSubjectKeyID();
                    if (byArray5 != null) {
                        stringBuffer.append(CertStoreRootCertificateOps.a(3953, 6870));
                        arrayList.add(byArray5);
                    }
                    KeyUsageSearchTemplate keyUsageSearchTemplate = certificateSearchTemplate.getAnahtarKullanim();
                    if (keyUsageSearchTemplate != null) {
                        stringBuffer.append(CertStoreRootCertificateOps.a(3962, -22950));
                        arrayList.add(keyUsageSearchTemplate.sorguOlustur());
                    }
                }
                if (sertifikaTipiArray == null || sertifikaTipiArray.length == 0) break block38;
                stringBuffer.append(CertStoreRootCertificateOps.a(3912, 22462));
                stringBuffer.append(CertStoreRootCertificateOps.a(3946, -21368));
                for (int i = 0; i < sertifikaTipiArray.length - 1; ++i) {
                    stringBuffer.append(sertifikaTipiArray[i].getIntValue() + CertStoreRootCertificateOps.a(3937, -3510));
                    if (!bl) continue;
                }
                stringBuffer.append(sertifikaTipiArray[sertifikaTipiArray.length - 1].getIntValue() + CertStoreRootCertificateOps.a(3964, 21243));
            }
            if (guvenlikSeviyesiArray == null || guvenlikSeviyesiArray.length == 0) break block39;
            stringBuffer.append(CertStoreRootCertificateOps.a(3950, -2340));
            stringBuffer.append(CertStoreRootCertificateOps.a(3959, -26656));
            for (int i = 0; i < guvenlikSeviyesiArray.length - 1; ++i) {
                stringBuffer.append(guvenlikSeviyesiArray[i].getIntValue() + CertStoreRootCertificateOps.a(3945, 19696));
                if (!bl) continue;
            }
            stringBuffer.append(guvenlikSeviyesiArray[guvenlikSeviyesiArray.length - 1].getIntValue() + CertStoreRootCertificateOps.a(3919, 2349));
        }
        return new Pair((Object)stringBuffer.toString(), arrayList);
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[40];
                var3_1 = 0;
                var2_2 = "zg&\u009b(\t\u009e\u00e1\u0081\u0011s\u00ac\r\u0097\u009a\u0011\r\u00ad`\u00c4\u0085'\u0010\u0098S\u00eep\u00a7l\u00dc \bG\u0085\u0092\u00fbe\u00c4\u00edu\u00ab\u00ca\u00cf\u00e1\u00f6\u0019z\u00a15\u009d\u00c3\u0083(H!\u0014\u00cc;\u00f3C:P\u0000\u0017K\u00af5\u00050~\u00a5>U\u0003&\u0013\u00cd\u0081x\u0097\u0082\u00fd;[\u0084\u00e4?\u00e6\u00f9\u00a3\u00c2S\u00ad\u0098\u00a2\u00b476\u0004O&\u007f\u00fe\u0081\u0099l\u009cg\u00ec_1|\u00cc\u009d>\u0097\u009b!\u0096Ve\u001f/\u00aaOe\u0082?rP\\m\u00e7\u00c3\u00e0\u00df\u00ff\u00eeVh\u00ce\u00cb\u0003\u0012OF\u0005\u00a3\u0095\u001e\u001d\u00cf$\u00a4\u00a3\u00c5\u0089\u00a2K6Ak\u00bb.\u00f3\u00bf5\u00c0\u001dYN=\u00ad\u001d\r\u00ac\u00841\u0013X\u00e1\u00fd}\u0013\u00e3e\u00e9*n3\u0003\u00dd\u00d3\u00c2z\"\u0004 -k\u009a\u0093\u00fey\u008b\u00c4\u001b6[\u009a\u001d\u008b\u00ffA\u0005\u0015=\u000b\u0092~}\u0014lZ^\u00ae\u00b9c\u00f0\u00d6\u0003u\u00d1]\u0011a~\u008fF\f\u00d2\u0017\u0088\u0005{\u000fcW!\u0016\u0005\u00931\u00b1o\u00b9\u00ff\u00a4\u0015>\u00e9\u0002\u001fp)J\u0011\u009bk \u00a5~/\u000f\u00b7\u00cc\u00b5\u0017\u00a1\u00f0\u00e4\u00fc\u00b8D\u0091*;\u0089\u00c1\u00d8O\u00c0d\u0088\\\u00ce\u00a7\u00d2{Vb\u0017up\u0083\u00cd\u0095\u001d\u00ado\u0091}\u00bc\u0011\u00dcB%\u00f4\u0091b+\u0012|)*4N\u00ab\u00cc\u00a1\u00ae\u0094K\u001c\u0010\u0081\u0018\u00de\u00c9\u009f9D\u0084\u00d33\u0090\u00d8\u00d7\r\u001e\u00ea\u00b8\u0011:\u00a6\u0099w\u00c2\u000f\u009cm\u00e0\u00a4\u00ffUX'\u001b\u008fd\u000f\u00f4\u00f5\u0099\u0000\u00b5DW\u00d1\u0000x\u00c4Y\u00b1Ss\u00f9\u00e9\u0087?X\u0002C5Q8dF\u001b\u00a6E\u00be\u0007\u00dbV66\u00fd\u0081v&\u00aa~\u00ed\u00c0\u0098\u00ca\u0094\u0098\u008c\u0002\u00a4\u00b4\u0012\u0098w\u0003\u00d9@?\u0003\u00a0>2a\u00a6\u00ad\u00ce\u0096+\u00c7\u0082B\u00d5%\u009az#\u0006L[\u0015\u00c4\u00c8\u008cU(\u00f7h6\u00e7=zz\u00a4\u00d7:\u0011R\u00c9\u00fatsC\u00fc>1v\u00b8\u00e3\u0006\u00f8\u00a8Qi/hv\u008a%Uy\u0093\u00bd_t\u000e*\u00de\u0089\u00ff\u00a1q\u008ae1\u0012\u009aw\u00af\u00f7\u00ab\u00e7\u001eY\u00d2 w\u0001:\u0017\u00e7|r\u00f6L\u00c4bX\u00e2\u00c4\u000e\u0017\u00a1'^K\u00c7\u00df\u00b5\u0007\u008d\u00b7h\u00ecw\u00ff\u00c6pCf\u00eb\u001d\u00af2\u009eS\u00ae\u0099\u00cf\u0010\u000b\u0017\u0086WUq\u00d3\u00f9y59L\u0001$\u00c0\u00d8\u009c\u00fb\u001c\u0010\u00bc\u00fc:\u0094\u0013y\b\u00819(\\\u0016(\u0003\u00ca\u0097E\u00c8\u001c\u0098&\u00f2\u00e0\u00c3\u00f4A\u00f4\u0088\u00da\u00ad\u00e4\u00d8\u00b4\u0080\n\u00bf+\u00e3e\u00c6/\u009aDp^\t\u00cdO\u00a5NW\u00dcC+hA6\u00a8\u00d3\u001ad\u008c\u00e6>\u00d0qW\u00d2\u00c9\u001d\u00e0\u0094\b*\u00ee\u00a3\u0005K@\u0082^\u00a8\u008b0\u00f1\u007f\u000b\u0092a\u0013\u00c1i\u0015!|%x\u00e7*XG\u00ff\u00cd,\u000b#\u0094\u00ea2\u009e~B\u00f5\u00a9tgI\u00c1u\u00dfjb\u00e3\u00f3,&\u00eb\u00be3|\u0089XKj\u000b\u00d1\u00dez\u00fcZ#\u001a\u0001\u0012\u0096\u00e5\n\u00b3\u00e4\u0095\u0019\u00daW!NR\u00abE\u00ccoo\u00f0\u00a4\u00af\u0015\u00d8G\u00da[&\u0004\u00ae/\u00d9Sv\u0096\u00f5\u0095w\u00a4\u008a.\u00e9\u00ca\u0018\u0093\u008a\u00e4\u00bcc\u0019\u00c3\u00d6\u00bb\u009e\u00f9\u00c0H\u0013\u001a\u008f\u00be\u009c\u0006\u00e0\u0081\u000b<\u0094\u00d7\u00c6a^\u0002\u0005c\u00a7\u00e0,p\u00ff\u00b6f\u00c8\u009c\u00d3\u00f1\u00beY\u00adI\u009d\u00bc0\u00bb\u009e\u0018\u0001\u0092KVr\u000bR\u00e0[\u0097YU\u00cb\u009f\u00af^\u00bf0\u0081\u00a9\u00a4\u0017\u001e8XN+\u0017\u0015\u00ab\u008a\u00ee\u00cdr\u00d3Zz\u00f7\u00caq+{\u0004\u00f3\u0099\u009c\u0097=\u0091\u00b3Q\u00f2\u00c8\u0002\u008b\u00c6\u000b\u0010\u00adCXc&`\u001a\r\u00b4\u00e2V/\u00e8\u00ff>\r\u00d2F\u00efMf\u00d0\u001b\u0019i5\u00c7\u0080U\u00f0\u00f6\u009a>\u00dc\u00a8\u00a4\u00eb9vs%\u0004\n\u00b8Yl8.\u00c6\n/]\u00df\u001e~L\u00bd\u00dc\u00d6\u0007\u00c0\u0002\u00d6\u00ee\u00d5\u00c8Z\u009b\u000b8^\u00f9f4\u0098m5\u0000@s\rs\u0088O\u0000\u00e2-_x\u0001\u0080\u0087u\u00e51\u0002\u00cc\u0003\u00d4A\u0097\\\u00ba\u0096=}\u00ab\u00198\u00df<\u00bcN\u0081\u00ad\u008a\r^\u0084\u0001\u0019\u00b6\u00ce)W\u008a\u001f\u0092\u00a7\u00dc\u00e7\u00ec\u00f7\u008e\u0013,\u000fT\u0092\u00cbEu]\u00fe\u00ffDy\u00a6\u00e1\u00f7;r\u00bf\"\u008d\u00fc(\u0081U\u00fa\u00c8\u009b~\t\u00ad\t \u00a2(\u00ccjK\u00dc\u0002\u009f[2w\u00c7\u00ffs\u00cd\u00c9[\u0014\u00e3$\u00ecp\u001b\u0000V\u00d7R \u0010\bh\u00ae\u0001cm\u0090\u0096E\u000b\u00b2\u001b4K\f\u00f6X\u00f5\b\u009d\u0012\u00c0\u0088\u0006\u0097>\u00e2\u00bb\u0093sU\u0014\u0007\u00ad\u008a\u001a]\u00f6\u00c8y\u00f2f\u00c0\u00c9\u001aA\"\u00e2\u00e1\u00dafg\u0015\u0003a\tO\u00dd\u0001#c0\u00aa\u00cb^\u0089\u00cc\u0081\u00f7\rq`_\u0085\u001e-\u009d\u00ec\u0093C\u0002!h\u00bf\u0091XX\u001f\u000b_\u00e4d\u00ee\u00d9\u00bc\u00a7\u008e\u0016ul\u00cd\u0099\u00da\u00b7\u00b9\u0010\u001e\u00a2\u00d9w\u00c9\u00fb\u00de\u00ea^\u00e2\u00b2\u008bU{\u00b9\u00cca\ri\u00bb\u000e\u0085\u00d4W oi\u00cd\u00f3\u00c97\u0011}\u00be\u0000\u00bd\u0014\u00fb;\"\n\u008c\u00abj\u00f3\u0090\u0095\u008a\u001c\u00ba\u0096\u00bcb\u00da`\u0096\u009e\u0084}!1\t7\u00a5\u008e\u00fa\u00adZ\u00f0\u00d8\u0099\u00f07\u00c3\u00df\u00ea\u00d6\u009e?w\u00f8\";\u00d4\u00e9$v\u00e4p ;\u00f8~A\u00d6C\u007fy\u00e4\u0002\u0099\u0094\u00042\u001e\u00c8\u00ba\u001bM\u0088i\u00bf\u00e2\u00a5A;\u00a6\u00e65\u00f8;\u00f9^\u0095\"E\u00ae\u00f6N\u001e\u009b\u00ee0S]`\u00ad\u00af\u00e00\u009aV\u0011\u0090\u00a1\u0080\u0086\u00c3;\u00f5\u00b9'\u00c0D\u0004\"5\u00f5t\u009bQ\u00fb$\u00da:\u00dd\u00a8\u00b9\u0015k\u00f8\u00b3\u0096\u0081\u0002$\u00b3.\u00c7\u0091\u0005#\u0094\u000e=\u00cd\u0010\u00a7\u00f8\u00ee</\u0092\u0002\u00c7\u00c5G\u00c1?;\u00edt\u001e\u0019U:\u00c0\u00e8\u0014\u00ab\u00cf\u0089\u00c2v\u0091\u00c5^\u00b6]\u008cA\u00aa&8\u000b\u0093\u00ab\u00d7\u00f3\u0002\u0092J";
                var4_3 = "zg&\u009b(\t\u009e\u00e1\u0081\u0011s\u00ac\r\u0097\u009a\u0011\r\u00ad`\u00c4\u0085'\u0010\u0098S\u00eep\u00a7l\u00dc \bG\u0085\u0092\u00fbe\u00c4\u00edu\u00ab\u00ca\u00cf\u00e1\u00f6\u0019z\u00a15\u009d\u00c3\u0083(H!\u0014\u00cc;\u00f3C:P\u0000\u0017K\u00af5\u00050~\u00a5>U\u0003&\u0013\u00cd\u0081x\u0097\u0082\u00fd;[\u0084\u00e4?\u00e6\u00f9\u00a3\u00c2S\u00ad\u0098\u00a2\u00b476\u0004O&\u007f\u00fe\u0081\u0099l\u009cg\u00ec_1|\u00cc\u009d>\u0097\u009b!\u0096Ve\u001f/\u00aaOe\u0082?rP\\m\u00e7\u00c3\u00e0\u00df\u00ff\u00eeVh\u00ce\u00cb\u0003\u0012OF\u0005\u00a3\u0095\u001e\u001d\u00cf$\u00a4\u00a3\u00c5\u0089\u00a2K6Ak\u00bb.\u00f3\u00bf5\u00c0\u001dYN=\u00ad\u001d\r\u00ac\u00841\u0013X\u00e1\u00fd}\u0013\u00e3e\u00e9*n3\u0003\u00dd\u00d3\u00c2z\"\u0004 -k\u009a\u0093\u00fey\u008b\u00c4\u001b6[\u009a\u001d\u008b\u00ffA\u0005\u0015=\u000b\u0092~}\u0014lZ^\u00ae\u00b9c\u00f0\u00d6\u0003u\u00d1]\u0011a~\u008fF\f\u00d2\u0017\u0088\u0005{\u000fcW!\u0016\u0005\u00931\u00b1o\u00b9\u00ff\u00a4\u0015>\u00e9\u0002\u001fp)J\u0011\u009bk \u00a5~/\u000f\u00b7\u00cc\u00b5\u0017\u00a1\u00f0\u00e4\u00fc\u00b8D\u0091*;\u0089\u00c1\u00d8O\u00c0d\u0088\\\u00ce\u00a7\u00d2{Vb\u0017up\u0083\u00cd\u0095\u001d\u00ado\u0091}\u00bc\u0011\u00dcB%\u00f4\u0091b+\u0012|)*4N\u00ab\u00cc\u00a1\u00ae\u0094K\u001c\u0010\u0081\u0018\u00de\u00c9\u009f9D\u0084\u00d33\u0090\u00d8\u00d7\r\u001e\u00ea\u00b8\u0011:\u00a6\u0099w\u00c2\u000f\u009cm\u00e0\u00a4\u00ffUX'\u001b\u008fd\u000f\u00f4\u00f5\u0099\u0000\u00b5DW\u00d1\u0000x\u00c4Y\u00b1Ss\u00f9\u00e9\u0087?X\u0002C5Q8dF\u001b\u00a6E\u00be\u0007\u00dbV66\u00fd\u0081v&\u00aa~\u00ed\u00c0\u0098\u00ca\u0094\u0098\u008c\u0002\u00a4\u00b4\u0012\u0098w\u0003\u00d9@?\u0003\u00a0>2a\u00a6\u00ad\u00ce\u0096+\u00c7\u0082B\u00d5%\u009az#\u0006L[\u0015\u00c4\u00c8\u008cU(\u00f7h6\u00e7=zz\u00a4\u00d7:\u0011R\u00c9\u00fatsC\u00fc>1v\u00b8\u00e3\u0006\u00f8\u00a8Qi/hv\u008a%Uy\u0093\u00bd_t\u000e*\u00de\u0089\u00ff\u00a1q\u008ae1\u0012\u009aw\u00af\u00f7\u00ab\u00e7\u001eY\u00d2 w\u0001:\u0017\u00e7|r\u00f6L\u00c4bX\u00e2\u00c4\u000e\u0017\u00a1'^K\u00c7\u00df\u00b5\u0007\u008d\u00b7h\u00ecw\u00ff\u00c6pCf\u00eb\u001d\u00af2\u009eS\u00ae\u0099\u00cf\u0010\u000b\u0017\u0086WUq\u00d3\u00f9y59L\u0001$\u00c0\u00d8\u009c\u00fb\u001c\u0010\u00bc\u00fc:\u0094\u0013y\b\u00819(\\\u0016(\u0003\u00ca\u0097E\u00c8\u001c\u0098&\u00f2\u00e0\u00c3\u00f4A\u00f4\u0088\u00da\u00ad\u00e4\u00d8\u00b4\u0080\n\u00bf+\u00e3e\u00c6/\u009aDp^\t\u00cdO\u00a5NW\u00dcC+hA6\u00a8\u00d3\u001ad\u008c\u00e6>\u00d0qW\u00d2\u00c9\u001d\u00e0\u0094\b*\u00ee\u00a3\u0005K@\u0082^\u00a8\u008b0\u00f1\u007f\u000b\u0092a\u0013\u00c1i\u0015!|%x\u00e7*XG\u00ff\u00cd,\u000b#\u0094\u00ea2\u009e~B\u00f5\u00a9tgI\u00c1u\u00dfjb\u00e3\u00f3,&\u00eb\u00be3|\u0089XKj\u000b\u00d1\u00dez\u00fcZ#\u001a\u0001\u0012\u0096\u00e5\n\u00b3\u00e4\u0095\u0019\u00daW!NR\u00abE\u00ccoo\u00f0\u00a4\u00af\u0015\u00d8G\u00da[&\u0004\u00ae/\u00d9Sv\u0096\u00f5\u0095w\u00a4\u008a.\u00e9\u00ca\u0018\u0093\u008a\u00e4\u00bcc\u0019\u00c3\u00d6\u00bb\u009e\u00f9\u00c0H\u0013\u001a\u008f\u00be\u009c\u0006\u00e0\u0081\u000b<\u0094\u00d7\u00c6a^\u0002\u0005c\u00a7\u00e0,p\u00ff\u00b6f\u00c8\u009c\u00d3\u00f1\u00beY\u00adI\u009d\u00bc0\u00bb\u009e\u0018\u0001\u0092KVr\u000bR\u00e0[\u0097YU\u00cb\u009f\u00af^\u00bf0\u0081\u00a9\u00a4\u0017\u001e8XN+\u0017\u0015\u00ab\u008a\u00ee\u00cdr\u00d3Zz\u00f7\u00caq+{\u0004\u00f3\u0099\u009c\u0097=\u0091\u00b3Q\u00f2\u00c8\u0002\u008b\u00c6\u000b\u0010\u00adCXc&`\u001a\r\u00b4\u00e2V/\u00e8\u00ff>\r\u00d2F\u00efMf\u00d0\u001b\u0019i5\u00c7\u0080U\u00f0\u00f6\u009a>\u00dc\u00a8\u00a4\u00eb9vs%\u0004\n\u00b8Yl8.\u00c6\n/]\u00df\u001e~L\u00bd\u00dc\u00d6\u0007\u00c0\u0002\u00d6\u00ee\u00d5\u00c8Z\u009b\u000b8^\u00f9f4\u0098m5\u0000@s\rs\u0088O\u0000\u00e2-_x\u0001\u0080\u0087u\u00e51\u0002\u00cc\u0003\u00d4A\u0097\\\u00ba\u0096=}\u00ab\u00198\u00df<\u00bcN\u0081\u00ad\u008a\r^\u0084\u0001\u0019\u00b6\u00ce)W\u008a\u001f\u0092\u00a7\u00dc\u00e7\u00ec\u00f7\u008e\u0013,\u000fT\u0092\u00cbEu]\u00fe\u00ffDy\u00a6\u00e1\u00f7;r\u00bf\"\u008d\u00fc(\u0081U\u00fa\u00c8\u009b~\t\u00ad\t \u00a2(\u00ccjK\u00dc\u0002\u009f[2w\u00c7\u00ffs\u00cd\u00c9[\u0014\u00e3$\u00ecp\u001b\u0000V\u00d7R \u0010\bh\u00ae\u0001cm\u0090\u0096E\u000b\u00b2\u001b4K\f\u00f6X\u00f5\b\u009d\u0012\u00c0\u0088\u0006\u0097>\u00e2\u00bb\u0093sU\u0014\u0007\u00ad\u008a\u001a]\u00f6\u00c8y\u00f2f\u00c0\u00c9\u001aA\"\u00e2\u00e1\u00dafg\u0015\u0003a\tO\u00dd\u0001#c0\u00aa\u00cb^\u0089\u00cc\u0081\u00f7\rq`_\u0085\u001e-\u009d\u00ec\u0093C\u0002!h\u00bf\u0091XX\u001f\u000b_\u00e4d\u00ee\u00d9\u00bc\u00a7\u008e\u0016ul\u00cd\u0099\u00da\u00b7\u00b9\u0010\u001e\u00a2\u00d9w\u00c9\u00fb\u00de\u00ea^\u00e2\u00b2\u008bU{\u00b9\u00cca\ri\u00bb\u000e\u0085\u00d4W oi\u00cd\u00f3\u00c97\u0011}\u00be\u0000\u00bd\u0014\u00fb;\"\n\u008c\u00abj\u00f3\u0090\u0095\u008a\u001c\u00ba\u0096\u00bcb\u00da`\u0096\u009e\u0084}!1\t7\u00a5\u008e\u00fa\u00adZ\u00f0\u00d8\u0099\u00f07\u00c3\u00df\u00ea\u00d6\u009e?w\u00f8\";\u00d4\u00e9$v\u00e4p ;\u00f8~A\u00d6C\u007fy\u00e4\u0002\u0099\u0094\u00042\u001e\u00c8\u00ba\u001bM\u0088i\u00bf\u00e2\u00a5A;\u00a6\u00e65\u00f8;\u00f9^\u0095\"E\u00ae\u00f6N\u001e\u009b\u00ee0S]`\u00ad\u00af\u00e00\u009aV\u0011\u0090\u00a1\u0080\u0086\u00c3;\u00f5\u00b9'\u00c0D\u0004\"5\u00f5t\u009bQ\u00fb$\u00da:\u00dd\u00a8\u00b9\u0015k\u00f8\u00b3\u0096\u0081\u0002$\u00b3.\u00c7\u0091\u0005#\u0094\u000e=\u00cd\u0010\u00a7\u00f8\u00ee</\u0092\u0002\u00c7\u00c5G\u00c1?;\u00edt\u001e\u0019U:\u00c0\u00e8\u0014\u00ab\u00cf\u0089\u00c2v\u0091\u00c5^\u00b6]\u008cA\u00aa&8\u000b\u0093\u00ab\u00d7\u00f3\u0002\u0092J".length();
                var1_4 = 21;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0011u\u0094\tJ.\u00ec&\u0018\u00acw\u00efJ\u008b+~\u00dc\bm\u001c\u00e42\u001dkF\u00ac\u00ec8>\u0018\u00dd I\u0011\u00ce\u0097\\i\u00f2\u00fa]U\u00bd@\u0091\u00a5\u00d2\u00e8\u00de\u00fdT\u00d0\u00b5\u00e4\u001b\u00977\u0019\u008c\u008d\u00a9\u00a9N&j\u0005\u0082WL\u00d0<\u009f\b\u0081TQ\u00160 \u00c8\u00aa\u0016@\"";
                    var4_3 = "\u0011u\u0094\tJ.\u00ec&\u0018\u00acw\u00efJ\u008b+~\u00dc\bm\u001c\u00e42\u001dkF\u00ac\u00ec8>\u0018\u00dd I\u0011\u00ce\u0097\\i\u00f2\u00fa]U\u00bd@\u0091\u00a5\u00d2\u00e8\u00de\u00fdT\u00d0\u00b5\u00e4\u001b\u00977\u0019\u008c\u008d\u00a9\u00a9N&j\u0005\u0082WL\u00d0<\u009f\b\u0081TQ\u00160 \u00c8\u00aa\u0016@\"".length();
                    var1_4 = 27;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 58;
                            break;
                        }
                        case 1: {
                            v13 = 7;
                            break;
                        }
                        case 2: {
                            v13 = 71;
                            break;
                        }
                        case 3: {
                            v13 = 98;
                            break;
                        }
                        case 4: {
                            v13 = 67;
                            break;
                        }
                        case 5: {
                            v13 = 125;
                            break;
                        }
                        default: {
                            v13 = 78;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        CertStoreRootCertificateOps.d = var5;
        CertStoreRootCertificateOps.e = new String[40];
        CertStoreRootCertificateOps.a = LoggerFactory.getLogger(CertStoreRootCertificateOps.class);
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0xF6A) & 0xFFFF;
        if (e[n3] == null) {
            int n4;
            int n5;
            char[] cArray = d[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 221;
                    break;
                }
                case 1: {
                    n5 = 195;
                    break;
                }
                case 2: {
                    n5 = 253;
                    break;
                }
                case 3: {
                    n5 = 208;
                    break;
                }
                case 4: {
                    n5 = 75;
                    break;
                }
                case 5: {
                    n5 = 36;
                    break;
                }
                case 6: {
                    n5 = 200;
                    break;
                }
                case 7: {
                    n5 = 233;
                    break;
                }
                case 8: {
                    n5 = 132;
                    break;
                }
                case 9: {
                    n5 = 129;
                    break;
                }
                case 10: {
                    n5 = 248;
                    break;
                }
                case 11: {
                    n5 = 174;
                    break;
                }
                case 12: {
                    n5 = 81;
                    break;
                }
                case 13: {
                    n5 = 235;
                    break;
                }
                case 14: {
                    n5 = 199;
                    break;
                }
                case 15: {
                    n5 = 68;
                    break;
                }
                case 16: {
                    n5 = 137;
                    break;
                }
                case 17: {
                    n5 = 148;
                    break;
                }
                case 18: {
                    n5 = 117;
                    break;
                }
                case 19: {
                    n5 = 157;
                    break;
                }
                case 20: {
                    n5 = 2;
                    break;
                }
                case 21: {
                    n5 = 48;
                    break;
                }
                case 22: {
                    n5 = 121;
                    break;
                }
                case 23: {
                    n5 = 141;
                    break;
                }
                case 24: {
                    n5 = 122;
                    break;
                }
                case 25: {
                    n5 = 133;
                    break;
                }
                case 26: {
                    n5 = 99;
                    break;
                }
                case 27: {
                    n5 = 212;
                    break;
                }
                case 28: {
                    n5 = 207;
                    break;
                }
                case 29: {
                    n5 = 8;
                    break;
                }
                case 30: {
                    n5 = 52;
                    break;
                }
                case 31: {
                    n5 = 181;
                    break;
                }
                case 32: {
                    n5 = 54;
                    break;
                }
                case 33: {
                    n5 = 237;
                    break;
                }
                case 34: {
                    n5 = 70;
                    break;
                }
                case 35: {
                    n5 = 228;
                    break;
                }
                case 36: {
                    n5 = 153;
                    break;
                }
                case 37: {
                    n5 = 92;
                    break;
                }
                case 38: {
                    n5 = 130;
                    break;
                }
                case 39: {
                    n5 = 161;
                    break;
                }
                case 40: {
                    n5 = 232;
                    break;
                }
                case 41: {
                    n5 = 80;
                    break;
                }
                case 42: {
                    n5 = 204;
                    break;
                }
                case 43: {
                    n5 = 136;
                    break;
                }
                case 44: {
                    n5 = 250;
                    break;
                }
                case 45: {
                    n5 = 238;
                    break;
                }
                case 46: {
                    n5 = 76;
                    break;
                }
                case 47: {
                    n5 = 184;
                    break;
                }
                case 48: {
                    n5 = 7;
                    break;
                }
                case 49: {
                    n5 = 219;
                    break;
                }
                case 50: {
                    n5 = 16;
                    break;
                }
                case 51: {
                    n5 = 231;
                    break;
                }
                case 52: {
                    n5 = 118;
                    break;
                }
                case 53: {
                    n5 = 61;
                    break;
                }
                case 54: {
                    n5 = 109;
                    break;
                }
                case 55: {
                    n5 = 239;
                    break;
                }
                case 56: {
                    n5 = 144;
                    break;
                }
                case 57: {
                    n5 = 110;
                    break;
                }
                case 58: {
                    n5 = 83;
                    break;
                }
                case 59: {
                    n5 = 111;
                    break;
                }
                case 60: {
                    n5 = 241;
                    break;
                }
                case 61: {
                    n5 = 4;
                    break;
                }
                case 62: {
                    n5 = 14;
                    break;
                }
                case 63: {
                    n5 = 56;
                    break;
                }
                case 64: {
                    n5 = 125;
                    break;
                }
                case 65: {
                    n5 = 34;
                    break;
                }
                case 66: {
                    n5 = 203;
                    break;
                }
                case 67: {
                    n5 = 86;
                    break;
                }
                case 68: {
                    n5 = 59;
                    break;
                }
                case 69: {
                    n5 = 147;
                    break;
                }
                case 70: {
                    n5 = 189;
                    break;
                }
                case 71: {
                    n5 = 243;
                    break;
                }
                case 72: {
                    n5 = 65;
                    break;
                }
                case 73: {
                    n5 = 229;
                    break;
                }
                case 74: {
                    n5 = 187;
                    break;
                }
                case 75: {
                    n5 = 10;
                    break;
                }
                case 76: {
                    n5 = 210;
                    break;
                }
                case 77: {
                    n5 = 185;
                    break;
                }
                case 78: {
                    n5 = 100;
                    break;
                }
                case 79: {
                    n5 = 28;
                    break;
                }
                case 80: {
                    n5 = 139;
                    break;
                }
                case 81: {
                    n5 = 214;
                    break;
                }
                case 82: {
                    n5 = 88;
                    break;
                }
                case 83: {
                    n5 = 197;
                    break;
                }
                case 84: {
                    n5 = 215;
                    break;
                }
                case 85: {
                    n5 = 91;
                    break;
                }
                case 86: {
                    n5 = 255;
                    break;
                }
                case 87: {
                    n5 = 0;
                    break;
                }
                case 88: {
                    n5 = 73;
                    break;
                }
                case 89: {
                    n5 = 234;
                    break;
                }
                case 90: {
                    n5 = 246;
                    break;
                }
                case 91: {
                    n5 = 21;
                    break;
                }
                case 92: {
                    n5 = 90;
                    break;
                }
                case 93: {
                    n5 = 182;
                    break;
                }
                case 94: {
                    n5 = 220;
                    break;
                }
                case 95: {
                    n5 = 205;
                    break;
                }
                case 96: {
                    n5 = 245;
                    break;
                }
                case 97: {
                    n5 = 50;
                    break;
                }
                case 98: {
                    n5 = 60;
                    break;
                }
                case 99: {
                    n5 = 31;
                    break;
                }
                case 100: {
                    n5 = 126;
                    break;
                }
                case 101: {
                    n5 = 166;
                    break;
                }
                case 102: {
                    n5 = 168;
                    break;
                }
                case 103: {
                    n5 = 22;
                    break;
                }
                case 104: {
                    n5 = 164;
                    break;
                }
                case 105: {
                    n5 = 134;
                    break;
                }
                case 106: {
                    n5 = 222;
                    break;
                }
                case 107: {
                    n5 = 103;
                    break;
                }
                case 108: {
                    n5 = 95;
                    break;
                }
                case 109: {
                    n5 = 202;
                    break;
                }
                case 110: {
                    n5 = 172;
                    break;
                }
                case 111: {
                    n5 = 96;
                    break;
                }
                case 112: {
                    n5 = 105;
                    break;
                }
                case 113: {
                    n5 = 30;
                    break;
                }
                case 114: {
                    n5 = 102;
                    break;
                }
                case 115: {
                    n5 = 131;
                    break;
                }
                case 116: {
                    n5 = 180;
                    break;
                }
                case 117: {
                    n5 = 44;
                    break;
                }
                case 118: {
                    n5 = 46;
                    break;
                }
                case 119: {
                    n5 = 27;
                    break;
                }
                case 120: {
                    n5 = 190;
                    break;
                }
                case 121: {
                    n5 = 94;
                    break;
                }
                case 122: {
                    n5 = 64;
                    break;
                }
                case 123: {
                    n5 = 154;
                    break;
                }
                case 124: {
                    n5 = 108;
                    break;
                }
                case 125: {
                    n5 = 72;
                    break;
                }
                case 126: {
                    n5 = 6;
                    break;
                }
                case 127: {
                    n5 = 128;
                    break;
                }
                case 128: {
                    n5 = 98;
                    break;
                }
                case 129: {
                    n5 = 226;
                    break;
                }
                case 130: {
                    n5 = 123;
                    break;
                }
                case 131: {
                    n5 = 29;
                    break;
                }
                case 132: {
                    n5 = 45;
                    break;
                }
                case 133: {
                    n5 = 167;
                    break;
                }
                case 134: {
                    n5 = 43;
                    break;
                }
                case 135: {
                    n5 = 18;
                    break;
                }
                case 136: {
                    n5 = 158;
                    break;
                }
                case 137: {
                    n5 = 51;
                    break;
                }
                case 138: {
                    n5 = 41;
                    break;
                }
                case 139: {
                    n5 = 201;
                    break;
                }
                case 140: {
                    n5 = 115;
                    break;
                }
                case 141: {
                    n5 = 193;
                    break;
                }
                case 142: {
                    n5 = 223;
                    break;
                }
                case 143: {
                    n5 = 32;
                    break;
                }
                case 144: {
                    n5 = 242;
                    break;
                }
                case 145: {
                    n5 = 120;
                    break;
                }
                case 146: {
                    n5 = 69;
                    break;
                }
                case 147: {
                    n5 = 84;
                    break;
                }
                case 148: {
                    n5 = 9;
                    break;
                }
                case 149: {
                    n5 = 37;
                    break;
                }
                case 150: {
                    n5 = 77;
                    break;
                }
                case 151: {
                    n5 = 240;
                    break;
                }
                case 152: {
                    n5 = 160;
                    break;
                }
                case 153: {
                    n5 = 35;
                    break;
                }
                case 154: {
                    n5 = 89;
                    break;
                }
                case 155: {
                    n5 = 155;
                    break;
                }
                case 156: {
                    n5 = 113;
                    break;
                }
                case 157: {
                    n5 = 25;
                    break;
                }
                case 158: {
                    n5 = 254;
                    break;
                }
                case 159: {
                    n5 = 198;
                    break;
                }
                case 160: {
                    n5 = 150;
                    break;
                }
                case 161: {
                    n5 = 252;
                    break;
                }
                case 162: {
                    n5 = 62;
                    break;
                }
                case 163: {
                    n5 = 47;
                    break;
                }
                case 164: {
                    n5 = 13;
                    break;
                }
                case 165: {
                    n5 = 55;
                    break;
                }
                case 166: {
                    n5 = 163;
                    break;
                }
                case 167: {
                    n5 = 194;
                    break;
                }
                case 168: {
                    n5 = 165;
                    break;
                }
                case 169: {
                    n5 = 173;
                    break;
                }
                case 170: {
                    n5 = 169;
                    break;
                }
                case 171: {
                    n5 = 211;
                    break;
                }
                case 172: {
                    n5 = 71;
                    break;
                }
                case 173: {
                    n5 = 19;
                    break;
                }
                case 174: {
                    n5 = 49;
                    break;
                }
                case 175: {
                    n5 = 114;
                    break;
                }
                case 176: {
                    n5 = 209;
                    break;
                }
                case 177: {
                    n5 = 106;
                    break;
                }
                case 178: {
                    n5 = 188;
                    break;
                }
                case 179: {
                    n5 = 107;
                    break;
                }
                case 180: {
                    n5 = 151;
                    break;
                }
                case 181: {
                    n5 = 213;
                    break;
                }
                case 182: {
                    n5 = 24;
                    break;
                }
                case 183: {
                    n5 = 15;
                    break;
                }
                case 184: {
                    n5 = 140;
                    break;
                }
                case 185: {
                    n5 = 152;
                    break;
                }
                case 186: {
                    n5 = 175;
                    break;
                }
                case 187: {
                    n5 = 236;
                    break;
                }
                case 188: {
                    n5 = 192;
                    break;
                }
                case 189: {
                    n5 = 87;
                    break;
                }
                case 190: {
                    n5 = 247;
                    break;
                }
                case 191: {
                    n5 = 63;
                    break;
                }
                case 192: {
                    n5 = 93;
                    break;
                }
                case 193: {
                    n5 = 3;
                    break;
                }
                case 194: {
                    n5 = 179;
                    break;
                }
                case 195: {
                    n5 = 23;
                    break;
                }
                case 196: {
                    n5 = 33;
                    break;
                }
                case 197: {
                    n5 = 244;
                    break;
                }
                case 198: {
                    n5 = 38;
                    break;
                }
                case 199: {
                    n5 = 67;
                    break;
                }
                case 200: {
                    n5 = 230;
                    break;
                }
                case 201: {
                    n5 = 251;
                    break;
                }
                case 202: {
                    n5 = 186;
                    break;
                }
                case 203: {
                    n5 = 112;
                    break;
                }
                case 204: {
                    n5 = 53;
                    break;
                }
                case 205: {
                    n5 = 171;
                    break;
                }
                case 206: {
                    n5 = 74;
                    break;
                }
                case 207: {
                    n5 = 170;
                    break;
                }
                case 208: {
                    n5 = 78;
                    break;
                }
                case 209: {
                    n5 = 225;
                    break;
                }
                case 210: {
                    n5 = 119;
                    break;
                }
                case 211: {
                    n5 = 156;
                    break;
                }
                case 212: {
                    n5 = 104;
                    break;
                }
                case 213: {
                    n5 = 146;
                    break;
                }
                case 214: {
                    n5 = 42;
                    break;
                }
                case 215: {
                    n5 = 26;
                    break;
                }
                case 216: {
                    n5 = 79;
                    break;
                }
                case 217: {
                    n5 = 97;
                    break;
                }
                case 218: {
                    n5 = 82;
                    break;
                }
                case 219: {
                    n5 = 101;
                    break;
                }
                case 220: {
                    n5 = 40;
                    break;
                }
                case 221: {
                    n5 = 159;
                    break;
                }
                case 222: {
                    n5 = 127;
                    break;
                }
                case 223: {
                    n5 = 162;
                    break;
                }
                case 224: {
                    n5 = 124;
                    break;
                }
                case 225: {
                    n5 = 58;
                    break;
                }
                case 226: {
                    n5 = 1;
                    break;
                }
                case 227: {
                    n5 = 135;
                    break;
                }
                case 228: {
                    n5 = 142;
                    break;
                }
                case 229: {
                    n5 = 85;
                    break;
                }
                case 230: {
                    n5 = 218;
                    break;
                }
                case 231: {
                    n5 = 17;
                    break;
                }
                case 232: {
                    n5 = 39;
                    break;
                }
                case 233: {
                    n5 = 217;
                    break;
                }
                case 234: {
                    n5 = 206;
                    break;
                }
                case 235: {
                    n5 = 191;
                    break;
                }
                case 236: {
                    n5 = 11;
                    break;
                }
                case 237: {
                    n5 = 227;
                    break;
                }
                case 238: {
                    n5 = 66;
                    break;
                }
                case 239: {
                    n5 = 177;
                    break;
                }
                case 240: {
                    n5 = 196;
                    break;
                }
                case 241: {
                    n5 = 145;
                    break;
                }
                case 242: {
                    n5 = 5;
                    break;
                }
                case 243: {
                    n5 = 143;
                    break;
                }
                case 244: {
                    n5 = 57;
                    break;
                }
                case 245: {
                    n5 = 12;
                    break;
                }
                case 246: {
                    n5 = 138;
                    break;
                }
                case 247: {
                    n5 = 249;
                    break;
                }
                case 248: {
                    n5 = 183;
                    break;
                }
                case 249: {
                    n5 = 116;
                    break;
                }
                case 250: {
                    n5 = 20;
                    break;
                }
                case 251: {
                    n5 = 176;
                    break;
                }
                case 252: {
                    n5 = 178;
                    break;
                }
                case 253: {
                    n5 = 149;
                    break;
                }
                case 254: {
                    n5 = 224;
                    break;
                }
                default: {
                    n5 = 216;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            CertStoreRootCertificateOps.e[n3] = new String(cArray).intern();
        }
        return e[n3];
    }
}

