/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.mobile;

import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignerIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.infra.mobile.IMobileSigner;
import tr.gov.tubitak.uekae.esya.api.infra.mobile.MSSPClientConnector;
import tr.gov.tubitak.uekae.esya.api.infra.mobile.MultiSignResult;
import tr.gov.tubitak.uekae.esya.api.infra.mobile.SigningMode;
import tr.gov.tubitak.uekae.esya.api.infra.mobile.UserIdentifier;
import tr.gov.tubitak.uekae.esya.asn.cms.SigningCertificate;
import tr.gov.tubitak.uekae.esya.asn.cms.SigningCertificateV2;

public class MobileSigner
extends IMobileSigner {
    MSSPClientConnector a;
    UserIdentifier c;
    ECertificate d;
    String e;
    AlgorithmParameterSpec f;

    public MobileSigner(MSSPClientConnector connector, UserIdentifier aUserIden, ECertificate aSigningCert, String informativeText, String aSigningAlg, AlgorithmParameterSpec aParams) {
        super(informativeText);
        this.a = connector;
        this.c = aUserIden;
        this.d = aSigningCert;
        this.e = aSigningAlg;
        this.f = aParams;
    }

    public byte[] sign(byte[] aData) throws ESYAException {
        DigestAlg digestAlg = SignatureAlg.fromName((String)this.getSignatureAlgorithmStr()).getDigestAlg();
        this.calculateFingerPrint(digestAlg, aData);
        return this.a.sign(aData, SigningMode.SIGNHASH, this.c, this.d, this.informativeText, this.e, this.f);
    }

    public ArrayList<MultiSignResult> sign(ArrayList<byte[]> aData, ArrayList<String> informativeText) throws ESYAException {
        return this.a.sign(aData, SigningMode.SIGNHASH, this.c, this.d, informativeText, this.e, this.f);
    }

    public String getSignatureAlgorithmStr() {
        return this.e;
    }

    @Override
    public ECertificate getSigningCert() {
        return this.a.getSigningCert();
    }

    @Override
    public ESignerIdentifier getSignerIdentifier() {
        return this.a.getSignerIdentifier();
    }

    @Override
    public SigningCertificate getSigningCertAttr() {
        return this.a.getSigningCertAttr();
    }

    @Override
    public SigningCertificateV2 getSigningCertAttrv2() {
        return this.a.getSigningCertAttrv2();
    }

    @Override
    public DigestAlg getDigestAlg() {
        return this.a.getDigestAlg();
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.f;
    }
}

