/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.infra.ocsp;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1BigInteger;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1Type;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EBasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ECertID;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EResponseData;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.ESingleResponse;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtension;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EExtensions;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ESubjectPublicKeyInfo;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.KeyUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.SignUtil;
import tr.gov.tubitak.uekae.esya.api.infra.ocsp.configuration.element.AbstractConfigElement;
import tr.gov.tubitak.uekae.esya.api.infra.util.HashMultiMap;
import tr.gov.tubitak.uekae.esya.asn.ocsp.BasicOCSPResponse;
import tr.gov.tubitak.uekae.esya.asn.ocsp.CertID;
import tr.gov.tubitak.uekae.esya.asn.ocsp.OCSPRequest;
import tr.gov.tubitak.uekae.esya.asn.ocsp.OCSPResponse;
import tr.gov.tubitak.uekae.esya.asn.ocsp.Request;
import tr.gov.tubitak.uekae.esya.asn.ocsp.TBSRequest;
import tr.gov.tubitak.uekae.esya.asn.ocsp.Version;
import tr.gov.tubitak.uekae.esya.asn.ocsp._SeqOfRequest;
import tr.gov.tubitak.uekae.esya.asn.ocsp._ocspValues;
import tr.gov.tubitak.uekae.esya.asn.x509.AlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.asn.x509.Extension;
import tr.gov.tubitak.uekae.esya.asn.x509.Extensions;

public class OCSPClient {
    protected static Logger logger;
    public static final int REASON_UNSPECIFIED = 0;
    public static final int REASON_KEY_COMPROMISE = 1;
    public static final int REASON_CA_COMPROMISE = 2;
    public static final int REASON_AFFILIATION_CHANGED = 3;
    public static final int REASON_SUPERSEDED = 4;
    public static final int REASON_CESSATION_OF_OPERATION = 5;
    public static final int REASON_CERTIFICATE_HOLD = 6;
    public static final int REASON_PRIVILEGE_WITHDRAWN = 9;
    public static final int REASON_AA_COMPROMISE = 10;
    public static final int STATUS_RESPONSE_HAS_INVALID_SIGNATURE = 1;
    public static final int STATUS_RESPONSE_CANT_BE_RECEIVED = 2;
    public static final int STATUS_RESPONCE_INVALID_NONCE = 3;
    private static final String a;
    private static final String b;
    private static final String c;
    private static final String d;
    private static final String e;
    public static final Asn1ObjectIdentifier NONCE_OID;
    private int f;
    protected HashMultiMap<BigInteger, ESingleResponse> singleResponses;
    protected ECertificate signingCertificate;
    protected EBasicOCSPResponse mBasicResponse;
    protected EOCSPResponse mOCSPResponce;
    private static final Logger g;
    private String h;
    private HttpURLConnection i;
    private URL j;
    private byte[] k;
    private int l;
    private boolean m;
    private boolean n;
    private boolean o;
    private boolean p;
    public static DigestAlg digestAlgForOcspRequest;
    public static int q;
    private static final String[] r;
    private static final String[] s;

    protected OCSPClient() {
        block6: {
            boolean bl;
            block8: {
                block7: {
                    this.h = null;
                    this.i = null;
                    this.j = null;
                    this.k = null;
                    this.l = 0;
                    this.m = true;
                    this.n = true;
                    this.o = true;
                    int n = q;
                    this.p = false;
                    this.singleResponses = new HashMultiMap();
                    try {
                        LV.getInstance().checkLD(LV.Urunler.ORTAK);
                    }
                    catch (LE lE) {
                        throw new ESYARuntimeException(OCSPClient.a(4259, 15005) + lE.getMessage());
                    }
                    if (n == 0) break block6;
                    if (!AbstractConfigElement.b) break block7;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
            AbstractConfigElement.b = bl;
        }
    }

    public OCSPClient(String aConnectionAddress) throws ESYAException {
        this();
        try {
            this.j = new URL(aConnectionAddress);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ESYAException((Throwable)malformedURLException);
        }
        this.h = aConnectionAddress;
    }

    public void setCheckSignature(boolean aCheckSignature) {
        this.m = aCheckSignature;
    }

    public void setCheckNonce(boolean aCheckNonce) {
        this.n = aCheckNonce;
    }

    public void setCheckResponseStatus(boolean aCheckResponseStatus) {
        this.o = aCheckResponseStatus;
    }

    public void setCheckDate(boolean aCheckDate) {
        this.p = aCheckDate;
    }

    public void openConnection() throws ESYAException {
        this.openConnection(null);
    }

    public void closeConnection() throws ESYAException {
        this.i.disconnect();
    }

    public void openConnection(String aTimeOut) throws ESYAException {
        int n = q;
        try {
            this.i = (HttpURLConnection)this.j.openConnection();
            if (aTimeOut != null) {
                this.i.setConnectTimeout(Integer.parseInt(aTimeOut));
                this.i.setReadTimeout(Integer.parseInt(aTimeOut));
            }
            this.i.setRequestProperty(OCSPClient.a(4258, 16253), OCSPClient.a(4291, 32556));
            this.i.setRequestProperty(OCSPClient.a(4289, 28701), OCSPClient.a(4300, 25956));
            this.i.setRequestMethod(OCSPClient.a(4342, 6335));
            this.i.setDoOutput(true);
            this.i.setUseCaches(false);
            this.i.connect();
        }
        catch (IOException iOException) {
            g.error(OCSPClient.a(4348, -26120) + this.h, (Throwable)iOException);
            throw new ESYAException(OCSPClient.a(4297, 23641) + this.h, (Throwable)iOException);
        }
        if (AbstractConfigElement.b) {
            q = ++n;
        }
    }

    public Calendar getProducedAt() {
        return this.mBasicResponse.getProducedAt();
    }

    public void queryCertificate(ECertificate aCertificateToQuery, ECertificate aIssuerCertificate) throws ESYAException {
        this.queryCertificate(new ECertificate[]{aCertificateToQuery}, new ECertificate[]{aIssuerCertificate});
    }

    public EOCSPResponse queryCertificate(ECertificate[] aCertificatesToQuery, ECertificate[] aIssuerCertificates) throws ESYAException {
        if (this.i == null) {
            g.error(OCSPClient.a(4327, -8025));
            throw new ESYAException(OCSPClient.a(4290, 23185));
        }
        byte[] byArray = this.a(aCertificatesToQuery, aIssuerCertificates);
        this.a(byArray);
        g.debug(OCSPClient.a(4263, 1853));
        return this.mOCSPResponce;
    }

    public EOCSPResponse queryCertificate(BigInteger aSertifikaSeriNo, byte[] aSMSubjectHashDegeri, byte[] aSMAcikAnahtarHashDegeri) throws ESYAException {
        if (this.i == null) {
            g.error(OCSPClient.a(4335, -15288));
            throw new ESYAException(OCSPClient.a(4336, -1247));
        }
        byte[] byArray = this.a(aSertifikaSeriNo, aSMSubjectHashDegeri, aSMAcikAnahtarHashDegeri);
        this.a(byArray);
        g.debug(OCSPClient.a(4288, -9145));
        return this.mOCSPResponce;
    }

    public int getStatus() {
        return this.l;
    }

    private EOCSPResponse a(byte[] byArray) throws ESYAException {
        block10: {
            block11: {
                int n = q;
                try {
                    DataOutputStream dataOutputStream = new DataOutputStream(this.i.getOutputStream());
                    dataOutputStream.write(byArray);
                    dataOutputStream.flush();
                    dataOutputStream.close();
                }
                catch (IOException iOException) {
                    g.error(OCSPClient.a(4319, -1853), (Throwable)iOException);
                    throw new ESYAException(OCSPClient.a(4317, 10605), (Throwable)iOException);
                }
                try {
                    g.debug(OCSPClient.a(4350, -17702));
                    this.mOCSPResponce = this.b();
                    g.debug(OCSPClient.a(4345, -9983));
                }
                catch (Exception exception) {
                    this.l = 2;
                    g.error(OCSPClient.a(4257, -1396), (Throwable)exception);
                    throw new ESYAException(OCSPClient.a(4308, -27700), (Throwable)exception);
                }
                if (!this.o) break block10;
                if (!this.checkResponseStatus()) break block11;
                this.a(this.mOCSPResponce);
                if (n == 0) break block10;
            }
            this.mOCSPResponce = null;
            g.error(OCSPClient.a(4293, 18977));
            throw new ESYAException(OCSPClient.a(4262, 10288));
        }
        return this.mOCSPResponce;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(ECertificate[] eCertificateArray, ECertificate[] eCertificateArray2) throws ESYAException {
        g.debug(OCSPClient.a(4314, 13266));
        int n = q;
        if (eCertificateArray == null || eCertificateArray.length == 0) {
            g.error(OCSPClient.a(4309, 26873));
            throw new ESYAException(OCSPClient.a(4320, 25852));
        }
        int n2 = eCertificateArray.length;
        Request[] requestArray = new Request[n2];
        for (int i = 0; i < n2; ++i) {
            ECertificate eCertificate = eCertificateArray[i];
            ECertificate eCertificate2 = eCertificateArray2[i];
            try {
                requestArray[i] = this.a(eCertificate, eCertificate2);
                continue;
            }
            catch (Exception exception) {
                g.error(OCSPClient.a(4321, -17176), (Throwable)exception);
                throw new ESYAException(OCSPClient.a(4294, 14071), (Throwable)exception);
            }
        }
        return this.a(requestArray);
    }

    private byte[] a(BigInteger bigInteger, byte[] byArray, byte[] byArray2) throws ESYAException {
        Request[] requestArray = new Request[1];
        try {
            requestArray[0] = this.b(bigInteger, byArray, byArray2);
        }
        catch (Exception exception) {
            g.error(OCSPClient.a(4330, -3800), (Throwable)exception);
            return null;
        }
        return this.a(requestArray);
    }

    private byte[] a(Request[] requestArray) throws ESYAException {
        Extension extension;
        OCSPRequest oCSPRequest = new OCSPRequest();
        TBSRequest tBSRequest = new TBSRequest();
        try {
            extension = this.a();
        }
        catch (Exception exception) {
            g.warn(OCSPClient.a(4298, 14745), (Throwable)exception);
            throw new ESYAException(OCSPClient.a(4351, -7900));
        }
        tBSRequest.requestList = new _SeqOfRequest(requestArray);
        tBSRequest.requestExtensions = new Extensions(new Extension[]{extension});
        tBSRequest.version = new Version(0L);
        oCSPRequest.tbsRequest = tBSRequest;
        Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
        try {
            oCSPRequest.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
        }
        catch (Exception exception) {
            g.error(OCSPClient.a(4331, 29479), (Throwable)exception);
            throw new ESYAException(OCSPClient.a(4344, 2809));
        }
        byte[] byArray = asn1DerEncodeBuffer.getMsgCopy();
        g.debug(OCSPClient.a(4341, 2586));
        return byArray;
    }

    private Extension a() throws ESYAException {
        try {
            Extension extension = new Extension();
            extension.extnID = NONCE_OID;
            this.k = new byte[16];
            SecureRandom.getInstance(OCSPClient.a(4303, -6370)).nextBytes(this.k);
            Asn1OctetString asn1OctetString = new Asn1OctetString(this.k);
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            asn1OctetString.encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
            extension.extnValue = new Asn1OctetString(asn1DerEncodeBuffer.getMsgCopy());
            return extension;
        }
        catch (Exception exception) {
            throw new ESYAException((Throwable)exception);
        }
    }

    private EOCSPResponse b() throws ESYAException {
        OCSPResponse oCSPResponse = new OCSPResponse();
        InputStream inputStream = null;
        try {
            inputStream = this.i.getInputStream();
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(inputStream);
            oCSPResponse.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
            g.debug(OCSPClient.a(4349, -10674));
        }
        catch (IOException iOException) {
            g.error(OCSPClient.a(4322, -5067), (Throwable)iOException);
            throw new ESYAException(OCSPClient.a(4324, 32744), (Throwable)iOException);
        }
        catch (Exception exception) {
            g.error(OCSPClient.a(4329, -27935), (Throwable)exception);
            throw new ESYAException(OCSPClient.a(4299, -31291), (Throwable)exception);
        }
        return new EOCSPResponse(oCSPResponse);
    }

    private Request a(ECertificate eCertificate, ECertificate eCertificate2) throws Exception {
        BigInteger bigInteger = eCertificate.getSerialNumber();
        byte[] byArray = DigestUtil.digest((DigestAlg)digestAlgForOcspRequest, (byte[])eCertificate2.getSubject().getEncoded());
        byte[] byArray2 = DigestUtil.digest((DigestAlg)digestAlgForOcspRequest, (byte[])eCertificate2.getSubjectPublicKeyInfo().getSubjectPublicKey());
        return this.b(bigInteger, byArray, byArray2);
    }

    private Request b(BigInteger bigInteger, byte[] byArray, byte[] byArray2) throws ESYAException {
        CertID certID = new CertID();
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(digestAlgForOcspRequest.getOID());
        Asn1OctetString asn1OctetString = new Asn1OctetString(byArray);
        Asn1OctetString asn1OctetString2 = new Asn1OctetString(byArray2);
        Asn1BigInteger asn1BigInteger = new Asn1BigInteger(bigInteger);
        certID.hashAlgorithm = algorithmIdentifier;
        certID.issuerNameHash = asn1OctetString;
        certID.issuerKeyHash = asn1OctetString2;
        certID.serialNumber = asn1BigInteger;
        return new Request(certID);
    }

    public int getResponseStatus() {
        return this.f;
    }

    public ESingleResponse getSingleResponse(ECertificate aCertificateToQuery, ECertificate aIssuerCertificate) throws ESYAException {
        List<ESingleResponse> list = this.singleResponses.get(aCertificateToQuery.getSerialNumber());
        int n = q;
        if (list == null) {
            throw new ESYAException(OCSPClient.a(4312, 20167));
        }
        for (ESingleResponse eSingleResponse : list) {
            ECertID eCertID = eSingleResponse.getCertID();
            if (OCSPClient.isEqual(eCertID, aCertificateToQuery, aIssuerCertificate)) {
                return eSingleResponse;
            }
            if (n == 0) continue;
        }
        throw new ESYAException(OCSPClient.a(4311, 25988));
    }

    public static boolean isEqual(ECertID certID, ECertificate aCertificateToQuery, ECertificate aIssuerCertificate) {
        block5: {
            if (certID.getSerialNumber().equals(aCertificateToQuery.getSerialNumber())) {
                try {
                    byte[] byArray = aIssuerCertificate.getSubject().getEncoded();
                    byte[] byArray2 = aIssuerCertificate.getSubjectPublicKeyInfo().getSubjectPublicKey();
                    DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)certID.getHashAlgorithm());
                    byte[] byArray3 = DigestUtil.digest((DigestAlg)digestAlg, (byte[])byArray);
                    byte[] byArray4 = DigestUtil.digest((DigestAlg)digestAlg, (byte[])byArray2);
                    if (!Arrays.equals(certID.getIssuerNameHash(), byArray3) || !Arrays.equals(certID.getIssuerKeyHash(), byArray4)) break block5;
                    return true;
                }
                catch (CryptoException cryptoException) {
                    logger.warn(OCSPClient.a(4328, 13712), (Throwable)cryptoException);
                    return false;
                }
            }
        }
        return false;
    }

    public EBasicOCSPResponse getBasicResponse() {
        return this.mBasicResponse;
    }

    public EOCSPResponse getOCSPResponse() {
        return this.mOCSPResponce;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkResponseStatus() {
        int n;
        this.f = n = this.mOCSPResponce.getResponseStatus();
        g.debug(OCSPClient.a(4301, -19854) + n);
        switch (n) {
            case 0: {
                g.debug(OCSPClient.a(4325, -32436));
                return true;
            }
            case 1: {
                g.debug(OCSPClient.a(4333, 31339));
                return false;
            }
            case 2: {
                g.debug(OCSPClient.a(4260, 31140));
                return false;
            }
            case 3: {
                g.debug(OCSPClient.a(4339, -2543));
                return false;
            }
            case 5: {
                g.debug(OCSPClient.a(4304, 7116));
                return false;
            }
            case 6: {
                g.debug(OCSPClient.a(4296, 5276));
                return false;
            }
        }
        return false;
    }

    public void checkResponse() throws ESYAException {
        this.a(this.mOCSPResponce);
    }

    private void a(EOCSPResponse eOCSPResponse) throws ESYAException {
        int n;
        block17: {
            block18: {
                block15: {
                    block16: {
                        n = q;
                        try {
                            this.mBasicResponse = eOCSPResponse.getBasicOCSPResponse();
                        }
                        catch (Exception exception) {
                            g.error(OCSPClient.a(4299, -31291), (Throwable)exception);
                            throw new ESYAException(OCSPClient.a(4299, -31291), (Throwable)exception);
                        }
                        if (!this.n) break block15;
                        if (this.checkNonce()) break block16;
                        this.mOCSPResponce = null;
                        this.l = 3;
                        g.error(OCSPClient.a(4315, 14540));
                        throw new ESYAException(OCSPClient.a(4334, 29661));
                    }
                    g.debug(OCSPClient.a(4307, -29215));
                }
                if (!this.m) break block17;
                if (this.checkSignature()) break block18;
                this.mOCSPResponce = null;
                this.l = 1;
                g.error(OCSPClient.a(4292, -16387));
                throw new ESYAException(OCSPClient.a(4310, 17554));
            }
            g.debug(OCSPClient.a(4346, 10061));
        }
        EResponseData eResponseData = this.mBasicResponse.getTbsResponseData();
        int n2 = eResponseData.getSingleResponseCount();
        for (int i = 0; i < n2; ++i) {
            ESingleResponse eSingleResponse = eResponseData.getSingleResponse(i);
            if (this.p) {
                Calendar calendar = Calendar.getInstance();
                if (!this.checkDate(eSingleResponse, calendar)) {
                    g.error(OCSPClient.a(4302, 7583));
                    throw new ESYAException(OCSPClient.a(4338, 28674));
                }
            }
            this.singleResponses.put(eSingleResponse.getCertID().getSerialNumber(), eSingleResponse);
            if (n == 0) continue;
        }
    }

    public boolean checkDate(ESingleResponse aResponse, Calendar aDate) {
        block7: {
            if (aDate.before(aResponse.getThisUpdate())) {
                g.warn(OCSPClient.a(4306, -29096));
                return false;
            }
            if (aResponse.getNextUpdate() == null || !aDate.after(aResponse.getNextUpdate())) break block7;
            g.warn(OCSPClient.a(4316, -866));
            return false;
        }
        return true;
    }

    public byte[] getNonce() {
        return this.k;
    }

    public boolean checkNonce() {
        EExtensions eExtensions = this.mBasicResponse.getResponseExtensions();
        int n = q;
        if (eExtensions == null) {
            g.error(OCSPClient.a(4323, 748));
            return false;
        }
        for (int i = 0; i < eExtensions.getExtensionCount(); ++i) {
            EExtension eExtension = eExtensions.getExtension(i);
            if (!eExtension.getIdentifier().equals((Asn1Type)NONCE_OID)) continue;
            byte[] byArray = eExtension.getValue();
            Asn1OctetString asn1OctetString = new Asn1OctetString();
            Asn1DerDecodeBuffer asn1DerDecodeBuffer = new Asn1DerDecodeBuffer(byArray);
            try {
                asn1OctetString.decode((Asn1BerDecodeBuffer)asn1DerDecodeBuffer);
            }
            catch (Exception exception) {
                g.error(OCSPClient.a(4313, 4901), (Throwable)exception);
                return false;
            }
            if (Arrays.equals(asn1OctetString.value, this.k)) {
                return true;
            }
            return false;
        }
        g.error(OCSPClient.a(4305, -17733));
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkSignature() {
        byte[] byArray = null;
        byArray = this.mBasicResponse.getTbsResponseData().getEncoded();
        byte[] byArray2 = this.mBasicResponse.getSignature();
        int n = q;
        if (this.mBasicResponse.getObject() == null || ((BasicOCSPResponse)this.mBasicResponse.getObject()).certs == null) {
            g.error(OCSPClient.a(4332, 12211));
            return false;
        }
        for (int i = 0; i < this.mBasicResponse.getCertificateCount(); ++i) {
            ECertificate eCertificate = this.mBasicResponse.getCertificate(i);
            try {
                Pair pair = SignatureAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)this.mBasicResponse.getSignatureAlgorithm());
                PublicKey publicKey = KeyUtil.decodePublicKey((ESubjectPublicKeyInfo)eCertificate.getSubjectPublicKeyInfo());
                if (SignUtil.verify((SignatureAlg)((SignatureAlg)pair.first()), (AlgorithmParams)((AlgorithmParams)pair.second()), (byte[])byArray, (byte[])byArray2, (PublicKey)publicKey)) {
                    return true;
                }
                byte[] byArray3 = new byte[byArray2.length];
                int n2 = byArray2.length - 1;
                for (int j = 0; j < byArray2.length; ++j) {
                    byArray3[j] = byArray2[n2 - j];
                    if (n == 0) continue;
                }
                if (!SignUtil.verify((SignatureAlg)((SignatureAlg)pair.first()), (AlgorithmParams)((AlgorithmParams)pair.second()), (byte[])byArray, (byte[])byArray3, (PublicKey)publicKey)) continue;
                return true;
            }
            catch (CryptoException cryptoException) {
                g.error(OCSPClient.a(4261, -22402), (Throwable)cryptoException);
                return false;
            }
        }
        g.debug(OCSPClient.a(4347, 4277));
        return false;
    }

    public ECertificate getSigningCertificate() throws ESYAException {
        if (this.mBasicResponse == null) {
            throw new ESYAException(OCSPClient.a(4343, -7882));
        }
        if (this.signingCertificate != null) {
            return this.signingCertificate;
        }
        if (this.checkSignature()) {
            return this.signingCertificate;
        }
        return null;
    }

    public void setDigestAlgForOcspRequest(DigestAlg digestAlg) {
        digestAlgForOcspRequest = digestAlg;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[71];
                var3_1 = 0;
                var2_2 = "\n~\u00db\u0080\u00ce\nL\u00d2\u00fa\u00ce\u019e\u0014\u009e0e\u01c8\u00a7\u0095I\u0016\u00ba\u001d\u00bd\u00f2\u00ea\u01ce\u0112\u00dd\u0011\u00d9\u00b3^*@\u00dc\u0097s[\u00c4\u0082m\u00c8\u00d2\u0012,.\u000e\u000fEm\u00f0\u0089\u00a3\u0010\u00be\u012f*\u00d3\u01d5\u00fa\u01a1'\u008fq\u00d5\u00a5O]\u0095]F\u00b2U\u00a9;\u00bb@\\\u00fd2~\u0015\u00d7e\u0082\u00ee\u008fhI\u00d9m\"m\u0098\u009b\u00e1\u0006D\u000e\u00f6Y'\u00c0\u00cd<2r\u00af2\u0003\u00b2k\u01da\u008f\u00f5\u000f\u001c\u00c8r/j\u0099,\u0001\u00cbe3\u008a\u00c4F\u00b5U6\u0018\u0084\\\u0017\u00ca\u0092,\u01de'\u00aev\u00f1E\u00cbA\u0005\u00deT\u00c2\u0017\u00a7szId\u00dc5Z\u00f5Sy\u0012m\u009d\u0018\u000b\u00d7%\u00e3d\u00a0\u00ba\u00e6\"\u00a4\u008a\u00ea\u00c9\u0014\u01ee\u0082N\u00d8\u00b4\"\u00c2\u0083\u00f3\u011f!\u00ce|JP\u00afW)\u00a2\u0189\u0017\u0097\u0005\u0084\u00b1=\u009b'\u00a9$\u00c9\u00bd\u00f0\u001c\u000b\u00d6\u0080@:\u0017\u00c6\u00e5\u00feP\u001c|\u00ad\u0015\u00fa\u0017Ew;\u009d\u00f3\u0172\u00b3\u0003\u00c4\u00d6\u0156\u00d1F\u0087lcR\u0086\u001b\u008d\u01f3\u01fez*\u008cq\u00b5\u00a5C]\u0014]v\u00b2S\u00a9\u00fb\u00bbX\\\u00fe|\u0019\u0014\u00d3\u00ec\u00e0cN\u00cbq\u00b2p\u009f\u008f}\u00dc~\u00e3\u0131\f1\u010d\u0085\u0157\u00ea\u001e/\u0003i8\t\u00ba\u0011\u0088\u0002N\u0088\u00ac \u0095\u009b\u00ab\u000e\u00ae\u00a3\u00dd\u00a6m,\u00e7\u00f8ys(I\u00e4\u001fN\u00fd\u0002\u00ee\u00f5!\u001b\u008f\n\r\u009ezB\u001dz\u00aa\u0002\u0088m\u00e4\u00b6<\u00db\u0014%\u00e1\u00ce\u00cfz\u0001\u00ba,\u0010K&\u00e21\u00bfLH\u00adI\u00ac\u00ae\u0004[\u00a7@\u0001\u00ff\u00e7g6\u00f15\u0087\u00de\u00b2[\u00c5wTf\u0012\u00c9YA\u00b5X\u00bd\u00d9\u0013\u001c\u00cd\u00a3\u008d\u0014\u01361U\u00ae\u00d7\u00ec\u00aeZ~\u0124\u0090\u00a9J\u00a6\u00962\u008f\u009a\u00b9\u01ff.\u0087c\u00d4\u00e7o\u0015\u0091T\u00c6\u0093E\u008d9?\u0000\u00cc\u00f5nr\\\u00f8\u00a2(b=\f7\u001c\u00ed\u00f2\u00ff\u0081J\u0088\u009dU\u00aaj\u0089{\u00c3\u001a\u0000\u008d~)\u0015L\f\u0097RKWw\u00e6PG\u009e\u00e8d\u00d5x\u009c\u00e8!u\u00de.\u0010\u00ae!\u00a39\u00df\u0006\u00b9rg\u00deS\u008e\u00c8\u00fcg\u0005\u00035K\u008c!\u00d6\u00d1\u00fe\u00b1*\u00d5/\u0005\u00c1\u0194h\u00a2\u00fb,\u0181\u00f5'\u0132M\u00ed\u00a3\u00f3\n\u00e7F\u01ae\u00b7)\u00f1\u00d7\u00bf\u00b5\u008f\f\u00c0z\u008cI\u00bbm\u00f7\u00ac\f\u00b5\u00dfi\u0016=\u00eb+%A\u0019\u0018\u00fc#\u00c0\u00ac}\u00a4\u00af\u0012\u00ff\u0010\u007f\u00d9\u008e.\u00d6/\u001b\u0092G\u00d9\u001d\u00d2\u00df\u00ac\u000f\u008c|d\u001e\u00dd\u00e0\u008ehtls:\u0085i$UL.\u009cJ\\8g\u00c4w\u00cd\u00974\u00b6&D\u00d5\u00bep\u009a\u00f35\u01ee\u0018\u00e8\u00a4\u00f1v\u00c5\u009c\u00a0gl\u00a8WT\u00f6\u001e\u00a0\u00e0\u00f5\u00e0\u00bf\u0081v\u0085:\u00dc6].1\u0088\u009f]\u00e3\u00e5\u0005Kn\u00cer\u0001\u0088\u009bz\u000f\u008f\u0095\u00e0\u00bb-\u00f3\u001f\u00d9\u00f5)\u008b8\u00cfHL\u0013\u001c\u00f1\u00f0\u00aa\u01df\u0098\u00b6\u00a1`\u01fa\u0007\u00d3]\u00de8\u0004\u00ed\u00d1\u00e1\u01aa\"K<Q\u0096\u0000-\u0091v\u00d3\r\u001e\u00f7\u00d9\u00b1\u009e\u00c8\u00c2\u00ac\u00d5/P\u0089\u00ce\u00a1'vu\u0016\u008dO\u00c8Q\u00ddd\u000en3A>\fz\u00a3\u0088\u0154O\f\u00c5}\u00e1#\\3\u00af\u00ed\u0000Z|w{H\u00bb\u00e2\u0081$\u00e2\u00f4\u00e2J\u00f5\u00b1\u00b4x\u00e3\u009f\u0007\u00b9[\u00ed,M\u0014\u00f9\u00ea\u00cf\u00e8'X./N\u00100~\u00e6,T\u00bf\u00ce;\u00cb\u00ad\u0114E\u00ef\u00cb\u0151\u008b\u0183\u00be\u00dd~?\u00f6\u0011\u0014o\u007f\u00c7!`\u00ee\u013d.\u00b7\u00f50\u00ccXRZ\u00b3\u00b2\n\u012e\u00b1\u009af\u00a3\u0010\u0004+\u00fa\u00c6\u00f3P\u00c1v\u00fc/\u001b\u0089\u00a2 L\u00ad\u00f1\u00a7\u00e3m\u00c8W\u00dd9\u009a)\u00efOOJ{\u00b4;\u0106e(\u00d2\u00ff~t:g;\u001a\u0093Z\u00ef\u00b4l\u0018\u00aa(\u00a0\u00f2\u00d5\u00c7\u00b9\u00d6~-t!\u00a8\u00c8\u000f\u0015N\u0093$\u00e7\u01c8_\u0083\u0146\u00d0\u0102\f\u0085\u0090<J\u00a3\u00f4VY\u01eau\u00de\u01d0\u0018\u00e5\tWx\u00b6\u00c3\u00de\u00b2\u00e6\u00ed\u00fb\u00b27*g\u00b7|\u00e3\u00cf}lh\u00f9B\n\u00af\u00db\u00be\u00e4\u00df1)\u00a5\u009c\u00d8\u0018\bP\u00eaS\u0001\u00a6(\u001e8x \u0000L|\b}\u0091\u00barV\u00db\r\u000f\u00ee\u0014\u00a8\u00bc\u0099\u00cf\u0017D\u00c3B\u0155\u00b5\u009c\u0126\u0013\u01df,\u00d4\u0015\u019d\u00ee\u00f3)\u00f1\u00a0\u001a\u009f\u00b6\u001a\u00aa\u00b5\u00a1\u00af\u00a9\n\u00a4\u00cf\u00b3\u00d2\u0083\u00ad\u00b1,5\u00ab\u00ef\u0082F\u00d4\u00eev\u00c7\u00c2Wi\u0007\u00b8\u01ac\u00b4\u000f\u013b^\u01ad|\u0018\u0017h\u000e\u00ef:\u00af_\u0001\u0093d\u00a8\u00cd\t-_\u0086\n,@\u0018\u0089\u00b6\u00c5\u00ba\u0015\u00b0~\u0082\u00d3zj\u00cf\u00a40oT\u00cb\r ]\u0013\u00ad0\u00d0\u0097N\n\u0010~IP!\u00a7\u00f6wg\u0082#\u00aa(q\u008e\u00db+\u0010\u00fb\u0016C\u00a3i\u00ce\u00e7\u0097\u0019f\u01a2\fB\u01c0\u0082?\u00b6\u00d6\u0003O\u00caJ\u00a8\u00b9DTq\u0125\bS\b\u00c3\u0081\u00ad\u00a5\u009cd/\u009f\u000e\u00d7J\u000f\u00a0\u009d\u00e2GEu]?\u00fa\u00c4j\u00ec\u00e8\u00fc\u00e0(\u00f7+j\u001d\u0085'\u00a5k{\u001c\u0083@\u00eb]\u0004&\u00c4d\n\u009dwy\u00a3\u00d2\u0012\u01ca\u0013\u0092\u00eb@!k\u001d\u0090m7\u00d4\u00de\u001b\u0006\u000e3\u0013\u008f\u001b\u00fc\u0011\u0092\u00987Omp2\u00e6\u00efv\u0014;\u001a\u0018Hue.\u00a9~\u0011D\u00d7a\u0086\u00da$B\u0019\u00b7\u00b2xq$\u00dbs\u00b7\u00ff@\u00d6?\u00ec\u00df\u00ddk&f\u00b5\u008eid\u0095X\u00f6\u0012\u001e\u009e\u00f5!\u00cb\\\u00b7\u00f5n\u001e\u00f6l\u00e6\u009c\u00f6lO^\b\beW\u00b6\u00a5sJs\u00f1u\u0150<DS\u00f7\u00ca\u00a8\u0005\u0004\u008b\u01a0\u001b\u000e\u001a\u00e5\u00c8I\u00e0U\u00fcI\u0017\u0013\u00a6\u00ae\u00c6\u001f\u01b5\u0013\u00db\u0001\u01d7\u00d2\u0003\u008a\u009d\u0005\u0123\u00a2\u001a\u00c3v\u00f4\u0096\u00baog2\u00cc\u0019QF\u001b\u00c8\u00e4\u000f\u00f7\u00c7+\u009b\u00cd\u00eb\u000e\u00ea\u0010\u00e0<Tb\u00ae\u00c7 \u0000x\u00c0\u00ea\u00bb\u00bdj\u00a1M\u0016\u00be\u009e\u00d6\u00d6y\u00acwk\u00a6\u00d6Y\u00fc\u00d4\u0083\u00e5\u00c5\u009d\u0015.#f\u0097e\u009c\u00a9\u00c8I\u00eb\u00c8\u00f9u\u00fe\u00b7\u00c7\u0002\u008cK\u00da\u00c4\u00c4\u001ce\u00cf\u008c\u00cf)q0\n\u008d\u00b4X\u00ea\u00fd\u00a9\u00a6\u00a8+\u0084\u00eb\u00b7V\u0003=\u00a1>7\u00e9\u00af\u00caN\u00dd\u00efW\u00e7\u00e6S\u00ed\u0087(\u01bc\u00a6\r\u0179\u001e\u01e5t\u001e\u009d3.`\u00f8Ir\u0004\u0096\u0011\u0082J\u00a1\u00f6\u0017\u00e6\u00daY\u00f6\u0094^H\u000b\u00f5Pw\u00fc\u00e7[\u009d\u001e\u0000\u00dc$\u0010q\u00fbR\u009f\u00a9{\u000f.l~oS}\u00e3\u00ebd-\u001c\u00b1\u012eI_7\u00fa\u00cd\u017f)\u0087d\u00d4\u0007o\t\u0091\u00d7\u00c6\u00e3E\u00839\u00fe\u0000\u00f4\u00f5ix\u00b6\u00ff\u00b8e\u00e9\u00fe\u009ag\u0098\u00b2\u00da\u00d7\u00d5\u00d7k\u0082\u0193 e\u0188\u0010\u01e74*\u000ba\u00ea\u00d9\u00b4G`\u001c\u0015\u001eD_&r\u0089\u00f2Z\u00ad\u0007\u00a0\u00b5\u00e5&\u01bb\u0084)\r\u00b6\u01e6J\u00f5\u0085\u00c7\u000eZ\u00bb\u00a4\u00c2 \u00a4\u00972l\u0011\u0010\u001e\u0099\u008dL/J-xl+\u0006\u0090)n\u00d39q\u01ab\u00cc\u00dbg\u00d9\u00c5\u00ca\u008e}\u0086\u00d9\u00b6\u0086\u00c1\u000fxm\u008f09m\u001d3Y\u00f9e2?\u0018\u0084ic\u008e\u0094\u017c\u0019\u00f3?\u00f2\u00bfzJ\u007f\u0096\u00cf\u008d1\u00d4\u0017\u009acB\u00c7\u00ae\u00fal\u00de4.vm\u001f\u01b1$\u00a5\f\u00c9\u00b8eJ\u0015\u00d4\u0094\u00ec\u00e2\u00f0\u00fe\u00d1!\u0093\u00a0K\u00e2\u00a3\u0011\u0089\b\u00ff\u00995\u0102UP\u0003\u00efE\u00d7\u001f\u01e6rO\u00c6\u0094\u00e1\u00cea`\u00b1:@7eDcv\u00c5J\u0081\u00bf\u00fa\u00ba\u00a2}\u009a7\u0099\u01d7\u00c0\u00ea3\u00ddh\u009f\u0086\u00069\u00bc\u00d1c#\u00f1\u0098\u00af\u00f5\u00c7\u00c0\u00a3s\u0087\"\u00e5\u0011M\u00b2\u01ae\u0016\u008b_\u00e2\u01ac\u00c0\u00bc\u00d4\u00ee$\u007f\u00fe\u0000j\u00b4\u00b1\u0005\u0090>EZ\u0011\u00d1Ts\u00f7*\u0000\u00bb$\u00fcqvR8\u00be\u001eJ<\u00d8\t<\nr\u00b6\u0088M\u00e1\u00c7\u00a6\u0006\u0086gh'S-\u00eb+P\u00b4r\u0168>\u001a\u014b\u00e0\u019fF\u0019\u00d3g^g>\u000f\u00ad^\u0091\u01ffb\u00cf\u00b7\u008c\u008e\u0173\u00af_\u0091\u0095_\u00875\r23KbM\u00c7\\\u0011\u00f7\u00d4\n\u0091\u01cd\u00d0\u0017\u00e4@\u00b5\u00f9\u0080\u001bG\u0015\u008e\u001f\u00c6<\u0098\u000b\u0093\u00fc\u00ba\u00f4m\u0000W\u009f\u00a2\u00ee\u000e\u008bFF=\u00eb\u00bb\f\u0003L<\u0018\u00ac\u00ff<F\u00de\u00ecPh\u00f2q\u009e\u00cbp\u0099\u0013%b\u0086[\u008cj\u0094\u00ee\u00e4\u0085b\u00f8\u00f7\u0092\u00d8\u00ad\u0007\u00caUx\u0007\u0092a\u00f1\u00df\u0097\u0095\u00f7\u00e9\u0082\u00cf\u00b1}ZnR\u00d5\u00be\u00ce\u00dc\u00926\u00cdBD\u0004\u00a8\u00b6#\u00d4\u00f5\u00be5\"\\/\u0015\u00f1\u009e_\u00d2Q\u0090d\u00f7\u0018\u017f\u00c3\u00f9\u0139\u00f5\u0000X1\u00de\u00b3q\u00d5\u00dfJ\u00aa*\u00ac\u01ea\u001c\u008a\u00be\u00eb\u009e\u00e3\u0013\u00a0+g\u000eLQ\u00d7/\u00fcB:\u00ef\u00cf^\u008f\u0093\u000f/T\u00dd~\u0003\u001e\u0098\u00fd\u00d8\u00ee\u00e2$*\u01fc\u00e9\u00c7\u009d\u00ae\u00ec\u0194\u00c3\u00b2\u00f0\u00ce\u001b\u00c2\u001b\u00c6\u0013\u00d3\u00b0\u00de1\u0158\u0006\u0096\u001bJ*\u00c5\u001d\u009c\u001e\u00a3\u001cT\u00dcB\u00fey\u00df\u00b4\u00edw\u008b\u008a\u00061\u0080rR!\u00f5\u00ba\u001b\u00fdf\u00d8\u0019\u0084\u00cd.@\u00d2\u00b1\\\u000b\u00ce\f\u00a1\u001c\\6::\u0015\u00ec\u00b1a\u00a1\u00aa\u00f1";
                var4_3 = "\n~\u00db\u0080\u00ce\nL\u00d2\u00fa\u00ce\u019e\u0014\u009e0e\u01c8\u00a7\u0095I\u0016\u00ba\u001d\u00bd\u00f2\u00ea\u01ce\u0112\u00dd\u0011\u00d9\u00b3^*@\u00dc\u0097s[\u00c4\u0082m\u00c8\u00d2\u0012,.\u000e\u000fEm\u00f0\u0089\u00a3\u0010\u00be\u012f*\u00d3\u01d5\u00fa\u01a1'\u008fq\u00d5\u00a5O]\u0095]F\u00b2U\u00a9;\u00bb@\\\u00fd2~\u0015\u00d7e\u0082\u00ee\u008fhI\u00d9m\"m\u0098\u009b\u00e1\u0006D\u000e\u00f6Y'\u00c0\u00cd<2r\u00af2\u0003\u00b2k\u01da\u008f\u00f5\u000f\u001c\u00c8r/j\u0099,\u0001\u00cbe3\u008a\u00c4F\u00b5U6\u0018\u0084\\\u0017\u00ca\u0092,\u01de'\u00aev\u00f1E\u00cbA\u0005\u00deT\u00c2\u0017\u00a7szId\u00dc5Z\u00f5Sy\u0012m\u009d\u0018\u000b\u00d7%\u00e3d\u00a0\u00ba\u00e6\"\u00a4\u008a\u00ea\u00c9\u0014\u01ee\u0082N\u00d8\u00b4\"\u00c2\u0083\u00f3\u011f!\u00ce|JP\u00afW)\u00a2\u0189\u0017\u0097\u0005\u0084\u00b1=\u009b'\u00a9$\u00c9\u00bd\u00f0\u001c\u000b\u00d6\u0080@:\u0017\u00c6\u00e5\u00feP\u001c|\u00ad\u0015\u00fa\u0017Ew;\u009d\u00f3\u0172\u00b3\u0003\u00c4\u00d6\u0156\u00d1F\u0087lcR\u0086\u001b\u008d\u01f3\u01fez*\u008cq\u00b5\u00a5C]\u0014]v\u00b2S\u00a9\u00fb\u00bbX\\\u00fe|\u0019\u0014\u00d3\u00ec\u00e0cN\u00cbq\u00b2p\u009f\u008f}\u00dc~\u00e3\u0131\f1\u010d\u0085\u0157\u00ea\u001e/\u0003i8\t\u00ba\u0011\u0088\u0002N\u0088\u00ac \u0095\u009b\u00ab\u000e\u00ae\u00a3\u00dd\u00a6m,\u00e7\u00f8ys(I\u00e4\u001fN\u00fd\u0002\u00ee\u00f5!\u001b\u008f\n\r\u009ezB\u001dz\u00aa\u0002\u0088m\u00e4\u00b6<\u00db\u0014%\u00e1\u00ce\u00cfz\u0001\u00ba,\u0010K&\u00e21\u00bfLH\u00adI\u00ac\u00ae\u0004[\u00a7@\u0001\u00ff\u00e7g6\u00f15\u0087\u00de\u00b2[\u00c5wTf\u0012\u00c9YA\u00b5X\u00bd\u00d9\u0013\u001c\u00cd\u00a3\u008d\u0014\u01361U\u00ae\u00d7\u00ec\u00aeZ~\u0124\u0090\u00a9J\u00a6\u00962\u008f\u009a\u00b9\u01ff.\u0087c\u00d4\u00e7o\u0015\u0091T\u00c6\u0093E\u008d9?\u0000\u00cc\u00f5nr\\\u00f8\u00a2(b=\f7\u001c\u00ed\u00f2\u00ff\u0081J\u0088\u009dU\u00aaj\u0089{\u00c3\u001a\u0000\u008d~)\u0015L\f\u0097RKWw\u00e6PG\u009e\u00e8d\u00d5x\u009c\u00e8!u\u00de.\u0010\u00ae!\u00a39\u00df\u0006\u00b9rg\u00deS\u008e\u00c8\u00fcg\u0005\u00035K\u008c!\u00d6\u00d1\u00fe\u00b1*\u00d5/\u0005\u00c1\u0194h\u00a2\u00fb,\u0181\u00f5'\u0132M\u00ed\u00a3\u00f3\n\u00e7F\u01ae\u00b7)\u00f1\u00d7\u00bf\u00b5\u008f\f\u00c0z\u008cI\u00bbm\u00f7\u00ac\f\u00b5\u00dfi\u0016=\u00eb+%A\u0019\u0018\u00fc#\u00c0\u00ac}\u00a4\u00af\u0012\u00ff\u0010\u007f\u00d9\u008e.\u00d6/\u001b\u0092G\u00d9\u001d\u00d2\u00df\u00ac\u000f\u008c|d\u001e\u00dd\u00e0\u008ehtls:\u0085i$UL.\u009cJ\\8g\u00c4w\u00cd\u00974\u00b6&D\u00d5\u00bep\u009a\u00f35\u01ee\u0018\u00e8\u00a4\u00f1v\u00c5\u009c\u00a0gl\u00a8WT\u00f6\u001e\u00a0\u00e0\u00f5\u00e0\u00bf\u0081v\u0085:\u00dc6].1\u0088\u009f]\u00e3\u00e5\u0005Kn\u00cer\u0001\u0088\u009bz\u000f\u008f\u0095\u00e0\u00bb-\u00f3\u001f\u00d9\u00f5)\u008b8\u00cfHL\u0013\u001c\u00f1\u00f0\u00aa\u01df\u0098\u00b6\u00a1`\u01fa\u0007\u00d3]\u00de8\u0004\u00ed\u00d1\u00e1\u01aa\"K<Q\u0096\u0000-\u0091v\u00d3\r\u001e\u00f7\u00d9\u00b1\u009e\u00c8\u00c2\u00ac\u00d5/P\u0089\u00ce\u00a1'vu\u0016\u008dO\u00c8Q\u00ddd\u000en3A>\fz\u00a3\u0088\u0154O\f\u00c5}\u00e1#\\3\u00af\u00ed\u0000Z|w{H\u00bb\u00e2\u0081$\u00e2\u00f4\u00e2J\u00f5\u00b1\u00b4x\u00e3\u009f\u0007\u00b9[\u00ed,M\u0014\u00f9\u00ea\u00cf\u00e8'X./N\u00100~\u00e6,T\u00bf\u00ce;\u00cb\u00ad\u0114E\u00ef\u00cb\u0151\u008b\u0183\u00be\u00dd~?\u00f6\u0011\u0014o\u007f\u00c7!`\u00ee\u013d.\u00b7\u00f50\u00ccXRZ\u00b3\u00b2\n\u012e\u00b1\u009af\u00a3\u0010\u0004+\u00fa\u00c6\u00f3P\u00c1v\u00fc/\u001b\u0089\u00a2 L\u00ad\u00f1\u00a7\u00e3m\u00c8W\u00dd9\u009a)\u00efOOJ{\u00b4;\u0106e(\u00d2\u00ff~t:g;\u001a\u0093Z\u00ef\u00b4l\u0018\u00aa(\u00a0\u00f2\u00d5\u00c7\u00b9\u00d6~-t!\u00a8\u00c8\u000f\u0015N\u0093$\u00e7\u01c8_\u0083\u0146\u00d0\u0102\f\u0085\u0090<J\u00a3\u00f4VY\u01eau\u00de\u01d0\u0018\u00e5\tWx\u00b6\u00c3\u00de\u00b2\u00e6\u00ed\u00fb\u00b27*g\u00b7|\u00e3\u00cf}lh\u00f9B\n\u00af\u00db\u00be\u00e4\u00df1)\u00a5\u009c\u00d8\u0018\bP\u00eaS\u0001\u00a6(\u001e8x \u0000L|\b}\u0091\u00barV\u00db\r\u000f\u00ee\u0014\u00a8\u00bc\u0099\u00cf\u0017D\u00c3B\u0155\u00b5\u009c\u0126\u0013\u01df,\u00d4\u0015\u019d\u00ee\u00f3)\u00f1\u00a0\u001a\u009f\u00b6\u001a\u00aa\u00b5\u00a1\u00af\u00a9\n\u00a4\u00cf\u00b3\u00d2\u0083\u00ad\u00b1,5\u00ab\u00ef\u0082F\u00d4\u00eev\u00c7\u00c2Wi\u0007\u00b8\u01ac\u00b4\u000f\u013b^\u01ad|\u0018\u0017h\u000e\u00ef:\u00af_\u0001\u0093d\u00a8\u00cd\t-_\u0086\n,@\u0018\u0089\u00b6\u00c5\u00ba\u0015\u00b0~\u0082\u00d3zj\u00cf\u00a40oT\u00cb\r ]\u0013\u00ad0\u00d0\u0097N\n\u0010~IP!\u00a7\u00f6wg\u0082#\u00aa(q\u008e\u00db+\u0010\u00fb\u0016C\u00a3i\u00ce\u00e7\u0097\u0019f\u01a2\fB\u01c0\u0082?\u00b6\u00d6\u0003O\u00caJ\u00a8\u00b9DTq\u0125\bS\b\u00c3\u0081\u00ad\u00a5\u009cd/\u009f\u000e\u00d7J\u000f\u00a0\u009d\u00e2GEu]?\u00fa\u00c4j\u00ec\u00e8\u00fc\u00e0(\u00f7+j\u001d\u0085'\u00a5k{\u001c\u0083@\u00eb]\u0004&\u00c4d\n\u009dwy\u00a3\u00d2\u0012\u01ca\u0013\u0092\u00eb@!k\u001d\u0090m7\u00d4\u00de\u001b\u0006\u000e3\u0013\u008f\u001b\u00fc\u0011\u0092\u00987Omp2\u00e6\u00efv\u0014;\u001a\u0018Hue.\u00a9~\u0011D\u00d7a\u0086\u00da$B\u0019\u00b7\u00b2xq$\u00dbs\u00b7\u00ff@\u00d6?\u00ec\u00df\u00ddk&f\u00b5\u008eid\u0095X\u00f6\u0012\u001e\u009e\u00f5!\u00cb\\\u00b7\u00f5n\u001e\u00f6l\u00e6\u009c\u00f6lO^\b\beW\u00b6\u00a5sJs\u00f1u\u0150<DS\u00f7\u00ca\u00a8\u0005\u0004\u008b\u01a0\u001b\u000e\u001a\u00e5\u00c8I\u00e0U\u00fcI\u0017\u0013\u00a6\u00ae\u00c6\u001f\u01b5\u0013\u00db\u0001\u01d7\u00d2\u0003\u008a\u009d\u0005\u0123\u00a2\u001a\u00c3v\u00f4\u0096\u00baog2\u00cc\u0019QF\u001b\u00c8\u00e4\u000f\u00f7\u00c7+\u009b\u00cd\u00eb\u000e\u00ea\u0010\u00e0<Tb\u00ae\u00c7 \u0000x\u00c0\u00ea\u00bb\u00bdj\u00a1M\u0016\u00be\u009e\u00d6\u00d6y\u00acwk\u00a6\u00d6Y\u00fc\u00d4\u0083\u00e5\u00c5\u009d\u0015.#f\u0097e\u009c\u00a9\u00c8I\u00eb\u00c8\u00f9u\u00fe\u00b7\u00c7\u0002\u008cK\u00da\u00c4\u00c4\u001ce\u00cf\u008c\u00cf)q0\n\u008d\u00b4X\u00ea\u00fd\u00a9\u00a6\u00a8+\u0084\u00eb\u00b7V\u0003=\u00a1>7\u00e9\u00af\u00caN\u00dd\u00efW\u00e7\u00e6S\u00ed\u0087(\u01bc\u00a6\r\u0179\u001e\u01e5t\u001e\u009d3.`\u00f8Ir\u0004\u0096\u0011\u0082J\u00a1\u00f6\u0017\u00e6\u00daY\u00f6\u0094^H\u000b\u00f5Pw\u00fc\u00e7[\u009d\u001e\u0000\u00dc$\u0010q\u00fbR\u009f\u00a9{\u000f.l~oS}\u00e3\u00ebd-\u001c\u00b1\u012eI_7\u00fa\u00cd\u017f)\u0087d\u00d4\u0007o\t\u0091\u00d7\u00c6\u00e3E\u00839\u00fe\u0000\u00f4\u00f5ix\u00b6\u00ff\u00b8e\u00e9\u00fe\u009ag\u0098\u00b2\u00da\u00d7\u00d5\u00d7k\u0082\u0193 e\u0188\u0010\u01e74*\u000ba\u00ea\u00d9\u00b4G`\u001c\u0015\u001eD_&r\u0089\u00f2Z\u00ad\u0007\u00a0\u00b5\u00e5&\u01bb\u0084)\r\u00b6\u01e6J\u00f5\u0085\u00c7\u000eZ\u00bb\u00a4\u00c2 \u00a4\u00972l\u0011\u0010\u001e\u0099\u008dL/J-xl+\u0006\u0090)n\u00d39q\u01ab\u00cc\u00dbg\u00d9\u00c5\u00ca\u008e}\u0086\u00d9\u00b6\u0086\u00c1\u000fxm\u008f09m\u001d3Y\u00f9e2?\u0018\u0084ic\u008e\u0094\u017c\u0019\u00f3?\u00f2\u00bfzJ\u007f\u0096\u00cf\u008d1\u00d4\u0017\u009acB\u00c7\u00ae\u00fal\u00de4.vm\u001f\u01b1$\u00a5\f\u00c9\u00b8eJ\u0015\u00d4\u0094\u00ec\u00e2\u00f0\u00fe\u00d1!\u0093\u00a0K\u00e2\u00a3\u0011\u0089\b\u00ff\u00995\u0102UP\u0003\u00efE\u00d7\u001f\u01e6rO\u00c6\u0094\u00e1\u00cea`\u00b1:@7eDcv\u00c5J\u0081\u00bf\u00fa\u00ba\u00a2}\u009a7\u0099\u01d7\u00c0\u00ea3\u00ddh\u009f\u0086\u00069\u00bc\u00d1c#\u00f1\u0098\u00af\u00f5\u00c7\u00c0\u00a3s\u0087\"\u00e5\u0011M\u00b2\u01ae\u0016\u008b_\u00e2\u01ac\u00c0\u00bc\u00d4\u00ee$\u007f\u00fe\u0000j\u00b4\u00b1\u0005\u0090>EZ\u0011\u00d1Ts\u00f7*\u0000\u00bb$\u00fcqvR8\u00be\u001eJ<\u00d8\t<\nr\u00b6\u0088M\u00e1\u00c7\u00a6\u0006\u0086gh'S-\u00eb+P\u00b4r\u0168>\u001a\u014b\u00e0\u019fF\u0019\u00d3g^g>\u000f\u00ad^\u0091\u01ffb\u00cf\u00b7\u008c\u008e\u0173\u00af_\u0091\u0095_\u00875\r23KbM\u00c7\\\u0011\u00f7\u00d4\n\u0091\u01cd\u00d0\u0017\u00e4@\u00b5\u00f9\u0080\u001bG\u0015\u008e\u001f\u00c6<\u0098\u000b\u0093\u00fc\u00ba\u00f4m\u0000W\u009f\u00a2\u00ee\u000e\u008bFF=\u00eb\u00bb\f\u0003L<\u0018\u00ac\u00ff<F\u00de\u00ecPh\u00f2q\u009e\u00cbp\u0099\u0013%b\u0086[\u008cj\u0094\u00ee\u00e4\u0085b\u00f8\u00f7\u0092\u00d8\u00ad\u0007\u00caUx\u0007\u0092a\u00f1\u00df\u0097\u0095\u00f7\u00e9\u0082\u00cf\u00b1}ZnR\u00d5\u00be\u00ce\u00dc\u00926\u00cdBD\u0004\u00a8\u00b6#\u00d4\u00f5\u00be5\"\\/\u0015\u00f1\u009e_\u00d2Q\u0090d\u00f7\u0018\u017f\u00c3\u00f9\u0139\u00f5\u0000X1\u00de\u00b3q\u00d5\u00dfJ\u00aa*\u00ac\u01ea\u001c\u008a\u00be\u00eb\u009e\u00e3\u0013\u00a0+g\u000eLQ\u00d7/\u00fcB:\u00ef\u00cf^\u008f\u0093\u000f/T\u00dd~\u0003\u001e\u0098\u00fd\u00d8\u00ee\u00e2$*\u01fc\u00e9\u00c7\u009d\u00ae\u00ec\u0194\u00c3\u00b2\u00f0\u00ce\u001b\u00c2\u001b\u00c6\u0013\u00d3\u00b0\u00de1\u0158\u0006\u0096\u001bJ*\u00c5\u001d\u009c\u001e\u00a3\u001cT\u00dcB\u00fey\u00df\u00b4\u00edw\u008b\u008a\u00061\u0080rR!\u00f5\u00ba\u001b\u00fdf\u00d8\u0019\u0084\u00cd.@\u00d2\u00b1\\\u000b\u00ce\f\u00a1\u001c\\6::\u0015\u00ec\u00b1a\u00a1\u00aa\u00f1".length();
                var1_4 = 28;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\r\u00fc5\u0099\u008cw\u0011\u00ef\u00d0\u00ddDd*\u00c4a\u00bc\u00a7b\r0A\u00e5\u00a0\u0086U]\u0011I\u00be\u00b9^s\u00d3>\u00ea\u00d3\u01f0\u0005\u01d4\u00a1\u00db\u00e2Od\u00d2%\u009b\u00b5&\u00c8]\u001e\u01f9\u00bc\u00c3";
                    var4_3 = "\r\u00fc5\u0099\u008cw\u0011\u00ef\u00d0\u00ddDd*\u00c4a\u00bc\u00a7b\r0A\u00e5\u00a0\u0086U]\u0011I\u00be\u00b9^s\u00d3>\u00ea\u00d3\u01f0\u0005\u01d4\u00a1\u00db\u00e2Od\u00d2%\u009b\u00b5&\u00c8]\u001e\u01f9\u00bc\u00c3".length();
                    var1_4 = 12;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 109;
                            break;
                        }
                        case 1: {
                            v13 = 118;
                            break;
                        }
                        case 2: {
                            v13 = 124;
                            break;
                        }
                        case 3: {
                            v13 = 62;
                            break;
                        }
                        case 4: {
                            v13 = 99;
                            break;
                        }
                        case 5: {
                            v13 = 23;
                            break;
                        }
                        default: {
                            v13 = 81;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        OCSPClient.r = var5;
        OCSPClient.s = new String[71];
        OCSPClient.b = OCSPClient.a(4337, -4817);
        OCSPClient.d = OCSPClient.a(4326, -6585);
        OCSPClient.c = OCSPClient.a(4295, -17548);
        OCSPClient.a = OCSPClient.a(4340, 28152);
        OCSPClient.e = OCSPClient.a(4318, -28192);
        OCSPClient.logger = LoggerFactory.getLogger(OCSPClient.class);
        OCSPClient.NONCE_OID = new Asn1ObjectIdentifier(_ocspValues.id_pkix_ocsp_nonce);
        OCSPClient.g = LoggerFactory.getLogger(OCSPClient.class);
        OCSPClient.digestAlgForOcspRequest = DigestAlg.SHA256;
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0x10E7) & 0xFFFF;
        if (s[n3] == null) {
            int n4;
            int n5;
            char[] cArray = r[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 3;
                    break;
                }
                case 1: {
                    n5 = 52;
                    break;
                }
                case 2: {
                    n5 = 152;
                    break;
                }
                case 3: {
                    n5 = 154;
                    break;
                }
                case 4: {
                    n5 = 87;
                    break;
                }
                case 5: {
                    n5 = 56;
                    break;
                }
                case 6: {
                    n5 = 172;
                    break;
                }
                case 7: {
                    n5 = 129;
                    break;
                }
                case 8: {
                    n5 = 18;
                    break;
                }
                case 9: {
                    n5 = 8;
                    break;
                }
                case 10: {
                    n5 = 153;
                    break;
                }
                case 11: {
                    n5 = 149;
                    break;
                }
                case 12: {
                    n5 = 101;
                    break;
                }
                case 13: {
                    n5 = 51;
                    break;
                }
                case 14: {
                    n5 = 22;
                    break;
                }
                case 15: {
                    n5 = 247;
                    break;
                }
                case 16: {
                    n5 = 44;
                    break;
                }
                case 17: {
                    n5 = 6;
                    break;
                }
                case 18: {
                    n5 = 142;
                    break;
                }
                case 19: {
                    n5 = 242;
                    break;
                }
                case 20: {
                    n5 = 88;
                    break;
                }
                case 21: {
                    n5 = 97;
                    break;
                }
                case 22: {
                    n5 = 171;
                    break;
                }
                case 23: {
                    n5 = 218;
                    break;
                }
                case 24: {
                    n5 = 165;
                    break;
                }
                case 25: {
                    n5 = 213;
                    break;
                }
                case 26: {
                    n5 = 140;
                    break;
                }
                case 27: {
                    n5 = 235;
                    break;
                }
                case 28: {
                    n5 = 63;
                    break;
                }
                case 29: {
                    n5 = 136;
                    break;
                }
                case 30: {
                    n5 = 251;
                    break;
                }
                case 31: {
                    n5 = 253;
                    break;
                }
                case 32: {
                    n5 = 241;
                    break;
                }
                case 33: {
                    n5 = 26;
                    break;
                }
                case 34: {
                    n5 = 203;
                    break;
                }
                case 35: {
                    n5 = 73;
                    break;
                }
                case 36: {
                    n5 = 46;
                    break;
                }
                case 37: {
                    n5 = 137;
                    break;
                }
                case 38: {
                    n5 = 188;
                    break;
                }
                case 39: {
                    n5 = 64;
                    break;
                }
                case 40: {
                    n5 = 181;
                    break;
                }
                case 41: {
                    n5 = 94;
                    break;
                }
                case 42: {
                    n5 = 92;
                    break;
                }
                case 43: {
                    n5 = 99;
                    break;
                }
                case 44: {
                    n5 = 244;
                    break;
                }
                case 45: {
                    n5 = 9;
                    break;
                }
                case 46: {
                    n5 = 167;
                    break;
                }
                case 47: {
                    n5 = 98;
                    break;
                }
                case 48: {
                    n5 = 190;
                    break;
                }
                case 49: {
                    n5 = 208;
                    break;
                }
                case 50: {
                    n5 = 248;
                    break;
                }
                case 51: {
                    n5 = 122;
                    break;
                }
                case 52: {
                    n5 = 144;
                    break;
                }
                case 53: {
                    n5 = 126;
                    break;
                }
                case 54: {
                    n5 = 31;
                    break;
                }
                case 55: {
                    n5 = 67;
                    break;
                }
                case 56: {
                    n5 = 127;
                    break;
                }
                case 57: {
                    n5 = 14;
                    break;
                }
                case 58: {
                    n5 = 78;
                    break;
                }
                case 59: {
                    n5 = 135;
                    break;
                }
                case 60: {
                    n5 = 197;
                    break;
                }
                case 61: {
                    n5 = 21;
                    break;
                }
                case 62: {
                    n5 = 177;
                    break;
                }
                case 63: {
                    n5 = 222;
                    break;
                }
                case 64: {
                    n5 = 65;
                    break;
                }
                case 65: {
                    n5 = 113;
                    break;
                }
                case 66: {
                    n5 = 106;
                    break;
                }
                case 67: {
                    n5 = 110;
                    break;
                }
                case 68: {
                    n5 = 145;
                    break;
                }
                case 69: {
                    n5 = 216;
                    break;
                }
                case 70: {
                    n5 = 4;
                    break;
                }
                case 71: {
                    n5 = 80;
                    break;
                }
                case 72: {
                    n5 = 124;
                    break;
                }
                case 73: {
                    n5 = 19;
                    break;
                }
                case 74: {
                    n5 = 28;
                    break;
                }
                case 75: {
                    n5 = 48;
                    break;
                }
                case 76: {
                    n5 = 85;
                    break;
                }
                case 77: {
                    n5 = 2;
                    break;
                }
                case 78: {
                    n5 = 82;
                    break;
                }
                case 79: {
                    n5 = 163;
                    break;
                }
                case 80: {
                    n5 = 254;
                    break;
                }
                case 81: {
                    n5 = 35;
                    break;
                }
                case 82: {
                    n5 = 79;
                    break;
                }
                case 83: {
                    n5 = 112;
                    break;
                }
                case 84: {
                    n5 = 139;
                    break;
                }
                case 85: {
                    n5 = 176;
                    break;
                }
                case 86: {
                    n5 = 81;
                    break;
                }
                case 87: {
                    n5 = 36;
                    break;
                }
                case 88: {
                    n5 = 160;
                    break;
                }
                case 89: {
                    n5 = 200;
                    break;
                }
                case 90: {
                    n5 = 54;
                    break;
                }
                case 91: {
                    n5 = 189;
                    break;
                }
                case 92: {
                    n5 = 184;
                    break;
                }
                case 93: {
                    n5 = 156;
                    break;
                }
                case 94: {
                    n5 = 214;
                    break;
                }
                case 95: {
                    n5 = 161;
                    break;
                }
                case 96: {
                    n5 = 90;
                    break;
                }
                case 97: {
                    n5 = 179;
                    break;
                }
                case 98: {
                    n5 = 43;
                    break;
                }
                case 99: {
                    n5 = 45;
                    break;
                }
                case 100: {
                    n5 = 234;
                    break;
                }
                case 101: {
                    n5 = 227;
                    break;
                }
                case 102: {
                    n5 = 20;
                    break;
                }
                case 103: {
                    n5 = 115;
                    break;
                }
                case 104: {
                    n5 = 103;
                    break;
                }
                case 105: {
                    n5 = 138;
                    break;
                }
                case 106: {
                    n5 = 57;
                    break;
                }
                case 107: {
                    n5 = 7;
                    break;
                }
                case 108: {
                    n5 = 100;
                    break;
                }
                case 109: {
                    n5 = 170;
                    break;
                }
                case 110: {
                    n5 = 133;
                    break;
                }
                case 111: {
                    n5 = 158;
                    break;
                }
                case 112: {
                    n5 = 143;
                    break;
                }
                case 113: {
                    n5 = 118;
                    break;
                }
                case 114: {
                    n5 = 141;
                    break;
                }
                case 115: {
                    n5 = 151;
                    break;
                }
                case 116: {
                    n5 = 202;
                    break;
                }
                case 117: {
                    n5 = 1;
                    break;
                }
                case 118: {
                    n5 = 201;
                    break;
                }
                case 119: {
                    n5 = 240;
                    break;
                }
                case 120: {
                    n5 = 174;
                    break;
                }
                case 121: {
                    n5 = 120;
                    break;
                }
                case 122: {
                    n5 = 17;
                    break;
                }
                case 123: {
                    n5 = 252;
                    break;
                }
                case 124: {
                    n5 = 183;
                    break;
                }
                case 125: {
                    n5 = 245;
                    break;
                }
                case 126: {
                    n5 = 231;
                    break;
                }
                case 127: {
                    n5 = 250;
                    break;
                }
                case 128: {
                    n5 = 162;
                    break;
                }
                case 129: {
                    n5 = 249;
                    break;
                }
                case 130: {
                    n5 = 27;
                    break;
                }
                case 131: {
                    n5 = 53;
                    break;
                }
                case 132: {
                    n5 = 109;
                    break;
                }
                case 133: {
                    n5 = 75;
                    break;
                }
                case 134: {
                    n5 = 49;
                    break;
                }
                case 135: {
                    n5 = 150;
                    break;
                }
                case 136: {
                    n5 = 0;
                    break;
                }
                case 137: {
                    n5 = 91;
                    break;
                }
                case 138: {
                    n5 = 192;
                    break;
                }
                case 139: {
                    n5 = 178;
                    break;
                }
                case 140: {
                    n5 = 41;
                    break;
                }
                case 141: {
                    n5 = 104;
                    break;
                }
                case 142: {
                    n5 = 210;
                    break;
                }
                case 143: {
                    n5 = 96;
                    break;
                }
                case 144: {
                    n5 = 193;
                    break;
                }
                case 145: {
                    n5 = 95;
                    break;
                }
                case 146: {
                    n5 = 105;
                    break;
                }
                case 147: {
                    n5 = 220;
                    break;
                }
                case 148: {
                    n5 = 125;
                    break;
                }
                case 149: {
                    n5 = 114;
                    break;
                }
                case 150: {
                    n5 = 229;
                    break;
                }
                case 151: {
                    n5 = 182;
                    break;
                }
                case 152: {
                    n5 = 217;
                    break;
                }
                case 153: {
                    n5 = 164;
                    break;
                }
                case 154: {
                    n5 = 255;
                    break;
                }
                case 155: {
                    n5 = 196;
                    break;
                }
                case 156: {
                    n5 = 42;
                    break;
                }
                case 157: {
                    n5 = 132;
                    break;
                }
                case 158: {
                    n5 = 239;
                    break;
                }
                case 159: {
                    n5 = 12;
                    break;
                }
                case 160: {
                    n5 = 237;
                    break;
                }
                case 161: {
                    n5 = 205;
                    break;
                }
                case 162: {
                    n5 = 199;
                    break;
                }
                case 163: {
                    n5 = 50;
                    break;
                }
                case 164: {
                    n5 = 40;
                    break;
                }
                case 165: {
                    n5 = 111;
                    break;
                }
                case 166: {
                    n5 = 209;
                    break;
                }
                case 167: {
                    n5 = 24;
                    break;
                }
                case 168: {
                    n5 = 185;
                    break;
                }
                case 169: {
                    n5 = 166;
                    break;
                }
                case 170: {
                    n5 = 15;
                    break;
                }
                case 171: {
                    n5 = 134;
                    break;
                }
                case 172: {
                    n5 = 238;
                    break;
                }
                case 173: {
                    n5 = 10;
                    break;
                }
                case 174: {
                    n5 = 175;
                    break;
                }
                case 175: {
                    n5 = 204;
                    break;
                }
                case 176: {
                    n5 = 159;
                    break;
                }
                case 177: {
                    n5 = 207;
                    break;
                }
                case 178: {
                    n5 = 117;
                    break;
                }
                case 179: {
                    n5 = 25;
                    break;
                }
                case 180: {
                    n5 = 102;
                    break;
                }
                case 181: {
                    n5 = 131;
                    break;
                }
                case 182: {
                    n5 = 232;
                    break;
                }
                case 183: {
                    n5 = 157;
                    break;
                }
                case 184: {
                    n5 = 180;
                    break;
                }
                case 185: {
                    n5 = 71;
                    break;
                }
                case 186: {
                    n5 = 173;
                    break;
                }
                case 187: {
                    n5 = 38;
                    break;
                }
                case 188: {
                    n5 = 107;
                    break;
                }
                case 189: {
                    n5 = 70;
                    break;
                }
                case 190: {
                    n5 = 225;
                    break;
                }
                case 191: {
                    n5 = 93;
                    break;
                }
                case 192: {
                    n5 = 206;
                    break;
                }
                case 193: {
                    n5 = 30;
                    break;
                }
                case 194: {
                    n5 = 221;
                    break;
                }
                case 195: {
                    n5 = 169;
                    break;
                }
                case 196: {
                    n5 = 58;
                    break;
                }
                case 197: {
                    n5 = 155;
                    break;
                }
                case 198: {
                    n5 = 246;
                    break;
                }
                case 199: {
                    n5 = 191;
                    break;
                }
                case 200: {
                    n5 = 61;
                    break;
                }
                case 201: {
                    n5 = 148;
                    break;
                }
                case 202: {
                    n5 = 116;
                    break;
                }
                case 203: {
                    n5 = 187;
                    break;
                }
                case 204: {
                    n5 = 29;
                    break;
                }
                case 205: {
                    n5 = 74;
                    break;
                }
                case 206: {
                    n5 = 224;
                    break;
                }
                case 207: {
                    n5 = 68;
                    break;
                }
                case 208: {
                    n5 = 55;
                    break;
                }
                case 209: {
                    n5 = 11;
                    break;
                }
                case 210: {
                    n5 = 32;
                    break;
                }
                case 211: {
                    n5 = 89;
                    break;
                }
                case 212: {
                    n5 = 69;
                    break;
                }
                case 213: {
                    n5 = 76;
                    break;
                }
                case 214: {
                    n5 = 212;
                    break;
                }
                case 215: {
                    n5 = 77;
                    break;
                }
                case 216: {
                    n5 = 34;
                    break;
                }
                case 217: {
                    n5 = 66;
                    break;
                }
                case 218: {
                    n5 = 219;
                    break;
                }
                case 219: {
                    n5 = 147;
                    break;
                }
                case 220: {
                    n5 = 215;
                    break;
                }
                case 221: {
                    n5 = 243;
                    break;
                }
                case 222: {
                    n5 = 230;
                    break;
                }
                case 223: {
                    n5 = 33;
                    break;
                }
                case 224: {
                    n5 = 168;
                    break;
                }
                case 225: {
                    n5 = 47;
                    break;
                }
                case 226: {
                    n5 = 59;
                    break;
                }
                case 227: {
                    n5 = 198;
                    break;
                }
                case 228: {
                    n5 = 83;
                    break;
                }
                case 229: {
                    n5 = 128;
                    break;
                }
                case 230: {
                    n5 = 211;
                    break;
                }
                case 231: {
                    n5 = 123;
                    break;
                }
                case 232: {
                    n5 = 86;
                    break;
                }
                case 233: {
                    n5 = 5;
                    break;
                }
                case 234: {
                    n5 = 60;
                    break;
                }
                case 235: {
                    n5 = 37;
                    break;
                }
                case 236: {
                    n5 = 223;
                    break;
                }
                case 237: {
                    n5 = 233;
                    break;
                }
                case 238: {
                    n5 = 84;
                    break;
                }
                case 239: {
                    n5 = 130;
                    break;
                }
                case 240: {
                    n5 = 62;
                    break;
                }
                case 241: {
                    n5 = 121;
                    break;
                }
                case 242: {
                    n5 = 226;
                    break;
                }
                case 243: {
                    n5 = 23;
                    break;
                }
                case 244: {
                    n5 = 16;
                    break;
                }
                case 245: {
                    n5 = 194;
                    break;
                }
                case 246: {
                    n5 = 146;
                    break;
                }
                case 247: {
                    n5 = 195;
                    break;
                }
                case 248: {
                    n5 = 119;
                    break;
                }
                case 249: {
                    n5 = 39;
                    break;
                }
                case 250: {
                    n5 = 72;
                    break;
                }
                case 251: {
                    n5 = 108;
                    break;
                }
                case 252: {
                    n5 = 236;
                    break;
                }
                case 253: {
                    n5 = 228;
                    break;
                }
                case 254: {
                    n5 = 13;
                    break;
                }
                default: {
                    n5 = 186;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            OCSPClient.s[n3] = new String(cArray).intern();
        }
        return s[n3];
    }
}

