/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAKeyGenParameterSpec;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.SmartCardException;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.keytemplate.asymmetric.rsa.RSAKeyTemplate;
import tr.gov.tubitak.uekae.esya.api.smartcard.pkcs11.card.template.CardTemplate;

public class RSAPrivateKeyTemplate
extends RSAKeyTemplate
implements RSAPrivateKey {
    public RSAPrivateKeyTemplate(String label, RSAKeyGenParameterSpec spec) {
        super(label, spec);
        this.add(new CK_ATTRIBUTE(0L, 3L));
        this.add(new CK_ATTRIBUTE(2L, true));
    }

    public RSAPrivateKeyTemplate(String label, RSAPrivateCrtKey privKey, X509Certificate certificate) {
        this(label, new RSAKeyGenParameterSpec(privKey.getModulus().bitLength(), privKey.getPublicExponent()));
        this.encoded = privKey.getEncoded();
        byte[] byArray = CardTemplate.toByteArray(privKey.getModulus());
        byte[] byArray2 = CardTemplate.toByteArray(privKey.getPublicExponent());
        byte[] byArray3 = CardTemplate.toByteArray(privKey.getPrivateExponent());
        byte[] byArray4 = CardTemplate.toByteArray(privKey.getPrimeP());
        byte[] byArray5 = CardTemplate.toByteArray(privKey.getPrimeQ());
        byte[] byArray6 = CardTemplate.toByteArray(privKey.getPrimeExponentP());
        byte[] byArray7 = CardTemplate.toByteArray(privKey.getPrimeExponentQ());
        byte[] byArray8 = CardTemplate.toByteArray(privKey.getCrtCoefficient());
        this.OZET_ALICI.update(byArray);
        byte[] byArray9 = this.OZET_ALICI.digest();
        this.add(new CK_ATTRIBUTE(259L, true));
        this.add(new CK_ATTRIBUTE(354L, false));
        this.add(new CK_ATTRIBUTE(288L, byArray));
        this.add(new CK_ATTRIBUTE(290L, byArray2));
        this.add(new CK_ATTRIBUTE(291L, byArray3));
        this.add(new CK_ATTRIBUTE(292L, byArray4));
        this.add(new CK_ATTRIBUTE(293L, byArray5));
        this.add(new CK_ATTRIBUTE(294L, byArray6));
        this.add(new CK_ATTRIBUTE(295L, byArray7));
        boolean bl = RSAKeyTemplate.d;
        this.add(new CK_ATTRIBUTE(296L, byArray8));
        this.add(new CK_ATTRIBUTE(258L, byArray9));
        if (certificate != null) {
            byte[] byArray10 = certificate.getSubjectX500Principal().getEncoded();
            this.add(new CK_ATTRIBUTE(257L, byArray10));
        }
        if (bl) {
            SmartCardException.b = !SmartCardException.b;
        }
    }

    public RSAPrivateKeyTemplate getAsTokenTemplate(boolean sign, boolean encrypt) {
        this.add(new CK_ATTRIBUTE(1L, true));
        this.add(new CK_ATTRIBUTE(259L, true));
        this.add(new CK_ATTRIBUTE(354L, false));
        if (encrypt) {
            this.add(new CK_ATTRIBUTE(261L, encrypt));
        }
        if (sign) {
            this.add(new CK_ATTRIBUTE(264L, sign));
            this.add(new CK_ATTRIBUTE(265L, sign));
        }
        return this;
    }

    public RSAPrivateKeyTemplate getAsTokenTemplate(boolean sign, boolean encrypt, boolean isUnwrap) {
        this.getAsTokenTemplate(sign, encrypt);
        if (isUnwrap) {
            this.add(new CK_ATTRIBUTE(263L, isUnwrap));
        }
        return this;
    }

    public RSAPrivateKeyTemplate getAsUnwrapperTemplate() {
        return (RSAPrivateKeyTemplate)this.add(new CK_ATTRIBUTE(1L, false)).add(new CK_ATTRIBUTE(263L, true));
    }

    public RSAPrivateKeyTemplate getAsExtractableTemplate() {
        return (RSAPrivateKeyTemplate)this.add(new CK_ATTRIBUTE(1L, false)).add(new CK_ATTRIBUTE(354L, true)).add(new CK_ATTRIBUTE(259L, false));
    }

    @Override
    public BigInteger getPrivateExponent() {
        return null;
    }

    @Override
    public byte[] getEncoded() {
        return this.encoded;
    }
}

