/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.smyy.utils;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.Any;
import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.IA5String;
import com.turktrust.asn1.Null;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.SetOf;
import com.turktrust.asn1.UTCTime;
import com.turktrust.asn1.UTF8String;
import com.turktrust.cms.CommitmentTypeIndication;
import com.turktrust.cms.ContentTimeStamp;
import com.turktrust.cms.DigestAlgorithmIdentifiers;
import com.turktrust.cms.EncapsulatedContentInfo;
import com.turktrust.cms.SignedAttributes;
import com.turktrust.cms.SignedData;
import com.turktrust.cms.SignerInfo;
import com.turktrust.cms.SignerInfos;
import com.turktrust.cms.SignerLocation;
import com.turktrust.cms.X509CertificateSet;
import com.turktrust.ess.ContentHints;
import com.turktrust.ess.ContentIdentifier;
import com.turktrust.ess.ESSCertId;
import com.turktrust.ess.ESSCertIdv2;
import com.turktrust.ess.IssuerSerial;
import com.turktrust.ess.SigningCertificate;
import com.turktrust.ess.SigningCertificateV2;
import com.turktrust.ltes.OtherHashAlgAndValue;
import com.turktrust.ltes.SigPolicyQualifierInfo;
import com.turktrust.ltes.SigPolicyQualifiers;
import com.turktrust.ltes.SignaturePolicyId;
import com.turktrust.ltes.SignaturePolicyIdentifier;
import com.turktrust.pkcs7.ContentInfo;
import com.turktrust.smyy.utils.HashFabrikasi;
import com.turktrust.x509.AlgorithmIdentifier;
import com.turktrust.x509.Attribute;
import com.turktrust.x509.AttributeType;
import com.turktrust.x509.Certificate;
import com.turktrust.x509.CertificateSerialNumber;
import com.turktrust.x509.DirectoryString;
import com.turktrust.x509.GeneralName;
import com.turktrust.x509.GeneralNames;
import com.turktrust.x509.Name;
import com.turktrust.x509.Time;
import java.util.Date;
import java.util.Vector;

public class CMSFabrikasi {
    private static ObjectID idData = new ObjectID("idData", "1.2.840.113549.1.7.1");
    private static ObjectID idSignedData = new ObjectID("idSignedData", "1.2.840.113549.1.7.2");

    public static SignedAttributes signedAttributesOlustur(boolean seriImza, String hashObjectIdStr, byte[] tbsDataHash, Certificate cert, String imzaProfilOID, String policyDocHashAlgStr, byte[] policyDocHashBytes, String policyDocUrl, boolean useContentHints, String orijinalVeriMimeType, String signerCountry, String signerLocality, String commitmentTypeOID, byte[] contentIdBytes, ContentTimeStamp contentTimeStamp, Date givenSigningTime) {
        try {
            System.out.println("Policy DOC URL = " + policyDocUrl);
            Null parNull = new Null("Null_par");
            Any anyNull = new Any("Any_null");
            anyNull.setValue(parNull);
            Attribute attConType = new Attribute("attConType");
            if (!seriImza) {
                AttributeType attTypeConType = new AttributeType("attTypeConType");
                attTypeConType.setValue("1.2.840.113549.1.9.3");
                SetOf attValsConType = new SetOf("attValsConType", new ObjectID());
                attValsConType.addElement(idData);
                attConType.settype(attTypeConType);
                attConType.setvalues(attValsConType);
                attConType.commitElementUpdate();
            }
            Attribute attMesDig = new Attribute("attMesDig");
            AttributeType attTypeMesDig = new AttributeType("attTypeMesDig");
            attTypeMesDig.setValue("1.2.840.113549.1.9.4");
            SetOf attValsMesDig = new SetOf("attValsMesDig", new OctetString());
            OctetString tbsDataHashOcts = new OctetString("tbsDataHashOcts", tbsDataHash);
            attValsMesDig.addElement(tbsDataHashOcts);
            attMesDig.settype(attTypeMesDig);
            attMesDig.setvalues(attValsMesDig);
            attMesDig.commitElementUpdate();
            Attribute attSigTime = new Attribute("attSigningTime");
            AttributeType attTypeSigTime = new AttributeType("attTypeSigTime");
            attTypeSigTime.setValue("1.2.840.113549.1.9.5");
            UTCTime utcSigTime = new UTCTime("utcSigTime");
            if (givenSigningTime != null) {
                utcSigTime.setValue(givenSigningTime);
            } else {
                utcSigTime.setValue(new Date());
            }
            Time tmSigTime = new Time("tmSigTime");
            tmSigTime.setValue(utcSigTime);
            SetOf attValsSigTime = new SetOf("attValsSigTime", new Time("time"));
            attValsSigTime.addElement(tmSigTime);
            attSigTime.settype(attTypeSigTime);
            attSigTime.setvalues(attValsSigTime);
            attSigTime.commitElementUpdate();
            Attribute attSigCert = new Attribute("attSigCert");
            AttributeType attTypeSigCert = new AttributeType("attTypeSigCert");
            SetOf attValsSigCert = null;
            if (hashObjectIdStr.equals("1.3.14.3.2.26")) {
                attTypeSigCert.setValue("1.2.840.113549.1.9.16.2.12");
                attValsSigCert = new SetOf("attValsSigCert", new SigningCertificate());
            } else {
                attTypeSigCert.setValue("1.2.840.113549.1.9.16.2.47");
                attValsSigCert = new SetOf("attValsSigCert", new SigningCertificateV2());
            }
            byte[] signerCertHash = HashFabrikasi.hashAl(cert.getEncoded(), hashObjectIdStr);
            OctetString signerCertHashOcts = new OctetString("signerCertHashOcts", signerCertHash);
            com.turktrust.pkcs7.CertificateSerialNumber signerSerialNo = new com.turktrust.pkcs7.CertificateSerialNumber("signerSerial");
            signerSerialNo.setValue(cert.gettbsCertificate().getserialNumber());
            IssuerSerial issSer = new IssuerSerial("issSer");
            GeneralName gnIss = new GeneralName("gnIss");
            Name issuerClone = new Name("issuerClone");
            issuerClone.decode(cert.gettbsCertificate().getissuer().getEncoded());
            gnIss.setDirectoryName(issuerClone);
            GeneralNames issGenNames = new GeneralNames("issGenNames");
            issGenNames.addElement(gnIss);
            CertificateSerialNumber csno = new CertificateSerialNumber("csno");
            csno.decode(signerSerialNo.getEncoded());
            issSer.setIssuer(issGenNames);
            issSer.setSerialNumber(csno);
            issSer.commitElementUpdate();
            if (hashObjectIdStr.equals("1.3.14.3.2.26")) {
                ESSCertId essCertId = new ESSCertId("signerCertId");
                essCertId.setCertHash(signerCertHashOcts);
                essCertId.setIssuerSerial(issSer);
                essCertId.commitElementUpdate();
                Vector<ESSCertId> essCertIdVec = new Vector<ESSCertId>();
                essCertIdVec.addElement(essCertId);
                SigningCertificate sc = new SigningCertificate("sc");
                sc.setESSCertIds(essCertIdVec);
                sc.commitElementUpdate();
                attValsSigCert.addElement(sc);
            } else {
                ESSCertIdv2 essCertIdv2 = new ESSCertIdv2("signerCertId");
                ObjectID hashObjId = new ObjectID("Hash");
                hashObjId.setValue(hashObjectIdStr);
                AlgorithmIdentifier hashAlgId = new AlgorithmIdentifier("Hash");
                hashAlgId.setalgorithm(hashObjId);
                hashAlgId.commitElementUpdate();
                essCertIdv2.setHashAlgorithm(hashAlgId);
                essCertIdv2.setCertHash(signerCertHashOcts);
                essCertIdv2.setIssuerSerial(issSer);
                essCertIdv2.commitElementUpdate();
                Vector<ESSCertIdv2> essCertIdVec = new Vector<ESSCertIdv2>();
                essCertIdVec.addElement(essCertIdv2);
                SigningCertificateV2 sc = new SigningCertificateV2("sc");
                sc.setESSCertIds(essCertIdVec);
                sc.commitElementUpdate();
                attValsSigCert.addElement(sc);
            }
            attSigCert.settype(attTypeSigCert);
            attSigCert.setvalues(attValsSigCert);
            attSigCert.commitElementUpdate();
            Attribute attSigPolicyId = new Attribute("attSigPolicyId");
            if (imzaProfilOID != null) {
                AttributeType attTypeSigPolicyId = new AttributeType("attTypeSigPolicyId");
                attTypeSigPolicyId.setValue("1.2.840.113549.1.9.16.2.15");
                SignaturePolicyIdentifier spid = new SignaturePolicyIdentifier("spid");
                SignaturePolicyId sigPol = new SignaturePolicyId();
                ObjectID policyOID = new ObjectID("policyOID", imzaProfilOID);
                OtherHashAlgAndValue polHav = new OtherHashAlgAndValue("polHav");
                ObjectID policyDocHashObjId = new ObjectID("policyDocHashObjId");
                policyDocHashObjId.setValue(policyDocHashAlgStr);
                AlgorithmIdentifier polHashAlgId = new AlgorithmIdentifier("polHashAlgId");
                polHashAlgId.setalgorithm(policyDocHashObjId);
                polHashAlgId.commitElementUpdate();
                polHav.setHashAlgorithm(polHashAlgId);
                OctetString hashValOcts = new OctetString("hashValOcts", policyDocHashBytes);
                polHav.setHashValue(hashValOcts);
                polHav.commitElementUpdate();
                SigPolicyQualifiers spqs = new SigPolicyQualifiers("spqs");
                if (policyDocUrl != null) {
                    SigPolicyQualifierInfo spqi = new SigPolicyQualifierInfo();
                    ObjectID qualUriObjId = new ObjectID("qualUriObjId");
                    qualUriObjId.setValue("1.2.840.113549.1.9.16.5.1");
                    spqi.setSigPolicyQualifierId(qualUriObjId);
                    IA5String ia5PolicyDocUri = new IA5String("ia5PolicyDocUri");
                    ia5PolicyDocUri.setValue(policyDocUrl);
                    Any docUriAny = new Any("docUriAny", ia5PolicyDocUri);
                    spqi.setSigQualifier(docUriAny);
                    spqi.commitElementUpdate();
                    spqs.addElement(spqi);
                }
                sigPol.setSigPolicyIdentifier(policyOID);
                sigPol.setSigPolicyHash(polHav);
                if (spqs != null) {
                    sigPol.setSigPolicyQualifiers(spqs);
                }
                sigPol.commitElementUpdate();
                spid.setSignaturePolicyId(sigPol);
                SetOf attValsSigPolId = new SetOf("attValsSigPolId", new SignaturePolicyIdentifier());
                attValsSigPolId.addElement(spid);
                attSigPolicyId.settype(attTypeSigPolicyId);
                attSigPolicyId.setvalues(attValsSigPolId);
                attSigPolicyId.commitElementUpdate();
            }
            Attribute attContentHints = new Attribute("attContentHints");
            if (useContentHints) {
                AttributeType attTypeContentHints = new AttributeType("attTypeContentHints");
                attTypeContentHints.setValue("1.2.840.113549.1.9.16.2.4");
                SetOf attValsContentHints = new SetOf("attValsSigCert", new ContentHints());
                ContentHints contentHints = new ContentHints("contentHints");
                if (orijinalVeriMimeType != null) {
                    UTF8String contentDescription = new UTF8String("contentDescription");
                    contentDescription.setValue(orijinalVeriMimeType);
                    contentHints.setContentDescription(contentDescription);
                }
                contentHints.setContentType(idData);
                contentHints.commitElementUpdate();
                attValsContentHints.addElement(contentHints);
                attContentHints.settype(attTypeContentHints);
                attContentHints.setvalues(attValsContentHints);
                attContentHints.commitElementUpdate();
            }
            Attribute attSignerLocation = new Attribute("attSignerLocation");
            if (signerCountry != null || signerLocality != null) {
                AttributeType attTypeSignerLocation = new AttributeType("attTypeSignerLocation");
                attTypeSignerLocation.setValue("1.2.840.113549.1.9.16.2.17");
                SetOf attValsSignerLocation = new SetOf("attValsSignerLocation", new SignerLocation());
                SignerLocation signerLocation = new SignerLocation("signerLocation");
                if (signerCountry != null) {
                    UTF8String cstr = new UTF8String("cstr");
                    cstr.setValue(signerCountry);
                    DirectoryString cdir = new DirectoryString("cdir");
                    cdir.setValue(cstr);
                    signerLocation.setCountryName(cdir);
                }
                if (signerLocality != null) {
                    UTF8String lstr = new UTF8String("lstr");
                    lstr.setValue(signerLocality);
                    DirectoryString ldir = new DirectoryString("ldir");
                    ldir.setValue(lstr);
                    signerLocation.setLocalityName(ldir);
                }
                signerLocation.commitElementUpdate();
                attValsSignerLocation.addElement(signerLocation);
                attSignerLocation.settype(attTypeSignerLocation);
                attSignerLocation.setvalues(attValsSignerLocation);
                attSignerLocation.commitElementUpdate();
            }
            Attribute attCommitmentTypeIndication = new Attribute("attCommitmentTypeIndication");
            if (commitmentTypeOID != null) {
                AttributeType attTypeCommitmentTypeIndication = new AttributeType("attTypeCommitmentTypeIndication");
                attTypeCommitmentTypeIndication.setValue("1.2.840.113549.1.9.16.2.16");
                SetOf attValsCommitmentTypeIndication = new SetOf("attValsCommitmentTypeIndication", new CommitmentTypeIndication());
                CommitmentTypeIndication commitmentTypeIndication = new CommitmentTypeIndication("commitmentTypeIndication");
                ObjectID commitmentTypeId = new ObjectID("commitmentTypeId", commitmentTypeOID);
                commitmentTypeIndication.setCommitmentTypeId(commitmentTypeId);
                commitmentTypeIndication.commitElementUpdate();
                attValsCommitmentTypeIndication.addElement(commitmentTypeIndication);
                attCommitmentTypeIndication.settype(attTypeCommitmentTypeIndication);
                attCommitmentTypeIndication.setvalues(attValsCommitmentTypeIndication);
                attCommitmentTypeIndication.commitElementUpdate();
            }
            Attribute attContentIdentifier = new Attribute("attContentIdentifier");
            if (contentIdBytes != null) {
                AttributeType attTypeContentIdentifier = new AttributeType("attTypeContentIdentifier");
                attTypeContentIdentifier.setValue("1.2.840.113549.1.9.16.2.7");
                SetOf attValsContentIdentifier = new SetOf("attValsContentIdentifier", new ContentIdentifier());
                ContentIdentifier contentIdentifier = new ContentIdentifier();
                contentIdentifier.setValue(contentIdBytes);
                attValsContentIdentifier.addElement(contentIdentifier);
                attContentIdentifier.settype(attTypeContentIdentifier);
                attContentIdentifier.setvalues(attValsContentIdentifier);
                attContentIdentifier.commitElementUpdate();
            }
            Attribute attContentTimestamp = new Attribute("attContentTimestamp");
            if (contentTimeStamp != null) {
                AttributeType attTypeContentTimestamp = new AttributeType("attTypeContentTimestamp");
                attTypeContentTimestamp.setValue("1.2.840.113549.1.9.16.2.20");
                SetOf attValsContentTimestamp = new SetOf("attValsContentTimestamp", new ContentTimeStamp());
                attValsContentTimestamp.addElement(contentTimeStamp);
                attContentTimestamp.settype(attTypeContentTimestamp);
                attContentTimestamp.setvalues(attValsContentTimestamp);
                attContentTimestamp.commitElementUpdate();
            }
            SignedAttributes signedAttrs = new SignedAttributes("signedAttrs");
            if (!seriImza) {
                signedAttrs.addElement(attConType);
            }
            signedAttrs.addElement(attMesDig);
            signedAttrs.addElement(attSigTime);
            signedAttrs.addElement(attSigCert);
            if (imzaProfilOID != null) {
                signedAttrs.addElement(attSigPolicyId);
            }
            if (useContentHints) {
                signedAttrs.addElement(attContentHints);
            }
            if (signerCountry != null || signerLocality != null) {
                signedAttrs.addElement(attSignerLocation);
            }
            if (commitmentTypeOID != null) {
                signedAttrs.addElement(attCommitmentTypeIndication);
            }
            if (contentIdBytes != null) {
                signedAttrs.addElement(attContentIdentifier);
            }
            if (contentTimeStamp != null) {
                signedAttrs.addElement(attContentTimestamp);
            }
            return signedAttrs;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static Attribute imzadaSignedAttributeBul(SignerInfo sinfo, String attributeObjectId) {
        try {
            Vector signedAttsVec = (Vector)sinfo.getSignedAttributes().getValue();
            for (int i = 0; i < signedAttsVec.size(); ++i) {
                Attribute tempAtt = (Attribute)signedAttsVec.elementAt(i);
                AttributeType tempType = tempAtt.gettype();
                if (!((String)tempType.getValue()).equals(attributeObjectId)) continue;
                return tempAtt;
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static int countCounterSignatures(byte[] input) {
        try {
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(input);
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            SignerInfo sinfo = (SignerInfo)((Vector)sd.getSignerInfos().getValue()).elementAt(0);
            if (sinfo.getUnsignedAttributes() == null) {
                return 0;
            }
            int count = 0;
            Vector unsignedAttsVec = (Vector)sinfo.getUnsignedAttributes().getValue();
            for (int i = 0; i < unsignedAttsVec.size(); ++i) {
                Attribute tempAtt = (Attribute)unsignedAttsVec.elementAt(i);
                AttributeType tempType = tempAtt.gettype();
                if (!((String)tempType.getValue()).equals("1.2.840.113549.1.9.6")) continue;
                Any counterSigAttVal = (Any)((Vector)tempAtt.getvalues().getValue()).elementAt(0);
                SignerInfo counterSignerInfo = new SignerInfo("counterSignerInfo");
                counterSignerInfo.decode((byte[])counterSigAttVal.getValue());
                byte[] sepContentInfo = CMSFabrikasi.putCounterSigInSeparateContentInfo(counterSignerInfo, (byte[])sinfo.getSignature().getValue(), sd.getCertificates());
                count = 1 + CMSFabrikasi.countCounterSignatures(sepContentInfo);
            }
            return count;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return -1;
        }
    }

    public static byte[] putCounterSigInSeparateContentInfo(SignerInfo counterSignerInfo, byte[] signatureInputBytes, X509CertificateSet certificateSet) {
        try {
            EncapsulatedContentInfo eci = new EncapsulatedContentInfo("eci");
            ObjectID idData = new ObjectID("idData", "1.2.840.113549.1.7.1");
            eci.setEncapsulatedContentType(idData);
            OctetString tbsOctet = new OctetString("tbsOctet", signatureInputBytes);
            eci.setEncapsulatedContent(tbsOctet);
            eci.commitElementUpdate();
            SignedData sd = new SignedData("sd");
            ASN1Integer sdVersion = new ASN1Integer("sdVersion", "3");
            DigestAlgorithmIdentifiers dais = new DigestAlgorithmIdentifiers("dais");
            dais.addElement(counterSignerInfo.getDigestAlgorithm());
            SignerInfos sinfos = new SignerInfos("sinfos");
            sinfos.addElement(counterSignerInfo);
            sd.setCMSVersion(sdVersion);
            sd.setDigestAlgorithms(dais);
            sd.setEncapContentInfo(eci);
            sd.setCertificates(certificateSet);
            sd.setSignerInfos(sinfos);
            sd.commitElementUpdate();
            ContentInfo ci = new ContentInfo("ci");
            ObjectID idSignedData = new ObjectID("idSignedData", "1.2.840.113549.1.7.2");
            ci.setcontentType(idSignedData);
            Any contSignedData = new Any("contSignedData", sd);
            ci.setcontent(contSignedData);
            ci.commitElementUpdate();
            return ci.getEncoded();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static SignerInfo extractLastSignerInfoFromCMSSignedData(byte[] ciBytes) {
        try {
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(ciBytes);
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            SignerInfo sinfo = null;
            int numCounterSignatures = CMSFabrikasi.countCounterSignatures(ciBytes);
            if (numCounterSignatures > 0) {
                Vector lastSigStripped = CMSFabrikasi.removeLastCounterSignature(ciBytes);
                byte[] lastSinfoBytes = (byte[])lastSigStripped.elementAt(1);
                SignerInfo lastSinfo = new SignerInfo("lastSinfo");
                lastSinfo.decode(lastSinfoBytes);
                byte[] parentSinfoBytesForLast = (byte[])lastSigStripped.elementAt(2);
                SignerInfo parentSinfo = new SignerInfo("parentSinfo");
                parentSinfo.decode(parentSinfoBytesForLast);
                sinfo = lastSinfo;
            } else {
                sinfo = (SignerInfo)((Vector)sd.getSignerInfos().getValue()).elementAt(0);
            }
            return sinfo;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public static Vector removeLastCounterSignature(byte[] input) {
        try {
            Vector<byte[]> result = new Vector<byte[]>();
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(input);
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            SignerInfo sinfo = (SignerInfo)((Vector)sd.getSignerInfos().getValue()).elementAt(0);
            if (sinfo.getUnsignedAttributes() == null) {
                result.add(input);
                return result;
            }
            boolean foundAtleastOneCounterSignature = false;
            boolean searchComplete = false;
            int count = 0;
            Vector unsignedAttsVec = (Vector)sinfo.getUnsignedAttributes().getValue();
            int attributeIndex = -1;
            BaseASN1Object parentSignerInfo = sinfo;
            BaseASN1Object childSignerInfo = null;
            Vector<BaseASN1Object> sinfoVec = new Vector<BaseASN1Object>();
            Vector<Integer> counterIndexVec = new Vector<Integer>();
            while (!searchComplete) {
                boolean foundCounterSignatureInNode = false;
                for (int i = 0; i < unsignedAttsVec.size(); ++i) {
                    Attribute tempAtt = (Attribute)unsignedAttsVec.elementAt(i);
                    AttributeType tempType = tempAtt.gettype();
                    if (!((String)tempType.getValue()).equals("1.2.840.113549.1.9.6")) continue;
                    ++count;
                    foundAtleastOneCounterSignature = true;
                    foundCounterSignatureInNode = true;
                    attributeIndex = i;
                    Any counterSigAttVal = (Any)((Vector)tempAtt.getvalues().getValue()).elementAt(0);
                    SignerInfo counterSignerInfo = new SignerInfo("counterSignerInfo");
                    counterSignerInfo.decode((byte[])counterSigAttVal.getValue());
                    if (childSignerInfo != null) {
                        parentSignerInfo = childSignerInfo;
                    }
                    childSignerInfo = counterSignerInfo;
                    sinfoVec.add(parentSignerInfo);
                    counterIndexVec.add(new Integer(i));
                    unsignedAttsVec = (Vector)((SignerInfo)childSignerInfo).getUnsignedAttributes().getValue();
                    break;
                }
                if (foundCounterSignatureInNode) continue;
                searchComplete = true;
            }
            if (foundAtleastOneCounterSignature) {
                Vector uavecToUpdate = (Vector)((SignerInfo)parentSignerInfo).getUnsignedAttributes().getValue();
                uavecToUpdate.removeElementAt(attributeIndex);
                ((SignerInfo)parentSignerInfo).getUnsignedAttributes().setValue(uavecToUpdate);
                if (count > 1) {
                    for (int j = sinfoVec.size() - 2; j >= 0; --j) {
                        SignerInfo upperSignerInfo = (SignerInfo)sinfoVec.elementAt(j);
                        SignerInfo lowerSignerInfo = (SignerInfo)sinfoVec.elementAt(j + 1);
                        Any updatedCounterSigAttVal = new Any("updatedCounterSigAttVal", lowerSignerInfo);
                        int upperLevelAttIndex = (Integer)counterIndexVec.elementAt(j);
                        Vector upperAttributes = (Vector)upperSignerInfo.getUnsignedAttributes().getValue();
                        Attribute tbuAtt = (Attribute)upperAttributes.elementAt(upperLevelAttIndex);
                        ((Vector)tbuAtt.getvalues().getValue()).removeElementAt(0);
                        ((Vector)tbuAtt.getvalues().getValue()).add(0, updatedCounterSigAttVal);
                    }
                }
                ContentInfo cinfo = new ContentInfo("cinfo");
                ObjectID idSignedData = new ObjectID("idSignedData", "1.2.840.113549.1.7.2");
                cinfo.setcontentType(idSignedData);
                Any contSignedData = new Any("contSignedData", sd);
                cinfo.setcontent(contSignedData);
                cinfo.commitElementUpdate();
                result.add(cinfo.getEncoded());
                result.add(childSignerInfo.getEncoded());
                result.add(parentSignerInfo.getEncoded());
                return result;
            }
            result.add(input);
            return result;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }
}

