/*
 * Decompiled with CFR 0.152.
 */
package tr.gov.tubitak.uekae.esya.api.cmssignature.signature;

import com.objsys.asn1j.runtime.Asn1BerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1BerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerDecodeBuffer;
import com.objsys.asn1j.runtime.Asn1DerEncodeBuffer;
import com.objsys.asn1j.runtime.Asn1IA5String;
import com.objsys.asn1j.runtime.Asn1ObjectIdentifier;
import com.objsys.asn1j.runtime.Asn1OctetString;
import com.objsys.asn1j.runtime.Asn1Type;
import com.objsys.asn1j.runtime.Asn1UTF8String;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EATSHashIndex;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EAttribute;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ECertificateChoices;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EContentInfo;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EIssuerAndSerialNumber;
import tr.gov.tubitak.uekae.esya.api.asn.cms.EOtherHashAlgAndValue;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ERevocationInfoChoice;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESigPolicyQualifierInfo;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignaturePolicy;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignedData;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignerIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.cms.ESignerInfo;
import tr.gov.tubitak.uekae.esya.api.asn.esya.EESYAOID;
import tr.gov.tubitak.uekae.esya.api.asn.ocsp.EOCSPResponse;
import tr.gov.tubitak.uekae.esya.api.asn.pkixtsp.ETSTInfo;
import tr.gov.tubitak.uekae.esya.api.asn.profile.TurkishESigProfile;
import tr.gov.tubitak.uekae.esya.api.asn.x509.EAlgorithmIdentifier;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECRL;
import tr.gov.tubitak.uekae.esya.api.asn.x509.ECertificate;
import tr.gov.tubitak.uekae.esya.api.certificate.validation.check.certificate.CertificateStatusInfo;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CMSSignatureException;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CMSSignatureUtil;
import tr.gov.tubitak.uekae.esya.api.cmssignature.CertRevocationInfoFinder;
import tr.gov.tubitak.uekae.esya.api.cmssignature.SignableByteArray;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeOIDs;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.AttributeUtil;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.IAttribute;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.MessageDigestAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.MimeTypeAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.SignaturePolicyIdentifierAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.attribute.SignatureTimeStampAttr;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.CMSSignatureI18n;
import tr.gov.tubitak.uekae.esya.api.cmssignature.bundle.E_KEYS;
import tr.gov.tubitak.uekae.esya.api.cmssignature.provider.CMSSigProviderUtil;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.BaseSignedData;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.ESignatureType;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.SignatureParser;
import tr.gov.tubitak.uekae.esya.api.cmssignature.signature.c;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.CertificateValidationException;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.DefaultValidationParameters;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.BaseChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.Checker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.CheckerResult;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.ProfileRevocationValueMatcherChecker;
import tr.gov.tubitak.uekae.esya.api.cmssignature.validation.check.TurkishProfileAttributesChecker;
import tr.gov.tubitak.uekae.esya.api.common.ESYAException;
import tr.gov.tubitak.uekae.esya.api.common.ESYARuntimeException;
import tr.gov.tubitak.uekae.esya.api.common.OID;
import tr.gov.tubitak.uekae.esya.api.common.crypto.BaseSigner;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LE;
import tr.gov.tubitak.uekae.esya.api.common.lcns.LV;
import tr.gov.tubitak.uekae.esya.api.common.tools.Chronometer;
import tr.gov.tubitak.uekae.esya.api.common.util.bag.Pair;
import tr.gov.tubitak.uekae.esya.api.crypto.HashInfo;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.DigestAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.alg.SignatureAlg;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.ArgErrorException;
import tr.gov.tubitak.uekae.esya.api.crypto.exceptions.CryptoException;
import tr.gov.tubitak.uekae.esya.api.crypto.params.AlgorithmParams;
import tr.gov.tubitak.uekae.esya.api.crypto.util.DigestUtil;
import tr.gov.tubitak.uekae.esya.api.crypto.util.ECUtil;
import tr.gov.tubitak.uekae.esya.api.infra.mobile.IMobileSigner;
import tr.gov.tubitak.uekae.esya.api.signature.SignatureRuntimeException;
import tr.gov.tubitak.uekae.esya.api.signature.attribute.SignaturePolicyIdentifier;
import tr.gov.tubitak.uekae.esya.api.signature.attribute.TimestampInfo;
import tr.gov.tubitak.uekae.esya.api.signature.certval.ValidationInfoResolver;
import tr.gov.tubitak.uekae.esya.api.signature.certval.ValidationInfoResolverFromCertStore;
import tr.gov.tubitak.uekae.esya.api.signature.impl.TimestampInfoImp;
import tr.gov.tubitak.uekae.esya.asn.cms.SPUserNotice;
import tr.gov.tubitak.uekae.esya.asn.cms.SignerIdentifier;
import tr.gov.tubitak.uekae.esya.asn.cms.SignerInfo;
import tr.gov.tubitak.uekae.esya.asn.cms._etsi101733Values;
import tr.gov.tubitak.uekae.esya.asn.etsiqc._etsiqcValues;
import tr.gov.tubitak.uekae.esya.asn.x509.Attribute;

public abstract class Signer {
    protected EAttribute mParentCounterSignatureAttribute;
    protected Signer mParent;
    protected boolean mIsCounterSignature;
    protected int mCSIndex = -1;
    protected ESignerInfo mSignerInfo;
    protected ESignatureType mSignatureType;
    protected BaseSignedData mSignedData;
    private static final DigestAlg a;
    private static final Boolean b;
    private static final int c = 1;
    private static final Boolean d;
    static Asn1ObjectIdentifier e;
    static Asn1ObjectIdentifier f;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    public static int g;
    private static final String[] h;
    private static final String[] i;

    Signer() {
        try {
            LV.getInstance().checkLD(LV.Urunler.CMSIMZA);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(Signer.a(30849, -18567) + lE.getMessage(), (Throwable)lE);
        }
    }

    Signer(BaseSignedData baseSignedData) {
        try {
            LV.getInstance().checkLD(LV.Urunler.CMSIMZA);
        }
        catch (LE lE) {
            throw new ESYARuntimeException(Signer.a(30945, 3954) + lE.getMessage(), (Throwable)lE);
        }
        this.mSignedData = baseSignedData;
        this.mSignerInfo = new ESignerInfo(new SignerInfo());
    }

    public ESignerInfo getSignerInfo() {
        return this.mSignerInfo;
    }

    public BaseSignedData getBaseSignedData() {
        return this.mSignedData;
    }

    public ECertificate getSignerCertificate() {
        List list = this.mSignedData.getSignedData().getCertificates();
        return this.mSignerInfo.getSignerCertificate(list);
    }

    public Pair<SignatureAlg, AlgorithmParams> getSignatureAlg() throws CryptoException {
        EAlgorithmIdentifier eAlgorithmIdentifier = this.mSignerInfo.getSignatureAlgorithm();
        Pair pair = SignatureAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eAlgorithmIdentifier);
        return pair;
    }

    public HashInfo getContentHashInfo() throws ESYAException {
        List list = this.mSignerInfo.getSignedAttribute(MessageDigestAttr.OID);
        if (!list.isEmpty()) {
            EAttribute eAttribute = (EAttribute)list.get(0);
            byte[] byArray = MessageDigestAttr.toMessageDigest(eAttribute).getHash();
            DigestAlg digestAlg = DigestAlg.fromOID((int[])this.mSignerInfo.getDigestAlgorithm().getAlgorithm().value);
            return new HashInfo(digestAlg, byArray);
        }
        return null;
    }

    public void convert(ESignatureType aType, Map<String, Object> aParameters) throws CMSSignatureException {
        this.a(null, aType);
        if (this.a()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv2, new String[0]));
        }
        if (this.b()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv3, new String[0]));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (aParameters != null) {
            hashMap.putAll(aParameters);
        }
        this._convert(aType, this.mIsCounterSignature, hashMap);
        this.c();
        this.mSignatureType = aType;
    }

    private boolean a() {
        Signer signer = this.mParent;
        int n = g;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV2()) {
                return true;
            }
            signer = signer.mParent;
            if (n == 0) continue;
        }
        return false;
    }

    public Calendar getESAv2Time() throws ESYAException {
        Signer signer = this.mParent;
        Calendar calendar = null;
        int n = g;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV2()) {
                List<EAttribute> list = signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV2);
                calendar = SignatureTimeStampAttr.toTime(list.get(0));
                return calendar;
            }
            signer = signer.mParent;
            if (n == 0) continue;
        }
        return calendar;
    }

    public List<TimestampInfo> getAllTimeStamps() throws ESYAException {
        ArrayList<TimestampInfo> arrayList = new ArrayList<TimestampInfo>();
        List<TimestampInfo> list = this.a(AttributeOIDs.id_aa_ets_contentTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_escTimeStamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_signatureTimeStampToken);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_certCRLTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestampV2);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestampV3);
        this.a(list, arrayList);
        Collections.sort(arrayList, new c(this));
        return arrayList;
    }

    public List<TimestampInfo> getAllArchiveTimeStamps() throws ESYAException {
        ArrayList<TimestampInfo> arrayList = new ArrayList<TimestampInfo>();
        List<TimestampInfo> list = this.a(AttributeOIDs.id_aa_ets_archiveTimestamp);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestampV2);
        this.a(list, arrayList);
        list = this.a(AttributeOIDs.id_aa_ets_archiveTimestampV3);
        this.a(list, arrayList);
        arrayList.sort(Comparator.comparingLong(timestampInfo -> timestampInfo.getTSTInfo().getTime().getTimeInMillis()));
        return arrayList;
    }

    private void a(List<TimestampInfo> list, List<TimestampInfo> list2) {
        Iterator<TimestampInfo> iterator = list.iterator();
        int n = g;
        while (iterator.hasNext()) {
            TimestampInfo timestampInfo = iterator.next();
            list2.add(timestampInfo);
            if (n == 0) continue;
        }
    }

    private List<TimestampInfo> a(Asn1ObjectIdentifier asn1ObjectIdentifier) throws ESYAException {
        List list = this.mSignerInfo.getUnsignedAttribute(asn1ObjectIdentifier);
        int n = g;
        ArrayList<TimestampInfo> arrayList = new ArrayList<TimestampInfo>(list.size());
        for (EAttribute eAttribute : list) {
            EContentInfo eContentInfo = new EContentInfo(eAttribute.getValue(0));
            ESignedData eSignedData = new ESignedData(eContentInfo.getContent());
            ETSTInfo eTSTInfo = new ETSTInfo(eSignedData.getEncapsulatedContentInfo().getContent());
            TimestampInfoImp timestampInfoImp = new TimestampInfoImp(CMSSigProviderUtil.convertTimestampType(asn1ObjectIdentifier), eSignedData, eTSTInfo);
            arrayList.add((TimestampInfo)timestampInfoImp);
            if (n == 0) continue;
        }
        return arrayList;
    }

    public boolean _checkIfSignerIsESAV3() {
        block4: {
            List list = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV3);
            if (list == null || list.size() <= 0) break block4;
            return true;
        }
        return false;
    }

    public boolean _checkIfSignerIsESAV2() {
        block9: {
            List list;
            block8: {
                List list2 = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestamp);
                list = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV2);
                if (list2 == null || list2.size() <= 0) break block8;
                return true;
            }
            if (list == null || list.size() <= 0) break block9;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _convert(ESignatureType aType, boolean aIsCounterSignature, Map<String, Object> aParameters) throws CMSSignatureException {
        ECertificate eCertificate;
        ESignatureType eSignatureType = SignatureParser.parse(this.mSignerInfo, aIsCounterSignature);
        ArrayList<ECertificate> arrayList = new ArrayList<ECertificate>();
        arrayList.addAll(this.mSignedData.getSignedData().getCertificates());
        Object object = aParameters.get(Signer.a(30946, -10490));
        ECertificate eCertificate2 = null;
        if (object != null && object instanceof ECertificate) {
            eCertificate2 = (ECertificate)object;
            arrayList.add(eCertificate2);
        }
        if ((eCertificate = this.getSignerCertificate()) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.error(Signer.a(30873, 19341));
            }
            throw new CMSSignatureException(Signer.a(30913, 24116));
        }
        aParameters.put(Signer.a(30877, -10158), eCertificate);
        Signer signer = null;
        try {
            signer = ESignatureType.createSigner(aType, this.mSignedData, this.mSignerInfo);
        }
        catch (Exception exception) {
            if (this.logger.isDebugEnabled()) {
                this.logger.error(Signer.a(30944, 15035), (Throwable)exception);
            }
            throw new CMSSignatureException(Signer.a(30937, 14307), exception);
        }
        this.a(aIsCounterSignature, eCertificate, null, aParameters);
        signer._convert(eSignatureType, aParameters);
    }

    public boolean remove() throws CMSSignatureException {
        if (this.a()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv2, new String[0]));
        }
        if (this.b()) {
            throw new CMSSignatureException(CMSSignatureI18n.getMsg(E_KEYS.PARENT_SIGNER_ESAv3, new String[0]));
        }
        if (!this.mIsCounterSignature) {
            return this.mSignedData.removeSigner(this.mSignerInfo);
        }
        return this.mParent.removeUnSignedAttribute(this.mParentCounterSignatureAttribute);
    }

    private boolean b() throws CMSSignatureException {
        Signer signer = this.mParent;
        int n = g;
        Signer signer2 = this;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV3()) {
                List<EAttribute> list = signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV3);
                EATSHashIndex eATSHashIndex = this.a(list.get(list.size() - 1));
                List<Asn1OctetString> list2 = Arrays.asList(eATSHashIndex.getUnsignedAttrsHashIndex());
                DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eATSHashIndex.gethashIndAlgorithm());
                List list3 = signer.getSignerInfo().getUnsignedAttribute(AttributeOIDs.id_countersignature);
                for (EAttribute eAttribute : list3) {
                    try {
                        ESignerInfo eSignerInfo = new ESignerInfo(eAttribute.getValue(0));
                        if (Arrays.equals(eSignerInfo.getSignature(), signer2.getSignerInfo().getSignature())) {
                            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
                            ((Attribute)eAttribute.getObject()).encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
                            Asn1OctetString asn1OctetString = new Asn1OctetString(DigestUtil.digest((DigestAlg)digestAlg, (byte[])asn1DerEncodeBuffer.getMsgCopy()));
                            asn1DerEncodeBuffer.reset();
                            if (list2.contains(asn1OctetString)) {
                                return true;
                            }
                        }
                    }
                    catch (ESYAException eSYAException) {
                        this.logger.error(eSYAException.getMessage(), (Throwable)eSYAException);
                        throw new CMSSignatureException(Signer.a(30938, 3566), eSYAException);
                    }
                    if (n == 0) continue;
                }
            }
            signer2 = signer;
            signer = signer.mParent;
            if (n == 0) continue;
        }
        return false;
    }

    public Calendar getESAv3Time() throws ESYAException {
        Signer signer = this.mParent;
        int n = g;
        Signer signer2 = this;
        Calendar calendar = null;
        while (signer != null) {
            if (signer._checkIfSignerIsESAV3()) {
                List<EAttribute> list = signer.getUnsignedAttribute(AttributeOIDs.id_aa_ets_archiveTimestampV3);
                EATSHashIndex eATSHashIndex = this.a(list.get(list.size() - 1));
                List<Asn1OctetString> list2 = Arrays.asList(eATSHashIndex.getUnsignedAttrsHashIndex());
                DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eATSHashIndex.gethashIndAlgorithm());
                List list3 = signer.getSignerInfo().getUnsignedAttribute(AttributeOIDs.id_countersignature);
                for (EAttribute eAttribute : list3) {
                    try {
                        ESignerInfo eSignerInfo = new ESignerInfo(eAttribute.getValue(0));
                        if (Arrays.equals(eSignerInfo.getSignature(), signer2.getSignerInfo().getSignature())) {
                            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
                            ((Attribute)eAttribute.getObject()).encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
                            Asn1OctetString asn1OctetString = new Asn1OctetString(DigestUtil.digest((DigestAlg)digestAlg, (byte[])asn1DerEncodeBuffer.getMsgCopy()));
                            asn1DerEncodeBuffer.reset();
                            if (list2.contains(asn1OctetString)) {
                                int n2 = this.a(list, eAttribute);
                                calendar = SignatureTimeStampAttr.toTime(list.get(n2));
                                return calendar;
                            }
                        }
                    }
                    catch (ESYAException eSYAException) {
                        this.logger.error(eSYAException.getMessage(), (Throwable)eSYAException);
                        throw new ESYAException(Signer.a(30934, 12305), (Throwable)eSYAException);
                    }
                    if (n == 0) continue;
                }
            }
            signer2 = signer;
            signer = signer.mParent;
            if (n == 0) continue;
        }
        return calendar;
    }

    private int a(List<EAttribute> list, EAttribute eAttribute) throws CryptoException {
        int n = g;
        for (int i = 0; i < list.size() - 1; ++i) {
            EATSHashIndex eATSHashIndex = this.a(list.get(i));
            List<Asn1OctetString> list2 = Arrays.asList(eATSHashIndex.getUnsignedAttrsHashIndex());
            DigestAlg digestAlg = DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eATSHashIndex.gethashIndAlgorithm());
            Asn1DerEncodeBuffer asn1DerEncodeBuffer = new Asn1DerEncodeBuffer();
            ((Attribute)eAttribute.getObject()).encode((Asn1BerEncodeBuffer)asn1DerEncodeBuffer);
            Asn1OctetString asn1OctetString = new Asn1OctetString(DigestUtil.digest((DigestAlg)digestAlg, (byte[])asn1DerEncodeBuffer.getMsgCopy()));
            asn1DerEncodeBuffer.reset();
            if (!list2.contains(asn1OctetString)) continue;
            return i;
        }
        return list.size() - 1;
    }

    private EATSHashIndex a(EAttribute eAttribute) {
        try {
            EContentInfo eContentInfo = new EContentInfo(eAttribute.getValue(0));
            ESignedData eSignedData = new ESignedData(eContentInfo.getContent());
            EAttribute eAttribute2 = (EAttribute)eSignedData.getSignerInfo(0).getUnsignedAttribute(AttributeOIDs.id_aa_ATSHashIndex).get(0);
            return new EATSHashIndex(eAttribute2.getValue(0));
        }
        catch (ESYAException eSYAException) {
            throw new ESYARuntimeException(Signer.a(30966, 31926), (Throwable)eSYAException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addCounterSigner(ESignatureType aType, ECertificate aCer, BaseSigner aSignerInterface, List<IAttribute> aOptionalAttributes, Map<String, Object> aParameters) throws CertificateValidationException, CMSSignatureException {
        this.a(aCer, aType);
        int n = g;
        if (this.mSignedData.checkIfAnyESAv2Exist() && this.b()) {
            if (!this.logger.isDebugEnabled()) throw new CMSSignatureException(Signer.a(30963, 15249));
            this.logger.error(Signer.a(30927, -26879));
            throw new CMSSignatureException(Signer.a(30963, 15249));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (aParameters != null) {
            hashMap.putAll(aParameters);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Signer.a(30926, 19341) + aCer + Signer.a(30949, 1843));
        }
        Signer signer = null;
        SignatureAlg signatureAlg = null;
        try {
            signatureAlg = SignatureAlg.fromName((String)aSignerInterface.getSignatureAlgorithmStr());
            signer = ESignatureType.createSigner(aType, this.mSignedData);
        }
        catch (ArgErrorException argErrorException) {
            throw new CMSSignatureException(Signer.a(30858, -23288), argErrorException);
        }
        catch (Exception exception) {
            throw new CMSSignatureException(Signer.a(30914, 17409), exception);
        }
        DigestAlg digestAlg = signatureAlg.getDigestAlg();
        AlgorithmParameterSpec algorithmParameterSpec = aSignerInterface.getAlgorithmParameterSpec();
        digestAlg = CMSSignatureUtil.getDigestAlgFromParameters(digestAlg, algorithmParameterSpec);
        hashMap.put(Signer.a(30967, -50), new SignableByteArray(this.mSignerInfo.getSignature()));
        signer.a(true, aCer, aSignerInterface, aOptionalAttributes, hashMap, digestAlg);
        EAttribute eAttribute = new EAttribute(new Attribute());
        eAttribute.setType(AttributeOIDs.id_countersignature);
        eAttribute.addValue(signer.getSignerInfo().getEncoded());
        this.mSignerInfo.addUnsignedAttribute(eAttribute);
        if (digestAlg != null) {
            CMSSignatureUtil.addDigestAlgIfNotExist(this.mSignedData.getSignedData(), digestAlg.toAlgorithmIdentifier());
        }
        this.c();
        if (BaseChecker.d == 0) return;
        g = ++n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addCounterSigner(Signer signer) {
        int n = g;
        if (this.checkSignerMessageDigest(signer, this.mSignerInfo.getSignature())) {
            EAttribute eAttribute = new EAttribute(new Attribute());
            eAttribute.setType(AttributeOIDs.id_countersignature);
            eAttribute.addValue(signer.getSignerInfo().getEncoded());
            this.mSignerInfo.addUnsignedAttribute(eAttribute);
            CMSSignatureUtil.addCerIfNotExist(this.mSignedData.getSignedData(), signer.getSignerCertificate());
            EAlgorithmIdentifier eAlgorithmIdentifier = signer.getSignerInfo().getDigestAlgorithm();
            if (eAlgorithmIdentifier != null) {
                CMSSignatureUtil.addDigestAlgIfNotExist(this.mSignedData.getSignedData(), eAlgorithmIdentifier);
            }
            this.c();
            if (n == 0) return;
        }
        this.logger.error(Signer.a(30876, 8876));
    }

    public boolean checkSignerMessageDigest(Signer aSigner, byte[] aContent) {
        Object object;
        List<EAttribute> list = aSigner.getSignedAttribute(AttributeOIDs.id_messageDigest);
        if (list.isEmpty()) {
            this.logger.error(Signer.a(30848, 1107));
            return false;
        }
        EAttribute eAttribute = list.get(0);
        Asn1OctetString asn1OctetString = new Asn1OctetString();
        try {
            object = new Asn1DerDecodeBuffer(eAttribute.getValue(0));
            asn1OctetString.decode((Asn1BerDecodeBuffer)object);
        }
        catch (Exception exception) {
            this.logger.error(Signer.a(30929, -8960), (Throwable)exception);
            return false;
        }
        DigestAlg digestAlg = DigestAlg.fromOID((int[])aSigner.getSignerInfo().getDigestAlgorithm().getAlgorithm().value);
        if (digestAlg == null) {
            this.logger.error(Signer.a(30879, -23320));
            return false;
        }
        try {
            object = DigestUtil.digest((DigestAlg)digestAlg, (byte[])aContent);
        }
        catch (CryptoException cryptoException) {
            this.logger.error(Signer.a(30942, 12720), (Throwable)cryptoException);
            return false;
        }
        boolean bl = Arrays.equals(asn1OctetString.value, (byte[])object);
        if (!bl) {
            this.logger.error(Signer.a(30855, 5865));
            return false;
        }
        this.logger.error(Signer.a(30920, -6642));
        return true;
    }

    public List<Signer> getCounterSigners() throws CMSSignatureException {
        List list = this.mSignerInfo.getUnsignedAttribute(AttributeOIDs.id_countersignature);
        ArrayList<Signer> arrayList = new ArrayList<Signer>();
        int n = g;
        for (EAttribute eAttribute : list) {
            try {
                for (int i = 0; i < eAttribute.getValueCount(); ++i) {
                    ESignerInfo eSignerInfo = new ESignerInfo(eAttribute.getValue(i));
                    ESignatureType eSignatureType = SignatureParser.parse(eSignerInfo, true);
                    Signer signer = ESignatureType.createSigner(eSignatureType, this.mSignedData, eSignerInfo);
                    signer.setParent(this, eAttribute, i);
                    arrayList.add(signer);
                    if (n == 0) continue;
                    break;
                }
            }
            catch (Exception exception) {
                throw new CMSSignatureException(Signer.a(30923, 7867), exception);
            }
            if (n == 0) continue;
        }
        return arrayList;
    }

    public ESignatureType getType() {
        return this.mSignatureType;
    }

    protected void setParent(Signer aParent, EAttribute aAttr, int aIndex) {
        this.mParent = aParent;
        this.mParentCounterSignatureAttribute = aAttr;
        this.mCSIndex = aIndex;
        if (this.mParent != null) {
            this.mIsCounterSignature = true;
        }
    }

    public boolean isCounterSignature() {
        return this.mIsCounterSignature;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void a(boolean bl, ECertificate eCertificate, BaseSigner baseSigner, List<IAttribute> list, Map<String, Object> map, DigestAlg digestAlg) throws CMSSignatureException {
        Object object2;
        List<IAttribute> list2;
        HashMap<String, Object> hashMap;
        int n;
        block33: {
            block30: {
                block32: {
                    block31: {
                        n = g;
                        if (bl && this.b(list)) {
                            throw new CMSSignatureException(Signer.a(30939, 512));
                        }
                        hashMap = new HashMap<String, Object>();
                        if (map != null) {
                            hashMap.putAll(map);
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(Signer.a(30941, -11175) + digestAlg);
                        }
                        this.a(bl, eCertificate, digestAlg, hashMap);
                        DigestAlg digestAlg2 = (DigestAlg)hashMap.get(Signer.a(30951, 32154));
                        if (this.mSignatureType == ESignatureType.TYPE_EPES && !this.a(list)) {
                            throw new CMSSignatureException(Signer.a(30940, 21521));
                        }
                        list2 = this._getMandatorySignedAttributes(bl, digestAlg2);
                        this.mSignerInfo.setVersion(1);
                        if (eCertificate != null || !(baseSigner instanceof IMobileSigner)) break block30;
                        object2 = ((IMobileSigner)baseSigner).getSignerIdentifier();
                        if (object2 == null) {
                            throw new CMSSignatureException(Signer.a(30971, 3386));
                        }
                        this.mSignerInfo.setSignerIdentifier(object2);
                        DigestAlg object3 = ((IMobileSigner)baseSigner).getDigestAlg();
                        list2 = this._getMandatorySignedAttributes(bl, object3);
                        if (!object3.equals((Object)DigestAlg.SHA1)) break block31;
                        hashMap.put(Signer.a(30936, 10153), ((IMobileSigner)baseSigner).getSigningCertAttr());
                        if (n == 0) break block32;
                        int n2 = BaseChecker.d;
                        BaseChecker.d = ++n2;
                    }
                    hashMap.put(Signer.a(30925, 22472), ((IMobileSigner)baseSigner).getSigningCertAttrv2());
                }
                if (n == 0) break block33;
            }
            object2 = new ESignerIdentifier(new SignerIdentifier());
            object2.setIssuerAndSerialNumber(new EIssuerAndSerialNumber(eCertificate));
            this.mSignerInfo.setSignerIdentifier(object2);
        }
        if (list != null) {
            list2.addAll(list);
        }
        this.mSignerInfo.setDigestAlgorithm(digestAlg.toAlgorithmIdentifier());
        for (IAttribute exception : list2) {
            if (exception.isSigned()) {
                exception.setParameters(hashMap);
                exception.setValue();
                this.mSignerInfo.addSignedAttribute(exception.getAttribute());
            }
            if (n == 0) continue;
        }
        this.a(hashMap);
        object2 = null;
        try {
            SignatureAlg signatureAlg = SignatureAlg.fromName((String)baseSigner.getSignatureAlgorithmStr());
            AlgorithmParameterSpec algorithmParameterSpec = baseSigner.getAlgorithmParameterSpec();
            EAlgorithmIdentifier eAlgorithmIdentifier = signatureAlg.toAlgorithmIdentifierFromSpec(algorithmParameterSpec);
            this.mSignerInfo.setSignatureAlgorithm(eAlgorithmIdentifier);
            Chronometer chronometer = new Chronometer(Signer.a(30872, -21435));
            chronometer.start();
            byte[] byArray = this.mSignerInfo.getSignedAttributes().getEncoded();
            object2 = baseSigner.sign(byArray);
            if (eCertificate == null && baseSigner instanceof IMobileSigner) {
                eCertificate = ((IMobileSigner)baseSigner).getSigningCert();
                hashMap.put(Signer.a(30877, -10158), eCertificate);
            }
            this.logger.info(chronometer.stopSingleRun());
            this.mSignerInfo.setSignature((byte[])object2);
            ECUtil.checkDigestAlgForECCAlgorithm((ECertificate)eCertificate, (SignatureAlg)signatureAlg);
            CMSSignatureUtil.addCerIfNotExist(this.mSignedData.getSignedData(), eCertificate);
        }
        catch (ArgErrorException argErrorException) {
            throw new CMSSignatureException(Signer.a(30921, 7618), argErrorException);
        }
        catch (Exception exception) {
            throw new CMSSignatureException(Signer.a(30975, -29111) + exception.getMessage(), exception);
        }
        this._addUnsignedAttributes(hashMap);
    }

    private boolean a(List<IAttribute> list) {
        Iterator<IAttribute> iterator = list.iterator();
        int n = g;
        while (iterator.hasNext()) {
            IAttribute iAttribute = iterator.next();
            if (iAttribute instanceof SignaturePolicyIdentifierAttr) {
                return true;
            }
            if (n == 0) continue;
        }
        return false;
    }

    private boolean b(List<IAttribute> list) {
        int n = g;
        if (list != null) {
            for (IAttribute iAttribute : list) {
                if (iAttribute instanceof MimeTypeAttr) {
                    return true;
                }
                if (n == 0) continue;
            }
        }
        return false;
    }

    protected CertificateStatusInfo _validateCertificate(ECertificate aCer, Map<String, Object> aParams, Calendar aDate, boolean gelismis) throws CMSSignatureException {
        CertificateStatusInfo certificateStatusInfo;
        block8: {
            CertRevocationInfoFinder certRevocationInfoFinder = new CertRevocationInfoFinder(gelismis);
            certificateStatusInfo = certRevocationInfoFinder.validateCertificate(aCer, aParams, aDate);
            int n = g;
            List<CertRevocationInfoFinder.CertRevocationInfo> list = certRevocationInfoFinder.getCertRevRefs(certificateStatusInfo);
            aParams.put(Signer.a(30960, -18706), list);
            try {
                boolean bl = Boolean.TRUE.equals(aParams.get(Signer.a(30968, -24788)));
                if (!this.isTurkishProfile() || bl) break block8;
                ArrayList<BaseChecker> arrayList = new ArrayList<BaseChecker>();
                ProfileRevocationValueMatcherChecker profileRevocationValueMatcherChecker = new ProfileRevocationValueMatcherChecker(certificateStatusInfo, true);
                TurkishProfileAttributesChecker turkishProfileAttributesChecker = new TurkishProfileAttributesChecker(true);
                arrayList.add(profileRevocationValueMatcherChecker);
                arrayList.add(turkishProfileAttributesChecker);
                for (Checker checker : arrayList) {
                    CheckerResult checkerResult = new CheckerResult();
                    checker.setParameters(aParams);
                    boolean bl2 = checker.check(this, checkerResult);
                    if (!bl2) {
                        throw new CMSSignatureException(checkerResult.getCheckResult());
                    }
                    if (n == 0) continue;
                    break;
                }
            }
            catch (Exception exception) {
                this.logger.error(Signer.a(30851, 21365) + exception.getMessage());
                throw new SignatureRuntimeException((Throwable)exception);
            }
        }
        return certificateStatusInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(boolean bl, ECertificate eCertificate, DigestAlg digestAlg, Map<String, Object> map) {
        int n;
        block87: {
            block86: {
                block85: {
                    block84: {
                        block83: {
                            block82: {
                                block81: {
                                    block80: {
                                        block79: {
                                            block78: {
                                                block77: {
                                                    block76: {
                                                        block74: {
                                                            block75: {
                                                                n = g;
                                                                if (digestAlg != null) {
                                                                    map.put(Signer.a(30853, 23292), digestAlg);
                                                                    map.put(Signer.a(30948, 13025), digestAlg);
                                                                }
                                                                if (eCertificate != null) {
                                                                    map.put(Signer.a(30854, -1568), eCertificate);
                                                                }
                                                                map.put(Signer.a(30915, 13854), this.mSignedData.getSignedData().getEncapsulatedContentInfo().getContentType());
                                                                if (bl) break block74;
                                                                if (this.mSignedData.a() != null) break block75;
                                                                byte[] byArray = this.mSignedData.getSignedData().getEncapsulatedContentInfo().getContent();
                                                                if (byArray != null) {
                                                                    map.put(Signer.a(30957, -6010), new SignableByteArray(byArray));
                                                                }
                                                                if (n == 0) break block74;
                                                            }
                                                            map.put(Signer.a(30967, -50), this.mSignedData.a());
                                                        }
                                                        if (map.containsKey(Signer.a(30951, 32154))) break block76;
                                                        map.put(Signer.a(30951, 32154), a);
                                                        if (!this.logger.isDebugEnabled()) break block77;
                                                        this.logger.debug(Signer.a(30917, 13721) + digestAlg + Signer.a(30857, 27549));
                                                        if (n == 0) break block77;
                                                    }
                                                    if (!(map.get(Signer.a(30951, 32154)) instanceof DigestAlg)) {
                                                        map.put(Signer.a(30951, 32154), a);
                                                        this.logger.debug(Signer.a(30928, -7162) + digestAlg + Signer.a(30969, -9494));
                                                    }
                                                }
                                                if (map.containsKey(Signer.a(30956, 21408))) break block78;
                                                map.put(Signer.a(30922, -9133), b);
                                                if (!this.logger.isDebugEnabled()) break block79;
                                                this.logger.debug(Signer.a(30878, 19511));
                                                if (n == 0) break block79;
                                            }
                                            if (!(map.get(Signer.a(30922, -9133)) instanceof Boolean)) {
                                                map.put(Signer.a(30922, -9133), b);
                                                this.logger.debug(Signer.a(30952, 10532));
                                            }
                                        }
                                        if (!map.containsKey(Signer.a(30852, 6502))) {
                                            map.put(Signer.a(30964, 26502), new ValidationInfoResolverFromCertStore());
                                            if (this.logger.isDebugEnabled()) {
                                                this.logger.debug(Signer.a(30970, 9840));
                                            }
                                        }
                                        ValidationInfoResolver validationInfoResolver = (ValidationInfoResolver)map.get(Signer.a(30964, 26502));
                                        List list = (List)map.get(Signer.a(30954, -18344));
                                        List list2 = (List)map.get(Signer.a(30931, -5563));
                                        List list3 = (List)map.get(Signer.a(30933, -30376));
                                        if (list != null) {
                                            validationInfoResolver.addCertificates(list);
                                        }
                                        if (list2 != null) {
                                            validationInfoResolver.addCRLs(list2);
                                        }
                                        if (list3 != null) {
                                            validationInfoResolver.addOCSPResponses(list3);
                                        }
                                        if (map.containsKey(Signer.a(30924, 1474))) break block80;
                                        map.put(Signer.a(30932, -24182), DefaultValidationParameters.DEFAULT_TRUST_SIGNINGTIMEATTR);
                                        if (!this.logger.isDebugEnabled()) break block81;
                                        this.logger.debug(Signer.a(30930, 29224));
                                        if (n == 0) break block81;
                                    }
                                    if (!(map.get(Signer.a(30932, -24182)) instanceof Boolean)) {
                                        map.put(Signer.a(30932, -24182), DefaultValidationParameters.DEFAULT_TRUST_SIGNINGTIMEATTR);
                                        this.logger.debug(Signer.a(30912, 13414));
                                    }
                                }
                                if (map.containsKey(Signer.a(30955, 32550))) break block82;
                                map.put(Signer.a(30973, -27102), DefaultValidationParameters.DEFAULT_GRACE_PERIOD);
                                if (!this.logger.isDebugEnabled()) break block83;
                                this.logger.debug(Signer.a(30860, 10746) + DefaultValidationParameters.DEFAULT_GRACE_PERIOD + ".");
                                if (n == 0) break block83;
                            }
                            if (!(map.get(Signer.a(30973, -27102)) instanceof Long)) {
                                map.put(Signer.a(30973, -27102), DefaultValidationParameters.DEFAULT_GRACE_PERIOD);
                                this.logger.debug(Signer.a(30862, -86) + DefaultValidationParameters.DEFAULT_GRACE_PERIOD + ".");
                            }
                        }
                        if (map.containsKey(Signer.a(30874, -13718))) break block84;
                        map.put(Signer.a(30916, -11845), DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE);
                        if (!this.logger.isDebugEnabled()) break block85;
                        this.logger.debug(Signer.a(30950, -17607) + DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE + ".");
                        if (n == 0) break block85;
                    }
                    if (!(map.get(Signer.a(30916, -11845)) instanceof Long)) {
                        map.put(Signer.a(30916, -11845), DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE);
                        this.logger.debug(Signer.a(30935, -26003) + DefaultValidationParameters.DEFAULT_SIGNING_TIME_TOLERANCE + ".");
                    }
                }
                if (map.containsKey(Signer.a(30859, 27820))) break block86;
                map.put(Signer.a(30958, 9543), DefaultValidationParameters.DEFAULT_IGNORE_GRACE);
                if (!this.logger.isDebugEnabled()) break block87;
                this.logger.debug(Signer.a(30959, 25246) + DefaultValidationParameters.DEFAULT_GRACE_PERIOD + ".");
                if (n == 0) break block87;
            }
            if (!(map.get(Signer.a(30958, 9543)) instanceof Boolean)) {
                map.put(Signer.a(30958, 9543), DefaultValidationParameters.DEFAULT_IGNORE_GRACE);
                this.logger.debug(Signer.a(30856, -21066) + DefaultValidationParameters.DEFAULT_IGNORE_GRACE + ".");
            }
        }
        if (!map.containsKey(Signer.a(30863, -12144))) {
            map.put(Signer.a(30965, 3334), d);
            if (!this.logger.isDebugEnabled()) return;
            this.logger.debug(Signer.a(30953, 24807));
            if (n == 0) return;
        }
        if (map.get(Signer.a(30965, 3334)) instanceof Boolean) return;
        map.put(Signer.a(30965, 3334), d);
        this.logger.debug(Signer.a(30943, 27893));
    }

    public List<EAttribute> getSignedAttribute(Asn1ObjectIdentifier aOID) {
        return this.mSignerInfo.getSignedAttribute(aOID);
    }

    public List<EAttribute> getUnsignedAttribute(Asn1ObjectIdentifier aOID) {
        return this.mSignerInfo.getUnsignedAttribute(aOID);
    }

    public List<EAttribute> getAttribute(Asn1ObjectIdentifier aOID) {
        List list = this.mSignerInfo.getUnsignedAttribute(aOID);
        List list2 = this.mSignerInfo.getSignedAttribute(aOID);
        list.addAll(list2);
        return list;
    }

    public boolean removeUnSignedAttribute(EAttribute aAttribute) {
        boolean bl = this.mSignerInfo.removeUnSignedAttribute(aAttribute);
        this.c();
        return bl;
    }

    private void c() {
        Signer signer = this.mParent;
        EAttribute eAttribute = this.mParentCounterSignatureAttribute;
        ESignerInfo eSignerInfo = this.mSignerInfo;
        int n = g;
        while (signer != null) {
            eAttribute.setValue(this.mCSIndex, eSignerInfo.getEncoded());
            eAttribute = signer.mParentCounterSignatureAttribute;
            eSignerInfo = signer.mSignerInfo;
            signer = signer.mParent;
            if (n == 0) continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(ECertificate eCertificate, ESignatureType eSignatureType) {
        int n = g;
        try {
            block11: {
                block10: {
                    if (eSignatureType != ESignatureType.TYPE_BES && eSignatureType != ESignatureType.TYPE_EPES) break block10;
                    LV.getInstance().checkLD(LV.Urunler.CMSIMZA);
                    if (n == 0) break block11;
                }
                LV.getInstance().checkLD(LV.Urunler.CMSIMZAGELISMIS);
            }
            boolean bl = LV.getInstance().isTL(LV.Urunler.CMSIMZA);
            if (eCertificate == null) return;
            if (!bl) return;
            if (eCertificate.getSubject().getCommonNameAttribute().toLowerCase().contains(Signer.a(30918, -2995))) return;
            throw new ESYARuntimeException(Signer.a(30947, 17770));
        }
        catch (LE lE) {
            throw new ESYARuntimeException(Signer.a(30945, 3954) + lE.getMessage(), (Throwable)lE);
        }
    }

    public boolean isTurkishProfile() {
        try {
            TurkishESigProfile turkishESigProfile = this.mSignerInfo.getProfile();
            if (turkishESigProfile == null) {
                return false;
            }
        }
        catch (Exception exception) {
            this.logger.warn(Signer.a(30974, 14619), (Throwable)exception);
            return false;
        }
        return true;
    }

    protected void _addCertRevocationValuesToSignedData(List<CertRevocationInfoFinder.CertRevocationInfo> aList) throws CMSSignatureException {
        this.a(aList, this.mSignedData.getSignedData());
    }

    protected void _addCertRevocationValuesToSignedData(List<ECertificate> aCerts, List<ECRL> aCrls, List<EOCSPResponse> aOCSPResponses) throws CMSSignatureException {
        this.a(aCerts, aCrls, aOCSPResponses, this.mSignedData.getSignedData());
    }

    public List<CertRevocationInfoFinder.CertRevocationInfo> findTSCertificateRevocationValues(EAttribute aTSAttr, Map<String, Object> aParamMap) throws CMSSignatureException {
        return this.a(aTSAttr, aParamMap);
    }

    private List<CertRevocationInfoFinder.CertRevocationInfo> a(EAttribute eAttribute, Map<String, Object> map) throws CMSSignatureException {
        CertificateStatusInfo certificateStatusInfo;
        Calendar calendar = null;
        EContentInfo eContentInfo = null;
        try {
            eContentInfo = new EContentInfo(eAttribute.getValue(0));
        }
        catch (Exception exception) {
            throw new CMSSignatureException(Signer.a(30861, 20449), exception);
        }
        BaseSignedData baseSignedData = new BaseSignedData(eContentInfo);
        ECertificate eCertificate = baseSignedData.getSignerList().get(0).getSignerCertificate();
        if (eCertificate == null) {
            throw new CMSSignatureException(Signer.a(30919, 2412));
        }
        calendar = Calendar.getInstance();
        CertRevocationInfoFinder certRevocationInfoFinder = new CertRevocationInfoFinder(true);
        try {
            certificateStatusInfo = certRevocationInfoFinder.validateCertificate(eCertificate, map, calendar);
        }
        catch (CertificateValidationException certificateValidationException) {
            try {
                calendar = SignatureTimeStampAttr.toTime(eAttribute);
            }
            catch (ESYAException eSYAException) {
                this.logger.warn(Signer.a(30961, 3744), (Throwable)eSYAException);
                throw certificateValidationException;
            }
            certRevocationInfoFinder = new CertRevocationInfoFinder(true);
            certificateStatusInfo = certRevocationInfoFinder.validateCertificate(eCertificate, map, calendar);
        }
        return certRevocationInfoFinder.getCertRevRefs(certificateStatusInfo);
    }

    protected void _addTSCertRevocationValues(Map<String, Object> aParameters, Asn1ObjectIdentifier aTSOID, boolean intoTimestamp) throws CMSSignatureException {
        List list = this.mSignerInfo.getUnsignedAttribute(aTSOID);
        if (list.isEmpty()) {
            list = this.mSignerInfo.getSignedAttribute(aTSOID);
            if (list.isEmpty()) {
                throw new CMSSignatureException(Signer.a(30972, -13280) + aTSOID);
            }
        }
        this._addTSCertRevocationValues((EAttribute)list.get(list.size() - 1), aParameters, intoTimestamp);
    }

    protected void _addTSCertRevocationValues(EAttribute aTSAttr, Map<String, Object> aParamMap, boolean intoTimestamp) throws CMSSignatureException {
        block5: {
            List<CertRevocationInfoFinder.CertRevocationInfo> list;
            block4: {
                list = this.a(aTSAttr, aParamMap);
                int n = g;
                if (!intoTimestamp) break block4;
                this.b(list, aTSAttr);
                if (n == 0) break block5;
            }
            this._addCertRevocationValuesToSignedData(list);
        }
    }

    private void b(List<CertRevocationInfoFinder.CertRevocationInfo> list, EAttribute eAttribute) throws CMSSignatureException {
        EContentInfo eContentInfo = null;
        ESignedData eSignedData = null;
        try {
            eContentInfo = new EContentInfo(eAttribute.getValue(0));
            eSignedData = new ESignedData(eContentInfo.getContent());
        }
        catch (Exception exception) {
            throw new CMSSignatureException(Signer.a(30962, -29932), exception);
        }
        this.a(list, eSignedData);
        eContentInfo.setContent(eSignedData.getEncoded());
        eAttribute.setValue(0, eContentInfo.getEncoded());
    }

    private void a(List<CertRevocationInfoFinder.CertRevocationInfo> list, ESignedData eSignedData) throws CMSSignatureException {
        List<ECertificate> list2 = AttributeUtil.getCertificates(list);
        List<ECRL> list3 = AttributeUtil.getCRLs(list);
        List<EOCSPResponse> list4 = AttributeUtil.getOCSPResponses(list);
        this.a(list2, list3, list4, eSignedData);
    }

    /*
     * WARNING - void declaration
     */
    private void a(List<ECertificate> list, List<ECRL> list2, List<EOCSPResponse> list3, ESignedData eSignedData) throws CMSSignatureException {
        List<Object> list4 = new ArrayList();
        int n = g;
        if (eSignedData.getCertificateSet() != null) {
            list4 = Arrays.asList(eSignedData.getCertificateSet().getCertificates());
        }
        for (ECertificate object2 : list) {
            if (!list4.contains(object2)) {
                eSignedData.addCertificateChoices(new ECertificateChoices(object2));
            }
            if (n == 0) continue;
        }
        Object object3 = new ArrayList();
        if (eSignedData.getRevocationInfoChoices() != null) {
            object3 = eSignedData.getRevocationInfoChoices().getCRLs();
        }
        for (ECRL eCRL : list2) {
            if (!object3.contains(eCRL)) {
                eSignedData.addRevocationInfoChoice(new ERevocationInfoChoice(eCRL));
            }
            if (n == 0) continue;
        }
        ArrayList arrayList = new ArrayList();
        if (eSignedData.getRevocationInfoChoices() != null) {
            List list5 = eSignedData.getOSCPResponses();
        }
        for (EOCSPResponse eOCSPResponse : list3) {
            void var8_12;
            if (!var8_12.contains(eOCSPResponse)) {
                eSignedData.addRevocationInfoChoice(new ERevocationInfoChoice(eOCSPResponse));
            }
            if (n == 0) continue;
        }
    }

    private void a(Map<String, Object> map) throws CMSSignatureException {
        Asn1ObjectIdentifier asn1ObjectIdentifier = AttributeOIDs.id_aa_ets_contentTimestamp;
        if (this.mSignerInfo.getSignedAttribute(asn1ObjectIdentifier).size() > 0) {
            this._addTSCertRevocationValues(map, asn1ObjectIdentifier, true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignaturePolicyIdentifier getSignaturePolicy() {
        int n = g;
        if (this.getType() == ESignatureType.TYPE_BES) {
            return null;
        }
        ESignaturePolicy eSignaturePolicy = null;
        try {
            eSignaturePolicy = this.getSignerInfo().getPolicyAttr();
        }
        catch (Exception exception) {
            this.logger.warn(Signer.a(30875, -3203), (Throwable)exception);
            throw new SignatureRuntimeException();
        }
        if (eSignaturePolicy == null) {
            return null;
        }
        OID oID = new OID(eSignaturePolicy.getSignaturePolicyId().getPolicyObjectIdentifier().value);
        EOtherHashAlgAndValue eOtherHashAlgAndValue = eSignaturePolicy.getSignaturePolicyId().getHashInfo();
        SignaturePolicyIdentifier signaturePolicyIdentifier = eSignaturePolicy.getSignaturePolicyId().getPolicyQualifiers();
        String string = null;
        String string2 = null;
        SignaturePolicyIdentifier signaturePolicyIdentifier2 = signaturePolicyIdentifier;
        int n2 = ((ESigPolicyQualifierInfo[])signaturePolicyIdentifier2).length;
        int n3 = 0;
        do {
            block13: {
                ESigPolicyQualifierInfo eSigPolicyQualifierInfo;
                block14: {
                    Asn1IA5String asn1IA5String;
                    block12: {
                        if (n3 >= n2) return new SignaturePolicyIdentifier(oID, DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eOtherHashAlgAndValue.getHashAlg()), eOtherHashAlgAndValue.getHashValue(), string, string2);
                        eSigPolicyQualifierInfo = signaturePolicyIdentifier2[n3];
                        if (!Arrays.equals(eSigPolicyQualifierInfo.getObjectIdentifier().getValue(), _etsi101733Values.id_spq_ets_uri)) break block12;
                        asn1IA5String = new Asn1IA5String();
                        eSigPolicyQualifierInfo.decodeQualifier((Asn1Type)asn1IA5String);
                        string = asn1IA5String.value;
                        if (n == 0) break block13;
                    }
                    if (!Arrays.equals(eSigPolicyQualifierInfo.getObjectIdentifier().getValue(), _etsi101733Values.id_spq_ets_unotice)) break block14;
                    asn1IA5String = new SPUserNotice();
                    eSigPolicyQualifierInfo.decodeQualifier((Asn1Type)asn1IA5String);
                    string2 = ((Asn1UTF8String)asn1IA5String.explicitText.getElement()).value;
                    if (n == 0) break block13;
                }
                this.logger.warn(Signer.a(30850, -27720) + eSigPolicyQualifierInfo.getObjectIdentifier());
            }
            ++n3;
        } while (n == 0);
        return new SignaturePolicyIdentifier(oID, DigestAlg.fromAlgorithmIdentifier((EAlgorithmIdentifier)eOtherHashAlgAndValue.getHashAlg()), eOtherHashAlgAndValue.getHashValue(), string, string2);
    }

    protected abstract List<IAttribute> _getMandatorySignedAttributes(boolean var1, DigestAlg var2);

    protected abstract void _addUnsignedAttributes(Map<String, Object> var1) throws CMSSignatureException;

    protected abstract void _convert(ESignatureType var1, Map<String, Object> var2) throws CMSSignatureException;

    public abstract Calendar getTime() throws ESYAException;

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[88];
                var3_1 = 0;
                var2_2 = "\\\u00b8\u00ebe\u00fa\u007fF\u00d7;\u009e\u0087p\u00f1\u008b\u00de\u00f3Q\u00a7\u00e8\u0085\u009cg\u0087\u00e3\u0005\u00e1\u0000z$n%\b\u00e5(V\u009fr\u00bc\u00f5a\u00b7\u00b2\u0012?\u00f5\u00c4\u0081%\u0006#y\u00d5\u0099U\u00b9D1\u00b24/\u00af~\u0017\u00fbTW\u00d9\u00a3\u001bD\u00d99\u00e9\u0004q\u00a2\r\u00ea\u00c98Yu2\f\u00a0\u001a\u0017\u00a12\u00d0R\u008d\u0084\u00e6\u00f6\u00d3\u0018[%\u00e5\u009a\u000ev2\u00cdd\u00f6\u00956\u0005}k\u00bf\u00f0\u0082(r\u00b0\u00bc\u00be\u0005N\u00aaE5\u00da!\u0088=)R@|\u008a\u009e\u00d5k\u0003\u00a2\u00e0\tm\u00a0z\u0000@\u00f1\u0093O\u00f3>c\u00c5\u00b5\u00dd\u00939w\fg\u00c2\u0006\u00c4>v=\u00c8;\u009d\u0088\u00d1\u0092N:\u00ac'\u00e7\u00fd^YP{\u00a9\u009d\u00b6\u00dc\u0090\u007f\u008e\u00e4G\u00f89\f\u00f2\u00d7X\u00cd\u00de\u00bd&\u00bc)\u00ec\u00d6x\u0084I\u00e3(\u0014D\u00e2\u00feC\u00acM\u00fd[\u00d9)\u00e4\u00f3m\u001e\u0018\u00c8\u00e6j\u0013\u00bfj!\"\u00c7\u00a2\u00b2\u00d96#\\_\u00b9\u000f\u00db\u0096\u00f3m\u008a6\u00b3\u00f2\u00c0zW\u0093\u0084\u0090\u00a4\u00a4\u00bc\u00c7\u00de\u0005(\u001b\u00e4\u0014As\u00edL{\u00b9\u008b\u00170\u0007-\u0019d\u00f0\u00e9\u00e2\u00de\u0084\u00ba\u00f4)\u0099\u0098\u008e\u00d0]u\u0096\u00d9u\u00d9\u000e)u\u0019J\f#\u008dnf0Y\u00a1=\u00cd\u0018\u00e8Y\u00a7g\u00f0\u00d6\u0085\n\u00ba\u00b4\u0005\u00a6\u0012\u00f4\t\u0019[jK\u0088\u001a\u00af\u00b8\u00fa%\u001f\u0004\u0098\u00b5\u00b7\u00ff\u00d1\u001a\u0015?\u0000\u00f8\u0004\u00fc\u00d3\u00d4$\u00ad\u0014\u0087\u0007\u0010`\u0098\u00d2\u00df\u0089\u00e2\t\u00aaEDM[\u00b8\u001d\u00c6X\u00f4\u00f6\u00b5'w7\u008b\u001a\u0092\u009b3\u0017\u0018\u00e5\u00be\u0001\u0014\u00ac\u00ed\u00a8\u00ca\u00b2\u00bb\u008d\u0000\u00be\u00945Y\u00e0\u00ba\u00af\u0095\u0084(O}\u00a1\u00da(5\u0099\u00d9\u00de\u00e1\u0099\u00fc\u0098\u0001\u0010\u00fa)\u00a6\u00e4\u0007\u00f9\u001c\u00dc[\u00fa\u000f!\u00e6\u0099a\u00f0\u00a0q)Y\u0082\u00c9\u008bWl\u0016-\u0019\u00a2\u00ef\u00c5\u00fc\u00fa\u00a7\u0093\u0015\u000eH14\u00cf\u0010\u00c7\u00fb\u00dd\u00cd\u00b6\u00ea\u0013_i\u000e^\u000e9\u00c9\u00f1V\u00dd,\u00fbF\u0011Z\u0099:\u008e\u0096hU\u008d\u00bc\u0089]\u009b\u00f8\u00c5J\u0096\u0006Q\u00cde/\u000e\u00d3\u00ce\u0089\u0004\u009a+\u00ff\u00c74\u00f19\u0013\u00c9v\t\u00dc\u0013\u00a3\u00e9\u00a9\u0003\u0004S\u0091!\u00eb\u0082QW\u001c^\b1[`\u00df\u0093I\u00a8\u00a0\u0082\u00b7\u009doM\u00f0\u00c7\u00d6\u0010\u00cb\u008d\u008a6\u00ec\u0084\u00d9+\u00a2AU\u00ea\"\u00e4\u008e\u00b75.\u00dd\u009c\u008d\u00b1\u00b8\u00a8\u00e3p\u00cc\u00ba\u0011\u00bb\u001a\u00e5 \u008f\r\u00ba?\u00e7@1\u00e7M\u00e8.gm\u00a08\u00ff\u00a6S\u00ea\u00c0x\u008b\u001f,\u00982\t\u00e7g\u00f5\u00dc\u00aa\u00de\u00a1\u0099P\u00ec\u0005\u009bs\u00eeT\u008bQ\u0011\u00b3j\u0082\u00acw\u008e\u00ca\u0090\u0086\u00132@s\u00a0\u00c3\u00e2}\u0089\u001b\u0081\u00e7\u00c2\u00db\u009a]\u00d2H\u0081\u00aa\u008a\u0019U\u00197\u00fei\u0080O\u00f3(\u00e8v\u00ec\u00a7r\u00b7\u00f7\u00f9\u00ce\u001d\u0096\u00ba:\u00a9\u00e1\u008c\u00d1Ki\u00b0\u00a3\u00bc\u0080\u00b4O\u00a3M=\u008eq\u00e9\u001aj\u00eeL\u00aey%\u00e31k\u00b0\u0094\u00c6\u00c8~\u0011\u00f5\u0080\u008e\u00c5\u00a8\u00050\u00bc<\u000bV\u00d8\u0018\u00b3\u00a3\u00cc8\u009d=(w\u000f\u001b\u00b3S\u00c4J\u00d3\u00ce\u0000\u0090 \u00d7wD\u0015\u0087!f\u0090\u00fe\u00f63\u00a9\u00ee\u008a)\u00ca\u00c7mN\u0089\u0086\u00ed\u00be_\u00e3]T\u00f8\u00c3\u00e2\u008b\u00e7\u0090\u008b\u00cf\u0080<2Ao\u00acW\u00bc\u0000\r\u00b8\u00ee\u00ac+\u009c\u00fb`\u001aQ\u00fc\u00f3\u0003\u0019\u00b9\u0082B\u00c7\u00da)IJ+9\u00027K\u001f\u00ea\\4\u00ce\u00ad\u00f0\u0086\u0005`\u00da:\u00bd\u008b\u00fc~\u0011l\u00d2\u00b5\u0089\u00fb\u009ed\u00e2K\u00b8\u007fX<'E\u008b\u0016t\\\u00e5\u008b^j\u001c\u0095\u000f\u00dd\u00ce\u00cc;d{((a?\u00bb\u00ac\u00c84\u00ae`5p\u0001\f\u0098\r\u00dc\u000boN\u00a1?\u00f04\n\u00f8j\u00fclQ&\u0013R\u0085\u00c4\u008e*\u00f4\u00b6\u009d\u00f4\u00fc\u0087wG@7\u00a5\u00e2\u008a\u0093\u001a\u0019\u00d7X\u00cf\u00af\u00b0\u00d5\u00c37$\u00b4A/\u001e\u00c2\u0090\u00e6E\u00bc\u00be\u00a0\u00a62\u00dd\u00ce\u00ae>\u00d2q\u00d78}\u00d2<J\u00da2\u00feA=\u00cc\u00d7 \u00e7\u0093\b\u00f6k\u0015\u00b0(4\u00d6Uu\u00c6\u0002n|\u00e3\u00e7\u00ff8\u00bb\u00c8\u00bfk\u00e7\u001d\nkR\u0099\u0082\u0096\u00d8zp\u00ec\u00ac\u001d\u0091@gPA]\u007f\u00bb\u000e?\u0090\u00d1\u00f7Y\u00b5\u00cc\u00b3\u00dbe\u00e2\u0000\u00a3\u0085]\u00c8f25\u0087u\u0095RQ\u0092K6\u0017\u00c1_\u0085(<j\u00ba:\u00f0\u00a5\u00c5\u00c3\u00b7\u00ec\u0014V\u00c4[+\u00a9\u0014\u00aeO\u00df\u00bf\u00afj\u00cf\n\"F\u0088O\u0006\u007f-\"u\u000eV\u00e7\u00e6<\u00a0bz\u00f8c\n_\u00a5\u00abw\u00a3\u0083?X\u00ee@]\u00ae\u00dc\u00c1\u00ab\u00d3L;\u00f8l\u00ee\u00aa\u00c9p\u00c6\u00f5\u00d7\u00e0\n\u0002\u001c'@\"sq\u00cag~'\u00e0r\u00b9x\u00d5\u00e9\u008b\u00fe\u0019OH\u0089z\u0096\u00b8\u00b2i?y\u00fe\u0017)\u008647_\u00a3\u00d7q8\u00bd0\u0012Dof\u00f9\u00fc-\u00ad\u009d>n\u00f9\u00fc\f\u008e\u00ca\b\u00ff-\u00f8\u0093\u00ab\u00f9\u008fe\u00b7\u0018i\u00b1\u00f7\u00bfiT\u00e1\u0001\u00b0#Y-\u0097o\u00d9\u00f4\u00aa\u00e6\u00c0\u00a5\u00d0gW\u00c3t\"y\u0081k\u0099]\u00b0\u00f6\u00fe\u0098]\u0016\u0080~t\u008b\u00ed-\u00c4\\\u0011\u00d8D\u0002\u00f8'\u000f\u00ef\u0018~\u00bc\u00d9\u00f6\u00a8h/\u00fc\u00d2\u00bc\u0095\u00d8f~$2\u00a8\b\u0097m\u00a8\u00eb\u00a1\u00e2\u0086\u0086YG\u0088%\u0088Z\u000b'J\u001c\u00c0\u0001eBnK8\u00bdrh\u0099m \u00cb\u00cd\u009f\u00971_\u00d0\u00ea\u00cffKc\u00cf2\u00bdd8\u007f\u0080DD\u0018H\u0000-\u00ba\u00e9S\u0007\u00f7=q\u00f8L\u00fcH\tz\u00d0&\u00f5\u0087\u0007\u00ff\u00d0\u00ddU\u00a2B\u00aa\u00ee\u00ec0GU1$\u008cp\u00b2Qc\u008e%\u00f6r\u00e6z\u008b\u00e2p/\u00fe\u0015\u00137upW\u00de\u00b0}\u001e\u0095a\u0082\u00f9)\u0082\u0000L:\u0015\u0096\u001b\u0018\u00e7\u00ac\u00cap:E\u00a0\u00adV\u00a6_i\u0086\u0098,uQ\u00fa\u00dd\u00b1aY\u0080d\u0017\u008a\u0095zK\u008e\u00ba\u00b4\u00abu\u00ad\u00cf\u00d1\u0087=M\u001aj\u00cf\"\u00c43?\u0084\u000em\u00f2\u0095\u00a7\u00167 \b\u00d7\u00d5\u00edTr`\u0016\u00e7s\u00ca\u008b::\u00a0BV[S\u00d0\u008bm\u00ba[[\u00b9\u0000\u00d0\u00e2\rs\u0088u8D\u009d0\u00fc\u00bdi\u00be\u00b3$\u0013\u00d9\u00dd\u00e2';=\u00c6\u00d2O\u00c88\u000bhc}\u000b\u00bfj\u000e\u00ce~\u00b0\u008a=x\u0094\u0014\"\u00f8r\u00f9\u0082uMR\u0014\u009b;\u00f4\u00f1\u0095\u00cf\u0095\u00fb\u0081T\f\u0097\u00a7S\u0089h\u00a0\u001e\u00ab\u008b\u009bj<\u00f0\u00b4\u00d5\u00b7\u0089\u00ffzm\u00e9\u009f6\u0004\u00e7\u00e3%\u0097\u00e3O(\u00cd\u0096\u00e2\u00e3\u00f0-\u00f7\u0098Va\u00b1\b\u00ef\u00a6\u008e4\u00bfCY\u00b5#\u0012\u008eTh\u007f0\u00c6\u00ecB%\u0007\u001f\u0016\u00ea\\\u00b9\u00e2\u0080\u007f/R\u00d3\u00cd\u00c3\b\u00ce\u00eeS3l\\\u009f\u00f2\u00da\u00c5\u00b9\u008c\u0081\u00b9c~\u00ee\u000f\u00d2u\u00b8eQ=\u0099eB6\u0097\u00be\u00ba\u00a2K:\u00f58S\u00dd({\u00ae\u00f1\u00c5\u00de\u00c4y\u0087+\u00136)\u0098\u0012\u0083d\u00f3\u00e38\u0098\u009b\u0018\u00e5rc\u00f4m\u0004\u00c2\u0084\u00be\u0094P=H\u00e3\u00a3\u00f3`\u00b8\u00f6);rE\u0013\u00a3Z\u008d\u00efr\u001f\u00a00\u00c0\u0011\u00f6\u00ed4\u00a1TT\u0099\u00ec\u00fa{q\u00ad\u0083Co\u00a7G\u001d\u00cdQ\u0004\u00e9Y\u009aX\u00a5s\u00a5\u0007{\u0090\u009a\u009b\u001a\u00d8\u0014e\u00a2m\u0016\u00fc`$\u009c\u00ee^\u0097hH\u0010\u00f5\u00a2eS`\u00fb\r=\u000e8\u00a21\u00b8BoS\u0094C\u001d\u0091\u0007\u00f1\u0002\tx\u00ee39IM%\u00a3s%b\u00a1e\u00de6c\u0089\u00d7\u00c7\u00f3f\u009a\u00a5\u00e4\u0097\u00a3OBn\u00f1|\u0088`\u009b\u00e2uf\u00bc\u00b5\u00be-5\u0091\u0010\u001aQ\nn\u0007m\u00c2\u0010\u00a1\u00df\u00e9I\u00cb\u00b1'\u00f5\u00c1M4\u008a!o\u000f\u00cf\u00e9R\u00ba\u00bf\u0003\u009eZ\u00a5\u0094\u00bb\u00da\u00a4[\u00e2\u007f\u0007\u00a2\u0092\u00f5%\u008c+v\u00b6\u00beU\u00b0\u00fb\u00fd\u009e\u00f9\u007f\u00c9\u00cc\u00ed\u00cc6\u009az\u0007d\u008e\u0080\u00d8]\t7T.G\u00d6;\u00c0\u00a2G\u009cI\u009a\u0015U>\u0002\u0015\u00ea\u00f8xX\u00ff\u00ee\u00c9\u00b1n\u001d&\u0094n\u00acA\u00ad\u008f\u00d1\u0093\u00cd\u00bf\u00eb@\u00da\b?c\u001e\u0012Wx\u0019\u00fc\u00ad\u00dd\u008c\u008c\u007f\u00b83r\u00d6\u00faR\u00b3r\u00e4:\u00a3\u00a4\u00a3\u00e0\u00f3\u007f+\u0000\u0080B\u001bx\u0083\u009cJ\u00aa\u00ef\u0018\u0011&o-v\u00a8Px\u00a5\u0093\u00eeei\r\u0093\u0080zho\u0080\u0018\u0010\u00d0y/\u008b\u00acVP\u00e1N\u0000OO\u0085\u00eb\u009fVF\u00d6:I`o\u00b7\u0016]4\u0086h\u00c4=\u008a\u0095i9\u00f0\u0019/\u0010\u00f4IG\u008f\u00c4\u00f6\u00aejm\u00a3Q_\u00ce3\u00a2?b\u00c5E&\\\u00a1;\u0080\u00ef\u00fc\u00c5\r\u00db\u0092r\u0019\u00d0\u0093\u00bd\u00bfX\u009c\u001f\u0014\u0099*\u007fg<\u00c7\u00ae\u00cb\u00ce\u00c9\u00a3\u000f\u0092-\u0018\u00b8\u00ff\u00aa.\u00ecB\u000bC\u0090O\u0010\u00da)g8\u00ca\u00a6$\u00d6\u0015\u00cb\u0013sOc+\u0005Vk\u00ec^y\u008b\u00ec\u00a7\u00f0\u00b4+\u00f1\u0098>\u00b7\"\u0083\u00df\u00cbd&1\u00eb\\g\u00fd\u00d2\u00cd!\u009d\u00fd\u0014\u00ccb\u00f7\u0089\u001aA\u00ceH\u00deE\u00b6N\u008d$\u00d5\u0095Xj\u00ecZ\u007f\u0087l\u00f1\u00cf!.\u0014\u00cas\u00c2\u0016H\u00ed$S\u0090Z\u0000y8\u00a4\u00da\u00aajf\\\u0087RVf\u00cd\u00fa\r\u00197\u00b9E\u00c3\u00a0\u0084RC\u001a\u00ec\r\u00fb\u00f1\u0094\u00e1\u00ed5x\u00ce\u00df\u00e0\u00f3\u00dd3pp\u00d4\u00fe\u00b35\u00ec\u001e\u00d2x\u00ac\n\u001b%\u0002\u00a4 \u00dc\u00e9U\u0083\u00c3\u00f5@\u00a5\u00dd+?0A\u00d9J2\u0007$\u00cc\u00e6\u008b[\u0001#\u000e\u008fD\u00bcD;\u00d6D\u00ab\u00de\u00b2\u00bbP?\u00fe\u0010\u00f6\u0084\r\u00f0Np\u00d4\u00e5\u009c\u00f6#\u00eb\u00e5(tS\u0018\u00a8w\u00f9\u0007\u0005\u00fe\u0004u\u00d1\u0005\u00f3\u00afA\u00c2\u00b0(\u00d2\u00cb\u001c\u0004\u00f1\u0005v\u008e>H\u00e3\u001e\u00b0V\u0001\\\u00dcP{\u0087\u00af\u009b\u00c2r\u000e\u00d6\n\u00b2\u00ab4,\u00cb^\u0019Rk\u00be\u008c\u00fe\u0011I\u0088\u0006\u00fb\u0094\u00cb\u00c3Q|\u00f2\u00ee:\u00abZ\u00d3\u00a9\u00e5\u0019\u00f8ih~eF\u00b8\u0095/\b\u00a9\u0005\u000f;1m\u00d3\u00ffJMe\u00fe\u00e1w\u0088\u0011\u00c7\u0094\u0012\u00ae]\u0080F\tDN\u00f3s\u00ab\u00fe\u00c5_L\u000e\u00ec\u0014\u00a5{\u0010\u00ac\u00e0{\u00cf\u00bb\u00ee\u0099\u0012\u00d9\u001fN\u0094{\u00ac\u0096\u00b0`\u001b_\u00a6\u00ee\u00d5\u00c8\u0085j\u00ad#}\u008c\u00a8\u0003/\n\u00f0m\u008e\u0091rJz\u0080N\u00c4\u00cb\u00f8\u000b\u0098\u00b2\nn\u00b4\u00a8\u00a0\u0097\u0005v\u0018w\u00ccn\u00c4\u00bc\u0019@7\u0007\u0017{\u0093\u00ee\u00a5\u00c0\u00b6\u00c1\u00b3\u001d\u00f4\u00a6\u00b5]\u00f5A\"\u00d6\u00aa S\u0098\u00ee\u00fc\u00bf\u001c\u0083\u00eb\u0015\u001d\u00d0\u00ba\u00b8\u00b1\u008cf2>\u00c5\u00a8\u00fe\u00f1C5\u00fe\u00c2\u000eK\u0014?\u0084\u00d0E\u001e\u0016\u00b3L\u00c4\u00b7a\u00d3\u009ew\u0080+\u0015n\u00b1\u00a5\u00c7=\u0015\u0014\u00be\u00a1J\u00e0\u0011\u00c0?\u00f2\u00dbA.\u00c5\u00dc4\u00f4\u00fd$j\u0014\u00fd\u0002K\u001d\u0017\u00ab\u00de\u009b\u00e8R\u0082H\u0017\u00e1\u00dc\t/n\u00c0Rs\u00f7\u00fb\u0081\u00ce\u008a&Z\"\u00ca!\u0001\u008a\t\u00c1F\u0004,\u00af\u00ef\u00f9\u00f7\u00e8,f`v@\u00ca2\u00dc\u0090\u0005>\u009eL\u00e5\u0006\u00d9\u0013\u008d\u00e9\u00d8&?\u000e\u00b73\u009c\u00c5\u001dS\t\b\u00e2>\u00d0\u00cf=u\u0099\u00b2\u00a4\u008fR\u000e\u008a\u0011\"\u0012mkG\u00f7P\u00b1\u00b1\u00c0?\u0086\u0014\u00b5\u00df\t\"\u00bd#n\u00c5\u00b8/\u00854\u00a2\u00e9VM\u00ad\u00b9\u00be\u00ceTf\u001a\u00b6#\u00ff\u008eei\u00e3\u0096\u008a\u00d7\u00df\u009e\u009a\u00d332\u008b\u0088\u00cfx|7\u00943\r\u00e2\u000e\u00804&j\u00a05\u000f\u00df\u00c8t\u00e0*\u00df\u00a7 9\u00d5\\\u008f+\u00be\u0093\u00c5\u00a2\u0081\u00e32\u00ce\u0006\u00baE:\u009b\u009a\u00ae4\u0018\u008cU\u00c57\u0082\u00b9\u00800\u00e1\u00f5\u000e\u0084\u00de\u00f81}\u007f\u00e24<\u001f\u00cf\u0017\u0018\u00cbHsp\u00c1\u00bd\u00a9\nPA\u00f3\u00feOu\u00a4\u0083I\u00b4\u00eagLXL\f\u00a2\u00a8g\u000e\\\u00bb\u00bd\u0091{y`\u00a1\u00af\u00c4\u00cdK\u00f4\u00c6\u0085\u00d9K\u00df\u00e0?s\u00d4:\u0097\u00da\u00f9\u00a4\u00a0\u00ef\u009d\u00cd;r#(\u00f7O3\u00e3-\"\u00865\u0090w\u00a6\"6\u0002\u00ef\u00aag\u00ed\u00a3\u0006\u0082\u00c9\u00ce\u00ca\u00bc\u0004(Y\u0099L\u00ea((\u0092\u0097\u0083\u00e0\u001f\u001e\u0093\u00a4b\u009f\u00b5p\tHL\u0083&\u00c3U\u00c5\u00cf\u00b8\u000e\u00d40\u008b\u00b2\u00cbq\u00e6\u0003g}P\u00e7,\u00d7\u00ac\u00c9\u008e\u0089\u00ab\u0007\u0093,9\u008a\u00a9\u00f2\u00c5fk\u0081\u00c2+Y\u009e\u00cfZ=$\u0094\u00d0\u0091\u0092\u00f9\u0016Y.X\u00aemT\u00e5\u00e4\u00a2\u00f7\u0099\u00f4x\u00c0,i\u00c5\u00fc\fL\u00c1\u001b\u0082/T\u00df\u0017&m\u009b\u00cf\u00908\u0084ta\u00e7\u00c3\u00bf\u00c1\u00f8\f0[\u00a4\u00b2\u0098\u00bb\n\u00e6)TN\u00a1\u00ba\u00d2\u00aeB*\u001f\u009cP\u00b41/\u0014f?yU\u009b'&\u0087\u00df\u00a4 \u00b0\u0087\u00d2Y\u00b9\u00c18|\u0080A\u001b\u00ea\u0001\u001f\u00e2\u0094\u00e9\u001e\u00d9E\u00fc_\u00a7\u0012P\u0081\u00e8\u00de\u00ce\u000f\u00ce\u000f\u0016\u000b\u00de\u00b3\u00bbe\u0011e\u00c4\u0082Z\u00fd\u00bd\u00a0x\u00be\u00e6\u00f2.\u00e3\u0006\u00a5g\u00c7\u001a\u0080Ry\u0085_Eb\u00e1\u00e7k\u0082M\u0091\u00ebc\u00df\u00d7k\u0090\u00a0X\u00b7\u00b1\u00eb\u00ca\u00dd\u0082\u00bc\u009c\u0006\u0092\u0082$\u00f5\u00e7\u0004\u00b0\u0084,\u0015S<F\u00b9C\u0010\u00e3L6)\u00fc\u00f3#$\u00ddivs\u00f9K\u00a4o\u00d7\u0001\u00c0\u0011\u00a8,f\u001b\no\u00f0?=\u00ab\u0085V\r\u00a4\u00ac5\u008fUD\u00e3\u00fc]b\u0017\u0005U\u0001\u00b9\u00d6{F\u001b\u008e\u0092Bhq\u00abc\u0099I~\u00c0T\u0015\u0014\u00cf-e\u00ff\u00bbK\u00d6\u00d7\u00fb\u00f2\u0007~m-\u00855\u00cb\u0093\u00dd;\u009c\u00a5\u00b6\u001c8 \u00ec\u0081\u00d0\u00fc\u00ad\u00c5\u00ec\b\u00cb?Vqo\u0018\u000f\u00e5\u00d0\u007fr\u007f%\u008f\u00d7V\u000f\u00bf\u00c75\u00f36\u00d5\u00f2!\u001a\u00d5l4\u00b34Sui\u008cb\u0088\u00a4\u00a6)\u0004\u00e3s\u001d\u009cQ!\n1\f\u00ff|\u0015&K\u00e8\u008b)\u00c7\r\u00ab\u00e8\u0088\u00ee\u00aa<\"L\u00b2\u0085\u0084\u00dbw\u0099\u0012\u0000*;\u00a7\u00a6I\u00e6\n\u00d4\u00fb}\u001b\u00bdP\u00c2(U\u0089\u001a\u00f4\u00d3\u00b7\u0090l\u00aa\u00c2\u00ee\u00ae\u00d8[\u007f\n\u00ef!\u00b5\u00c9x\u0087fu\u00f4\u00b5K)\u00ed\u001b\u00c43rZQ\u001e\u00c7\u00dat4\u00f5,O3\u00c4X\u00e3>\u00dc\u0088m\u0003}0\u0014\\\u00b6\"=)\u008c\u00c1ICp^,\u00c2\u001b\u00ac\u0006%t,b\u00bd\u00de\u00d4\u00e8\u0093V\u00ecz:\u0082\u00a8;\u0001\u00e0Z\u00b4\u0007\"B}3\u009a\u00c2\u001a\u007f\u0086\u00c0\u0088\u00ba\u000eS\"9\u000fy\u00d6\u00bf\u00e8|\u00e6\u00c25\u0090N\u0012F\u00d6\t\u00b4\u00e10\u001b\u000b\u0087i\u008b\u0018\u00d5J\u0093\u009c\u009e\u00cc\u00e6\u0018\u00f9\u00f4D\u00ab,<\u00a2@r\u0007\u00dfS\u0088\u00ec\u00a7d\u0094&\u0092\u00ecQn\u0090\u0004l\u001f\u0000\u00ca\u00ea\u00c3\u00e57\u0007\u0010\u00e9\u009c\u00d9\u00fa\u008c|\u00ae2\u00e3\u00c1\u00c5\u0089\u000e\u00deK5o\u009c\u00ff\u00ea\u00d6\u00c68\u00ec\u00b1\u00b5e\u00ff.?\u00cas\u00bb\u00a51%\u0095f\u00c3W\u00b5\u00e0\u00e0H\u00813w\u00bd\u00e9{\u00bax\u00c1\u00e2\u00f5\u008c\u00f4i\u00ab;\u00e2@g\u00b1\u00de\u00b5f\u0003~\u00d4T\u00c85\u00a9\u00a9,\u001a\u00ae\u00e3\u00da0\u00b1\u0019}\u009a\u0098\u0087b\u00b4\u008b\u00f6f\u0080\b \u0010\u00bf\u00c3\u001d";
                var4_3 = "\\\u00b8\u00ebe\u00fa\u007fF\u00d7;\u009e\u0087p\u00f1\u008b\u00de\u00f3Q\u00a7\u00e8\u0085\u009cg\u0087\u00e3\u0005\u00e1\u0000z$n%\b\u00e5(V\u009fr\u00bc\u00f5a\u00b7\u00b2\u0012?\u00f5\u00c4\u0081%\u0006#y\u00d5\u0099U\u00b9D1\u00b24/\u00af~\u0017\u00fbTW\u00d9\u00a3\u001bD\u00d99\u00e9\u0004q\u00a2\r\u00ea\u00c98Yu2\f\u00a0\u001a\u0017\u00a12\u00d0R\u008d\u0084\u00e6\u00f6\u00d3\u0018[%\u00e5\u009a\u000ev2\u00cdd\u00f6\u00956\u0005}k\u00bf\u00f0\u0082(r\u00b0\u00bc\u00be\u0005N\u00aaE5\u00da!\u0088=)R@|\u008a\u009e\u00d5k\u0003\u00a2\u00e0\tm\u00a0z\u0000@\u00f1\u0093O\u00f3>c\u00c5\u00b5\u00dd\u00939w\fg\u00c2\u0006\u00c4>v=\u00c8;\u009d\u0088\u00d1\u0092N:\u00ac'\u00e7\u00fd^YP{\u00a9\u009d\u00b6\u00dc\u0090\u007f\u008e\u00e4G\u00f89\f\u00f2\u00d7X\u00cd\u00de\u00bd&\u00bc)\u00ec\u00d6x\u0084I\u00e3(\u0014D\u00e2\u00feC\u00acM\u00fd[\u00d9)\u00e4\u00f3m\u001e\u0018\u00c8\u00e6j\u0013\u00bfj!\"\u00c7\u00a2\u00b2\u00d96#\\_\u00b9\u000f\u00db\u0096\u00f3m\u008a6\u00b3\u00f2\u00c0zW\u0093\u0084\u0090\u00a4\u00a4\u00bc\u00c7\u00de\u0005(\u001b\u00e4\u0014As\u00edL{\u00b9\u008b\u00170\u0007-\u0019d\u00f0\u00e9\u00e2\u00de\u0084\u00ba\u00f4)\u0099\u0098\u008e\u00d0]u\u0096\u00d9u\u00d9\u000e)u\u0019J\f#\u008dnf0Y\u00a1=\u00cd\u0018\u00e8Y\u00a7g\u00f0\u00d6\u0085\n\u00ba\u00b4\u0005\u00a6\u0012\u00f4\t\u0019[jK\u0088\u001a\u00af\u00b8\u00fa%\u001f\u0004\u0098\u00b5\u00b7\u00ff\u00d1\u001a\u0015?\u0000\u00f8\u0004\u00fc\u00d3\u00d4$\u00ad\u0014\u0087\u0007\u0010`\u0098\u00d2\u00df\u0089\u00e2\t\u00aaEDM[\u00b8\u001d\u00c6X\u00f4\u00f6\u00b5'w7\u008b\u001a\u0092\u009b3\u0017\u0018\u00e5\u00be\u0001\u0014\u00ac\u00ed\u00a8\u00ca\u00b2\u00bb\u008d\u0000\u00be\u00945Y\u00e0\u00ba\u00af\u0095\u0084(O}\u00a1\u00da(5\u0099\u00d9\u00de\u00e1\u0099\u00fc\u0098\u0001\u0010\u00fa)\u00a6\u00e4\u0007\u00f9\u001c\u00dc[\u00fa\u000f!\u00e6\u0099a\u00f0\u00a0q)Y\u0082\u00c9\u008bWl\u0016-\u0019\u00a2\u00ef\u00c5\u00fc\u00fa\u00a7\u0093\u0015\u000eH14\u00cf\u0010\u00c7\u00fb\u00dd\u00cd\u00b6\u00ea\u0013_i\u000e^\u000e9\u00c9\u00f1V\u00dd,\u00fbF\u0011Z\u0099:\u008e\u0096hU\u008d\u00bc\u0089]\u009b\u00f8\u00c5J\u0096\u0006Q\u00cde/\u000e\u00d3\u00ce\u0089\u0004\u009a+\u00ff\u00c74\u00f19\u0013\u00c9v\t\u00dc\u0013\u00a3\u00e9\u00a9\u0003\u0004S\u0091!\u00eb\u0082QW\u001c^\b1[`\u00df\u0093I\u00a8\u00a0\u0082\u00b7\u009doM\u00f0\u00c7\u00d6\u0010\u00cb\u008d\u008a6\u00ec\u0084\u00d9+\u00a2AU\u00ea\"\u00e4\u008e\u00b75.\u00dd\u009c\u008d\u00b1\u00b8\u00a8\u00e3p\u00cc\u00ba\u0011\u00bb\u001a\u00e5 \u008f\r\u00ba?\u00e7@1\u00e7M\u00e8.gm\u00a08\u00ff\u00a6S\u00ea\u00c0x\u008b\u001f,\u00982\t\u00e7g\u00f5\u00dc\u00aa\u00de\u00a1\u0099P\u00ec\u0005\u009bs\u00eeT\u008bQ\u0011\u00b3j\u0082\u00acw\u008e\u00ca\u0090\u0086\u00132@s\u00a0\u00c3\u00e2}\u0089\u001b\u0081\u00e7\u00c2\u00db\u009a]\u00d2H\u0081\u00aa\u008a\u0019U\u00197\u00fei\u0080O\u00f3(\u00e8v\u00ec\u00a7r\u00b7\u00f7\u00f9\u00ce\u001d\u0096\u00ba:\u00a9\u00e1\u008c\u00d1Ki\u00b0\u00a3\u00bc\u0080\u00b4O\u00a3M=\u008eq\u00e9\u001aj\u00eeL\u00aey%\u00e31k\u00b0\u0094\u00c6\u00c8~\u0011\u00f5\u0080\u008e\u00c5\u00a8\u00050\u00bc<\u000bV\u00d8\u0018\u00b3\u00a3\u00cc8\u009d=(w\u000f\u001b\u00b3S\u00c4J\u00d3\u00ce\u0000\u0090 \u00d7wD\u0015\u0087!f\u0090\u00fe\u00f63\u00a9\u00ee\u008a)\u00ca\u00c7mN\u0089\u0086\u00ed\u00be_\u00e3]T\u00f8\u00c3\u00e2\u008b\u00e7\u0090\u008b\u00cf\u0080<2Ao\u00acW\u00bc\u0000\r\u00b8\u00ee\u00ac+\u009c\u00fb`\u001aQ\u00fc\u00f3\u0003\u0019\u00b9\u0082B\u00c7\u00da)IJ+9\u00027K\u001f\u00ea\\4\u00ce\u00ad\u00f0\u0086\u0005`\u00da:\u00bd\u008b\u00fc~\u0011l\u00d2\u00b5\u0089\u00fb\u009ed\u00e2K\u00b8\u007fX<'E\u008b\u0016t\\\u00e5\u008b^j\u001c\u0095\u000f\u00dd\u00ce\u00cc;d{((a?\u00bb\u00ac\u00c84\u00ae`5p\u0001\f\u0098\r\u00dc\u000boN\u00a1?\u00f04\n\u00f8j\u00fclQ&\u0013R\u0085\u00c4\u008e*\u00f4\u00b6\u009d\u00f4\u00fc\u0087wG@7\u00a5\u00e2\u008a\u0093\u001a\u0019\u00d7X\u00cf\u00af\u00b0\u00d5\u00c37$\u00b4A/\u001e\u00c2\u0090\u00e6E\u00bc\u00be\u00a0\u00a62\u00dd\u00ce\u00ae>\u00d2q\u00d78}\u00d2<J\u00da2\u00feA=\u00cc\u00d7 \u00e7\u0093\b\u00f6k\u0015\u00b0(4\u00d6Uu\u00c6\u0002n|\u00e3\u00e7\u00ff8\u00bb\u00c8\u00bfk\u00e7\u001d\nkR\u0099\u0082\u0096\u00d8zp\u00ec\u00ac\u001d\u0091@gPA]\u007f\u00bb\u000e?\u0090\u00d1\u00f7Y\u00b5\u00cc\u00b3\u00dbe\u00e2\u0000\u00a3\u0085]\u00c8f25\u0087u\u0095RQ\u0092K6\u0017\u00c1_\u0085(<j\u00ba:\u00f0\u00a5\u00c5\u00c3\u00b7\u00ec\u0014V\u00c4[+\u00a9\u0014\u00aeO\u00df\u00bf\u00afj\u00cf\n\"F\u0088O\u0006\u007f-\"u\u000eV\u00e7\u00e6<\u00a0bz\u00f8c\n_\u00a5\u00abw\u00a3\u0083?X\u00ee@]\u00ae\u00dc\u00c1\u00ab\u00d3L;\u00f8l\u00ee\u00aa\u00c9p\u00c6\u00f5\u00d7\u00e0\n\u0002\u001c'@\"sq\u00cag~'\u00e0r\u00b9x\u00d5\u00e9\u008b\u00fe\u0019OH\u0089z\u0096\u00b8\u00b2i?y\u00fe\u0017)\u008647_\u00a3\u00d7q8\u00bd0\u0012Dof\u00f9\u00fc-\u00ad\u009d>n\u00f9\u00fc\f\u008e\u00ca\b\u00ff-\u00f8\u0093\u00ab\u00f9\u008fe\u00b7\u0018i\u00b1\u00f7\u00bfiT\u00e1\u0001\u00b0#Y-\u0097o\u00d9\u00f4\u00aa\u00e6\u00c0\u00a5\u00d0gW\u00c3t\"y\u0081k\u0099]\u00b0\u00f6\u00fe\u0098]\u0016\u0080~t\u008b\u00ed-\u00c4\\\u0011\u00d8D\u0002\u00f8'\u000f\u00ef\u0018~\u00bc\u00d9\u00f6\u00a8h/\u00fc\u00d2\u00bc\u0095\u00d8f~$2\u00a8\b\u0097m\u00a8\u00eb\u00a1\u00e2\u0086\u0086YG\u0088%\u0088Z\u000b'J\u001c\u00c0\u0001eBnK8\u00bdrh\u0099m \u00cb\u00cd\u009f\u00971_\u00d0\u00ea\u00cffKc\u00cf2\u00bdd8\u007f\u0080DD\u0018H\u0000-\u00ba\u00e9S\u0007\u00f7=q\u00f8L\u00fcH\tz\u00d0&\u00f5\u0087\u0007\u00ff\u00d0\u00ddU\u00a2B\u00aa\u00ee\u00ec0GU1$\u008cp\u00b2Qc\u008e%\u00f6r\u00e6z\u008b\u00e2p/\u00fe\u0015\u00137upW\u00de\u00b0}\u001e\u0095a\u0082\u00f9)\u0082\u0000L:\u0015\u0096\u001b\u0018\u00e7\u00ac\u00cap:E\u00a0\u00adV\u00a6_i\u0086\u0098,uQ\u00fa\u00dd\u00b1aY\u0080d\u0017\u008a\u0095zK\u008e\u00ba\u00b4\u00abu\u00ad\u00cf\u00d1\u0087=M\u001aj\u00cf\"\u00c43?\u0084\u000em\u00f2\u0095\u00a7\u00167 \b\u00d7\u00d5\u00edTr`\u0016\u00e7s\u00ca\u008b::\u00a0BV[S\u00d0\u008bm\u00ba[[\u00b9\u0000\u00d0\u00e2\rs\u0088u8D\u009d0\u00fc\u00bdi\u00be\u00b3$\u0013\u00d9\u00dd\u00e2';=\u00c6\u00d2O\u00c88\u000bhc}\u000b\u00bfj\u000e\u00ce~\u00b0\u008a=x\u0094\u0014\"\u00f8r\u00f9\u0082uMR\u0014\u009b;\u00f4\u00f1\u0095\u00cf\u0095\u00fb\u0081T\f\u0097\u00a7S\u0089h\u00a0\u001e\u00ab\u008b\u009bj<\u00f0\u00b4\u00d5\u00b7\u0089\u00ffzm\u00e9\u009f6\u0004\u00e7\u00e3%\u0097\u00e3O(\u00cd\u0096\u00e2\u00e3\u00f0-\u00f7\u0098Va\u00b1\b\u00ef\u00a6\u008e4\u00bfCY\u00b5#\u0012\u008eTh\u007f0\u00c6\u00ecB%\u0007\u001f\u0016\u00ea\\\u00b9\u00e2\u0080\u007f/R\u00d3\u00cd\u00c3\b\u00ce\u00eeS3l\\\u009f\u00f2\u00da\u00c5\u00b9\u008c\u0081\u00b9c~\u00ee\u000f\u00d2u\u00b8eQ=\u0099eB6\u0097\u00be\u00ba\u00a2K:\u00f58S\u00dd({\u00ae\u00f1\u00c5\u00de\u00c4y\u0087+\u00136)\u0098\u0012\u0083d\u00f3\u00e38\u0098\u009b\u0018\u00e5rc\u00f4m\u0004\u00c2\u0084\u00be\u0094P=H\u00e3\u00a3\u00f3`\u00b8\u00f6);rE\u0013\u00a3Z\u008d\u00efr\u001f\u00a00\u00c0\u0011\u00f6\u00ed4\u00a1TT\u0099\u00ec\u00fa{q\u00ad\u0083Co\u00a7G\u001d\u00cdQ\u0004\u00e9Y\u009aX\u00a5s\u00a5\u0007{\u0090\u009a\u009b\u001a\u00d8\u0014e\u00a2m\u0016\u00fc`$\u009c\u00ee^\u0097hH\u0010\u00f5\u00a2eS`\u00fb\r=\u000e8\u00a21\u00b8BoS\u0094C\u001d\u0091\u0007\u00f1\u0002\tx\u00ee39IM%\u00a3s%b\u00a1e\u00de6c\u0089\u00d7\u00c7\u00f3f\u009a\u00a5\u00e4\u0097\u00a3OBn\u00f1|\u0088`\u009b\u00e2uf\u00bc\u00b5\u00be-5\u0091\u0010\u001aQ\nn\u0007m\u00c2\u0010\u00a1\u00df\u00e9I\u00cb\u00b1'\u00f5\u00c1M4\u008a!o\u000f\u00cf\u00e9R\u00ba\u00bf\u0003\u009eZ\u00a5\u0094\u00bb\u00da\u00a4[\u00e2\u007f\u0007\u00a2\u0092\u00f5%\u008c+v\u00b6\u00beU\u00b0\u00fb\u00fd\u009e\u00f9\u007f\u00c9\u00cc\u00ed\u00cc6\u009az\u0007d\u008e\u0080\u00d8]\t7T.G\u00d6;\u00c0\u00a2G\u009cI\u009a\u0015U>\u0002\u0015\u00ea\u00f8xX\u00ff\u00ee\u00c9\u00b1n\u001d&\u0094n\u00acA\u00ad\u008f\u00d1\u0093\u00cd\u00bf\u00eb@\u00da\b?c\u001e\u0012Wx\u0019\u00fc\u00ad\u00dd\u008c\u008c\u007f\u00b83r\u00d6\u00faR\u00b3r\u00e4:\u00a3\u00a4\u00a3\u00e0\u00f3\u007f+\u0000\u0080B\u001bx\u0083\u009cJ\u00aa\u00ef\u0018\u0011&o-v\u00a8Px\u00a5\u0093\u00eeei\r\u0093\u0080zho\u0080\u0018\u0010\u00d0y/\u008b\u00acVP\u00e1N\u0000OO\u0085\u00eb\u009fVF\u00d6:I`o\u00b7\u0016]4\u0086h\u00c4=\u008a\u0095i9\u00f0\u0019/\u0010\u00f4IG\u008f\u00c4\u00f6\u00aejm\u00a3Q_\u00ce3\u00a2?b\u00c5E&\\\u00a1;\u0080\u00ef\u00fc\u00c5\r\u00db\u0092r\u0019\u00d0\u0093\u00bd\u00bfX\u009c\u001f\u0014\u0099*\u007fg<\u00c7\u00ae\u00cb\u00ce\u00c9\u00a3\u000f\u0092-\u0018\u00b8\u00ff\u00aa.\u00ecB\u000bC\u0090O\u0010\u00da)g8\u00ca\u00a6$\u00d6\u0015\u00cb\u0013sOc+\u0005Vk\u00ec^y\u008b\u00ec\u00a7\u00f0\u00b4+\u00f1\u0098>\u00b7\"\u0083\u00df\u00cbd&1\u00eb\\g\u00fd\u00d2\u00cd!\u009d\u00fd\u0014\u00ccb\u00f7\u0089\u001aA\u00ceH\u00deE\u00b6N\u008d$\u00d5\u0095Xj\u00ecZ\u007f\u0087l\u00f1\u00cf!.\u0014\u00cas\u00c2\u0016H\u00ed$S\u0090Z\u0000y8\u00a4\u00da\u00aajf\\\u0087RVf\u00cd\u00fa\r\u00197\u00b9E\u00c3\u00a0\u0084RC\u001a\u00ec\r\u00fb\u00f1\u0094\u00e1\u00ed5x\u00ce\u00df\u00e0\u00f3\u00dd3pp\u00d4\u00fe\u00b35\u00ec\u001e\u00d2x\u00ac\n\u001b%\u0002\u00a4 \u00dc\u00e9U\u0083\u00c3\u00f5@\u00a5\u00dd+?0A\u00d9J2\u0007$\u00cc\u00e6\u008b[\u0001#\u000e\u008fD\u00bcD;\u00d6D\u00ab\u00de\u00b2\u00bbP?\u00fe\u0010\u00f6\u0084\r\u00f0Np\u00d4\u00e5\u009c\u00f6#\u00eb\u00e5(tS\u0018\u00a8w\u00f9\u0007\u0005\u00fe\u0004u\u00d1\u0005\u00f3\u00afA\u00c2\u00b0(\u00d2\u00cb\u001c\u0004\u00f1\u0005v\u008e>H\u00e3\u001e\u00b0V\u0001\\\u00dcP{\u0087\u00af\u009b\u00c2r\u000e\u00d6\n\u00b2\u00ab4,\u00cb^\u0019Rk\u00be\u008c\u00fe\u0011I\u0088\u0006\u00fb\u0094\u00cb\u00c3Q|\u00f2\u00ee:\u00abZ\u00d3\u00a9\u00e5\u0019\u00f8ih~eF\u00b8\u0095/\b\u00a9\u0005\u000f;1m\u00d3\u00ffJMe\u00fe\u00e1w\u0088\u0011\u00c7\u0094\u0012\u00ae]\u0080F\tDN\u00f3s\u00ab\u00fe\u00c5_L\u000e\u00ec\u0014\u00a5{\u0010\u00ac\u00e0{\u00cf\u00bb\u00ee\u0099\u0012\u00d9\u001fN\u0094{\u00ac\u0096\u00b0`\u001b_\u00a6\u00ee\u00d5\u00c8\u0085j\u00ad#}\u008c\u00a8\u0003/\n\u00f0m\u008e\u0091rJz\u0080N\u00c4\u00cb\u00f8\u000b\u0098\u00b2\nn\u00b4\u00a8\u00a0\u0097\u0005v\u0018w\u00ccn\u00c4\u00bc\u0019@7\u0007\u0017{\u0093\u00ee\u00a5\u00c0\u00b6\u00c1\u00b3\u001d\u00f4\u00a6\u00b5]\u00f5A\"\u00d6\u00aa S\u0098\u00ee\u00fc\u00bf\u001c\u0083\u00eb\u0015\u001d\u00d0\u00ba\u00b8\u00b1\u008cf2>\u00c5\u00a8\u00fe\u00f1C5\u00fe\u00c2\u000eK\u0014?\u0084\u00d0E\u001e\u0016\u00b3L\u00c4\u00b7a\u00d3\u009ew\u0080+\u0015n\u00b1\u00a5\u00c7=\u0015\u0014\u00be\u00a1J\u00e0\u0011\u00c0?\u00f2\u00dbA.\u00c5\u00dc4\u00f4\u00fd$j\u0014\u00fd\u0002K\u001d\u0017\u00ab\u00de\u009b\u00e8R\u0082H\u0017\u00e1\u00dc\t/n\u00c0Rs\u00f7\u00fb\u0081\u00ce\u008a&Z\"\u00ca!\u0001\u008a\t\u00c1F\u0004,\u00af\u00ef\u00f9\u00f7\u00e8,f`v@\u00ca2\u00dc\u0090\u0005>\u009eL\u00e5\u0006\u00d9\u0013\u008d\u00e9\u00d8&?\u000e\u00b73\u009c\u00c5\u001dS\t\b\u00e2>\u00d0\u00cf=u\u0099\u00b2\u00a4\u008fR\u000e\u008a\u0011\"\u0012mkG\u00f7P\u00b1\u00b1\u00c0?\u0086\u0014\u00b5\u00df\t\"\u00bd#n\u00c5\u00b8/\u00854\u00a2\u00e9VM\u00ad\u00b9\u00be\u00ceTf\u001a\u00b6#\u00ff\u008eei\u00e3\u0096\u008a\u00d7\u00df\u009e\u009a\u00d332\u008b\u0088\u00cfx|7\u00943\r\u00e2\u000e\u00804&j\u00a05\u000f\u00df\u00c8t\u00e0*\u00df\u00a7 9\u00d5\\\u008f+\u00be\u0093\u00c5\u00a2\u0081\u00e32\u00ce\u0006\u00baE:\u009b\u009a\u00ae4\u0018\u008cU\u00c57\u0082\u00b9\u00800\u00e1\u00f5\u000e\u0084\u00de\u00f81}\u007f\u00e24<\u001f\u00cf\u0017\u0018\u00cbHsp\u00c1\u00bd\u00a9\nPA\u00f3\u00feOu\u00a4\u0083I\u00b4\u00eagLXL\f\u00a2\u00a8g\u000e\\\u00bb\u00bd\u0091{y`\u00a1\u00af\u00c4\u00cdK\u00f4\u00c6\u0085\u00d9K\u00df\u00e0?s\u00d4:\u0097\u00da\u00f9\u00a4\u00a0\u00ef\u009d\u00cd;r#(\u00f7O3\u00e3-\"\u00865\u0090w\u00a6\"6\u0002\u00ef\u00aag\u00ed\u00a3\u0006\u0082\u00c9\u00ce\u00ca\u00bc\u0004(Y\u0099L\u00ea((\u0092\u0097\u0083\u00e0\u001f\u001e\u0093\u00a4b\u009f\u00b5p\tHL\u0083&\u00c3U\u00c5\u00cf\u00b8\u000e\u00d40\u008b\u00b2\u00cbq\u00e6\u0003g}P\u00e7,\u00d7\u00ac\u00c9\u008e\u0089\u00ab\u0007\u0093,9\u008a\u00a9\u00f2\u00c5fk\u0081\u00c2+Y\u009e\u00cfZ=$\u0094\u00d0\u0091\u0092\u00f9\u0016Y.X\u00aemT\u00e5\u00e4\u00a2\u00f7\u0099\u00f4x\u00c0,i\u00c5\u00fc\fL\u00c1\u001b\u0082/T\u00df\u0017&m\u009b\u00cf\u00908\u0084ta\u00e7\u00c3\u00bf\u00c1\u00f8\f0[\u00a4\u00b2\u0098\u00bb\n\u00e6)TN\u00a1\u00ba\u00d2\u00aeB*\u001f\u009cP\u00b41/\u0014f?yU\u009b'&\u0087\u00df\u00a4 \u00b0\u0087\u00d2Y\u00b9\u00c18|\u0080A\u001b\u00ea\u0001\u001f\u00e2\u0094\u00e9\u001e\u00d9E\u00fc_\u00a7\u0012P\u0081\u00e8\u00de\u00ce\u000f\u00ce\u000f\u0016\u000b\u00de\u00b3\u00bbe\u0011e\u00c4\u0082Z\u00fd\u00bd\u00a0x\u00be\u00e6\u00f2.\u00e3\u0006\u00a5g\u00c7\u001a\u0080Ry\u0085_Eb\u00e1\u00e7k\u0082M\u0091\u00ebc\u00df\u00d7k\u0090\u00a0X\u00b7\u00b1\u00eb\u00ca\u00dd\u0082\u00bc\u009c\u0006\u0092\u0082$\u00f5\u00e7\u0004\u00b0\u0084,\u0015S<F\u00b9C\u0010\u00e3L6)\u00fc\u00f3#$\u00ddivs\u00f9K\u00a4o\u00d7\u0001\u00c0\u0011\u00a8,f\u001b\no\u00f0?=\u00ab\u0085V\r\u00a4\u00ac5\u008fUD\u00e3\u00fc]b\u0017\u0005U\u0001\u00b9\u00d6{F\u001b\u008e\u0092Bhq\u00abc\u0099I~\u00c0T\u0015\u0014\u00cf-e\u00ff\u00bbK\u00d6\u00d7\u00fb\u00f2\u0007~m-\u00855\u00cb\u0093\u00dd;\u009c\u00a5\u00b6\u001c8 \u00ec\u0081\u00d0\u00fc\u00ad\u00c5\u00ec\b\u00cb?Vqo\u0018\u000f\u00e5\u00d0\u007fr\u007f%\u008f\u00d7V\u000f\u00bf\u00c75\u00f36\u00d5\u00f2!\u001a\u00d5l4\u00b34Sui\u008cb\u0088\u00a4\u00a6)\u0004\u00e3s\u001d\u009cQ!\n1\f\u00ff|\u0015&K\u00e8\u008b)\u00c7\r\u00ab\u00e8\u0088\u00ee\u00aa<\"L\u00b2\u0085\u0084\u00dbw\u0099\u0012\u0000*;\u00a7\u00a6I\u00e6\n\u00d4\u00fb}\u001b\u00bdP\u00c2(U\u0089\u001a\u00f4\u00d3\u00b7\u0090l\u00aa\u00c2\u00ee\u00ae\u00d8[\u007f\n\u00ef!\u00b5\u00c9x\u0087fu\u00f4\u00b5K)\u00ed\u001b\u00c43rZQ\u001e\u00c7\u00dat4\u00f5,O3\u00c4X\u00e3>\u00dc\u0088m\u0003}0\u0014\\\u00b6\"=)\u008c\u00c1ICp^,\u00c2\u001b\u00ac\u0006%t,b\u00bd\u00de\u00d4\u00e8\u0093V\u00ecz:\u0082\u00a8;\u0001\u00e0Z\u00b4\u0007\"B}3\u009a\u00c2\u001a\u007f\u0086\u00c0\u0088\u00ba\u000eS\"9\u000fy\u00d6\u00bf\u00e8|\u00e6\u00c25\u0090N\u0012F\u00d6\t\u00b4\u00e10\u001b\u000b\u0087i\u008b\u0018\u00d5J\u0093\u009c\u009e\u00cc\u00e6\u0018\u00f9\u00f4D\u00ab,<\u00a2@r\u0007\u00dfS\u0088\u00ec\u00a7d\u0094&\u0092\u00ecQn\u0090\u0004l\u001f\u0000\u00ca\u00ea\u00c3\u00e57\u0007\u0010\u00e9\u009c\u00d9\u00fa\u008c|\u00ae2\u00e3\u00c1\u00c5\u0089\u000e\u00deK5o\u009c\u00ff\u00ea\u00d6\u00c68\u00ec\u00b1\u00b5e\u00ff.?\u00cas\u00bb\u00a51%\u0095f\u00c3W\u00b5\u00e0\u00e0H\u00813w\u00bd\u00e9{\u00bax\u00c1\u00e2\u00f5\u008c\u00f4i\u00ab;\u00e2@g\u00b1\u00de\u00b5f\u0003~\u00d4T\u00c85\u00a9\u00a9,\u001a\u00ae\u00e3\u00da0\u00b1\u0019}\u009a\u0098\u0087b\u00b4\u008b\u00f6f\u0080\b \u0010\u00bf\u00c3\u001d".length();
                var1_4 = 30;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = ++var0_5;
                    v1 = var2_2.substring(v0, v0 + var1_4);
                    v2 = -1;
                    break block19;
                    break;
                }
lbl12:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0085\u007f\u009c\r\u00a7\u0017\u00dc\u00b1\u00d2\u00cb\u00a9\u00c2\u00d4/Q\u0013&\u00b0\u00af\u00f1\u0017\u001e\u00a2c/\u009f\u0000\u00adF\u00c6\u00e9\u00b0Xv}\u00d1\u00dc\u000b\u00fb\u001f\u0016\u00b7\u00db\u00ce\u008d\u00bd\u00a0U\u00ccM\u008eK";
                    var4_3 = "\u0085\u007f\u009c\r\u00a7\u0017\u00dc\u00b1\u00d2\u00cb\u00a9\u00c2\u00d4/Q\u0013&\u00b0\u00af\u00f1\u0017\u001e\u00a2c/\u009f\u0000\u00adF\u00c6\u00e9\u00b0Xv}\u00d1\u00dc\u000b\u00fb\u001f\u0016\u00b7\u00db\u00ce\u008d\u00bd\u00a0U\u00ccM\u008eK".length();
                    var1_4 = 21;
                    var0_5 = -1;
lbl21:
                    // 2 sources

                    while (true) {
                        v4 = ++var0_5;
                        v1 = var2_2.substring(v4, v4 + var1_4);
                        v2 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl26:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v3.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v5 = v1.toCharArray();
            var6_6 = 0;
            v6 = v5.length;
            v7 = v5;
            v8 = v6;
            if (v6 > 1) ** GOTO lbl76
            do {
                v9 = v7;
                v10 = v7;
                v11 = var6_6;
                while (true) {
                    v12 = v9[v11];
                    switch (var6_6 % 7) {
                        case 0: {
                            v13 = 112;
                            break;
                        }
                        case 1: {
                            v13 = 11;
                            break;
                        }
                        case 2: {
                            v13 = 43;
                            break;
                        }
                        case 3: {
                            v13 = 126;
                            break;
                        }
                        case 4: {
                            v13 = 47;
                            break;
                        }
                        case 5: {
                            v13 = 87;
                            break;
                        }
                        default: {
                            v13 = 43;
                        }
                    }
                    v9[v11] = (char)(v12 ^ v13);
                    ++var6_6;
                    v7 = v10;
                    v8 = v8;
                    if (v8 != 0) break;
                    v10 = v7;
                    v14 = v8;
                    v11 = v8;
                    v9 = v7;
                }
lbl76:
                // 2 sources

                v15 = v7;
                v14 = v8;
            } while (v8 > var6_6);
            v3 = new String(v15);
            switch (v2) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl85:
                // 1 sources

                ** continue;
            }
        }
        Signer.h = var5;
        Signer.i = new String[88];
        Signer.a = DigestAlg.SHA256;
        Signer.b = true;
        Signer.d = true;
        Signer.e = new Asn1ObjectIdentifier(_etsiqcValues.id_etsi_qcs_QcCompliance);
        Signer.f = EESYAOID.oid_TK_nesoid;
    }

    private static String a(int n, int n2) {
        int n3 = (n ^ 0x78CB) & 0xFFFF;
        if (i[n3] == null) {
            int n4;
            int n5;
            char[] cArray = h[n3].toCharArray();
            switch (cArray[0] & 0xFF) {
                case 0: {
                    n5 = 19;
                    break;
                }
                case 1: {
                    n5 = 142;
                    break;
                }
                case 2: {
                    n5 = 2;
                    break;
                }
                case 3: {
                    n5 = 111;
                    break;
                }
                case 4: {
                    n5 = 75;
                    break;
                }
                case 5: {
                    n5 = 228;
                    break;
                }
                case 6: {
                    n5 = 114;
                    break;
                }
                case 7: {
                    n5 = 221;
                    break;
                }
                case 8: {
                    n5 = 46;
                    break;
                }
                case 9: {
                    n5 = 108;
                    break;
                }
                case 10: {
                    n5 = 206;
                    break;
                }
                case 11: {
                    n5 = 135;
                    break;
                }
                case 12: {
                    n5 = 26;
                    break;
                }
                case 13: {
                    n5 = 4;
                    break;
                }
                case 14: {
                    n5 = 207;
                    break;
                }
                case 15: {
                    n5 = 197;
                    break;
                }
                case 16: {
                    n5 = 55;
                    break;
                }
                case 17: {
                    n5 = 176;
                    break;
                }
                case 18: {
                    n5 = 94;
                    break;
                }
                case 19: {
                    n5 = 83;
                    break;
                }
                case 20: {
                    n5 = 119;
                    break;
                }
                case 21: {
                    n5 = 34;
                    break;
                }
                case 22: {
                    n5 = 99;
                    break;
                }
                case 23: {
                    n5 = 158;
                    break;
                }
                case 24: {
                    n5 = 152;
                    break;
                }
                case 25: {
                    n5 = 222;
                    break;
                }
                case 26: {
                    n5 = 167;
                    break;
                }
                case 27: {
                    n5 = 23;
                    break;
                }
                case 28: {
                    n5 = 188;
                    break;
                }
                case 29: {
                    n5 = 217;
                    break;
                }
                case 30: {
                    n5 = 81;
                    break;
                }
                case 31: {
                    n5 = 17;
                    break;
                }
                case 32: {
                    n5 = 253;
                    break;
                }
                case 33: {
                    n5 = 117;
                    break;
                }
                case 34: {
                    n5 = 74;
                    break;
                }
                case 35: {
                    n5 = 28;
                    break;
                }
                case 36: {
                    n5 = 69;
                    break;
                }
                case 37: {
                    n5 = 203;
                    break;
                }
                case 38: {
                    n5 = 10;
                    break;
                }
                case 39: {
                    n5 = 250;
                    break;
                }
                case 40: {
                    n5 = 109;
                    break;
                }
                case 41: {
                    n5 = 32;
                    break;
                }
                case 42: {
                    n5 = 168;
                    break;
                }
                case 43: {
                    n5 = 159;
                    break;
                }
                case 44: {
                    n5 = 76;
                    break;
                }
                case 45: {
                    n5 = 29;
                    break;
                }
                case 46: {
                    n5 = 156;
                    break;
                }
                case 47: {
                    n5 = 180;
                    break;
                }
                case 48: {
                    n5 = 157;
                    break;
                }
                case 49: {
                    n5 = 24;
                    break;
                }
                case 50: {
                    n5 = 44;
                    break;
                }
                case 51: {
                    n5 = 140;
                    break;
                }
                case 52: {
                    n5 = 97;
                    break;
                }
                case 53: {
                    n5 = 153;
                    break;
                }
                case 54: {
                    n5 = 166;
                    break;
                }
                case 55: {
                    n5 = 143;
                    break;
                }
                case 56: {
                    n5 = 121;
                    break;
                }
                case 57: {
                    n5 = 195;
                    break;
                }
                case 58: {
                    n5 = 73;
                    break;
                }
                case 59: {
                    n5 = 102;
                    break;
                }
                case 60: {
                    n5 = 50;
                    break;
                }
                case 61: {
                    n5 = 209;
                    break;
                }
                case 62: {
                    n5 = 214;
                    break;
                }
                case 63: {
                    n5 = 7;
                    break;
                }
                case 64: {
                    n5 = 178;
                    break;
                }
                case 65: {
                    n5 = 113;
                    break;
                }
                case 66: {
                    n5 = 246;
                    break;
                }
                case 67: {
                    n5 = 11;
                    break;
                }
                case 68: {
                    n5 = 92;
                    break;
                }
                case 69: {
                    n5 = 130;
                    break;
                }
                case 70: {
                    n5 = 122;
                    break;
                }
                case 71: {
                    n5 = 48;
                    break;
                }
                case 72: {
                    n5 = 47;
                    break;
                }
                case 73: {
                    n5 = 238;
                    break;
                }
                case 74: {
                    n5 = 174;
                    break;
                }
                case 75: {
                    n5 = 5;
                    break;
                }
                case 76: {
                    n5 = 187;
                    break;
                }
                case 77: {
                    n5 = 77;
                    break;
                }
                case 78: {
                    n5 = 255;
                    break;
                }
                case 79: {
                    n5 = 38;
                    break;
                }
                case 80: {
                    n5 = 89;
                    break;
                }
                case 81: {
                    n5 = 71;
                    break;
                }
                case 82: {
                    n5 = 162;
                    break;
                }
                case 83: {
                    n5 = 6;
                    break;
                }
                case 84: {
                    n5 = 202;
                    break;
                }
                case 85: {
                    n5 = 196;
                    break;
                }
                case 86: {
                    n5 = 218;
                    break;
                }
                case 87: {
                    n5 = 13;
                    break;
                }
                case 88: {
                    n5 = 41;
                    break;
                }
                case 89: {
                    n5 = 21;
                    break;
                }
                case 90: {
                    n5 = 18;
                    break;
                }
                case 91: {
                    n5 = 134;
                    break;
                }
                case 92: {
                    n5 = 192;
                    break;
                }
                case 93: {
                    n5 = 234;
                    break;
                }
                case 94: {
                    n5 = 239;
                    break;
                }
                case 95: {
                    n5 = 165;
                    break;
                }
                case 96: {
                    n5 = 136;
                    break;
                }
                case 97: {
                    n5 = 49;
                    break;
                }
                case 98: {
                    n5 = 212;
                    break;
                }
                case 99: {
                    n5 = 107;
                    break;
                }
                case 100: {
                    n5 = 115;
                    break;
                }
                case 101: {
                    n5 = 120;
                    break;
                }
                case 102: {
                    n5 = 129;
                    break;
                }
                case 103: {
                    n5 = 183;
                    break;
                }
                case 104: {
                    n5 = 67;
                    break;
                }
                case 105: {
                    n5 = 31;
                    break;
                }
                case 106: {
                    n5 = 106;
                    break;
                }
                case 107: {
                    n5 = 198;
                    break;
                }
                case 108: {
                    n5 = 230;
                    break;
                }
                case 109: {
                    n5 = 133;
                    break;
                }
                case 110: {
                    n5 = 116;
                    break;
                }
                case 111: {
                    n5 = 248;
                    break;
                }
                case 112: {
                    n5 = 220;
                    break;
                }
                case 113: {
                    n5 = 243;
                    break;
                }
                case 114: {
                    n5 = 249;
                    break;
                }
                case 115: {
                    n5 = 127;
                    break;
                }
                case 116: {
                    n5 = 56;
                    break;
                }
                case 117: {
                    n5 = 223;
                    break;
                }
                case 118: {
                    n5 = 25;
                    break;
                }
                case 119: {
                    n5 = 60;
                    break;
                }
                case 120: {
                    n5 = 43;
                    break;
                }
                case 121: {
                    n5 = 79;
                    break;
                }
                case 122: {
                    n5 = 137;
                    break;
                }
                case 123: {
                    n5 = 227;
                    break;
                }
                case 124: {
                    n5 = 15;
                    break;
                }
                case 125: {
                    n5 = 149;
                    break;
                }
                case 126: {
                    n5 = 147;
                    break;
                }
                case 127: {
                    n5 = 123;
                    break;
                }
                case 128: {
                    n5 = 213;
                    break;
                }
                case 129: {
                    n5 = 200;
                    break;
                }
                case 130: {
                    n5 = 229;
                    break;
                }
                case 131: {
                    n5 = 219;
                    break;
                }
                case 132: {
                    n5 = 146;
                    break;
                }
                case 133: {
                    n5 = 181;
                    break;
                }
                case 134: {
                    n5 = 37;
                    break;
                }
                case 135: {
                    n5 = 148;
                    break;
                }
                case 136: {
                    n5 = 126;
                    break;
                }
                case 137: {
                    n5 = 14;
                    break;
                }
                case 138: {
                    n5 = 150;
                    break;
                }
                case 139: {
                    n5 = 118;
                    break;
                }
                case 140: {
                    n5 = 30;
                    break;
                }
                case 141: {
                    n5 = 84;
                    break;
                }
                case 142: {
                    n5 = 68;
                    break;
                }
                case 143: {
                    n5 = 62;
                    break;
                }
                case 144: {
                    n5 = 101;
                    break;
                }
                case 145: {
                    n5 = 155;
                    break;
                }
                case 146: {
                    n5 = 179;
                    break;
                }
                case 147: {
                    n5 = 251;
                    break;
                }
                case 148: {
                    n5 = 247;
                    break;
                }
                case 149: {
                    n5 = 231;
                    break;
                }
                case 150: {
                    n5 = 131;
                    break;
                }
                case 151: {
                    n5 = 145;
                    break;
                }
                case 152: {
                    n5 = 36;
                    break;
                }
                case 153: {
                    n5 = 0;
                    break;
                }
                case 154: {
                    n5 = 110;
                    break;
                }
                case 155: {
                    n5 = 39;
                    break;
                }
                case 156: {
                    n5 = 86;
                    break;
                }
                case 157: {
                    n5 = 9;
                    break;
                }
                case 158: {
                    n5 = 226;
                    break;
                }
                case 159: {
                    n5 = 184;
                    break;
                }
                case 160: {
                    n5 = 52;
                    break;
                }
                case 161: {
                    n5 = 208;
                    break;
                }
                case 162: {
                    n5 = 42;
                    break;
                }
                case 163: {
                    n5 = 40;
                    break;
                }
                case 164: {
                    n5 = 124;
                    break;
                }
                case 165: {
                    n5 = 8;
                    break;
                }
                case 166: {
                    n5 = 100;
                    break;
                }
                case 167: {
                    n5 = 82;
                    break;
                }
                case 168: {
                    n5 = 245;
                    break;
                }
                case 169: {
                    n5 = 61;
                    break;
                }
                case 170: {
                    n5 = 141;
                    break;
                }
                case 171: {
                    n5 = 215;
                    break;
                }
                case 172: {
                    n5 = 244;
                    break;
                }
                case 173: {
                    n5 = 98;
                    break;
                }
                case 174: {
                    n5 = 65;
                    break;
                }
                case 175: {
                    n5 = 128;
                    break;
                }
                case 176: {
                    n5 = 185;
                    break;
                }
                case 177: {
                    n5 = 237;
                    break;
                }
                case 178: {
                    n5 = 103;
                    break;
                }
                case 179: {
                    n5 = 138;
                    break;
                }
                case 180: {
                    n5 = 154;
                    break;
                }
                case 181: {
                    n5 = 70;
                    break;
                }
                case 182: {
                    n5 = 91;
                    break;
                }
                case 183: {
                    n5 = 59;
                    break;
                }
                case 184: {
                    n5 = 64;
                    break;
                }
                case 185: {
                    n5 = 242;
                    break;
                }
                case 186: {
                    n5 = 169;
                    break;
                }
                case 187: {
                    n5 = 194;
                    break;
                }
                case 188: {
                    n5 = 1;
                    break;
                }
                case 189: {
                    n5 = 235;
                    break;
                }
                case 190: {
                    n5 = 216;
                    break;
                }
                case 191: {
                    n5 = 193;
                    break;
                }
                case 192: {
                    n5 = 171;
                    break;
                }
                case 193: {
                    n5 = 232;
                    break;
                }
                case 194: {
                    n5 = 191;
                    break;
                }
                case 195: {
                    n5 = 93;
                    break;
                }
                case 196: {
                    n5 = 190;
                    break;
                }
                case 197: {
                    n5 = 132;
                    break;
                }
                case 198: {
                    n5 = 240;
                    break;
                }
                case 199: {
                    n5 = 164;
                    break;
                }
                case 200: {
                    n5 = 210;
                    break;
                }
                case 201: {
                    n5 = 66;
                    break;
                }
                case 202: {
                    n5 = 51;
                    break;
                }
                case 203: {
                    n5 = 54;
                    break;
                }
                case 204: {
                    n5 = 254;
                    break;
                }
                case 205: {
                    n5 = 163;
                    break;
                }
                case 206: {
                    n5 = 225;
                    break;
                }
                case 207: {
                    n5 = 88;
                    break;
                }
                case 208: {
                    n5 = 78;
                    break;
                }
                case 209: {
                    n5 = 186;
                    break;
                }
                case 210: {
                    n5 = 27;
                    break;
                }
                case 211: {
                    n5 = 182;
                    break;
                }
                case 212: {
                    n5 = 112;
                    break;
                }
                case 213: {
                    n5 = 45;
                    break;
                }
                case 214: {
                    n5 = 189;
                    break;
                }
                case 215: {
                    n5 = 33;
                    break;
                }
                case 216: {
                    n5 = 160;
                    break;
                }
                case 217: {
                    n5 = 80;
                    break;
                }
                case 218: {
                    n5 = 104;
                    break;
                }
                case 219: {
                    n5 = 35;
                    break;
                }
                case 220: {
                    n5 = 105;
                    break;
                }
                case 221: {
                    n5 = 53;
                    break;
                }
                case 222: {
                    n5 = 233;
                    break;
                }
                case 223: {
                    n5 = 57;
                    break;
                }
                case 224: {
                    n5 = 16;
                    break;
                }
                case 225: {
                    n5 = 85;
                    break;
                }
                case 226: {
                    n5 = 125;
                    break;
                }
                case 227: {
                    n5 = 170;
                    break;
                }
                case 228: {
                    n5 = 90;
                    break;
                }
                case 229: {
                    n5 = 20;
                    break;
                }
                case 230: {
                    n5 = 211;
                    break;
                }
                case 231: {
                    n5 = 205;
                    break;
                }
                case 232: {
                    n5 = 204;
                    break;
                }
                case 233: {
                    n5 = 236;
                    break;
                }
                case 234: {
                    n5 = 175;
                    break;
                }
                case 235: {
                    n5 = 3;
                    break;
                }
                case 236: {
                    n5 = 151;
                    break;
                }
                case 237: {
                    n5 = 87;
                    break;
                }
                case 238: {
                    n5 = 139;
                    break;
                }
                case 239: {
                    n5 = 72;
                    break;
                }
                case 240: {
                    n5 = 12;
                    break;
                }
                case 241: {
                    n5 = 58;
                    break;
                }
                case 242: {
                    n5 = 144;
                    break;
                }
                case 243: {
                    n5 = 96;
                    break;
                }
                case 244: {
                    n5 = 201;
                    break;
                }
                case 245: {
                    n5 = 173;
                    break;
                }
                case 246: {
                    n5 = 177;
                    break;
                }
                case 247: {
                    n5 = 161;
                    break;
                }
                case 248: {
                    n5 = 63;
                    break;
                }
                case 249: {
                    n5 = 241;
                    break;
                }
                case 250: {
                    n5 = 224;
                    break;
                }
                case 251: {
                    n5 = 172;
                    break;
                }
                case 252: {
                    n5 = 252;
                    break;
                }
                case 253: {
                    n5 = 95;
                    break;
                }
                case 254: {
                    n5 = 199;
                    break;
                }
                default: {
                    n5 = 22;
                }
            }
            int n6 = n5;
            int n7 = (n2 & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n4 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n4 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n4);
                    n4 = ((n4 >>> 3 | n4 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            Signer.i[n3] = new String(cArray).intern();
        }
        return i[n3];
    }
}

