/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.dianta2.api;

import com.sun.org.apache.xerces.internal.jaxp.datatype.XMLGregorianCalendarImpl;
import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.ASN1Object;
import com.turktrust.asn1.Any;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.Null;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.SetOf;
import com.turktrust.cms.DigestAlgorithmIdentifiers;
import com.turktrust.cms.EncapsulatedContentInfo;
import com.turktrust.cms.SignedAttributes;
import com.turktrust.cms.SignedData;
import com.turktrust.cms.SignerIdentifier;
import com.turktrust.cms.SignerInfo;
import com.turktrust.cms.SignerInfos;
import com.turktrust.cms.UnsignedAttributes;
import com.turktrust.cms.X509CertificateSet;
import com.turktrust.dianta2.api.ImzaDegerNesnesi;
import com.turktrust.dianta2.api.SertifikaDegerNesnesi;
import com.turktrust.pkcs7.CertificateSerialNumber;
import com.turktrust.pkcs7.ContentInfo;
import com.turktrust.pkcs7.IssuerAndSerialNumber;
import com.turktrust.smyy.utils.Base64;
import com.turktrust.smyy.utils.CMSFabrikasi;
import com.turktrust.smyy.utils.HashFabrikasi;
import com.turktrust.smyy.utils.ImzaFabrikasi;
import com.turktrust.x509.AlgorithmIdentifier;
import com.turktrust.x509.Attribute;
import com.turktrust.x509.AttributeType;
import com.turktrust.x509.Certificate;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.xml.ws.BindingProvider;
import org.etsi.uri.ts102204.v1_1.AdditionalServiceType;
import org.etsi.uri.ts102204.v1_1.DataType;
import org.etsi.uri.ts102204.v1_1.MSSRegistrationReqType;
import org.etsi.uri.ts102204.v1_1.MSSRegistrationRespType;
import org.etsi.uri.ts102204.v1_1.MSSSignatureReqType;
import org.etsi.uri.ts102204.v1_1.MSSSignatureRespType;
import org.etsi.uri.ts102204.v1_1.MSSStatusReqType;
import org.etsi.uri.ts102204.v1_1.MSSStatusRespType;
import org.etsi.uri.ts102204.v1_1.MeshMemberType;
import org.etsi.uri.ts102204.v1_1.MessageAbstractType;
import org.etsi.uri.ts102204.v1_1.MessagingModeType;
import org.etsi.uri.ts102204.v1_1.MobileUserType;
import org.etsi.uri.ts102204.v1_1.MssURIType;
import org.etsi.uri.ts102204.v1_1.StatusType;
import tr.com.turktrust.mssp.MSSSignaturePortType;
import tr.com.turktrust.mssp.MSSSignatureService;

public class Dianta2IstemciNesnesi {
    public static final int DURUM_IMZA_TALEBI_ALINDI = 100;
    public static final int DURUM_RED_GECERSIZ_PARAMETRE = 101;
    public static final int DURUM_RED_GECERSIZ_VERI_UZUNLUGU = 103;
    public static final int DURUM_RED_BILINMEYEN_UYGULAMA = 104;
    public static final int DURUM_RED_GECERSIZ_KULLANICI = 105;
    public static final int DURUM_RED_ZAMAN_ASIMI = 208;
    public static final int DURUM_RED_KULLANICIYA_ULASILAMADI = 209;
    public static final int DURUM_RED_KULLANICININ_SERTIFIKASI_YOK = 422;
    public static final int DURUM_RED_KULLANICININ_SERTIFIKASI_DOGRULANAMADI = 425;
    public static final int DURUM_RED_SUNUCU_HATASI = 900;
    public static final int DURUM_SERTIFIKA_IPTAL_EDILMIS = 501;
    public static final int DURUM_IMZA_GECERLI = 502;
    public static final int DURUM_IMZA_GECERSIZ = 503;
    public static final int DURUM_ISLEM_DEVAM_EDIYOR = 504;
    public static final int DURUM_SERTIFIKA_KAYITLI = 408;
    public static final int DURUM_TALEP_GONDERILEMEDI_ISTEMCI_HATASI = -1;
    public static final int MOD_SENKRON = 1;
    public static final int MOD_ASENKRON = 2;
    public static final int SERTIFIKA_SORGU_BASARILI = 0;
    public static final int SERTIFIKA_SORGU_PARAMETRE_HATASI = 1;
    public static final int SERTIFIKA_SORGU_YAPILAMADI = 2;
    public static final int SERTIFIKA_SORGU_NUMARA_ICIN_GECERLI_SERTIFIKA_YOK = 3;
    public static final String SHA_1 = "1.3.14.3.2.26";
    public static final String SHA_256 = "2.16.840.1.101.3.4.2.1";
    private static final String MESSAGING_MODE_SYNCH = "synch";
    private static final String MESSAGING_MODE_ASYNCH_CLIENT_SERVER = "asynchClientServer";
    private static final String MESSAGING_MODE_ASYNCH_SERVER_SERVER = "asynchServerServer";
    private static final String VODAFONE_MSSP_ID = "http://dianta2.vodafone.com.tr";
    private static final String MSS_FORMAT_URI_CMS = "http://uri.etsi.org/TS102204/v1.1.2#CMS";
    private static final String MSS_FORMAT_URI_PKCS7 = "http://uri.etsi.org/TS102204/v1.1.2#PKCS7";
    private String msspServerAddress;
    private String hashAlgorithm = "2.16.840.1.101.3.4.2.1";
    private static int REQUEST_TIMEOUT = 0;
    private static int CONNECT_TIMEOUT = 0;
    private int sonSertifikaSorgusuBasariDurumu;
    private byte[] sonImzaTalebiSignedAttributes;
    private byte[] hashBytes;
    private SignedAttributes satts;

    public void baglant\u0131KurmaZamanAsimiSuresiBelirle(int saniye) {
        CONNECT_TIMEOUT = saniye * 1000;
    }

    public void baglant\u0131ZamanAsimiSureBelirle(int saniye) {
        REQUEST_TIMEOUT = saniye * 1000;
    }

    public Dianta2IstemciNesnesi(String msspIPVeyaHostname) {
        this.msspServerAddress = msspIPVeyaHostname;
        this.createStoreFile();
    }

    public Dianta2IstemciNesnesi(String msspIPVeyaHostname, boolean createStoreFile) {
        this.msspServerAddress = msspIPVeyaHostname;
        if (createStoreFile) {
            this.createStoreFile();
        }
    }

    private void createStoreFile() {
        try {
            String tempdir = System.getProperty("java.io.tmpdir");
            Class<Dianta2IstemciNesnesi> class_ = Dianta2IstemciNesnesi.class;
            ClassLoader classLoader = class_.getClassLoader();
            InputStream inStreamStore = classLoader.getResourceAsStream("com/turktrust/dianta2/api/vfssl.store");
            byte[] storeBytes = new byte[inStreamStore.available()];
            inStreamStore.read(storeBytes);
            inStreamStore.close();
            FileOutputStream fos = new FileOutputStream(tempdir + "vfssl.store");
            fos.write(storeBytes);
            fos.close();
            System.setProperty("javax.net.ssl.trustStore", tempdir + "vfssl.store");
            System.setProperty("javax.net.ssl.trustStorePassword", "turktrust");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public byte[] mobilImzaSertifikasiSorgula(String uygulamaID, String uygulamaParola, String cepTelefonNo) {
        try {
            if (uygulamaID == null || uygulamaParola == null || cepTelefonNo == null) {
                this.sonSertifikaSorgusuBasariDurumu = 1;
                return null;
            }
            String url = "https://" + this.msspServerAddress + "/Dianta2/MSS_SignatureService?wsdl";
            MSSSignatureService service = new MSSSignatureService();
            MSSSignaturePortType port = service.getMSSSignaturePort();
            BindingProvider provider = (BindingProvider)port;
            provider.getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
            if (REQUEST_TIMEOUT > 0) {
                provider.getRequestContext().put("com.sun.xml.ws.request.timeout", REQUEST_TIMEOUT);
            }
            if (CONNECT_TIMEOUT > 0) {
                provider.getRequestContext().put("com.sun.xml.ws.connect.timeout", CONNECT_TIMEOUT);
            }
            MSSRegistrationReqType regReqType = new MSSRegistrationReqType();
            regReqType.setMajorVersion(BigInteger.ONE);
            regReqType.setMinorVersion(BigInteger.ONE);
            MessageAbstractType.APInfo apInfo = new MessageAbstractType.APInfo();
            apInfo.setAPID(uygulamaID);
            apInfo.setAPPWD(uygulamaParola);
            apInfo.setAPTransID("111");
            GregorianCalendar gregCal = new GregorianCalendar();
            XMLGregorianCalendarImpl dt = new XMLGregorianCalendarImpl(gregCal);
            apInfo.setInstant(dt);
            regReqType.setAPInfo(apInfo);
            MeshMemberType meshMemType = new MeshMemberType();
            meshMemType.setURI(VODAFONE_MSSP_ID);
            MessageAbstractType.MSSPInfo msspInfo = new MessageAbstractType.MSSPInfo();
            msspInfo.setMSSPID(meshMemType);
            regReqType.setMSSPInfo(msspInfo);
            MobileUserType mobut = new MobileUserType();
            mobut.setMSISDN(cepTelefonNo);
            regReqType.setMobileUser(mobut);
            MSSRegistrationRespType regResp = port.mssRegistration(regReqType);
            if (regResp.getStatus().getStatusCode().getValue().intValue() == 408) {
                byte[] certBytes = regResp.getX509Certificate();
                this.sonSertifikaSorgusuBasariDurumu = 0;
                return certBytes;
            }
            this.sonSertifikaSorgusuBasariDurumu = 3;
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.sonSertifikaSorgusuBasariDurumu = 2;
            return null;
        }
    }

    public SertifikaDegerNesnesi mobilImzaSertifikasiSorgulaSDN(String uygulamaID, String uygulamaParola, String cepTelefonNo) {
        SertifikaDegerNesnesi sdn = null;
        String message = null;
        String message_detail = null;
        int statusCode = -1;
        try {
            if (uygulamaID == null || uygulamaParola == null || cepTelefonNo == null) {
                this.sonSertifikaSorgusuBasariDurumu = 1;
                sdn = new SertifikaDegerNesnesi(1, "uygulamaID, uygulamaParola, cepTelefonNo parametreleri bos gecilemez", "", null);
                return sdn;
            }
            String url = "https://" + this.msspServerAddress + "/Dianta2/MSS_SignatureService?wsdl";
            MSSSignatureService service = new MSSSignatureService();
            MSSSignaturePortType port = service.getMSSSignaturePort();
            BindingProvider provider = (BindingProvider)port;
            provider.getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
            MSSRegistrationReqType regReqType = new MSSRegistrationReqType();
            regReqType.setMajorVersion(BigInteger.ONE);
            regReqType.setMinorVersion(BigInteger.ONE);
            MessageAbstractType.APInfo apInfo = new MessageAbstractType.APInfo();
            apInfo.setAPID(uygulamaID);
            apInfo.setAPPWD(uygulamaParola);
            apInfo.setAPTransID("111");
            GregorianCalendar gregCal = new GregorianCalendar();
            XMLGregorianCalendarImpl dt = new XMLGregorianCalendarImpl(gregCal);
            apInfo.setInstant(dt);
            regReqType.setAPInfo(apInfo);
            MeshMemberType meshMemType = new MeshMemberType();
            meshMemType.setURI(VODAFONE_MSSP_ID);
            MessageAbstractType.MSSPInfo msspInfo = new MessageAbstractType.MSSPInfo();
            msspInfo.setMSSPID(meshMemType);
            regReqType.setMSSPInfo(msspInfo);
            MobileUserType mobut = new MobileUserType();
            mobut.setMSISDN(cepTelefonNo);
            regReqType.setMobileUser(mobut);
            MSSRegistrationRespType regResp = port.mssRegistration(regReqType);
            StatusType st = regResp.getStatus();
            statusCode = st.getStatusCode().getValue().intValue();
            message = st.getStatusMessage();
            message_detail = st.getStatusDetail() == null ? null : ((DataType)st.getStatusDetail().getAny().get(0)).getValue();
            this.sonSertifikaSorgusuBasariDurumu = statusCode == 408 ? 0 : 3;
            sdn = new SertifikaDegerNesnesi(statusCode, message, message_detail, regResp.getX509Certificate());
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.sonSertifikaSorgusuBasariDurumu = 2;
            sdn = new SertifikaDegerNesnesi(2, exc.getLocalizedMessage(), exc.getMessage(), null);
        }
        return sdn;
    }

    public int sonSertifikaSorgusuBasariDurumuAl() {
        return this.sonSertifikaSorgusuBasariDurumu;
    }

    public String goruntulenecekOzetHazirla(byte[] imzalanacakVeri, byte[] kullaniciSertifikaByteDizisi) {
        try {
            byte[] toBeSignedBytes = null;
            ObjectID idSignedData = new ObjectID("idSignedData", (Object)"1.2.840.113549.1.7.2");
            ContentInfo existingSignatureCinfo = null;
            boolean seriImza = false;
            try {
                existingSignatureCinfo = new ContentInfo("ci");
                existingSignatureCinfo.decode(imzalanacakVeri);
                if (((String)existingSignatureCinfo.getcontentType().getValue()).equals((String)idSignedData.getValue())) {
                    toBeSignedBytes = this.getInputForCounterSignature(existingSignatureCinfo);
                    seriImza = true;
                } else {
                    toBeSignedBytes = imzalanacakVeri;
                }
            }
            catch (Exception exc) {
                toBeSignedBytes = imzalanacakVeri;
            }
            Certificate cert = new Certificate("mobileSignCert");
            cert.decode(kullaniciSertifikaByteDizisi);
            byte[] hashOfTBSData = HashFabrikasi.hashAl((byte[])toBeSignedBytes, (String)this.hashAlgorithm);
            this.satts = CMSFabrikasi.signedAttributesOlustur((boolean)seriImza, (String)this.hashAlgorithm, (byte[])hashOfTBSData, (Certificate)cert, null, null, null, null, (boolean)false, null, null, null, null, null, null, null);
            this.sonImzaTalebiSignedAttributes = this.satts.getEncoded();
            this.hashBytes = HashFabrikasi.hashAl((byte[])this.sonImzaTalebiSignedAttributes, (String)this.hashAlgorithm);
            System.out.println("goruntulenecekOzetHazirla: " + Dianta2IstemciNesnesi.byteArrayToHexString(this.hashBytes, true));
            String hexStrOfFullFingerprint = Dianta2IstemciNesnesi.byteArrayToHexString(this.hashBytes, false);
            return this.formatHashStr(hexStrOfFullFingerprint);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public ImzaDegerNesnesi mobilImzaTalebiGonder(String uygulamaID, String uygulamaParola, String uygulamaIslemID, String cepTelefonNo, byte[] imzalanacakVeri, String kullaniciBilgilendirmeVerisi, byte[] kullaniciSertifikaByteDizisi, int islemeTaninanSure, int calismaModu, byte[] hash, byte[] sonImzaTalebiOzellik) {
        return this.mobilImzaTalebiGonder(uygulamaID, uygulamaParola, uygulamaIslemID, cepTelefonNo, imzalanacakVeri, kullaniciBilgilendirmeVerisi, kullaniciSertifikaByteDizisi, islemeTaninanSure, calismaModu, hash, sonImzaTalebiOzellik, false);
    }

    public ImzaDegerNesnesi mobilImzaTalebiGonder(String uygulamaID, String uygulamaParola, String uygulamaIslemID, String cepTelefonNo, byte[] imzalanacakVeri, String kullaniciBilgilendirmeVerisi, byte[] kullaniciSertifikaByteDizisi, int islemeTaninanSure, int calismaModu, byte[] hash, byte[] sonImzaTalebiOzellik, boolean rowImza) {
        try {
            if (calismaModu != 1 && calismaModu != 2) {
                ImzaDegerNesnesi res = new ImzaDegerNesnesi(101, null, uygulamaIslemID, null);
                return res;
            }
            if (uygulamaID == null || uygulamaParola == null || uygulamaIslemID == null || cepTelefonNo == null) {
                ImzaDegerNesnesi res = new ImzaDegerNesnesi(101, null, uygulamaIslemID, null);
                return res;
            }
            if (hash != null && hash.length > 0) {
                this.hashBytes = new byte[hash.length];
                System.arraycopy(hash, 0, this.hashBytes, 0, hash.length);
            }
            if (sonImzaTalebiOzellik != null && sonImzaTalebiOzellik.length > 0) {
                this.sonImzaTalebiSignedAttributes = new byte[sonImzaTalebiOzellik.length];
                System.arraycopy(sonImzaTalebiOzellik, 0, this.sonImzaTalebiSignedAttributes, 0, sonImzaTalebiOzellik.length);
                this.satts = new SignedAttributes("satts");
                this.satts.decode(sonImzaTalebiOzellik);
            }
            boolean seriImza = false;
            ObjectID idSignedData = new ObjectID("idSignedData", (Object)"1.2.840.113549.1.7.2");
            ContentInfo existingSignatureCinfo = null;
            if (imzalanacakVeri != null) {
                try {
                    existingSignatureCinfo = new ContentInfo("ci");
                    existingSignatureCinfo.decode(imzalanacakVeri);
                    seriImza = ((String)existingSignatureCinfo.getcontentType().getValue()).equals((String)idSignedData.getValue());
                }
                catch (Exception exc) {
                    seriImza = false;
                }
            }
            System.out.println("mobilImzaTalebiGonder: " + Dianta2IstemciNesnesi.byteArrayToHexString(this.hashBytes, true));
            String url = "https://" + this.msspServerAddress + "/Dianta2/MSS_SignatureService?wsdl";
            MSSSignatureService service = new MSSSignatureService();
            MSSSignaturePortType port = service.getMSSSignaturePort();
            BindingProvider provider = (BindingProvider)port;
            provider.getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
            if (REQUEST_TIMEOUT > 0) {
                provider.getRequestContext().put("com.sun.xml.ws.request.timeout", REQUEST_TIMEOUT);
            }
            if (CONNECT_TIMEOUT > 0) {
                provider.getRequestContext().put("com.sun.xml.ws.connect.timeout", CONNECT_TIMEOUT);
            }
            MSSSignatureReqType mssSignatureReq = new MSSSignatureReqType();
            mssSignatureReq.setMajorVersion(BigInteger.ONE);
            mssSignatureReq.setMinorVersion(BigInteger.ONE);
            MessageAbstractType.APInfo apInfo = new MessageAbstractType.APInfo();
            apInfo.setAPID(uygulamaID);
            apInfo.setAPPWD(uygulamaParola);
            apInfo.setAPTransID(uygulamaIslemID);
            GregorianCalendar gregCal = new GregorianCalendar();
            XMLGregorianCalendarImpl dt = new XMLGregorianCalendarImpl(gregCal);
            apInfo.setInstant(dt);
            mssSignatureReq.setAPInfo(apInfo);
            MeshMemberType meshMemType = new MeshMemberType();
            meshMemType.setURI(VODAFONE_MSSP_ID);
            MessageAbstractType.MSSPInfo msspInfo = new MessageAbstractType.MSSPInfo();
            msspInfo.setMSSPID(meshMemType);
            mssSignatureReq.setMSSPInfo(msspInfo);
            MobileUserType mobut = new MobileUserType();
            mobut.setMSISDN(cepTelefonNo);
            mssSignatureReq.setMobileUser(mobut);
            DataType dtype = new DataType();
            dtype.setMimeType("application/octet-stream");
            dtype.setEncoding("base64");
            Base64 b64 = new Base64();
            dtype.setValue(b64.encodeToString(this.hashBytes, false));
            mssSignatureReq.setDataToBeSigned(dtype);
            if (kullaniciBilgilendirmeVerisi != null && !kullaniciBilgilendirmeVerisi.equals("")) {
                DataType dtypeDispText = new DataType();
                dtypeDispText.setMimeType("text/plain");
                dtypeDispText.setValue(kullaniciBilgilendirmeVerisi);
                mssSignatureReq.setDataToBeDisplayed(dtypeDispText);
            }
            MSSSignatureReqType.AdditionalServices adServices = new MSSSignatureReqType.AdditionalServices();
            AdditionalServiceType astSigValidate = new AdditionalServiceType();
            MssURIType uriSigVal = new MssURIType();
            uriSigVal.setMssURI("http://uri.etsi.org/TS102204/v1.1.2#validate");
            astSigValidate.setDescription(uriSigVal);
            adServices.getService().add(astSigValidate);
            mssSignatureReq.setAdditionalServices(adServices);
            MssURIType pkcs7Uri = new MssURIType();
            pkcs7Uri.setMssURI(MSS_FORMAT_URI_PKCS7);
            mssSignatureReq.setMSSFormat(pkcs7Uri);
            mssSignatureReq.setTimeOut(new BigInteger(Integer.toString(islemeTaninanSure)));
            MessagingModeType mesModeType = null;
            if (calismaModu == 1) {
                mesModeType = MessagingModeType.fromValue(MESSAGING_MODE_SYNCH);
            } else if (calismaModu == 2) {
                mesModeType = MessagingModeType.fromValue(MESSAGING_MODE_ASYNCH_CLIENT_SERVER);
            }
            mssSignatureReq.setMessagingMode(mesModeType);
            MSSSignatureRespType result = null;
            result = port.mssSignature(mssSignatureReq);
            StatusType st = result.getStatus();
            int donusDurum = st.getStatusCode().getValue().intValue();
            String message = st.getStatusMessage();
            String message_detail = st.getStatusDetail() == null ? null : ((DataType)st.getStatusDetail().getAny().get(0)).getValue();
            String msspIslemIDStr = result.getMSSPTransID();
            ImzaDegerNesnesi res = null;
            if (calismaModu == 1 && donusDurum == 502) {
                byte[] sigBytes = result.getMSSSignature().getBase64Signature();
                if (rowImza) {
                    res = new ImzaDegerNesnesi(502, sigBytes, uygulamaIslemID, msspIslemIDStr, message, message_detail);
                } else if (!seriImza) {
                    ContentInfo resCinfo = Dianta2IstemciNesnesi.encapsulateSignatureInCMSSignedData(imzalanacakVeri, kullaniciSertifikaByteDizisi, this.hashAlgorithm, this.satts, sigBytes);
                    res = new ImzaDegerNesnesi(502, resCinfo.getEncoded(), uygulamaIslemID, msspIslemIDStr, message, message_detail);
                } else {
                    ContentInfo counterCinfo = Dianta2IstemciNesnesi.encapsulateSignatureInCMSSignedData(null, kullaniciSertifikaByteDizisi, this.hashAlgorithm, this.satts, sigBytes);
                    byte[] updatedCinfoBytes = this.appendNewCounterSignature(existingSignatureCinfo, counterCinfo.getEncoded());
                    res = new ImzaDegerNesnesi(502, updatedCinfoBytes, uygulamaIslemID, msspIslemIDStr, message, message_detail);
                }
                return res;
            }
            res = new ImzaDegerNesnesi(donusDurum, null, uygulamaIslemID, msspIslemIDStr, message, message_detail);
            return res;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            ImzaDegerNesnesi res = new ImzaDegerNesnesi(-1, null, uygulamaIslemID, null, exc.getLocalizedMessage(), exc.getMessage());
            return res;
        }
    }

    public byte[] sonMobilImzaTalebiImzalananOzelliklerAl() {
        return this.sonImzaTalebiSignedAttributes;
    }

    public byte[] sonParmakIziDegeriAl() {
        return this.hashBytes;
    }

    public ImzaDegerNesnesi mobilImzaSonucuSorgula(String uygulamaID, String uygulamaParola, String uygulamaIslemID, String msspIslemID, byte[] imzalananVeri, byte[] kullaniciSertifikaByteDizisi, byte[] imzalananOzellikler) {
        return this.mobilImzaSonucuSorgula(uygulamaID, uygulamaParola, uygulamaIslemID, msspIslemID, imzalananVeri, kullaniciSertifikaByteDizisi, imzalananOzellikler, false);
    }

    public ImzaDegerNesnesi mobilImzaSonucuSorgula(String uygulamaID, String uygulamaParola, String uygulamaIslemID, String msspIslemID, byte[] imzalananVeri, byte[] kullaniciSertifikaByteDizisi, byte[] imzalananOzellikler, boolean rowImza) {
        try {
            String message_detail;
            String url = "https://" + this.msspServerAddress + "/Dianta2/MSS_SignatureService?wsdl";
            MSSSignatureService service = new MSSSignatureService();
            MSSSignaturePortType port = service.getMSSSignaturePort();
            BindingProvider provider = (BindingProvider)port;
            provider.getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
            if (REQUEST_TIMEOUT > 0) {
                provider.getRequestContext().put("com.sun.xml.ws.request.timeout", REQUEST_TIMEOUT);
            }
            if (CONNECT_TIMEOUT > 0) {
                provider.getRequestContext().put("com.sun.xml.ws.connect.timeout", CONNECT_TIMEOUT);
            }
            MSSStatusReqType statusReq = new MSSStatusReqType();
            statusReq.setMajorVersion(BigInteger.ONE);
            statusReq.setMinorVersion(BigInteger.ONE);
            MessageAbstractType.APInfo apInfo = new MessageAbstractType.APInfo();
            apInfo.setAPID(uygulamaID);
            apInfo.setAPPWD(uygulamaParola);
            apInfo.setAPTransID(uygulamaIslemID);
            GregorianCalendar gregCal = new GregorianCalendar();
            XMLGregorianCalendarImpl dt = new XMLGregorianCalendarImpl(gregCal);
            apInfo.setInstant(dt);
            statusReq.setAPInfo(apInfo);
            MeshMemberType meshMemType = new MeshMemberType();
            meshMemType.setURI(VODAFONE_MSSP_ID);
            MessageAbstractType.MSSPInfo msspInfo = new MessageAbstractType.MSSPInfo();
            msspInfo.setMSSPID(meshMemType);
            statusReq.setMSSPInfo(msspInfo);
            statusReq.setMSSPTransID(msspIslemID);
            MSSStatusRespType statusResp = port.mssStatusQuery(statusReq);
            StatusType st = statusResp.getStatus();
            int donusDurum = st.getStatusCode().getValue().intValue();
            String message = st.getStatusMessage();
            String string = message_detail = st.getStatusDetail() == null ? null : ((DataType)st.getStatusDetail().getAny().get(0)).getValue();
            if (donusDurum == 502) {
                ImzaDegerNesnesi res;
                byte[] sigBytes = statusResp.getMSSSignature().getBase64Signature();
                if (rowImza) {
                    ImzaDegerNesnesi res2 = new ImzaDegerNesnesi(502, sigBytes, uygulamaIslemID, msspIslemID, message, message_detail);
                    return res2;
                }
                boolean seriImza = false;
                ContentInfo existingSignatureCinfo = null;
                if (imzalananVeri != null) {
                    ObjectID idSignedData = new ObjectID("idSignedData", (Object)"1.2.840.113549.1.7.2");
                    try {
                        existingSignatureCinfo = new ContentInfo("ci");
                        existingSignatureCinfo.decode(imzalananVeri);
                        seriImza = ((String)existingSignatureCinfo.getcontentType().getValue()).equals((String)idSignedData.getValue());
                    }
                    catch (Exception exc) {
                        seriImza = false;
                    }
                }
                this.satts = new SignedAttributes("satts");
                this.satts.decode(imzalananOzellikler);
                if (!seriImza) {
                    ContentInfo resCinfo = Dianta2IstemciNesnesi.encapsulateSignatureInCMSSignedData(imzalananVeri, kullaniciSertifikaByteDizisi, this.hashAlgorithm, this.satts, sigBytes);
                    res = new ImzaDegerNesnesi(502, resCinfo.getEncoded(), uygulamaIslemID, msspIslemID, message, message_detail);
                } else {
                    ContentInfo counterCinfo = Dianta2IstemciNesnesi.encapsulateSignatureInCMSSignedData(null, kullaniciSertifikaByteDizisi, this.hashAlgorithm, this.satts, sigBytes);
                    byte[] updatedCinfoBytes = this.appendNewCounterSignature(existingSignatureCinfo, counterCinfo.getEncoded());
                    res = new ImzaDegerNesnesi(502, updatedCinfoBytes, uygulamaIslemID, msspIslemID, message, message_detail);
                }
                return res;
            }
            ImzaDegerNesnesi res = new ImzaDegerNesnesi(donusDurum, null, uygulamaIslemID, msspIslemID, message, message_detail);
            return res;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            ImzaDegerNesnesi res = new ImzaDegerNesnesi(-1, null, uygulamaIslemID, null, exc.getLocalizedMessage(), exc.getMessage());
            return res;
        }
    }

    private static String byteArrayToHexString(byte[] input, boolean withSpace) {
        String res = "";
        for (int i = 0; i < input.length; ++i) {
            int val;
            if (i != 0 && i % 2 == 0 && withSpace) {
                res = res.concat(" ");
            }
            if ((val = input[i]) < 0) {
                val += 256;
            }
            if (val < 16) {
                res = res + "0";
            }
            res = res + Integer.toHexString(val);
        }
        return res.toUpperCase();
    }

    private String formatHashStr(String s) {
        if (s != null && s.length() > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < s.length() - 3; i += 4) {
                sb.append(s.substring(i, i + 4).toUpperCase());
                sb.append(' ');
            }
            if (sb.length() > 0) {
                s = sb.toString().trim();
            }
        }
        return s;
    }

    private static ContentInfo encapsulateSignatureInCMSSignedData(byte[] tbsBytes, byte[] signerCertBytes, String hashAlgorithmOID, SignedAttributes signedAttrs, byte[] signatureBytes) throws DecodeException {
        EncapsulatedContentInfo eci = new EncapsulatedContentInfo("eci");
        ObjectID idData = new ObjectID("idData", (Object)"1.2.840.113549.1.7.1");
        ObjectID idSignedData = new ObjectID("idSignedData", (Object)"1.2.840.113549.1.7.2");
        eci.setEncapsulatedContentType(idData);
        if (tbsBytes != null) {
            OctetString tbsOctet = new OctetString("tbsOctet", (Object)tbsBytes);
            eci.setEncapsulatedContent(tbsOctet);
        }
        eci.commitElementUpdate();
        SignerInfo sinfo = new SignerInfo("sinfo");
        ASN1Integer cmsVersion = new ASN1Integer("cmsVersion", (Object)"1");
        Certificate signerCert = new Certificate("signerCert");
        signerCert.decode(signerCertBytes);
        IssuerAndSerialNumber iasn = new IssuerAndSerialNumber("iasn");
        iasn.setissuer(signerCert.gettbsCertificate().getissuer());
        CertificateSerialNumber signerSerialNo = new CertificateSerialNumber("signerSerial");
        signerSerialNo.setValue((Object)signerCert.gettbsCertificate().getserialNumber());
        iasn.setserialNumber(signerSerialNo);
        iasn.commitElementUpdate();
        SignerIdentifier sid = new SignerIdentifier("sid");
        sid.setIssuerAndSerialNumber(iasn);
        ObjectID hashObjId = new ObjectID("hashObjId");
        hashObjId.setValue((Object)hashAlgorithmOID);
        AlgorithmIdentifier hashAlgId = new AlgorithmIdentifier("hashAlgId");
        hashAlgId.setalgorithm(hashObjId);
        hashAlgId.commitElementUpdate();
        String signatureAlgOID = ImzaFabrikasi.mapHashOIDToSignatureAlgorithmOID((String)hashAlgorithmOID);
        ObjectID rsaWithHashobjId = new ObjectID("RSAwithHash");
        rsaWithHashobjId.setValue((Object)signatureAlgOID);
        Null parNull2 = new Null("Null_par");
        Any anyNull2 = new Any("Any_null");
        anyNull2.setValue((Object)parNull2);
        AlgorithmIdentifier rsaAlgId = new AlgorithmIdentifier("RSAwithHash");
        rsaAlgId.setalgorithm(rsaWithHashobjId);
        rsaAlgId.setparameters(anyNull2);
        rsaAlgId.commitElementUpdate();
        OctetString signatureOcts = new OctetString("signatureOcts", (Object)signatureBytes);
        sinfo.setCMSVersion(cmsVersion);
        sinfo.setSignerIdentifier(sid);
        sinfo.setDigestAlgorithm(hashAlgId);
        sinfo.setSignedAttributes(signedAttrs);
        sinfo.setSignatureAlgorithm(rsaAlgId);
        sinfo.setSignature(signatureOcts);
        sinfo.commitElementUpdate();
        SignedData sd = new SignedData("sd");
        ASN1Integer sdVersion = new ASN1Integer("sdVersion", (Object)"3");
        DigestAlgorithmIdentifiers dais = new DigestAlgorithmIdentifiers("dais");
        dais.addElement((ASN1Object)hashAlgId);
        X509CertificateSet certset = new X509CertificateSet("certset");
        certset.addElement((ASN1Object)signerCert);
        SignerInfos sinfos = new SignerInfos("sinfos");
        sinfos.addElement((ASN1Object)sinfo);
        sd.setCMSVersion(sdVersion);
        sd.setDigestAlgorithms(dais);
        sd.setEncapContentInfo(eci);
        sd.setCertificates(certset);
        sd.setSignerInfos(sinfos);
        sd.commitElementUpdate();
        ContentInfo ci = new ContentInfo("ci");
        ci.setcontentType(idSignedData);
        Any contSignedData = new Any("contSignedData", (Object)sd);
        ci.setcontent(contSignedData);
        ci.commitElementUpdate();
        return ci;
    }

    private byte[] getInputForCounterSignature(ContentInfo existingSignatureCinfo) {
        try {
            byte[] existingSignatureBytes = existingSignatureCinfo.getEncoded();
            Vector previousCounterSigs = Dianta2IstemciNesnesi.getCounterSignaturesList(existingSignatureBytes);
            SignerInfo previousSinfo = null;
            byte[] sdBytes = (byte[])existingSignatureCinfo.getcontent().getValue();
            SignedData topLevelSignedData = new SignedData("topLevelSignedData");
            topLevelSignedData.setTaggingMethod(2);
            topLevelSignedData.setTagClass((byte)-128);
            topLevelSignedData.setTagNumber(0);
            topLevelSignedData.decode(sdBytes);
            if (previousCounterSigs.size() == 0) {
                previousSinfo = (SignerInfo)((Vector)topLevelSignedData.getSignerInfos().getValue()).elementAt(0);
            } else {
                Vector stripped = Dianta2IstemciNesnesi.removeLastCounterSignature(existingSignatureBytes);
                byte[] outerSinfoBytes = (byte[])stripped.elementAt(1);
                previousSinfo = new SignerInfo("outerSinfo");
                previousSinfo.decode(outerSinfoBytes);
            }
            byte[] tbsData = (byte[])previousSinfo.getSignature().getValue();
            return tbsData;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private byte[] appendNewCounterSignature(ContentInfo existingSignatureCinfo, byte[] newSignatureCinfoBytes) {
        try {
            ContentInfo cinfoYeni = new ContentInfo("cinfoYeni");
            cinfoYeni.decode(newSignatureCinfoBytes);
            SignerInfo yeniSinfo = null;
            byte[] yeniSdBytes = (byte[])cinfoYeni.getcontent().getValue();
            SignedData yeniSignedData = new SignedData("yeniSignedData");
            yeniSignedData.setTaggingMethod(2);
            yeniSignedData.setTagClass((byte)-128);
            yeniSignedData.setTagNumber(0);
            yeniSignedData.decode(yeniSdBytes);
            yeniSinfo = (SignerInfo)((Vector)yeniSignedData.getSignerInfos().getValue()).elementAt(0);
            Certificate yeniSignerCert = (Certificate)((Vector)yeniSignedData.getCertificates().getValue()).elementAt(0);
            byte[] existingSignatureBytes = existingSignatureCinfo.getEncoded();
            Vector previousCounterSigs = Dianta2IstemciNesnesi.getCounterSignaturesList(existingSignatureBytes);
            SignerInfo previousSinfo = null;
            byte[] sdBytes = (byte[])existingSignatureCinfo.getcontent().getValue();
            SignedData topLevelSignedData = new SignedData("topLevelSignedData");
            topLevelSignedData.setTaggingMethod(2);
            topLevelSignedData.setTagClass((byte)-128);
            topLevelSignedData.setTagNumber(0);
            topLevelSignedData.decode(sdBytes);
            if (previousCounterSigs.size() == 0) {
                previousSinfo = (SignerInfo)((Vector)topLevelSignedData.getSignerInfos().getValue()).elementAt(0);
            } else {
                Vector stripped = Dianta2IstemciNesnesi.removeLastCounterSignature(existingSignatureBytes);
                byte[] outerSinfoBytes = (byte[])stripped.elementAt(1);
                previousSinfo = new SignerInfo("outerSinfo");
                previousSinfo.decode(outerSinfoBytes);
            }
            Attribute attCounterSig = new Attribute("attCounterSig");
            AttributeType attTypeCounterSig = new AttributeType("attTypeCounterSig");
            attTypeCounterSig.setValue((Object)"1.2.840.113549.1.9.6");
            SetOf attValsCounterSig = new SetOf("attValsSigCert", (Object)new SignerInfo());
            attValsCounterSig.addElement((ASN1Object)yeniSinfo);
            attCounterSig.settype(attTypeCounterSig);
            attCounterSig.setvalues(attValsCounterSig);
            attCounterSig.commitElementUpdate();
            if (previousSinfo.getUnsignedAttributes() != null && previousSinfo.getUnsignedAttributes().getValue() != null) {
                ((Vector)previousSinfo.getUnsignedAttributes().getValue()).add(attCounterSig);
            } else {
                UnsignedAttributes unsignedAttrs = new UnsignedAttributes("unsignedAttrs");
                unsignedAttrs.addElement((ASN1Object)attCounterSig);
                previousSinfo.setUnsignedAttributes(unsignedAttrs);
            }
            if (previousCounterSigs.size() > 0) {
                SignerInfo childSinfo = previousSinfo;
                for (int i = 0; i < previousCounterSigs.size() - 1; ++i) {
                    byte[] parentCinfoBytes = (byte[])previousCounterSigs.elementAt(i);
                    ContentInfo parentCinfo = new ContentInfo("ci");
                    parentCinfo.decode(parentCinfoBytes);
                    byte[] parentSdataBytes = (byte[])parentCinfo.getcontent().getValue();
                    SignedData parentSdata = new SignedData("sd");
                    parentSdata.setTaggingMethod(2);
                    parentSdata.setTagClass((byte)-128);
                    parentSdata.setTagNumber(0);
                    parentSdata.decode(parentSdataBytes);
                    SignerInfo parentSinfo = (SignerInfo)((Vector)parentSdata.getSignerInfos().getValue()).elementAt(0);
                    Attribute attCounterSigParent = new Attribute("attCounterSig");
                    SetOf attValsCounterSigParent = new SetOf("attValsSigCert", (Object)new SignerInfo());
                    attValsCounterSigParent.addElement((ASN1Object)childSinfo);
                    attCounterSigParent.settype(attTypeCounterSig);
                    attCounterSigParent.setvalues(attValsCounterSigParent);
                    attCounterSigParent.commitElementUpdate();
                    if (parentSinfo.getUnsignedAttributes() != null && parentSinfo.getUnsignedAttributes().getValue() != null) {
                        ((Vector)parentSinfo.getUnsignedAttributes().getValue()).add(attCounterSigParent);
                    } else {
                        UnsignedAttributes unsignedAttrs = new UnsignedAttributes("unsignedAttrs");
                        unsignedAttrs.addElement((ASN1Object)attCounterSigParent);
                        parentSinfo.setUnsignedAttributes(unsignedAttrs);
                    }
                    childSinfo = parentSinfo;
                }
                SignerInfo topSinfo = (SignerInfo)((Vector)topLevelSignedData.getSignerInfos().getValue()).elementAt(0);
                Attribute attCounterSigParent = new Attribute("attCounterSig");
                SetOf attValsCounterSigParent = new SetOf("attValsSigCert", (Object)new SignerInfo());
                attValsCounterSigParent.addElement((ASN1Object)childSinfo);
                attCounterSigParent.settype(attTypeCounterSig);
                attCounterSigParent.setvalues(attValsCounterSigParent);
                attCounterSigParent.commitElementUpdate();
                if (topSinfo.getUnsignedAttributes() != null && topSinfo.getUnsignedAttributes().getValue() != null) {
                    Vector topUnsignedAttsVec = (Vector)topSinfo.getUnsignedAttributes().getValue();
                    boolean updated = false;
                    for (int k = 0; k < topUnsignedAttsVec.size(); ++k) {
                        Attribute tempAtt = (Attribute)topUnsignedAttsVec.elementAt(k);
                        AttributeType tempType = tempAtt.gettype();
                        if (!((String)tempType.getValue()).equals("1.2.840.113549.1.9.6")) continue;
                        tempAtt.setvalues(attValsCounterSigParent);
                        tempAtt.commitElementUpdate();
                        updated = true;
                    }
                    if (!updated) {
                        topUnsignedAttsVec.addElement(attCounterSigParent);
                    }
                } else {
                    UnsignedAttributes unsignedAttrs = new UnsignedAttributes("unsignedAttrs");
                    unsignedAttrs.addElement((ASN1Object)attCounterSigParent);
                    topSinfo.setUnsignedAttributes(unsignedAttrs);
                }
            }
            Vector existingCertsVec = (Vector)topLevelSignedData.getCertificates().getValue();
            boolean foundCert = false;
            byte[] signerCertBytes = yeniSignerCert.getEncoded();
            for (int j = 0; j < existingCertsVec.size(); ++j) {
                Certificate tempCert = (Certificate)existingCertsVec.elementAt(j);
                if (!Dianta2IstemciNesnesi.areByteArraysEqual(signerCertBytes, tempCert.getEncoded())) continue;
                foundCert = true;
                break;
            }
            if (!foundCert) {
                ((Vector)topLevelSignedData.getCertificates().getValue()).addElement(yeniSignerCert);
            }
            ContentInfo ci = new ContentInfo("ci");
            ObjectID conTypeSignedDataObjId = new ObjectID("signedData", (Object)"1.2.840.113549.1.7.2");
            ci.setcontentType(conTypeSignedDataObjId);
            Any contSignedData = new Any("contSignedData", (Object)topLevelSignedData);
            ci.setcontent(contSignedData);
            ci.commitElementUpdate();
            return ci.getEncoded();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    protected static Vector getCounterSignaturesList(byte[] input) {
        try {
            Vector<byte[]> result = new Vector<byte[]>();
            int count = Dianta2IstemciNesnesi.countCounterSignatures(input);
            if (count == -1) {
                return null;
            }
            if (count == 0) {
                return result;
            }
            Vector initialStripped = Dianta2IstemciNesnesi.removeLastCounterSignature(input);
            byte[] allInnerSigs = (byte[])initialStripped.elementAt(0);
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(allInnerSigs);
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            byte[] beingProcessedBytes = allInnerSigs;
            for (int remaining = count; remaining > 1; --remaining) {
                Vector stripped = Dianta2IstemciNesnesi.removeLastCounterSignature(beingProcessedBytes);
                byte[] innerSigs = (byte[])stripped.elementAt(0);
                byte[] outerSinfoBytes = (byte[])stripped.elementAt(1);
                byte[] parentSinfoBytes = (byte[])stripped.elementAt(2);
                SignerInfo outerSinfo = new SignerInfo("outerSinfo");
                outerSinfo.decode(outerSinfoBytes);
                SignerInfo parentSinfo = new SignerInfo("parentSinfo");
                parentSinfo.decode(parentSinfoBytes);
                byte[] outerCinfoBytes = Dianta2IstemciNesnesi.putCounterSigInSeparateContentInfo(outerSinfo, (byte[])parentSinfo.getSignature().getValue(), sd.getCertificates());
                result.add(outerCinfoBytes);
                beingProcessedBytes = innerSigs;
            }
            result.add(beingProcessedBytes);
            return result;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    protected static int countCounterSignatures(byte[] input) {
        try {
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(input);
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            SignerInfo sinfo = (SignerInfo)((Vector)sd.getSignerInfos().getValue()).elementAt(0);
            if (sinfo.getUnsignedAttributes() == null) {
                return 0;
            }
            int count = 0;
            Vector unsignedAttsVec = (Vector)sinfo.getUnsignedAttributes().getValue();
            for (int i = 0; i < unsignedAttsVec.size(); ++i) {
                Attribute tempAtt = (Attribute)unsignedAttsVec.elementAt(i);
                AttributeType tempType = tempAtt.gettype();
                if (!((String)tempType.getValue()).equals("1.2.840.113549.1.9.6")) continue;
                Any counterSigAttVal = (Any)((Vector)tempAtt.getvalues().getValue()).elementAt(0);
                SignerInfo counterSignerInfo = new SignerInfo("counterSignerInfo");
                counterSignerInfo.decode((byte[])counterSigAttVal.getValue());
                byte[] sepContentInfo = Dianta2IstemciNesnesi.putCounterSigInSeparateContentInfo(counterSignerInfo, (byte[])sinfo.getSignature().getValue(), sd.getCertificates());
                count = 1 + Dianta2IstemciNesnesi.countCounterSignatures(sepContentInfo);
            }
            return count;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return -1;
        }
    }

    private static byte[] putCounterSigInSeparateContentInfo(SignerInfo counterSignerInfo, byte[] signatureInputBytes, X509CertificateSet certificateSet) {
        try {
            EncapsulatedContentInfo eci = new EncapsulatedContentInfo("eci");
            ObjectID idData = new ObjectID("idData", (Object)"1.2.840.113549.1.7.1");
            eci.setEncapsulatedContentType(idData);
            OctetString tbsOctet = new OctetString("tbsOctet", (Object)signatureInputBytes);
            eci.setEncapsulatedContent(tbsOctet);
            eci.commitElementUpdate();
            SignedData sd = new SignedData("sd");
            ASN1Integer sdVersion = new ASN1Integer("sdVersion", (Object)"3");
            DigestAlgorithmIdentifiers dais = new DigestAlgorithmIdentifiers("dais");
            dais.addElement((ASN1Object)counterSignerInfo.getDigestAlgorithm());
            SignerInfos sinfos = new SignerInfos("sinfos");
            sinfos.addElement((ASN1Object)counterSignerInfo);
            sd.setCMSVersion(sdVersion);
            sd.setDigestAlgorithms(dais);
            sd.setEncapContentInfo(eci);
            sd.setCertificates(certificateSet);
            sd.setSignerInfos(sinfos);
            sd.commitElementUpdate();
            ContentInfo ci = new ContentInfo("ci");
            ObjectID idSignedData = new ObjectID("idSignedData", (Object)"1.2.840.113549.1.7.2");
            ci.setcontentType(idSignedData);
            Any contSignedData = new Any("contSignedData", (Object)sd);
            ci.setcontent(contSignedData);
            ci.commitElementUpdate();
            return ci.getEncoded();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    protected static Vector removeLastCounterSignature(byte[] input) {
        try {
            Vector<byte[]> result = new Vector<byte[]>();
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(input);
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            SignerInfo sinfo = (SignerInfo)((Vector)sd.getSignerInfos().getValue()).elementAt(0);
            if (sinfo.getUnsignedAttributes() == null) {
                result.add(input);
                return result;
            }
            boolean foundAtleastOneCounterSignature = false;
            boolean searchComplete = false;
            int count = 0;
            Vector unsignedAttsVec = (Vector)sinfo.getUnsignedAttributes().getValue();
            int attributeIndex = -1;
            SignerInfo parentSignerInfo = sinfo;
            SignerInfo childSignerInfo = null;
            Vector<SignerInfo> sinfoVec = new Vector<SignerInfo>();
            Vector<Integer> counterIndexVec = new Vector<Integer>();
            while (!searchComplete) {
                boolean foundCounterSignatureInNode = false;
                for (int i = 0; i < unsignedAttsVec.size(); ++i) {
                    Attribute tempAtt = (Attribute)unsignedAttsVec.elementAt(i);
                    AttributeType tempType = tempAtt.gettype();
                    if (!((String)tempType.getValue()).equals("1.2.840.113549.1.9.6")) continue;
                    ++count;
                    foundAtleastOneCounterSignature = true;
                    foundCounterSignatureInNode = true;
                    attributeIndex = i;
                    Any counterSigAttVal = (Any)((Vector)tempAtt.getvalues().getValue()).elementAt(0);
                    SignerInfo counterSignerInfo = new SignerInfo("counterSignerInfo");
                    counterSignerInfo.decode((byte[])counterSigAttVal.getValue());
                    if (childSignerInfo != null) {
                        parentSignerInfo = childSignerInfo;
                    }
                    childSignerInfo = counterSignerInfo;
                    sinfoVec.add(parentSignerInfo);
                    counterIndexVec.add(new Integer(i));
                    unsignedAttsVec = (Vector)childSignerInfo.getUnsignedAttributes().getValue();
                    break;
                }
                if (foundCounterSignatureInNode) continue;
                searchComplete = true;
            }
            if (foundAtleastOneCounterSignature) {
                Vector uavecToUpdate = (Vector)parentSignerInfo.getUnsignedAttributes().getValue();
                uavecToUpdate.removeElementAt(attributeIndex);
                parentSignerInfo.getUnsignedAttributes().setValue((Object)uavecToUpdate);
                if (count > 1) {
                    for (int j = sinfoVec.size() - 2; j >= 0; --j) {
                        SignerInfo upperSignerInfo = (SignerInfo)sinfoVec.elementAt(j);
                        SignerInfo lowerSignerInfo = (SignerInfo)sinfoVec.elementAt(j + 1);
                        Any updatedCounterSigAttVal = new Any("updatedCounterSigAttVal", (Object)lowerSignerInfo);
                        int upperLevelAttIndex = (Integer)counterIndexVec.elementAt(j);
                        Vector upperAttributes = (Vector)upperSignerInfo.getUnsignedAttributes().getValue();
                        Attribute tbuAtt = (Attribute)upperAttributes.elementAt(upperLevelAttIndex);
                        ((Vector)tbuAtt.getvalues().getValue()).removeElementAt(0);
                        ((Vector)tbuAtt.getvalues().getValue()).add(0, updatedCounterSigAttVal);
                    }
                }
                ContentInfo cinfo = new ContentInfo("cinfo");
                ObjectID idSignedData = new ObjectID("idSignedData", (Object)"1.2.840.113549.1.7.2");
                cinfo.setcontentType(idSignedData);
                Any contSignedData = new Any("contSignedData", (Object)sd);
                cinfo.setcontent(contSignedData);
                cinfo.commitElementUpdate();
                result.add(cinfo.getEncoded());
                result.add(childSignerInfo.getEncoded());
                result.add(parentSignerInfo.getEncoded());
                return result;
            }
            result.add(input);
            return result;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static boolean areByteArraysEqual(byte[] bar1, byte[] bar2) {
        if (bar1.length != bar2.length) {
            return false;
        }
        for (int i = 0; i < bar1.length; ++i) {
            if (bar1[i] == bar2[i]) continue;
            return false;
        }
        return true;
    }

    private static void trustAllHttpsCertificates() throws Exception {
        TrustManager tm = new TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public boolean isServerTrusted(X509Certificate[] certs) {
                return true;
            }

            public boolean isClientTrusted(X509Certificate[] certs) {
                return true;
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }
        };
        TrustManager[] trustAllCerts = new TrustManager[]{tm};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    public String getOzetAlgoritmasi() {
        return this.hashAlgorithm;
    }

    public void setOzetAlgoritmasi(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }
}

