/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.api;

import com.turktrust.api.DogrulamaLog;
import com.turktrust.api.ImzaIslemNesnesi;
import com.turktrust.api.SertifikaBilgiNesnesi;
import com.turktrust.api.TimestampException;
import com.turktrust.asn1.Any;
import com.turktrust.asn1.GeneralizedTime;
import com.turktrust.asn1.Null;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.SetOf;
import com.turktrust.asn1.UTCTime;
import com.turktrust.cms.CertificateRevocationLists;
import com.turktrust.cms.SignedData;
import com.turktrust.cms.SignerInfo;
import com.turktrust.cms.SignerInfos;
import com.turktrust.cms.UnsignedAttributes;
import com.turktrust.ess.IssuerSerial;
import com.turktrust.ltes.CRLIdentifier;
import com.turktrust.ltes.CRLListId;
import com.turktrust.ltes.CRLValidatedId;
import com.turktrust.ltes.CertificateValues;
import com.turktrust.ltes.CompleteCertificateRefs;
import com.turktrust.ltes.CompleteRevocationRefs;
import com.turktrust.ltes.CrlOcspRef;
import com.turktrust.ltes.OcspIdentifier;
import com.turktrust.ltes.OcspListId;
import com.turktrust.ltes.OcspResponsesId;
import com.turktrust.ltes.OtherCertId;
import com.turktrust.ltes.OtherHash;
import com.turktrust.ltes.OtherHashAlgAndValue;
import com.turktrust.ltes.RevocationValues;
import com.turktrust.ocsp.BasicOCSPResponse;
import com.turktrust.ocsp.OCSPResponse;
import com.turktrust.ocsp.ResponderID;
import com.turktrust.ocsp.RevokedInfo;
import com.turktrust.ocsp.SingleResponse;
import com.turktrust.pkcs7.ContentInfo;
import com.turktrust.smyy.utils.CRLFabrikasi;
import com.turktrust.smyy.utils.DateComparator;
import com.turktrust.smyy.utils.HashFabrikasi;
import com.turktrust.smyy.utils.OCSPFabrikasi;
import com.turktrust.smyy.utils.SertifikaFabrikasi;
import com.turktrust.smyy.utils.TSTokenComparator;
import com.turktrust.smyy.utils.TimestampFabrikasi;
import com.turktrust.timestamp.MessageImprint;
import com.turktrust.timestamp.PKIFailureInfo;
import com.turktrust.timestamp.PKIStatusInfo;
import com.turktrust.timestamp.TimeStampReq;
import com.turktrust.timestamp.TimeStampResp;
import com.turktrust.x509.AccessDescription;
import com.turktrust.x509.AlgorithmIdentifier;
import com.turktrust.x509.Attribute;
import com.turktrust.x509.AttributeType;
import com.turktrust.x509.AuthorityInfoAccessSyntax;
import com.turktrust.x509.CRLDistributionPoints;
import com.turktrust.x509.Certificate;
import com.turktrust.x509.CertificateList;
import com.turktrust.x509.DistributionPoint;
import com.turktrust.x509.DistributionPointName;
import com.turktrust.x509.Extension;
import com.turktrust.x509.Extensions;
import com.turktrust.x509.GeneralName;
import com.turktrust.x509.GeneralNames;
import com.turktrust.x509.Name;
import com.turktrust.x509.RevokedCertificate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class UzunDonemliIslemler {
    private static final String SIGNATURE_TIMESTAMP_ATTRIBUTE_OBJ_ID = "1.2.840.113549.1.9.16.2.14";
    private static final String CERTIFICATE_REFS_ATTRIBUTE_OBJ_ID = "1.2.840.113549.1.9.16.2.21";
    private static final String REVOCATION_REFS_ATTRIBUTE_OBJ_ID = "1.2.840.113549.1.9.16.2.22";
    private static final String CERTIFICATE_VALUES_ATTRIBUTE_OBJ_ID = "1.2.840.113549.1.9.16.2.23";
    private static final String REVOCATION_VALUES_ATTRIBUTE_OBJ_ID = "1.2.840.113549.1.9.16.2.24";
    private static final String ARCHIVE_TIMESTAMP_ATTRIBUTE_OBJ_ID = "1.2.840.113549.1.9.16.2.27";
    private static final String ARCHIVE_TIMESTAMP_V2_ATTRIBUTE_OBJ_ID = "1.2.840.113549.1.9.16.2.48";
    public static final int ISLEM_TAMAM = 11;
    public static final int ISLEM_YAPILIRKEN_HATA_OLUSTU = 12;
    public static final int DOGRULAMA_SONUCU_ZAMAN_DAMGASI_GECERLI = 20;
    public static final int DOGRULAMA_SONUCU_ZAMAN_DAMGASI_GECERSIZ = 21;
    public static final int DOGRULAMA_ISLEMINDE_HATA_OLUSTU = 22;
    public static final int DOGRULAMA_ISLEMINDE_BILINMEYEN_IMZA_ALGORITMASI = 23;
    public static final int DOGRULAMA_ISLEMINDE_SERTIFIKA_DOGRULANAMADI = 24;
    public static final int DOGRULAMA_ISLEMINDE_IMZA_VERI_YAPISI_HATALI = 25;
    public static final int DOGRULAMA_ISLEMINDE_ZAMAN_DAMGASI_SAHIBI_SERTIFIKA_BULUNAMADI = 26;
    public static final int DOGRULAMA_ISLEMINDE_ZAMAN_DAMGASI_VERI_YAPISI_HATALI = 27;
    public static final int DOGRULAMA_ISLEMINDE_OCSP_CEVAP_YAPISI_BOZUK = 28;
    public static final int DOGRULAMA_ISLEMINDE_OCSP_CEVABI_DOGRULANAMADI = 29;
    public static final int DOGRULAMA_ISLEMINDE_OCSP_CEVAP_SERTIFIKASI_DOGRULANAMADI = 111;
    public static final int DOGRULAMA_ISLEMINDE_OCSP_CEVABI_ESKI = 112;
    public static final int DOGRULAMA_ISLEMINDE_OCSP_CEVABI_BASKA_SERTIFIKAYA_AIT = 113;
    public static final int DOGRULAMA_ISLEMINDE_OCSP_CEVABI_SERTIFIKA_IPTAL = 114;
    public static final int DOGRULAMA_ISLEMINDE_OCSP_CEVABI_SERTIFIKA_BILINMIYOR = 115;
    public static final int DOGRULAMA_ISLEMINDE_CRL_VERI_YAPISI_BOZUK = 116;
    public static final int DOGRULAMA_ISLEMINDE_CRL_DOGRULANAMADI = 117;
    public static final int DOGRULAMA_ISLEMINDE_CRL_TARIHI_UYGUN_DEGIL = 118;
    public static final int DOGRULAMA_ISLEMINDE_CRL_SERTIFIKA_IPTAL = 119;
    public static final int DOGRULAMA_ISLEMINDE_ALT_KOK_IPTAL = 120;
    public static final int DOGRULAMA_ISLEMINDE_KOK_CRL_BULUNAMADI = 121;
    public static final int DOGRULAMA_ISLEMINDE_IMZA_ZAMANI_SERTIFIKA_SURESININ_DISINDA = 81;
    public static final int ZAMAN_DAMGASI_BASARIYLA_OLUSTURULDU = 30;
    public static final int ZAMAN_DAMGASI_SUNUCUSUNA_BAGLANTI_KURULAMADI = 31;
    public static final int ZAMAN_DAMGASI_TALEBI_SUNUCU_TARAFINDAN_REDDEDILDI = 32;
    public static final int ZAMAN_DAMGASI_ICIN_VERILEN_IMZA_VERI_YAPISI_HATALI = 33;
    public static final int ZAMAN_DAMGASI_ICIN_VERILEN_VERI_BOS = 34;
    public static final int ZD_RED_DESTEKLENMEYEN_ALGORITMA = 40;
    public static final int ZD_RED_PROTOKOL_HATASI = 41;
    public static final int ZD_RED_TALEP_YAPI_HATASI = 42;
    public static final int ZD_RED_ZAMAN_BILGISINE_ERISIM_YOK = 43;
    public static final int ZD_RED_DESTEKLENMEYEN_ILKE = 44;
    public static final int ZD_RED_DESTEKLENMEYEN_UZANTI = 45;
    public static final int ZD_RED_EK_BILGI_BULUNMUYOR = 46;
    public static final int ZD_RED_SUNUCU_SISTEM_HATASI = 47;
    private static final int ESC_BASARIYLA_OLUSTURULDU = 50;
    private static final int ESC_OLUSTURULMADI_VERI_YAPISI_HATALI = 51;
    private static final int ESC_OLUSTURULMADI_ZAMAN_DAMGASI_YOK = 52;
    private static final int ESC_OLUSTURULMADI_ESHS_SERTIFIKA_LISTESI_GECERSIZ = 53;
    private static final int ESC_OLUSTURULMADI_ESHS_SERTIFIKASI_IPTAL_EDILMIS = 54;
    private static final int ESC_OLUSTURULMADI_ESHS_SERTIFIKASI_TANINMIYOR = 55;
    private static final int ESC_OLUSTURULMADI_OCSP_VE_CRL_ERISIMI_YOK = 56;
    public static final int OCSP_SORGU_YAPILAMAZ_VERI_YAPISI_HATALI = 60;
    public static final int OCSP_SORGU_YAPILAMAZ_ESHS_SERTIFIKASI_BULUNAMADI = 61;
    public static final int OCSP_ADRESI_BULUNAMADI = 62;
    public static final int OCSP_BAGLANTISI_KURULAMADI = 63;
    public static final int OCSP_SUNUCUSUNDA_HATA_OLUSTU = 64;
    public static final int OCSP_YANIT_GECERSIZ = 65;
    public static final int OCSP_YANIT_DOGRULAMA_SERTIFIKASI_BULUNAMADI = 66;
    public static final int OCSP_YANIT_DOGRULAMA_ISLEMINDE_HATA = 67;
    public static final int OCSP_YANIT_BILINMEYEN_IMZA_ALGORITMASI = 68;
    public static final int OCSP_SERTIFIKA_GECERLI = 69;
    public static final int OCSP_SERTIFIKA_IPTAL_EDILMIS = 70;
    public static final int OCSP_SERTIFIKA_BILINMIYOR = 71;
    public static final int OCSP_SORGUSU_YAPILDI = 72;
    public static final int ESXLONG_BASARIYLA_OLUSTURULDU = 80;
    public static final int ESXLONG_OLUSTURULMADI_VERI_YAPISI_HATALI = 81;
    public static final int ESXLONG_OLUSTURULMADI_ZAMAN_DAMGASI_YOK = 82;
    public static final int ESXLONG_OLUSTURULMADI_ESHS_SERTIFIKA_LISTESI_GECERSIZ = 83;
    public static final int ESXLONG_OLUSTURULMADI_ESHS_SERTIFIKASI_IPTAL_EDILMIS = 84;
    public static final int ESXLONG_OLUSTURULMADI_ESHS_SERTIFIKASI_TANINMIYOR = 85;
    public static final int ESXLONG_OLUSTURULMADI_OCSP_VE_CRL_ERISIMI_YOK = 86;
    public static final int ESXLONG_YAPISI_VE_IMZA_DOGRULANDI = 90;
    public static final int ESXLONG_YAPISI_HATALI = 91;
    public static final int ESXLONG_YAPISI_DOGRULANAMADI_GECERSIZ_ESHS_SERTIFIKA_LISTESI = 92;
    public static final int ESXLONG_YAPISI_DOGRULANAMADI_GECERSIZ_CRL = 93;
    public static final int ESXLONG_YAPISI_DOGRULANAMADI_GECERSIZ_OCSP_CEVABI = 94;
    public static final int ESXLONG_YAPISI_DOGRULANAMADI_IPTAL_EDILMIS_SERTIFIKA = 95;
    public static final int ESXLONG_YAPISI_DOGRULANAMADI_SERTIFIKA_GECERLILIK_REFERANSI_YOK = 96;
    public static final int ESXLONG_YAPISI_DOGRU_FAKAT_IMZA_GECERSIZ = 97;
    public static final int ESXLONG_YAPISI_DOGRULANAMADI_UYUMSUZ_SERTIFIKA_REFERANSI = 98;
    public static final int ESXLONG_YAPISI_DOGRULANAMADI_UYUMSUZ_IPTAL_REFERANSI = 99;
    public static final int ESARSIV_BASARIYLA_OLUSTURULDU = 110;
    public static final int ESARSIV_OLUSTURULMADI_VERI_YAPISI_HATALI = 111;
    public static final int ESARSIV_OLUSTURULMADI_ZAMAN_DAMGASI_BAGLANTISI_KURULAMADI = 112;
    public static final int ESARSIV_OLUSTURULMADI_ZAMAN_DAMGASI_TALEBI_REDDEDILDI = 113;
    public static final int ESARSIV_OLUSTURULMADI_ZAMAN_DAMGASI_DOGRULANAMADI = 114;
    public static final int ESARSIV_OLUSTURULMADI_ZAMAN_DAMGASI_KOK_SERTIFIKASI_BULUNAMADI = 115;
    public static final int ESARSIV_OLUSTURULMADI_ZAMAN_DAMGASI_SERTIFIKASI_IPTAL_BILGILERI_ERISIMI_YOK = 116;
    public static final int ESARSIV_OLUSTURULMADI_ZAMAN_DAMGASI_SERTIFIKASI_IPTAL_EDILMIS = 117;
    public static final int ESARSIV_OLUSTURULMADI_ZAMAN_DAMGASI_SERTIFIKASI_BILINMIYOR = 118;
    public static final int ESARSIV_GECERLI = 130;
    public static final int ESARSIV_DOGRULANAMADI_VERI_YAPISI_HATALI = 131;
    public static final int ESARSIV_DOGRULANAMADI_ISLEM_SIRASINDA_HATA = 132;
    public static final int ESARSIV_DOGRULANAMADI_GECERSIZ_ESHS_SERTIFIKA_LISTESI = 133;
    public static final int ESARSIV_DOGRULANAMADI_GECERSIZ_ZD_IMZASI = 134;
    public static final int ESARSIV_DOGRULANAMADI_ZD_SERTIFIKASI_DOGRULANAMADI = 135;
    public static final int ESARSIV_DOGRULANAMADI_ZD_GIRDISI_DOGRULANAMADI = 136;
    public static final String SHA_1 = "1.3.14.3.2.26";
    public static final String SHA_224 = "2.16.840.1.101.3.4.2.4";
    public static final String SHA_256 = "2.16.840.1.101.3.4.2.1";
    public static final String SHA_384 = "2.16.840.1.101.3.4.2.2";
    public static final String SHA_512 = "2.16.840.1.101.3.4.2.3";
    public static final String WHIRLPOOL = "1.0.10118.3.0.55";
    private Vector zdDogrulamaKokleri = new Vector();
    private int zdHataDurumu;
    private int zdSunucuRedBilgisi;
    private int escHataBilgisi;
    private int escXLongHataBilgisi;
    private int esArsivHataBilgisi;
    private Vector sonDogrulamaZincir = new Vector();
    private int ocspSonSorgudaHataKodu;
    private int ocspSonSorgudaIptalNedeni;
    private Date ocspSonSorgudaIptalTarihi;
    private Vector kokCRLVec;
    private Hashtable adresTablosu;
    private int baglantiZamanAsimiSaniyesi;
    private boolean zdHatalarindaExceptionKullan = false;
    private String referansHashAlgoritmasi = "2.16.840.1.101.3.4.2.1";
    private boolean zamanDamgasinaCRLEkle = false;
    private boolean escxLongOlusturmadaCRLKullan = false;
    private String ocspHashAlgoritmasi = "2.16.840.1.101.3.4.2.1";
    private String zamanDamgasiHashAlgoritmasi = "2.16.840.1.101.3.4.2.1";

    public void baglantiZamanAsimiSuresiBelirle(int sure) {
        this.baglantiZamanAsimiSaniyesi = sure;
    }

    public void zamanDamgasiHatalarindaExceptionKullanimi(boolean kullanim) {
        this.zdHatalarindaExceptionKullan = kullanim;
    }

    public void zamanDamgalarinaCRLEkle(boolean crlEkle) {
        this.zamanDamgasinaCRLEkle = crlEkle;
    }

    public void escxLongOlusturmadaCRLKullan(boolean crlKullan) {
        this.escxLongOlusturmadaCRLKullan = crlKullan;
    }

    public boolean ocspOzetAlgoritmasiBelirle(String algoritmaOID) {
        if (!(algoritmaOID.equals(SHA_1) || algoritmaOID.equals(SHA_256) || algoritmaOID.equals(SHA_224) || algoritmaOID.equals(WHIRLPOOL) || algoritmaOID.equals(SHA_384) || algoritmaOID.equals(SHA_512))) {
            return false;
        }
        this.ocspHashAlgoritmasi = algoritmaOID;
        return true;
    }

    public boolean zamanDamgasiOzetAlgoritmasiBelirle(String algoritmaOID) {
        if (!(algoritmaOID.equals(SHA_1) || algoritmaOID.equals(SHA_256) || algoritmaOID.equals(SHA_224) || algoritmaOID.equals(WHIRLPOOL) || algoritmaOID.equals(SHA_384) || algoritmaOID.equals(SHA_512))) {
            return false;
        }
        this.zamanDamgasiHashAlgoritmasi = algoritmaOID;
        return true;
    }

    public byte[] zamanDamgasiOlustur(byte[] veri, String zamanDamgasiSunucuAdresi, boolean httpSSL, boolean tcpKullan, int tcpPort) throws TimestampException {
        try {
            if (veri == null || veri.length == 0) {
                this.zdHataDurumu = 34;
                return null;
            }
            MessageImprint mesImp = TimestampFabrikasi.formMessageImprint(veri, this.zamanDamgasiHashAlgoritmasi);
            SecureRandom srand = new SecureRandom();
            long nonceLong = srand.nextLong();
            if (nonceLong < 0L) {
                nonceLong = -nonceLong;
            }
            BigInteger nonceBigInt = new BigInteger(Long.toString(nonceLong));
            TimeStampReq tsreq = TimestampFabrikasi.formTimeStampReq(mesImp, null, nonceBigInt, true);
            byte[] tsreqBytes = tsreq.getEncoded();
            byte[] tsRespBytes = null;
            tsRespBytes = tcpKullan ? TimestampFabrikasi.getTSARespViaDirectTCP(tsreqBytes, zamanDamgasiSunucuAdresi, tcpPort, this.baglantiZamanAsimiSaniyesi) : TimestampFabrikasi.getTSARespViaHTTP(tsreqBytes, zamanDamgasiSunucuAdresi, httpSSL, this.baglantiZamanAsimiSaniyesi);
            if (tsRespBytes.length == 1 && tsRespBytes[0] == -1) {
                this.zdHataDurumu = 31;
                if (this.zdHatalarindaExceptionKullan) {
                    throw new TimestampException(31);
                }
                return null;
            }
            TimeStampResp tsResp = new TimeStampResp("tsResp");
            tsResp.decode(tsRespBytes);
            PKIStatusInfo pkiStinfo = tsResp.getStatus();
            int statusIntVal = ((BigInteger)pkiStinfo.getStatus().getValue()).intValue();
            if (statusIntVal == 0 || statusIntVal == 1) {
                ContentInfo tsToken = tsResp.getTimeStampToken();
                return tsToken.getEncoded();
            }
            this.zdHataDurumu = 32;
            PKIFailureInfo failInfo = pkiStinfo.getFailInfo();
            int failReason = failInfo.getFailingReason();
            switch (failReason) {
                case 0: {
                    this.zdSunucuRedBilgisi = 40;
                    break;
                }
                case 2: {
                    this.zdSunucuRedBilgisi = 41;
                    break;
                }
                case 5: {
                    this.zdSunucuRedBilgisi = 42;
                    break;
                }
                case 14: {
                    this.zdSunucuRedBilgisi = 43;
                    break;
                }
                case 15: {
                    this.zdSunucuRedBilgisi = 44;
                    break;
                }
                case 16: {
                    this.zdSunucuRedBilgisi = 45;
                    break;
                }
                case 17: {
                    this.zdSunucuRedBilgisi = 46;
                    break;
                }
                case 25: {
                    this.zdSunucuRedBilgisi = 47;
                }
            }
            if (this.zdHatalarindaExceptionKullan) {
                throw new TimestampException(32);
            }
            return null;
        }
        catch (TimestampException tsexc) {
            throw tsexc;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.zdHataDurumu = 31;
            return null;
        }
    }

    public byte[] zamanDamgasiOlustur(byte[] veri, String zamanDamgasiSunucuAdresi, boolean httpSSL, boolean tcpKullan, int tcpPort, String servisKullaniciAdi, String servisParolasi) throws TimestampException {
        try {
            if (veri == null || veri.length == 0) {
                this.zdHataDurumu = 34;
                return null;
            }
            MessageImprint mesImp = TimestampFabrikasi.formMessageImprint(veri, this.zamanDamgasiHashAlgoritmasi);
            SecureRandom srand = new SecureRandom();
            long nonceLong = srand.nextLong();
            if (nonceLong < 0L) {
                nonceLong = -nonceLong;
            }
            BigInteger nonceBigInt = new BigInteger(Long.toString(nonceLong));
            TimeStampReq tsreq = TimestampFabrikasi.formTimeStampReq(mesImp, null, nonceBigInt, true);
            byte[] tsreqBytes = tsreq.getEncoded();
            byte[] tsRespBytes = null;
            tsRespBytes = tcpKullan ? TimestampFabrikasi.getTSARespViaDirectTCP(tsreqBytes, zamanDamgasiSunucuAdresi, tcpPort, this.baglantiZamanAsimiSaniyesi) : TimestampFabrikasi.getTSARespViaHTTP(tsreqBytes, zamanDamgasiSunucuAdresi, httpSSL, servisKullaniciAdi, servisParolasi, 2, this.baglantiZamanAsimiSaniyesi);
            if (tsRespBytes.length == 1 && tsRespBytes[0] == -1) {
                this.zdHataDurumu = 31;
                if (this.zdHatalarindaExceptionKullan) {
                    throw new TimestampException(31);
                }
                return null;
            }
            TimeStampResp tsResp = new TimeStampResp("tsResp");
            tsResp.decode(tsRespBytes);
            PKIStatusInfo pkiStinfo = tsResp.getStatus();
            int statusIntVal = ((BigInteger)pkiStinfo.getStatus().getValue()).intValue();
            if (statusIntVal == 0 || statusIntVal == 1) {
                ContentInfo tsToken = tsResp.getTimeStampToken();
                return tsToken.getEncoded();
            }
            this.zdHataDurumu = 32;
            PKIFailureInfo failInfo = pkiStinfo.getFailInfo();
            int failReason = failInfo.getFailingReason();
            switch (failReason) {
                case 0: {
                    this.zdSunucuRedBilgisi = 40;
                    break;
                }
                case 2: {
                    this.zdSunucuRedBilgisi = 41;
                    break;
                }
                case 5: {
                    this.zdSunucuRedBilgisi = 42;
                    break;
                }
                case 14: {
                    this.zdSunucuRedBilgisi = 43;
                    break;
                }
                case 15: {
                    this.zdSunucuRedBilgisi = 44;
                    break;
                }
                case 16: {
                    this.zdSunucuRedBilgisi = 45;
                    break;
                }
                case 17: {
                    this.zdSunucuRedBilgisi = 46;
                    break;
                }
                case 25: {
                    this.zdSunucuRedBilgisi = 47;
                }
            }
            if (this.zdHatalarindaExceptionKullan) {
                throw new TimestampException(32);
            }
            return null;
        }
        catch (TimestampException tsexc) {
            throw tsexc;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.zdHataDurumu = 31;
            return null;
        }
    }

    public byte[] imzayaZamanDamgasiEkle(byte[] imza, String zamanDamgasiSunucuAdresi, boolean httpSSL, boolean tcpKullan, int tcpPort) throws TimestampException {
        return this.addTimestampToSignature(imza, zamanDamgasiSunucuAdresi, httpSSL, tcpKullan, tcpPort, null, null);
    }

    public byte[] imzayaZamanDamgasiEkle(byte[] imza, String zamanDamgasiSunucuAdresi, boolean httpSSL, boolean tcpKullan, int tcpPort, String servisKullaniciAdi, String servisParolasi) throws TimestampException {
        return this.addTimestampToSignature(imza, zamanDamgasiSunucuAdresi, httpSSL, tcpKullan, tcpPort, servisKullaniciAdi, servisParolasi);
    }

    private byte[] addTimestampToSignature(byte[] imza, String zamanDamgasiSunucuAdresi, boolean httpSSL, boolean tcpKullan, int tcpPort, String servisKullaniciAdi, String servisParolasi) throws TimestampException {
        int phase = 0;
        try {
            if (imza[0] == 48 && imza[1] == -128) {
                imza = UzunDonemliIslemler.convertFromIndefiniteLengthBERToDER(imza);
            }
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(imza);
            if (!ci.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                return null;
            }
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            SignerInfo sinfo = null;
            int numCounterSignatures = ImzaIslemNesnesi.countCounterSignatures(imza);
            if (numCounterSignatures > 0) {
                Vector lastSigStripped = ImzaIslemNesnesi.removeLastCounterSignature(imza);
                byte[] lastSinfoBytes = (byte[])lastSigStripped.elementAt(1);
                sinfo = new SignerInfo("lastSinfo");
                sinfo.decode(lastSinfoBytes);
            } else {
                sinfo = (SignerInfo)((Vector)sd.getSignerInfos().getValue()).elementAt(0);
            }
            byte[] sigValue = (byte[])sinfo.getSignature().getValue();
            phase = 1;
            MessageImprint mesImp = TimestampFabrikasi.formMessageImprint(sigValue, this.zamanDamgasiHashAlgoritmasi);
            SecureRandom srand = new SecureRandom();
            long nonceLong = srand.nextLong();
            if (nonceLong < 0L) {
                nonceLong = -nonceLong;
            }
            BigInteger nonceBigInt = new BigInteger(Long.toString(nonceLong));
            TimeStampReq tsreq = TimestampFabrikasi.formTimeStampReq(mesImp, null, nonceBigInt, true);
            byte[] tsreqBytes = tsreq.getEncoded();
            byte[] tsRespBytes = null;
            tsRespBytes = tcpKullan ? TimestampFabrikasi.getTSARespViaDirectTCP(tsreqBytes, zamanDamgasiSunucuAdresi, tcpPort, this.baglantiZamanAsimiSaniyesi) : (servisKullaniciAdi != null && servisParolasi != null ? TimestampFabrikasi.getTSARespViaHTTP(tsreqBytes, zamanDamgasiSunucuAdresi, httpSSL, servisKullaniciAdi, servisParolasi, 2, this.baglantiZamanAsimiSaniyesi) : TimestampFabrikasi.getTSARespViaHTTP(tsreqBytes, zamanDamgasiSunucuAdresi, httpSSL, this.baglantiZamanAsimiSaniyesi));
            if (tsRespBytes.length == 1 && tsRespBytes[0] == -1) {
                this.zdHataDurumu = 31;
                if (this.zdHatalarindaExceptionKullan) {
                    throw new TimestampException(31);
                }
                return null;
            }
            TimeStampResp tsResp = new TimeStampResp("tsResp");
            tsResp.decode(tsRespBytes);
            phase = 2;
            PKIStatusInfo pkiStinfo = tsResp.getStatus();
            int statusIntVal = ((BigInteger)pkiStinfo.getStatus().getValue()).intValue();
            if (statusIntVal == 0 || statusIntVal == 1) {
                ContentInfo tsToken = tsResp.getTimeStampToken();
                if (this.zamanDamgasinaCRLEkle) {
                    byte[] tstSignedDataBytes = (byte[])tsToken.getcontent().getValue();
                    SignedData tstSignedData = new SignedData("tstSignedData");
                    tstSignedData.setTaggingMethod(2);
                    tstSignedData.setTagClass((byte)-128);
                    tstSignedData.setTagNumber(0);
                    tstSignedData.decode(tstSignedDataBytes);
                    CertificateRevocationLists crls = new CertificateRevocationLists();
                    Vector certsvec = (Vector)tstSignedData.getCertificates().getValue();
                    for (Certificate tempCert : certsvec) {
                        if (SertifikaFabrikasi.verifyCertificate(tempCert, tempCert)) continue;
                        SertifikaBilgiNesnesi sbn = new SertifikaBilgiNesnesi();
                        sbn.sertifikaYukle(tempCert.getEncoded());
                        String crlAdresi = sbn.sertifikaCRLDagitimNoktalariListesiAl()[0];
                        System.out.println("CRL indir: " + crlAdresi);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        URL crlUrl = new URL(crlAdresi);
                        crlUrl.openConnection();
                        InputStream reader = crlUrl.openStream();
                        byte[] buffer = new byte[153600];
                        int bytesRead = 0;
                        while ((bytesRead = reader.read(buffer)) > 0) {
                            baos.write(buffer, 0, bytesRead);
                        }
                        reader.close();
                        baos.close();
                        byte[] crlBytes = baos.toByteArray();
                        CertificateList crl = new CertificateList("crl");
                        crl.decode(crlBytes);
                        crls.addElement(crl);
                    }
                    tstSignedData.setCRLs(crls);
                    tstSignedData.commitElementUpdate();
                    ContentInfo updatedTsToken = new ContentInfo("updatedTsToken");
                    updatedTsToken.setcontentType(tsToken.getcontentType());
                    Any anyTstSignedData = new Any("anyTstSignedData", tstSignedData);
                    updatedTsToken.setcontent(anyTstSignedData);
                    updatedTsToken.commitElementUpdate();
                    tsToken = updatedTsToken;
                }
                Attribute attSigTimeStamp = new Attribute("attSigTimeStamp");
                AttributeType attTypeSigTimeStamp = new AttributeType("attTypeSigTimeStamp");
                attTypeSigTimeStamp.setValue(SIGNATURE_TIMESTAMP_ATTRIBUTE_OBJ_ID);
                SetOf attValsSigTimeStamp = new SetOf("attValsSigTimeStamp", new ContentInfo("tsToken"));
                attValsSigTimeStamp.addElement(tsToken);
                attSigTimeStamp.settype(attTypeSigTimeStamp);
                attSigTimeStamp.setvalues(attValsSigTimeStamp);
                attSigTimeStamp.commitElementUpdate();
                UnsignedAttributes unsAtt = new UnsignedAttributes("unsAtt");
                Vector existingUnsAttVec = (Vector)sinfo.getUnsignedAttributes().getValue();
                if (existingUnsAttVec != null && existingUnsAttVec.size() > 0) {
                    for (int i = 0; i < existingUnsAttVec.size(); ++i) {
                        unsAtt.addElement((Attribute)existingUnsAttVec.elementAt(i));
                    }
                }
                unsAtt.addElement(attSigTimeStamp);
                sinfo.setUnsignedAttributes(unsAtt);
                sinfo.commitElementUpdate();
                if (numCounterSignatures > 0) {
                    Vector previousCounterSigs = ImzaIslemNesnesi.getCounterSignaturesList(imza);
                    AttributeType attTypeCounterSig = new AttributeType("attTypeCounterSig");
                    attTypeCounterSig.setValue("1.2.840.113549.1.9.6");
                    if (previousCounterSigs.size() > 0) {
                        SignerInfo childSinfo = sinfo;
                        for (int i = 0; i < previousCounterSigs.size() - 1; ++i) {
                            byte[] parentCinfoBytes = (byte[])previousCounterSigs.elementAt(i);
                            ContentInfo parentCinfo = new ContentInfo("ci");
                            parentCinfo.decode(parentCinfoBytes);
                            byte[] parentSdataBytes = (byte[])parentCinfo.getcontent().getValue();
                            SignedData parentSdata = new SignedData("sd");
                            parentSdata.setTaggingMethod(2);
                            parentSdata.setTagClass((byte)-128);
                            parentSdata.setTagNumber(0);
                            parentSdata.decode(parentSdataBytes);
                            SignerInfo parentSinfo = (SignerInfo)((Vector)parentSdata.getSignerInfos().getValue()).elementAt(0);
                            Attribute attCounterSigParent = new Attribute("attCounterSig");
                            SetOf attValsCounterSigParent = new SetOf("attValsSigCert", new SignerInfo());
                            attValsCounterSigParent.addElement(childSinfo);
                            attCounterSigParent.settype(attTypeCounterSig);
                            attCounterSigParent.setvalues(attValsCounterSigParent);
                            attCounterSigParent.commitElementUpdate();
                            if (parentSinfo.getUnsignedAttributes() != null && parentSinfo.getUnsignedAttributes().getValue() != null) {
                                ((Vector)parentSinfo.getUnsignedAttributes().getValue()).add(attCounterSigParent);
                            } else {
                                UnsignedAttributes unsignedAttrs = new UnsignedAttributes("unsignedAttrs");
                                unsignedAttrs.addElement(attCounterSigParent);
                                parentSinfo.setUnsignedAttributes(unsignedAttrs);
                            }
                            childSinfo = parentSinfo;
                        }
                        SignerInfo topSinfo = (SignerInfo)((Vector)sd.getSignerInfos().getValue()).elementAt(0);
                        Attribute attCounterSigParent = new Attribute("attCounterSig");
                        SetOf attValsCounterSigParent = new SetOf("attValsSigCert", new SignerInfo());
                        attValsCounterSigParent.addElement(childSinfo);
                        attCounterSigParent.settype(attTypeCounterSig);
                        attCounterSigParent.setvalues(attValsCounterSigParent);
                        attCounterSigParent.commitElementUpdate();
                        if (topSinfo.getUnsignedAttributes() != null && topSinfo.getUnsignedAttributes().getValue() != null) {
                            Vector topUnsignedAttsVec = (Vector)topSinfo.getUnsignedAttributes().getValue();
                            boolean updated = false;
                            for (int k = 0; k < topUnsignedAttsVec.size(); ++k) {
                                Attribute tempAtt = (Attribute)topUnsignedAttsVec.elementAt(k);
                                AttributeType tempType = tempAtt.gettype();
                                if (!((String)tempType.getValue()).equals("1.2.840.113549.1.9.6")) continue;
                                tempAtt.setvalues(attValsCounterSigParent);
                                tempAtt.commitElementUpdate();
                                updated = true;
                            }
                            if (!updated) {
                                topUnsignedAttsVec.addElement(attCounterSigParent);
                            }
                        } else {
                            UnsignedAttributes unsignedAttrs = new UnsignedAttributes("unsignedAttrs");
                            unsignedAttrs.addElement(attCounterSigParent);
                            topSinfo.setUnsignedAttributes(unsignedAttrs);
                        }
                    }
                } else {
                    ((Vector)sd.getSignerInfos().getValue()).removeElementAt(0);
                    ((Vector)sd.getSignerInfos().getValue()).add(0, sinfo);
                }
                ContentInfo ciRes = new ContentInfo("ci");
                ObjectID conTypeSignedDataObjId = new ObjectID("signedData", "1.2.840.113549.1.7.2");
                ciRes.setcontentType(conTypeSignedDataObjId);
                Any contSignedData = new Any("contSignedData", sd);
                ciRes.setcontent(contSignedData);
                ciRes.commitElementUpdate();
                this.zdHataDurumu = 30;
                this.zdSunucuRedBilgisi = 0;
                return ciRes.getEncoded();
            }
            this.zdHataDurumu = 32;
            PKIFailureInfo failInfo = pkiStinfo.getFailInfo();
            int failReason = failInfo.getFailingReason();
            switch (failReason) {
                case 0: {
                    this.zdSunucuRedBilgisi = 40;
                    break;
                }
                case 2: {
                    this.zdSunucuRedBilgisi = 41;
                    break;
                }
                case 5: {
                    this.zdSunucuRedBilgisi = 42;
                    break;
                }
                case 14: {
                    this.zdSunucuRedBilgisi = 43;
                    break;
                }
                case 15: {
                    this.zdSunucuRedBilgisi = 44;
                    break;
                }
                case 16: {
                    this.zdSunucuRedBilgisi = 45;
                    break;
                }
                case 17: {
                    this.zdSunucuRedBilgisi = 46;
                    break;
                }
                case 25: {
                    this.zdSunucuRedBilgisi = 47;
                }
            }
            if (this.zdHatalarindaExceptionKullan) {
                throw new TimestampException(32);
            }
            return null;
        }
        catch (TimestampException tsexc) {
            throw tsexc;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.zdHataDurumu = phase == 1 ? 31 : 33;
            return null;
        }
    }

    public byte[] imzayaZamanDamgasiEkle(byte[] imza, byte[] zamanDamgasi) {
        try {
            if (imza[0] == 48 && imza[1] == -128) {
                imza = UzunDonemliIslemler.convertFromIndefiniteLengthBERToDER(imza);
            }
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(imza);
            if (!ci.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                return null;
            }
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            Vector sinfoVec = (Vector)sd.getSignerInfos().getValue();
            SignerInfo sinfo = (SignerInfo)sinfoVec.elementAt(0);
            ContentInfo tsToken = new ContentInfo("tsToken");
            tsToken.decode(zamanDamgasi);
            Attribute attSigTimeStamp = new Attribute("attSigTimeStamp");
            AttributeType attTypeSigTimeStamp = new AttributeType("attTypeSigTimeStamp");
            attTypeSigTimeStamp.setValue(SIGNATURE_TIMESTAMP_ATTRIBUTE_OBJ_ID);
            SetOf attValsSigTimeStamp = new SetOf("attValsSigTimeStamp", new ContentInfo("tsToken"));
            attValsSigTimeStamp.addElement(tsToken);
            attSigTimeStamp.settype(attTypeSigTimeStamp);
            attSigTimeStamp.setvalues(attValsSigTimeStamp);
            attSigTimeStamp.commitElementUpdate();
            UnsignedAttributes unsAtt = new UnsignedAttributes("unsAtt");
            Vector existingUnsAttVec = (Vector)sinfo.getUnsignedAttributes().getValue();
            if (existingUnsAttVec != null && existingUnsAttVec.size() > 0) {
                for (int i = 0; i < existingUnsAttVec.size(); ++i) {
                    unsAtt.addElement((Attribute)existingUnsAttVec.elementAt(i));
                }
            }
            unsAtt.addElement(attSigTimeStamp);
            sinfo.setUnsignedAttributes(unsAtt);
            sinfo.commitElementUpdate();
            SignerInfos sinfos = new SignerInfos("sinfos");
            sinfos.addElement(sinfo);
            sd.setSignerInfos(sinfos);
            sd.commitElementUpdate();
            ContentInfo ciRes = new ContentInfo("ci");
            ObjectID conTypeSignedDataObjId = new ObjectID("signedData", "1.2.840.113549.1.7.2");
            ciRes.setcontentType(conTypeSignedDataObjId);
            Any contSignedData = new Any("contSignedData", sd);
            ciRes.setcontent(contSignedData);
            ciRes.commitElementUpdate();
            this.zdHataDurumu = 30;
            this.zdSunucuRedBilgisi = 0;
            return ciRes.getEncoded();
        }
        catch (Exception exc) {
            this.zdHataDurumu = 33;
            return null;
        }
    }

    public byte[] imzadanZamanDamgasiIcinGirdiAl(byte[] imza) {
        try {
            if (imza[0] == 48 && imza[1] == -128) {
                imza = UzunDonemliIslemler.convertFromIndefiniteLengthBERToDER(imza);
            }
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(imza);
            if (!ci.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                return null;
            }
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            Vector sinfoVec = (Vector)sd.getSignerInfos().getValue();
            SignerInfo sinfo = (SignerInfo)sinfoVec.elementAt(0);
            byte[] sigValue = (byte[])sinfo.getSignature().getValue();
            return sigValue;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public int zamanDamgasiOlusturmaBasariDurumunuAl() {
        return this.zdHataDurumu;
    }

    public int zamanDamgasiSunucusundanDonenHatayiAl() {
        return this.zdSunucuRedBilgisi;
    }

    public Date zamanDamgasiZamaniOku(byte[] zamanDamgasi) {
        try {
            SignedData tstSigData = this.extractTSTSignedDataFromTSToken(zamanDamgasi);
            if (tstSigData == null) {
                return null;
            }
            return TimestampFabrikasi.getGenerationTimeOfTimestamp(tstSigData);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public Date imzadanZamanDamgasiOku(byte[] zamanDamgaliImza) {
        try {
            SignedData tstSigData = this.extractTSTSignedDataFromEST(zamanDamgaliImza);
            if (tstSigData == null) {
                return null;
            }
            return TimestampFabrikasi.getGenerationTimeOfTimestamp(tstSigData);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public String zamanDamgasiIlkeNumarasiniOku(byte[] zamanDamgasi) {
        try {
            SignedData tstSigData = this.extractTSTSignedDataFromTSToken(zamanDamgasi);
            if (tstSigData == null) {
                return null;
            }
            return TimestampFabrikasi.getPolicyIdOfTimestamp(tstSigData);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public String imzadakiZamanDamgasiIlkeNumarasiniOku(byte[] zamanDamgaliImza) {
        try {
            SignedData tstSigData = this.extractTSTSignedDataFromEST(zamanDamgaliImza);
            if (tstSigData == null) {
                return null;
            }
            return TimestampFabrikasi.getPolicyIdOfTimestamp(tstSigData);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public String zamanDamgasiSeriNoOku(byte[] zamanDamgasi) {
        try {
            SignedData tstSigData = this.extractTSTSignedDataFromTSToken(zamanDamgasi);
            if (tstSigData == null) {
                return null;
            }
            return TimestampFabrikasi.getSerialNumberOfTimestamp(tstSigData);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public String imzadakiZamanDamgasiSeriNoOku(byte[] zamanDamgaliImza) {
        try {
            SignedData tstSigData = this.extractTSTSignedDataFromEST(zamanDamgaliImza);
            if (tstSigData == null) {
                return null;
            }
            return TimestampFabrikasi.getSerialNumberOfTimestamp(tstSigData);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public String zamanDamgasiSunucuKurumAdiniOku(byte[] zamanDamgasi) {
        try {
            SignedData tstSigData = this.extractTSTSignedDataFromTSToken(zamanDamgasi);
            if (tstSigData == null) {
                return null;
            }
            return TimestampFabrikasi.getAuthorityURLOfTimestamp(tstSigData);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public String imzadakiZamanDamgasiSunucuKurumAdiniOku(byte[] zamanDamgaliImza) {
        try {
            SignedData tstSigData = this.extractTSTSignedDataFromEST(zamanDamgaliImza);
            if (tstSigData == null) {
                return null;
            }
            return TimestampFabrikasi.getAuthorityURLOfTimestamp(tstSigData);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public String zamanDamgasiSertifikaAdiniOku(byte[] zamanDamgasi) {
        try {
            SignedData tstSigData = this.extractTSTSignedDataFromTSToken(zamanDamgasi);
            Certificate tsCert = TimestampFabrikasi.extractSignerCertFromTimeStampToken(tstSigData);
            return tsCert.gettbsCertificate().getsubject().getCN();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public String imzadakiZamanDamgasiSertifikaAdiniOku(byte[] zamanDamgaliImza) {
        try {
            SignedData tstSigData = this.extractTSTSignedDataFromEST(zamanDamgaliImza);
            Certificate tsCert = TimestampFabrikasi.extractSignerCertFromTimeStampToken(tstSigData);
            return tsCert.gettbsCertificate().getsubject().getCN();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public String imzadakiZamanDamgasiImzaAlgoritmasiniOku(byte[] zamanDamgaliImza) {
        try {
            SignedData tstSigData = this.extractTSTSignedDataFromEST(zamanDamgaliImza);
            return TimestampFabrikasi.getSignatureAlgorithmOfTimestamp(tstSigData);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public String imzadakiZamanDamgasiOzetAlgoritmasiniOku(byte[] zamanDamgaliImza) {
        try {
            SignedData tstSigData = this.extractTSTSignedDataFromEST(zamanDamgaliImza);
            return TimestampFabrikasi.getHashAlgorithmOfTimestamp(tstSigData);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public byte[] zamanDamgasiSertifikasiniOku(byte[] zamanDamgasi) {
        try {
            SignedData tstSigData = this.extractTSTSignedDataFromTSToken(zamanDamgasi);
            Certificate tsCert = TimestampFabrikasi.extractSignerCertFromTimeStampToken(tstSigData);
            return tsCert.getEncoded();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public byte[] imzadakiZamanDamgasiSertifikasiniOku(byte[] zamanDamgaliImza) {
        try {
            SignedData tstSigData = this.extractTSTSignedDataFromEST(zamanDamgaliImza);
            Certificate tsCert = TimestampFabrikasi.extractSignerCertFromTimeStampToken(tstSigData);
            return tsCert.getEncoded();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public int zamanDamgasiDogrulamaIcinShsSertifikasiEkle(File shsSertifikaDosyasi) {
        try {
            FileInputStream fis = new FileInputStream(shsSertifikaDosyasi);
            byte[] shsCertBytes = new byte[fis.available()];
            fis.read(shsCertBytes);
            fis.close();
            Certificate yeniShsCert = new Certificate("shsCert");
            yeniShsCert.decode(shsCertBytes);
            this.zdDogrulamaKokleri.addElement(yeniShsCert);
            return 11;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public int zamanDamgasiDogrulamaIcinShsSertifikasiEkle(byte[] shsSertifikaByteDizisi) {
        try {
            Certificate yeniShsCert = new Certificate("shsCert");
            yeniShsCert.decode(shsSertifikaByteDizisi);
            this.zdDogrulamaKokleri.addElement(yeniShsCert);
            return 11;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public void yuklenmisSHSSertifikalariniTemizle() {
        try {
            this.zdDogrulamaKokleri.clear();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public int zamanDamgasiDogrula(byte[] orijinalVeri, byte[] zamanDamgasi) {
        try {
            byte[] hashOfOriginalData;
            SignedData tstSignedData = this.extractTSTSignedDataFromTSToken(zamanDamgasi);
            int zdImzaVerifRes = this.zdUzerindekiImzayiDogrula(tstSignedData);
            if (zdImzaVerifRes != 20) {
                return zdImzaVerifRes;
            }
            MessageImprint mesimp = TimestampFabrikasi.getMessageImprintInTimestamp(tstSignedData);
            if (!HashFabrikasi.algoritmaDesteklenmeKontrolu((String)mesimp.getHashAlgorithm().getalgorithm().getValue())) {
                return 23;
            }
            byte[] hashFromTST = (byte[])mesimp.getHashedMessage().getValue();
            if (UzunDonemliIslemler.areByteArraysEqual(hashFromTST, hashOfOriginalData = HashFabrikasi.hashAl(orijinalVeri, (String)mesimp.getHashAlgorithm().getalgorithm().getValue()))) {
                return 20;
            }
            return 21;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return 27;
        }
    }

    public int imzadakiZamanDamgasiniDogrula(byte[] zamanDamgaliImza) {
        try {
            byte[] sigValue;
            byte[] hashOfSignatureOctets;
            int zdImzaVerifRes;
            if (DogrulamaLog.aktif) {
                DogrulamaLog.init();
                DogrulamaLog.logEkle("Zaman damgas\u0131 do\u011frulama ba\u015fl\u0131yor...");
            }
            if ((zdImzaVerifRes = this.zdUzerindekiImzayiDogrula(zamanDamgaliImza)) != 20) {
                return zdImzaVerifRes;
            }
            SignerInfo lastSinfo = this.extractLastSignerInfoFromSignedData(zamanDamgaliImza);
            SignedData tstSigData = this.extractTSTSignedDataFromSignerInfo(lastSinfo);
            MessageImprint mesimp = TimestampFabrikasi.getMessageImprintInTimestamp(tstSigData);
            if (!HashFabrikasi.algoritmaDesteklenmeKontrolu((String)mesimp.getHashAlgorithm().getalgorithm().getValue())) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[x] Zaman damgas\u0131nda kullan\u0131lan \u00f6zet algoritmas\u0131 desteklenmiyor");
                }
                return 23;
            }
            byte[] hashFromTST = (byte[])mesimp.getHashedMessage().getValue();
            if (UzunDonemliIslemler.areByteArraysEqual(hashFromTST, hashOfSignatureOctets = HashFabrikasi.hashAl(sigValue = (byte[])lastSinfo.getSignature().getValue(), (String)mesimp.getHashAlgorithm().getalgorithm().getValue()))) {
                return 20;
            }
            if (DogrulamaLog.aktif) {
                DogrulamaLog.logEkle("[x] Zaman damgas\u0131nda kullan\u0131lan \u00f6zet de\u011feri, veri \u00f6zet de\u011ferinden farkl\u0131");
            }
            return 21;
        }
        catch (Exception exc) {
            if (DogrulamaLog.aktif) {
                DogrulamaLog.logEkle("[x] Zaman damgas\u0131 do\u011frulama i\u015fleminde hata olu\u015ftu");
            }
            return 25;
        }
    }

    private int zdUzerindekiImzayiDogrula(byte[] zamanDamgaliImza) {
        try {
            SignerInfo lastSinfo = this.extractLastSignerInfoFromSignedData(zamanDamgaliImza);
            SignedData tstSignedData = this.extractTSTSignedDataFromSignerInfo(lastSinfo);
            return this.zdUzerindekiImzayiDogrula(tstSignedData);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            if (DogrulamaLog.aktif) {
                DogrulamaLog.logEkle("[x] Zaman damgas\u0131 do\u011frulama i\u015fleminde hata olu\u015ftu");
            }
            return 22;
        }
    }

    private int zdUzerindekiImzayiDogrula(SignedData tstSignedData) {
        try {
            Vector verifRes = TimestampFabrikasi.verifyTimeStampToken(tstSignedData);
            int verifFlag = (Integer)verifRes.elementAt(0);
            if (verifFlag == 0) {
                Certificate rootestCertInSet;
                Certificate tsCert = (Certificate)verifRes.elementAt(1);
                if (this.zdDogrulamaKokleri.size() == 0) {
                    if (DogrulamaLog.aktif) {
                        DogrulamaLog.logEkle("[x] Zaman damgas\u0131 do\u011frulama i\u00e7in ESHS sertifikas\u0131 bulunamad\u0131");
                    }
                    return 24;
                }
                boolean signerCertVerified = false;
                Vector certsInTst = (Vector)tstSignedData.getCertificates().getValue();
                boolean directParentInTrustList = false;
                Certificate directParent = null;
                for (int i = 0; i < this.zdDogrulamaKokleri.size(); ++i) {
                    Certificate tempIssuer = (Certificate)this.zdDogrulamaKokleri.elementAt(i);
                    if (!SertifikaFabrikasi.verifyCertificate(tsCert, tempIssuer)) continue;
                    directParentInTrustList = true;
                    signerCertVerified = true;
                    directParent = tempIssuer;
                    break;
                }
                if (!directParentInTrustList && (rootestCertInSet = UzunDonemliIslemler.findRootestIssuerInSet(tsCert, certsInTst)) != null && rootestCertInSet != tsCert) {
                    for (int j = 0; j < this.zdDogrulamaKokleri.size(); ++j) {
                        Certificate tempIssuer = (Certificate)this.zdDogrulamaKokleri.elementAt(j);
                        if (!SertifikaFabrikasi.verifyCertificate(rootestCertInSet, tempIssuer)) continue;
                        signerCertVerified = true;
                        break;
                    }
                }
                if (signerCertVerified) {
                    if (directParent == null) {
                        directParent = UzunDonemliIslemler.findIssuerInSet(tsCert, certsInTst);
                    }
                    this.sonDogrulamaZincir = UzunDonemliIslemler.getHierarchyFromSet(directParent, this.zdDogrulamaKokleri);
                    if (this.sonDogrulamaZincir == null || this.sonDogrulamaZincir.size() == 0) {
                        if (DogrulamaLog.aktif) {
                            DogrulamaLog.logEkle("[x] Zaman damgas\u0131 sertifikas\u0131 do\u011frulanamad\u0131");
                        }
                        return 24;
                    }
                    if (DogrulamaLog.aktif) {
                        DogrulamaLog.logEkle("Zaman damgas\u0131 sertifikas\u0131 do\u011fruland\u0131");
                    }
                    return 20;
                }
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[x] Zaman damgas\u0131 sertifikas\u0131 do\u011frulanamad\u0131");
                }
                return 24;
            }
            if (verifFlag == 2) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[x] Zaman damgas\u0131 sertifikas\u0131 bulunamad\u0131");
                }
                return 26;
            }
            if (verifFlag == -1) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[x] Zaman damgas\u0131 veri yap\u0131s\u0131 hatal\u0131");
                }
                return 27;
            }
            if (verifFlag == 1) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[x] Zaman damgas\u0131 matematiksel olarak ge\u00e7ersiz");
                }
                return 21;
            }
            if (DogrulamaLog.aktif) {
                DogrulamaLog.logEkle("[x] Zaman damgas\u0131 do\u011frulama i\u015fleminde hata olu\u015ftu");
            }
            return 22;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            if (DogrulamaLog.aktif) {
                DogrulamaLog.logEkle("[x] Zaman damgas\u0131 veri yap\u0131s\u0131 hatal\u0131");
            }
            return 27;
        }
    }

    private static Certificate findIssuerInSet(Certificate leafCert, Vector certSet) {
        if (leafCert == null || certSet == null) {
            return null;
        }
        if (certSet.size() == 0) {
            return null;
        }
        for (int i = 0; i < certSet.size(); ++i) {
            if (!SertifikaFabrikasi.verifyCertificate(leafCert, (Certificate)certSet.elementAt(i))) continue;
            return (Certificate)certSet.elementAt(i);
        }
        return null;
    }

    private static Vector getHierarchyFromSet(Certificate leafCert, Vector certSet) {
        Vector<Certificate> zincir = new Vector<Certificate>();
        if (leafCert == null || certSet == null) {
            return null;
        }
        if (certSet.size() == 0) {
            return zincir;
        }
        Certificate kontrolCert = leafCert;
        int issuerIndex = -1;
        while (true) {
            byte[] issuerBytes;
            boolean verif = false;
            for (int i = 0; i < certSet.size(); ++i) {
                if (!SertifikaFabrikasi.verifyCertificate(kontrolCert, (Certificate)certSet.elementAt(i))) continue;
                zincir.addElement(kontrolCert);
                issuerIndex = i;
                verif = true;
                break;
            }
            if (!verif) break;
            byte[] kontrolCertBytes = kontrolCert.getEncoded();
            if (UzunDonemliIslemler.areByteArraysEqual(kontrolCertBytes, issuerBytes = ((Certificate)certSet.elementAt(issuerIndex)).getEncoded())) {
                return zincir;
            }
            kontrolCert = (Certificate)certSet.elementAt(issuerIndex);
        }
        zincir.clear();
        return zincir;
    }

    private byte[] escYapisiOlustur(byte[] zamanDamgaliImza, Vector sertifikaByteDizileri) {
        try {
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(zamanDamgaliImza);
            if (!ci.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                this.escHataBilgisi = 51;
                return null;
            }
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            Vector sinfoVec = (Vector)sd.getSignerInfos().getValue();
            SignerInfo sinfo = (SignerInfo)sinfoVec.elementAt(0);
            if (this.imzadanZamanDamgasiOku(zamanDamgaliImza) == null) {
                this.escHataBilgisi = 52;
                return null;
            }
            ImzaIslemNesnesi ines = new ImzaIslemNesnesi();
            byte[] signerCertBytes = ines.imzadanSertifikaAl(zamanDamgaliImza);
            Certificate signerCert = new Certificate();
            signerCert.decode(signerCertBytes);
            if (sertifikaByteDizileri.size() == 0) {
                this.escHataBilgisi = 53;
                return null;
            }
            Vector<Certificate> certsVec = new Vector<Certificate>();
            try {
                for (byte[] certBytes : sertifikaByteDizileri) {
                    Certificate tempCert = new Certificate();
                    tempCert.decode(certBytes);
                    certsVec.addElement(tempCert);
                }
            }
            catch (Exception exc) {
                this.escHataBilgisi = 53;
                return null;
            }
            Vector sortedIssuersVec = UzunDonemliIslemler.sortCACerts(signerCert, certsVec);
            if (sortedIssuersVec == null) {
                this.escHataBilgisi = 53;
                return null;
            }
            Vector<Certificate> certsForRevRefsVec = new Vector<Certificate>();
            certsForRevRefsVec.addElement(signerCert);
            for (int k = sortedIssuersVec.size() - 1; k >= 0; --k) {
                certsForRevRefsVec.addElement((Certificate)sortedIssuersVec.elementAt(k));
            }
            Vector reverseSortedIssuersVec = new Vector();
            for (int m = sortedIssuersVec.size() - 1; m >= 0; --m) {
                reverseSortedIssuersVec.addElement(sortedIssuersVec.elementAt(m));
            }
            CompleteRevocationRefs compRevs = new CompleteRevocationRefs("compRevs");
            CrlOcspRef cor = null;
            for (int i = 0; i < certsForRevRefsVec.size() - 1; ++i) {
                Certificate tempCert = (Certificate)certsForRevRefsVec.elementAt(i);
                Vector ocspCevapVec = this.ocspSorgusuYapTumCevapGetir(tempCert, (Certificate)certsForRevRefsVec.elementAt(i + 1), null, this.baglantiZamanAsimiSaniyesi);
                int sorguSonuc = (Integer)ocspCevapVec.elementAt(0);
                if (sorguSonuc == 69) {
                    byte[] ocspRespBytes = (byte[])ocspCevapVec.elementAt(1);
                    OCSPResponse tResp = new OCSPResponse("tResp");
                    tResp.decode(ocspRespBytes);
                    BasicOCSPResponse basicOCSPResp = new BasicOCSPResponse("basicOCSPResp");
                    basicOCSPResp.decode((byte[])tResp.getResponseBytes().getResponse().getValue());
                    OcspIdentifier ocspId = new OcspIdentifier("ocspId");
                    ocspId.setOcspResponderId(basicOCSPResp.getTbsResponseData().getResponderId());
                    ocspId.setProducedAt(basicOCSPResp.getTbsResponseData().getProducedAt());
                    ocspId.commitElementUpdate();
                    byte[] hashOfResp = HashFabrikasi.hashAl(ocspRespBytes, this.referansHashAlgoritmasi);
                    OctetString hashOcts = new OctetString("hashOcts");
                    hashOcts.setValue(hashOfResp);
                    OtherHash otHash = new OtherHash("otHash");
                    if (this.referansHashAlgoritmasi.equals("SHA_1")) {
                        otHash.setSha1Hash(hashOcts);
                    } else {
                        OtherHashAlgAndValue ohav = new OtherHashAlgAndValue("ohav");
                        ObjectID hashObjId = new ObjectID("Hash");
                        hashObjId.setValue(this.referansHashAlgoritmasi);
                        Null parNull = new Null("Null_par");
                        Any anyNull = new Any("Any_null");
                        anyNull.setValue(parNull);
                        AlgorithmIdentifier hashAlgId = new AlgorithmIdentifier("Hash");
                        hashAlgId.setalgorithm(hashObjId);
                        hashAlgId.setparameters(anyNull);
                        hashAlgId.commitElementUpdate();
                        ohav.setHashAlgorithm(hashAlgId);
                        ohav.setHashValue(hashOcts);
                        otHash.setHashWithOtherAlg(ohav);
                    }
                    OcspResponsesId ori = new OcspResponsesId("ori");
                    ori.setOcspIdentifier(ocspId);
                    ori.setOcspRespHash(otHash);
                    ori.commitElementUpdate();
                    OcspListId olist = new OcspListId("olist");
                    olist.addOcspResponsesId(ori);
                    cor = new CrlOcspRef("cor");
                    cor.setOcspIds(olist);
                    cor.commitElementUpdate();
                } else {
                    if (sorguSonuc == 70) {
                        this.escHataBilgisi = 54;
                        return null;
                    }
                    if (sorguSonuc == 71) {
                        this.escHataBilgisi = 55;
                        return null;
                    }
                    Extensions exts = tempCert.gettbsCertificate().getextensions();
                    Extension crldpExt = exts.getExtensionByOID("2.5.29.31");
                    if (crldpExt == null) {
                        this.escHataBilgisi = 56;
                        return null;
                    }
                    byte[] crldpBytes = (byte[])crldpExt.getextnValue().getValue();
                    CRLDistributionPoints crldps = new CRLDistributionPoints();
                    crldps.decodeExtVal(crldpBytes);
                    Vector distPointVec = crldps.getDistributionPoints();
                    boolean crlFound = false;
                    Iterator dpIter = distPointVec.iterator();
                    while (!crlFound && dpIter.hasNext()) {
                        DistributionPoint dp = (DistributionPoint)dpIter.next();
                        DistributionPointName dpn = dp.getDistributionPointName();
                        Vector dpnVec = dpn.getFullName();
                        for (int k = 0; k < dpnVec.size(); ++k) {
                            GeneralName gn = (GeneralName)dpnVec.elementAt(k);
                            if (gn.getURI() == null || gn.getURI().length() <= 0) continue;
                            String crlAddress = gn.getURI();
                            try {
                                int oneChar;
                                URL url = new URL(crlAddress);
                                URLConnection urlC = url.openConnection();
                                InputStream is = url.openStream();
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                while ((oneChar = is.read()) != -1) {
                                    baos.write(oneChar);
                                }
                                is.close();
                                baos.close();
                                byte[] crlBytes = baos.toByteArray();
                                CertificateList crl = new CertificateList("crl");
                                crl.decode(crlBytes);
                                if (!CRLFabrikasi.verifyCRL(crl, (Certificate)certsForRevRefsVec.elementAt(i + 1))) continue;
                                crlFound = true;
                                RevokedCertificate revcert = CRLFabrikasi.isCertificateInCRL(tempCert, crl);
                                if (revcert != null) continue;
                                CRLIdentifier crlIdent = new CRLIdentifier("crlIdent");
                                crlIdent.setCRLIssuer(crl.gettbsCertList().getissuer());
                                crlIdent.setCRLIssuedTime((UTCTime)crl.gettbsCertList().getthisUpdate().getValue());
                                crlIdent.commitElementUpdate();
                                byte[] crlHashBytes = HashFabrikasi.hashAl(crlBytes, this.referansHashAlgoritmasi);
                                OctetString crlHashOcts = new OctetString("crlHashOcts");
                                crlHashOcts.setValue(crlHashBytes);
                                OtherHash crlOtherHash = new OtherHash("crlOtherHash");
                                if (this.referansHashAlgoritmasi.equals(SHA_1)) {
                                    crlOtherHash.setSha1Hash(crlHashOcts);
                                } else {
                                    OtherHashAlgAndValue ohav = new OtherHashAlgAndValue("ohav");
                                    ObjectID hashObjId = new ObjectID("Hash");
                                    hashObjId.setValue(this.referansHashAlgoritmasi);
                                    Null parNull = new Null("Null_par");
                                    Any anyNull = new Any("Any_null");
                                    anyNull.setValue(parNull);
                                    AlgorithmIdentifier hashAlgId = new AlgorithmIdentifier("Hash");
                                    hashAlgId.setalgorithm(hashObjId);
                                    hashAlgId.setparameters(anyNull);
                                    hashAlgId.commitElementUpdate();
                                    ohav.setHashAlgorithm(hashAlgId);
                                    ohav.setHashValue(crlHashOcts);
                                    crlOtherHash.setHashWithOtherAlg(ohav);
                                }
                                CRLValidatedId cvid = new CRLValidatedId("cvid");
                                cvid.setCRLHash(crlOtherHash);
                                cvid.setCRLIdentifier(crlIdent);
                                cvid.commitElementUpdate();
                                CRLListId cli = new CRLListId("cli");
                                cli.addCRLValId(cvid);
                                cor = new CrlOcspRef("cor");
                                cor.setCrlIds(cli);
                                cor.commitElementUpdate();
                                continue;
                            }
                            catch (Exception exc) {
                                exc.printStackTrace();
                            }
                        }
                    }
                }
                if (cor == null) {
                    this.escHataBilgisi = 56;
                    return null;
                }
                compRevs.addElement(cor);
                cor = null;
            }
            CompleteCertificateRefs ccrefs = new CompleteCertificateRefs("ccrefs");
            for (Certificate tempCert : reverseSortedIssuersVec) {
                byte[] tempHash = HashFabrikasi.hashAl(tempCert.getEncoded(), this.referansHashAlgoritmasi);
                OtherHash ohash = new OtherHash("ohash");
                OctetString tempHashOcts = new OctetString("tempHashOcts");
                tempHashOcts.setValue(tempHash);
                if (this.referansHashAlgoritmasi.equals(SHA_1)) {
                    ohash.setSha1Hash(tempHashOcts);
                } else {
                    OtherHashAlgAndValue ohav = new OtherHashAlgAndValue("ohav");
                    ObjectID hashObjId = new ObjectID("Hash");
                    hashObjId.setValue(this.referansHashAlgoritmasi);
                    Null parNull = new Null("Null_par");
                    Any anyNull = new Any("Any_null");
                    anyNull.setValue(parNull);
                    AlgorithmIdentifier hashAlgId = new AlgorithmIdentifier("Hash");
                    hashAlgId.setalgorithm(hashObjId);
                    hashAlgId.setparameters(anyNull);
                    hashAlgId.commitElementUpdate();
                    ohav.setHashAlgorithm(hashAlgId);
                    ohav.setHashValue(tempHashOcts);
                    ohash.setHashWithOtherAlg(ohav);
                }
                IssuerSerial issSer = new IssuerSerial("issSer");
                GeneralName gnIss = new GeneralName("gnIss");
                Name issuerClone = new Name("issuerClone");
                issuerClone.decode(tempCert.gettbsCertificate().getissuer().getEncoded());
                gnIss.setDirectoryName(issuerClone);
                GeneralNames issGenNames = new GeneralNames("issGenNames");
                issGenNames.addElement(gnIss);
                issSer.setIssuer(issGenNames);
                issSer.setSerialNumber(tempCert.gettbsCertificate().getserialNumber());
                issSer.commitElementUpdate();
                OtherCertId oci = new OtherCertId("oci");
                oci.setOtherCertHash(ohash);
                oci.setIssuerSerial(issSer);
                oci.commitElementUpdate();
                ccrefs.addElement(oci);
            }
            Attribute attCertificateRefs = new Attribute("attCertificateRefs");
            AttributeType attTypeCertificateRefs = new AttributeType("attTypeCertificateRefs");
            attTypeCertificateRefs.setValue(CERTIFICATE_REFS_ATTRIBUTE_OBJ_ID);
            SetOf attValsCertificateRefs = new SetOf("attValsCertificateRefs", new CompleteCertificateRefs("ccrefs"));
            attValsCertificateRefs.addElement(ccrefs);
            attCertificateRefs.settype(attTypeCertificateRefs);
            attCertificateRefs.setvalues(attValsCertificateRefs);
            attCertificateRefs.commitElementUpdate();
            Attribute attRevocationRefs = new Attribute("attRevocationRefs");
            AttributeType attTypeRevocationRefs = new AttributeType("attTypeRevocationRefs");
            attTypeRevocationRefs.setValue(REVOCATION_REFS_ATTRIBUTE_OBJ_ID);
            SetOf attValsRevocationRefs = new SetOf("attValsRevocationRefs", new CompleteRevocationRefs("crevrefs"));
            attValsRevocationRefs.addElement(compRevs);
            attRevocationRefs.settype(attTypeRevocationRefs);
            attRevocationRefs.setvalues(attValsRevocationRefs);
            attRevocationRefs.commitElementUpdate();
            UnsignedAttributes unsAtt = new UnsignedAttributes("unsAtt");
            Vector existingUnsAttVec = (Vector)sinfo.getUnsignedAttributes().getValue();
            if (existingUnsAttVec != null && existingUnsAttVec.size() > 0) {
                for (int i = 0; i < existingUnsAttVec.size(); ++i) {
                    unsAtt.addElement((Attribute)existingUnsAttVec.elementAt(i));
                }
            }
            unsAtt.addElement(attCertificateRefs);
            unsAtt.addElement(attRevocationRefs);
            sinfo.setUnsignedAttributes(unsAtt);
            sinfo.commitElementUpdate();
            SignerInfos sinfos = new SignerInfos("sinfos");
            sinfos.addElement(sinfo);
            sd.setSignerInfos(sinfos);
            sd.commitElementUpdate();
            ContentInfo ciRes = new ContentInfo("ci");
            ObjectID conTypeSignedDataObjId = new ObjectID("signedData", "1.2.840.113549.1.7.2");
            ciRes.setcontentType(conTypeSignedDataObjId);
            Any contSignedData = new Any("contSignedData", sd);
            ciRes.setcontent(contSignedData);
            ciRes.commitElementUpdate();
            this.escHataBilgisi = 50;
            return ciRes.getEncoded();
        }
        catch (Exception exc) {
            this.escHataBilgisi = 51;
            return null;
        }
    }

    private Vector escYapisindanESHSSertifikaSHA1OzetleriniOku(byte[] escImza) {
        try {
            CompleteCertificateRefs ccrefs = this.extractCompleteCertRefsFromESC(escImza);
            if (ccrefs == null) {
                return null;
            }
            Vector<byte[]> ozetVec = new Vector<byte[]>();
            Vector certIdsVec = (Vector)ccrefs.getValue();
            for (OtherCertId oci : certIdsVec) {
                OctetString sha1Octs = oci.getOtherCertHash().getSha1Hash();
                if (sha1Octs.getValue() == null) continue;
                ozetVec.addElement((byte[])sha1Octs.getValue());
            }
            if (ozetVec.size() > 0) {
                return ozetVec;
            }
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    private int escOlusturmaHataBilgisiniAl() {
        return this.escHataBilgisi;
    }

    private Vector escYapisindanCRLSHA1OzetleriniOku(byte[] escImza) {
        try {
            CompleteRevocationRefs crrefs = this.extractCompleteRevRefsFromESC(escImza);
            if (crrefs == null) {
                return null;
            }
            Vector<byte[]> resultVec = new Vector<byte[]>();
            Vector crvec = (Vector)crrefs.getValue();
            for (CrlOcspRef cor : crvec) {
                if (cor.getCrlIds().getCRLValIds().size() <= 0) continue;
                for (CRLValidatedId cvid : cor.getCrlIds().getCRLValIds()) {
                    resultVec.addElement((byte[])cvid.getCRLHash().getSha1Hash().getValue());
                }
            }
            return resultVec;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private Vector escYapisindanOCSPCevapTanimlayicilariniOku(byte[] escImza) {
        try {
            CompleteRevocationRefs crrefs = this.extractCompleteRevRefsFromESC(escImza);
            if (crrefs == null) {
                return null;
            }
            Vector<byte[]> resultVec = new Vector<byte[]>();
            Vector crvec = (Vector)crrefs.getValue();
            for (CrlOcspRef cor : crvec) {
                if (cor.getOcspIds().getOcspResponsesIds().size() <= 0) continue;
                Iterator ocspIdIt = cor.getOcspIds().getOcspResponsesIds().iterator();
                while (ocspIdIt.hasNext()) {
                    OcspIdentifier ident = ((OcspResponsesId)ocspIdIt.next()).getOcspIdentifier();
                    resultVec.addElement(ident.getEncoded());
                }
            }
            return resultVec;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public boolean referansOzetAlgoritmasiBelirle(String algoritmaOID) {
        if (!(algoritmaOID.equals(SHA_1) || algoritmaOID.equals(SHA_256) || algoritmaOID.equals(SHA_384) || algoritmaOID.equals(SHA_512))) {
            return false;
        }
        this.referansHashAlgoritmasi = algoritmaOID;
        return true;
    }

    public byte[] escXLongYapisiOlustur(byte[] zamanDamgaliImza, Vector sertifikaByteDizileri, byte[] imzaSahibiSertifikaOCSPCevabi, byte[] imzaSahibiSertifikaCRLBytes, byte[] kokCRLBytes) {
        try {
            AlgorithmIdentifier hashAlgId;
            ObjectID hashObjId;
            OtherHashAlgAndValue ohav;
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(zamanDamgaliImza);
            if (!ci.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                this.escXLongHataBilgisi = 81;
                return null;
            }
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            Vector sinfoVec = (Vector)sd.getSignerInfos().getValue();
            SignerInfo sinfo = (SignerInfo)sinfoVec.elementAt(0);
            if (this.imzadanZamanDamgasiOku(zamanDamgaliImza) == null) {
                this.escXLongHataBilgisi = 82;
                return null;
            }
            ImzaIslemNesnesi ines = new ImzaIslemNesnesi();
            byte[] signerCertBytes = ines.imzadanSertifikaAl(zamanDamgaliImza);
            Certificate signerCert = new Certificate();
            signerCert.decode(signerCertBytes);
            if (sertifikaByteDizileri.size() == 0) {
                this.escXLongHataBilgisi = 83;
                return null;
            }
            Vector<Certificate> certsVec = new Vector<Certificate>();
            try {
                for (byte[] certBytes : sertifikaByteDizileri) {
                    Certificate tempCert = new Certificate();
                    tempCert.decode(certBytes);
                    certsVec.addElement(tempCert);
                }
            }
            catch (Exception exc) {
                this.escXLongHataBilgisi = 83;
                return null;
            }
            Vector sortedIssuersVec = UzunDonemliIslemler.sortCACerts(signerCert, certsVec);
            if (sortedIssuersVec == null) {
                this.escXLongHataBilgisi = 83;
                return null;
            }
            Vector<Certificate> certsForRevRefsVec = new Vector<Certificate>();
            certsForRevRefsVec.addElement(signerCert);
            for (int k = sortedIssuersVec.size() - 1; k >= 0; --k) {
                certsForRevRefsVec.addElement((Certificate)sortedIssuersVec.elementAt(k));
            }
            Vector reverseSortedIssuersVec = new Vector();
            for (int m = sortedIssuersVec.size() - 1; m >= 0; --m) {
                reverseSortedIssuersVec.addElement(sortedIssuersVec.elementAt(m));
            }
            CompleteRevocationRefs compRevRefs = new CompleteRevocationRefs("compRevs");
            CrlOcspRef corSigner = new CrlOcspRef("cor");
            BasicOCSPResponse basicOCSPResp = null;
            CertificateList signerCrl = null;
            if (imzaSahibiSertifikaOCSPCevabi != null) {
                basicOCSPResp = new BasicOCSPResponse("basicOCSPResp");
                basicOCSPResp.decode(imzaSahibiSertifikaOCSPCevabi);
                OcspIdentifier ocspId = new OcspIdentifier("ocspId");
                ocspId.setOcspResponderId(basicOCSPResp.getTbsResponseData().getResponderId());
                ocspId.setProducedAt(basicOCSPResp.getTbsResponseData().getProducedAt());
                ocspId.commitElementUpdate();
                byte[] hashOfResp = HashFabrikasi.hashAl(imzaSahibiSertifikaOCSPCevabi, this.referansHashAlgoritmasi);
                OctetString hashOcts = new OctetString("hashOcts");
                hashOcts.setValue(hashOfResp);
                OtherHash otHash = new OtherHash("sha1Hash");
                if (this.referansHashAlgoritmasi.equals(SHA_1)) {
                    otHash.setSha1Hash(hashOcts);
                } else {
                    ohav = new OtherHashAlgAndValue("ohav");
                    hashObjId = new ObjectID("Hash");
                    hashObjId.setValue(this.referansHashAlgoritmasi);
                    hashAlgId = new AlgorithmIdentifier("Hash");
                    hashAlgId.setalgorithm(hashObjId);
                    hashAlgId.commitElementUpdate();
                    ohav.setHashAlgorithm(hashAlgId);
                    ohav.setHashValue(hashOcts);
                    ohav.commitElementUpdate();
                    otHash.setHashWithOtherAlg(ohav);
                }
                OcspResponsesId ori = new OcspResponsesId("ori");
                ori.setOcspIdentifier(ocspId);
                ori.setOcspRespHash(otHash);
                ori.commitElementUpdate();
                OcspListId olist = new OcspListId("olist");
                olist.addOcspResponsesId(ori);
                corSigner.setOcspIds(olist);
                corSigner.commitElementUpdate();
            } else {
                signerCrl = new CertificateList("crl");
                signerCrl.decode(imzaSahibiSertifikaCRLBytes);
                CRLIdentifier signerCrlIdent = new CRLIdentifier("crlIdent");
                signerCrlIdent.setCRLIssuer(signerCrl.gettbsCertList().getissuer());
                signerCrlIdent.setCRLIssuedTime((UTCTime)signerCrl.gettbsCertList().getthisUpdate().getValue());
                signerCrlIdent.commitElementUpdate();
                byte[] signerCrlHashBytes = HashFabrikasi.hashAl(imzaSahibiSertifikaCRLBytes, this.referansHashAlgoritmasi);
                OctetString crlHashOcts = new OctetString("crlHashOcts");
                crlHashOcts.setValue(signerCrlHashBytes);
                OtherHash signerCrlOtherHash = new OtherHash("crlOtherHash");
                if (this.referansHashAlgoritmasi.equals(SHA_1)) {
                    signerCrlOtherHash.setSha1Hash(crlHashOcts);
                } else {
                    ohav = new OtherHashAlgAndValue("ohav");
                    hashObjId = new ObjectID("Hash");
                    hashObjId.setValue(this.referansHashAlgoritmasi);
                    hashAlgId = new AlgorithmIdentifier("Hash");
                    hashAlgId.setalgorithm(hashObjId);
                    hashAlgId.commitElementUpdate();
                    ohav.setHashAlgorithm(hashAlgId);
                    ohav.setHashValue(crlHashOcts);
                    ohav.commitElementUpdate();
                    signerCrlOtherHash.setHashWithOtherAlg(ohav);
                }
                CRLValidatedId signerCvid = new CRLValidatedId("cvid");
                signerCvid.setCRLHash(signerCrlOtherHash);
                signerCvid.setCRLIdentifier(signerCrlIdent);
                signerCvid.commitElementUpdate();
                CRLListId signerCli = new CRLListId("cli");
                signerCli.addCRLValId(signerCvid);
                corSigner.setCrlIds(signerCli);
                corSigner.commitElementUpdate();
            }
            CertificateList crl = new CertificateList("crl");
            crl.decode(kokCRLBytes);
            CRLIdentifier crlIdent = new CRLIdentifier("crlIdent");
            crlIdent.setCRLIssuer(crl.gettbsCertList().getissuer());
            crlIdent.setCRLIssuedTime((UTCTime)crl.gettbsCertList().getthisUpdate().getValue());
            crlIdent.commitElementUpdate();
            byte[] crlHashBytes = HashFabrikasi.hashAl(kokCRLBytes, this.referansHashAlgoritmasi);
            OctetString crlHashOcts = new OctetString("crlHashOcts");
            crlHashOcts.setValue(crlHashBytes);
            OtherHash crlOtherHash = new OtherHash("crlOtherHash");
            if (this.referansHashAlgoritmasi.equals(SHA_1)) {
                crlOtherHash.setSha1Hash(crlHashOcts);
            } else {
                OtherHashAlgAndValue ohav2 = new OtherHashAlgAndValue("ohav");
                ObjectID hashObjId2 = new ObjectID("Hash");
                hashObjId2.setValue(this.referansHashAlgoritmasi);
                AlgorithmIdentifier hashAlgId2 = new AlgorithmIdentifier("Hash");
                hashAlgId2.setalgorithm(hashObjId2);
                hashAlgId2.commitElementUpdate();
                ohav2.setHashAlgorithm(hashAlgId2);
                ohav2.setHashValue(crlHashOcts);
                ohav2.commitElementUpdate();
                crlOtherHash.setHashWithOtherAlg(ohav2);
            }
            CRLValidatedId cvid = new CRLValidatedId("cvid");
            cvid.setCRLHash(crlOtherHash);
            cvid.setCRLIdentifier(crlIdent);
            cvid.commitElementUpdate();
            CRLListId cli = new CRLListId("cli");
            cli.addCRLValId(cvid);
            CrlOcspRef corCrl = new CrlOcspRef("cor");
            corCrl.setCrlIds(cli);
            corCrl.commitElementUpdate();
            compRevRefs.addElement(corSigner);
            compRevRefs.addElement(corCrl);
            RevocationValues revValues = new RevocationValues("revValues");
            if (basicOCSPResp != null) {
                revValues.addOCSPVal(basicOCSPResp);
            } else {
                revValues.addCRLVal(signerCrl);
            }
            revValues.addCRLVal(crl);
            CompleteCertificateRefs ccrefs = new CompleteCertificateRefs("ccrefs");
            CertificateValues certVals = new CertificateValues("certVals");
            for (Certificate tempCert : reverseSortedIssuersVec) {
                byte[] tempHash = HashFabrikasi.hashAl(tempCert.getEncoded(), this.referansHashAlgoritmasi);
                OtherHash ohash = new OtherHash("ohash");
                OctetString tempHashOcts = new OctetString("tempHashOcts");
                tempHashOcts.setValue(tempHash);
                if (this.referansHashAlgoritmasi.equals(SHA_1)) {
                    ohash.setSha1Hash(tempHashOcts);
                } else {
                    OtherHashAlgAndValue ohav3 = new OtherHashAlgAndValue("ohav");
                    ObjectID hashObjId3 = new ObjectID("Hash");
                    hashObjId3.setValue(this.referansHashAlgoritmasi);
                    AlgorithmIdentifier hashAlgId3 = new AlgorithmIdentifier("Hash");
                    hashAlgId3.setalgorithm(hashObjId3);
                    hashAlgId3.commitElementUpdate();
                    ohav3.setHashAlgorithm(hashAlgId3);
                    ohav3.setHashValue(tempHashOcts);
                    ohav3.commitElementUpdate();
                    ohash.setHashWithOtherAlg(ohav3);
                }
                IssuerSerial issSer = new IssuerSerial("issSer");
                GeneralName gnIss = new GeneralName("gnIss");
                Name issuerClone = new Name("issuerClone");
                issuerClone.decode(tempCert.gettbsCertificate().getissuer().getEncoded());
                gnIss.setDirectoryName(issuerClone);
                GeneralNames issGenNames = new GeneralNames("issGenNames");
                issGenNames.addElement(gnIss);
                issSer.setIssuer(issGenNames);
                issSer.setSerialNumber(tempCert.gettbsCertificate().getserialNumber());
                issSer.commitElementUpdate();
                OtherCertId oci = new OtherCertId("oci");
                oci.setOtherCertHash(ohash);
                oci.setIssuerSerial(issSer);
                oci.commitElementUpdate();
                ccrefs.addElement(oci);
                certVals.addElement(tempCert);
            }
            Attribute attCertificateRefs = new Attribute("attCertificateRefs");
            AttributeType attTypeCertificateRefs = new AttributeType("attTypeCertificateRefs");
            attTypeCertificateRefs.setValue(CERTIFICATE_REFS_ATTRIBUTE_OBJ_ID);
            SetOf attValsCertificateRefs = new SetOf("attValsCertificateRefs", new CompleteCertificateRefs("ccrefs"));
            attValsCertificateRefs.addElement(ccrefs);
            attCertificateRefs.settype(attTypeCertificateRefs);
            attCertificateRefs.setvalues(attValsCertificateRefs);
            attCertificateRefs.commitElementUpdate();
            Attribute attRevocationRefs = new Attribute("attRevocationRefs");
            AttributeType attTypeRevocationRefs = new AttributeType("attTypeRevocationRefs");
            attTypeRevocationRefs.setValue(REVOCATION_REFS_ATTRIBUTE_OBJ_ID);
            SetOf attValsRevocationRefs = new SetOf("attValsRevocationRefs", new CompleteRevocationRefs("crevrefs"));
            attValsRevocationRefs.addElement(compRevRefs);
            attRevocationRefs.settype(attTypeRevocationRefs);
            attRevocationRefs.setvalues(attValsRevocationRefs);
            attRevocationRefs.commitElementUpdate();
            Attribute attCertificateVals = new Attribute("attCertificateVals");
            AttributeType attTypeCertificateVals = new AttributeType("attTypeCertificateVals");
            attTypeCertificateVals.setValue(CERTIFICATE_VALUES_ATTRIBUTE_OBJ_ID);
            SetOf attValsCertificateVals = new SetOf("attValsCertificateVals", new CertificateValues("ccvals"));
            attValsCertificateVals.addElement(certVals);
            attCertificateVals.settype(attTypeCertificateVals);
            attCertificateVals.setvalues(attValsCertificateVals);
            attCertificateVals.commitElementUpdate();
            Attribute attRevocationVals = new Attribute("attRevocationValss");
            AttributeType attTypeRevocationVals = new AttributeType("attTypeRevocationVals");
            attTypeRevocationVals.setValue(REVOCATION_VALUES_ATTRIBUTE_OBJ_ID);
            SetOf attValsRevocationVals = new SetOf("attValsRevocationVals", new RevocationValues("crevvals"));
            attValsRevocationVals.addElement(revValues);
            attRevocationVals.settype(attTypeRevocationVals);
            attRevocationVals.setvalues(attValsRevocationVals);
            attRevocationVals.commitElementUpdate();
            UnsignedAttributes unsAtt = new UnsignedAttributes("unsAtt");
            Vector existingUnsAttVec = (Vector)sinfo.getUnsignedAttributes().getValue();
            if (existingUnsAttVec != null && existingUnsAttVec.size() > 0) {
                for (int i = 0; i < existingUnsAttVec.size(); ++i) {
                    unsAtt.addElement((Attribute)existingUnsAttVec.elementAt(i));
                }
            }
            unsAtt.addElement(attCertificateRefs);
            unsAtt.addElement(attRevocationRefs);
            unsAtt.addElement(attCertificateVals);
            unsAtt.addElement(attRevocationVals);
            sinfo.setUnsignedAttributes(unsAtt);
            sinfo.commitElementUpdate();
            SignerInfos sinfos = new SignerInfos("sinfos");
            sinfos.addElement(sinfo);
            sd.setSignerInfos(sinfos);
            sd.commitElementUpdate();
            ContentInfo ciRes = new ContentInfo("ci");
            ObjectID conTypeSignedDataObjId = new ObjectID("signedData", "1.2.840.113549.1.7.2");
            ciRes.setcontentType(conTypeSignedDataObjId);
            Any contSignedData = new Any("contSignedData", sd);
            ciRes.setcontent(contSignedData);
            ciRes.commitElementUpdate();
            this.escXLongHataBilgisi = 80;
            return ciRes.getEncoded();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.escXLongHataBilgisi = 81;
            return null;
        }
    }

    public byte[] escXLongYapisiOlustur(byte[] zamanDamgaliImza, Vector sertifikaByteDizileri) {
        try {
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(zamanDamgaliImza);
            if (!ci.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                this.escXLongHataBilgisi = 81;
                return null;
            }
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            Vector sinfoVec = (Vector)sd.getSignerInfos().getValue();
            SignerInfo sinfo = (SignerInfo)sinfoVec.elementAt(0);
            if (this.imzadanZamanDamgasiOku(zamanDamgaliImza) == null) {
                this.escXLongHataBilgisi = 82;
                return null;
            }
            ImzaIslemNesnesi ines = new ImzaIslemNesnesi();
            byte[] signerCertBytes = ines.imzadanSertifikaAl(zamanDamgaliImza);
            Certificate signerCert = new Certificate();
            signerCert.decode(signerCertBytes);
            if (sertifikaByteDizileri.size() == 0) {
                this.escXLongHataBilgisi = 83;
                return null;
            }
            Vector<Certificate> certsVec = new Vector<Certificate>();
            try {
                for (byte[] certBytes : sertifikaByteDizileri) {
                    Certificate tempCert = new Certificate();
                    tempCert.decode(certBytes);
                    certsVec.addElement(tempCert);
                }
            }
            catch (Exception exc) {
                this.escXLongHataBilgisi = 83;
                return null;
            }
            Vector sortedIssuersVec = UzunDonemliIslemler.sortCACerts(signerCert, certsVec);
            if (sortedIssuersVec == null) {
                this.escXLongHataBilgisi = 83;
                return null;
            }
            Vector<Certificate> certsForRevRefsVec = new Vector<Certificate>();
            certsForRevRefsVec.addElement(signerCert);
            for (int k = sortedIssuersVec.size() - 1; k >= 0; --k) {
                certsForRevRefsVec.addElement((Certificate)sortedIssuersVec.elementAt(k));
            }
            Vector reverseSortedIssuersVec = new Vector();
            for (int m = sortedIssuersVec.size() - 1; m >= 0; --m) {
                reverseSortedIssuersVec.addElement(sortedIssuersVec.elementAt(m));
            }
            CompleteRevocationRefs compRevs = new CompleteRevocationRefs("compRevs");
            RevocationValues revValues = new RevocationValues("revValues");
            CrlOcspRef cor = null;
            CrlOcspRef cor2 = null;
            for (int i = 0; i < certsForRevRefsVec.size() - 1; ++i) {
                Certificate tempCert = (Certificate)certsForRevRefsVec.elementAt(i);
                boolean ocspAvailable = true;
                if (!this.escxLongOlusturmadaCRLKullan) {
                    Vector ocspCevapVec = this.ocspSorgusuYapTumCevapGetir(tempCert, (Certificate)certsForRevRefsVec.elementAt(i + 1), null, this.baglantiZamanAsimiSaniyesi);
                    int sorguSonuc = (Integer)ocspCevapVec.elementAt(0);
                    if (sorguSonuc == 69) {
                        byte[] ocspRespBytes = (byte[])ocspCevapVec.elementAt(1);
                        OCSPResponse tResp = new OCSPResponse("tResp");
                        tResp.decode(ocspRespBytes);
                        BasicOCSPResponse basicOCSPResp = new BasicOCSPResponse("basicOCSPResp");
                        byte[] basicOcspRespBytes = (byte[])tResp.getResponseBytes().getResponse().getValue();
                        basicOCSPResp.decode(basicOcspRespBytes);
                        OcspIdentifier ocspId = new OcspIdentifier("ocspId");
                        ocspId.setOcspResponderId(basicOCSPResp.getTbsResponseData().getResponderId());
                        ocspId.setProducedAt(basicOCSPResp.getTbsResponseData().getProducedAt());
                        ocspId.commitElementUpdate();
                        byte[] hashOfResp = HashFabrikasi.hashAl(basicOcspRespBytes, this.referansHashAlgoritmasi);
                        OctetString hashOcts = new OctetString("hashOcts");
                        hashOcts.setValue(hashOfResp);
                        OtherHash otHash = new OtherHash("otHash");
                        if (this.referansHashAlgoritmasi.equals(SHA_1)) {
                            otHash.setSha1Hash(hashOcts);
                        } else {
                            OtherHashAlgAndValue ohav = new OtherHashAlgAndValue("ohav");
                            ObjectID hashObjId = new ObjectID("Hash");
                            hashObjId.setValue(this.referansHashAlgoritmasi);
                            AlgorithmIdentifier hashAlgId = new AlgorithmIdentifier("Hash");
                            hashAlgId.setalgorithm(hashObjId);
                            hashAlgId.commitElementUpdate();
                            ohav.setHashAlgorithm(hashAlgId);
                            ohav.setHashValue(hashOcts);
                            ohav.commitElementUpdate();
                            otHash.setHashWithOtherAlg(ohav);
                        }
                        OcspResponsesId ori = new OcspResponsesId("ori");
                        ori.setOcspIdentifier(ocspId);
                        ori.setOcspRespHash(otHash);
                        ori.commitElementUpdate();
                        OcspListId olist = new OcspListId("olist");
                        olist.addOcspResponsesId(ori);
                        cor = new CrlOcspRef("cor");
                        cor.setOcspIds(olist);
                        cor.commitElementUpdate();
                        revValues.addOCSPVal(basicOCSPResp);
                        Certificate ocspCert = OCSPFabrikasi.extractResponderCertFromBasicOCSPResponse(basicOCSPResp);
                        reverseSortedIssuersVec.add(0, ocspCert);
                        CertificateList ocspCertCrl = CRLFabrikasi.downloadCRL(ocspCert);
                        CRLIdentifier crlIdent = new CRLIdentifier("crlIdent");
                        crlIdent.setCRLIssuer(ocspCertCrl.gettbsCertList().getissuer());
                        crlIdent.setCRLIssuedTime((UTCTime)ocspCertCrl.gettbsCertList().getthisUpdate().getValue());
                        crlIdent.commitElementUpdate();
                        byte[] crlHashBytes = HashFabrikasi.hashAl(ocspCertCrl.getEncoded(), this.referansHashAlgoritmasi);
                        OctetString crlHashOcts = new OctetString("crlHashOcts");
                        crlHashOcts.setValue(crlHashBytes);
                        OtherHash crlOtherHash = new OtherHash("crlOtherHash");
                        if (this.referansHashAlgoritmasi.equals(SHA_1)) {
                            crlOtherHash.setSha1Hash(crlHashOcts);
                        } else {
                            OtherHashAlgAndValue ohav = new OtherHashAlgAndValue("ohav");
                            ObjectID hashObjId = new ObjectID("Hash");
                            hashObjId.setValue(this.referansHashAlgoritmasi);
                            AlgorithmIdentifier hashAlgId = new AlgorithmIdentifier("Hash");
                            hashAlgId.setalgorithm(hashObjId);
                            hashAlgId.commitElementUpdate();
                            ohav.setHashAlgorithm(hashAlgId);
                            ohav.setHashValue(crlHashOcts);
                            ohav.commitElementUpdate();
                            crlOtherHash.setHashWithOtherAlg(ohav);
                        }
                        CRLValidatedId cvid = new CRLValidatedId("cvid");
                        cvid.setCRLHash(crlOtherHash);
                        cvid.setCRLIdentifier(crlIdent);
                        cvid.commitElementUpdate();
                        CRLListId cli = new CRLListId("cli");
                        cli.addCRLValId(cvid);
                        cor2 = new CrlOcspRef("cor2");
                        cor2.setCrlIds(cli);
                        cor2.commitElementUpdate();
                        revValues.addCRLVal(ocspCertCrl);
                    } else {
                        if (sorguSonuc == 70) {
                            this.escXLongHataBilgisi = 84;
                            return null;
                        }
                        if (sorguSonuc == 71) {
                            this.escXLongHataBilgisi = 85;
                            return null;
                        }
                        ocspAvailable = false;
                    }
                }
                if (this.escxLongOlusturmadaCRLKullan || !ocspAvailable) {
                    System.out.println("CRL kismi basliyor");
                    Extensions exts = tempCert.gettbsCertificate().getextensions();
                    Extension crldpExt = exts.getExtensionByOID("2.5.29.31");
                    if (crldpExt == null) {
                        this.escXLongHataBilgisi = 86;
                        return null;
                    }
                    byte[] crldpBytes = (byte[])crldpExt.getextnValue().getValue();
                    CRLDistributionPoints crldps = new CRLDistributionPoints();
                    crldps.decodeExtVal(crldpBytes);
                    Vector distPointVec = crldps.getDistributionPoints();
                    boolean crlFound = false;
                    Iterator dpIter = distPointVec.iterator();
                    while (!crlFound && dpIter.hasNext()) {
                        DistributionPoint dp = (DistributionPoint)dpIter.next();
                        DistributionPointName dpn = dp.getDistributionPointName();
                        Vector dpnVec = dpn.getFullName();
                        for (int k = 0; k < dpnVec.size(); ++k) {
                            GeneralName gn = (GeneralName)dpnVec.elementAt(k);
                            if (gn.getURI() == null || gn.getURI().length() <= 0) continue;
                            String crlAddress = gn.getURI();
                            try {
                                int oneChar;
                                URL url = new URL(crlAddress);
                                URLConnection urlC = url.openConnection();
                                InputStream is = url.openStream();
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                while ((oneChar = is.read()) != -1) {
                                    baos.write(oneChar);
                                }
                                is.close();
                                baos.close();
                                byte[] crlBytes = baos.toByteArray();
                                CertificateList crl = new CertificateList("crl");
                                crl.decode(crlBytes);
                                if (!CRLFabrikasi.verifyCRL(crl, (Certificate)certsForRevRefsVec.elementAt(i + 1)) || !CRLFabrikasi.isCRLUptoDate(crl)) continue;
                                crlFound = true;
                                RevokedCertificate revcert = CRLFabrikasi.isCertificateInCRL(tempCert, crl);
                                if (revcert == null) {
                                    CRLIdentifier crlIdent = new CRLIdentifier("crlIdent");
                                    crlIdent.setCRLIssuer(crl.gettbsCertList().getissuer());
                                    crlIdent.setCRLIssuedTime((UTCTime)crl.gettbsCertList().getthisUpdate().getValue());
                                    crlIdent.commitElementUpdate();
                                    byte[] crlHashBytes = HashFabrikasi.hashAl(crlBytes, this.referansHashAlgoritmasi);
                                    OctetString crlHashOcts = new OctetString("crlHashOcts");
                                    crlHashOcts.setValue(crlHashBytes);
                                    OtherHash crlOtherHash = new OtherHash("crlOtherHash");
                                    if (this.referansHashAlgoritmasi.equals(SHA_1)) {
                                        crlOtherHash.setSha1Hash(crlHashOcts);
                                    } else {
                                        OtherHashAlgAndValue ohav = new OtherHashAlgAndValue("ohav");
                                        ObjectID hashObjId = new ObjectID("Hash");
                                        hashObjId.setValue(this.referansHashAlgoritmasi);
                                        AlgorithmIdentifier hashAlgId = new AlgorithmIdentifier("Hash");
                                        hashAlgId.setalgorithm(hashObjId);
                                        hashAlgId.commitElementUpdate();
                                        ohav.setHashAlgorithm(hashAlgId);
                                        ohav.setHashValue(crlHashOcts);
                                        ohav.commitElementUpdate();
                                        crlOtherHash.setHashWithOtherAlg(ohav);
                                    }
                                    CRLValidatedId cvid = new CRLValidatedId("cvid");
                                    cvid.setCRLHash(crlOtherHash);
                                    cvid.setCRLIdentifier(crlIdent);
                                    cvid.commitElementUpdate();
                                    CRLListId cli = new CRLListId("cli");
                                    cli.addCRLValId(cvid);
                                    cor = new CrlOcspRef("cor");
                                    cor.setCrlIds(cli);
                                    cor.commitElementUpdate();
                                    revValues.addCRLVal(crl);
                                    continue;
                                }
                                this.escXLongHataBilgisi = 84;
                                return null;
                            }
                            catch (Exception exc) {
                                exc.printStackTrace();
                            }
                        }
                    }
                }
                if (cor == null) {
                    this.escXLongHataBilgisi = 86;
                    return null;
                }
                compRevs.addElement(cor);
                cor = null;
                if (cor2 == null) continue;
                compRevs.addElement(cor2);
                cor2 = null;
            }
            CompleteCertificateRefs ccrefs = new CompleteCertificateRefs("ccrefs");
            CertificateValues certVals = new CertificateValues("certVals");
            for (Certificate tempCert : reverseSortedIssuersVec) {
                byte[] tempHash = HashFabrikasi.hashAl(tempCert.getEncoded(), this.referansHashAlgoritmasi);
                OtherHash ohash = new OtherHash("ohash");
                OctetString tempHashOcts = new OctetString("tempHashOcts");
                tempHashOcts.setValue(tempHash);
                if (this.referansHashAlgoritmasi.equals(SHA_1)) {
                    ohash.setSha1Hash(tempHashOcts);
                } else {
                    OtherHashAlgAndValue ohav = new OtherHashAlgAndValue("ohav");
                    ObjectID hashObjId = new ObjectID("Hash");
                    hashObjId.setValue(this.referansHashAlgoritmasi);
                    AlgorithmIdentifier hashAlgId = new AlgorithmIdentifier("Hash");
                    hashAlgId.setalgorithm(hashObjId);
                    hashAlgId.commitElementUpdate();
                    ohav.setHashAlgorithm(hashAlgId);
                    ohav.setHashValue(tempHashOcts);
                    ohav.commitElementUpdate();
                    ohash.setHashWithOtherAlg(ohav);
                }
                IssuerSerial issSer = new IssuerSerial("issSer");
                GeneralName gnIss = new GeneralName("gnIss");
                Name issuerClone = new Name("issuerClone");
                issuerClone.decode(tempCert.gettbsCertificate().getissuer().getEncoded());
                gnIss.setDirectoryName(issuerClone);
                GeneralNames issGenNames = new GeneralNames("issGenNames");
                issGenNames.addElement(gnIss);
                issSer.setIssuer(issGenNames);
                issSer.setSerialNumber(tempCert.gettbsCertificate().getserialNumber());
                issSer.commitElementUpdate();
                OtherCertId oci = new OtherCertId("oci");
                oci.setOtherCertHash(ohash);
                oci.setIssuerSerial(issSer);
                oci.commitElementUpdate();
                ccrefs.addElement(oci);
                certVals.addElement(tempCert);
            }
            Attribute attCertificateRefs = new Attribute("attCertificateRefs");
            AttributeType attTypeCertificateRefs = new AttributeType("attTypeCertificateRefs");
            attTypeCertificateRefs.setValue(CERTIFICATE_REFS_ATTRIBUTE_OBJ_ID);
            SetOf attValsCertificateRefs = new SetOf("attValsCertificateRefs", new CompleteCertificateRefs("ccrefs"));
            attValsCertificateRefs.addElement(ccrefs);
            attCertificateRefs.settype(attTypeCertificateRefs);
            attCertificateRefs.setvalues(attValsCertificateRefs);
            attCertificateRefs.commitElementUpdate();
            Attribute attRevocationRefs = new Attribute("attRevocationRefs");
            AttributeType attTypeRevocationRefs = new AttributeType("attTypeRevocationRefs");
            attTypeRevocationRefs.setValue(REVOCATION_REFS_ATTRIBUTE_OBJ_ID);
            SetOf attValsRevocationRefs = new SetOf("attValsRevocationRefs", new CompleteRevocationRefs("crevrefs"));
            attValsRevocationRefs.addElement(compRevs);
            attRevocationRefs.settype(attTypeRevocationRefs);
            attRevocationRefs.setvalues(attValsRevocationRefs);
            attRevocationRefs.commitElementUpdate();
            Attribute attCertificateVals = new Attribute("attCertificateVals");
            AttributeType attTypeCertificateVals = new AttributeType("attTypeCertificateVals");
            attTypeCertificateVals.setValue(CERTIFICATE_VALUES_ATTRIBUTE_OBJ_ID);
            SetOf attValsCertificateVals = new SetOf("attValsCertificateVals", new CertificateValues("ccvals"));
            attValsCertificateVals.addElement(certVals);
            attCertificateVals.settype(attTypeCertificateVals);
            attCertificateVals.setvalues(attValsCertificateVals);
            attCertificateVals.commitElementUpdate();
            Attribute attRevocationVals = new Attribute("attRevocationValss");
            AttributeType attTypeRevocationVals = new AttributeType("attTypeRevocationVals");
            attTypeRevocationVals.setValue(REVOCATION_VALUES_ATTRIBUTE_OBJ_ID);
            SetOf attValsRevocationVals = new SetOf("attValsRevocationVals", new RevocationValues("crevvals"));
            attValsRevocationVals.addElement(revValues);
            attRevocationVals.settype(attTypeRevocationVals);
            attRevocationVals.setvalues(attValsRevocationVals);
            attRevocationVals.commitElementUpdate();
            UnsignedAttributes unsAtt = new UnsignedAttributes("unsAtt");
            Vector existingUnsAttVec = (Vector)sinfo.getUnsignedAttributes().getValue();
            if (existingUnsAttVec != null && existingUnsAttVec.size() > 0) {
                for (int i = 0; i < existingUnsAttVec.size(); ++i) {
                    unsAtt.addElement((Attribute)existingUnsAttVec.elementAt(i));
                }
            }
            unsAtt.addElement(attCertificateRefs);
            unsAtt.addElement(attRevocationRefs);
            unsAtt.addElement(attCertificateVals);
            unsAtt.addElement(attRevocationVals);
            sinfo.setUnsignedAttributes(unsAtt);
            sinfo.commitElementUpdate();
            SignerInfos sinfos = new SignerInfos("sinfos");
            sinfos.addElement(sinfo);
            sd.setSignerInfos(sinfos);
            sd.commitElementUpdate();
            ContentInfo ciRes = new ContentInfo("ci");
            ObjectID conTypeSignedDataObjId = new ObjectID("signedData", "1.2.840.113549.1.7.2");
            ciRes.setcontentType(conTypeSignedDataObjId);
            Any contSignedData = new Any("contSignedData", sd);
            ciRes.setcontent(contSignedData);
            ciRes.commitElementUpdate();
            this.escXLongHataBilgisi = 80;
            return ciRes.getEncoded();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.escXLongHataBilgisi = 81;
            return null;
        }
    }

    public int escXLongOlusturmaHataBilgisiniAl() {
        return this.escXLongHataBilgisi;
    }

    public byte[] seriImzalarIcinESCXLongYapisiOlustur(byte[] tumImzaBytes, Vector sertifikaByteDizileri) {
        try {
            ImzaIslemNesnesi in = new ImzaIslemNesnesi();
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(tumImzaBytes);
            if (!ci.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                return null;
            }
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            int numCounterSignatures = ImzaIslemNesnesi.countCounterSignatures(tumImzaBytes);
            if (numCounterSignatures > 0) {
                Vector lastSigStripped;
                AttributeType attTypeCounterSig = new AttributeType("attTypeCounterSig");
                attTypeCounterSig.setValue("1.2.840.113549.1.9.6");
                boolean finished = false;
                Vector<byte[]> updatedCinfoVec = new Vector<byte[]>();
                byte[] workCopyImzaBytes = tumImzaBytes;
                while (!finished && (lastSigStripped = ImzaIslemNesnesi.removeLastCounterSignature(workCopyImzaBytes)).size() != 1) {
                    workCopyImzaBytes = (byte[])lastSigStripped.elementAt(0);
                    byte[] lastSinfoBytes = (byte[])lastSigStripped.elementAt(1);
                    SignerInfo lastSinfo = new SignerInfo("lastSinfo");
                    lastSinfo.decode(lastSinfoBytes);
                    byte[] parentSinfoBytesForLast = (byte[])lastSigStripped.elementAt(2);
                    SignerInfo parentSinfo = new SignerInfo("parentSinfo");
                    parentSinfo.decode(parentSinfoBytesForLast);
                    byte[] newCinfoBytes = ImzaIslemNesnesi.putCounterSigInSeparateContentInfo(lastSinfo, (byte[])parentSinfo.getSignature().getValue(), sd.getCertificates());
                    byte[] updatedCinfoBytes = this.escXLongYapisiOlustur(newCinfoBytes, sertifikaByteDizileri);
                    updatedCinfoVec.add(updatedCinfoBytes);
                }
                System.out.println("G\u00fcncellenmis counter sig. sayisi = " + updatedCinfoVec.size());
                byte[] childCinfoBytes = (byte[])updatedCinfoVec.elementAt(0);
                ContentInfo childCinfo = new ContentInfo("ci");
                childCinfo.decode(childCinfoBytes);
                byte[] childSdataBytes = (byte[])childCinfo.getcontent().getValue();
                SignedData childSdata = new SignedData("sd");
                childSdata.setTaggingMethod(2);
                childSdata.setTagClass((byte)-128);
                childSdata.setTagNumber(0);
                childSdata.decode(childSdataBytes);
                SignerInfo childSinfo = (SignerInfo)((Vector)childSdata.getSignerInfos().getValue()).elementAt(0);
                for (int i = 0; i < updatedCinfoVec.size() - 1; ++i) {
                    byte[] parentCinfoBytes = (byte[])updatedCinfoVec.elementAt(i + 1);
                    ContentInfo parentCinfo = new ContentInfo("ci");
                    parentCinfo.decode(parentCinfoBytes);
                    byte[] parentSdataBytes = (byte[])parentCinfo.getcontent().getValue();
                    SignedData parentSdata = new SignedData("sd");
                    parentSdata.setTaggingMethod(2);
                    parentSdata.setTagClass((byte)-128);
                    parentSdata.setTagNumber(0);
                    parentSdata.decode(parentSdataBytes);
                    SignerInfo parentSinfo = (SignerInfo)((Vector)parentSdata.getSignerInfos().getValue()).elementAt(0);
                    Attribute attCounterSigParent = new Attribute("attCounterSig");
                    SetOf attValsCounterSigParent = new SetOf("attValsSigCert", new SignerInfo());
                    attValsCounterSigParent.addElement(childSinfo);
                    attCounterSigParent.settype(attTypeCounterSig);
                    attCounterSigParent.setvalues(attValsCounterSigParent);
                    attCounterSigParent.commitElementUpdate();
                    if (parentSinfo.getUnsignedAttributes() != null && parentSinfo.getUnsignedAttributes().getValue() != null) {
                        ((Vector)parentSinfo.getUnsignedAttributes().getValue()).add(attCounterSigParent);
                    } else {
                        UnsignedAttributes unsignedAttrs = new UnsignedAttributes("unsignedAttrs");
                        unsignedAttrs.addElement(attCounterSigParent);
                        parentSinfo.setUnsignedAttributes(unsignedAttrs);
                    }
                    childSinfo = parentSinfo;
                }
                SignerInfo topSinfo = (SignerInfo)((Vector)sd.getSignerInfos().getValue()).elementAt(0);
                Attribute attCounterSigParent = new Attribute("attCounterSig");
                SetOf attValsCounterSigParent = new SetOf("attValsSigCert", new SignerInfo());
                attValsCounterSigParent.addElement(childSinfo);
                attCounterSigParent.settype(attTypeCounterSig);
                attCounterSigParent.setvalues(attValsCounterSigParent);
                attCounterSigParent.commitElementUpdate();
                if (topSinfo.getUnsignedAttributes() != null && topSinfo.getUnsignedAttributes().getValue() != null) {
                    Vector topUnsignedAttsVec = (Vector)topSinfo.getUnsignedAttributes().getValue();
                    boolean updated = false;
                    for (int k = 0; k < topUnsignedAttsVec.size(); ++k) {
                        Attribute tempAtt = (Attribute)topUnsignedAttsVec.elementAt(k);
                        AttributeType tempType = tempAtt.gettype();
                        if (!((String)tempType.getValue()).equals("1.2.840.113549.1.9.6")) continue;
                        tempAtt.setvalues(attValsCounterSigParent);
                        tempAtt.commitElementUpdate();
                        updated = true;
                    }
                    if (!updated) {
                        topUnsignedAttsVec.addElement(attCounterSigParent);
                    }
                } else {
                    UnsignedAttributes unsignedAttrs = new UnsignedAttributes("unsignedAttrs");
                    unsignedAttrs.addElement(attCounterSigParent);
                    topSinfo.setUnsignedAttributes(unsignedAttrs);
                }
                ContentInfo ciTop = new ContentInfo("ci");
                ObjectID conTypeSignedDataObjId = new ObjectID("signedData", "1.2.840.113549.1.7.2");
                ciTop.setcontentType(conTypeSignedDataObjId);
                Any contSignedData = new Any("contSignedData", sd);
                ciTop.setcontent(contSignedData);
                ciTop.commitElementUpdate();
                return this.escXLongYapisiOlustur(ciTop.getEncoded(), sertifikaByteDizileri);
            }
            return this.escXLongYapisiOlustur(tumImzaBytes, sertifikaByteDizileri);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private Vector escXLongYapisindanESHSSertifikalariniOku(byte[] escXLongImza) {
        try {
            CertificateValues certVals = this.extractCertificatesFromESCXLong(escXLongImza);
            if (certVals == null) {
                return null;
            }
            Vector certsVec = (Vector)certVals.getValue();
            Iterator certsIter = certsVec.iterator();
            Vector<byte[]> encodedCertsVec = new Vector<byte[]>();
            while (certsIter.hasNext()) {
                Certificate tempCert = (Certificate)certsIter.next();
                encodedCertsVec.addElement(tempCert.getEncoded());
            }
            return encodedCertsVec;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private Vector escXLongYapisindanSertifikaIptalListeleriniOku(byte[] escXLongImza) {
        try {
            RevocationValues revvals = this.extractRevocationValuesFromESCXLong(escXLongImza);
            if (revvals == null) {
                return null;
            }
            Vector crlsVec = revvals.getCRLVals();
            Iterator crlsIter = crlsVec.iterator();
            Vector<byte[]> encodedcrlsvec = new Vector<byte[]>();
            while (crlsIter.hasNext()) {
                CertificateList tempcrl = (CertificateList)crlsIter.next();
                encodedcrlsvec.addElement(tempcrl.getEncoded());
            }
            return encodedcrlsvec;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private Vector escXLongYapisindanOCSPCevaplariniOku(byte[] escXLongImza) {
        try {
            RevocationValues revvals = this.extractRevocationValuesFromESCXLong(escXLongImza);
            if (revvals == null) {
                return null;
            }
            Vector ocspVec = revvals.getOCSPVals();
            Iterator ocspIter = ocspVec.iterator();
            Vector<byte[]> encodedocspvec = new Vector<byte[]>();
            while (ocspIter.hasNext()) {
                BasicOCSPResponse tempresp = (BasicOCSPResponse)ocspIter.next();
                encodedocspvec.addElement(tempresp.getEncoded());
            }
            return encodedocspvec;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public int escXLongYapisiDogrula(byte[] escXLongImza) {
        try {
            if (DogrulamaLog.aktif) {
                DogrulamaLog.init();
                DogrulamaLog.logEkle("ESCXLong do\u011frulama ba\u015fl\u0131yor...");
            }
            ImzaIslemNesnesi ines = new ImzaIslemNesnesi();
            byte[] signerCertBytes = ines.imzadanSertifikaAl(escXLongImza);
            Certificate signerCert = new Certificate();
            signerCert.decode(signerCertBytes);
            CertificateValues certVals = this.extractCertificatesFromESCXLong(escXLongImza);
            if (certVals == null) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[x] \u0130mzadan ESHS sertifika de\u011ferleri okunamad\u0131");
                }
                return 92;
            }
            Vector certsVec = (Vector)certVals.getValue();
            Vector hierVec = UzunDonemliIslemler.getHierarchyFromSet(signerCert, certsVec);
            if (hierVec == null || hierVec.size() == 0) {
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[x] Sertifika zinciri do\u011frulanamad\u0131");
                }
                return 92;
            }
            if (DogrulamaLog.aktif) {
                DogrulamaLog.logEkle("Sertifika zinciri do\u011fruland\u0131");
            }
            CompleteRevocationRefs compRevRefs = this.extractCompleteRevRefsFromESC(escXLongImza);
            RevocationValues revVals = this.extractRevocationValuesFromESCXLong(escXLongImza);
            Vector crlOcspRefVec = (Vector)compRevRefs.getValue();
            Vector crlValsVec = revVals.getCRLVals();
            Vector ocspValsVec = revVals.getOCSPVals();
            boolean allRefsValid = false;
            boolean refsValidated = false;
            for (CrlOcspRef cor : crlOcspRefVec) {
                if (cor.getCrlIds().getCRLValIds().size() > 0) {
                    CRLValidatedId crlValId = (CRLValidatedId)cor.getCrlIds().getCRLValIds().elementAt(0);
                    OtherHash crlHash = crlValId.getCRLHash();
                    boolean crlFound = false;
                    if (crlHash.getSha1Hash().getValue() != null) {
                        byte[] crlSha1HashBytes = (byte[])crlHash.getSha1Hash().getValue();
                        for (CertificateList tempCrl : crlValsVec) {
                            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
                            byte[] tempCrlHash = sha1.digest(tempCrl.getEncoded());
                            if (!UzunDonemliIslemler.areByteArraysEqual(crlSha1HashBytes, tempCrlHash)) continue;
                            crlFound = true;
                            break;
                        }
                    } else if (crlHash.getHashWithOtherAlg() != null) {
                        byte[] crlHashBytes = (byte[])crlHash.getHashWithOtherAlg().getHashValue().getValue();
                        for (CertificateList tempCrl : crlValsVec) {
                            byte[] tempCrlHash = HashFabrikasi.hashAl(tempCrl.getEncoded(), (String)crlHash.getHashWithOtherAlg().getHashAlgorithm().getalgorithm().getValue());
                            if (!UzunDonemliIslemler.areByteArraysEqual(crlHashBytes, tempCrlHash)) continue;
                            crlFound = true;
                            break;
                        }
                    }
                    if (crlFound) continue;
                    if (DogrulamaLog.aktif) {
                        DogrulamaLog.logEkle("[x] CRL referans\u0131 CRL de\u011feri ile uyumsuz");
                    }
                    return 99;
                }
                if (cor.getOcspIds().getOcspResponsesIds().size() <= 0) continue;
                OcspResponsesId ocspRespId = (OcspResponsesId)cor.getOcspIds().getOcspResponsesIds().elementAt(0);
                OcspIdentifier ocspId = ocspRespId.getOcspIdentifier();
                ResponderID responderId = ocspId.getOcspResponderId();
                GeneralizedTime producedAt = ocspId.getProducedAt();
                byte[] responderIdEnc = responderId.getEncoded();
                byte[] producedAtEnc = producedAt.getEncoded();
                String ocspRespHashAlg = null;
                byte[] ocspRespHashBytes = null;
                if (ocspRespId.getOcspRespHash() != null) {
                    if (ocspRespId.getOcspRespHash().getSha1Hash().getValue() != null) {
                        ocspRespHashAlg = SHA_1;
                        ocspRespHashBytes = (byte[])ocspRespId.getOcspRespHash().getSha1Hash().getValue();
                    } else {
                        OtherHashAlgAndValue ocspOhav = ocspRespId.getOcspRespHash().getHashWithOtherAlg();
                        ocspRespHashAlg = (String)ocspOhav.getHashAlgorithm().getalgorithm().getValue();
                        ocspRespHashBytes = (byte[])ocspOhav.getHashValue().getValue();
                    }
                }
                Iterator ocspIter = ocspValsVec.iterator();
                boolean ocspFound = false;
                while (ocspIter.hasNext()) {
                    BasicOCSPResponse basicResp = (BasicOCSPResponse)ocspIter.next();
                    byte[] tempResponderIdEnc = basicResp.getTbsResponseData().getResponderId().getEncoded();
                    byte[] tempProducedAtEnc = basicResp.getTbsResponseData().getProducedAt().getEncoded();
                    if (!UzunDonemliIslemler.areByteArraysEqual(responderIdEnc, tempResponderIdEnc) || !UzunDonemliIslemler.areByteArraysEqual(producedAtEnc, tempProducedAtEnc)) continue;
                    if (ocspRespHashAlg != null) {
                        byte[] tempResponseHashBytes = HashFabrikasi.hashAl(basicResp.getEncoded(), ocspRespHashAlg);
                        if (UzunDonemliIslemler.areByteArraysEqual(ocspRespHashBytes, tempResponseHashBytes)) {
                            ocspFound = true;
                        }
                    } else {
                        ocspFound = true;
                    }
                    if (!ocspFound) continue;
                    break;
                }
                if (ocspFound) continue;
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[x] OCSP cevap referans\u0131 OCSP cevap de\u011feri ile uyumsuz");
                }
                return 99;
            }
            if (DogrulamaLog.aktif) {
                DogrulamaLog.logEkle("\u0130ptal referanslar\u0131 iptal de\u011ferleriyle uyumlu");
            }
            Iterator crlsIter = crlValsVec.iterator();
            while (crlsIter.hasNext()) {
                Iterator certsIter = certsVec.iterator();
                CertificateList tempCrl = (CertificateList)crlsIter.next();
                boolean crlVerified = false;
                while (certsIter.hasNext()) {
                    if (!CRLFabrikasi.verifyCRL(tempCrl, (Certificate)certsIter.next())) continue;
                    crlVerified = true;
                    break;
                }
                if (crlVerified) continue;
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[x] CRL de\u011feri ESHS sertifikalar\u0131 ile do\u011frulanamad\u0131");
                }
                return 93;
            }
            Iterator ocspIter = ocspValsVec.iterator();
            while (ocspIter.hasNext()) {
                Iterator certsIter = certsVec.iterator();
                BasicOCSPResponse tempResp = (BasicOCSPResponse)ocspIter.next();
                boolean ocspVerified = false;
                if (OCSPFabrikasi.verifyBasicOCSPResponse(tempResp) != 0) continue;
                Certificate ocspRespCert = OCSPFabrikasi.extractResponderCertFromBasicOCSPResponse(tempResp);
                while (certsIter.hasNext()) {
                    if (!SertifikaFabrikasi.verifyCertificate(ocspRespCert, (Certificate)certsIter.next())) continue;
                    ocspVerified = true;
                }
                if (ocspVerified) continue;
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[x] OCSP cevap de\u011feri ESHS sertifikalar\u0131 ile do\u011frulanamad\u0131");
                }
                return 94;
            }
            if (DogrulamaLog.aktif) {
                DogrulamaLog.logEkle("\u0130ptal kay\u0131tlar\u0131 \u00fczerindeki imzalar do\u011fruland\u0131");
            }
            Date tsSignTime = this.imzadanZamanDamgasiOku(escXLongImza);
            boolean certWasValid = false;
            Certificate certToCheck = signerCert;
            Iterator certsIter = certsVec.iterator();
            for (int i = -1; i < certsVec.size(); ++i) {
                if (i != -1) {
                    certToCheck = (Certificate)certsVec.elementAt(i);
                }
                for (CertificateList tempCrl : crlValsVec) {
                    if (!certToCheck.gettbsCertificate().getissuer().isEqualTo(tempCrl.gettbsCertList().getissuer())) continue;
                    if (CRLFabrikasi.isCertificateInCRL(certToCheck, tempCrl) == null) {
                        Date crlThisUp = (Date)((UTCTime)tempCrl.gettbsCertList().getthisUpdate().getValue()).getValue();
                        Date crlNextUp = (Date)((UTCTime)tempCrl.gettbsCertList().getnextUpdate().getValue()).getValue();
                        if (!tsSignTime.before(crlThisUp)) continue;
                        certWasValid = true;
                        continue;
                    }
                    if (DogrulamaLog.aktif) {
                        DogrulamaLog.logEkle("[x] Sertifika CRL kayd\u0131na g\u00f6re imza zaman\u0131ndan \u00f6nce iptal edilmi\u015f");
                    }
                    return 95;
                }
                if (!certWasValid) {
                    for (BasicOCSPResponse resp : ocspValsVec) {
                        Date respTime;
                        SingleResponse sinResp = (SingleResponse)resp.getTbsResponseData().getReponses().elementAt(0);
                        int certStatus = OCSPFabrikasi.getCertStatusFromSingleResponse(sinResp, certToCheck);
                        if (certStatus == 7) {
                            long resplong;
                            respTime = (Date)resp.getTbsResponseData().getProducedAt().getValue();
                            long tslong = tsSignTime.getTime();
                            if (tslong - 180000L >= (resplong = respTime.getTime())) continue;
                            certWasValid = true;
                            continue;
                        }
                        if (certStatus != 8 || !tsSignTime.after(respTime = (Date)resp.getTbsResponseData().getProducedAt().getValue())) continue;
                        if (DogrulamaLog.aktif) {
                            DogrulamaLog.logEkle("[x] Sertifika OCSP cevab\u0131na g\u00f6re imza zaman\u0131ndan \u00f6nce iptal edilmi\u015f");
                        }
                        return 95;
                    }
                }
                if (certWasValid) continue;
                if (DogrulamaLog.aktif) {
                    DogrulamaLog.logEkle("[x] Sertifika ge\u00e7erlilik referans\u0131 bulunamad\u0131");
                }
                return 96;
            }
            if (DogrulamaLog.aktif) {
                DogrulamaLog.logEkle("T\u00fcm sertifikalar i\u00e7in ge\u00e7erlilik kay\u0131tlar\u0131 bulundu ve do\u011fruland\u0131");
            }
            return 90;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return 91;
        }
    }

    public void adresTablosuYukle(Hashtable htAdresler) {
        this.adresTablosu = htAdresler;
    }

    public byte[] esArsivOlustur(byte[] escXLongBytes, byte[] ayrikImzadaOrijinalVeri, String zdSunucuAdresi, String zdKullaniciAdi, String zdParola) throws TimestampException {
        try {
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(escXLongBytes);
            if (!ci.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                this.esArsivHataBilgisi = 111;
                return null;
            }
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            Vector sinfoVec = (Vector)sd.getSignerInfos().getValue();
            SignerInfo sinfo = (SignerInfo)sinfoVec.elementAt(0);
            if (this.imzadanZamanDamgasiOku(escXLongBytes) == null) {
                this.esArsivHataBilgisi = 111;
                return null;
            }
            byte[] encapCinfoBytes = sd.getEncapContentInfo().getEncoded();
            int totalSize = encapCinfoBytes.length;
            if (ayrikImzadaOrijinalVeri != null) {
                totalSize += ayrikImzadaOrijinalVeri.length;
            }
            byte[] certificatesBytes = null;
            if (sd.getCertificates() != null && ((Vector)sd.getCertificates().getValue()).size() > 0) {
                certificatesBytes = sd.getCertificates().getEncoded();
                totalSize += certificatesBytes.length;
            }
            byte[] crlsBytes = null;
            if (sd.getCRLs() != null && ((Vector)sd.getCRLs().getValue()).size() > 0) {
                crlsBytes = sd.getCRLs().getEncoded();
                totalSize += crlsBytes.length;
            }
            byte[] sinfoContentBytes = sinfo.getContentEncoding();
            byte[] tsInputBytes = new byte[totalSize += sinfoContentBytes.length];
            System.arraycopy(encapCinfoBytes, 0, tsInputBytes, 0, encapCinfoBytes.length);
            int copiedSize = encapCinfoBytes.length;
            if (ayrikImzadaOrijinalVeri != null) {
                System.arraycopy(ayrikImzadaOrijinalVeri, 0, tsInputBytes, copiedSize, ayrikImzadaOrijinalVeri.length);
                copiedSize += ayrikImzadaOrijinalVeri.length;
            }
            if (certificatesBytes != null) {
                System.arraycopy(certificatesBytes, 0, tsInputBytes, copiedSize, certificatesBytes.length);
                copiedSize += certificatesBytes.length;
            }
            if (crlsBytes != null) {
                System.arraycopy(crlsBytes, 0, tsInputBytes, copiedSize, crlsBytes.length);
                copiedSize += crlsBytes.length;
            }
            System.arraycopy(sinfoContentBytes, 0, tsInputBytes, copiedSize, sinfoContentBytes.length);
            byte[] tsTokenBytes = this.zamanDamgasiOlustur(tsInputBytes, zdSunucuAdresi, false, false, -1, zdKullaniciAdi, zdParola);
            if (tsTokenBytes == null) {
                this.esArsivHataBilgisi = this.zdHataDurumu == 31 ? 112 : (this.zdHataDurumu == 32 ? 113 : 111);
                return null;
            }
            ContentInfo tstoken = new ContentInfo("tstoken");
            tstoken.decode(tsTokenBytes);
            byte[] tstSdBytes = (byte[])tstoken.getcontent().getValue();
            SignedData tstSd = new SignedData("tstSd");
            tstSd.setTaggingMethod(2);
            tstSd.setTagClass((byte)-128);
            tstSd.setTagNumber(0);
            tstSd.decode(tstSdBytes);
            Vector tstSinfoVec = (Vector)tstSd.getSignerInfos().getValue();
            SignerInfo tstSinfo = (SignerInfo)tstSinfoVec.elementAt(0);
            Certificate tsCert = TimestampFabrikasi.extractSignerCertFromTimeStampToken(tstSd);
            int zdDogrulamaSonuc = this.zdUzerindekiImzayiDogrula(tstSd);
            if (zdDogrulamaSonuc != 20) {
                this.esArsivHataBilgisi = zdDogrulamaSonuc == 24 ? 115 : 114;
                return null;
            }
            Vector sortedIssuersVec = UzunDonemliIslemler.sortCACerts(tsCert, this.sonDogrulamaZincir);
            if (sortedIssuersVec == null) {
                this.esArsivHataBilgisi = 115;
                return null;
            }
            Vector<Certificate> certsForRevRefsVec = new Vector<Certificate>();
            certsForRevRefsVec.addElement(tsCert);
            for (int k = sortedIssuersVec.size() - 1; k >= 0; --k) {
                certsForRevRefsVec.addElement((Certificate)sortedIssuersVec.elementAt(k));
            }
            Vector reverseSortedIssuersVec = new Vector();
            for (int m = sortedIssuersVec.size() - 1; m >= 0; --m) {
                reverseSortedIssuersVec.addElement(sortedIssuersVec.elementAt(m));
            }
            RevocationValues revValues = new RevocationValues("revValues");
            for (int i = 0; i < certsForRevRefsVec.size() - 1; ++i) {
                Certificate tempCert = (Certificate)certsForRevRefsVec.elementAt(i);
                String ocspAdres = UzunDonemliIslemler.ocspAdresiOku(tempCert);
                if (this.adresTablosu != null && (ocspAdres = (String)this.adresTablosu.get(ocspAdres)) == null) {
                    this.esArsivHataBilgisi = 116;
                    return null;
                }
                Vector ocspCevapVec = this.ocspSorgusuYapTumCevapGetir(tempCert, (Certificate)certsForRevRefsVec.elementAt(i + 1), ocspAdres, this.baglantiZamanAsimiSaniyesi);
                int sorguSonuc = (Integer)ocspCevapVec.elementAt(0);
                if (sorguSonuc == 69) {
                    byte[] ocspRespBytes = (byte[])ocspCevapVec.elementAt(1);
                    OCSPResponse tResp = new OCSPResponse("tResp");
                    tResp.decode(ocspRespBytes);
                    BasicOCSPResponse basicOCSPResp = new BasicOCSPResponse("basicOCSPResp");
                    basicOCSPResp.decode((byte[])tResp.getResponseBytes().getResponse().getValue());
                    revValues.addOCSPVal(basicOCSPResp);
                    continue;
                }
                if (sorguSonuc == 70) {
                    this.esArsivHataBilgisi = 117;
                    return null;
                }
                if (sorguSonuc == 71) {
                    this.esArsivHataBilgisi = 118;
                    return null;
                }
                SertifikaBilgiNesnesi sbn = new SertifikaBilgiNesnesi();
                sbn.sertifikaYukle(tsCert.getEncoded());
                String[] crlAdresler = sbn.sertifikaCRLDagitimNoktalariListesiAl();
                if (crlAdresler == null || crlAdresler.length == 0) {
                    this.esArsivHataBilgisi = 116;
                    return null;
                }
                String crlHttpAdres = null;
                for (int a = 0; a < crlAdresler.length; ++a) {
                    if (!crlAdresler[a].toLowerCase().startsWith("http")) continue;
                    crlHttpAdres = crlAdresler[a];
                }
                if (crlHttpAdres == null) {
                    this.esArsivHataBilgisi = 116;
                    return null;
                }
                if (this.adresTablosu != null && (crlHttpAdres = (String)this.adresTablosu.get(crlHttpAdres)) == null) {
                    this.esArsivHataBilgisi = 116;
                    return null;
                }
                boolean crlFound = false;
                try {
                    int oneChar;
                    URL url = new URL(crlHttpAdres);
                    URLConnection urlC = url.openConnection();
                    InputStream is = url.openStream();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    while ((oneChar = is.read()) != -1) {
                        baos.write(oneChar);
                    }
                    is.close();
                    baos.close();
                    byte[] crlBytes = baos.toByteArray();
                    CertificateList crl = new CertificateList("crl");
                    crl.decode(crlBytes);
                    if (!CRLFabrikasi.verifyCRL(crl, (Certificate)certsForRevRefsVec.elementAt(i + 1)) || !CRLFabrikasi.isCRLUptoDate(crl)) continue;
                    crlFound = true;
                    RevokedCertificate revcert = CRLFabrikasi.isCertificateInCRL(tempCert, crl);
                    if (revcert == null) {
                        revValues.addCRLVal(crl);
                        continue;
                    }
                    this.esArsivHataBilgisi = 117;
                    return null;
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    this.esArsivHataBilgisi = 116;
                    return null;
                }
            }
            CertificateValues certVals = new CertificateValues("certVals");
            for (Certificate tempCert : reverseSortedIssuersVec) {
                certVals.addElement(tempCert);
            }
            Attribute attCertificateVals = new Attribute("attCertificateVals");
            AttributeType attTypeCertificateVals = new AttributeType("attTypeCertificateVals");
            attTypeCertificateVals.setValue(CERTIFICATE_VALUES_ATTRIBUTE_OBJ_ID);
            SetOf attValsCertificateVals = new SetOf("attValsCertificateVals", new CertificateValues("ccvals"));
            attValsCertificateVals.addElement(certVals);
            attCertificateVals.settype(attTypeCertificateVals);
            attCertificateVals.setvalues(attValsCertificateVals);
            attCertificateVals.commitElementUpdate();
            Attribute attRevocationVals = new Attribute("attRevocationValss");
            AttributeType attTypeRevocationVals = new AttributeType("attTypeRevocationVals");
            attTypeRevocationVals.setValue(REVOCATION_VALUES_ATTRIBUTE_OBJ_ID);
            SetOf attValsRevocationVals = new SetOf("attValsRevocationVals", new RevocationValues("crevvals"));
            attValsRevocationVals.addElement(revValues);
            attRevocationVals.settype(attTypeRevocationVals);
            attRevocationVals.setvalues(attValsRevocationVals);
            attRevocationVals.commitElementUpdate();
            UnsignedAttributes tstUnsAtt = new UnsignedAttributes("tstUnsAtt");
            Vector tstExistingUnsAttVec = (Vector)tstSinfo.getUnsignedAttributes().getValue();
            if (tstExistingUnsAttVec != null && tstExistingUnsAttVec.size() > 0) {
                for (int i = 0; i < tstExistingUnsAttVec.size(); ++i) {
                    tstUnsAtt.addElement((Attribute)tstExistingUnsAttVec.elementAt(i));
                }
            }
            tstUnsAtt.addElement(attCertificateVals);
            tstUnsAtt.addElement(attRevocationVals);
            tstSinfo.setUnsignedAttributes(tstUnsAtt);
            tstSinfo.commitElementUpdate();
            SignerInfos tstSinfos = new SignerInfos("tstSinfos");
            tstSinfos.addElement(tstSinfo);
            tstSd.setSignerInfos(tstSinfos);
            tstSd.commitElementUpdate();
            ContentInfo ciTst = new ContentInfo("ciTst");
            ObjectID conTypeSignedDataObjId = new ObjectID("signedData", "1.2.840.113549.1.7.2");
            ciTst.setcontentType(conTypeSignedDataObjId);
            Any contTst = new Any("contSignedData", tstSd);
            ciTst.setcontent(contTst);
            ciTst.commitElementUpdate();
            Attribute attArchive = new Attribute("attArchive");
            AttributeType attTypeArchive = new AttributeType("attTypeArchive");
            attTypeArchive.setValue(ARCHIVE_TIMESTAMP_V2_ATTRIBUTE_OBJ_ID);
            SetOf attValsArchive = new SetOf("attValsRevocationVals", new ContentInfo("tstoken"));
            attValsArchive.addElement(ciTst);
            attArchive.settype(attTypeArchive);
            attArchive.setvalues(attValsArchive);
            attArchive.commitElementUpdate();
            UnsignedAttributes unsAtt = new UnsignedAttributes("unsAtt");
            Vector existingUnsAttVec = (Vector)sinfo.getUnsignedAttributes().getValue();
            if (existingUnsAttVec != null && existingUnsAttVec.size() > 0) {
                for (int i = 0; i < existingUnsAttVec.size(); ++i) {
                    unsAtt.addElement((Attribute)existingUnsAttVec.elementAt(i));
                }
            }
            unsAtt.addElement(attArchive);
            sinfo.setUnsignedAttributes(unsAtt);
            sinfo.commitElementUpdate();
            SignerInfos sinfos = new SignerInfos("sinfos");
            sinfos.addElement(sinfo);
            sd.setSignerInfos(sinfos);
            sd.commitElementUpdate();
            ContentInfo ciRes = new ContentInfo("ci");
            ciRes.setcontentType(conTypeSignedDataObjId);
            Any contSignedData = new Any("contSignedData", sd);
            ciRes.setcontent(contSignedData);
            ciRes.commitElementUpdate();
            this.esArsivHataBilgisi = 110;
            return ciRes.getEncoded();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public int esArsivOlusturmaHataBilgisiniAl() {
        return this.esArsivHataBilgisi;
    }

    public int esArsivDogrula(byte[] esArsivBytes, byte[] ayrikImzadaOrijinalVeri) {
        try {
            Certificate rootestCertInSet;
            int escXLongdsonuc = this.escXLongYapisiDogrula(esArsivBytes);
            if (escXLongdsonuc != 90) {
                return escXLongdsonuc;
            }
            CertificateValues certVals = this.extractCertificatesFromESCXLong(esArsivBytes);
            if (certVals == null) {
                return 133;
            }
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(esArsivBytes);
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            Vector sinfoVec = (Vector)sd.getSignerInfos().getValue();
            SignerInfo sinfo = (SignerInfo)sinfoVec.elementAt(0);
            SignedData[] tstokens = this.extractArchiveTSTBlocksFromSignerInfo(sinfo);
            if (tstokens == null) {
                return 131;
            }
            Arrays.sort(tstokens, new TSTokenComparator());
            Date toBeRemovedTokenDate = TimestampFabrikasi.getGenerationTimeOfTimestamp(tstokens[tstokens.length - 1]);
            if (!UzunDonemliIslemler.removeArchiveTSTBlockFromSignerInfo(sinfo, toBeRemovedTokenDate)) {
                return 132;
            }
            Vector tstokenVerifResVec = TimestampFabrikasi.verifyTimeStampToken(tstokens[tstokens.length - 1]);
            int tstokenVerif = (Integer)tstokenVerifResVec.elementAt(0);
            if (tstokenVerif != 0) {
                System.out.println("tstokenVerif = " + tstokenVerif);
                return 134;
            }
            MessageImprint mesimp = TimestampFabrikasi.getMessageImprintInTimestamp(tstokens[tstokens.length - 1]);
            byte[] hashFromToken = (byte[])mesimp.getHashedMessage().getValue();
            byte[] encapCinfoBytes = sd.getEncapContentInfo().getEncoded();
            int totalSize = encapCinfoBytes.length;
            if (ayrikImzadaOrijinalVeri != null) {
                totalSize += ayrikImzadaOrijinalVeri.length;
            }
            byte[] certificatesBytes = null;
            if (sd.getCertificates() != null && ((Vector)sd.getCertificates().getValue()).size() > 0) {
                certificatesBytes = sd.getCertificates().getEncoded();
                totalSize += certificatesBytes.length;
            }
            byte[] crlsBytes = null;
            if (sd.getCRLs() != null && ((Vector)sd.getCRLs().getValue()).size() > 0) {
                crlsBytes = sd.getCRLs().getEncoded();
                totalSize += crlsBytes.length;
            }
            byte[] sinfoContentBytes = sinfo.getContentEncoding();
            byte[] tsInputBytes = new byte[totalSize += sinfoContentBytes.length];
            System.arraycopy(encapCinfoBytes, 0, tsInputBytes, 0, encapCinfoBytes.length);
            int copiedSize = encapCinfoBytes.length;
            if (ayrikImzadaOrijinalVeri != null) {
                System.arraycopy(ayrikImzadaOrijinalVeri, 0, tsInputBytes, copiedSize, ayrikImzadaOrijinalVeri.length);
                copiedSize += ayrikImzadaOrijinalVeri.length;
            }
            if (certificatesBytes != null) {
                System.arraycopy(certificatesBytes, 0, tsInputBytes, copiedSize, certificatesBytes.length);
                copiedSize += certificatesBytes.length;
            }
            if (crlsBytes != null) {
                System.arraycopy(crlsBytes, 0, tsInputBytes, copiedSize, crlsBytes.length);
                copiedSize += crlsBytes.length;
            }
            System.arraycopy(sinfoContentBytes, 0, tsInputBytes, copiedSize, sinfoContentBytes.length);
            byte[] hashComputed = HashFabrikasi.hashAl(tsInputBytes, (String)mesimp.getHashAlgorithm().getalgorithm().getValue());
            if (!UzunDonemliIslemler.areByteArraysEqual(hashFromToken, hashComputed)) {
                return 136;
            }
            Certificate arsivZdCert = (Certificate)tstokenVerifResVec.elementAt(1);
            if (this.zdDogrulamaKokleri.size() == 0) {
                return 135;
            }
            boolean signerCertVerified = false;
            Vector certsInTst = (Vector)sd.getCertificates().getValue();
            boolean directParentInTrustList = false;
            Certificate directParent = null;
            for (int i = 0; i < this.zdDogrulamaKokleri.size(); ++i) {
                Certificate tempIssuer = (Certificate)this.zdDogrulamaKokleri.elementAt(i);
                if (!SertifikaFabrikasi.verifyCertificate(arsivZdCert, tempIssuer)) continue;
                directParentInTrustList = true;
                signerCertVerified = true;
                directParent = tempIssuer;
                break;
            }
            if (!directParentInTrustList && (rootestCertInSet = UzunDonemliIslemler.findRootestIssuerInSet(arsivZdCert, certsInTst)) != null && rootestCertInSet != arsivZdCert) {
                for (int j = 0; j < this.zdDogrulamaKokleri.size(); ++j) {
                    Certificate tempIssuer = (Certificate)this.zdDogrulamaKokleri.elementAt(j);
                    if (!SertifikaFabrikasi.verifyCertificate(rootestCertInSet, tempIssuer)) continue;
                    signerCertVerified = true;
                    break;
                }
            }
            if (signerCertVerified) {
                if (directParent == null) {
                    directParent = UzunDonemliIslemler.findIssuerInSet(arsivZdCert, certsInTst);
                }
                this.sonDogrulamaZincir = UzunDonemliIslemler.getHierarchyFromSet(directParent, this.zdDogrulamaKokleri);
                if (this.sonDogrulamaZincir == null || this.sonDogrulamaZincir.size() == 0) {
                    return 135;
                }
                return 130;
            }
            return 135;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return 132;
        }
    }

    public Date[] esArsivdenArsivZamanDamgalariniOku(byte[] esArsivBytes) {
        try {
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(esArsivBytes);
            if (!ci.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                return null;
            }
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            Vector sinfoVec = (Vector)sd.getSignerInfos().getValue();
            SignerInfo sinfo = (SignerInfo)sinfoVec.elementAt(0);
            SignedData[] tstokens = this.extractArchiveTSTBlocksFromSignerInfo(sinfo);
            if (tstokens != null) {
                Date[] res = new Date[tstokens.length];
                for (int i = 0; i < tstokens.length; ++i) {
                    res[i] = TimestampFabrikasi.getGenerationTimeOfTimestamp(tstokens[i]);
                }
                Arrays.sort(res, new DateComparator());
                return res;
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public String[] esArsivdenArsivZamanDamgasiImzaAlgoritmalariniOku(byte[] esArsivBytes) {
        try {
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(esArsivBytes);
            if (!ci.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                return null;
            }
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            Vector sinfoVec = (Vector)sd.getSignerInfos().getValue();
            SignerInfo sinfo = (SignerInfo)sinfoVec.elementAt(0);
            SignedData[] tstokens = this.extractArchiveTSTBlocksFromSignerInfo(sinfo);
            Arrays.sort(tstokens, new TSTokenComparator());
            if (tstokens != null) {
                String[] res = new String[tstokens.length];
                for (int i = 0; i < tstokens.length; ++i) {
                    res[i] = TimestampFabrikasi.getSignatureAlgorithmOfTimestamp(tstokens[i]);
                }
                return res;
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public String[] esArsivdenArsivZamanDamgasiOzetAlgoritmalariniOku(byte[] esArsivBytes) {
        try {
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(esArsivBytes);
            if (!ci.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                return null;
            }
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            Vector sinfoVec = (Vector)sd.getSignerInfos().getValue();
            SignerInfo sinfo = (SignerInfo)sinfoVec.elementAt(0);
            SignedData[] tstokens = this.extractArchiveTSTBlocksFromSignerInfo(sinfo);
            Arrays.sort(tstokens, new TSTokenComparator());
            if (tstokens != null) {
                String[] res = new String[tstokens.length];
                for (int i = 0; i < tstokens.length; ++i) {
                    res[i] = TimestampFabrikasi.getHashAlgorithmOfTimestamp(tstokens[i]);
                }
                return res;
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public byte[][] esArsivdenArsivZamanDamgasiSertifikalariniOku(byte[] esArsivBytes) {
        try {
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(esArsivBytes);
            if (!ci.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                return null;
            }
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            Vector sinfoVec = (Vector)sd.getSignerInfos().getValue();
            SignerInfo sinfo = (SignerInfo)sinfoVec.elementAt(0);
            SignedData[] tstokens = this.extractArchiveTSTBlocksFromSignerInfo(sinfo);
            if (tstokens != null) {
                Arrays.sort(tstokens, new TSTokenComparator());
                byte[][] res = new byte[tstokens.length][];
                for (int i = 0; i < tstokens.length; ++i) {
                    res[i] = TimestampFabrikasi.extractSignerCertFromTimeStampToken(tstokens[i]).getEncoded();
                }
                return res;
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public byte[] sertifikaOCSPSorgusuYapTumCevabiVer(byte[] sertifikaBytes) {
        try {
            Certificate cert = new Certificate("cert");
            cert.decode(sertifikaBytes);
            Certificate issuerCert = null;
            for (int i = 0; i < this.zdDogrulamaKokleri.size(); ++i) {
                if (!SertifikaFabrikasi.verifyCertificate(cert, (Certificate)this.zdDogrulamaKokleri.elementAt(i))) continue;
                issuerCert = (Certificate)this.zdDogrulamaKokleri.elementAt(i);
            }
            if (issuerCert == null) {
                this.ocspSonSorgudaHataKodu = 61;
                return null;
            }
            Vector sorguSonucVec = this.ocspSorgusuYapTumCevapGetir(cert, issuerCert, null, this.baglantiZamanAsimiSaniyesi);
            int sorguSonuc = (Integer)sorguSonucVec.elementAt(0);
            if (sorguSonuc == 69 || sorguSonuc == 70 || sorguSonuc == 71) {
                this.ocspSonSorgudaHataKodu = 72;
                if (sorguSonucVec.size() == 3) {
                    return OCSPFabrikasi.getBasicResponseFromResponse((byte[])sorguSonucVec.elementAt(1)).getEncoded();
                }
                if (sorguSonuc == 70) {
                    this.ocspSonSorgudaIptalNedeni = (Integer)sorguSonucVec.elementAt(1);
                    this.ocspSonSorgudaIptalTarihi = (Date)sorguSonucVec.elementAt(2);
                }
                return OCSPFabrikasi.getBasicResponseFromResponse((byte[])sorguSonucVec.elementAt(3)).getEncoded();
            }
            this.ocspSonSorgudaHataKodu = sorguSonuc;
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.ocspSonSorgudaHataKodu = 60;
            return null;
        }
    }

    public byte[] sertifikaOCSPSorgusuYapTumCevabiVer(byte[] sertifikaBytes, String ocspAdresi) {
        try {
            Certificate cert = new Certificate("cert");
            cert.decode(sertifikaBytes);
            Certificate issuerCert = null;
            for (int i = 0; i < this.zdDogrulamaKokleri.size(); ++i) {
                if (!SertifikaFabrikasi.verifyCertificate(cert, (Certificate)this.zdDogrulamaKokleri.elementAt(i))) continue;
                issuerCert = (Certificate)this.zdDogrulamaKokleri.elementAt(i);
            }
            if (issuerCert == null) {
                this.ocspSonSorgudaHataKodu = 61;
                return null;
            }
            Vector sorguSonucVec = this.ocspSorgusuYapTumCevapGetir(cert, issuerCert, ocspAdresi, this.baglantiZamanAsimiSaniyesi);
            int sorguSonuc = (Integer)sorguSonucVec.elementAt(0);
            if (sorguSonuc == 69 || sorguSonuc == 70 || sorguSonuc == 71) {
                this.ocspSonSorgudaHataKodu = 72;
                if (sorguSonucVec.size() == 3) {
                    return OCSPFabrikasi.getBasicResponseFromResponse((byte[])sorguSonucVec.elementAt(1)).getEncoded();
                }
                if (sorguSonuc == 70) {
                    this.ocspSonSorgudaIptalNedeni = (Integer)sorguSonucVec.elementAt(1);
                    this.ocspSonSorgudaIptalTarihi = (Date)sorguSonucVec.elementAt(2);
                }
                return OCSPFabrikasi.getBasicResponseFromResponse((byte[])sorguSonucVec.elementAt(3)).getEncoded();
            }
            this.ocspSonSorgudaHataKodu = sorguSonuc;
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.ocspSonSorgudaHataKodu = 60;
            return null;
        }
    }

    public int shsSertifikalariIcinCRLYukle(byte[] shsCrlDosyasiByteDizisi) {
        try {
            CertificateList crl = new CertificateList("crl");
            crl.decode(shsCrlDosyasiByteDizisi);
            this.kokCRLVec.addElement(crl);
            return 11;
        }
        catch (Exception exc) {
            return 12;
        }
    }

    public byte[] shsSertifikalariIcinAdrestenCRLYukle(String shsCrlAdresi) {
        try {
            URL kokCrlURL = new URL(shsCrlAdresi);
            HttpURLConnection conn = (HttpURLConnection)kokCrlURL.openConnection();
            conn.connect();
            BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
            byte[] buf = new byte[100];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(baos);
            int r = bis.read(buf);
            while (r != -1) {
                bos.write(buf, 0, r);
                r = bis.read(buf);
            }
            bis.close();
            bos.flush();
            byte[] crlBytes = baos.toByteArray();
            bos.close();
            this.shsSertifikalariIcinCRLYukle(crlBytes);
            return crlBytes;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public int imzadakiZamanDamgasiniDogrulaOCSPKullan(byte[] zamanDamgaliImza, byte[] ocspCevabi) {
        try {
            int basitDogrulamaSonuc = this.imzadakiZamanDamgasiniDogrula(zamanDamgaliImza);
            if (basitDogrulamaSonuc != 20) {
                return basitDogrulamaSonuc;
            }
            byte[] zdCertBytes = this.imzadakiZamanDamgasiSertifikasiniOku(zamanDamgaliImza);
            Certificate zdCert = new Certificate("zdCert");
            zdCert.decode(zdCertBytes);
            BasicOCSPResponse basicResp = new BasicOCSPResponse("basicResp");
            try {
                basicResp.decode(ocspCevabi);
            }
            catch (Exception dexc) {
                return 28;
            }
            if (OCSPFabrikasi.verifyBasicOCSPResponse(basicResp) != 0) {
                return 29;
            }
            Certificate ocspRespCert = OCSPFabrikasi.extractResponderCertFromBasicOCSPResponse(basicResp);
            Vector ocspZincir = UzunDonemliIslemler.getHierarchyFromSet(ocspRespCert, this.zdDogrulamaKokleri);
            if (ocspZincir.size() == 0) {
                return 111;
            }
            Date zdZamani = this.imzadanZamanDamgasiOku(zamanDamgaliImza);
            Date respTime = OCSPFabrikasi.getResponseTimeFromResponse(basicResp);
            if (respTime.compareTo(zdZamani) < 0) {
                return 112;
            }
            if (basicResp.getTbsResponseData().getReponses().size() == 0) {
                return 28;
            }
            SingleResponse singleResp = (SingleResponse)basicResp.getTbsResponseData().getReponses().elementAt(0);
            int certOcspStatus = OCSPFabrikasi.getCertStatusFromSingleResponse(singleResp, zdCert);
            if (certOcspStatus == 10) {
                return 113;
            }
            if (certOcspStatus == 9) {
                return 115;
            }
            if (certOcspStatus == 8) {
                RevokedInfo revInfo = singleResp.getCertStatus().getRevokedInfo();
                if (revInfo == null) {
                    return 114;
                }
                Date revokTime = (Date)revInfo.getRevocationTime().getValue();
                if (zdZamani.compareTo(revokTime) > 0) {
                    return 114;
                }
            }
            for (int i = 0; i < this.sonDogrulamaZincir.size() - 1; ++i) {
                boolean siradakiCRLBulundu = false;
                for (int y = 0; y < this.kokCRLVec.size(); ++y) {
                    if (!CRLFabrikasi.verifyCRL((CertificateList)this.kokCRLVec.elementAt(y), (Certificate)this.sonDogrulamaZincir.elementAt(i + 1))) continue;
                    Date crlStart = null;
                    try {
                        UTCTime crlstUTC = (UTCTime)((CertificateList)this.kokCRLVec.elementAt(y)).gettbsCertList().getthisUpdate().getValue();
                        crlStart = (Date)crlstUTC.getValue();
                    }
                    catch (ClassCastException ccexc) {
                        GeneralizedTime crlstGN = (GeneralizedTime)((CertificateList)this.kokCRLVec.elementAt(y)).gettbsCertList().getthisUpdate().getValue();
                        crlStart = (Date)crlstGN.getValue();
                    }
                    Date crlFinish = null;
                    try {
                        UTCTime crlfnUTC = (UTCTime)((CertificateList)this.kokCRLVec.elementAt(y)).gettbsCertList().getnextUpdate().getValue();
                        crlFinish = (Date)crlfnUTC.getValue();
                    }
                    catch (ClassCastException ccexc) {
                        GeneralizedTime crlfnGN = (GeneralizedTime)((CertificateList)this.kokCRLVec.elementAt(y)).gettbsCertList().getnextUpdate().getValue();
                        crlFinish = (Date)crlfnGN.getValue();
                    }
                    Certificate currentCACert = (Certificate)this.sonDogrulamaZincir.elementAt(i);
                    Date currentCAFinish = null;
                    try {
                        UTCTime utc = (UTCTime)currentCACert.gettbsCertificate().getvalidity().getnotAfter().getValue();
                        currentCAFinish = (Date)utc.getValue();
                    }
                    catch (ClassCastException ccexc) {
                        GeneralizedTime gtm = (GeneralizedTime)currentCACert.gettbsCertificate().getvalidity().getnotAfter().getValue();
                        currentCAFinish = (Date)gtm.getValue();
                    }
                    if (crlStart.compareTo(currentCAFinish) > 0 || crlFinish.compareTo(zdZamani) < 0) continue;
                    siradakiCRLBulundu = true;
                    if (CRLFabrikasi.isCertificateInCRL(currentCACert, (CertificateList)this.kokCRLVec.elementAt(y)) == null) break;
                    return 120;
                }
                if (siradakiCRLBulundu) continue;
                return 121;
            }
            return 20;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return 25;
        }
    }

    public int imzadakiZamanDamgasiniDogrulaCRLKullan(byte[] zamanDamgaliImza, byte[] crlByteDizisi) {
        try {
            GeneralizedTime crlstGN;
            UTCTime crlstUTC;
            int basitDogrulamaSonuc = this.imzadakiZamanDamgasiniDogrula(zamanDamgaliImza);
            if (basitDogrulamaSonuc != 20) {
                return basitDogrulamaSonuc;
            }
            byte[] zdCertBytes = this.imzadakiZamanDamgasiSertifikasiniOku(zamanDamgaliImza);
            Certificate zdCert = new Certificate("zdCert");
            zdCert.decode(zdCertBytes);
            Date zdZamani = this.imzadanZamanDamgasiOku(zamanDamgaliImza);
            Date certStart = null;
            try {
                UTCTime utc = (UTCTime)zdCert.gettbsCertificate().getvalidity().getnotBefore().getValue();
                certStart = (Date)utc.getValue();
            }
            catch (ClassCastException ccexc) {
                GeneralizedTime gtm = (GeneralizedTime)zdCert.gettbsCertificate().getvalidity().getnotBefore().getValue();
                certStart = (Date)gtm.getValue();
            }
            Date certFinish = null;
            try {
                UTCTime utc = (UTCTime)zdCert.gettbsCertificate().getvalidity().getnotAfter().getValue();
                certFinish = (Date)utc.getValue();
            }
            catch (ClassCastException ccexc) {
                GeneralizedTime gtm = (GeneralizedTime)zdCert.gettbsCertificate().getvalidity().getnotAfter().getValue();
                certFinish = (Date)gtm.getValue();
            }
            if (certStart.compareTo(zdZamani) > 0 || certFinish.compareTo(zdZamani) < 0) {
                return 81;
            }
            CertificateList crl = new CertificateList("crl");
            try {
                crl.decode(crlByteDizisi);
            }
            catch (Exception dexc) {
                return 116;
            }
            if (!CRLFabrikasi.verifyCRL(crl, (Certificate)this.sonDogrulamaZincir.elementAt(0))) {
                return 117;
            }
            Date signerCrlStart = null;
            Date signerCrlFinish = null;
            try {
                crlstUTC = (UTCTime)crl.gettbsCertList().getthisUpdate().getValue();
                signerCrlStart = (Date)crlstUTC.getValue();
            }
            catch (ClassCastException ccexc) {
                crlstGN = (GeneralizedTime)crl.gettbsCertList().getthisUpdate().getValue();
                signerCrlStart = (Date)crlstGN.getValue();
            }
            try {
                crlstUTC = (UTCTime)crl.gettbsCertList().getnextUpdate().getValue();
                signerCrlFinish = (Date)crlstUTC.getValue();
            }
            catch (ClassCastException ccexc) {
                crlstGN = (GeneralizedTime)crl.gettbsCertList().getthisUpdate().getValue();
                signerCrlFinish = (Date)crlstGN.getValue();
            }
            if (signerCrlFinish.compareTo(zdZamani) < 0) {
                return 118;
            }
            if (signerCrlStart.compareTo(certFinish) > 0) {
                return 118;
            }
            RevokedCertificate revCert = CRLFabrikasi.isCertificateInCRL(zdCert, crl);
            if (revCert != null) {
                Date revokTime = null;
                try {
                    revokTime = (Date)((UTCTime)revCert.getRevocationDate().getValue()).getValue();
                }
                catch (ClassCastException castExc) {
                    revokTime = (Date)((GeneralizedTime)revCert.getRevocationDate().getValue()).getValue();
                }
                if (zdZamani.compareTo(revokTime) > 0) {
                    return 119;
                }
            }
            for (int i = 0; i < this.sonDogrulamaZincir.size() - 1; ++i) {
                boolean siradakiCRLBulundu = false;
                for (int y = 0; y < this.kokCRLVec.size(); ++y) {
                    if (!CRLFabrikasi.verifyCRL((CertificateList)this.kokCRLVec.elementAt(y), (Certificate)this.sonDogrulamaZincir.elementAt(i + 1))) continue;
                    Date crlStart = null;
                    try {
                        UTCTime crlstUTC2 = (UTCTime)((CertificateList)this.kokCRLVec.elementAt(y)).gettbsCertList().getthisUpdate().getValue();
                        crlStart = (Date)crlstUTC2.getValue();
                    }
                    catch (ClassCastException ccexc) {
                        GeneralizedTime crlstGN2 = (GeneralizedTime)((CertificateList)this.kokCRLVec.elementAt(y)).gettbsCertList().getthisUpdate().getValue();
                        crlStart = (Date)crlstGN2.getValue();
                    }
                    Date crlFinish = null;
                    try {
                        UTCTime crlfnUTC = (UTCTime)((CertificateList)this.kokCRLVec.elementAt(y)).gettbsCertList().getnextUpdate().getValue();
                        crlFinish = (Date)crlfnUTC.getValue();
                    }
                    catch (ClassCastException ccexc) {
                        GeneralizedTime crlfnGN = (GeneralizedTime)((CertificateList)this.kokCRLVec.elementAt(y)).gettbsCertList().getnextUpdate().getValue();
                        crlFinish = (Date)crlfnGN.getValue();
                    }
                    Certificate currentCACert = (Certificate)this.sonDogrulamaZincir.elementAt(i);
                    Date currentCAFinish = null;
                    try {
                        UTCTime utc = (UTCTime)currentCACert.gettbsCertificate().getvalidity().getnotAfter().getValue();
                        currentCAFinish = (Date)utc.getValue();
                    }
                    catch (ClassCastException ccexc) {
                        GeneralizedTime gtm = (GeneralizedTime)currentCACert.gettbsCertificate().getvalidity().getnotAfter().getValue();
                        currentCAFinish = (Date)gtm.getValue();
                    }
                    if (crlStart.compareTo(currentCAFinish) > 0 || crlFinish.compareTo(zdZamani) < 0) continue;
                    siradakiCRLBulundu = true;
                    if (CRLFabrikasi.isCertificateInCRL(currentCACert, (CertificateList)this.kokCRLVec.elementAt(y)) == null) break;
                    return 120;
                }
                if (siradakiCRLBulundu) continue;
                return 121;
            }
            return 20;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return 25;
        }
    }

    public byte[] sertifikaKokCRLBaglanYukle(byte[] sertifikaBytes) {
        try {
            Certificate cert = new Certificate("cert");
            cert.decode(sertifikaBytes);
            Certificate shsCert = null;
            boolean verif = false;
            for (int i = 0; i < this.zdDogrulamaKokleri.size(); ++i) {
                verif = SertifikaFabrikasi.verifyCertificate(cert, (Certificate)this.zdDogrulamaKokleri.elementAt(i));
                if (!verif) continue;
                shsCert = (Certificate)this.zdDogrulamaKokleri.elementAt(i);
                break;
            }
            if (!verif) {
                return null;
            }
            Certificate certToGetAddress = null;
            certToGetAddress = SertifikaFabrikasi.verifyCertificate(shsCert, shsCert) ? cert : shsCert;
            String kokCrlAdres = null;
            Extensions exts = certToGetAddress.gettbsCertificate().getextensions();
            Extension crldpExt = exts.getExtensionByOID("2.5.29.31");
            if (crldpExt == null) {
                return null;
            }
            kokCrlAdres = crldpExt.getTurkishExplanation();
            URL kokCrlURL = new URL(kokCrlAdres);
            HttpURLConnection conn = (HttpURLConnection)kokCrlURL.openConnection();
            conn.connect();
            BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
            byte[] buf = new byte[100];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(baos);
            int r = bis.read(buf);
            while (r != -1) {
                bos.write(buf, 0, r);
                r = bis.read(buf);
            }
            bis.close();
            bos.flush();
            byte[] crlBytes = baos.toByteArray();
            bos.close();
            this.shsSertifikalariIcinCRLYukle(crlBytes);
            return crlBytes;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private SignerInfo extractLastSignerInfoFromSignedData(byte[] cinfoBytes) {
        try {
            ContentInfo ci = new ContentInfo("ci");
            ci.decode(cinfoBytes);
            if (!ci.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                return null;
            }
            byte[] sdBytes = (byte[])ci.getcontent().getValue();
            SignedData sd = new SignedData("sd");
            sd.setTaggingMethod(2);
            sd.setTagClass((byte)-128);
            sd.setTagNumber(0);
            sd.decode(sdBytes);
            int numCounterSignatures = ImzaIslemNesnesi.countCounterSignatures(cinfoBytes);
            if (numCounterSignatures == 0) {
                Vector sinfosVec = (Vector)sd.getSignerInfos().getValue();
                if (sinfosVec.size() == 0) {
                    return null;
                }
                return (SignerInfo)sinfosVec.elementAt(0);
            }
            Vector stripped = ImzaIslemNesnesi.removeLastCounterSignature(cinfoBytes);
            byte[] outerSinfoBytes = (byte[])stripped.elementAt(1);
            SignerInfo outerSinfo = new SignerInfo("outerSinfo");
            outerSinfo.decode(outerSinfoBytes);
            return outerSinfo;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private SignedData extractTSTSignedDataFromSignerInfo(SignerInfo sinfo) {
        try {
            UnsignedAttributes unsatts = sinfo.getUnsignedAttributes();
            Vector unsattsVec = (Vector)unsatts.getValue();
            if (unsattsVec == null || unsattsVec.size() == 0) {
                return null;
            }
            for (int i = 0; i < unsattsVec.size(); ++i) {
                Attribute att = (Attribute)unsattsVec.elementAt(i);
                if (!((String)att.gettype().getValue()).equals(SIGNATURE_TIMESTAMP_ATTRIBUTE_OBJ_ID)) continue;
                Any tstAttValAny = (Any)((Vector)att.getvalues().getValue()).elementAt(0);
                ContentInfo tstoken = new ContentInfo("tstoken");
                tstoken.decode((byte[])tstAttValAny.getValue());
                if (!tstoken.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                    return null;
                }
                byte[] tstSigDataBytes = (byte[])tstoken.getcontent().getValue();
                SignedData tstSigData = new SignedData("sd");
                tstSigData.setTaggingMethod(2);
                tstSigData.setTagClass((byte)-128);
                tstSigData.setTagNumber(0);
                tstSigData.decode(tstSigDataBytes);
                return tstSigData;
            }
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    private SignedData extractTSTSignedDataFromEST(byte[] estBytes) {
        try {
            SignerInfo lastSignerInfo = this.extractLastSignerInfoFromSignedData(estBytes);
            return this.extractTSTSignedDataFromSignerInfo(lastSignerInfo);
        }
        catch (Exception exc) {
            return null;
        }
    }

    private SignedData extractTSTSignedDataFromTSToken(byte[] tstokenBytes) {
        try {
            ContentInfo tstoken = new ContentInfo("tstoken");
            tstoken.decode(tstokenBytes);
            if (!tstoken.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                return null;
            }
            byte[] tstSigDataBytes = (byte[])tstoken.getcontent().getValue();
            SignedData tstSigData = new SignedData("sd");
            tstSigData.setTaggingMethod(2);
            tstSigData.setTagClass((byte)-128);
            tstSigData.setTagNumber(0);
            tstSigData.decode(tstSigDataBytes);
            return tstSigData;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private CompleteCertificateRefs extractCompleteCertRefsFromESC(byte[] escBytes) {
        try {
            SignerInfo lastSignerInfo = this.extractLastSignerInfoFromSignedData(escBytes);
            UnsignedAttributes unsatts = lastSignerInfo.getUnsignedAttributes();
            Vector unsattsVec = (Vector)unsatts.getValue();
            if (unsattsVec == null || unsattsVec.size() == 0) {
                return null;
            }
            for (int i = 0; i < unsattsVec.size(); ++i) {
                Attribute att = (Attribute)unsattsVec.elementAt(i);
                if (!((String)att.gettype().getValue()).equals(CERTIFICATE_REFS_ATTRIBUTE_OBJ_ID)) continue;
                Any ccRefsAttValAny = (Any)((Vector)att.getvalues().getValue()).elementAt(0);
                CompleteCertificateRefs ccrefs = new CompleteCertificateRefs("ccrefs");
                ccrefs.decode((byte[])ccRefsAttValAny.getValue());
                return ccrefs;
            }
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    private CompleteRevocationRefs extractCompleteRevRefsFromESC(byte[] escBytes) {
        try {
            SignerInfo lastSignerInfo = this.extractLastSignerInfoFromSignedData(escBytes);
            UnsignedAttributes unsatts = lastSignerInfo.getUnsignedAttributes();
            Vector unsattsVec = (Vector)unsatts.getValue();
            if (unsattsVec == null || unsattsVec.size() == 0) {
                return null;
            }
            for (int i = 0; i < unsattsVec.size(); ++i) {
                Attribute att = (Attribute)unsattsVec.elementAt(i);
                if (!((String)att.gettype().getValue()).equals(REVOCATION_REFS_ATTRIBUTE_OBJ_ID)) continue;
                Any crRefsAttValAny = (Any)((Vector)att.getvalues().getValue()).elementAt(0);
                CompleteRevocationRefs crrefs = new CompleteRevocationRefs("crrefs");
                crrefs.decode((byte[])crRefsAttValAny.getValue());
                return crrefs;
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private CertificateValues extractCertificatesFromESCXLong(byte[] escXLongBytes) {
        try {
            SignerInfo lastSignerInfo = this.extractLastSignerInfoFromSignedData(escXLongBytes);
            UnsignedAttributes unsatts = lastSignerInfo.getUnsignedAttributes();
            Vector unsattsVec = (Vector)unsatts.getValue();
            if (unsattsVec == null || unsattsVec.size() == 0) {
                return null;
            }
            for (int i = 0; i < unsattsVec.size(); ++i) {
                Attribute att = (Attribute)unsattsVec.elementAt(i);
                if (!((String)att.gettype().getValue()).equals(CERTIFICATE_VALUES_ATTRIBUTE_OBJ_ID)) continue;
                Any certValsAttValAny = (Any)((Vector)att.getvalues().getValue()).elementAt(0);
                CertificateValues certVals = new CertificateValues("crrefs");
                certVals.decode((byte[])certValsAttValAny.getValue());
                return certVals;
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private RevocationValues extractRevocationValuesFromESCXLong(byte[] escXLongBytes) {
        try {
            SignerInfo lastSignerInfo = this.extractLastSignerInfoFromSignedData(escXLongBytes);
            UnsignedAttributes unsatts = lastSignerInfo.getUnsignedAttributes();
            Vector unsattsVec = (Vector)unsatts.getValue();
            if (unsattsVec == null || unsattsVec.size() == 0) {
                return null;
            }
            for (int i = 0; i < unsattsVec.size(); ++i) {
                Attribute att = (Attribute)unsattsVec.elementAt(i);
                if (!((String)att.gettype().getValue()).equals(REVOCATION_VALUES_ATTRIBUTE_OBJ_ID)) continue;
                Any revValsAttValAny = (Any)((Vector)att.getvalues().getValue()).elementAt(0);
                RevocationValues revVals = new RevocationValues("revVals");
                revVals.decode((byte[])revValsAttValAny.getValue());
                return revVals;
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private SignedData[] extractArchiveTSTBlocksFromSignerInfo(SignerInfo sinfo) {
        try {
            UnsignedAttributes unsatts = sinfo.getUnsignedAttributes();
            Vector unsattsVec = (Vector)unsatts.getValue();
            if (unsattsVec == null || unsattsVec.size() == 0) {
                return null;
            }
            Vector<SignedData> sdvec = new Vector<SignedData>();
            for (int i = 0; i < unsattsVec.size(); ++i) {
                Attribute att = (Attribute)unsattsVec.elementAt(i);
                if (!((String)att.gettype().getValue()).equals(ARCHIVE_TIMESTAMP_V2_ATTRIBUTE_OBJ_ID)) continue;
                Any tstAttValAny = (Any)((Vector)att.getvalues().getValue()).elementAt(0);
                ContentInfo tstoken = new ContentInfo("tstoken");
                tstoken.decode((byte[])tstAttValAny.getValue());
                if (!tstoken.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                    return null;
                }
                byte[] tstSigDataBytes = (byte[])tstoken.getcontent().getValue();
                SignedData tstSigData = new SignedData("sd");
                tstSigData.setTaggingMethod(2);
                tstSigData.setTagClass((byte)-128);
                tstSigData.setTagNumber(0);
                tstSigData.decode(tstSigDataBytes);
                sdvec.addElement(tstSigData);
            }
            if (sdvec.size() > 0) {
                Object[] sdarr = new SignedData[sdvec.size()];
                sdvec.copyInto(sdarr);
                return sdarr;
            }
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    private static boolean removeArchiveTSTBlockFromSignerInfo(SignerInfo sinfo, Date toBeRemovedTSTDate) {
        try {
            UnsignedAttributes unsatts = sinfo.getUnsignedAttributes();
            Vector unsattsVec = (Vector)unsatts.getValue();
            if (unsattsVec == null || unsattsVec.size() == 0) {
                return false;
            }
            Vector<Attribute> editedUnsAttsVec = new Vector<Attribute>();
            for (int i = 0; i < unsattsVec.size(); ++i) {
                Attribute att = (Attribute)unsattsVec.elementAt(i);
                if (((String)att.gettype().getValue()).equals(ARCHIVE_TIMESTAMP_V2_ATTRIBUTE_OBJ_ID)) {
                    Any tstAttValAny = (Any)((Vector)att.getvalues().getValue()).elementAt(0);
                    ContentInfo tstoken = new ContentInfo("tstoken");
                    tstoken.decode((byte[])tstAttValAny.getValue());
                    if (!tstoken.getcontentType().getValue().equals("1.2.840.113549.1.7.2")) {
                        return false;
                    }
                    byte[] tstSigDataBytes = (byte[])tstoken.getcontent().getValue();
                    SignedData tstSigData = new SignedData("sd");
                    tstSigData.setTaggingMethod(2);
                    tstSigData.setTagClass((byte)-128);
                    tstSigData.setTagNumber(0);
                    tstSigData.decode(tstSigDataBytes);
                    Date tstDate = TimestampFabrikasi.getGenerationTimeOfTimestamp(tstSigData);
                    if (toBeRemovedTSTDate.equals(tstDate)) continue;
                    editedUnsAttsVec.addElement(att);
                    continue;
                }
                editedUnsAttsVec.addElement(att);
            }
            UnsignedAttributes editedUnsAtts = new UnsignedAttributes();
            editedUnsAtts.setValue(editedUnsAttsVec);
            sinfo.setUnsignedAttributes(editedUnsAtts);
            sinfo.commitElementUpdate();
            return true;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
    }

    private static Certificate findRootestIssuerInSet(Certificate leafCert, Vector certSet) {
        if (certSet == null) {
            return null;
        }
        if (certSet.size() == 0) {
            return null;
        }
        boolean leafInSet = false;
        for (int i = 0; i < certSet.size(); ++i) {
            Certificate tempCert = (Certificate)certSet.elementAt(i);
            if (leafCert.gettbsCertificate().getsubject().isEqualTo(tempCert.gettbsCertificate().getsubject())) {
                if (SertifikaFabrikasi.verifyCertificate(leafCert, tempCert)) {
                    if (UzunDonemliIslemler.areByteArraysEqual(leafCert.getEncoded(), tempCert.getEncoded())) {
                        return leafCert;
                    }
                } else if (UzunDonemliIslemler.areByteArraysEqual(leafCert.getEncoded(), tempCert.getEncoded())) {
                    leafInSet = true;
                }
            }
            if (!leafCert.gettbsCertificate().getissuer().isEqualTo(tempCert.gettbsCertificate().getsubject()) || !SertifikaFabrikasi.verifyCertificate(leafCert, tempCert)) continue;
            return UzunDonemliIslemler.findRootestIssuerInSet(tempCert, certSet);
        }
        if (leafInSet) {
            return leafCert;
        }
        return null;
    }

    private static Vector sortCACerts(Certificate signerCert, Vector caCerts) {
        try {
            Certificate rootIss = UzunDonemliIslemler.findRootestIssuerInSet(signerCert, caCerts);
            if (!SertifikaFabrikasi.verifyCertificate(rootIss, rootIss)) {
                return null;
            }
            Vector<Certificate> resultVec = new Vector<Certificate>();
            resultVec.addElement(rootIss);
            Certificate directIssCandidate = rootIss;
            Vector activeSearchVec = (Vector)caCerts.clone();
            boolean finished = false;
            while (!finished) {
                if (SertifikaFabrikasi.verifyCertificate(signerCert, directIssCandidate)) {
                    return resultVec;
                }
                if (activeSearchVec.size() == 1) {
                    return null;
                }
                activeSearchVec.remove(directIssCandidate);
                directIssCandidate = UzunDonemliIslemler.findRootestIssuerInSet(signerCert, activeSearchVec);
                if (directIssCandidate == null) {
                    return null;
                }
                resultVec.addElement(directIssCandidate);
            }
            return null;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static String ocspAdresiOku(Certificate sertifika) {
        try {
            Extensions exts = sertifika.gettbsCertificate().getextensions();
            Extension authInfoExt = exts.getExtensionByOID("1.3.6.1.5.5.7.1.1");
            if (authInfoExt == null) {
                return null;
            }
            String adres = null;
            AuthorityInfoAccessSyntax aias = new AuthorityInfoAccessSyntax();
            aias.decodeExtVal((byte[])authInfoExt.getextnValue().getValue());
            Vector vecAccess = aias.getAccessDescriptions();
            for (int i = 0; i < vecAccess.size(); ++i) {
                AccessDescription acDesc = (AccessDescription)vecAccess.elementAt(i);
                if (!((String)acDesc.getAccessMethod().getValue()).equals("1.3.6.1.5.5.7.48.1")) continue;
                adres = acDesc.getAccessLocation().getURI();
            }
            return adres;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private Vector ocspSorgusuYapTumCevapGetir(Certificate sorgulanacakSertifika, Certificate kokSertifika, String ocspAdresi, int timeoutSeconds) {
        Vector<Object> resultVec = new Vector<Object>();
        try {
            Extensions exts = sorgulanacakSertifika.gettbsCertificate().getextensions();
            Extension authInfoExt = exts.getExtensionByOID("1.3.6.1.5.5.7.1.1");
            if (authInfoExt == null) {
                resultVec.addElement(new Integer(62));
                return resultVec;
            }
            String adres = null;
            if (ocspAdresi == null) {
                AuthorityInfoAccessSyntax aias = new AuthorityInfoAccessSyntax();
                aias.decodeExtVal((byte[])authInfoExt.getextnValue().getValue());
                Vector vecAccess = aias.getAccessDescriptions();
                for (int i = 0; i < vecAccess.size(); ++i) {
                    AccessDescription acDesc = (AccessDescription)vecAccess.elementAt(i);
                    if (!((String)acDesc.getAccessMethod().getValue()).equals("1.3.6.1.5.5.7.48.1")) continue;
                    adres = acDesc.getAccessLocation().getURI();
                }
                if (adres == null) {
                    resultVec.addElement(new Integer(62));
                    return resultVec;
                }
            } else {
                adres = ocspAdresi;
            }
            Vector sonucVec = OCSPFabrikasi.queryUsingOCSP(sorgulanacakSertifika, kokSertifika, adres, timeoutSeconds, this.ocspHashAlgoritmasi);
            int sorguSonuc = (Integer)sonucVec.elementAt(0);
            switch (sorguSonuc) {
                case 5: {
                    resultVec.addElement(new Integer(63));
                    return resultVec;
                }
                case 6: {
                    resultVec.addElement(new Integer(64));
                    return resultVec;
                }
                case 2: {
                    resultVec.addElement(new Integer(65));
                    return resultVec;
                }
                case 1: {
                    resultVec.addElement(new Integer(66));
                    return resultVec;
                }
                case 3: {
                    resultVec.addElement(new Integer(67));
                    return resultVec;
                }
                case 4: {
                    resultVec.addElement(new Integer(68));
                    return resultVec;
                }
                case 7: {
                    resultVec.addElement(new Integer(69));
                    resultVec.addElement((byte[])sonucVec.elementAt(1));
                    resultVec.addElement((Date)sonucVec.elementAt(2));
                    return resultVec;
                }
                case 9: {
                    resultVec.addElement(new Integer(71));
                    resultVec.addElement((byte[])sonucVec.elementAt(1));
                    resultVec.addElement((Date)sonucVec.elementAt(2));
                    return resultVec;
                }
                case 8: {
                    resultVec.addElement(new Integer(70));
                    if (sonucVec.size() == 5) {
                        resultVec.addElement((Integer)sonucVec.elementAt(1));
                        resultVec.addElement((Date)sonucVec.elementAt(2));
                        resultVec.addElement((byte[])sonucVec.elementAt(3));
                        resultVec.addElement((Date)sonucVec.elementAt(4));
                    } else {
                        resultVec.addElement((byte[])sonucVec.elementAt(1));
                        resultVec.addElement((Date)sonucVec.elementAt(2));
                    }
                    return resultVec;
                }
            }
            resultVec.addElement(new Integer(65));
            return resultVec;
        }
        catch (Exception exc) {
            resultVec.addElement(new Integer(60));
            return resultVec;
        }
    }

    private static boolean areByteArraysEqual(byte[] bar1, byte[] bar2) {
        if (bar1.length != bar2.length) {
            return false;
        }
        for (int i = 0; i < bar1.length; ++i) {
            if (bar1[i] == bar2[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] convertFromIndefiniteLengthBERToDER(byte[] input) {
        try {
            byte[] lengthOctets;
            if (input.length < 5) {
                return null;
            }
            int len = input.length - 4;
            if (len < 128) {
                lengthOctets = new byte[]{(byte)len};
            } else {
                byte[] tmp;
                String ls = Integer.toString(len);
                BigInteger bi = new BigInteger(ls);
                lengthOctets = bi.toByteArray();
                if (lengthOctets[0] == 0) {
                    tmp = new byte[lengthOctets.length - 1];
                    System.arraycopy(lengthOctets, 1, tmp, 0, tmp.length);
                    lengthOctets = tmp;
                }
                tmp = new byte[lengthOctets.length + 1];
                tmp[0] = (byte)(0x80 | lengthOctets.length);
                System.arraycopy(lengthOctets, 0, tmp, 1, lengthOctets.length);
                lengthOctets = tmp;
            }
            byte[] result = new byte[1 + lengthOctets.length + len];
            result[0] = 48;
            System.arraycopy(lengthOctets, 0, result, 1, lengthOctets.length);
            System.arraycopy(input, 2, result, 1 + lengthOctets.length, len);
            return result;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }
}

