/*
 * Decompiled with CFR 0.152.
 */
package com.turktrust.asn1;

import com.turktrust.asn1.ASN1Integer;
import com.turktrust.asn1.ASN1Object;
import com.turktrust.asn1.BaseASN1Object;
import com.turktrust.asn1.DecodeException;
import com.turktrust.asn1.IA5String;
import com.turktrust.asn1.ObjectID;
import com.turktrust.asn1.OctetString;
import com.turktrust.asn1.PrintableString;
import com.turktrust.asn1.UTCTime;

public class Any
extends BaseASN1Object {
    private byte[] value;
    private BaseASN1Object givenObject;

    public Any() {
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(0);
        this.setTagNumber(0);
    }

    public Any(String name) {
        super(name);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(0);
        this.setTagNumber(0);
    }

    public Any(String name, Object value) {
        super(name, value);
        this.setTagClass((byte)0);
        this.setTaggingMethod(0);
        this.setType(0);
        this.setTagNumber(0);
        if (value instanceof byte[] || value instanceof ASN1Object) {
            this.setValue(value);
        }
    }

    public void setValue(Object value) {
        if (value instanceof byte[]) {
            this.value = (byte[])value;
            return;
        }
        if (value instanceof ASN1Object) {
            this.value = ((ASN1Object)value).getEncoded();
            this.givenObject = (BaseASN1Object)value;
            this.constructed = this.givenObject.isConstructed();
            this.optional = this.givenObject.isOptional();
            this.tagClass = this.givenObject.getTagClass();
            this.tagMethod = this.givenObject.getTaggingMethod();
            this.type = this.givenObject.getType();
            this.forcedTagMethod = this.givenObject.getForcedTagMethod();
            this.internalTagMethod = this.givenObject.getInternalTagMethod();
            return;
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void decode(byte[] data) {
        this.setValue(data);
    }

    public byte[] getEncoded() {
        if (this.givenObject == null) {
            return this.value;
        }
        return this.givenObject.getEncoded();
    }

    public byte[] getContentEncoding() {
        return this.givenObject.getContentEncoding();
    }

    public ASN1Object getRealObject() throws InstantiationException, DecodeException {
        byte tag = this.value[0];
        if ((tag & 0x20) != 0) {
            throw new InstantiationException("The object is\tconstructed, cannot determine real type");
        }
        if ((tag & 0xFFFFFFC0) != 0) {
            throw new InstantiationException("The object is\timplicitly tagged, cannot determine real type");
        }
        tag = (byte)(tag & 0x1F);
        BaseASN1Object obj = null;
        switch (tag) {
            case 2: {
                obj = new ASN1Integer(this.getName());
                break;
            }
            case 4: {
                obj = new OctetString(this.getName());
                break;
            }
            case 6: {
                obj = new ObjectID(this.getName());
                break;
            }
            case 19: {
                obj = new PrintableString(this.getName());
                break;
            }
            case 22: {
                obj = new IA5String(this.getName());
                break;
            }
            case 23: {
                obj = new UTCTime(this.getName());
            }
        }
        if (obj == null) {
            throw new InstantiationException("cannot determine real type");
        }
        obj.decode(this.value);
        return obj;
    }

    public BaseASN1Object getGivenObject() {
        return this.givenObject;
    }

    public void decodeInto(ASN1Object obj) throws DecodeException {
        obj.decode(this.value);
    }

    public String toString() {
        String x = new String("Any [" + this.getName() + "]:\n");
        if (this.value == null) {
            return x;
        }
        for (int i = 0; i < this.value.length; ++i) {
            int j = this.value[i] & 0xFF;
            String hd = null;
            hd = j < 16 ? new String("0" + Integer.toString(j, 16) + " ") : new String(Integer.toString(j, 16) + " ");
            x = x.concat(hd);
            if ((i + 1) % 8 == 0) {
                x = x.concat(" ");
            }
            if ((i + 1) % 16 != 0) continue;
            x = x.concat("\n");
        }
        return x;
    }
}

